/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import appeng.me.Grid;
import appeng.tile.networking.TileController;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.CraftingDebugHelper;
import com.asdflj.ae2thing.api.LimitedSizeLinkedList;
import com.asdflj.ae2thing.network.SPacketCraftingDebugCardUpdate;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CraftingDebugCardObject {
    private final NBTTagCompound data;
    private Mode currentMode;

    public CraftingDebugCardObject(ItemStack itemStack) {
        this.data = Platform.openNbtData((ItemStack)itemStack);
        this.currentMode = Mode.values()[this.data.func_74771_c("debug_card_mode")];
    }

    public Mode getMode() {
        return this.currentMode;
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
        this.data.func_74774_a("debug_card_mode", (byte)mode.ordinal());
    }

    public Mode getNextMode() {
        return Mode.values()[(this.getMode().ordinal() + 1) % Mode.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendMessageToPlayer(long networkID, Mode mode) {
        LimitedSizeLinkedList<CraftingDebugHelper.CraftingInfo> infos = AE2ThingAPI.instance().getHistory(networkID);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (infos.isEmpty()) {
            player.func_146105_b((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.no_history", (Object[])new Object[0])));
            return;
        }
        List<String> text = CraftingDebugCardObject.getHistoryText(infos, mode);
        if (!text.isEmpty()) {
            for (String s : text) {
                player.func_146105_b((IChatComponent)new ChatComponentText(s));
            }
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.no_history", (Object[])new Object[0])));
        }
    }

    public void sendRecordToPlayer(Grid grid, EntityPlayer player) {
        if (grid == null) {
            return;
        }
        long id = AE2ThingAPI.instance().getStorageMyID(grid);
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            AE2Thing.proxy.netHandler.sendTo(new SPacketCraftingDebugCardUpdate(id, AE2ThingAPI.instance().getHistory(grid), this.getMode()), (EntityPlayerMP)player);
        } else {
            CraftingDebugCardObject.sendMessageToPlayer(id, this.getMode());
            AE2ThingAPI.instance().saveHistory();
        }
    }

    public Grid getGrid(TileController tc) {
        try {
            return (Grid)tc.getProxy().getGrid();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static List<String> getHistoryText(LimitedSizeLinkedList<CraftingDebugHelper.CraftingInfo> history, Mode mode) {
        ArrayList<String> msg = new ArrayList<String>();
        if (history.isEmpty()) {
            return msg;
        }
        for (CraftingDebugHelper.CraftingInfo info : history) {
            if (mode == Mode.Player && !info.isPlayer || mode == Mode.Machine && info.isPlayer) continue;
            msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.network_id", (Object[])new Object[0]) + info.getNetworkID());
            msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.request_type", (Object[])new Object[0]) + I18n.func_135052_a((String)(info.isPlayer ? "ae2thing.message.crafting_debug_card.request_type.player" : "ae2thing.message.crafting_debug_card.request_type.machine"), (Object[])new Object[0]));
            if (!info.isPlayer && info.pos != null) {
                msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.pos", (Object[])new Object[]{info.pos.x, info.pos.y, info.pos.z, info.pos.getDimension()}));
            }
            msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.name", (Object[])new Object[0]) + info.name);
            msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.start_time", (Object[])new Object[0]) + info.getFormatStartTime());
            if (info.isFinish()) {
                msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.usage_time", (Object[])new Object[0]) + info.getUsageTime());
            }
            switch (info.getState()) {
                case FINISHED: {
                    msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.state", (Object[])new Object[0]) + I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.finish", (Object[])new Object[0]));
                    break;
                }
                case CANCELLED: {
                    msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.state", (Object[])new Object[0]) + I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.cancel", (Object[])new Object[0]));
                    break;
                }
                case RUNNING: {
                    msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.state", (Object[])new Object[0]) + I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.running", (Object[])new Object[0]));
                }
            }
            if (!info.getErrorMessage().isEmpty()) {
                msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.error_message", (Object[])new Object[]{info.getErrorMessage()}));
            }
            if (info.isSimulation()) {
                msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.simulation", (Object[])new Object[0]));
            }
            msg.add(I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.stack", (Object[])new Object[]{info.itemName, ReadableNumberConverter.INSTANCE.toWideReadableForm(info.requestSize)}));
            msg.add("------------------------------------------------");
        }
        if (!msg.isEmpty()) {
            msg.add(0, "------------------------------------------------");
        }
        return msg;
    }

    public static enum Mode {
        Everything,
        Player,
        Machine;

    }
}

