/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.Grid;
import appeng.util.ReadableNumberConverter;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.CraftingDebugHelper;
import com.asdflj.ae2thing.api.IAE2ThingAPI;
import com.asdflj.ae2thing.api.IBackpackItem;
import com.asdflj.ae2thing.api.LimitedSizeLinkedList;
import com.asdflj.ae2thing.api.Pinned;
import com.asdflj.ae2thing.api.Terminal;
import com.asdflj.ae2thing.client.event.NotificationEvent;
import com.asdflj.ae2thing.common.Config;
import com.asdflj.ae2thing.common.fluids.Mana;
import com.asdflj.ae2thing.common.storage.StorageManager;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.nei.NEI_TH_Config;
import com.asdflj.ae2thing.network.CPacketFindCellItem;
import com.asdflj.ae2thing.network.CPacketSwitchGuis;
import com.asdflj.ae2thing.util.Ae2Reflect;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public final class AE2ThingAPI
implements IAE2ThingAPI {
    public static final ItemStack BUCKET = new ItemStack(Items.field_151133_ar, 1);
    public static final ItemStack PHIAL = AE2ThingAPI.createEmptyPhial();
    public static final ItemStack GLASS_BOTTLE = new ItemStack(Items.field_151069_bo, 1);
    public static int maxSelectionRows = 5;
    private static final Fluid mana = new Mana();
    private static final AE2ThingAPI API = new AE2ThingAPI();
    public static final int CRAFTING_HISTORY_SIZE = Config.craftingHistorySize;
    private static final Set<Class<? extends Item>> backpackItems = new HashSet<Class<? extends Item>>();
    private StorageManager storageManager = null;
    private static ItemStack fluidContainer = BUCKET;
    public static final ReadableNumberConverter readableNumber = ReadableNumberConverter.INSTANCE;

    public static AE2ThingAPI instance() {
        return API;
    }

    private static ItemStack createEmptyPhial() {
        if (ModAndClassUtil.THE) {
            return AspectUtil.HELPER.createEmptyPhial();
        }
        return null;
    }

    public Terminal terminal() {
        return Terminal.API;
    }

    @Override
    public boolean isBlacklistedInStorage(Item item) {
        if (item instanceof IBackpackItem) {
            return true;
        }
        for (Class<? extends Item> cls : backpackItems) {
            if (!cls.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void blacklistItemInStorage(Class<? extends Item> item) {
        backpackItems.add(item);
    }

    @Override
    public void addBackpackItem(Class<? extends Item> item) {
        this.blacklistItemInStorage(item);
    }

    @Override
    public boolean isBackpackItem(Item item) {
        return this.isBlacklistedInStorage(item);
    }

    @Override
    public boolean isBackpackItem(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && this.isBackpackItem(itemStack.func_77973_b());
    }

    @Override
    public IInventory getBackpackInv(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        Item item = is.func_77973_b();
        if (item instanceof IBackpackItem) {
            IBackpackItem ibi = (IBackpackItem)item;
            return ibi.getInventory(is);
        }
        return null;
    }

    @Override
    public boolean isBackpackItemInv(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return false;
        }
        return is.func_77973_b() instanceof IBackpackItem;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void setStorageManager(StorageManager manager) {
        this.storageManager = manager;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pinned getPinned() {
        return Pinned.INSTANCE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openBackpackTerminal() {
        AE2Thing.proxy.netHandler.sendToServer(new CPacketSwitchGuis(GuiType.BACKPACK_TERMINAL));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openDualinterfaceTerminal() {
        AE2Thing.proxy.netHandler.sendToServer(new CPacketSwitchGuis(GuiType.WIRELESS_DUAL_INTERFACE_TERMINAL));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openTerminalMenu() {
        AE2Thing.proxy.netHandler.sendToServer(new CPacketSwitchGuis(GuiType.TERMINAL_MENU));
    }

    @Override
    public ItemStack getFluidContainer(IAEFluidStack fluid) {
        return this.getFluidContainer(fluid.getFluidStack());
    }

    @Override
    public ItemStack getFluidContainer(FluidStack fluid) {
        if (ModAndClassUtil.THE && AspectUtil.isEssentiaGas((FluidStack)fluid)) {
            return PHIAL;
        }
        if (this.canFillContainer(BUCKET, fluid)) {
            return BUCKET;
        }
        if (this.getDefaultFluidContainer() != BUCKET && this.canFillContainer(this.getDefaultFluidContainer(), fluid)) {
            return this.getDefaultFluidContainer();
        }
        return GLASS_BOTTLE;
    }

    @Override
    public void setDefaultFluidContainer(ItemStack item) {
        fluidContainer = item;
    }

    @Override
    public ItemStack getDefaultFluidContainer() {
        return fluidContainer;
    }

    private boolean canFillContainer(ItemStack is, FluidStack fluidStack) {
        MutablePair result = Util.FluidUtil.fillStack((ItemStack)is, (FluidStack)fluidStack);
        return result != null && (Integer)result.left != 0;
    }

    @Override
    public String getVersion() {
        return "v1.2.4";
    }

    @Override
    public Fluid getMana() {
        return mana;
    }

    @Override
    public void findCellItem(ItemStack item) {
        AE2Thing.proxy.netHandler.sendToServer(new CPacketFindCellItem(item));
    }

    @Override
    public long getStorageMyID(Grid grid) {
        return Ae2Reflect.getMyStorage(grid).getID();
    }

    @Override
    public LimitedSizeLinkedList<CraftingDebugHelper.CraftingInfo> getHistory(Grid grid) {
        return CraftingDebugHelper.getHistory().getOrDefault(this.getStorageMyID(grid), new LimitedSizeLinkedList());
    }

    @Override
    public LimitedSizeLinkedList<CraftingDebugHelper.CraftingInfo> getHistory(long networkID) {
        return CraftingDebugHelper.getHistory().getOrDefault(networkID, new LimitedSizeLinkedList());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void pushHistory(long networkID, LimitedSizeLinkedList<CraftingDebugHelper.CraftingInfo> infos) {
        CraftingDebugHelper.getHistory().clear();
        CraftingDebugHelper.getHistory().put(networkID, infos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveHistory() {
        if (CraftingDebugHelper.getHistory().isEmpty()) {
            return;
        }
        String json = CraftingDebugHelper.getGson().toJson(CraftingDebugHelper.getHistory());
        File file = new File((File)FMLInjectionData.data()[6], "history.json");
        try (FileWriter writer = new FileWriter(file);){
            writer.write(json);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            player.func_146105_b((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"ae2thing.crafting_debug_card.export_file", (Object[])new Object[]{"history.json"})));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCraftingCompleteNotification(IAEItemStack item) {
        if (NEI_TH_Config.getConfigValue("ae2thing.crafting_notification")) {
            MinecraftForge.EVENT_BUS.post((Event)new NotificationEvent(item));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addNotification(String tile, String Content, ItemStack item) {
        if (NEI_TH_Config.getConfigValue("ae2thing.crafting_notification")) {
            MinecraftForge.EVENT_BUS.post((Event)new NotificationEvent(tile, Content, item));
        }
    }
}

