var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// external-cesium:Cesium
var require_Cesium = __commonJS({
  "external-cesium:Cesium"(exports, module) {
    module.exports = Cesium;
  }
});

// node_modules/urijs/src/punycode.js
var require_punycode = __commonJS({
  "node_modules/urijs/src/punycode.js"(exports, module) {
    (function(root) {
      var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
      var freeModule = typeof module == "object" && module && !module.nodeType && module;
      var freeGlobal = typeof global == "object" && global;
      if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
        root = freeGlobal;
      }
      var punycode, maxInt = 2147483647, base = 36, tMin = 1, tMax = 26, skew = 38, damp = 700, initialBias = 72, initialN = 128, delimiter = "-", regexPunycode = /^xn--/, regexNonASCII = /[^\x20-\x7E]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      }, baseMinusTMin = base - tMin, floor = Math.floor, stringFromCharCode = String.fromCharCode, key;
      function error(type) {
        throw new RangeError(errors[type]);
      }
      function map(array, fn) {
        var length2 = array.length;
        var result = [];
        while (length2--) {
          result[length2] = fn(array[length2]);
        }
        return result;
      }
      function mapDomain(string, fn) {
        var parts = string.split("@");
        var result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          string = parts[1];
        }
        string = string.replace(regexSeparators, ".");
        var labels = string.split(".");
        var encoded = map(labels, fn).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        var output = [], counter = 0, length2 = string.length, value, extra;
        while (counter < length2) {
          value = string.charCodeAt(counter++);
          if (value >= 55296 && value <= 56319 && counter < length2) {
            extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      function ucs2encode(array) {
        return map(array, function(value) {
          var output = "";
          if (value > 65535) {
            value -= 65536;
            output += stringFromCharCode(value >>> 10 & 1023 | 55296);
            value = 56320 | value & 1023;
          }
          output += stringFromCharCode(value);
          return output;
        }).join("");
      }
      function basicToDigit(codePoint) {
        if (codePoint - 48 < 10) {
          return codePoint - 22;
        }
        if (codePoint - 65 < 26) {
          return codePoint - 65;
        }
        if (codePoint - 97 < 26) {
          return codePoint - 97;
        }
        return base;
      }
      function digitToBasic(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      }
      function adapt(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (; delta > baseMinusTMin * tMax >> 1; k += base) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      }
      function decode(input) {
        var output = [], inputLength = input.length, out, i = 0, n = initialN, bias = initialBias, basic, j, index, oldi, w, k, digit, t, baseMinusT;
        basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
          basic = 0;
        }
        for (j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          for (oldi = i, w = 1, k = base; ; k += base) {
            if (index >= inputLength) {
              error("invalid-input");
            }
            digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base || digit > floor((maxInt - i) / w)) {
              error("overflow");
            }
            i += digit * w;
            t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t) {
              break;
            }
            baseMinusT = base - t;
            if (w > floor(maxInt / baseMinusT)) {
              error("overflow");
            }
            w *= baseMinusT;
          }
          out = output.length + 1;
          bias = adapt(i - oldi, out, oldi == 0);
          if (floor(i / out) > maxInt - n) {
            error("overflow");
          }
          n += floor(i / out);
          i %= out;
          output.splice(i++, 0, n);
        }
        return ucs2encode(output);
      }
      function encode(input) {
        var n, delta, handledCPCount, basicLength, bias, j, m, q, k, t, currentValue, output = [], inputLength, handledCPCountPlusOne, baseMinusT, qMinusT;
        input = ucs2decode(input);
        inputLength = input.length;
        n = initialN;
        delta = 0;
        bias = initialBias;
        for (j = 0; j < inputLength; ++j) {
          currentValue = input[j];
          if (currentValue < 128) {
            output.push(stringFromCharCode(currentValue));
          }
        }
        handledCPCount = basicLength = output.length;
        if (basicLength) {
          output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
          for (m = maxInt, j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue >= n && currentValue < m) {
              m = currentValue;
            }
          }
          handledCPCountPlusOne = handledCPCount + 1;
          if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error("overflow");
          }
          delta += (m - n) * handledCPCountPlusOne;
          n = m;
          for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < n && ++delta > maxInt) {
              error("overflow");
            }
            if (currentValue == n) {
              for (q = delta, k = base; ; k += base) {
                t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (q < t) {
                  break;
                }
                qMinusT = q - t;
                baseMinusT = base - t;
                output.push(
                  stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                );
                q = floor(qMinusT / baseMinusT);
              }
              output.push(stringFromCharCode(digitToBasic(q, 0)));
              bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
              delta = 0;
              ++handledCPCount;
            }
          }
          ++delta;
          ++n;
        }
        return output.join("");
      }
      function toUnicode(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      }
      function toASCII(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      }
      punycode = {
        /**
         * A string representing the current Punycode.js version number.
         * @memberOf punycode
         * @type String
         */
        "version": "1.3.2",
        /**
         * An object of methods to convert from JavaScript's internal character
         * representation (UCS-2) to Unicode code points, and back.
         * @see <https://mathiasbynens.be/notes/javascript-encoding>
         * @memberOf punycode
         * @type Object
         */
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        define("punycode", function() {
          return punycode;
        });
      } else if (freeExports && freeModule) {
        if (module.exports == freeExports) {
          freeModule.exports = punycode;
        } else {
          for (key in punycode) {
            punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
          }
        }
      } else {
        root.punycode = punycode;
      }
    })(exports);
  }
});

// node_modules/urijs/src/IPv6.js
var require_IPv6 = __commonJS({
  "node_modules/urijs/src/IPv6.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.IPv6 = factory(root);
      }
    })(exports, function(root) {
      "use strict";
      var _IPv6 = root && root.IPv6;
      function bestPresentation(address) {
        var _address = address.toLowerCase();
        var segments = _address.split(":");
        var length2 = segments.length;
        var total = 8;
        if (segments[0] === "" && segments[1] === "" && segments[2] === "") {
          segments.shift();
          segments.shift();
        } else if (segments[0] === "" && segments[1] === "") {
          segments.shift();
        } else if (segments[length2 - 1] === "" && segments[length2 - 2] === "") {
          segments.pop();
        }
        length2 = segments.length;
        if (segments[length2 - 1].indexOf(".") !== -1) {
          total = 7;
        }
        var pos;
        for (pos = 0; pos < length2; pos++) {
          if (segments[pos] === "") {
            break;
          }
        }
        if (pos < total) {
          segments.splice(pos, 1, "0000");
          while (segments.length < total) {
            segments.splice(pos, 0, "0000");
          }
        }
        var _segments;
        for (var i = 0; i < total; i++) {
          _segments = segments[i].split("");
          for (var j = 0; j < 3; j++) {
            if (_segments[0] === "0" && _segments.length > 1) {
              _segments.splice(0, 1);
            } else {
              break;
            }
          }
          segments[i] = _segments.join("");
        }
        var best = -1;
        var _best = 0;
        var _current = 0;
        var current = -1;
        var inzeroes = false;
        for (i = 0; i < total; i++) {
          if (inzeroes) {
            if (segments[i] === "0") {
              _current += 1;
            } else {
              inzeroes = false;
              if (_current > _best) {
                best = current;
                _best = _current;
              }
            }
          } else {
            if (segments[i] === "0") {
              inzeroes = true;
              current = i;
              _current = 1;
            }
          }
        }
        if (_current > _best) {
          best = current;
          _best = _current;
        }
        if (_best > 1) {
          segments.splice(best, _best, "");
        }
        length2 = segments.length;
        var result = "";
        if (segments[0] === "") {
          result = ":";
        }
        for (i = 0; i < length2; i++) {
          result += segments[i];
          if (i === length2 - 1) {
            break;
          }
          result += ":";
        }
        if (segments[length2 - 1] === "") {
          result += ":";
        }
        return result;
      }
      function noConflict() {
        if (root.IPv6 === this) {
          root.IPv6 = _IPv6;
        }
        return this;
      }
      return {
        best: bestPresentation,
        noConflict
      };
    });
  }
});

// node_modules/urijs/src/SecondLevelDomains.js
var require_SecondLevelDomains = __commonJS({
  "node_modules/urijs/src/SecondLevelDomains.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.SecondLevelDomains = factory(root);
      }
    })(exports, function(root) {
      "use strict";
      var _SecondLevelDomains = root && root.SecondLevelDomains;
      var SLD = {
        // list of known Second Level Domains
        // converted list of SLDs from https://github.com/gavingmiller/second-level-domains
        // ----
        // publicsuffix.org is more current and actually used by a couple of browsers internally.
        // downside is it also contains domains like "dyndns.org" - which is fine for the security
        // issues browser have to deal with (SOP for cookies, etc) - but is way overboard for URI.js
        // ----
        list: {
          "ac": " com gov mil net org ",
          "ae": " ac co gov mil name net org pro sch ",
          "af": " com edu gov net org ",
          "al": " com edu gov mil net org ",
          "ao": " co ed gv it og pb ",
          "ar": " com edu gob gov int mil net org tur ",
          "at": " ac co gv or ",
          "au": " asn com csiro edu gov id net org ",
          "ba": " co com edu gov mil net org rs unbi unmo unsa untz unze ",
          "bb": " biz co com edu gov info net org store tv ",
          "bh": " biz cc com edu gov info net org ",
          "bn": " com edu gov net org ",
          "bo": " com edu gob gov int mil net org tv ",
          "br": " adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",
          "bs": " com edu gov net org ",
          "bz": " du et om ov rg ",
          "ca": " ab bc mb nb nf nl ns nt nu on pe qc sk yk ",
          "ck": " biz co edu gen gov info net org ",
          "cn": " ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",
          "co": " com edu gov mil net nom org ",
          "cr": " ac c co ed fi go or sa ",
          "cy": " ac biz com ekloges gov ltd name net org parliament press pro tm ",
          "do": " art com edu gob gov mil net org sld web ",
          "dz": " art asso com edu gov net org pol ",
          "ec": " com edu fin gov info med mil net org pro ",
          "eg": " com edu eun gov mil name net org sci ",
          "er": " com edu gov ind mil net org rochest w ",
          "es": " com edu gob nom org ",
          "et": " biz com edu gov info name net org ",
          "fj": " ac biz com info mil name net org pro ",
          "fk": " ac co gov net nom org ",
          "fr": " asso com f gouv nom prd presse tm ",
          "gg": " co net org ",
          "gh": " com edu gov mil org ",
          "gn": " ac com gov net org ",
          "gr": " com edu gov mil net org ",
          "gt": " com edu gob ind mil net org ",
          "gu": " com edu gov net org ",
          "hk": " com edu gov idv net org ",
          "hu": " 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",
          "id": " ac co go mil net or sch web ",
          "il": " ac co gov idf k12 muni net org ",
          "in": " ac co edu ernet firm gen gov i ind mil net nic org res ",
          "iq": " com edu gov i mil net org ",
          "ir": " ac co dnssec gov i id net org sch ",
          "it": " edu gov ",
          "je": " co net org ",
          "jo": " com edu gov mil name net org sch ",
          "jp": " ac ad co ed go gr lg ne or ",
          "ke": " ac co go info me mobi ne or sc ",
          "kh": " com edu gov mil net org per ",
          "ki": " biz com de edu gov info mob net org tel ",
          "km": " asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",
          "kn": " edu gov net org ",
          "kr": " ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",
          "kw": " com edu gov net org ",
          "ky": " com edu gov net org ",
          "kz": " com edu gov mil net org ",
          "lb": " com edu gov net org ",
          "lk": " assn com edu gov grp hotel int ltd net ngo org sch soc web ",
          "lr": " com edu gov net org ",
          "lv": " asn com conf edu gov id mil net org ",
          "ly": " com edu gov id med net org plc sch ",
          "ma": " ac co gov m net org press ",
          "mc": " asso tm ",
          "me": " ac co edu gov its net org priv ",
          "mg": " com edu gov mil nom org prd tm ",
          "mk": " com edu gov inf name net org pro ",
          "ml": " com edu gov net org presse ",
          "mn": " edu gov org ",
          "mo": " com edu gov net org ",
          "mt": " com edu gov net org ",
          "mv": " aero biz com coop edu gov info int mil museum name net org pro ",
          "mw": " ac co com coop edu gov int museum net org ",
          "mx": " com edu gob net org ",
          "my": " com edu gov mil name net org sch ",
          "nf": " arts com firm info net other per rec store web ",
          "ng": " biz com edu gov mil mobi name net org sch ",
          "ni": " ac co com edu gob mil net nom org ",
          "np": " com edu gov mil net org ",
          "nr": " biz com edu gov info net org ",
          "om": " ac biz co com edu gov med mil museum net org pro sch ",
          "pe": " com edu gob mil net nom org sld ",
          "ph": " com edu gov i mil net ngo org ",
          "pk": " biz com edu fam gob gok gon gop gos gov net org web ",
          "pl": " art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",
          "pr": " ac biz com edu est gov info isla name net org pro prof ",
          "ps": " com edu gov net org plo sec ",
          "pw": " belau co ed go ne or ",
          "ro": " arts com firm info nom nt org rec store tm www ",
          "rs": " ac co edu gov in org ",
          "sb": " com edu gov net org ",
          "sc": " com edu gov net org ",
          "sh": " co com edu gov net nom org ",
          "sl": " com edu gov net org ",
          "st": " co com consulado edu embaixada gov mil net org principe saotome store ",
          "sv": " com edu gob org red ",
          "sz": " ac co org ",
          "tr": " av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",
          "tt": " aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",
          "tw": " club com ebiz edu game gov idv mil net org ",
          "mu": " ac co com gov net or org ",
          "mz": " ac co edu gov org ",
          "na": " co com ",
          "nz": " ac co cri geek gen govt health iwi maori mil net org parliament school ",
          "pa": " abo ac com edu gob ing med net nom org sld ",
          "pt": " com edu gov int net nome org publ ",
          "py": " com edu gov mil net org ",
          "qa": " com edu gov mil net org ",
          "re": " asso com nom ",
          "ru": " ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",
          "rw": " ac co com edu gouv gov int mil net ",
          "sa": " com edu gov med net org pub sch ",
          "sd": " com edu gov info med net org tv ",
          "se": " a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",
          "sg": " com edu gov idn net org per ",
          "sn": " art com edu gouv org perso univ ",
          "sy": " com edu gov mil net news org ",
          "th": " ac co go in mi net or ",
          "tj": " ac biz co com edu go gov info int mil name net nic org test web ",
          "tn": " agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",
          "tz": " ac co go ne or ",
          "ua": " biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",
          "ug": " ac co go ne or org sc ",
          "uk": " ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",
          "us": " dni fed isa kids nsn ",
          "uy": " com edu gub mil net org ",
          "ve": " co com edu gob info mil net org web ",
          "vi": " co com k12 net org ",
          "vn": " ac biz com edu gov health info int name net org pro ",
          "ye": " co com gov ltd me net org plc ",
          "yu": " ac co edu gov org ",
          "za": " ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",
          "zm": " ac co com edu gov net org sch ",
          // https://en.wikipedia.org/wiki/CentralNic#Second-level_domains
          "com": "ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",
          "net": "gb jp se uk ",
          "org": "ae",
          "de": "com "
        },
        // gorhill 2013-10-25: Using indexOf() instead Regexp(). Significant boost
        // in both performance and memory footprint. No initialization required.
        // http://jsperf.com/uri-js-sld-regex-vs-binary-search/4
        // Following methods use lastIndexOf() rather than array.split() in order
        // to avoid any memory allocations.
        has: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") >= 0;
        },
        is: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset >= 0) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(0, tldOffset) + " ") >= 0;
        },
        get: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return null;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return null;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return null;
          }
          if (sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") < 0) {
            return null;
          }
          return domain.slice(sldOffset + 1);
        },
        noConflict: function() {
          if (root.SecondLevelDomains === this) {
            root.SecondLevelDomains = _SecondLevelDomains;
          }
          return this;
        }
      };
      return SLD;
    });
  }
});

// node_modules/urijs/src/URI.js
var require_URI = __commonJS({
  "node_modules/urijs/src/URI.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory(require_punycode(), require_IPv6(), require_SecondLevelDomains());
      } else if (typeof define === "function" && define.amd) {
        define(["./punycode", "./IPv6", "./SecondLevelDomains"], factory);
      } else {
        root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
      }
    })(exports, function(punycode, IPv6, SLD, root) {
      "use strict";
      var _URI = root && root.URI;
      function URI(url, base) {
        var _urlSupplied = arguments.length >= 1;
        var _baseSupplied = arguments.length >= 2;
        if (!(this instanceof URI)) {
          if (_urlSupplied) {
            if (_baseSupplied) {
              return new URI(url, base);
            }
            return new URI(url);
          }
          return new URI();
        }
        if (url === void 0) {
          if (_urlSupplied) {
            throw new TypeError("undefined is not a valid argument for URI");
          }
          if (typeof location !== "undefined") {
            url = location.href + "";
          } else {
            url = "";
          }
        }
        if (url === null) {
          if (_urlSupplied) {
            throw new TypeError("null is not a valid argument for URI");
          }
        }
        this.href(url);
        if (base !== void 0) {
          return this.absoluteTo(base);
        }
        return this;
      }
      function isInteger(value) {
        return /^[0-9]+$/.test(value);
      }
      URI.version = "1.19.11";
      var p = URI.prototype;
      var hasOwn = Object.prototype.hasOwnProperty;
      function escapeRegEx(string) {
        return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, "\\$1");
      }
      function getType(value) {
        if (value === void 0) {
          return "Undefined";
        }
        return String(Object.prototype.toString.call(value)).slice(8, -1);
      }
      function isArray(obj) {
        return getType(obj) === "Array";
      }
      function filterArrayValues(data, value) {
        var lookup = {};
        var i, length2;
        if (getType(value) === "RegExp") {
          lookup = null;
        } else if (isArray(value)) {
          for (i = 0, length2 = value.length; i < length2; i++) {
            lookup[value[i]] = true;
          }
        } else {
          lookup[value] = true;
        }
        for (i = 0, length2 = data.length; i < length2; i++) {
          var _match = lookup && lookup[data[i]] !== void 0 || !lookup && value.test(data[i]);
          if (_match) {
            data.splice(i, 1);
            length2--;
            i--;
          }
        }
        return data;
      }
      function arrayContains(list, value) {
        var i, length2;
        if (isArray(value)) {
          for (i = 0, length2 = value.length; i < length2; i++) {
            if (!arrayContains(list, value[i])) {
              return false;
            }
          }
          return true;
        }
        var _type = getType(value);
        for (i = 0, length2 = list.length; i < length2; i++) {
          if (_type === "RegExp") {
            if (typeof list[i] === "string" && list[i].match(value)) {
              return true;
            }
          } else if (list[i] === value) {
            return true;
          }
        }
        return false;
      }
      function arraysEqual(one, two) {
        if (!isArray(one) || !isArray(two)) {
          return false;
        }
        if (one.length !== two.length) {
          return false;
        }
        one.sort();
        two.sort();
        for (var i = 0, l = one.length; i < l; i++) {
          if (one[i] !== two[i]) {
            return false;
          }
        }
        return true;
      }
      function trimSlashes(text) {
        var trim_expression = /^\/+|\/+$/g;
        return text.replace(trim_expression, "");
      }
      URI._parts = function() {
        return {
          protocol: null,
          username: null,
          password: null,
          hostname: null,
          urn: null,
          port: null,
          path: null,
          query: null,
          fragment: null,
          // state
          preventInvalidHostname: URI.preventInvalidHostname,
          duplicateQueryParameters: URI.duplicateQueryParameters,
          escapeQuerySpace: URI.escapeQuerySpace
        };
      };
      URI.preventInvalidHostname = false;
      URI.duplicateQueryParameters = false;
      URI.escapeQuerySpace = true;
      URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
      URI.idn_expression = /[^a-z0-9\._-]/i;
      URI.punycode_expression = /(xn--)/i;
      URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
      URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
      URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
      URI.findUri = {
        // valid "scheme://" or "www."
        start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
        // everything up to the next whitespace
        end: /[\s\r\n]|$/,
        // trim trailing punctuation captured by end RegExp
        trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
        // balanced parens inclusion (), [], {}, <>
        parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g
      };
      URI.leading_whitespace_expression = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
      URI.ascii_tab_whitespace = /[\u0009\u000A\u000D]+/g;
      URI.defaultPorts = {
        http: "80",
        https: "443",
        ftp: "21",
        gopher: "70",
        ws: "80",
        wss: "443"
      };
      URI.hostProtocols = [
        "http",
        "https"
      ];
      URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
      URI.domAttributes = {
        "a": "href",
        "blockquote": "cite",
        "link": "href",
        "base": "href",
        "script": "src",
        "form": "action",
        "img": "src",
        "area": "href",
        "iframe": "src",
        "embed": "src",
        "source": "src",
        "track": "src",
        "input": "src",
        // but only if type="image"
        "audio": "src",
        "video": "src"
      };
      URI.getDomAttribute = function(node) {
        if (!node || !node.nodeName) {
          return void 0;
        }
        var nodeName = node.nodeName.toLowerCase();
        if (nodeName === "input" && node.type !== "image") {
          return void 0;
        }
        return URI.domAttributes[nodeName];
      };
      function escapeForDumbFirefox36(value) {
        return escape(value);
      }
      function strictEncodeURIComponent(string) {
        return encodeURIComponent(string).replace(/[!'()*]/g, escapeForDumbFirefox36).replace(/\*/g, "%2A");
      }
      URI.encode = strictEncodeURIComponent;
      URI.decode = decodeURIComponent;
      URI.iso8859 = function() {
        URI.encode = escape;
        URI.decode = unescape;
      };
      URI.unicode = function() {
        URI.encode = strictEncodeURIComponent;
        URI.decode = decodeURIComponent;
      };
      URI.characters = {
        pathname: {
          encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
            map: {
              // -._~!'()*
              "%24": "$",
              "%26": "&",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%3A": ":",
              "%40": "@"
            }
          },
          decode: {
            expression: /[\/\?#]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23"
            }
          }
        },
        reserved: {
          encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
            map: {
              // gen-delims
              "%3A": ":",
              "%2F": "/",
              "%3F": "?",
              "%23": "#",
              "%5B": "[",
              "%5D": "]",
              "%40": "@",
              // sub-delims
              "%21": "!",
              "%24": "$",
              "%26": "&",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "="
            }
          }
        },
        urnpath: {
          // The characters under `encode` are the characters called out by RFC 2141 as being acceptable
          // for usage in a URN. RFC2141 also calls out "-", ".", and "_" as acceptable characters, but
          // these aren't encoded by encodeURIComponent, so we don't have to call them out here. Also
          // note that the colon character is not featured in the encoding map; this is because URI.js
          // gives the colons in URNs semantic meaning as the delimiters of path segements, and so it
          // should not appear unencoded in a segment itself.
          // See also the note above about RFC3986 and capitalalized hex digits.
          encode: {
            expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
            map: {
              "%21": "!",
              "%24": "$",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%40": "@"
            }
          },
          // These characters are the characters called out by RFC2141 as "reserved" characters that
          // should never appear in a URN, plus the colon character (see note above).
          decode: {
            expression: /[\/\?#:]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23",
              ":": "%3A"
            }
          }
        }
      };
      URI.encodeQuery = function(string, escapeQuerySpace) {
        var escaped = URI.encode(string + "");
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        return escapeQuerySpace ? escaped.replace(/%20/g, "+") : escaped;
      };
      URI.decodeQuery = function(string, escapeQuerySpace) {
        string += "";
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        try {
          return URI.decode(escapeQuerySpace ? string.replace(/\+/g, "%20") : string);
        } catch (e) {
          return string;
        }
      };
      var _parts = { "encode": "encode", "decode": "decode" };
      var _part;
      var generateAccessor = function(_group, _part2) {
        return function(string) {
          try {
            return URI[_part2](string + "").replace(URI.characters[_group][_part2].expression, function(c) {
              return URI.characters[_group][_part2].map[c];
            });
          } catch (e) {
            return string;
          }
        };
      };
      for (_part in _parts) {
        URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
        URI[_part + "UrnPathSegment"] = generateAccessor("urnpath", _parts[_part]);
      }
      var generateSegmentedPathFunction = function(_sep, _codingFuncName, _innerCodingFuncName) {
        return function(string) {
          var actualCodingFunc;
          if (!_innerCodingFuncName) {
            actualCodingFunc = URI[_codingFuncName];
          } else {
            actualCodingFunc = function(string2) {
              return URI[_codingFuncName](URI[_innerCodingFuncName](string2));
            };
          }
          var segments = (string + "").split(_sep);
          for (var i = 0, length2 = segments.length; i < length2; i++) {
            segments[i] = actualCodingFunc(segments[i]);
          }
          return segments.join(_sep);
        };
      };
      URI.decodePath = generateSegmentedPathFunction("/", "decodePathSegment");
      URI.decodeUrnPath = generateSegmentedPathFunction(":", "decodeUrnPathSegment");
      URI.recodePath = generateSegmentedPathFunction("/", "encodePathSegment", "decode");
      URI.recodeUrnPath = generateSegmentedPathFunction(":", "encodeUrnPathSegment", "decode");
      URI.encodeReserved = generateAccessor("reserved", "encode");
      URI.parse = function(string, parts) {
        var pos;
        if (!parts) {
          parts = {
            preventInvalidHostname: URI.preventInvalidHostname
          };
        }
        string = string.replace(URI.leading_whitespace_expression, "");
        string = string.replace(URI.ascii_tab_whitespace, "");
        pos = string.indexOf("#");
        if (pos > -1) {
          parts.fragment = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        pos = string.indexOf("?");
        if (pos > -1) {
          parts.query = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        string = string.replace(/^(https?|ftp|wss?)?:+[/\\]*/i, "$1://");
        string = string.replace(/^[/\\]{2,}/i, "//");
        if (string.substring(0, 2) === "//") {
          parts.protocol = null;
          string = string.substring(2);
          string = URI.parseAuthority(string, parts);
        } else {
          pos = string.indexOf(":");
          if (pos > -1) {
            parts.protocol = string.substring(0, pos) || null;
            if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
              parts.protocol = void 0;
            } else if (string.substring(pos + 1, pos + 3).replace(/\\/g, "/") === "//") {
              string = string.substring(pos + 3);
              string = URI.parseAuthority(string, parts);
            } else {
              string = string.substring(pos + 1);
              parts.urn = true;
            }
          }
        }
        parts.path = string;
        return parts;
      };
      URI.parseHost = function(string, parts) {
        if (!string) {
          string = "";
        }
        string = string.replace(/\\/g, "/");
        var pos = string.indexOf("/");
        var bracketPos;
        var t;
        if (pos === -1) {
          pos = string.length;
        }
        if (string.charAt(0) === "[") {
          bracketPos = string.indexOf("]");
          parts.hostname = string.substring(1, bracketPos) || null;
          parts.port = string.substring(bracketPos + 2, pos) || null;
          if (parts.port === "/") {
            parts.port = null;
          }
        } else {
          var firstColon = string.indexOf(":");
          var firstSlash = string.indexOf("/");
          var nextColon = string.indexOf(":", firstColon + 1);
          if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
            parts.hostname = string.substring(0, pos) || null;
            parts.port = null;
          } else {
            t = string.substring(0, pos).split(":");
            parts.hostname = t[0] || null;
            parts.port = t[1] || null;
          }
        }
        if (parts.hostname && string.substring(pos).charAt(0) !== "/") {
          pos++;
          string = "/" + string;
        }
        if (parts.preventInvalidHostname) {
          URI.ensureValidHostname(parts.hostname, parts.protocol);
        }
        if (parts.port) {
          URI.ensureValidPort(parts.port);
        }
        return string.substring(pos) || "/";
      };
      URI.parseAuthority = function(string, parts) {
        string = URI.parseUserinfo(string, parts);
        return URI.parseHost(string, parts);
      };
      URI.parseUserinfo = function(string, parts) {
        var _string = string;
        var firstBackSlash = string.indexOf("\\");
        if (firstBackSlash !== -1) {
          string = string.replace(/\\/g, "/");
        }
        var firstSlash = string.indexOf("/");
        var pos = string.lastIndexOf("@", firstSlash > -1 ? firstSlash : string.length - 1);
        var t;
        if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
          t = string.substring(0, pos).split(":");
          parts.username = t[0] ? URI.decode(t[0]) : null;
          t.shift();
          parts.password = t[0] ? URI.decode(t.join(":")) : null;
          string = _string.substring(pos + 1);
        } else {
          parts.username = null;
          parts.password = null;
        }
        return string;
      };
      URI.parseQuery = function(string, escapeQuerySpace) {
        if (!string) {
          return {};
        }
        string = string.replace(/&+/g, "&").replace(/^\?*&*|&+$/g, "");
        if (!string) {
          return {};
        }
        var items = {};
        var splits = string.split("&");
        var length2 = splits.length;
        var v, name, value;
        for (var i = 0; i < length2; i++) {
          v = splits[i].split("=");
          name = URI.decodeQuery(v.shift(), escapeQuerySpace);
          value = v.length ? URI.decodeQuery(v.join("="), escapeQuerySpace) : null;
          if (name === "__proto__") {
            continue;
          } else if (hasOwn.call(items, name)) {
            if (typeof items[name] === "string" || items[name] === null) {
              items[name] = [items[name]];
            }
            items[name].push(value);
          } else {
            items[name] = value;
          }
        }
        return items;
      };
      URI.build = function(parts) {
        var t = "";
        var requireAbsolutePath = false;
        if (parts.protocol) {
          t += parts.protocol + ":";
        }
        if (!parts.urn && (t || parts.hostname)) {
          t += "//";
          requireAbsolutePath = true;
        }
        t += URI.buildAuthority(parts) || "";
        if (typeof parts.path === "string") {
          if (parts.path.charAt(0) !== "/" && requireAbsolutePath) {
            t += "/";
          }
          t += parts.path;
        }
        if (typeof parts.query === "string" && parts.query) {
          t += "?" + parts.query;
        }
        if (typeof parts.fragment === "string" && parts.fragment) {
          t += "#" + parts.fragment;
        }
        return t;
      };
      URI.buildHost = function(parts) {
        var t = "";
        if (!parts.hostname) {
          return "";
        } else if (URI.ip6_expression.test(parts.hostname)) {
          t += "[" + parts.hostname + "]";
        } else {
          t += parts.hostname;
        }
        if (parts.port) {
          t += ":" + parts.port;
        }
        return t;
      };
      URI.buildAuthority = function(parts) {
        return URI.buildUserinfo(parts) + URI.buildHost(parts);
      };
      URI.buildUserinfo = function(parts) {
        var t = "";
        if (parts.username) {
          t += URI.encode(parts.username);
        }
        if (parts.password) {
          t += ":" + URI.encode(parts.password);
        }
        if (t) {
          t += "@";
        }
        return t;
      };
      URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
        var t = "";
        var unique, key, i, length2;
        for (key in data) {
          if (key === "__proto__") {
            continue;
          } else if (hasOwn.call(data, key)) {
            if (isArray(data[key])) {
              unique = {};
              for (i = 0, length2 = data[key].length; i < length2; i++) {
                if (data[key][i] !== void 0 && unique[data[key][i] + ""] === void 0) {
                  t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                  if (duplicateQueryParameters !== true) {
                    unique[data[key][i] + ""] = true;
                  }
                }
              }
            } else if (data[key] !== void 0) {
              t += "&" + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
            }
          }
        }
        return t.substring(1);
      };
      URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
        return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
      };
      URI.addQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.addQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (data[name] === void 0) {
            data[name] = value;
            return;
          } else if (typeof data[name] === "string") {
            data[name] = [data[name]];
          }
          if (!isArray(value)) {
            value = [value];
          }
          data[name] = (data[name] || []).concat(value);
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
      };
      URI.setQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.setQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          data[name] = value === void 0 ? null : value;
        } else {
          throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");
        }
      };
      URI.removeQuery = function(data, name, value) {
        var i, length2, key;
        if (isArray(name)) {
          for (i = 0, length2 = name.length; i < length2; i++) {
            data[name[i]] = void 0;
          }
        } else if (getType(name) === "RegExp") {
          for (key in data) {
            if (name.test(key)) {
              data[key] = void 0;
            }
          }
        } else if (typeof name === "object") {
          for (key in name) {
            if (hasOwn.call(name, key)) {
              URI.removeQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (value !== void 0) {
            if (getType(value) === "RegExp") {
              if (!isArray(data[name]) && value.test(data[name])) {
                data[name] = void 0;
              } else {
                data[name] = filterArrayValues(data[name], value);
              }
            } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
              data[name] = void 0;
            } else if (isArray(data[name])) {
              data[name] = filterArrayValues(data[name], value);
            }
          } else {
            data[name] = void 0;
          }
        } else {
          throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");
        }
      };
      URI.hasQuery = function(data, name, value, withinArray) {
        switch (getType(name)) {
          case "String":
            break;
          case "RegExp":
            for (var key in data) {
              if (hasOwn.call(data, key)) {
                if (name.test(key) && (value === void 0 || URI.hasQuery(data, key, value))) {
                  return true;
                }
              }
            }
            return false;
          case "Object":
            for (var _key in name) {
              if (hasOwn.call(name, _key)) {
                if (!URI.hasQuery(data, _key, name[_key])) {
                  return false;
                }
              }
            }
            return true;
          default:
            throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter");
        }
        switch (getType(value)) {
          case "Undefined":
            return name in data;
          case "Boolean":
            var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
            return value === _booly;
          case "Function":
            return !!value(data[name], name, data);
          case "Array":
            if (!isArray(data[name])) {
              return false;
            }
            var op = withinArray ? arrayContains : arraysEqual;
            return op(data[name], value);
          case "RegExp":
            if (!isArray(data[name])) {
              return Boolean(data[name] && data[name].match(value));
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          case "Number":
            value = String(value);
          case "String":
            if (!isArray(data[name])) {
              return data[name] === value;
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          default:
            throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
        }
      };
      URI.joinPaths = function() {
        var input = [];
        var segments = [];
        var nonEmptySegments = 0;
        for (var i = 0; i < arguments.length; i++) {
          var url = new URI(arguments[i]);
          input.push(url);
          var _segments = url.segment();
          for (var s = 0; s < _segments.length; s++) {
            if (typeof _segments[s] === "string") {
              segments.push(_segments[s]);
            }
            if (_segments[s]) {
              nonEmptySegments++;
            }
          }
        }
        if (!segments.length || !nonEmptySegments) {
          return new URI("");
        }
        var uri = new URI("").segment(segments);
        if (input[0].path() === "" || input[0].path().slice(0, 1) === "/") {
          uri.path("/" + uri.path());
        }
        return uri.normalize();
      };
      URI.commonPath = function(one, two) {
        var length2 = Math.min(one.length, two.length);
        var pos;
        for (pos = 0; pos < length2; pos++) {
          if (one.charAt(pos) !== two.charAt(pos)) {
            pos--;
            break;
          }
        }
        if (pos < 1) {
          return one.charAt(0) === two.charAt(0) && one.charAt(0) === "/" ? "/" : "";
        }
        if (one.charAt(pos) !== "/" || two.charAt(pos) !== "/") {
          pos = one.substring(0, pos).lastIndexOf("/");
        }
        return one.substring(0, pos + 1);
      };
      URI.withinString = function(string, callback, options) {
        options || (options = {});
        var _start = options.start || URI.findUri.start;
        var _end = options.end || URI.findUri.end;
        var _trim = options.trim || URI.findUri.trim;
        var _parens = options.parens || URI.findUri.parens;
        var _attributeOpen = /[a-z0-9-]=["']?$/i;
        _start.lastIndex = 0;
        while (true) {
          var match = _start.exec(string);
          if (!match) {
            break;
          }
          var start = match.index;
          if (options.ignoreHtml) {
            var attributeOpen = string.slice(Math.max(start - 3, 0), start);
            if (attributeOpen && _attributeOpen.test(attributeOpen)) {
              continue;
            }
          }
          var end = start + string.slice(start).search(_end);
          var slice = string.slice(start, end);
          var parensEnd = -1;
          while (true) {
            var parensMatch = _parens.exec(slice);
            if (!parensMatch) {
              break;
            }
            var parensMatchEnd = parensMatch.index + parensMatch[0].length;
            parensEnd = Math.max(parensEnd, parensMatchEnd);
          }
          if (parensEnd > -1) {
            slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, "");
          } else {
            slice = slice.replace(_trim, "");
          }
          if (slice.length <= match[0].length) {
            continue;
          }
          if (options.ignore && options.ignore.test(slice)) {
            continue;
          }
          end = start + slice.length;
          var result = callback(slice, start, end, string);
          if (result === void 0) {
            _start.lastIndex = end;
            continue;
          }
          result = String(result);
          string = string.slice(0, start) + result + string.slice(end);
          _start.lastIndex = start + result.length;
        }
        _start.lastIndex = 0;
        return string;
      };
      URI.ensureValidHostname = function(v, protocol) {
        var hasHostname = !!v;
        var hasProtocol = !!protocol;
        var rejectEmptyHostname = false;
        if (hasProtocol) {
          rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
        }
        if (rejectEmptyHostname && !hasHostname) {
          throw new TypeError("Hostname cannot be empty, if protocol is " + protocol);
        } else if (v && v.match(URI.invalid_hostname_characters)) {
          if (!punycode) {
            throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
          }
          if (punycode.toASCII(v).match(URI.invalid_hostname_characters)) {
            throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-:_]');
          }
        }
      };
      URI.ensureValidPort = function(v) {
        if (!v) {
          return;
        }
        var port = Number(v);
        if (isInteger(port) && port > 0 && port < 65536) {
          return;
        }
        throw new TypeError('Port "' + v + '" is not a valid port');
      };
      URI.noConflict = function(removeAll) {
        if (removeAll) {
          var unconflicted = {
            URI: this.noConflict()
          };
          if (root.URITemplate && typeof root.URITemplate.noConflict === "function") {
            unconflicted.URITemplate = root.URITemplate.noConflict();
          }
          if (root.IPv6 && typeof root.IPv6.noConflict === "function") {
            unconflicted.IPv6 = root.IPv6.noConflict();
          }
          if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === "function") {
            unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
          }
          return unconflicted;
        } else if (root.URI === this) {
          root.URI = _URI;
        }
        return this;
      };
      p.build = function(deferBuild) {
        if (deferBuild === true) {
          this._deferred_build = true;
        } else if (deferBuild === void 0 || this._deferred_build) {
          this._string = URI.build(this._parts);
          this._deferred_build = false;
        }
        return this;
      };
      p.clone = function() {
        return new URI(this);
      };
      p.valueOf = p.toString = function() {
        return this.build(false)._string;
      };
      function generateSimpleAccessor(_part2) {
        return function(v, build) {
          if (v === void 0) {
            return this._parts[_part2] || "";
          } else {
            this._parts[_part2] = v || null;
            this.build(!build);
            return this;
          }
        };
      }
      function generatePrefixAccessor(_part2, _key) {
        return function(v, build) {
          if (v === void 0) {
            return this._parts[_part2] || "";
          } else {
            if (v !== null) {
              v = v + "";
              if (v.charAt(0) === _key) {
                v = v.substring(1);
              }
            }
            this._parts[_part2] = v;
            this.build(!build);
            return this;
          }
        };
      }
      p.protocol = generateSimpleAccessor("protocol");
      p.username = generateSimpleAccessor("username");
      p.password = generateSimpleAccessor("password");
      p.hostname = generateSimpleAccessor("hostname");
      p.port = generateSimpleAccessor("port");
      p.query = generatePrefixAccessor("query", "?");
      p.fragment = generatePrefixAccessor("fragment", "#");
      p.search = function(v, build) {
        var t = this.query(v, build);
        return typeof t === "string" && t.length ? "?" + t : t;
      };
      p.hash = function(v, build) {
        var t = this.fragment(v, build);
        return typeof t === "string" && t.length ? "#" + t : t;
      };
      p.pathname = function(v, build) {
        if (v === void 0 || v === true) {
          var res = this._parts.path || (this._parts.hostname ? "/" : "");
          return v ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
        } else {
          if (this._parts.urn) {
            this._parts.path = v ? URI.recodeUrnPath(v) : "";
          } else {
            this._parts.path = v ? URI.recodePath(v) : "/";
          }
          this.build(!build);
          return this;
        }
      };
      p.path = p.pathname;
      p.href = function(href, build) {
        var key;
        if (href === void 0) {
          return this.toString();
        }
        this._string = "";
        this._parts = URI._parts();
        var _URI2 = href instanceof URI;
        var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
        if (href.nodeName) {
          var attribute = URI.getDomAttribute(href);
          href = href[attribute] || "";
          _object = false;
        }
        if (!_URI2 && _object && href.pathname !== void 0) {
          href = href.toString();
        }
        if (typeof href === "string" || href instanceof String) {
          this._parts = URI.parse(String(href), this._parts);
        } else if (_URI2 || _object) {
          var src = _URI2 ? href._parts : href;
          for (key in src) {
            if (key === "query") {
              continue;
            }
            if (hasOwn.call(this._parts, key)) {
              this._parts[key] = src[key];
            }
          }
          if (src.query) {
            this.query(src.query, false);
          }
        } else {
          throw new TypeError("invalid input");
        }
        this.build(!build);
        return this;
      };
      p.is = function(what) {
        var ip = false;
        var ip4 = false;
        var ip6 = false;
        var name = false;
        var sld = false;
        var idn = false;
        var punycode2 = false;
        var relative = !this._parts.urn;
        if (this._parts.hostname) {
          relative = false;
          ip4 = URI.ip4_expression.test(this._parts.hostname);
          ip6 = URI.ip6_expression.test(this._parts.hostname);
          ip = ip4 || ip6;
          name = !ip;
          sld = name && SLD && SLD.has(this._parts.hostname);
          idn = name && URI.idn_expression.test(this._parts.hostname);
          punycode2 = name && URI.punycode_expression.test(this._parts.hostname);
        }
        switch (what.toLowerCase()) {
          case "relative":
            return relative;
          case "absolute":
            return !relative;
          case "domain":
          case "name":
            return name;
          case "sld":
            return sld;
          case "ip":
            return ip;
          case "ip4":
          case "ipv4":
          case "inet4":
            return ip4;
          case "ip6":
          case "ipv6":
          case "inet6":
            return ip6;
          case "idn":
            return idn;
          case "url":
            return !this._parts.urn;
          case "urn":
            return !!this._parts.urn;
          case "punycode":
            return punycode2;
        }
        return null;
      };
      var _protocol = p.protocol;
      var _port = p.port;
      var _hostname = p.hostname;
      p.protocol = function(v, build) {
        if (v) {
          v = v.replace(/:(\/\/)?$/, "");
          if (!v.match(URI.protocol_expression)) {
            throw new TypeError('Protocol "' + v + `" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);
          }
        }
        return _protocol.call(this, v, build);
      };
      p.scheme = p.protocol;
      p.port = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v !== void 0) {
          if (v === 0) {
            v = null;
          }
          if (v) {
            v += "";
            if (v.charAt(0) === ":") {
              v = v.substring(1);
            }
            URI.ensureValidPort(v);
          }
        }
        return _port.call(this, v, build);
      };
      p.hostname = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v !== void 0) {
          var x = { preventInvalidHostname: this._parts.preventInvalidHostname };
          var res = URI.parseHost(v, x);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
          }
          v = x.hostname;
          if (this._parts.preventInvalidHostname) {
            URI.ensureValidHostname(v, this._parts.protocol);
          }
        }
        return _hostname.call(this, v, build);
      };
      p.origin = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v === void 0) {
          var protocol = this.protocol();
          var authority = this.authority();
          if (!authority) {
            return "";
          }
          return (protocol ? protocol + "://" : "") + this.authority();
        } else {
          var origin = URI(v);
          this.protocol(origin.protocol()).authority(origin.authority()).build(!build);
          return this;
        }
      };
      p.host = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v === void 0) {
          return this._parts.hostname ? URI.buildHost(this._parts) : "";
        } else {
          var res = URI.parseHost(v, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.authority = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v === void 0) {
          return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
        } else {
          var res = URI.parseAuthority(v, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.userinfo = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v === void 0) {
          var t = URI.buildUserinfo(this._parts);
          return t ? t.substring(0, t.length - 1) : t;
        } else {
          if (v[v.length - 1] !== "@") {
            v += "@";
          }
          URI.parseUserinfo(v, this._parts);
          this.build(!build);
          return this;
        }
      };
      p.resource = function(v, build) {
        var parts;
        if (v === void 0) {
          return this.path() + this.search() + this.hash();
        }
        parts = URI.parse(v);
        this._parts.path = parts.path;
        this._parts.query = parts.query;
        this._parts.fragment = parts.fragment;
        this.build(!build);
        return this;
      };
      p.subdomain = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var end = this._parts.hostname.length - this.domain().length - 1;
          return this._parts.hostname.substring(0, end) || "";
        } else {
          var e = this._parts.hostname.length - this.domain().length;
          var sub = this._parts.hostname.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(sub));
          if (v && v.charAt(v.length - 1) !== ".") {
            v += ".";
          }
          if (v.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          if (v) {
            URI.ensureValidHostname(v, this._parts.protocol);
          }
          this._parts.hostname = this._parts.hostname.replace(replace, v);
          this.build(!build);
          return this;
        }
      };
      p.domain = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (typeof v === "boolean") {
          build = v;
          v = void 0;
        }
        if (v === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var t = this._parts.hostname.match(/\./g);
          if (t && t.length < 2) {
            return this._parts.hostname;
          }
          var end = this._parts.hostname.length - this.tld(build).length - 1;
          end = this._parts.hostname.lastIndexOf(".", end - 1) + 1;
          return this._parts.hostname.substring(end) || "";
        } else {
          if (!v) {
            throw new TypeError("cannot set domain empty");
          }
          if (v.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          URI.ensureValidHostname(v, this._parts.protocol);
          if (!this._parts.hostname || this.is("IP")) {
            this._parts.hostname = v;
          } else {
            var replace = new RegExp(escapeRegEx(this.domain()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v);
          }
          this.build(!build);
          return this;
        }
      };
      p.tld = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (typeof v === "boolean") {
          build = v;
          v = void 0;
        }
        if (v === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var pos = this._parts.hostname.lastIndexOf(".");
          var tld = this._parts.hostname.substring(pos + 1);
          if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
            return SLD.get(this._parts.hostname) || tld;
          }
          return tld;
        } else {
          var replace;
          if (!v) {
            throw new TypeError("cannot set TLD empty");
          } else if (v.match(/[^a-zA-Z0-9-]/)) {
            if (SLD && SLD.is(v)) {
              replace = new RegExp(escapeRegEx(this.tld()) + "$");
              this._parts.hostname = this._parts.hostname.replace(replace, v);
            } else {
              throw new TypeError('TLD "' + v + '" contains characters other than [A-Z0-9]');
            }
          } else if (!this._parts.hostname || this.is("IP")) {
            throw new ReferenceError("cannot set TLD on non-domain host");
          } else {
            replace = new RegExp(escapeRegEx(this.tld()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v);
          }
          this.build(!build);
          return this;
        }
      };
      p.directory = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v === void 0 || v === true) {
          if (!this._parts.path && !this._parts.hostname) {
            return "";
          }
          if (this._parts.path === "/") {
            return "/";
          }
          var end = this._parts.path.length - this.filename().length - 1;
          var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");
          return v ? URI.decodePath(res) : res;
        } else {
          var e = this._parts.path.length - this.filename().length;
          var directory = this._parts.path.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(directory));
          if (!this.is("relative")) {
            if (!v) {
              v = "/";
            }
            if (v.charAt(0) !== "/") {
              v = "/" + v;
            }
          }
          if (v && v.charAt(v.length - 1) !== "/") {
            v += "/";
          }
          v = URI.recodePath(v);
          this._parts.path = this._parts.path.replace(replace, v);
          this.build(!build);
          return this;
        }
      };
      p.filename = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (typeof v !== "string") {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var pos = this._parts.path.lastIndexOf("/");
          var res = this._parts.path.substring(pos + 1);
          return v ? URI.decodePathSegment(res) : res;
        } else {
          var mutatedDirectory = false;
          if (v.charAt(0) === "/") {
            v = v.substring(1);
          }
          if (v.match(/\.?\//)) {
            mutatedDirectory = true;
          }
          var replace = new RegExp(escapeRegEx(this.filename()) + "$");
          v = URI.recodePath(v);
          this._parts.path = this._parts.path.replace(replace, v);
          if (mutatedDirectory) {
            this.normalizePath(build);
          } else {
            this.build(!build);
          }
          return this;
        }
      };
      p.suffix = function(v, build) {
        if (this._parts.urn) {
          return v === void 0 ? "" : this;
        }
        if (v === void 0 || v === true) {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var filename = this.filename();
          var pos = filename.lastIndexOf(".");
          var s, res;
          if (pos === -1) {
            return "";
          }
          s = filename.substring(pos + 1);
          res = /^[a-z0-9%]+$/i.test(s) ? s : "";
          return v ? URI.decodePathSegment(res) : res;
        } else {
          if (v.charAt(0) === ".") {
            v = v.substring(1);
          }
          var suffix = this.suffix();
          var replace;
          if (!suffix) {
            if (!v) {
              return this;
            }
            this._parts.path += "." + URI.recodePath(v);
          } else if (!v) {
            replace = new RegExp(escapeRegEx("." + suffix) + "$");
          } else {
            replace = new RegExp(escapeRegEx(suffix) + "$");
          }
          if (replace) {
            v = URI.recodePath(v);
            this._parts.path = this._parts.path.replace(replace, v);
          }
          this.build(!build);
          return this;
        }
      };
      p.segment = function(segment, v, build) {
        var separator = this._parts.urn ? ":" : "/";
        var path = this.path();
        var absolute = path.substring(0, 1) === "/";
        var segments = path.split(separator);
        if (segment !== void 0 && typeof segment !== "number") {
          build = v;
          v = segment;
          segment = void 0;
        }
        if (segment !== void 0 && typeof segment !== "number") {
          throw new Error('Bad segment "' + segment + '", must be 0-based integer');
        }
        if (absolute) {
          segments.shift();
        }
        if (segment < 0) {
          segment = Math.max(segments.length + segment, 0);
        }
        if (v === void 0) {
          return segment === void 0 ? segments : segments[segment];
        } else if (segment === null || segments[segment] === void 0) {
          if (isArray(v)) {
            segments = [];
            for (var i = 0, l = v.length; i < l; i++) {
              if (!v[i].length && (!segments.length || !segments[segments.length - 1].length)) {
                continue;
              }
              if (segments.length && !segments[segments.length - 1].length) {
                segments.pop();
              }
              segments.push(trimSlashes(v[i]));
            }
          } else if (v || typeof v === "string") {
            v = trimSlashes(v);
            if (segments[segments.length - 1] === "") {
              segments[segments.length - 1] = v;
            } else {
              segments.push(v);
            }
          }
        } else {
          if (v) {
            segments[segment] = trimSlashes(v);
          } else {
            segments.splice(segment, 1);
          }
        }
        if (absolute) {
          segments.unshift("");
        }
        return this.path(segments.join(separator), build);
      };
      p.segmentCoded = function(segment, v, build) {
        var segments, i, l;
        if (typeof segment !== "number") {
          build = v;
          v = segment;
          segment = void 0;
        }
        if (v === void 0) {
          segments = this.segment(segment, v, build);
          if (!isArray(segments)) {
            segments = segments !== void 0 ? URI.decode(segments) : void 0;
          } else {
            for (i = 0, l = segments.length; i < l; i++) {
              segments[i] = URI.decode(segments[i]);
            }
          }
          return segments;
        }
        if (!isArray(v)) {
          v = typeof v === "string" || v instanceof String ? URI.encode(v) : v;
        } else {
          for (i = 0, l = v.length; i < l; i++) {
            v[i] = URI.encode(v[i]);
          }
        }
        return this.segment(segment, v, build);
      };
      var q = p.query;
      p.query = function(v, build) {
        if (v === true) {
          return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        } else if (typeof v === "function") {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          var result = v.call(this, data);
          this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else if (v !== void 0 && typeof v !== "string") {
          this._parts.query = URI.buildQuery(v, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else {
          return q.call(this, v, build);
        }
      };
      p.setQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        if (typeof name === "string" || name instanceof String) {
          data[name] = value !== void 0 ? value : null;
        } else if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              data[key] = name[key];
            }
          }
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.addQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.addQuery(data, name, value === void 0 ? null : value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.removeQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.removeQuery(data, name, value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.hasQuery = function(name, value, withinArray) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        return URI.hasQuery(data, name, value, withinArray);
      };
      p.setSearch = p.setQuery;
      p.addSearch = p.addQuery;
      p.removeSearch = p.removeQuery;
      p.hasSearch = p.hasQuery;
      p.normalize = function() {
        if (this._parts.urn) {
          return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
        }
        return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
      };
      p.normalizeProtocol = function(build) {
        if (typeof this._parts.protocol === "string") {
          this._parts.protocol = this._parts.protocol.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizeHostname = function(build) {
        if (this._parts.hostname) {
          if (this.is("IDN") && punycode) {
            this._parts.hostname = punycode.toASCII(this._parts.hostname);
          } else if (this.is("IPv6") && IPv6) {
            this._parts.hostname = IPv6.best(this._parts.hostname);
          }
          this._parts.hostname = this._parts.hostname.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizePort = function(build) {
        if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
          this._parts.port = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizePath = function(build) {
        var _path = this._parts.path;
        if (!_path) {
          return this;
        }
        if (this._parts.urn) {
          this._parts.path = URI.recodeUrnPath(this._parts.path);
          this.build(!build);
          return this;
        }
        if (this._parts.path === "/") {
          return this;
        }
        _path = URI.recodePath(_path);
        var _was_relative;
        var _leadingParents = "";
        var _parent, _pos;
        if (_path.charAt(0) !== "/") {
          _was_relative = true;
          _path = "/" + _path;
        }
        if (_path.slice(-3) === "/.." || _path.slice(-2) === "/.") {
          _path += "/";
        }
        _path = _path.replace(/(\/(\.\/)+)|(\/\.$)/g, "/").replace(/\/{2,}/g, "/");
        if (_was_relative) {
          _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || "";
          if (_leadingParents) {
            _leadingParents = _leadingParents[0];
          }
        }
        while (true) {
          _parent = _path.search(/\/\.\.(\/|$)/);
          if (_parent === -1) {
            break;
          } else if (_parent === 0) {
            _path = _path.substring(3);
            continue;
          }
          _pos = _path.substring(0, _parent).lastIndexOf("/");
          if (_pos === -1) {
            _pos = _parent;
          }
          _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
        }
        if (_was_relative && this.is("relative")) {
          _path = _leadingParents + _path.substring(1);
        }
        this._parts.path = _path;
        this.build(!build);
        return this;
      };
      p.normalizePathname = p.normalizePath;
      p.normalizeQuery = function(build) {
        if (typeof this._parts.query === "string") {
          if (!this._parts.query.length) {
            this._parts.query = null;
          } else {
            this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
          }
          this.build(!build);
        }
        return this;
      };
      p.normalizeFragment = function(build) {
        if (!this._parts.fragment) {
          this._parts.fragment = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizeSearch = p.normalizeQuery;
      p.normalizeHash = p.normalizeFragment;
      p.iso8859 = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = escape;
        URI.decode = decodeURIComponent;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.unicode = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = strictEncodeURIComponent;
        URI.decode = unescape;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.readable = function() {
        var uri = this.clone();
        uri.username("").password("").normalize();
        var t = "";
        if (uri._parts.protocol) {
          t += uri._parts.protocol + "://";
        }
        if (uri._parts.hostname) {
          if (uri.is("punycode") && punycode) {
            t += punycode.toUnicode(uri._parts.hostname);
            if (uri._parts.port) {
              t += ":" + uri._parts.port;
            }
          } else {
            t += uri.host();
          }
        }
        if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== "/") {
          t += "/";
        }
        t += uri.path(true);
        if (uri._parts.query) {
          var q2 = "";
          for (var i = 0, qp = uri._parts.query.split("&"), l = qp.length; i < l; i++) {
            var kv = (qp[i] || "").split("=");
            q2 += "&" + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            if (kv[1] !== void 0) {
              q2 += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            }
          }
          t += "?" + q2.substring(1);
        }
        t += URI.decodeQuery(uri.hash(), true);
        return t;
      };
      p.absoluteTo = function(base) {
        var resolved = this.clone();
        var properties = ["protocol", "username", "password", "hostname", "port"];
        var basedir, i, p2;
        if (this._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        if (!(base instanceof URI)) {
          base = new URI(base);
        }
        if (resolved._parts.protocol) {
          return resolved;
        } else {
          resolved._parts.protocol = base._parts.protocol;
        }
        if (this._parts.hostname) {
          return resolved;
        }
        for (i = 0; p2 = properties[i]; i++) {
          resolved._parts[p2] = base._parts[p2];
        }
        if (!resolved._parts.path) {
          resolved._parts.path = base._parts.path;
          if (!resolved._parts.query) {
            resolved._parts.query = base._parts.query;
          }
        } else {
          if (resolved._parts.path.substring(-2) === "..") {
            resolved._parts.path += "/";
          }
          if (resolved.path().charAt(0) !== "/") {
            basedir = base.directory();
            basedir = basedir ? basedir : base.path().indexOf("/") === 0 ? "/" : "";
            resolved._parts.path = (basedir ? basedir + "/" : "") + resolved._parts.path;
            resolved.normalizePath();
          }
        }
        resolved.build();
        return resolved;
      };
      p.relativeTo = function(base) {
        var relative = this.clone().normalize();
        var relativeParts, baseParts, common, relativePath, basePath;
        if (relative._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        base = new URI(base).normalize();
        relativeParts = relative._parts;
        baseParts = base._parts;
        relativePath = relative.path();
        basePath = base.path();
        if (relativePath.charAt(0) !== "/") {
          throw new Error("URI is already relative");
        }
        if (basePath.charAt(0) !== "/") {
          throw new Error("Cannot calculate a URI relative to another relative URI");
        }
        if (relativeParts.protocol === baseParts.protocol) {
          relativeParts.protocol = null;
        }
        if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
          return relative.build();
        }
        if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
          return relative.build();
        }
        if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
          relativeParts.hostname = null;
          relativeParts.port = null;
        } else {
          return relative.build();
        }
        if (relativePath === basePath) {
          relativeParts.path = "";
          return relative.build();
        }
        common = URI.commonPath(relativePath, basePath);
        if (!common) {
          return relative.build();
        }
        var parents = baseParts.path.substring(common.length).replace(/[^\/]*$/, "").replace(/.*?\//g, "../");
        relativeParts.path = parents + relativeParts.path.substring(common.length) || "./";
        return relative.build();
      };
      p.equals = function(uri) {
        var one = this.clone();
        var two = new URI(uri);
        var one_map = {};
        var two_map = {};
        var checked = {};
        var one_query, two_query, key;
        one.normalize();
        two.normalize();
        if (one.toString() === two.toString()) {
          return true;
        }
        one_query = one.query();
        two_query = two.query();
        one.query("");
        two.query("");
        if (one.toString() !== two.toString()) {
          return false;
        }
        if (one_query.length !== two_query.length) {
          return false;
        }
        one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
        two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);
        for (key in one_map) {
          if (hasOwn.call(one_map, key)) {
            if (!isArray(one_map[key])) {
              if (one_map[key] !== two_map[key]) {
                return false;
              }
            } else if (!arraysEqual(one_map[key], two_map[key])) {
              return false;
            }
            checked[key] = true;
          }
        }
        for (key in two_map) {
          if (hasOwn.call(two_map, key)) {
            if (!checked[key]) {
              return false;
            }
          }
        }
        return true;
      };
      p.preventInvalidHostname = function(v) {
        this._parts.preventInvalidHostname = !!v;
        return this;
      };
      p.duplicateQueryParameters = function(v) {
        this._parts.duplicateQueryParameters = !!v;
        return this;
      };
      p.escapeQuerySpace = function(v) {
        this._parts.escapeQuerySpace = !!v;
        return this;
      };
      return URI;
    });
  }
});

// node_modules/mersenne-twister/src/mersenne-twister.js
var require_mersenne_twister = __commonJS({
  "node_modules/mersenne-twister/src/mersenne-twister.js"(exports, module) {
    var MersenneTwister2 = function(seed) {
      if (seed == void 0) {
        seed = (/* @__PURE__ */ new Date()).getTime();
      }
      this.N = 624;
      this.M = 397;
      this.MATRIX_A = 2567483615;
      this.UPPER_MASK = 2147483648;
      this.LOWER_MASK = 2147483647;
      this.mt = new Array(this.N);
      this.mti = this.N + 1;
      if (seed.constructor == Array) {
        this.init_by_array(seed, seed.length);
      } else {
        this.init_seed(seed);
      }
    };
    MersenneTwister2.prototype.init_seed = function(s) {
      this.mt[0] = s >>> 0;
      for (this.mti = 1; this.mti < this.N; this.mti++) {
        var s = this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30;
        this.mt[this.mti] = (((s & 4294901760) >>> 16) * 1812433253 << 16) + (s & 65535) * 1812433253 + this.mti;
        this.mt[this.mti] >>>= 0;
      }
    };
    MersenneTwister2.prototype.init_by_array = function(init_key, key_length) {
      var i, j, k;
      this.init_seed(19650218);
      i = 1;
      j = 0;
      k = this.N > key_length ? this.N : key_length;
      for (; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1664525 << 16) + (s & 65535) * 1664525) + init_key[j] + j;
        this.mt[i] >>>= 0;
        i++;
        j++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
        if (j >= key_length) j = 0;
      }
      for (k = this.N - 1; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1566083941 << 16) + (s & 65535) * 1566083941) - i;
        this.mt[i] >>>= 0;
        i++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
      }
      this.mt[0] = 2147483648;
    };
    MersenneTwister2.prototype.random_int = function() {
      var y;
      var mag01 = new Array(0, this.MATRIX_A);
      if (this.mti >= this.N) {
        var kk;
        if (this.mti == this.N + 1)
          this.init_seed(5489);
        for (kk = 0; kk < this.N - this.M; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + this.M] ^ y >>> 1 ^ mag01[y & 1];
        }
        for (; kk < this.N - 1; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + (this.M - this.N)] ^ y >>> 1 ^ mag01[y & 1];
        }
        y = this.mt[this.N - 1] & this.UPPER_MASK | this.mt[0] & this.LOWER_MASK;
        this.mt[this.N - 1] = this.mt[this.M - 1] ^ y >>> 1 ^ mag01[y & 1];
        this.mti = 0;
      }
      y = this.mt[this.mti++];
      y ^= y >>> 11;
      y ^= y << 7 & 2636928640;
      y ^= y << 15 & 4022730752;
      y ^= y >>> 18;
      return y >>> 0;
    };
    MersenneTwister2.prototype.random_int31 = function() {
      return this.random_int() >>> 1;
    };
    MersenneTwister2.prototype.random_incl = function() {
      return this.random_int() * (1 / 4294967295);
    };
    MersenneTwister2.prototype.random = function() {
      return this.random_int() * (1 / 4294967296);
    };
    MersenneTwister2.prototype.random_excl = function() {
      return (this.random_int() + 0.5) * (1 / 4294967296);
    };
    MersenneTwister2.prototype.random_long = function() {
      var a = this.random_int() >>> 5, b = this.random_int() >>> 6;
      return (a * 67108864 + b) * (1 / 9007199254740992);
    };
    module.exports = MersenneTwister2;
  }
});

// packages/engine/Specs/Core/ApproximateTerrainHeightsSpec.js
var import__ = __toESM(require_Cesium(), 1);
describe("Core/ApproximateTerrainHeights", function() {
  beforeAll(function() {
    return import__.ApproximateTerrainHeights.initialize();
  });
  afterAll(function() {
    import__.ApproximateTerrainHeights._initPromise = void 0;
    import__.ApproximateTerrainHeights._terrainHeights = void 0;
  });
  it("initializes", function() {
    return import__.ApproximateTerrainHeights.initialize().then(function() {
      expect(import__.ApproximateTerrainHeights._terrainHeights).toBeDefined();
    });
  });
  it("getMinimumMaximumHeights computes minimum and maximum terrain heights", function() {
    const result = import__.ApproximateTerrainHeights.getMinimumMaximumHeights(
      import__.Rectangle.fromDegrees(-121, 10, -120, 11)
    );
    expect(result.minimumTerrainHeight).toEqualEpsilon(
      -5269.86,
      import__.Math.EPSILON8
    );
    expect(result.maximumTerrainHeight).toEqualEpsilon(
      -28.53,
      import__.Math.EPSILON8
    );
  });
  it("getMinimumMaximumHeights throws with no rectangle", function() {
    expect(function() {
      return import__.ApproximateTerrainHeights.getMinimumMaximumHeights();
    }).toThrowDeveloperError();
  });
  it("getMinimumMaximumHeights throws if ApproximateTerrainHeights was not initialized first", function() {
    const heights = import__.ApproximateTerrainHeights._terrainHeights;
    import__.ApproximateTerrainHeights._terrainHeights = void 0;
    expect(function() {
      return import__.ApproximateTerrainHeights.getMinimumMaximumHeights(
        import__.Rectangle.fromDegrees(-121, 10, -120, 11)
      );
    });
    import__.ApproximateTerrainHeights._terrainHeights = heights;
  });
  it("getBoundingSphere computes a bounding sphere", function() {
    const result = import__.ApproximateTerrainHeights.getBoundingSphere(
      import__.Rectangle.fromDegrees(-121, 10, -120, 11)
    );
    expect(result.center).toEqualEpsilon(
      new import__.Cartesian3(
        -3183013849117281e-9,
        -5403772559109628e-9,
        1.1545815821590829e6
      ),
      import__.Math.EPSILON8
    );
    expect(result.radius).toEqualEpsilon(
      77884.16321007285,
      import__.Math.EPSILON8
    );
  });
  it("getBoundingSphere throws with no rectangle", function() {
    expect(function() {
      return import__.ApproximateTerrainHeights.getBoundingSphere();
    }).toThrowDeveloperError();
  });
  it("getBoundingSphere throws if ApproximateTerrainHeights was not initialized first", function() {
    const heights = import__.ApproximateTerrainHeights._terrainHeights;
    import__.ApproximateTerrainHeights._terrainHeights = void 0;
    expect(function() {
      return import__.ApproximateTerrainHeights.getBoundingSphere(
        import__.Rectangle.fromDegrees(-121, 10, -120, 11)
      );
    });
    import__.ApproximateTerrainHeights._terrainHeights = heights;
  });
});

// packages/engine/Specs/Core/ArcGISTiledElevationTerrainProviderSpec.js
var import__2 = __toESM(require_Cesium(), 1);
describe("Core/ArcGISTiledElevationTerrainProvider", function() {
  const lercTileUrl = "Data/Images/Red16x16.png";
  let availability;
  let metadata;
  beforeEach(function() {
    availability = {
      data: []
    };
    availability.data.length = 128 * 128;
    availability.data.fill(1);
    metadata = {
      currentVersion: 10.3,
      serviceDescription: "Test",
      name: "Test",
      description: "Test",
      extent: {
        xmin: -20037507842788246e-9,
        ymin: -20037508659999996e-9,
        xmax: 20037509157211754e-9,
        ymax: 20037508340000004e-9,
        spatialReference: {
          wkid: 102100,
          latestWkid: 3857
        }
      },
      bandCount: 1,
      copyrightText: "Source: USGS, NGA, NASA, CGIAR, GEBCO,N Robinson,NCEAS,NLS,OS,NMA,Geodatastyrelsen and the GIS User Community",
      minValues: [-450],
      maxValues: [8700],
      capabilities: "Image,Tilemap,Mensuration",
      tileInfo: {
        rows: 256,
        cols: 256,
        format: "LERC",
        lods: [
          {
            level: 0,
            resolution: 156543.03392800014,
            scale: 591657527591555e-6
          },
          {
            level: 1,
            resolution: 78271.51696399994,
            scale: 295828763795777e-6
          },
          {
            level: 2,
            resolution: 39135.75848200009,
            scale: 147914381897889e-6
          },
          {
            level: 3,
            resolution: 19567.87924099992,
            scale: 73957190948944e-6
          },
          {
            level: 4,
            resolution: 9783.93962049996,
            scale: 36978595474472e-6
          },
          {
            level: 5,
            resolution: 4891.96981024998,
            scale: 18489297737236e-6
          },
          {
            level: 6,
            resolution: 2445.98490512499,
            scale: 9244648868618e-6
          },
          {
            level: 7,
            resolution: 1222.992452562495,
            scale: 4622324434309e-6
          },
          {
            level: 8,
            resolution: 611.4962262813797,
            scale: 2311162217155e-6
          },
          {
            level: 9,
            resolution: 305.74811314055756,
            scale: 1155581108577e-6
          },
          {
            level: 10,
            resolution: 152.87405657041106,
            scale: 577790.554289
          },
          {
            level: 11,
            resolution: 76.43702828507324,
            scale: 288895.277144
          },
          {
            level: 12,
            resolution: 38.21851414253662,
            scale: 144447.638572
          },
          {
            level: 13,
            resolution: 19.10925707126831,
            scale: 72223.819286
          },
          {
            level: 14,
            resolution: 9.554628535634155,
            scale: 36111.909643
          },
          {
            level: 15,
            resolution: 4.77731426794937,
            scale: 18055.954822
          },
          {
            level: 16,
            resolution: 2.388657133974685,
            scale: 9027.977411
          }
        ]
      },
      spatialReference: {
        wkid: 3857,
        latestWkid: 3857
      }
    };
    import__2.RequestScheduler.clearForSpecs();
    import__2.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
      if (url.indexOf("/tile/") !== -1) {
        import__2.Resource._DefaultImplementations.loadWithXhr(
          lercTileUrl,
          responseType,
          method,
          data,
          headers,
          deferred,
          overrideMimeType
        );
        return;
      }
      if (url.indexOf("/tilemap/") !== -1) {
        setTimeout(function() {
          deferred.resolve(JSON.stringify(availability));
        }, 1);
        return;
      }
      setTimeout(function() {
        deferred.resolve(JSON.stringify(metadata));
      }, 1);
    };
  });
  afterEach(function() {
    import__2.Resource._Implementations.createImage = import__2.Resource._DefaultImplementations.createImage;
    import__2.Resource._Implementations.loadWithXhr = import__2.Resource._DefaultImplementations.loadWithXhr;
  });
  function createRequest() {
    return new import__2.Request({
      throttleByServer: true
    });
  }
  it("conforms to TerrainProvider interface", function() {
    expect(import__2.ArcGISTiledElevationTerrainProvider).toConformToInterface(
      import__2.TerrainProvider
    );
  });
  it("fromUrl throws without url", async function() {
    await expectAsync(
      import__2.ArcGISTiledElevationTerrainProvider.fromUrl()
    ).toBeRejectedWithDeveloperError(
      "url is required, actual value was undefined"
    );
  });
  it("fromUrl resolves to new ArcGISTiledElevationTerrainProvider", async function() {
    const provider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      "made/up/url"
    );
    expect(provider).toBeInstanceOf(import__2.ArcGISTiledElevationTerrainProvider);
  });
  it("fromUrl with resource resolves to new ArcGISTiledElevationTerrainProvider", async function() {
    const resource = new import__2.Resource({
      url: "made/up/url"
    });
    const provider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      resource
    );
    expect(provider).toBeInstanceOf(import__2.ArcGISTiledElevationTerrainProvider);
  });
  it("fromUrl resolves with url promise", async function() {
    const provider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      Promise.resolve("made/up/url")
    );
    expect(provider).toBeInstanceOf(import__2.ArcGISTiledElevationTerrainProvider);
  });
  it("fromUrl rejects if url rejects", async function() {
    await expectAsync(
      import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
        Promise.reject(new Error("my message"))
      )
    ).toBeRejectedWithError("my message");
  });
  it("has error event", async function() {
    const provider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      "made/up/url"
    );
    expect(provider.errorEvent).toBeDefined();
    expect(provider.errorEvent).toBe(provider.errorEvent);
  });
  it("returns reasonable geometric error for various levels", async function() {
    const provider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      "made/up/url"
    );
    expect(provider.getLevelMaximumGeometricError(0)).toBeGreaterThan(0);
    expect(provider.getLevelMaximumGeometricError(0)).toEqualEpsilon(
      provider.getLevelMaximumGeometricError(1) * 2,
      import__2.Math.EPSILON10
    );
    expect(provider.getLevelMaximumGeometricError(1)).toEqualEpsilon(
      provider.getLevelMaximumGeometricError(2) * 2,
      import__2.Math.EPSILON10
    );
  });
  it("logo is undefined if credit is not provided", async function() {
    delete metadata.copyrightText;
    const provider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      "made/up/url"
    );
    expect(provider.credit).toBeUndefined();
  });
  it("logo is defined if credit is provided", async function() {
    const provider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      "made/up/url",
      {
        credit: "thanks to our awesome made up contributors!"
      }
    );
    expect(provider.credit).toBeDefined();
  });
  it("does not have a water mask", async function() {
    const provider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      "made/up/url"
    );
    expect(provider.hasWaterMask).toBe(false);
  });
  it("detects WebMercator tiling scheme", async function() {
    const baseUrl = "made/up/url";
    const terrainProvider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      baseUrl
    );
    expect(terrainProvider.tilingScheme).toBeInstanceOf(
      import__2.WebMercatorTilingScheme
    );
  });
  it("detects Geographic tiling scheme", async function() {
    const baseUrl = "made/up/url";
    metadata.spatialReference.latestWkid = 4326;
    const terrainProvider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      baseUrl
    );
    expect(terrainProvider.tilingScheme).toBeInstanceOf(import__2.GeographicTilingScheme);
  });
  it("fromUrl throws if the SRS is not supported", async function() {
    const baseUrl = "made/up/url";
    metadata.spatialReference.latestWkid = 1234;
    await expectAsync(
      import__2.ArcGISTiledElevationTerrainProvider.fromUrl(baseUrl)
    ).toBeRejectedWithError(import__2.RuntimeError, "Invalid spatial reference");
  });
  it("fromUrl throws if tileInfo missing", async function() {
    const baseUrl = "made/up/url";
    delete metadata.tileInfo;
    await expectAsync(
      import__2.ArcGISTiledElevationTerrainProvider.fromUrl(baseUrl)
    ).toBeRejectedWithError(import__2.RuntimeError, "tileInfo is required");
  });
  it("checks availability if TileMap capability exists", async function() {
    const baseUrl = "made/up/url";
    const terrainProvider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      baseUrl
    );
    expect(terrainProvider._hasAvailability).toBe(true);
    expect(terrainProvider._tilesAvailable).toBeDefined();
    expect(terrainProvider._tilesAvailabilityLoaded).toBeDefined();
  });
  it("does not check availability if TileMap capability is missing", async function() {
    const baseUrl = "made/up/url";
    metadata.capabilities = "Image,Mensuration";
    const terrainProvider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
      baseUrl
    );
    expect(terrainProvider._hasAvailability).toBe(false);
    expect(terrainProvider._tilesAvailable).toBeUndefined();
    expect(terrainProvider._tilesAvailablityLoaded).toBeUndefined();
  });
  describe("requestTileGeometry", function() {
    it("provides HeightmapTerrainData", async function() {
      const baseUrl = "made/up/url";
      const terrainProvider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
        baseUrl
      );
      const promise = terrainProvider.requestTileGeometry(0, 0, 0);
      import__2.RequestScheduler.update();
      const loadedData = await promise;
      expect(loadedData).toBeInstanceOf(import__2.HeightmapTerrainData);
    });
    it("returns undefined if too many requests are already in progress", async function() {
      const baseUrl = "made/up/url";
      const deferreds = [];
      import__2.Resource._Implementations.createImage = function(request, crossOrigin, deferred) {
        deferreds.push(deferred);
      };
      const terrainProvider = await import__2.ArcGISTiledElevationTerrainProvider.fromUrl(
        baseUrl
      );
      let promise;
      let i;
      for (i = 0; i < import__2.RequestScheduler.maximumRequestsPerServer - 1; ++i) {
        const request = new import__2.Request({
          throttle: true,
          throttleByServer: true
        });
        promise = terrainProvider.requestTileGeometry(0, 0, 0, request);
      }
      import__2.RequestScheduler.update();
      expect(promise).toBeDefined();
      promise = terrainProvider.requestTileGeometry(0, 0, 0, createRequest());
      expect(promise).toBeUndefined();
      for (i = 0; i < deferreds.length; ++i) {
        deferreds[i].resolve();
      }
      await Promise.all(
        deferreds.map(function(deferred) {
          return deferred.promise;
        })
      );
    });
  });
});

// packages/engine/Specs/Core/AssociativeArraySpec.js
var import__3 = __toESM(require_Cesium(), 1);
describe("Core/AssociativeArray", function() {
  it("constructor has expected default values", function() {
    const associativeArray = new import__3.AssociativeArray();
    expect(associativeArray.length).toEqual(0);
    expect(associativeArray.values).toEqual([]);
  });
  it("can manipulate values", function() {
    const associativeArray = new import__3.AssociativeArray();
    expect(associativeArray.contains("key1")).toEqual(false);
    associativeArray.set("key1", 1);
    associativeArray.set("key2", 2);
    associativeArray.set("key3", 3);
    expect(associativeArray.get("key1")).toEqual(1);
    expect(associativeArray.get("key2")).toEqual(2);
    expect(associativeArray.get("key3")).toEqual(3);
    expect(associativeArray.length).toEqual(3);
    expect(associativeArray.contains("key1")).toEqual(true);
    expect(associativeArray.contains("key2")).toEqual(true);
    expect(associativeArray.contains("key3")).toEqual(true);
    const values = associativeArray.values;
    expect(values).toContain(1);
    expect(values).toContain(2);
    expect(values).toContain(3);
    expect(values.length).toEqual(3);
    associativeArray.set("key2", 4);
    expect(associativeArray.length).toEqual(3);
    expect(values).toContain(1);
    expect(values).not.toContain(2);
    expect(values).toContain(4);
    expect(values).toContain(3);
    expect(values.length).toEqual(3);
    expect(associativeArray.remove("key1")).toBe(true);
    expect(associativeArray.get("key1")).toBeUndefined();
    expect(associativeArray.contains("key1")).toEqual(false);
    expect(values).not.toContain(1);
    expect(values).toContain(4);
    expect(values).toContain(3);
    expect(values.length).toEqual(2);
    expect(associativeArray.remove("key1")).toBe(false);
    associativeArray.removeAll();
    expect(associativeArray.length).toEqual(0);
    expect(associativeArray.values).toEqual([]);
  });
  it("set throws with undefined key", function() {
    const associativeArray = new import__3.AssociativeArray();
    expect(function() {
      associativeArray.set(void 0, 1);
    }).toThrowDeveloperError();
  });
  it("get throws with undefined key", function() {
    const associativeArray = new import__3.AssociativeArray();
    expect(function() {
      associativeArray.get(void 0);
    }).toThrowDeveloperError();
  });
  it("remove returns false with undefined key", function() {
    const associativeArray = new import__3.AssociativeArray();
    expect(associativeArray.remove(void 0)).toBe(false);
  });
});

// packages/engine/Specs/Core/AttributeCompressionSpec.js
var import__4 = __toESM(require_Cesium(), 1);
describe("Core/AttributeCompression", function() {
  const negativeUnitZ = new import__4.Cartesian3(0, 0, -1);
  it("oct decode(0, 0)", function() {
    const result = new import__4.Cartesian3();
    import__4.AttributeCompression.octDecode(0, 0, result);
    expect(result).toEqual(negativeUnitZ);
  });
  it("oct encode(0, 0, -1)", function() {
    const result = new import__4.Cartesian2();
    import__4.AttributeCompression.octEncode(negativeUnitZ, result);
    expect(result).toEqual(new import__4.Cartesian2(255, 255));
  });
  it("oct encode(0, 0, 1)", function() {
    const result = new import__4.Cartesian2();
    import__4.AttributeCompression.octEncode(import__4.Cartesian3.UNIT_Z, result);
    expect(result).toEqual(new import__4.Cartesian2(128, 128));
  });
  it("oct encode(0, 0, -1) to 4 components", function() {
    const result = new import__4.Cartesian4();
    import__4.AttributeCompression.octEncodeToCartesian4(negativeUnitZ, result);
    expect(result).toEqual(new import__4.Cartesian4(255, 255, 255, 255));
  });
  it("oct encode(0, 0, 1) to 4 components", function() {
    const result = new import__4.Cartesian4();
    import__4.AttributeCompression.octEncodeToCartesian4(import__4.Cartesian3.UNIT_Z, result);
    expect(result).toEqual(new import__4.Cartesian4(128, 0, 128, 0));
  });
  it("oct extents are equal", function() {
    const result = new import__4.Cartesian3();
    import__4.AttributeCompression.octDecode(0, 0, result);
    expect(result).toEqual(negativeUnitZ);
    import__4.AttributeCompression.octDecode(255, 0, result);
    expect(result).toEqual(negativeUnitZ);
    import__4.AttributeCompression.octDecode(255, 255, result);
    expect(result).toEqual(negativeUnitZ);
    import__4.AttributeCompression.octDecode(255, 0, result);
    expect(result).toEqual(negativeUnitZ);
  });
  it("throws oct encode vector undefined", function() {
    let vector;
    const result = new import__4.Cartesian3();
    expect(function() {
      import__4.AttributeCompression.octEncode(vector, result);
    }).toThrowDeveloperError();
  });
  it("throws oct encode result undefined", function() {
    let result;
    expect(function() {
      import__4.AttributeCompression.octEncode(import__4.Cartesian3.UNIT_Z, result);
    }).toThrowDeveloperError();
  });
  it("throws oct encode non unit vector", function() {
    const nonUnitLengthVector = new import__4.Cartesian3(2, 0, 0);
    const result = new import__4.Cartesian2();
    expect(function() {
      import__4.AttributeCompression.octEncode(nonUnitLengthVector, result);
    }).toThrowDeveloperError();
  });
  it("throws oct encode zero length vector", function() {
    const result = new import__4.Cartesian2();
    expect(function() {
      import__4.AttributeCompression.octEncode(import__4.Cartesian3.ZERO, result);
    }).toThrowDeveloperError();
  });
  it("throws oct decode result undefined", function() {
    let result;
    expect(function() {
      import__4.AttributeCompression.octDecode(0, 0, result);
    }).toThrowDeveloperError();
  });
  it("throws oct decode x out of bounds", function() {
    const result = new import__4.Cartesian3();
    expect(function() {
      import__4.AttributeCompression.octDecode(256, 0, result);
    }).toThrowDeveloperError();
  });
  it("throws oct decode y out of bounds", function() {
    const result = new import__4.Cartesian3();
    expect(function() {
      import__4.AttributeCompression.octDecode(0, 256, result);
    }).toThrowDeveloperError();
  });
  it("throws 4-component oct decode out of bounds", function() {
    const result = new import__4.Cartesian3();
    expect(function() {
      import__4.AttributeCompression.octDecodeFromCartesian4(
        new import__4.Cartesian4(256, 0, 0, 0),
        result
      );
    }).toThrowDeveloperError();
    expect(function() {
      import__4.AttributeCompression.octDecodeFromCartesian4(
        new import__4.Cartesian4(0, 256, 0, 0),
        result
      );
    }).toThrowDeveloperError();
    expect(function() {
      import__4.AttributeCompression.octDecodeFromCartesian4(
        new import__4.Cartesian4(0, 0, 256, 0),
        result
      );
    }).toThrowDeveloperError();
    expect(function() {
      import__4.AttributeCompression.octDecodeFromCartesian4(
        new import__4.Cartesian4(0, 0, 0, 256),
        result
      );
    }).toThrowDeveloperError();
  });
  it("oct encoding", function() {
    const epsilon = import__4.Math.EPSILON1;
    const encoded = new import__4.Cartesian2();
    const result = new import__4.Cartesian3();
    let normal = new import__4.Cartesian3(0, 0, 1);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, 0, -1);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, 1, 0);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, -1, 0);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 0, 0);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 0, 0);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result)
    ).toEqualEpsilon(normal, epsilon);
  });
  it("oct encoding high precision", function() {
    const rangeMax = 4294967295;
    const epsilon = import__4.Math.EPSILON8;
    const encoded = new import__4.Cartesian2();
    const result = new import__4.Cartesian3();
    let normal = new import__4.Cartesian3(0, 0, 1);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, 0, -1);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, 1, 0);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, -1, 0);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 0, 0);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 0, 0);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeInRange(normal, rangeMax, encoded);
    expect(
      import__4.AttributeCompression.octDecodeInRange(
        encoded.x,
        encoded.y,
        rangeMax,
        result
      )
    ).toEqualEpsilon(normal, epsilon);
  });
  it("oct encoding to 4 components", function() {
    const epsilon = import__4.Math.EPSILON1;
    const encoded = new import__4.Cartesian4();
    const result = new import__4.Cartesian3();
    let normal = new import__4.Cartesian3(0, 0, 1);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, 0, -1);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, 1, 0);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, -1, 0);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 0, 0);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 0, 0);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncodeToCartesian4(normal, encoded);
    expect(
      import__4.AttributeCompression.octDecodeFromCartesian4(encoded, result)
    ).toEqualEpsilon(normal, epsilon);
  });
  it("octFloat encoding", function() {
    const epsilon = import__4.Math.EPSILON1;
    const result = new import__4.Cartesian3();
    let normal = new import__4.Cartesian3(0, 0, 1);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, 0, -1);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, 1, 0);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(0, -1, 0);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 0, 0);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 0, 0);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
    normal = new import__4.Cartesian3(-1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    expect(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(normal),
        result
      )
    ).toEqualEpsilon(normal, epsilon);
  });
  it("octFloat encoding is equivalent to oct encoding", function() {
    const encoded = new import__4.Cartesian2();
    const result1 = new import__4.Cartesian3();
    const result2 = new import__4.Cartesian3();
    let normal = new import__4.Cartesian3(0, 0, 1);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(0, 0, -1);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(0, 1, 0);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(0, -1, 0);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(1, 0, 0);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(-1, 0, 0);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(-1, -1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(-1, 1, 1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(-1, 1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
    normal = new import__4.Cartesian3(-1, -1, -1);
    import__4.Cartesian3.normalize(normal, normal);
    import__4.AttributeCompression.octEncode(normal, encoded);
    import__4.AttributeCompression.octDecode(encoded.x, encoded.y, result1);
    import__4.AttributeCompression.octDecodeFloat(
      import__4.AttributeCompression.octEncodeFloat(normal),
      result2
    );
    expect(result1).toEqual(result2);
  });
  it("encodeFloat throws without vector", function() {
    expect(function() {
      import__4.AttributeCompression.octEncodeFloat(void 0);
    }).toThrowDeveloperError();
  });
  it("decodeFloat throws without value", function() {
    expect(function() {
      import__4.AttributeCompression.octDecodeFloat(void 0, new import__4.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("decodeFloat throws without result", function() {
    expect(function() {
      import__4.AttributeCompression.octDecodeFloat(0, void 0);
    }).toThrowDeveloperError();
  });
  it("encode and packFloat is equivalent to oct encoding", function() {
    const vector = new import__4.Cartesian3(1, 1, 1);
    import__4.Cartesian3.normalize(vector, vector);
    const encoded = import__4.AttributeCompression.octEncode(vector, new import__4.Cartesian2());
    const encodedFloat = import__4.AttributeCompression.octPackFloat(encoded);
    expect(
      import__4.AttributeCompression.octDecodeFloat(encodedFloat, new import__4.Cartesian3())
    ).toEqual(
      import__4.AttributeCompression.octDecode(encoded.x, encoded.y, new import__4.Cartesian3())
    );
  });
  it("packFloat throws without encoded", function() {
    expect(function() {
      import__4.AttributeCompression.octPackFloat(void 0);
    }).toThrowDeveloperError();
  });
  it("pack is equivalent to oct encoding", function() {
    const x = import__4.Cartesian3.UNIT_X;
    const y = import__4.Cartesian3.UNIT_Y;
    const z = import__4.Cartesian3.UNIT_Z;
    const packed = import__4.AttributeCompression.octPack(x, y, z, new import__4.Cartesian2());
    const decodedX = new import__4.Cartesian3();
    const decodedY = new import__4.Cartesian3();
    const decodedZ = new import__4.Cartesian3();
    import__4.AttributeCompression.octUnpack(packed, decodedX, decodedY, decodedZ);
    expect(decodedX).toEqual(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(x),
        new import__4.Cartesian3()
      )
    );
    expect(decodedY).toEqual(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(y),
        new import__4.Cartesian3()
      )
    );
    expect(decodedZ).toEqual(
      import__4.AttributeCompression.octDecodeFloat(
        import__4.AttributeCompression.octEncodeFloat(z),
        new import__4.Cartesian3()
      )
    );
  });
  it("pack throws without v1", function() {
    expect(function() {
      import__4.AttributeCompression.octPack(
        void 0,
        new import__4.Cartesian3(),
        new import__4.Cartesian3(),
        new import__4.Cartesian2()
      );
    }).toThrowDeveloperError();
  });
  it("pack throws without v2", function() {
    expect(function() {
      import__4.AttributeCompression.octPack(
        new import__4.Cartesian3(),
        void 0,
        new import__4.Cartesian3(),
        new import__4.Cartesian2()
      );
    }).toThrowDeveloperError();
  });
  it("pack throws without v3", function() {
    expect(function() {
      import__4.AttributeCompression.octPack(
        new import__4.Cartesian3(),
        new import__4.Cartesian3(),
        void 0,
        new import__4.Cartesian2()
      );
    }).toThrowDeveloperError();
  });
  it("pack throws without result", function() {
    expect(function() {
      import__4.AttributeCompression.octPack(
        new import__4.Cartesian3(),
        new import__4.Cartesian3(),
        new import__4.Cartesian3(),
        void 0
      );
    }).toThrowDeveloperError();
  });
  it("unpack throws without packed", function() {
    expect(function() {
      import__4.AttributeCompression.octUnpack(
        void 0,
        new import__4.Cartesian3(),
        new import__4.Cartesian3(),
        new import__4.Cartesian3()
      );
    }).toThrowDeveloperError();
  });
  it("unpack throws without v1", function() {
    expect(function() {
      import__4.AttributeCompression.octUnpack(
        new import__4.Cartesian2(),
        void 0,
        new import__4.Cartesian3(),
        new import__4.Cartesian3()
      );
    }).toThrowDeveloperError();
  });
  it("unpack throws without v2", function() {
    expect(function() {
      import__4.AttributeCompression.octUnpack(
        new import__4.Cartesian2(),
        new import__4.Cartesian3(),
        void 0,
        new import__4.Cartesian3()
      );
    }).toThrowDeveloperError();
  });
  it("unpack throws without v3", function() {
    expect(function() {
      import__4.AttributeCompression.octUnpack(
        new import__4.Cartesian2(),
        new import__4.Cartesian3(),
        new import__4.Cartesian3(),
        void 0
      );
    }).toThrowDeveloperError();
  });
  it("compresses texture coordinates", function() {
    const coords = new import__4.Cartesian2(0.5, 0.5);
    expect(
      import__4.AttributeCompression.decompressTextureCoordinates(
        import__4.AttributeCompression.compressTextureCoordinates(coords),
        new import__4.Cartesian2()
      )
    ).toEqualEpsilon(coords, 1 / 4096);
  });
  it("compress texture coordinates throws without texture coordinates", function() {
    expect(function() {
      import__4.AttributeCompression.compressTextureCoordinates(void 0);
    }).toThrowDeveloperError();
  });
  it("decompress texture coordinates throws without encoded texture coordinates", function() {
    expect(function() {
      import__4.AttributeCompression.decompressTextureCoordinates(
        void 0,
        new import__4.Cartesian2()
      );
    }).toThrowDeveloperError();
  });
  it("decompress texture coordinates throws without result", function() {
    expect(function() {
      import__4.AttributeCompression.decompressTextureCoordinates(0, void 0);
    }).toThrowDeveloperError();
  });
  it("compresses/decompresses 1.0", function() {
    const coords = new import__4.Cartesian2(1, 1);
    expect(
      import__4.AttributeCompression.decompressTextureCoordinates(
        import__4.AttributeCompression.compressTextureCoordinates(coords),
        new import__4.Cartesian2()
      )
    ).toEqual(coords);
  });
  it("compresses/decompresses 0.0", function() {
    const coords = new import__4.Cartesian2(1, 1);
    expect(
      import__4.AttributeCompression.decompressTextureCoordinates(
        import__4.AttributeCompression.compressTextureCoordinates(coords),
        new import__4.Cartesian2()
      )
    ).toEqual(coords);
  });
  it("compresses/decompresses 0.5 / 1.0", function() {
    const coords = new import__4.Cartesian2(0.5, 1);
    expect(
      import__4.AttributeCompression.decompressTextureCoordinates(
        import__4.AttributeCompression.compressTextureCoordinates(coords),
        new import__4.Cartesian2()
      )
    ).toEqualEpsilon(coords, 1 / 4095);
  });
  it("compresses/decompresses 1.0 / 0.5", function() {
    const coords = new import__4.Cartesian2(1, 0.5);
    expect(
      import__4.AttributeCompression.decompressTextureCoordinates(
        import__4.AttributeCompression.compressTextureCoordinates(coords),
        new import__4.Cartesian2()
      )
    ).toEqualEpsilon(coords, 1 / 4095);
  });
  it("compresses/decompresses values very close but not equal to 1.0", function() {
    const coords = new import__4.Cartesian2(0.99999999999999, 0.99999999999999);
    expect(
      import__4.AttributeCompression.decompressTextureCoordinates(
        import__4.AttributeCompression.compressTextureCoordinates(coords),
        new import__4.Cartesian2()
      )
    ).toEqualEpsilon(coords, 1 / 4095);
  });
  function zigZag(value) {
    return (value << 1 ^ value >> 15) & 65535;
  }
  const maxShort = 32767;
  function deltaZigZagEncode(uBuffer, vBuffer, heightBuffer) {
    const length2 = uBuffer.length;
    const buffer = new Uint16Array(length2 * ((0, import__4.defined)(heightBuffer) ? 3 : 2));
    let lastU = 0;
    let lastV = 0;
    let lastHeight = 0;
    for (let i = 0; i < length2; ++i) {
      const u = uBuffer[i];
      const v = vBuffer[i];
      buffer[i] = zigZag(u - lastU);
      buffer[i + length2] = zigZag(v - lastV);
      lastU = u;
      lastV = v;
      if ((0, import__4.defined)(heightBuffer)) {
        const height = heightBuffer[i];
        buffer[i + length2 * 2] = zigZag(height - lastHeight);
        lastHeight = height;
      }
    }
    return buffer;
  }
  it("decodes delta and ZigZag encoded vertices without height", function() {
    const length2 = 10;
    const decodedUBuffer = new Array(length2);
    const decodedVBuffer = new Array(length2);
    for (let i = 0; i < length2; ++i) {
      decodedUBuffer[i] = Math.floor(Math.random() * maxShort);
      decodedVBuffer[i] = Math.floor(Math.random() * maxShort);
    }
    const encoded = deltaZigZagEncode(decodedUBuffer, decodedVBuffer);
    const uBuffer = new Uint16Array(encoded.buffer, 0, length2);
    const vBuffer = new Uint16Array(
      encoded.buffer,
      length2 * Uint16Array.BYTES_PER_ELEMENT,
      length2
    );
    import__4.AttributeCompression.zigZagDeltaDecode(uBuffer, vBuffer);
    expect(uBuffer).toEqual(decodedUBuffer);
    expect(vBuffer).toEqual(decodedVBuffer);
  });
  it("decodes delta and ZigZag encoded vertices with height", function() {
    const length2 = 10;
    const decodedUBuffer = new Array(length2);
    const decodedVBuffer = new Array(length2);
    const decodedHeightBuffer = new Array(length2);
    for (let i = 0; i < length2; ++i) {
      decodedUBuffer[i] = Math.floor(Math.random() * maxShort);
      decodedVBuffer[i] = Math.floor(Math.random() * maxShort);
      decodedHeightBuffer[i] = Math.floor(Math.random() * maxShort);
    }
    const encoded = deltaZigZagEncode(
      decodedUBuffer,
      decodedVBuffer,
      decodedHeightBuffer
    );
    const uBuffer = new Uint16Array(encoded.buffer, 0, length2);
    const vBuffer = new Uint16Array(
      encoded.buffer,
      length2 * Uint16Array.BYTES_PER_ELEMENT,
      length2
    );
    const heightBuffer = new Uint16Array(
      encoded.buffer,
      2 * length2 * Uint16Array.BYTES_PER_ELEMENT,
      length2
    );
    import__4.AttributeCompression.zigZagDeltaDecode(uBuffer, vBuffer, heightBuffer);
    expect(uBuffer).toEqual(decodedUBuffer);
    expect(vBuffer).toEqual(decodedVBuffer);
    expect(heightBuffer).toEqual(decodedHeightBuffer);
  });
  it("throws when zigZagDeltaDecode has an undefined uBuffer", function() {
    expect(function() {
      import__4.AttributeCompression.zigZagDeltaDecode(void 0, new Uint16Array(10));
    }).toThrowDeveloperError();
  });
  it("throws when zigZagDeltaDecode has an undefined vBuffer", function() {
    expect(function() {
      import__4.AttributeCompression.zigZagDeltaDecode(new Uint16Array(10), void 0);
    }).toThrowDeveloperError();
  });
  it("throws when zigZagDeltaDecode has unequal uBuffer and vBuffer length", function() {
    expect(function() {
      import__4.AttributeCompression.zigZagDeltaDecode(
        new Uint16Array(10),
        new Uint16Array(11)
      );
    }).toThrowDeveloperError();
  });
  it("throws when zigZagDeltaDecode has unequal uBuffer, vBuffer, and heightBuffer length", function() {
    expect(function() {
      import__4.AttributeCompression.zigZagDeltaDecode(
        new Uint16Array(10),
        new Uint16Array(10),
        new Uint16Array(11)
      );
    }).toThrowDeveloperError();
  });
  it("throws when dequantize has an undefined typedArray", function() {
    expect(function() {
      import__4.AttributeCompression.dequantize(
        void 0,
        import__4.ComponentDatatype.UNSIGNED_BYTE,
        import__4.AttributeType.VEC3,
        1
      );
    }).toThrowDeveloperError();
  });
  it("throws when dequantize has an undefined componentType", function() {
    expect(function() {
      import__4.AttributeCompression.dequantize(
        new Uint8Array([0, 0, 0, 0]),
        void 0,
        import__4.AttributeType.VEC3,
        1
      );
    }).toThrowDeveloperError();
  });
  it("throws when dequantize has an undefined type", function() {
    expect(function() {
      import__4.AttributeCompression.dequantize(
        new Uint8Array([0, 0, 0, 0]),
        import__4.ComponentDatatype.UNSIGNED_BYTE,
        void 0,
        1
      );
    }).toThrowDeveloperError();
  });
  it("throws when dequantize has an undefined count", function() {
    expect(function() {
      import__4.AttributeCompression.dequantize(
        new Uint8Array([0, 0, 0, 0]),
        import__4.ComponentDatatype.UNSIGNED_BYTE,
        import__4.AttributeType.VEC3,
        void 0
      );
    }).toThrowDeveloperError();
  });
  it("dequantize works with BYTE", function() {
    const input = [-127, -127, -127, 0, 0, 0, 127, 127, 127];
    const expected = [-1, -1, -1, 0, 0, 0, 1, 1, 1];
    const result = import__4.AttributeCompression.dequantize(
      new Int8Array(input),
      import__4.ComponentDatatype.BYTE,
      import__4.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqualEpsilon(expected[i], import__4.Math.EPSILON2);
    }
  });
  it("dequantize works with UNSIGNED_BYTE", function() {
    const input = [0, 0, 0, 127, 127, 127, 255, 255, 255];
    const expected = [0, 0, 0, 0.5, 0.5, 0.5, 1, 1, 1];
    const result = import__4.AttributeCompression.dequantize(
      new Uint8Array(input),
      import__4.ComponentDatatype.UNSIGNED_BYTE,
      import__4.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqualEpsilon(expected[i], import__4.Math.EPSILON2);
    }
  });
  it("dequantize works with SHORT", function() {
    const input = [-32767, -32767, -32767, 0, 0, 0, 32767, 32767, 32767];
    const expected = [-1, -1, -1, 0, 0, 0, 1, 1, 1];
    const result = import__4.AttributeCompression.dequantize(
      new Int16Array(input),
      import__4.ComponentDatatype.SHORT,
      import__4.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqualEpsilon(expected[i], import__4.Math.EPSILON5);
    }
  });
  it("dequantize works with UNSIGNED_SHORT", function() {
    const input = [0, 0, 0, 32767, 32767, 32767, 65535, 65535, 65535];
    const expected = [0, 0, 0, 0.5, 0.5, 0.5, 1, 1, 1];
    const result = import__4.AttributeCompression.dequantize(
      new Uint16Array(input),
      import__4.ComponentDatatype.UNSIGNED_SHORT,
      import__4.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqualEpsilon(expected[i], import__4.Math.EPSILON5);
    }
  });
  it("dequantize works with INT", function() {
    const input = [
      -2147483647,
      -2147483647,
      -2147483647,
      0,
      0,
      0,
      2147483647,
      2147483647,
      2147483647
    ];
    const expected = [-1, -1, -1, 0, 0, 0, 1, 1, 1];
    const result = import__4.AttributeCompression.dequantize(
      new Int32Array(input),
      import__4.ComponentDatatype.INT,
      import__4.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqual(expected[i]);
    }
  });
  it("dequantize works with UNSIGNED_INT", function() {
    const input = [
      0,
      0,
      0,
      2147483647,
      2147483647,
      2147483647,
      4294967295,
      4294967295,
      4294967295
    ];
    const expected = [0, 0, 0, 0.5, 0.5, 0.5, 1, 1, 1];
    const result = import__4.AttributeCompression.dequantize(
      new Uint32Array(input),
      import__4.ComponentDatatype.UNSIGNED_INT,
      import__4.AttributeType.VEC3,
      3
    );
    for (let i = 0; i < input.length; i++) {
      expect(result[i]).toEqual(expected[i]);
    }
  });
  it("decodeRGB565 throws without typedArray", function() {
    expect(function() {
      return import__4.AttributeCompression.decodeRGB565();
    }).toThrowDeveloperError();
  });
  it("decodeRGB565 throws if arrays are the wrong size", function() {
    expect(function() {
      return import__4.AttributeCompression.decodeRGB565(
        new Uint16Array([0]),
        new Float32Array(1)
      );
    }).toThrowDeveloperError();
  });
  it("decodeRGB565 works", function() {
    const input = new Uint16Array([
      0,
      //0b00001_000001_00001
      2081,
      //0b10000_100000_01000
      33800,
      //0b11111_111111_11111
      65535
    ]);
    const expected = new Float32Array([
      0,
      0,
      0,
      1 / 31,
      1 / 63,
      1 / 31,
      16 / 31,
      32 / 63,
      8 / 31,
      31 / 31,
      63 / 63,
      31 / 31
    ]);
    const resultLength = input.length * 3;
    const result = new Float32Array(resultLength);
    import__4.AttributeCompression.decodeRGB565(input, result);
    for (let i = 0; i < resultLength; i++) {
      expect(result[i]).toEqual(expected[i]);
    }
  });
  it("decodeRGB565 creates a result array if not defined", function() {
    const result = import__4.AttributeCompression.decodeRGB565(new Uint16Array([0]));
    expect(result).toEqual(new Float32Array([0, 0, 0]));
  });
});

// packages/engine/Specs/Core/AxisAlignedBoundingBoxSpec.js
var import__5 = __toESM(require_Cesium(), 1);
describe("Core/AxisAlignedBoundingBox", function() {
  const positions = [
    new import__5.Cartesian3(3, -1, -3),
    new import__5.Cartesian3(2, -2, -2),
    new import__5.Cartesian3(1, -3, -1),
    new import__5.Cartesian3(0, 0, 0),
    new import__5.Cartesian3(-1, 1, 1),
    new import__5.Cartesian3(-2, 2, 2),
    new import__5.Cartesian3(-3, 3, 3)
  ];
  const positionsMinimum = new import__5.Cartesian3(-3, -3, -3);
  const positionsMaximum = new import__5.Cartesian3(3, 3, 3);
  const positionsCenter = new import__5.Cartesian3(0, 0, 0);
  it("constructor sets expected default values", function() {
    const box = new import__5.AxisAlignedBoundingBox();
    expect(box.minimum).toEqual(import__5.Cartesian3.ZERO);
    expect(box.maximum).toEqual(import__5.Cartesian3.ZERO);
    expect(box.center).toEqual(import__5.Cartesian3.ZERO);
  });
  it("constructor sets expected parameter values", function() {
    const minimum = new import__5.Cartesian3(1, 2, 3);
    const maximum = new import__5.Cartesian3(4, 5, 6);
    const center = new import__5.Cartesian3(2.5, 3.5, 4.5);
    const box = new import__5.AxisAlignedBoundingBox(minimum, maximum, center);
    expect(box.minimum).toEqual(minimum);
    expect(box.maximum).toEqual(maximum);
    expect(box.center).toEqual(center);
  });
  it("constructor computes center if not supplied", function() {
    const minimum = new import__5.Cartesian3(1, 2, 3);
    const maximum = new import__5.Cartesian3(4, 5, 6);
    const expectedCenter = new import__5.Cartesian3(2.5, 3.5, 4.5);
    const box = new import__5.AxisAlignedBoundingBox(minimum, maximum);
    expect(box.minimum).toEqual(minimum);
    expect(box.maximum).toEqual(maximum);
    expect(box.center).toEqual(expectedCenter);
  });
  it("fromCorners works with a result parameter", function() {
    const minimum = new import__5.Cartesian3(0, 0, 0);
    const maximum = new import__5.Cartesian3(1, 1, 1);
    const expectedCenter = new import__5.Cartesian3(0.5, 0.5, 0.5);
    const box = new import__5.AxisAlignedBoundingBox();
    const result = import__5.AxisAlignedBoundingBox.fromCorners(minimum, maximum, box);
    expect(result.minimum).toEqual(minimum);
    expect(result.maximum).toEqual(maximum);
    expect(result.center).toEqual(expectedCenter);
    expect(result).toBe(box);
  });
  it("fromCorners works without a result parameter", function() {
    const minimum = new import__5.Cartesian3(0, 0, 0);
    const maximum = new import__5.Cartesian3(1, 1, 1);
    const expectedCenter = new import__5.Cartesian3(0.5, 0.5, 0.5);
    const box = import__5.AxisAlignedBoundingBox.fromCorners(minimum, maximum);
    expect(box.minimum).toEqual(minimum);
    expect(box.maximum).toEqual(maximum);
    expect(box.center).toEqual(expectedCenter);
  });
  it("fromCorners throws without a minimum", function() {
    expect(function() {
      import__5.AxisAlignedBoundingBox.fromCorners(void 0, import__5.Cartesian3.ZERO);
    }).toThrowDeveloperError();
  });
  it("fromCorners throws without a maximum", function() {
    expect(function() {
      import__5.AxisAlignedBoundingBox.fromCorners(import__5.Cartesian3.ZERO, void 0);
    }).toThrowDeveloperError();
  });
  it("fromPoints constructs empty box with undefined positions", function() {
    const box = import__5.AxisAlignedBoundingBox.fromPoints(void 0);
    expect(box.minimum).toEqual(import__5.Cartesian3.ZERO);
    expect(box.maximum).toEqual(import__5.Cartesian3.ZERO);
    expect(box.center).toEqual(import__5.Cartesian3.ZERO);
  });
  it("fromPoints constructs empty box with empty positions", function() {
    const box = import__5.AxisAlignedBoundingBox.fromPoints([]);
    expect(box.minimum).toEqual(import__5.Cartesian3.ZERO);
    expect(box.maximum).toEqual(import__5.Cartesian3.ZERO);
    expect(box.center).toEqual(import__5.Cartesian3.ZERO);
  });
  it("fromPoints computes the correct values", function() {
    const box = import__5.AxisAlignedBoundingBox.fromPoints(positions);
    expect(box.minimum).toEqual(positionsMinimum);
    expect(box.maximum).toEqual(positionsMaximum);
    expect(box.center).toEqual(positionsCenter);
  });
  it("clone without a result parameter", function() {
    const box = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.UNIT_Y,
      import__5.Cartesian3.UNIT_X
    );
    const result = box.clone();
    expect(box).not.toBe(result);
    expect(box).toEqual(result);
  });
  it("clone without a result parameter with box of offset center", function() {
    const box = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.UNIT_Y,
      import__5.Cartesian3.UNIT_X,
      import__5.Cartesian3.UNIT_Z
    );
    const result = box.clone();
    expect(box).not.toBe(result);
    expect(box).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const box = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.UNIT_Y,
      import__5.Cartesian3.UNIT_X
    );
    const result = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.ZERO,
      import__5.Cartesian3.UNIT_Z
    );
    const returnedResult = box.clone(result);
    expect(result).toBe(returnedResult);
    expect(box).not.toBe(result);
    expect(box).toEqual(result);
  });
  it('clone works with "this" result parameter', function() {
    const box = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.UNIT_Y,
      import__5.Cartesian3.UNIT_X
    );
    const returnedResult = box.clone(box);
    expect(box).toBe(returnedResult);
    expect(box.minimum).toEqual(import__5.Cartesian3.UNIT_Y);
    expect(box.maximum).toEqual(import__5.Cartesian3.UNIT_X);
  });
  it("equals works in all cases", function() {
    const box = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.UNIT_X,
      import__5.Cartesian3.UNIT_Y,
      import__5.Cartesian3.UNIT_Z
    );
    const bogie = new import__5.Cartesian3(2, 3, 4);
    expect(
      box.equals(
        new import__5.AxisAlignedBoundingBox(
          import__5.Cartesian3.UNIT_X,
          import__5.Cartesian3.UNIT_Y,
          import__5.Cartesian3.UNIT_Z
        )
      )
    ).toEqual(true);
    expect(
      box.equals(
        new import__5.AxisAlignedBoundingBox(bogie, import__5.Cartesian3.UNIT_Y, import__5.Cartesian3.UNIT_Y)
      )
    ).toEqual(false);
    expect(
      box.equals(
        new import__5.AxisAlignedBoundingBox(import__5.Cartesian3.UNIT_X, bogie, import__5.Cartesian3.UNIT_Z)
      )
    ).toEqual(false);
    expect(
      box.equals(
        new import__5.AxisAlignedBoundingBox(import__5.Cartesian3.UNIT_X, import__5.Cartesian3.UNIT_Y, bogie)
      )
    ).toEqual(false);
    expect(box.equals(void 0)).toEqual(false);
  });
  it("computes the bounding box for a single position", function() {
    const box = import__5.AxisAlignedBoundingBox.fromPoints([positions[0]]);
    expect(box.minimum).toEqual(positions[0]);
    expect(box.maximum).toEqual(positions[0]);
    expect(box.center).toEqual(positions[0]);
  });
  it("intersectPlane works with box on the positive side of a plane", function() {
    const box = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.negate(import__5.Cartesian3.UNIT_X, new import__5.Cartesian3()),
      import__5.Cartesian3.ZERO
    );
    const normal = import__5.Cartesian3.negate(import__5.Cartesian3.UNIT_X, new import__5.Cartesian3());
    const position = import__5.Cartesian3.UNIT_X;
    const plane = new import__5.Plane(normal, -import__5.Cartesian3.dot(normal, position));
    expect(box.intersectPlane(plane)).toEqual(import__5.Intersect.INSIDE);
  });
  it("intersectPlane works with box on the negative side of a plane", function() {
    const box = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.negate(import__5.Cartesian3.UNIT_X, new import__5.Cartesian3()),
      import__5.Cartesian3.ZERO
    );
    const normal = import__5.Cartesian3.UNIT_X;
    const position = import__5.Cartesian3.UNIT_X;
    const plane = new import__5.Plane(normal, -import__5.Cartesian3.dot(normal, position));
    expect(box.intersectPlane(plane)).toEqual(import__5.Intersect.OUTSIDE);
  });
  it("intersectPlane works with box intersecting a plane", function() {
    const box = new import__5.AxisAlignedBoundingBox(
      import__5.Cartesian3.ZERO,
      import__5.Cartesian3.multiplyByScalar(import__5.Cartesian3.UNIT_X, 2, new import__5.Cartesian3())
    );
    const normal = import__5.Cartesian3.UNIT_X;
    const position = import__5.Cartesian3.UNIT_X;
    const plane = new import__5.Plane(normal, -import__5.Cartesian3.dot(normal, position));
    expect(box.intersectPlane(plane)).toEqual(import__5.Intersect.INTERSECTING);
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__5.AxisAlignedBoundingBox.clone()).toBeUndefined();
  });
  it("intersectPlane throws without a box", function() {
    const plane = new import__5.Plane(import__5.Cartesian3.UNIT_X, 0);
    expect(function() {
      import__5.AxisAlignedBoundingBox.intersectPlane(void 0, plane);
    }).toThrowDeveloperError();
  });
  it("intersectPlane throws without a plane", function() {
    const box = new import__5.AxisAlignedBoundingBox();
    expect(function() {
      import__5.AxisAlignedBoundingBox.intersectPlane(box, void 0);
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/BingMapsGeocoderServiceSpec.js
var import__6 = __toESM(require_Cesium(), 1);
describe("Core/BingMapsGeocoderService", function() {
  afterAll(function() {
    import__6.Resource._Implementations.loadAndExecuteScript = import__6.Resource._DefaultImplementations.loadAndExecuteScript;
  });
  it("conforms to GeocoderService interface", function() {
    expect(import__6.BingMapsGeocoderService).toConformToInterface(import__6.GeocoderService);
  });
  it("returns geocoder results", async function() {
    const query = "some query";
    const key = "not_the_real_key;";
    const data = {
      resourceSets: [
        {
          resources: [
            {
              name: "a",
              bbox: [32, 3, 3, 4]
            }
          ]
        }
      ]
    };
    import__6.Resource._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
      const parsedUrl = new URL(url);
      expect(parsedUrl.searchParams.get("query")).toEqual(query);
      expect(parsedUrl.searchParams.get("key")).toEqual(key);
      expect(parsedUrl.searchParams.get("culture")).toBe(null);
      deferred.resolve(data);
    };
    const service = new import__6.BingMapsGeocoderService({ key });
    const results = await service.geocode(query);
    expect(results.length).toEqual(1);
    expect(results[0].displayName).toEqual("a");
    expect(results[0].destination).toBeInstanceOf(import__6.Rectangle);
  });
  it("uses supplied culture", async function() {
    const query = "some query";
    const key = "not_the_real_key;";
    const data = {
      resourceSets: [
        {
          resources: [
            {
              name: "a",
              bbox: [32, 3, 3, 4]
            }
          ]
        }
      ]
    };
    import__6.Resource._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
      const parsedUrl = new URL(url);
      expect(parsedUrl.searchParams.get("query")).toEqual(query);
      expect(parsedUrl.searchParams.get("key")).toEqual(key);
      expect(parsedUrl.searchParams.get("culture")).toEqual("ja");
      deferred.resolve(data);
    };
    const service = new import__6.BingMapsGeocoderService({ key, culture: "ja" });
    const results = await service.geocode(query);
    expect(results.length).toEqual(1);
    expect(results[0].displayName).toEqual("a");
    expect(results[0].destination).toBeInstanceOf(import__6.Rectangle);
  });
  it("returns no geocoder results if Bing has no results", async function() {
    const query = "some query";
    const data = {
      resourceSets: []
    };
    import__6.Resource._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
      deferred.resolve(data);
    };
    const service = new import__6.BingMapsGeocoderService({ key: "" });
    const results = await service.geocode(query);
    expect(results.length).toEqual(0);
  });
  it("returns no geocoder results if Bing has results but no resources", async function() {
    const query = "some query";
    const data = {
      resourceSets: [
        {
          resources: []
        }
      ]
    };
    import__6.Resource._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
      deferred.resolve(data);
    };
    const service = new import__6.BingMapsGeocoderService({ key: "" });
    const results = await service.geocode(query);
    expect(results.length).toEqual(0);
  });
  it("credit returns expected value", async function() {
    const service = new import__6.BingMapsGeocoderService({ key: "" });
    expect(service.credit).toBeInstanceOf(import__6.Credit);
    expect(service.credit.html).toEqual(
      `<img src="http://dev.virtualearth.net/Branding/logo_powered_by.png"/>`
    );
    expect(service.credit.showOnScreen).toBe(false);
  });
});

// packages/engine/Specs/Core/BoundingRectangleSpec.js
var import__7 = __toESM(require_Cesium(), 1);

// Specs/createPackableSpecs.js
var import_engine = __toESM(require_Cesium(), 1);
function createPackableSpecs(packable, instance, packedInstance, namePrefix) {
  namePrefix = (0, import_engine.defaultValue)(namePrefix, "");
  it(`${namePrefix} can pack`, function() {
    const packedArray = [];
    const returnArray = packable.pack(instance, packedArray);
    expect(returnArray).toBe(packedArray);
    const packedLength = (0, import_engine.defined)(packable.packedLength) ? packable.packedLength : instance.packedLength;
    expect(packedArray.length).toEqual(packedLength);
    expect(packedArray).toEqualEpsilon(packedInstance, import_engine.Math.EPSILON15);
  });
  it(`${namePrefix} can roundtrip`, function() {
    const packedArray = [];
    packable.pack(instance, packedArray);
    const result = packable.unpack(packedArray);
    expect(instance).toEqual(result);
  });
  it(`${namePrefix} can unpack`, function() {
    const result = packable.unpack(packedInstance);
    expect(result).toEqual(instance);
  });
  it(`${namePrefix} can pack with startingIndex`, function() {
    const packedArray = [0];
    const expected = packedArray.concat(packedInstance);
    packable.pack(instance, packedArray, 1);
    expect(packedArray).toEqualEpsilon(expected, import_engine.Math.EPSILON15);
  });
  it(`${namePrefix} can unpack with startingIndex`, function() {
    const packedArray = [0].concat(packedInstance);
    const result = packable.unpack(packedArray, 1);
    expect(instance).toEqual(result);
  });
  it(`${namePrefix} pack throws with undefined value`, function() {
    const array = [];
    expect(function() {
      packable.pack(void 0, array);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} pack throws with undefined array`, function() {
    expect(function() {
      packable.pack(instance, void 0);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} unpack throws with undefined array`, function() {
    expect(function() {
      packable.unpack(void 0);
    }).toThrowDeveloperError();
  });
  if (typeof packable.convertPackedArrayForInterpolation === "function") {
    it(`${namePrefix} packs and unpacks for interpolation.`, function() {
      const packedForInterpolation = [];
      packable.convertPackedArrayForInterpolation(
        packedInstance,
        0,
        0,
        packedForInterpolation
      );
      const value = packable.unpackInterpolationResult(
        packedForInterpolation,
        packedInstance,
        0,
        0
      );
      const result = packable.unpack(packedInstance);
      expect(value).toEqual(result);
    });
    it(`${namePrefix} convertPackedArrayForInterpolation throws without array.`, function() {
      expect(function() {
        packable.convertPackedArrayForInterpolation(void 0);
      }).toThrowDeveloperError();
    });
    it(`${namePrefix} unpackInterpolationResult throws without packed array.`, function() {
      expect(function() {
        packable.unpackInterpolationResult(void 0, []);
      }).toThrowDeveloperError();
    });
    it(`${namePrefix} unpackInterpolationResult throws without source array.`, function() {
      expect(function() {
        packable.unpackInterpolationResult([], void 0);
      }).toThrowDeveloperError();
    });
  }
}
var createPackableSpecs_default = createPackableSpecs;

// packages/engine/Specs/Core/BoundingRectangleSpec.js
describe("Core/BoundingRectangle", function() {
  it("default constructor sets expected values", function() {
    const rectangle = new import__7.BoundingRectangle();
    expect(rectangle.x).toEqual(0);
    expect(rectangle.y).toEqual(0);
    expect(rectangle.width).toEqual(0);
    expect(rectangle.height).toEqual(0);
  });
  it("constructor sets expected parameters", function() {
    const rectangle = new import__7.BoundingRectangle(1, 2, 3, 4);
    expect(rectangle.x).toEqual(1);
    expect(rectangle.y).toEqual(2);
    expect(rectangle.width).toEqual(3);
    expect(rectangle.height).toEqual(4);
  });
  it("clone without a result parameter", function() {
    const rectangle = new import__7.BoundingRectangle(1, 2, 3, 4);
    const result = rectangle.clone();
    expect(rectangle).not.toBe(result);
    expect(rectangle).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const rectangle = new import__7.BoundingRectangle(1, 2, 3, 4);
    const result = new import__7.BoundingRectangle(6, 7, 8, 9);
    const returnedResult = rectangle.clone(result);
    expect(result).not.toBe(rectangle);
    expect(result).toEqual(rectangle);
    expect(result).toBe(returnedResult);
  });
  it('clone works with "this" result parameter', function() {
    const rectangle = new import__7.BoundingRectangle(1, 2, 3, 4);
    const returnedResult = rectangle.clone(rectangle);
    expect(rectangle.x).toEqual(1);
    expect(rectangle.y).toEqual(2);
    expect(rectangle.width).toEqual(3);
    expect(rectangle.height).toEqual(4);
    expect(rectangle).toBe(returnedResult);
  });
  it("equals", function() {
    const rectangle = new import__7.BoundingRectangle(1, 2, 3, 4);
    expect(rectangle.equals(new import__7.BoundingRectangle(1, 2, 3, 4))).toEqual(
      true
    );
    expect(rectangle.equals(new import__7.BoundingRectangle(5, 2, 3, 4))).toEqual(
      false
    );
    expect(rectangle.equals(new import__7.BoundingRectangle(1, 6, 3, 4))).toEqual(
      false
    );
    expect(rectangle.equals(new import__7.BoundingRectangle(1, 2, 7, 4))).toEqual(
      false
    );
    expect(rectangle.equals(new import__7.BoundingRectangle(1, 2, 3, 8))).toEqual(
      false
    );
    expect(rectangle.equals(void 0)).toEqual(false);
  });
  const positions = [
    new import__7.Cartesian2(3, -1),
    new import__7.Cartesian2(2, -2),
    new import__7.Cartesian2(1, -3),
    new import__7.Cartesian2(0, 0),
    new import__7.Cartesian2(-1, 1),
    new import__7.Cartesian2(-2, 2),
    new import__7.Cartesian2(-3, 3)
  ];
  it("create axis aligned bounding rectangle", function() {
    const rectangle = import__7.BoundingRectangle.fromPoints(positions);
    expect(rectangle.x).toEqual(-3);
    expect(rectangle.y).toEqual(-3);
    expect(rectangle.width).toEqual(6);
    expect(rectangle.height).toEqual(6);
  });
  it("fromPoints works with a result parameter", function() {
    const result = new import__7.BoundingRectangle();
    const rectangle = import__7.BoundingRectangle.fromPoints(positions, result);
    expect(rectangle).toBe(result);
    expect(rectangle.x).toEqual(-3);
    expect(rectangle.y).toEqual(-3);
    expect(rectangle.width).toEqual(6);
    expect(rectangle.height).toEqual(6);
  });
  it("fromPoints creates an empty rectangle with no positions", function() {
    const rectangle = import__7.BoundingRectangle.fromPoints();
    expect(rectangle.x).toEqual(0);
    expect(rectangle.y).toEqual(0);
    expect(rectangle.width).toEqual(0);
    expect(rectangle.height).toEqual(0);
  });
  it("fromRectangle creates an empty rectangle with no rectangle", function() {
    const rectangle = import__7.BoundingRectangle.fromRectangle();
    expect(rectangle.x).toEqual(0);
    expect(rectangle.y).toEqual(0);
    expect(rectangle.width).toEqual(0);
    expect(rectangle.height).toEqual(0);
  });
  it("create a bounding rectangle from a rectangle", function() {
    const rectangle = import__7.Rectangle.MAX_VALUE;
    const projection = new import__7.GeographicProjection(import__7.Ellipsoid.UNIT_SPHERE);
    const expected = new import__7.BoundingRectangle(
      rectangle.west,
      rectangle.south,
      rectangle.east - rectangle.west,
      rectangle.north - rectangle.south
    );
    expect(import__7.BoundingRectangle.fromRectangle(rectangle, projection)).toEqual(
      expected
    );
  });
  it("fromRectangle works with a result parameter", function() {
    const rectangle = import__7.Rectangle.MAX_VALUE;
    const expected = new import__7.BoundingRectangle(
      rectangle.west,
      rectangle.south,
      rectangle.east - rectangle.west,
      rectangle.north - rectangle.south
    );
    const projection = new import__7.GeographicProjection(import__7.Ellipsoid.UNIT_SPHERE);
    const result = new import__7.BoundingRectangle();
    const returnedResult = import__7.BoundingRectangle.fromRectangle(
      rectangle,
      projection,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqual(expected);
  });
  it("intersect works", function() {
    const rectangle1 = new import__7.BoundingRectangle(0, 0, 4, 4);
    const rectangle2 = new import__7.BoundingRectangle(2, 2, 4, 4);
    const rectangle3 = new import__7.BoundingRectangle(-6, 2, 4, 4);
    const rectangle4 = new import__7.BoundingRectangle(8, 2, 4, 4);
    const rectangle5 = new import__7.BoundingRectangle(2, -6, 4, 4);
    const rectangle6 = new import__7.BoundingRectangle(2, 8, 4, 4);
    expect(import__7.BoundingRectangle.intersect(rectangle1, rectangle2)).toEqual(
      import__7.Intersect.INTERSECTING
    );
    expect(import__7.BoundingRectangle.intersect(rectangle1, rectangle3)).toEqual(
      import__7.Intersect.OUTSIDE
    );
    expect(import__7.BoundingRectangle.intersect(rectangle1, rectangle4)).toEqual(
      import__7.Intersect.OUTSIDE
    );
    expect(import__7.BoundingRectangle.intersect(rectangle1, rectangle5)).toEqual(
      import__7.Intersect.OUTSIDE
    );
    expect(import__7.BoundingRectangle.intersect(rectangle1, rectangle6)).toEqual(
      import__7.Intersect.OUTSIDE
    );
  });
  it("union works without a result parameter", function() {
    const rectangle1 = new import__7.BoundingRectangle(2, 0, 1, 1);
    const rectangle2 = new import__7.BoundingRectangle(-2, 0, 1, 2);
    const expected = new import__7.BoundingRectangle(-2, 0, 5, 2);
    const returnedResult = import__7.BoundingRectangle.union(rectangle1, rectangle2);
    expect(returnedResult).toEqual(expected);
  });
  it("union works with a result parameter", function() {
    const rectangle1 = new import__7.BoundingRectangle(2, 0, 1, 1);
    const rectangle2 = new import__7.BoundingRectangle(-2, 0, 1, 2);
    const expected = new import__7.BoundingRectangle(-2, 0, 5, 2);
    const result = new import__7.BoundingRectangle(-1, -1, 10, 10);
    const returnedResult = import__7.BoundingRectangle.union(
      rectangle1,
      rectangle2,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqual(expected);
  });
  it("expand works if rectangle needs to grow right", function() {
    const rectangle = new import__7.BoundingRectangle(2, 0, 1, 1);
    const point = new import__7.Cartesian2(4, 0);
    const expected = new import__7.BoundingRectangle(2, 0, 2, 1);
    const result = import__7.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works if rectangle needs x to grow left", function() {
    const rectangle = new import__7.BoundingRectangle(2, 0, 1, 1);
    const point = new import__7.Cartesian2(0, 0);
    const expected = new import__7.BoundingRectangle(0, 0, 3, 1);
    const result = import__7.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works if rectangle needs to grow up", function() {
    const rectangle = new import__7.BoundingRectangle(2, 0, 1, 1);
    const point = new import__7.Cartesian2(2, 2);
    const expected = new import__7.BoundingRectangle(2, 0, 1, 2);
    const result = import__7.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works if rectangle needs x to grow down", function() {
    const rectangle = new import__7.BoundingRectangle(2, 0, 1, 1);
    const point = new import__7.Cartesian2(2, -1);
    const expected = new import__7.BoundingRectangle(2, -1, 1, 2);
    const result = import__7.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works if rectangle does not need to grow", function() {
    const rectangle = new import__7.BoundingRectangle(2, 0, 1, 1);
    const point = new import__7.Cartesian2(2.5, 0.6);
    const expected = new import__7.BoundingRectangle(2, 0, 1, 1);
    const result = import__7.BoundingRectangle.expand(rectangle, point);
    expect(result).toEqual(expected);
  });
  it("expand works with a result parameter", function() {
    const rectangle = new import__7.BoundingRectangle(2, 0, 1, 1);
    const point = new import__7.Cartesian2(2, -1);
    const expected = new import__7.BoundingRectangle(2, -1, 1, 2);
    const result = new import__7.BoundingRectangle();
    const returnedResult = import__7.BoundingRectangle.expand(rectangle, point, result);
    expect(returnedResult).toBe(returnedResult);
    expect(result).toEqual(expected);
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__7.BoundingRectangle.clone()).toBeUndefined();
  });
  it("union throws with no left parameter", function() {
    const right = new import__7.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__7.BoundingRectangle.union(void 0, right);
    }).toThrowDeveloperError();
  });
  it("union throws with no right parameter", function() {
    const left = new import__7.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__7.BoundingRectangle.union(left, void 0);
    }).toThrowDeveloperError();
  });
  it("expand throws with no rectangle parameter", function() {
    const point = new import__7.Cartesian2();
    expect(function() {
      import__7.BoundingRectangle.expand(void 0, point);
    }).toThrowDeveloperError();
  });
  it("expand throws with no point parameter", function() {
    const rectangle = new import__7.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__7.BoundingRectangle.expand(rectangle, void 0);
    }).toThrowDeveloperError();
  });
  it("intersect throws with no left parameter", function() {
    const right = new import__7.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__7.BoundingRectangle.intersect(void 0, right);
    }).toThrowDeveloperError();
  });
  it("intersect throws with no right parameter", function() {
    const left = new import__7.BoundingRectangle(1, 2, 3, 4);
    expect(function() {
      import__7.BoundingRectangle.intersect(left, void 0);
    }).toThrowDeveloperError();
  });
  createPackableSpecs_default(import__7.BoundingRectangle, new import__7.BoundingRectangle(1, 2, 3, 4), [
    1,
    2,
    3,
    4
  ]);
});

// packages/engine/Specs/Core/BoundingSphereSpec.js
var import__8 = __toESM(require_Cesium(), 1);
describe("Core/BoundingSphere", function() {
  const positionsRadius = 1;
  const positionsCenter = new import__8.Cartesian3(10000001, 0, 0);
  const center = new import__8.Cartesian3(1e7, 0, 0);
  function getPositions() {
    return [
      import__8.Cartesian3.add(center, new import__8.Cartesian3(1, 0, 0), new import__8.Cartesian3()),
      import__8.Cartesian3.add(center, new import__8.Cartesian3(2, 0, 0), new import__8.Cartesian3()),
      import__8.Cartesian3.add(center, new import__8.Cartesian3(0, 0, 0), new import__8.Cartesian3()),
      import__8.Cartesian3.add(center, new import__8.Cartesian3(1, 1, 0), new import__8.Cartesian3()),
      import__8.Cartesian3.add(center, new import__8.Cartesian3(1, -1, 0), new import__8.Cartesian3()),
      import__8.Cartesian3.add(center, new import__8.Cartesian3(1, 0, 1), new import__8.Cartesian3()),
      import__8.Cartesian3.add(center, new import__8.Cartesian3(1, 0, -1), new import__8.Cartesian3())
    ];
  }
  function getPositionsAsFlatArray() {
    const positions = getPositions();
    const result = [];
    for (let i = 0; i < positions.length; ++i) {
      result.push(positions[i].x);
      result.push(positions[i].y);
      result.push(positions[i].z);
    }
    return result;
  }
  function getPositionsAsFlatArrayWithStride5() {
    const positions = getPositions();
    const result = [];
    for (let i = 0; i < positions.length; ++i) {
      result.push(positions[i].x);
      result.push(positions[i].y);
      result.push(positions[i].z);
      result.push(1.23);
      result.push(4.56);
    }
    return result;
  }
  function getPositionsAsEncodedFlatArray() {
    const positions = getPositions();
    const high = [];
    const low = [];
    for (let i = 0; i < positions.length; ++i) {
      const encoded = import__8.EncodedCartesian3.fromCartesian(positions[i]);
      high.push(encoded.high.x);
      high.push(encoded.high.y);
      high.push(encoded.high.z);
      low.push(encoded.low.x);
      low.push(encoded.low.y);
      low.push(encoded.low.z);
    }
    return {
      high,
      low
    };
  }
  it("default constructing produces expected values", function() {
    const sphere = new import__8.BoundingSphere();
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("constructor sets expected values", function() {
    const expectedCenter = new import__8.Cartesian3(1, 2, 3);
    const expectedRadius = 1;
    const sphere = new import__8.BoundingSphere(expectedCenter, expectedRadius);
    expect(sphere.center).toEqual(expectedCenter);
    expect(sphere.radius).toEqual(expectedRadius);
  });
  it("clone without a result parameter", function() {
    const sphere = new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 4);
    const result = sphere.clone();
    expect(sphere).not.toBe(result);
    expect(sphere).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const sphere = new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 4);
    const result = new import__8.BoundingSphere();
    const returnedResult = sphere.clone(result);
    expect(result).not.toBe(sphere);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(sphere);
  });
  it('clone works with "this" result parameter', function() {
    const expectedCenter = new import__8.Cartesian3(1, 2, 3);
    const expectedRadius = 1;
    const sphere = new import__8.BoundingSphere(expectedCenter, expectedRadius);
    const returnedResult = sphere.clone(sphere);
    expect(sphere).toBe(returnedResult);
    expect(sphere.center).toEqual(expectedCenter);
    expect(sphere.radius).toEqual(expectedRadius);
  });
  it("clone clones undefined", function() {
    expect(import__8.BoundingSphere.clone(void 0)).toBe(void 0);
  });
  it("equals", function() {
    const sphere = new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 4);
    expect(
      sphere.equals(new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 4))
    ).toEqual(true);
    expect(
      sphere.equals(new import__8.BoundingSphere(new import__8.Cartesian3(5, 2, 3), 4))
    ).toEqual(false);
    expect(
      sphere.equals(new import__8.BoundingSphere(new import__8.Cartesian3(1, 6, 3), 4))
    ).toEqual(false);
    expect(
      sphere.equals(new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 7), 4))
    ).toEqual(false);
    expect(
      sphere.equals(new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 8))
    ).toEqual(false);
    expect(sphere.equals(void 0)).toEqual(false);
  });
  it("fromPoints without positions returns an empty sphere", function() {
    const sphere = import__8.BoundingSphere.fromPoints();
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromPoints works with one point", function() {
    const expectedCenter = new import__8.Cartesian3(1, 2, 3);
    const sphere = import__8.BoundingSphere.fromPoints([expectedCenter]);
    expect(sphere.center).toEqual(expectedCenter);
    expect(sphere.radius).toEqual(0);
  });
  it("fromPoints computes a center from points", function() {
    const sphere = import__8.BoundingSphere.fromPoints(getPositions());
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromPoints contains all points (naive)", function() {
    const sphere = import__8.BoundingSphere.fromPoints(getPositions());
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__8.Cartesian3(radius, radius, radius);
    const max = import__8.Cartesian3.add(r, center2, new import__8.Cartesian3());
    const min = import__8.Cartesian3.subtract(center2, r, new import__8.Cartesian3());
    const positions = getPositions();
    const numPositions = positions.length;
    for (let i = 0; i < numPositions; i++) {
      const currentPos = positions[i];
      expect(currentPos.x <= max.x && currentPos.x >= min.x).toEqual(true);
      expect(currentPos.y <= max.y && currentPos.y >= min.y).toEqual(true);
      expect(currentPos.z <= max.z && currentPos.z >= min.z).toEqual(true);
    }
  });
  it("fromPoints contains all points (ritter)", function() {
    const positions = getPositions();
    positions.push(
      new import__8.Cartesian3(1, 1, 1),
      new import__8.Cartesian3(2, 2, 2),
      new import__8.Cartesian3(3, 3, 3)
    );
    const sphere = import__8.BoundingSphere.fromPoints(positions);
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__8.Cartesian3(radius, radius, radius);
    const max = import__8.Cartesian3.add(r, center2, new import__8.Cartesian3());
    const min = import__8.Cartesian3.subtract(center2, r, new import__8.Cartesian3());
    const numPositions = positions.length;
    for (let i = 0; i < numPositions; i++) {
      const currentPos = positions[i];
      expect(currentPos.x <= max.x && currentPos.x >= min.x).toEqual(true);
      expect(currentPos.y <= max.y && currentPos.y >= min.y).toEqual(true);
      expect(currentPos.z <= max.z && currentPos.z >= min.z).toEqual(true);
    }
  });
  it("fromVertices without positions returns an empty sphere", function() {
    const sphere = import__8.BoundingSphere.fromVertices();
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromVertices works with one point", function() {
    const expectedCenter = new import__8.Cartesian3(1, 2, 3);
    const sphere = import__8.BoundingSphere.fromVertices([
      expectedCenter.x,
      expectedCenter.y,
      expectedCenter.z
    ]);
    expect(sphere.center).toEqual(expectedCenter);
    expect(sphere.radius).toEqual(0);
  });
  it("fromVertices computes a center from points", function() {
    const sphere = import__8.BoundingSphere.fromVertices(getPositionsAsFlatArray());
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromVertices contains all points (naive)", function() {
    const sphere = import__8.BoundingSphere.fromVertices(getPositionsAsFlatArray());
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__8.Cartesian3(radius, radius, radius);
    const max = import__8.Cartesian3.add(r, center2, new import__8.Cartesian3());
    const min = import__8.Cartesian3.subtract(center2, r, new import__8.Cartesian3());
    const positions = getPositions();
    const numPositions = positions.length;
    for (let i = 0; i < numPositions; i++) {
      const currentPos = positions[i];
      expect(currentPos.x <= max.x && currentPos.x >= min.x).toEqual(true);
      expect(currentPos.y <= max.y && currentPos.y >= min.y).toEqual(true);
      expect(currentPos.z <= max.z && currentPos.z >= min.z).toEqual(true);
    }
  });
  it("fromVertices contains all points (ritter)", function() {
    const positions = getPositionsAsFlatArray();
    positions.push(1, 1, 1, 2, 2, 2, 3, 3, 3);
    const sphere = import__8.BoundingSphere.fromVertices(positions);
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__8.Cartesian3(radius, radius, radius);
    const max = import__8.Cartesian3.add(r, center2, new import__8.Cartesian3());
    const min = import__8.Cartesian3.subtract(center2, r, new import__8.Cartesian3());
    const numElements = positions.length;
    for (let i = 0; i < numElements; i += 3) {
      expect(positions[i] <= max.x && positions[i] >= min.x).toEqual(true);
      expect(positions[i + 1] <= max.y && positions[i + 1] >= min.y).toEqual(
        true
      );
      expect(positions[i + 2] <= max.z && positions[i + 2] >= min.z).toEqual(
        true
      );
    }
  });
  it("fromVertices works with a stride of 5", function() {
    const sphere = import__8.BoundingSphere.fromVertices(
      getPositionsAsFlatArrayWithStride5(),
      void 0,
      5
    );
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromVertices works with defined center", function() {
    const center2 = new import__8.Cartesian3(1, 2, 3);
    const sphere = import__8.BoundingSphere.fromVertices(
      getPositionsAsFlatArrayWithStride5(),
      center2,
      5
    );
    expect(sphere.center).toEqual(
      import__8.Cartesian3.add(positionsCenter, center2, new import__8.Cartesian3())
    );
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromVertices requires a stride of at least 3", function() {
    function callWithStrideOf2() {
      import__8.BoundingSphere.fromVertices(getPositionsAsFlatArray(), void 0, 2);
    }
    expect(callWithStrideOf2).toThrowDeveloperError();
  });
  it("fromVertices fills result parameter if specified", function() {
    const center2 = new import__8.Cartesian3(1, 2, 3);
    const result = new import__8.BoundingSphere();
    const sphere = import__8.BoundingSphere.fromVertices(
      getPositionsAsFlatArrayWithStride5(),
      center2,
      5,
      result
    );
    expect(sphere).toEqual(result);
    expect(result.center).toEqual(
      import__8.Cartesian3.add(positionsCenter, center2, new import__8.Cartesian3())
    );
    expect(result.radius).toEqual(positionsRadius);
  });
  it("fromEncodedCartesianVertices without positions returns an empty sphere", function() {
    const sphere = import__8.BoundingSphere.fromEncodedCartesianVertices();
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromEncodedCartesianVertices without positions of different lengths returns an empty sphere", function() {
    const positions = getPositionsAsEncodedFlatArray();
    positions.low.length = positions.low.length - 1;
    const sphere = import__8.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low
    );
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromEncodedCartesianVertices computes a center from points", function() {
    const positions = getPositionsAsEncodedFlatArray();
    const sphere = import__8.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low
    );
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toEqual(positionsRadius);
  });
  it("fromEncodedCartesianVertices contains all points (naive)", function() {
    let positions = getPositionsAsEncodedFlatArray();
    const sphere = import__8.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low
    );
    const radius = sphere.radius;
    const center2 = sphere.center;
    const r = new import__8.Cartesian3(radius, radius, radius);
    const max = import__8.Cartesian3.add(r, center2, new import__8.Cartesian3());
    const min = import__8.Cartesian3.subtract(center2, r, new import__8.Cartesian3());
    positions = getPositions();
    const numPositions = positions.length;
    for (let i = 0; i < numPositions; i++) {
      const currentPos = positions[i];
      expect(currentPos.x <= max.x && currentPos.x >= min.x).toEqual(true);
      expect(currentPos.y <= max.y && currentPos.y >= min.y).toEqual(true);
      expect(currentPos.z <= max.z && currentPos.z >= min.z).toEqual(true);
    }
  });
  it("fromEncodedCartesianVertices contains all points (ritter)", function() {
    const positions = getPositionsAsEncodedFlatArray();
    const appendedPositions = [
      new import__8.Cartesian3(1, 1, 1),
      new import__8.Cartesian3(2, 2, 2),
      new import__8.Cartesian3(3, 3, 3)
    ];
    for (let j = 0; j < appendedPositions.length; ++j) {
      const encoded = import__8.EncodedCartesian3.fromCartesian(
        import__8.Cartesian3.add(appendedPositions[j], center, new import__8.Cartesian3())
      );
      positions.high.push(encoded.high.x);
      positions.high.push(encoded.high.y);
      positions.high.push(encoded.high.z);
      positions.low.push(encoded.low.x);
      positions.low.push(encoded.low.y);
      positions.low.push(encoded.low.z);
    }
    const sphere = import__8.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low
    );
    const radius = sphere.radius;
    const sphereCenter = sphere.center;
    const r = new import__8.Cartesian3(radius, radius, radius);
    const max = import__8.Cartesian3.add(r, sphereCenter, new import__8.Cartesian3());
    const min = import__8.Cartesian3.subtract(sphereCenter, r, new import__8.Cartesian3());
    const numElements = positions.length;
    for (let i = 0; i < numElements; i += 3) {
      expect(positions[i] <= max.x && positions[i] >= min.x).toEqual(true);
      expect(positions[i + 1] <= max.y && positions[i + 1] >= min.y).toEqual(
        true
      );
      expect(positions[i + 2] <= max.z && positions[i + 2] >= min.z).toEqual(
        true
      );
    }
  });
  it("fromEncodedCartesianVertices fills result parameter if specified", function() {
    const positions = getPositionsAsEncodedFlatArray();
    const result = new import__8.BoundingSphere();
    const sphere = import__8.BoundingSphere.fromEncodedCartesianVertices(
      positions.high,
      positions.low,
      result
    );
    expect(sphere).toEqual(result);
    expect(result.center).toEqual(positionsCenter);
    expect(result.radius).toEqual(positionsRadius);
  });
  it("fromRectangle2D creates an empty sphere if no rectangle provided", function() {
    const sphere = import__8.BoundingSphere.fromRectangle2D();
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromRectangle2D", function() {
    const rectangle = import__8.Rectangle.MAX_VALUE;
    const projection = new import__8.GeographicProjection(import__8.Ellipsoid.UNIT_SPHERE);
    const expected = new import__8.BoundingSphere(
      import__8.Cartesian3.ZERO,
      Math.sqrt(
        rectangle.east * rectangle.east + rectangle.north * rectangle.north
      )
    );
    expect(import__8.BoundingSphere.fromRectangle2D(rectangle, projection)).toEqual(
      expected
    );
  });
  it("fromRectangle3D creates an empty sphere if no rectangle provided", function() {
    const sphere = import__8.BoundingSphere.fromRectangle3D();
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromRectangle3D", function() {
    const rectangle = import__8.Rectangle.MAX_VALUE;
    const ellipsoid = import__8.Ellipsoid.WGS84;
    const expected = new import__8.BoundingSphere(
      import__8.Cartesian3.ZERO,
      ellipsoid.maximumRadius
    );
    expect(import__8.BoundingSphere.fromRectangle3D(rectangle, ellipsoid)).toEqual(
      expected
    );
  });
  it("fromRectangle3D with height", function() {
    const rectangle = new import__8.Rectangle(0.1, -0.3, 0.2, -0.4);
    const height = 1e5;
    const ellipsoid = import__8.Ellipsoid.WGS84;
    const points = import__8.Rectangle.subsample(rectangle, ellipsoid, height);
    const expected = import__8.BoundingSphere.fromPoints(points);
    expect(
      import__8.BoundingSphere.fromRectangle3D(rectangle, ellipsoid, height)
    ).toEqual(expected);
  });
  it("fromCornerPoints", function() {
    const sphere = import__8.BoundingSphere.fromCornerPoints(
      new import__8.Cartesian3(-1, -0, 0),
      new import__8.Cartesian3(1, 0, 0)
    );
    expect(sphere).toEqual(new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1));
  });
  it("fromCornerPoints with a result parameter", function() {
    const sphere = new import__8.BoundingSphere();
    const result = import__8.BoundingSphere.fromCornerPoints(
      new import__8.Cartesian3(0, -1, 0),
      new import__8.Cartesian3(0, 1, 0),
      sphere
    );
    expect(result).toBe(sphere);
    expect(result).toEqual(new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1));
  });
  it("fromCornerPoints throws without corner", function() {
    expect(function() {
      import__8.BoundingSphere.fromCornerPoints();
    }).toThrowDeveloperError();
  });
  it("fromCornerPoints throws without oppositeCorner", function() {
    expect(function() {
      import__8.BoundingSphere.fromCornerPoints(import__8.Cartesian3.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("fromEllipsoid", function() {
    const ellipsoid = import__8.Ellipsoid.WGS84;
    const sphere = import__8.BoundingSphere.fromEllipsoid(ellipsoid);
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(ellipsoid.maximumRadius);
  });
  it("fromEllipsoid with a result parameter", function() {
    const ellipsoid = import__8.Ellipsoid.WGS84;
    const sphere = new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 4);
    const result = import__8.BoundingSphere.fromEllipsoid(ellipsoid, sphere);
    expect(result).toBe(sphere);
    expect(result).toEqual(
      new import__8.BoundingSphere(import__8.Cartesian3.ZERO, ellipsoid.maximumRadius)
    );
  });
  it("fromEllipsoid throws without ellipsoid", function() {
    expect(function() {
      import__8.BoundingSphere.fromEllipsoid();
    }).toThrowDeveloperError();
  });
  it("fromBoundingSpheres with undefined returns an empty sphere", function() {
    const sphere = import__8.BoundingSphere.fromBoundingSpheres();
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromBoundingSpheres with empty array returns an empty sphere", function() {
    const sphere = import__8.BoundingSphere.fromBoundingSpheres([]);
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("fromBoundingSpheres works with 1 sphere", function() {
    const one = new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 4);
    const sphere = import__8.BoundingSphere.fromBoundingSpheres([one]);
    expect(sphere).toEqual(one);
  });
  it("fromBoundingSpheres works with 2 spheres", function() {
    const one = new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 4);
    const two = new import__8.BoundingSphere(new import__8.Cartesian3(5, 6, 7), 8);
    const sphere = import__8.BoundingSphere.fromBoundingSpheres([one, two]);
    expect(sphere).toEqual(
      import__8.BoundingSphere.union(one, two, new import__8.BoundingSphere())
    );
  });
  it("fromBoundingSpheres works with 3 spheres", function() {
    const one = new import__8.BoundingSphere(new import__8.Cartesian3(0, 0, 0), 1);
    const two = new import__8.BoundingSphere(new import__8.Cartesian3(0, 3, 0), 1);
    const three = new import__8.BoundingSphere(new import__8.Cartesian3(0, 0, 4), 1);
    const expected = new import__8.BoundingSphere(new import__8.Cartesian3(0, 1.5, 2), 3.5);
    const sphere = import__8.BoundingSphere.fromBoundingSpheres([one, two, three]);
    expect(sphere).toEqual(expected);
  });
  it("fromOrientedBoundingBox works with a result", function() {
    const box = import__8.OrientedBoundingBox.fromPoints(getPositions());
    const sphere = new import__8.BoundingSphere();
    import__8.BoundingSphere.fromOrientedBoundingBox(box, sphere);
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toBeGreaterThan(1.5);
    expect(sphere.radius).toBeLessThan(2);
  });
  it("fromOrientedBoundingBox works without a result parameter", function() {
    const box = import__8.OrientedBoundingBox.fromPoints(getPositions());
    const sphere = import__8.BoundingSphere.fromOrientedBoundingBox(box);
    expect(sphere.center).toEqual(positionsCenter);
    expect(sphere.radius).toBeGreaterThan(1.5);
    expect(sphere.radius).toBeLessThan(2);
  });
  it("throws from fromOrientedBoundingBox with undefined orientedBoundingBox parameter", function() {
    expect(function() {
      import__8.BoundingSphere.fromOrientedBoundingBox(void 0);
    }).toThrowDeveloperError();
  });
  it("fromTransformation works with a result parameter", function() {
    const translation = new import__8.Cartesian3(1, 2, 3);
    const rotation = import__8.Quaternion.fromAxisAngle(import__8.Cartesian3.UNIT_Z, 0.4);
    const scale = new import__8.Cartesian3(1, 2, 3);
    const expectedRadius = 0.5 * import__8.Cartesian3.magnitude(scale);
    const transformation = import__8.Matrix4.fromTranslationQuaternionRotationScale(
      translation,
      rotation,
      scale
    );
    const sphere = new import__8.BoundingSphere();
    const result = import__8.BoundingSphere.fromTransformation(transformation, sphere);
    expect(result.center).toEqual(translation);
    expect(result.radius).toEqualEpsilon(expectedRadius, import__8.Math.EPSILON14);
    expect(result).toBe(sphere);
  });
  it("fromTransformation works without a result parameter", function() {
    const translation = new import__8.Cartesian3(1, 2, 3);
    const rotation = import__8.Quaternion.fromAxisAngle(import__8.Cartesian3.UNIT_Z, 0.4);
    const scale = new import__8.Cartesian3(1, 2, 3);
    const expectedRadius = 0.5 * import__8.Cartesian3.magnitude(scale);
    const transformation = import__8.Matrix4.fromTranslationQuaternionRotationScale(
      translation,
      rotation,
      scale
    );
    const sphere = import__8.BoundingSphere.fromTransformation(transformation);
    expect(sphere.center).toEqual(translation);
    expect(sphere.radius).toEqualEpsilon(expectedRadius, import__8.Math.EPSILON14);
  });
  it("fromTransformation works with a transformation that has zero scale", function() {
    const transformation = import__8.Matrix4.fromScale(import__8.Cartesian3.ZERO);
    const sphere = import__8.BoundingSphere.fromTransformation(transformation);
    expect(sphere.center).toEqual(import__8.Cartesian3.ZERO);
    expect(sphere.radius).toEqual(0);
  });
  it("throws from fromTransformation with undefined transformation parameter", function() {
    expect(function() {
      import__8.BoundingSphere.fromTransformation(void 0);
    }).toThrowDeveloperError();
  });
  it("intersectPlane with sphere on the positive side of a plane", function() {
    const sphere = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 0.5);
    const normal = import__8.Cartesian3.negate(import__8.Cartesian3.UNIT_X, new import__8.Cartesian3());
    const position = import__8.Cartesian3.UNIT_X;
    const plane = new import__8.Plane(normal, -import__8.Cartesian3.dot(normal, position));
    expect(sphere.intersectPlane(plane)).toEqual(import__8.Intersect.INSIDE);
  });
  it("intersectPlane with sphere on the negative side of a plane", function() {
    const sphere = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 0.5);
    const normal = import__8.Cartesian3.UNIT_X;
    const position = import__8.Cartesian3.UNIT_X;
    const plane = new import__8.Plane(normal, -import__8.Cartesian3.dot(normal, position));
    expect(sphere.intersectPlane(plane)).toEqual(import__8.Intersect.OUTSIDE);
  });
  it("intersectPlane with sphere intersecting a plane", function() {
    const sphere = new import__8.BoundingSphere(import__8.Cartesian3.UNIT_X, 0.5);
    const normal = import__8.Cartesian3.UNIT_X;
    const position = import__8.Cartesian3.UNIT_X;
    const plane = new import__8.Plane(normal, -import__8.Cartesian3.dot(normal, position));
    expect(sphere.intersectPlane(plane)).toEqual(import__8.Intersect.INTERSECTING);
  });
  it("expands to contain another sphere", function() {
    const bs1 = new import__8.BoundingSphere(
      import__8.Cartesian3.negate(import__8.Cartesian3.UNIT_X, new import__8.Cartesian3()),
      1
    );
    const bs2 = new import__8.BoundingSphere(import__8.Cartesian3.UNIT_X, 1);
    const expected = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 2);
    expect(import__8.BoundingSphere.union(bs1, bs2)).toEqual(expected);
  });
  it("union left sphere encloses right", function() {
    const bs1 = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 3);
    const bs2 = new import__8.BoundingSphere(import__8.Cartesian3.UNIT_X, 1);
    const union = import__8.BoundingSphere.union(bs1, bs2);
    expect(union).toEqual(bs1);
  });
  it("union of co-located spheres, right sphere encloses left", function() {
    const bs1 = new import__8.BoundingSphere(import__8.Cartesian3.UNIT_X, 1);
    const bs2 = new import__8.BoundingSphere(import__8.Cartesian3.UNIT_X, 2);
    const union = import__8.BoundingSphere.union(bs1, bs2);
    expect(union).toEqual(bs2);
  });
  it("union result parameter is a tight fit", function() {
    const bs1 = new import__8.BoundingSphere(
      import__8.Cartesian3.multiplyByScalar(
        import__8.Cartesian3.negate(import__8.Cartesian3.UNIT_X, new import__8.Cartesian3()),
        3,
        new import__8.Cartesian3()
      ),
      3
    );
    const bs2 = new import__8.BoundingSphere(import__8.Cartesian3.UNIT_X, 1);
    const expected = new import__8.BoundingSphere(
      import__8.Cartesian3.multiplyByScalar(
        import__8.Cartesian3.negate(import__8.Cartesian3.UNIT_X, new import__8.Cartesian3()),
        2,
        new import__8.Cartesian3()
      ),
      4
    );
    import__8.BoundingSphere.union(bs1, bs2, bs1);
    expect(bs1).toEqual(expected);
  });
  it("expands to contain another point", function() {
    const bs = new import__8.BoundingSphere(
      import__8.Cartesian3.negate(import__8.Cartesian3.UNIT_X, new import__8.Cartesian3()),
      1
    );
    const point = import__8.Cartesian3.UNIT_X;
    const expected = new import__8.BoundingSphere(
      import__8.Cartesian3.negate(import__8.Cartesian3.UNIT_X, new import__8.Cartesian3()),
      2
    );
    expect(import__8.BoundingSphere.expand(bs, point)).toEqual(expected);
  });
  it("applies transform", function() {
    const bs = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1);
    const transform = import__8.Matrix4.fromTranslation(new import__8.Cartesian3(1, 2, 3));
    const expected = new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 1);
    expect(import__8.BoundingSphere.transform(bs, transform)).toEqual(expected);
  });
  it("applies scale transform", function() {
    const bs = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1);
    const transform = import__8.Matrix4.fromScale(new import__8.Cartesian3(1, 2, 3));
    const expected = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 3);
    expect(import__8.BoundingSphere.transform(bs, transform)).toEqual(expected);
  });
  it("applies transform without scale", function() {
    const bs = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1);
    const transform = import__8.Matrix4.fromTranslation(new import__8.Cartesian3(1, 2, 3));
    const expected = new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 1);
    expect(import__8.BoundingSphere.transformWithoutScale(bs, transform)).toEqual(
      expected
    );
  });
  it("transformWithoutScale ignores scale", function() {
    const bs = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1);
    const transform = import__8.Matrix4.fromScale(new import__8.Cartesian3(1, 2, 3));
    const expected = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1);
    expect(import__8.BoundingSphere.transformWithoutScale(bs, transform)).toEqual(
      expected
    );
  });
  it("finds distances", function() {
    const bs = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1);
    const position = new import__8.Cartesian3(-2, 1, 0);
    const direction = import__8.Cartesian3.UNIT_X;
    const expected = new import__8.Interval(1, 3);
    expect(
      import__8.BoundingSphere.computePlaneDistances(bs, position, direction)
    ).toEqual(expected);
  });
  it("distance squared to point outside of sphere", function() {
    const bs = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1);
    const position = new import__8.Cartesian3(-2, 1, 0);
    const expected = 1.52786405;
    expect(import__8.BoundingSphere.distanceSquaredTo(bs, position)).toEqualEpsilon(
      expected,
      import__8.Math.EPSILON6
    );
  });
  it("distance squared to point inside sphere", function() {
    const bs = new import__8.BoundingSphere(import__8.Cartesian3.ZERO, 1);
    const position = new import__8.Cartesian3(-0.5, 0.5, 0);
    expect(import__8.BoundingSphere.distanceSquaredTo(bs, position)).toEqual(0);
  });
  it("projectTo2D", function() {
    const positions = getPositions();
    const projection = new import__8.GeographicProjection();
    const positions2D = [];
    for (let i = 0; i < positions.length; ++i) {
      const position = positions[i];
      const cartographic = projection.ellipsoid.cartesianToCartographic(
        position
      );
      positions2D.push(projection.project(cartographic));
    }
    const boundingSphere3D = import__8.BoundingSphere.fromPoints(positions);
    const boundingSphere2D = import__8.BoundingSphere.projectTo2D(
      boundingSphere3D,
      projection
    );
    const actualSphere = import__8.BoundingSphere.fromPoints(positions2D);
    actualSphere.center = new import__8.Cartesian3(
      actualSphere.center.z,
      actualSphere.center.x,
      actualSphere.center.y
    );
    expect(boundingSphere2D.center).toEqualEpsilon(
      actualSphere.center,
      import__8.Math.EPSILON6
    );
    expect(boundingSphere2D.radius).toBeGreaterThan(actualSphere.radius);
  });
  it("projectTo2D with result parameter", function() {
    const positions = getPositions();
    const projection = new import__8.GeographicProjection();
    const sphere = new import__8.BoundingSphere();
    const positions2D = [];
    for (let i = 0; i < positions.length; ++i) {
      const position = positions[i];
      const cartographic = projection.ellipsoid.cartesianToCartographic(
        position
      );
      positions2D.push(projection.project(cartographic));
    }
    const boundingSphere3D = import__8.BoundingSphere.fromPoints(positions);
    const boundingSphere2D = import__8.BoundingSphere.projectTo2D(
      boundingSphere3D,
      projection,
      sphere
    );
    const actualSphere = import__8.BoundingSphere.fromPoints(positions2D);
    actualSphere.center = new import__8.Cartesian3(
      actualSphere.center.z,
      actualSphere.center.x,
      actualSphere.center.y
    );
    expect(boundingSphere2D).toBe(sphere);
    expect(boundingSphere2D.center).toEqualEpsilon(
      actualSphere.center,
      import__8.Math.EPSILON6
    );
    expect(boundingSphere2D.radius).toBeGreaterThan(actualSphere.radius);
  });
  it("can pack and unpack", function() {
    const array = [];
    const boundingSphere = new import__8.BoundingSphere();
    boundingSphere.center = new import__8.Cartesian3(1, 2, 3);
    boundingSphere.radius = 4;
    import__8.BoundingSphere.pack(boundingSphere, array);
    expect(array.length).toEqual(import__8.BoundingSphere.packedLength);
    expect(import__8.BoundingSphere.unpack(array)).toEqual(boundingSphere);
  });
  it("can pack and unpack with offset", function() {
    const packed = new Array(3);
    const offset = 3;
    const boundingSphere = new import__8.BoundingSphere();
    boundingSphere.center = new import__8.Cartesian3(1, 2, 3);
    boundingSphere.radius = 4;
    import__8.BoundingSphere.pack(boundingSphere, packed, offset);
    expect(packed.length).toEqual(offset + import__8.BoundingSphere.packedLength);
    const result = new import__8.BoundingSphere();
    const returnedResult = import__8.BoundingSphere.unpack(packed, offset, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(boundingSphere);
  });
  it("pack throws with undefined boundingSphere", function() {
    const array = [];
    expect(function() {
      import__8.BoundingSphere.pack(void 0, array);
    }).toThrowDeveloperError();
  });
  it("pack throws with undefined array", function() {
    const boundingSphere = new import__8.BoundingSphere();
    expect(function() {
      import__8.BoundingSphere.pack(boundingSphere, void 0);
    }).toThrowDeveloperError();
  });
  it("unpack throws with undefined array", function() {
    expect(function() {
      import__8.BoundingSphere.unpack(void 0);
    }).toThrowDeveloperError();
  });
  it("static projectTo2D throws without sphere", function() {
    expect(function() {
      import__8.BoundingSphere.projectTo2D();
    }).toThrowDeveloperError();
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__8.BoundingSphere.clone()).toBeUndefined();
  });
  it("union throws with no left parameter", function() {
    const right = new import__8.BoundingSphere();
    expect(function() {
      import__8.BoundingSphere.union(void 0, right);
    }).toThrowDeveloperError();
  });
  it("union throws with no right parameter", function() {
    const left = new import__8.BoundingSphere();
    expect(function() {
      import__8.BoundingSphere.union(left, void 0);
    }).toThrowDeveloperError();
  });
  it("expand throws without a sphere", function() {
    const plane = new import__8.Cartesian3();
    expect(function() {
      import__8.BoundingSphere.expand(void 0, plane);
    }).toThrowDeveloperError();
  });
  it("expand throws without a point", function() {
    const sphere = new import__8.BoundingSphere();
    expect(function() {
      import__8.BoundingSphere.expand(sphere, void 0);
    }).toThrowDeveloperError();
  });
  it("intersectPlane throws without a sphere", function() {
    const plane = new import__8.Plane(import__8.Cartesian3.UNIT_X, 0);
    expect(function() {
      import__8.BoundingSphere.intersectPlane(void 0, plane);
    }).toThrowDeveloperError();
  });
  it("intersectPlane throws without a plane", function() {
    const sphere = new import__8.BoundingSphere();
    expect(function() {
      import__8.BoundingSphere.intersectPlane(sphere, void 0);
    }).toThrowDeveloperError();
  });
  it("transform throws without a sphere", function() {
    expect(function() {
      import__8.BoundingSphere.transform();
    }).toThrowDeveloperError();
  });
  it("transform throws without a transform", function() {
    const sphere = new import__8.BoundingSphere();
    expect(function() {
      import__8.BoundingSphere.transform(sphere);
    }).toThrowDeveloperError();
  });
  it("distanceSquaredTo throws without a sphere", function() {
    expect(function() {
      import__8.BoundingSphere.distanceSquaredTo();
    }).toThrowDeveloperError();
  });
  it("distanceSquaredTo throws without a cartesian", function() {
    expect(function() {
      import__8.BoundingSphere.distanceSquaredTo(new import__8.BoundingSphere());
    }).toThrowDeveloperError();
  });
  it("transformWithoutScale throws without a sphere", function() {
    expect(function() {
      import__8.BoundingSphere.transformWithoutScale();
    }).toThrowDeveloperError();
  });
  it("transformWithoutScale throws without a transform", function() {
    const sphere = new import__8.BoundingSphere();
    expect(function() {
      import__8.BoundingSphere.transformWithoutScale(sphere);
    }).toThrowDeveloperError();
  });
  it("computePlaneDistances throws without a sphere", function() {
    expect(function() {
      import__8.BoundingSphere.computePlaneDistances();
    }).toThrowDeveloperError();
  });
  it("computePlaneDistances throws without a position", function() {
    expect(function() {
      import__8.BoundingSphere.computePlaneDistances(new import__8.BoundingSphere());
    }).toThrowDeveloperError();
  });
  it("computePlaneDistances throws without a direction", function() {
    expect(function() {
      import__8.BoundingSphere.computePlaneDistances(
        new import__8.BoundingSphere(),
        new import__8.Cartesian3()
      );
    }).toThrowDeveloperError();
  });
  it("isOccluded throws without a sphere", function() {
    expect(function() {
      import__8.BoundingSphere.isOccluded();
    }).toThrowDeveloperError();
  });
  it("isOccluded throws without an occluder", function() {
    expect(function() {
      import__8.BoundingSphere.isOccluded(new import__8.BoundingSphere());
    }).toThrowDeveloperError();
  });
  function expectBoundingSphereToContainPoint(boundingSphere, point, projection) {
    const pointInCartesian = projection.project(point);
    let distanceFromCenter = import__8.Cartesian3.magnitude(
      import__8.Cartesian3.subtract(
        pointInCartesian,
        boundingSphere.center,
        new import__8.Cartesian3()
      )
    );
    distanceFromCenter -= import__8.Math.EPSILON9;
    expect(distanceFromCenter).toBeLessThanOrEqual(boundingSphere.radius);
  }
  it("fromRectangleWithHeights2D includes specified min and max heights", function() {
    const rectangle = new import__8.Rectangle(0.1, 0.5, 0.2, 0.6);
    const projection = new import__8.GeographicProjection();
    const minHeight = -327;
    const maxHeight = 2456;
    const boundingSphere = import__8.BoundingSphere.fromRectangleWithHeights2D(
      rectangle,
      projection,
      minHeight,
      maxHeight
    );
    let point = import__8.Rectangle.southwest(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.southwest(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.northeast(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.northeast(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.southeast(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.southeast(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.northwest(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.northwest(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.center(rectangle).clone();
    point.height = minHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = import__8.Rectangle.center(rectangle).clone();
    point.height = maxHeight;
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__8.Cartographic(
      import__8.Rectangle.center(rectangle).longitude,
      rectangle.south,
      minHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__8.Cartographic(
      import__8.Rectangle.center(rectangle).longitude,
      rectangle.south,
      maxHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__8.Cartographic(
      import__8.Rectangle.center(rectangle).longitude,
      rectangle.north,
      minHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__8.Cartographic(
      import__8.Rectangle.center(rectangle).longitude,
      rectangle.north,
      maxHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__8.Cartographic(
      rectangle.west,
      import__8.Rectangle.center(rectangle).latitude,
      minHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__8.Cartographic(
      rectangle.west,
      import__8.Rectangle.center(rectangle).latitude,
      maxHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__8.Cartographic(
      rectangle.east,
      import__8.Rectangle.center(rectangle).latitude,
      minHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
    point = new import__8.Cartographic(
      rectangle.east,
      import__8.Rectangle.center(rectangle).latitude,
      maxHeight
    );
    expectBoundingSphereToContainPoint(boundingSphere, point, projection);
  });
  it("computes the volume of a BoundingSphere", function() {
    const sphere = new import__8.BoundingSphere(new import__8.Cartesian3(), 1);
    const computedVolume = sphere.volume();
    const expectedVolume = 4 / 3 * import__8.Math.PI;
    expect(computedVolume).toEqualEpsilon(expectedVolume, import__8.Math.EPSILON6);
  });
  createPackableSpecs_default(
    import__8.BoundingSphere,
    new import__8.BoundingSphere(new import__8.Cartesian3(1, 2, 3), 4),
    [1, 2, 3, 4]
  );
});

// packages/engine/Specs/Core/BoxGeometrySpec.js
var import__9 = __toESM(require_Cesium(), 1);
describe("Core/BoxGeometry", function() {
  it("constructor throws without maximum corner", function() {
    expect(function() {
      return new import__9.BoxGeometry({
        maximum: new import__9.Cartesian3()
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without minimum corner", function() {
    expect(function() {
      return new import__9.BoxGeometry({
        minimum: new import__9.Cartesian3()
      });
    }).toThrowDeveloperError();
  });
  it("constructor creates optimized number of positions for VertexFormat.POSITIONS_ONLY", function() {
    const m = import__9.BoxGeometry.createGeometry(
      new import__9.BoxGeometry({
        minimum: new import__9.Cartesian3(-1, -2, -3),
        maximum: new import__9.Cartesian3(1, 2, 3),
        vertexFormat: import__9.VertexFormat.POSITION_ONLY
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(12 * 3);
  });
  it("constructor computes all vertex attributes", function() {
    const minimumCorner = new import__9.Cartesian3(0, 0, 0);
    const maximumCorner = new import__9.Cartesian3(1, 1, 1);
    const m = import__9.BoxGeometry.createGeometry(
      new import__9.BoxGeometry({
        minimum: minimumCorner,
        maximum: maximumCorner,
        vertexFormat: import__9.VertexFormat.ALL
      })
    );
    const numVertices = 24;
    const numTriangles = 12;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.center).toEqual(import__9.Cartesian3.ZERO);
    expect(m.boundingSphere.radius).toEqual(
      import__9.Cartesian3.magnitude(maximumCorner) * 0.5
    );
  });
  it("computes offset attribute", function() {
    const m = import__9.BoxGeometry.createGeometry(
      new import__9.BoxGeometry({
        minimum: new import__9.Cartesian3(-1, -2, -3),
        maximum: new import__9.Cartesian3(1, 2, 3),
        vertexFormat: import__9.VertexFormat.POSITION_ONLY,
        offsetAttribute: import__9.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("fromDimensions throws without dimensions", function() {
    expect(function() {
      return import__9.BoxGeometry.fromDimensions();
    }).toThrowDeveloperError();
  });
  it("fromDimensions throws with negative dimensions", function() {
    expect(function() {
      return import__9.BoxGeometry.fromDimensions({
        dimensions: new import__9.Cartesian3(1, 2, -1)
      });
    }).toThrowDeveloperError();
  });
  it("fromDimensions", function() {
    const m = import__9.BoxGeometry.createGeometry(
      import__9.BoxGeometry.fromDimensions({
        dimensions: new import__9.Cartesian3(1, 2, 3),
        vertexFormat: import__9.VertexFormat.POSITION_ONLY
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(12 * 3);
  });
  it("fromAxisAlignedBoundingBox throws with no boundingBox", function() {
    expect(function() {
      return import__9.BoxGeometry.fromAxisAlignedBoundingBox(void 0);
    }).toThrowDeveloperError();
  });
  it("fromAxisAlignedBoundingBox", function() {
    const min = new import__9.Cartesian3(-1, -2, -3);
    const max = new import__9.Cartesian3(1, 2, 3);
    const m = import__9.BoxGeometry.fromAxisAlignedBoundingBox(
      new import__9.AxisAlignedBoundingBox(min, max)
    );
    expect(m._minimum).toEqual(min);
    expect(m._maximum).toEqual(max);
  });
  it("undefined is returned if min and max are equal", function() {
    const box = new import__9.BoxGeometry({
      vertexFormat: import__9.VertexFormat.POSITION_ONLY,
      maximum: new import__9.Cartesian3(25e4, 25e4, 25e4),
      minimum: new import__9.Cartesian3(25e4, 25e4, 25e4)
    });
    const geometry = import__9.BoxGeometry.createGeometry(box);
    expect(geometry).toBeUndefined();
  });
  createPackableSpecs_default(
    import__9.BoxGeometry,
    new import__9.BoxGeometry({
      minimum: new import__9.Cartesian3(1, 2, 3),
      maximum: new import__9.Cartesian3(4, 5, 6),
      vertexFormat: import__9.VertexFormat.POSITION_AND_NORMAL
    }),
    [1, 2, 3, 4, 5, 6, 1, 1, 0, 0, 0, 0, -1]
  );
});

// packages/engine/Specs/Core/BoxOutlineGeometrySpec.js
var import__10 = __toESM(require_Cesium(), 1);
describe("Core/BoxOutlineGeometry", function() {
  it("constructor throws without maximum corner", function() {
    expect(function() {
      return new import__10.BoxOutlineGeometry({
        maximum: new import__10.Cartesian3()
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without minimum corner", function() {
    expect(function() {
      return new import__10.BoxOutlineGeometry({
        minimum: new import__10.Cartesian3()
      });
    }).toThrowDeveloperError();
  });
  it("constructor creates positions", function() {
    const m = import__10.BoxOutlineGeometry.createGeometry(
      new import__10.BoxOutlineGeometry({
        minimum: new import__10.Cartesian3(-1, -2, -3),
        maximum: new import__10.Cartesian3(1, 2, 3)
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(12 * 2);
  });
  it("computes offset attribute", function() {
    const m = import__10.BoxOutlineGeometry.createGeometry(
      new import__10.BoxOutlineGeometry({
        minimum: new import__10.Cartesian3(-1, -2, -3),
        maximum: new import__10.Cartesian3(1, 2, 3),
        offsetAttribute: import__10.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("fromDimensions throws without dimensions", function() {
    expect(function() {
      return import__10.BoxOutlineGeometry.fromDimensions();
    }).toThrowDeveloperError();
  });
  it("fromDimensions throws with negative dimensions", function() {
    expect(function() {
      return import__10.BoxOutlineGeometry.fromDimensions({
        dimensions: new import__10.Cartesian3(1, 2, -1)
      });
    }).toThrowDeveloperError();
  });
  it("fromDimensions", function() {
    const m = import__10.BoxOutlineGeometry.createGeometry(
      import__10.BoxOutlineGeometry.fromDimensions({
        dimensions: new import__10.Cartesian3(1, 2, 3)
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(12 * 2);
  });
  it("fromAxisAlignedBoundingBox throws with no boundingBox", function() {
    expect(function() {
      return import__10.BoxOutlineGeometry.fromAxisAlignedBoundingBox(void 0);
    }).toThrowDeveloperError();
  });
  it("fromAxisAlignedBoundingBox", function() {
    const min = new import__10.Cartesian3(-1, -2, -3);
    const max = new import__10.Cartesian3(1, 2, 3);
    const m = import__10.BoxOutlineGeometry.fromAxisAlignedBoundingBox(
      new import__10.AxisAlignedBoundingBox(min, max)
    );
    expect(m._min).toEqual(min);
    expect(m._max).toEqual(max);
  });
  it("undefined is returned if min and max are equal", function() {
    const box = new import__10.BoxOutlineGeometry({
      maximum: new import__10.Cartesian3(25e4, 25e4, 25e4),
      minimum: new import__10.Cartesian3(25e4, 25e4, 25e4)
    });
    const geometry = import__10.BoxOutlineGeometry.createGeometry(box);
    expect(geometry).toBeUndefined();
  });
  createPackableSpecs_default(
    import__10.BoxOutlineGeometry,
    new import__10.BoxOutlineGeometry({
      minimum: new import__10.Cartesian3(1, 2, 3),
      maximum: new import__10.Cartesian3(4, 5, 6)
    }),
    [1, 2, 3, 4, 5, 6, -1]
  );
});

// packages/engine/Specs/Core/Cartesian2Spec.js
var import__11 = __toESM(require_Cesium(), 1);

// Specs/createPackableArraySpecs.js
var import_engine2 = __toESM(require_Cesium(), 1);
function createPackableArraySpecs(packable, unpackedArray, packedArray, stride, namePrefix) {
  namePrefix = (0, import_engine2.defaultValue)(namePrefix, "");
  it(`${namePrefix} can pack`, function() {
    const actualPackedArray = packable.packArray(unpackedArray);
    expect(actualPackedArray.length).toEqual(packedArray.length);
    expect(actualPackedArray).toEqual(packedArray);
  });
  it(`${namePrefix} can roundtrip`, function() {
    const actualPackedArray = packable.packArray(unpackedArray);
    const result = packable.unpackArray(actualPackedArray);
    expect(result).toEqual(unpackedArray);
  });
  it(`${namePrefix} can unpack`, function() {
    const result = packable.unpackArray(packedArray);
    expect(result).toEqual(unpackedArray);
  });
  it(`${namePrefix} packArray works with typed arrays`, function() {
    const typedArray = new Float64Array(packedArray.length);
    const result = packable.packArray(unpackedArray, typedArray);
    expect(result).toEqual(new Float64Array(packedArray));
  });
  it(`${namePrefix} packArray resizes arrays as needed`, function() {
    const emptyArray = [];
    let result = packable.packArray(unpackedArray, emptyArray);
    expect(result).toEqual(packedArray);
    const largerArray = new Array(packedArray.length + 1).fill(0);
    result = packable.packArray(unpackedArray, largerArray);
    expect(result).toEqual(packedArray);
  });
  it(`${namePrefix} packArray throws with undefined array`, function() {
    expect(function() {
      packable.packArray(void 0);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} packArray throws for typed arrays of the wrong size`, function() {
    expect(function() {
      const tooSmall = new Float64Array(0);
      packable.packArray(unpackedArray, tooSmall);
    }).toThrowDeveloperError();
    expect(function() {
      const tooBig = new Float64Array(10);
      packable.packArray(unpackedArray, tooBig);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} unpackArray works for typed arrays`, function() {
    const array = packable.unpackArray(new Float64Array(packedArray));
    expect(array).toEqual(unpackedArray);
  });
  it(`${namePrefix} unpackArray throws with undefined array`, function() {
    expect(function() {
      packable.unpackArray(void 0);
    }).toThrowDeveloperError();
  });
  it(`${namePrefix} unpackArray works with a result parameter`, function() {
    let array = [];
    let result = packable.unpackArray(packedArray, array);
    expect(result).toBe(array);
    expect(result).toEqual(unpackedArray);
    const PackableClass = packable;
    array = new Array(unpackedArray.length);
    for (let i = 0; i < unpackedArray.length; i++) {
      array[i] = new PackableClass();
    }
    result = packable.unpackArray(packedArray, array);
    expect(result).toBe(array);
    expect(result).toEqual(unpackedArray);
  });
  it(`${namePrefix} unpackArray throws with array less than the minimum length`, function() {
    expect(function() {
      packable.unpackArray([1]);
    }).toThrowDeveloperError();
  });
  it("unpackArray throws with array not multiple of stride", function() {
    expect(function() {
      packable.unpackArray(new Array(stride + 1).fill(1));
    }).toThrowDeveloperError();
  });
}
var createPackableArraySpecs_default = createPackableArraySpecs;

// packages/engine/Specs/Core/Cartesian2Spec.js
describe("Core/Cartesian2", function() {
  it("construct with default values", function() {
    const cartesian = new import__11.Cartesian2();
    expect(cartesian.x).toEqual(0);
    expect(cartesian.y).toEqual(0);
  });
  it("construct with only an x value", function() {
    const cartesian = new import__11.Cartesian2(1);
    expect(cartesian.x).toEqual(1);
    expect(cartesian.y).toEqual(0);
  });
  it("construct with all values", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    expect(cartesian.x).toEqual(1);
    expect(cartesian.y).toEqual(2);
  });
  it("fromArray creates a Cartesian2", function() {
    let cartesian = new import__11.Cartesian2();
    cartesian = import__11.Cartesian2.fromArray([1, 2]);
    expect(cartesian).toEqual(new import__11.Cartesian2(1, 2));
  });
  it("fromArray with an offset creates a Cartesian2", function() {
    let cartesian = new import__11.Cartesian2();
    cartesian = import__11.Cartesian2.fromArray([0, 1, 2, 0], 1);
    expect(cartesian).toEqual(new import__11.Cartesian2(1, 2));
  });
  it("fromArray throws without values", function() {
    expect(function() {
      import__11.Cartesian2.fromArray();
    }).toThrowDeveloperError();
  });
  it("clone with a result parameter", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    const result = new import__11.Cartesian2();
    const returnedResult = import__11.Cartesian2.clone(cartesian, result);
    expect(cartesian).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(cartesian).toEqual(result);
  });
  it("clone works with a result parameter that is an input parameter", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    const returnedResult = import__11.Cartesian2.clone(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
  });
  it("maximumComponent works when X is greater", function() {
    const cartesian = new import__11.Cartesian2(2, 1);
    expect(import__11.Cartesian2.maximumComponent(cartesian)).toEqual(cartesian.x);
  });
  it("maximumComponent works when Y is greater", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    expect(import__11.Cartesian2.maximumComponent(cartesian)).toEqual(cartesian.y);
  });
  it("minimumComponent works when X is lesser", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    expect(import__11.Cartesian2.minimumComponent(cartesian)).toEqual(cartesian.x);
  });
  it("minimumComponent works when Y is lesser", function() {
    const cartesian = new import__11.Cartesian2(2, 1);
    expect(import__11.Cartesian2.minimumComponent(cartesian)).toEqual(cartesian.y);
  });
  it("minimumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__11.Cartesian2();
    first = new import__11.Cartesian2(2, 0);
    second = new import__11.Cartesian2(1, 0);
    expected = new import__11.Cartesian2(1, 0);
    expect(import__11.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(1, 0);
    second = new import__11.Cartesian2(2, 0);
    expected = new import__11.Cartesian2(1, 0);
    expect(import__11.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(2, -15);
    second = new import__11.Cartesian2(1, -20);
    expected = new import__11.Cartesian2(1, -20);
    expect(import__11.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(2, -20);
    second = new import__11.Cartesian2(1, -15);
    expected = new import__11.Cartesian2(1, -20);
    expect(import__11.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(2, -15);
    second = new import__11.Cartesian2(1, -20);
    expected = new import__11.Cartesian2(1, -20);
    expect(import__11.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(2, -15);
    second = new import__11.Cartesian2(1, -20);
    expected = new import__11.Cartesian2(1, -20);
    expect(import__11.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent with a result parameter", function() {
    const first = new import__11.Cartesian2(2, 0);
    const second = new import__11.Cartesian2(1, 0);
    const expected = new import__11.Cartesian2(1, 0);
    const result = new import__11.Cartesian2();
    const returnedResult = import__11.Cartesian2.minimumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("minimumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__11.Cartesian2(2, 0);
    const second = new import__11.Cartesian2(1, 0);
    const expected = new import__11.Cartesian2(1, 0);
    expect(import__11.Cartesian2.minimumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__11.Cartesian2.minimumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("minimumByComponent throws without first", function() {
    expect(function() {
      import__11.Cartesian2.minimumByComponent();
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws without second", function() {
    expect(function() {
      import__11.Cartesian2.minimumByComponent(new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("minimumByComponent works when first's or second's X is lesser", function() {
    const first = new import__11.Cartesian2(2, 0);
    const second = new import__11.Cartesian2(1, 0);
    const expected = new import__11.Cartesian2(1, 0);
    expect(import__11.Cartesian2.minimumByComponent(first, second, expected)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 2;
    expect(import__11.Cartesian2.minimumByComponent(first, second, expected)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Y is lesser", function() {
    const first = new import__11.Cartesian2(0, 2);
    const second = new import__11.Cartesian2(0, 1);
    const expected = new import__11.Cartesian2(0, 1);
    const result = new import__11.Cartesian2();
    expect(import__11.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 2;
    expect(import__11.Cartesian2.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__11.Cartesian2();
    first = new import__11.Cartesian2(2, 0);
    second = new import__11.Cartesian2(1, 0);
    expected = new import__11.Cartesian2(2, 0);
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(1, 0);
    second = new import__11.Cartesian2(2, 0);
    expected = new import__11.Cartesian2(2, 0);
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(2, -15);
    second = new import__11.Cartesian2(1, -20);
    expected = new import__11.Cartesian2(2, -15);
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(2, -20);
    second = new import__11.Cartesian2(1, -15);
    expected = new import__11.Cartesian2(2, -15);
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(2, -15);
    second = new import__11.Cartesian2(1, -20);
    expected = new import__11.Cartesian2(2, -15);
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__11.Cartesian2(2, -15);
    second = new import__11.Cartesian2(1, -20);
    expected = new import__11.Cartesian2(2, -15);
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent with a result parameter", function() {
    const first = new import__11.Cartesian2(2, 0);
    const second = new import__11.Cartesian2(1, 0);
    const expected = new import__11.Cartesian2(2, 0);
    const result = new import__11.Cartesian2();
    const returnedResult = import__11.Cartesian2.maximumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("maximumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__11.Cartesian2(2, 0);
    const second = new import__11.Cartesian2(1, 0);
    const expected = new import__11.Cartesian2(2, 0);
    expect(import__11.Cartesian2.maximumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__11.Cartesian2.maximumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("maximumByComponent throws without first", function() {
    expect(function() {
      import__11.Cartesian2.maximumByComponent();
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws without second", function() {
    expect(function() {
      import__11.Cartesian2.maximumByComponent(new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent works when first's or second's X is greater", function() {
    const first = new import__11.Cartesian2(2, 0);
    const second = new import__11.Cartesian2(1, 0);
    const expected = new import__11.Cartesian2(2, 0);
    const result = new import__11.Cartesian2();
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 3;
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Y is greater", function() {
    const first = new import__11.Cartesian2(0, 2);
    const second = new import__11.Cartesian2(0, 1);
    const expected = new import__11.Cartesian2(0, 2);
    const result = new import__11.Cartesian2();
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 3;
    expect(import__11.Cartesian2.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("clamp", function() {
    let value;
    let min;
    let max;
    let expected;
    const result = new import__11.Cartesian2();
    value = new import__11.Cartesian2(-1, 0);
    min = new import__11.Cartesian2(0, 0);
    max = new import__11.Cartesian2(1, 1);
    expected = new import__11.Cartesian2(0, 0);
    expect(import__11.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__11.Cartesian2(2, 0);
    min = new import__11.Cartesian2(0, 0);
    max = new import__11.Cartesian2(1, 1);
    expected = new import__11.Cartesian2(1, 0);
    expect(import__11.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__11.Cartesian2(0, -1);
    min = new import__11.Cartesian2(0, 0);
    max = new import__11.Cartesian2(1, 1);
    expected = new import__11.Cartesian2(0, 0);
    expect(import__11.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__11.Cartesian2(0, 2);
    min = new import__11.Cartesian2(0, 0);
    max = new import__11.Cartesian2(1, 1);
    expected = new import__11.Cartesian2(0, 1);
    expect(import__11.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__11.Cartesian2(0, 0);
    min = new import__11.Cartesian2(0, 0);
    max = new import__11.Cartesian2(1, 1);
    expected = new import__11.Cartesian2(0, 0);
    expect(import__11.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__11.Cartesian2(0, 0);
    min = new import__11.Cartesian2(0, 0);
    max = new import__11.Cartesian2(1, 1);
    expected = new import__11.Cartesian2(0, 0);
    expect(import__11.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__11.Cartesian2(-2, 3);
    min = new import__11.Cartesian2(0, 0);
    max = new import__11.Cartesian2(1, 1);
    expected = new import__11.Cartesian2(0, 1);
    expect(import__11.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
    value = new import__11.Cartesian2(0, 0);
    min = new import__11.Cartesian2(1, 2);
    max = new import__11.Cartesian2(1, 2);
    expected = new import__11.Cartesian2(1, 2);
    expect(import__11.Cartesian2.clamp(value, min, max, result)).toEqual(expected);
  });
  it("clamp with a result parameter", function() {
    const value = new import__11.Cartesian2(-1, -1);
    const min = new import__11.Cartesian2(0, 0);
    const max = new import__11.Cartesian2(1, 1);
    const expected = new import__11.Cartesian2(0, 0);
    const result = new import__11.Cartesian2();
    const returnedResult = import__11.Cartesian2.clamp(value, min, max, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("clamp with a result parameter that is an input parameter", function() {
    const value = new import__11.Cartesian2(-1, -1);
    const min = new import__11.Cartesian2(0, 0);
    const max = new import__11.Cartesian2(1, 1);
    const expected = new import__11.Cartesian2(0, 0);
    expect(import__11.Cartesian2.clamp(value, min, max, value)).toEqual(expected);
    import__11.Cartesian2.fromElements(-1, -1, value);
    expect(import__11.Cartesian2.clamp(value, min, max, min)).toEqual(expected);
    import__11.Cartesian2.fromElements(0, 0, value);
    expect(import__11.Cartesian2.clamp(value, min, max, max)).toEqual(expected);
  });
  it("clamp throws without value", function() {
    expect(function() {
      import__11.Cartesian2.clamp();
    }).toThrowDeveloperError();
  });
  it("clamp throws without min", function() {
    expect(function() {
      import__11.Cartesian2.clamp(new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("clamp throws without max", function() {
    expect(function() {
      import__11.Cartesian2.clamp(new import__11.Cartesian2(), new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared", function() {
    const cartesian = new import__11.Cartesian2(2, 3);
    expect(import__11.Cartesian2.magnitudeSquared(cartesian)).toEqual(13);
  });
  it("magnitude", function() {
    const cartesian = new import__11.Cartesian2(2, 3);
    expect(import__11.Cartesian2.magnitude(cartesian)).toEqual(Math.sqrt(13));
  });
  it("distance", function() {
    const distance = import__11.Cartesian2.distance(
      new import__11.Cartesian2(1, 0),
      new import__11.Cartesian2(2, 0)
    );
    expect(distance).toEqual(1);
  });
  it("distance throws without left", function() {
    expect(function() {
      import__11.Cartesian2.distance();
    }).toThrowDeveloperError();
  });
  it("distance throws without right", function() {
    expect(function() {
      import__11.Cartesian2.distance(import__11.Cartesian2.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("distanceSquared", function() {
    const distanceSquared = import__11.Cartesian2.distanceSquared(
      new import__11.Cartesian2(1, 0),
      new import__11.Cartesian2(3, 0)
    );
    expect(distanceSquared).toEqual(4);
  });
  it("distanceSquared throws without left", function() {
    expect(function() {
      import__11.Cartesian2.distanceSquared();
    }).toThrowDeveloperError();
  });
  it("distanceSquared throws without right", function() {
    expect(function() {
      import__11.Cartesian2.distanceSquared(import__11.Cartesian2.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("normalize works with a result parameter", function() {
    const cartesian = new import__11.Cartesian2(2, 0);
    const expectedResult = new import__11.Cartesian2(1, 0);
    const result = new import__11.Cartesian2();
    const returnedResult = import__11.Cartesian2.normalize(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("normalize works with a result parameter that is an input parameter", function() {
    const cartesian = new import__11.Cartesian2(2, 0);
    const expectedResult = new import__11.Cartesian2(1, 0);
    const returnedResult = import__11.Cartesian2.normalize(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("normalize throws with zero vector", function() {
    expect(function() {
      import__11.Cartesian2.normalize(import__11.Cartesian2.ZERO, new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents works with a result parameter", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(4, 5);
    const result = new import__11.Cartesian2();
    const expectedResult = new import__11.Cartesian2(8, 15);
    const returnedResult = import__11.Cartesian2.multiplyComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyComponents works with a result parameter that is an input parameter", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(4, 5);
    const expectedResult = new import__11.Cartesian2(8, 15);
    const returnedResult = import__11.Cartesian2.multiplyComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(4, 5);
    const result = new import__11.Cartesian2();
    const expectedResult = new import__11.Cartesian2(0.5, 0.6);
    const returnedResult = import__11.Cartesian2.divideComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter that is an input parameter", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(4, 5);
    const expectedResult = new import__11.Cartesian2(0.5, 0.6);
    const returnedResult = import__11.Cartesian2.divideComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("dot", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(4, 5);
    const expectedResult = 23;
    const result = import__11.Cartesian2.dot(left, right);
    expect(result).toEqual(expectedResult);
  });
  it("cross", function() {
    const left = new import__11.Cartesian2(0, 1);
    const right = new import__11.Cartesian2(1, 0);
    const expectedResult = -1;
    const result = import__11.Cartesian2.cross(left, right);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(4, 5);
    const result = new import__11.Cartesian2();
    const expectedResult = new import__11.Cartesian2(6, 8);
    const returnedResult = import__11.Cartesian2.add(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter that is an input parameter", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(4, 5);
    const expectedResult = new import__11.Cartesian2(6, 8);
    const returnedResult = import__11.Cartesian2.add(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("subtract works with a result parameter", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(1, 5);
    const result = new import__11.Cartesian2();
    const expectedResult = new import__11.Cartesian2(1, -2);
    const returnedResult = import__11.Cartesian2.subtract(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("subtract works with this result parameter", function() {
    const left = new import__11.Cartesian2(2, 3);
    const right = new import__11.Cartesian2(1, 5);
    const expectedResult = new import__11.Cartesian2(1, -2);
    const returnedResult = import__11.Cartesian2.subtract(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    const result = new import__11.Cartesian2();
    const scalar = 2;
    const expectedResult = new import__11.Cartesian2(2, 4);
    const returnedResult = import__11.Cartesian2.multiplyByScalar(
      cartesian,
      scalar,
      result
    );
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter that is an input parameter", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    const scalar = 2;
    const expectedResult = new import__11.Cartesian2(2, 4);
    const returnedResult = import__11.Cartesian2.multiplyByScalar(
      cartesian,
      scalar,
      cartesian
    );
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    const result = new import__11.Cartesian2();
    const scalar = 2;
    const expectedResult = new import__11.Cartesian2(0.5, 1);
    const returnedResult = import__11.Cartesian2.divideByScalar(cartesian, scalar, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter that is an input parameter", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    const scalar = 2;
    const expectedResult = new import__11.Cartesian2(0.5, 1);
    const returnedResult = import__11.Cartesian2.divideByScalar(
      cartesian,
      scalar,
      cartesian
    );
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("negate with a result parameter", function() {
    const cartesian = new import__11.Cartesian2(1, -2);
    const result = new import__11.Cartesian2();
    const expectedResult = new import__11.Cartesian2(-1, 2);
    const returnedResult = import__11.Cartesian2.negate(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("negate with a result parameter that is an input parameter", function() {
    const cartesian = new import__11.Cartesian2(1, -2);
    const expectedResult = new import__11.Cartesian2(-1, 2);
    const returnedResult = import__11.Cartesian2.negate(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("abs with a result parameter", function() {
    const cartesian = new import__11.Cartesian2(1, -2);
    const result = new import__11.Cartesian2();
    const expectedResult = new import__11.Cartesian2(1, 2);
    const returnedResult = import__11.Cartesian2.abs(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("abs with a result parameter that is an input parameter", function() {
    const cartesian = new import__11.Cartesian2(1, -2);
    const expectedResult = new import__11.Cartesian2(1, 2);
    const returnedResult = import__11.Cartesian2.abs(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("lerp works with a result parameter", function() {
    const start = new import__11.Cartesian2(4, 8);
    const end = new import__11.Cartesian2(8, 20);
    const t = 0.25;
    const result = new import__11.Cartesian2();
    const expectedResult = new import__11.Cartesian2(5, 11);
    const returnedResult = import__11.Cartesian2.lerp(start, end, t, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("lerp works with a result parameter that is an input parameter", function() {
    const start = new import__11.Cartesian2(4, 8);
    const end = new import__11.Cartesian2(8, 20);
    const t = 0.25;
    const expectedResult = new import__11.Cartesian2(5, 11);
    const returnedResult = import__11.Cartesian2.lerp(start, end, t, start);
    expect(start).toBe(returnedResult);
    expect(start).toEqual(expectedResult);
  });
  it("lerp extrapolate forward", function() {
    const start = new import__11.Cartesian2(4, 8);
    const end = new import__11.Cartesian2(8, 20);
    const t = 2;
    const expectedResult = new import__11.Cartesian2(12, 32);
    const result = import__11.Cartesian2.lerp(start, end, t, new import__11.Cartesian2());
    expect(result).toEqual(expectedResult);
  });
  it("lerp extrapolate backward", function() {
    const start = new import__11.Cartesian2(4, 8);
    const end = new import__11.Cartesian2(8, 20);
    const t = -1;
    const expectedResult = new import__11.Cartesian2(0, -4);
    const result = import__11.Cartesian2.lerp(start, end, t, new import__11.Cartesian2());
    expect(result).toEqual(expectedResult);
  });
  it("angleBetween works for right angles", function() {
    const x = import__11.Cartesian2.UNIT_X;
    const y = import__11.Cartesian2.UNIT_Y;
    expect(import__11.Cartesian2.angleBetween(x, y)).toEqual(import__11.Math.PI_OVER_TWO);
    expect(import__11.Cartesian2.angleBetween(y, x)).toEqual(import__11.Math.PI_OVER_TWO);
  });
  it("angleBetween works for acute angles", function() {
    const x = new import__11.Cartesian2(0, 1);
    const y = new import__11.Cartesian2(1, 1);
    expect(import__11.Cartesian2.angleBetween(x, y)).toEqualEpsilon(
      import__11.Math.PI_OVER_FOUR,
      import__11.Math.EPSILON14
    );
    expect(import__11.Cartesian2.angleBetween(y, x)).toEqualEpsilon(
      import__11.Math.PI_OVER_FOUR,
      import__11.Math.EPSILON14
    );
  });
  it("angleBetween works for obtuse angles", function() {
    const x = new import__11.Cartesian2(0, 1);
    const y = new import__11.Cartesian2(-1, -1);
    expect(import__11.Cartesian2.angleBetween(x, y)).toEqualEpsilon(
      import__11.Math.PI * 3 / 4,
      import__11.Math.EPSILON14
    );
    expect(import__11.Cartesian2.angleBetween(y, x)).toEqualEpsilon(
      import__11.Math.PI * 3 / 4,
      import__11.Math.EPSILON14
    );
  });
  it("angleBetween works for zero angles", function() {
    const x = import__11.Cartesian2.UNIT_X;
    expect(import__11.Cartesian2.angleBetween(x, x)).toEqual(0);
  });
  it("most orthogonal angle is x", function() {
    const v = new import__11.Cartesian2(0, 1);
    expect(import__11.Cartesian2.mostOrthogonalAxis(v, new import__11.Cartesian2())).toEqual(
      import__11.Cartesian2.UNIT_X
    );
  });
  it("most orthogonal angle is y", function() {
    const v = new import__11.Cartesian2(1, 0);
    expect(import__11.Cartesian2.mostOrthogonalAxis(v, new import__11.Cartesian2())).toEqual(
      import__11.Cartesian2.UNIT_Y
    );
  });
  it("equals", function() {
    const cartesian = new import__11.Cartesian2(1, 2);
    expect(import__11.Cartesian2.equals(cartesian, new import__11.Cartesian2(1, 2))).toEqual(
      true
    );
    expect(import__11.Cartesian2.equals(cartesian, new import__11.Cartesian2(2, 2))).toEqual(
      false
    );
    expect(import__11.Cartesian2.equals(cartesian, new import__11.Cartesian2(2, 1))).toEqual(
      false
    );
    expect(import__11.Cartesian2.equals(cartesian, void 0)).toEqual(false);
  });
  it("equalsEpsilon", function() {
    let cartesian = new import__11.Cartesian2(1, 2);
    expect(cartesian.equalsEpsilon(new import__11.Cartesian2(1, 2), 0)).toEqual(
      true
    );
    expect(cartesian.equalsEpsilon(new import__11.Cartesian2(1, 2), 1)).toEqual(
      true
    );
    expect(cartesian.equalsEpsilon(new import__11.Cartesian2(2, 2), 1)).toEqual(
      true
    );
    expect(cartesian.equalsEpsilon(new import__11.Cartesian2(1, 3), 1)).toEqual(
      true
    );
    expect(
      cartesian.equalsEpsilon(new import__11.Cartesian2(1, 3), import__11.Math.EPSILON6)
    ).toEqual(false);
    expect(cartesian.equalsEpsilon(void 0, 1)).toEqual(false);
    cartesian = new import__11.Cartesian2(3e6, 4e6);
    expect(
      cartesian.equalsEpsilon(new import__11.Cartesian2(3e6, 4e6), 0)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__11.Cartesian2(3e6, 40000002e-1),
        import__11.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__11.Cartesian2(30000002e-1, 4e6),
        import__11.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__11.Cartesian2(30000002e-1, 40000002e-1),
        import__11.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__11.Cartesian2(30000002e-1, 40000002e-1),
        import__11.Math.EPSILON9
      )
    ).toEqual(false);
    expect(cartesian.equalsEpsilon(void 0, 1)).toEqual(false);
    expect(import__11.Cartesian2.equalsEpsilon(void 0, cartesian, 1)).toEqual(false);
  });
  it("toString", function() {
    const cartesian = new import__11.Cartesian2(1.123, 2.345);
    expect(cartesian.toString()).toEqual("(1.123, 2.345)");
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__11.Cartesian2.clone()).toBeUndefined();
  });
  it("maximumComponent throws with no parameter", function() {
    expect(function() {
      import__11.Cartesian2.maximumComponent();
    }).toThrowDeveloperError();
  });
  it("minimumComponent throws with no parameter", function() {
    expect(function() {
      import__11.Cartesian2.minimumComponent();
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared throws with no parameter", function() {
    expect(function() {
      import__11.Cartesian2.magnitudeSquared();
    }).toThrowDeveloperError();
  });
  it("magnitude throws with no parameter", function() {
    expect(function() {
      import__11.Cartesian2.magnitude();
    }).toThrowDeveloperError();
  });
  it("normalize throws with no parameter", function() {
    expect(function() {
      import__11.Cartesian2.normalize();
    }).toThrowDeveloperError();
  });
  it("dot throws with no left parameter", function() {
    expect(function() {
      import__11.Cartesian2.dot(void 0, new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("dot throws with no right parameter", function() {
    expect(function() {
      import__11.Cartesian2.dot(new import__11.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no left parameter", function() {
    const right = new import__11.Cartesian2(4, 5);
    expect(function() {
      import__11.Cartesian2.multiplyComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no right parameter", function() {
    const left = new import__11.Cartesian2(4, 5);
    expect(function() {
      import__11.Cartesian2.multiplyComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no left parameter", function() {
    const right = new import__11.Cartesian2(4, 5);
    expect(function() {
      import__11.Cartesian2.divideComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no right parameter", function() {
    const left = new import__11.Cartesian2(4, 5);
    expect(function() {
      import__11.Cartesian2.divideComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("add throws with no left parameter", function() {
    expect(function() {
      import__11.Cartesian2.add(void 0, new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("add throws with no right parameter", function() {
    expect(function() {
      import__11.Cartesian2.add(new import__11.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("subtract throws with no left parameter", function() {
    expect(function() {
      import__11.Cartesian2.subtract(void 0, new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no right parameter", function() {
    expect(function() {
      import__11.Cartesian2.subtract(new import__11.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__11.Cartesian2.multiplyByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__11.Cartesian2.multiplyByScalar(new import__11.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__11.Cartesian2.divideByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__11.Cartesian2.divideByScalar(new import__11.Cartesian2(), void 0);
    }).toThrowDeveloperError();
  });
  it("negate throws with no cartesian parameter", function() {
    expect(function() {
      import__11.Cartesian2.negate(void 0);
    }).toThrowDeveloperError();
  });
  it("abs throws with no cartesian parameter", function() {
    expect(function() {
      import__11.Cartesian2.abs(void 0);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no start parameter", function() {
    const end = new import__11.Cartesian2(8, 20);
    const t = 0.25;
    expect(function() {
      import__11.Cartesian2.lerp(void 0, end, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no end parameter", function() {
    const start = new import__11.Cartesian2(4, 8);
    const t = 0.25;
    expect(function() {
      import__11.Cartesian2.lerp(start, void 0, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no t parameter", function() {
    const start = new import__11.Cartesian2(4, 8);
    const end = new import__11.Cartesian2(8, 20);
    expect(function() {
      import__11.Cartesian2.lerp(start, end, void 0);
    }).toThrowDeveloperError();
  });
  it("angleBetween throws with no left parameter", function() {
    const right = new import__11.Cartesian2(8, 20);
    expect(function() {
      import__11.Cartesian2.angleBetween(void 0, right);
    }).toThrowDeveloperError();
  });
  it("angleBetween throws with no right parameter", function() {
    const left = new import__11.Cartesian2(4, 8);
    expect(function() {
      import__11.Cartesian2.angleBetween(left, void 0);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no cartesian parameter", function() {
    expect(function() {
      import__11.Cartesian2.mostOrthogonalAxis(void 0);
    }).toThrowDeveloperError();
  });
  it("fromElements returns a cartesian2 with corrrect coordinates", function() {
    const cartesian2 = import__11.Cartesian2.fromElements(2, 2);
    const expectedResult = new import__11.Cartesian2(2, 2);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("fromElements result param returns cartesian2 with correct coordinates", function() {
    const cartesian2 = new import__11.Cartesian2();
    import__11.Cartesian2.fromElements(2, 2, cartesian2);
    const expectedResult = new import__11.Cartesian2(2, 2);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("minimumByComponent throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.minimumByComponent(new import__11.Cartesian2(), new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.maximumByComponent(new import__11.Cartesian2(), new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("clamp throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.clamp(new import__11.Cartesian2(), new import__11.Cartesian2(), new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("normalize throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.normalize(new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.multiplyComponents(new import__11.Cartesian2(), new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("divideComponents throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.divideComponents(new import__11.Cartesian2(), new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("add throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.add(new import__11.Cartesian2(), new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("subtact throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.subtract(new import__11.Cartesian2(), new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.multiplyByScalar(new import__11.Cartesian2(), 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.divideByScalar(new import__11.Cartesian2(), 2);
    }).toThrowDeveloperError();
  });
  it("negate throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.negate(new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("abs throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.abs(new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  it("lerp throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.lerp(new import__11.Cartesian2(), new import__11.Cartesian2(), 10);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no result", function() {
    expect(function() {
      import__11.Cartesian2.mostOrthogonalAxis(new import__11.Cartesian2());
    }).toThrowDeveloperError();
  });
  createPackableSpecs_default(import__11.Cartesian2, new import__11.Cartesian2(1, 2), [1, 2]);
  createPackableArraySpecs_default(
    import__11.Cartesian2,
    [new import__11.Cartesian2(1, 2), new import__11.Cartesian2(3, 4)],
    [1, 2, 3, 4],
    2
  );
});

// packages/engine/Specs/Core/Cartesian3Spec.js
var import__12 = __toESM(require_Cesium(), 1);
describe("Core/Cartesian3", function() {
  afterEach(function() {
    import__12.Ellipsoid.default = import__12.Ellipsoid.WGS84;
  });
  it("construct with default values", function() {
    const cartesian2 = new import__12.Cartesian3();
    expect(cartesian2.x).toEqual(0);
    expect(cartesian2.y).toEqual(0);
    expect(cartesian2.z).toEqual(0);
  });
  it("construct with all values", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    expect(cartesian2.x).toEqual(1);
    expect(cartesian2.y).toEqual(2);
    expect(cartesian2.z).toEqual(3);
  });
  const fortyFiveDegrees = Math.PI / 4;
  const sixtyDegrees = Math.PI / 3;
  const cartesian = new import__12.Cartesian3(1, Math.sqrt(3), -2);
  const spherical = {
    clock: sixtyDegrees,
    cone: fortyFiveDegrees + Math.PI / 2,
    magnitude: Math.sqrt(8)
  };
  it("convert Spherical to an existing Cartesian3 instance", function() {
    const existing = new import__12.Cartesian3();
    expect(cartesian).toEqualEpsilon(
      import__12.Cartesian3.fromSpherical(spherical, existing),
      import__12.Math.EPSILON15
    );
    expect(cartesian).toEqualEpsilon(existing, import__12.Math.EPSILON15);
  });
  it("fromArray with an offset creates a Cartesian3", function() {
    const cartesian2 = import__12.Cartesian3.fromArray([0, 1, 2, 3, 0], 1);
    expect(cartesian2).toEqual(new import__12.Cartesian3(1, 2, 3));
  });
  it("fromArray creates a Cartesian3 with a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3();
    const result = import__12.Cartesian3.fromArray([1, 2, 3], 0, cartesian2);
    expect(result).toBe(cartesian2);
    expect(result).toEqual(new import__12.Cartesian3(1, 2, 3));
  });
  it("fromArray throws without values", function() {
    expect(function() {
      import__12.Cartesian3.fromArray();
    }).toThrowDeveloperError();
  });
  it("clone with a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    const result = new import__12.Cartesian3();
    const returnedResult = import__12.Cartesian3.clone(cartesian2, result);
    expect(cartesian2).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(cartesian2).toEqual(result);
  });
  it("clone works with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    const returnedResult = import__12.Cartesian3.clone(cartesian2, cartesian2);
    expect(cartesian2).toBe(returnedResult);
  });
  it("maximumComponent works when X is greater", function() {
    const cartesian2 = new import__12.Cartesian3(2, 1, 0);
    expect(import__12.Cartesian3.maximumComponent(cartesian2)).toEqual(cartesian2.x);
  });
  it("maximumComponent works when Y is greater", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 0);
    expect(import__12.Cartesian3.maximumComponent(cartesian2)).toEqual(cartesian2.y);
  });
  it("maximumComponent works when Z is greater", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    expect(import__12.Cartesian3.maximumComponent(cartesian2)).toEqual(cartesian2.z);
  });
  it("minimumComponent works when X is lesser", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    expect(import__12.Cartesian3.minimumComponent(cartesian2)).toEqual(cartesian2.x);
  });
  it("minimumComponent works when Y is lesser", function() {
    const cartesian2 = new import__12.Cartesian3(2, 1, 3);
    expect(import__12.Cartesian3.minimumComponent(cartesian2)).toEqual(cartesian2.y);
  });
  it("minimumComponent works when Z is lesser", function() {
    const cartesian2 = new import__12.Cartesian3(2, 1, 0);
    expect(import__12.Cartesian3.minimumComponent(cartesian2)).toEqual(cartesian2.z);
  });
  it("minimumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__12.Cartesian3();
    first = new import__12.Cartesian3(2, 0, 0);
    second = new import__12.Cartesian3(1, 0, 0);
    expected = new import__12.Cartesian3(1, 0, 0);
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(1, 0, 0);
    second = new import__12.Cartesian3(2, 0, 0);
    expected = new import__12.Cartesian3(1, 0, 0);
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(2, -15, 0);
    second = new import__12.Cartesian3(1, -20, 0);
    expected = new import__12.Cartesian3(1, -20, 0);
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(2, -20, 0);
    second = new import__12.Cartesian3(1, -15, 0);
    expected = new import__12.Cartesian3(1, -20, 0);
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(2, -15, 26.4);
    second = new import__12.Cartesian3(1, -20, 26.5);
    expected = new import__12.Cartesian3(1, -20, 26.4);
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(2, -15, 26.5);
    second = new import__12.Cartesian3(1, -20, 26.4);
    expected = new import__12.Cartesian3(1, -20, 26.4);
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent with a result parameter", function() {
    const first = new import__12.Cartesian3(2, 0, 0);
    const second = new import__12.Cartesian3(1, 0, 0);
    const expected = new import__12.Cartesian3(1, 0, 0);
    const result = new import__12.Cartesian3();
    const returnedResult = import__12.Cartesian3.minimumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("minimumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__12.Cartesian3(2, 0, 0);
    const second = new import__12.Cartesian3(1, 0, 0);
    const expected = new import__12.Cartesian3(1, 0, 0);
    expect(import__12.Cartesian3.minimumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__12.Cartesian3.minimumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("minimumByComponent throws without first", function() {
    expect(function() {
      import__12.Cartesian3.minimumByComponent();
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws without second", function() {
    expect(function() {
      import__12.Cartesian3.minimumByComponent(new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("minimumByComponent works when first's or second's X is lesser", function() {
    const first = new import__12.Cartesian3(2, 0, 0);
    const second = new import__12.Cartesian3(1, 0, 0);
    const expected = new import__12.Cartesian3(1, 0, 0);
    const result = new import__12.Cartesian3();
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 2;
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Y is lesser", function() {
    const first = new import__12.Cartesian3(0, 2, 0);
    const second = new import__12.Cartesian3(0, 1, 0);
    const expected = new import__12.Cartesian3(0, 1, 0);
    const result = new import__12.Cartesian3();
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 2;
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Z is lesser", function() {
    const first = new import__12.Cartesian3(0, 0, 2);
    const second = new import__12.Cartesian3(0, 0, 1);
    const expected = new import__12.Cartesian3(0, 0, 1);
    const result = new import__12.Cartesian3();
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.z = 3;
    expected.z = 2;
    expect(import__12.Cartesian3.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__12.Cartesian3();
    first = new import__12.Cartesian3(2, 0, 0);
    second = new import__12.Cartesian3(1, 0, 0);
    expected = new import__12.Cartesian3(2, 0, 0);
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(1, 0, 0);
    second = new import__12.Cartesian3(2, 0, 0);
    expected = new import__12.Cartesian3(2, 0, 0);
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(2, -15, 0);
    second = new import__12.Cartesian3(1, -20, 0);
    expected = new import__12.Cartesian3(2, -15, 0);
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(2, -20, 0);
    second = new import__12.Cartesian3(1, -15, 0);
    expected = new import__12.Cartesian3(2, -15, 0);
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(2, -15, 26.4);
    second = new import__12.Cartesian3(1, -20, 26.5);
    expected = new import__12.Cartesian3(2, -15, 26.5);
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__12.Cartesian3(2, -15, 26.5);
    second = new import__12.Cartesian3(1, -20, 26.4);
    expected = new import__12.Cartesian3(2, -15, 26.5);
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent with a result parameter", function() {
    const first = new import__12.Cartesian3(2, 0, 0);
    const second = new import__12.Cartesian3(1, 0, 0);
    const expected = new import__12.Cartesian3(2, 0, 0);
    const result = new import__12.Cartesian3();
    const returnedResult = import__12.Cartesian3.maximumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("maximumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__12.Cartesian3(2, 0, 0);
    const second = new import__12.Cartesian3(1, 0, 0);
    const expected = new import__12.Cartesian3(2, 0, 0);
    expect(import__12.Cartesian3.maximumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__12.Cartesian3.maximumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("maximumByComponent throws without first", function() {
    expect(function() {
      import__12.Cartesian3.maximumByComponent();
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws without second", function() {
    expect(function() {
      import__12.Cartesian3.maximumByComponent(new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent works when first's or second's X is greater", function() {
    const first = new import__12.Cartesian3(2, 0, 0);
    const second = new import__12.Cartesian3(1, 0, 0);
    const expected = new import__12.Cartesian3(2, 0, 0);
    const result = new import__12.Cartesian3();
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 3;
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Y is greater", function() {
    const first = new import__12.Cartesian3(0, 2, 0);
    const second = new import__12.Cartesian3(0, 1, 0);
    const expected = new import__12.Cartesian3(0, 2, 0);
    const result = new import__12.Cartesian3();
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 3;
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Z is greater", function() {
    const first = new import__12.Cartesian3(0, 0, 2);
    const second = new import__12.Cartesian3(0, 0, 1);
    const expected = new import__12.Cartesian3(0, 0, 2);
    const result = new import__12.Cartesian3();
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.z = 3;
    expected.z = 3;
    expect(import__12.Cartesian3.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("clamp", function() {
    let value;
    let min;
    let max;
    let expected;
    const result = new import__12.Cartesian3();
    value = new import__12.Cartesian3(-1, 0, 0);
    min = new import__12.Cartesian3(0, 0, 0);
    max = new import__12.Cartesian3(1, 1, 1);
    expected = new import__12.Cartesian3(0, 0, 0);
    expect(import__12.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__12.Cartesian3(2, 0, 0);
    min = new import__12.Cartesian3(0, 0, 0);
    max = new import__12.Cartesian3(1, 1, 1);
    expected = new import__12.Cartesian3(1, 0, 0);
    expect(import__12.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__12.Cartesian3(0, -1, 0);
    min = new import__12.Cartesian3(0, 0, 0);
    max = new import__12.Cartesian3(1, 1, 1);
    expected = new import__12.Cartesian3(0, 0, 0);
    expect(import__12.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__12.Cartesian3(0, 2, 0);
    min = new import__12.Cartesian3(0, 0, 0);
    max = new import__12.Cartesian3(1, 1, 1);
    expected = new import__12.Cartesian3(0, 1, 0);
    expect(import__12.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__12.Cartesian3(0, 0, -1);
    min = new import__12.Cartesian3(0, 0, 0);
    max = new import__12.Cartesian3(1, 1, 1);
    expected = new import__12.Cartesian3(0, 0, 0);
    expect(import__12.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__12.Cartesian3(0, 0, 2);
    min = new import__12.Cartesian3(0, 0, 0);
    max = new import__12.Cartesian3(1, 1, 1);
    expected = new import__12.Cartesian3(0, 0, 1);
    expect(import__12.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__12.Cartesian3(-2, 3, 4);
    min = new import__12.Cartesian3(0, 0, 0);
    max = new import__12.Cartesian3(1, 1, 1);
    expected = new import__12.Cartesian3(0, 1, 1);
    expect(import__12.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
    value = new import__12.Cartesian3(0, 0, 0);
    min = new import__12.Cartesian3(1, 2, 3);
    max = new import__12.Cartesian3(1, 2, 3);
    expected = new import__12.Cartesian3(1, 2, 3);
    expect(import__12.Cartesian3.clamp(value, min, max, result)).toEqual(expected);
  });
  it("clamp with a result parameter", function() {
    const value = new import__12.Cartesian3(-1, -1, -1);
    const min = new import__12.Cartesian3(0, 0, 0);
    const max = new import__12.Cartesian3(1, 1, 1);
    const expected = new import__12.Cartesian3(0, 0, 0);
    const result = new import__12.Cartesian3();
    const returnedResult = import__12.Cartesian3.clamp(value, min, max, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("clamp with a result parameter that is an input parameter", function() {
    const value = new import__12.Cartesian3(-1, -1, -1);
    const min = new import__12.Cartesian3(0, 0, 0);
    const max = new import__12.Cartesian3(1, 1, 1);
    const expected = new import__12.Cartesian3(0, 0, 0);
    expect(import__12.Cartesian3.clamp(value, min, max, value)).toEqual(expected);
    import__12.Cartesian3.fromElements(-1, -1, -1, value);
    expect(import__12.Cartesian3.clamp(value, min, max, min)).toEqual(expected);
    import__12.Cartesian3.fromElements(0, 0, 0, min);
    expect(import__12.Cartesian3.clamp(value, min, max, max)).toEqual(expected);
  });
  it("clamp throws without value", function() {
    expect(function() {
      import__12.Cartesian3.clamp();
    }).toThrowDeveloperError();
  });
  it("clamp throws without min", function() {
    expect(function() {
      import__12.Cartesian3.clamp(new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("clamp throws without max", function() {
    expect(function() {
      import__12.Cartesian3.clamp(new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared", function() {
    const cartesian2 = new import__12.Cartesian3(3, 4, 5);
    expect(import__12.Cartesian3.magnitudeSquared(cartesian2)).toEqual(50);
  });
  it("magnitude", function() {
    const cartesian2 = new import__12.Cartesian3(3, 4, 5);
    expect(import__12.Cartesian3.magnitude(cartesian2)).toEqual(Math.sqrt(50));
  });
  it("distance", function() {
    const distance = import__12.Cartesian3.distance(
      new import__12.Cartesian3(1, 0, 0),
      new import__12.Cartesian3(2, 0, 0)
    );
    expect(distance).toEqual(1);
  });
  it("distance throws without left", function() {
    expect(function() {
      import__12.Cartesian3.distance();
    }).toThrowDeveloperError();
  });
  it("distance throws without right", function() {
    expect(function() {
      import__12.Cartesian3.distance(import__12.Cartesian3.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("distanceSquared", function() {
    const distanceSquared = import__12.Cartesian3.distanceSquared(
      new import__12.Cartesian3(1, 0, 0),
      new import__12.Cartesian3(3, 0, 0)
    );
    expect(distanceSquared).toEqual(4);
  });
  it("distanceSquared throws without left", function() {
    expect(function() {
      import__12.Cartesian3.distanceSquared();
    }).toThrowDeveloperError();
  });
  it("distanceSquared throws without right", function() {
    expect(function() {
      import__12.Cartesian3.distanceSquared(import__12.Cartesian3.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("normalize works with a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3(2, 0, 0);
    const expectedResult = new import__12.Cartesian3(1, 0, 0);
    const result = new import__12.Cartesian3();
    const returnedResult = import__12.Cartesian3.normalize(cartesian2, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("normalize works with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__12.Cartesian3(2, 0, 0);
    const expectedResult = new import__12.Cartesian3(1, 0, 0);
    const returnedResult = import__12.Cartesian3.normalize(cartesian2, cartesian2);
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("normalize throws with zero vector", function() {
    expect(function() {
      import__12.Cartesian3.normalize(import__12.Cartesian3.ZERO, new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents works with a result parameter", function() {
    const left = new import__12.Cartesian3(2, 3, 6);
    const right = new import__12.Cartesian3(4, 5, 7);
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(8, 15, 42);
    const returnedResult = import__12.Cartesian3.multiplyComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyComponents works with a result parameter that is an input parameter", function() {
    const left = new import__12.Cartesian3(2, 3, 6);
    const right = new import__12.Cartesian3(4, 5, 7);
    const expectedResult = new import__12.Cartesian3(8, 15, 42);
    const returnedResult = import__12.Cartesian3.multiplyComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter", function() {
    const left = new import__12.Cartesian3(2, 3, 6);
    const right = new import__12.Cartesian3(4, 5, 8);
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(0.5, 0.6, 0.75);
    const returnedResult = import__12.Cartesian3.divideComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter that is an input parameter", function() {
    const left = new import__12.Cartesian3(2, 3, 6);
    const right = new import__12.Cartesian3(4, 5, 8);
    const expectedResult = new import__12.Cartesian3(0.5, 0.6, 0.75);
    const returnedResult = import__12.Cartesian3.divideComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("dot", function() {
    const left = new import__12.Cartesian3(2, 3, 6);
    const right = new import__12.Cartesian3(4, 5, 7);
    const expectedResult = 65;
    const result = import__12.Cartesian3.dot(left, right);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter", function() {
    const left = new import__12.Cartesian3(2, 3, 6);
    const right = new import__12.Cartesian3(4, 5, 7);
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(6, 8, 13);
    const returnedResult = import__12.Cartesian3.add(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter that is an input parameter", function() {
    const left = new import__12.Cartesian3(2, 3, 6);
    const right = new import__12.Cartesian3(4, 5, 7);
    const expectedResult = new import__12.Cartesian3(6, 8, 13);
    const returnedResult = import__12.Cartesian3.add(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("subtract works with a result parameter", function() {
    const left = new import__12.Cartesian3(2, 3, 4);
    const right = new import__12.Cartesian3(1, 5, 7);
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(1, -2, -3);
    const returnedResult = import__12.Cartesian3.subtract(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("subtract works with this result parameter", function() {
    const left = new import__12.Cartesian3(2, 3, 4);
    const right = new import__12.Cartesian3(1, 5, 7);
    const expectedResult = new import__12.Cartesian3(1, -2, -3);
    const returnedResult = import__12.Cartesian3.subtract(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    const result = new import__12.Cartesian3();
    const scalar = 2;
    const expectedResult = new import__12.Cartesian3(2, 4, 6);
    const returnedResult = import__12.Cartesian3.multiplyByScalar(
      cartesian2,
      scalar,
      result
    );
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    const scalar = 2;
    const expectedResult = new import__12.Cartesian3(2, 4, 6);
    const returnedResult = import__12.Cartesian3.multiplyByScalar(
      cartesian2,
      scalar,
      cartesian2
    );
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    const result = new import__12.Cartesian3();
    const scalar = 2;
    const expectedResult = new import__12.Cartesian3(0.5, 1, 1.5);
    const returnedResult = import__12.Cartesian3.divideByScalar(cartesian2, scalar, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    const scalar = 2;
    const expectedResult = new import__12.Cartesian3(0.5, 1, 1.5);
    const returnedResult = import__12.Cartesian3.divideByScalar(
      cartesian2,
      scalar,
      cartesian2
    );
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("negate without a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, -2, -5);
    const expectedResult = new import__12.Cartesian3(-1, 2, 5);
    const result = import__12.Cartesian3.negate(cartesian2, new import__12.Cartesian3());
    expect(result).toEqual(expectedResult);
  });
  it("negate with a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, -2, -5);
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(-1, 2, 5);
    const returnedResult = import__12.Cartesian3.negate(cartesian2, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("negate with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, -2, -5);
    const expectedResult = new import__12.Cartesian3(-1, 2, 5);
    const returnedResult = import__12.Cartesian3.negate(cartesian2, cartesian2);
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("abs without a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, -2, -4);
    const expectedResult = new import__12.Cartesian3(1, 2, 4);
    const result = import__12.Cartesian3.abs(cartesian2, new import__12.Cartesian3());
    expect(result).toEqual(expectedResult);
  });
  it("abs with a result parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, -2, -4);
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(1, 2, 4);
    const returnedResult = import__12.Cartesian3.abs(cartesian2, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("abs with a result parameter that is an input parameter", function() {
    const cartesian2 = new import__12.Cartesian3(1, -2, -4);
    const expectedResult = new import__12.Cartesian3(1, 2, 4);
    const returnedResult = import__12.Cartesian3.abs(cartesian2, cartesian2);
    expect(cartesian2).toBe(returnedResult);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("lerp works with a result parameter", function() {
    const start = new import__12.Cartesian3(4, 8, 10);
    const end = new import__12.Cartesian3(8, 20, 20);
    const t = 0.25;
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(5, 11, 12.5);
    const returnedResult = import__12.Cartesian3.lerp(start, end, t, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("lerp works with a result parameter that is an input parameter", function() {
    const start = new import__12.Cartesian3(4, 8, 10);
    const end = new import__12.Cartesian3(8, 20, 20);
    const t = 0.25;
    const expectedResult = new import__12.Cartesian3(5, 11, 12.5);
    const returnedResult = import__12.Cartesian3.lerp(start, end, t, start);
    expect(start).toBe(returnedResult);
    expect(start).toEqual(expectedResult);
  });
  it("lerp extrapolate forward", function() {
    const start = new import__12.Cartesian3(4, 8, 10);
    const end = new import__12.Cartesian3(8, 20, 20);
    const t = 2;
    const expectedResult = new import__12.Cartesian3(12, 32, 30);
    const result = import__12.Cartesian3.lerp(start, end, t, new import__12.Cartesian3());
    expect(result).toEqual(expectedResult);
  });
  it("lerp extrapolate backward", function() {
    const start = new import__12.Cartesian3(4, 8, 10);
    const end = new import__12.Cartesian3(8, 20, 20);
    const t = -1;
    const expectedResult = new import__12.Cartesian3(0, -4, 0);
    const result = import__12.Cartesian3.lerp(start, end, t, new import__12.Cartesian3());
    expect(result).toEqual(expectedResult);
  });
  it("angleBetween works for right angles", function() {
    const x = import__12.Cartesian3.UNIT_X;
    const y = import__12.Cartesian3.UNIT_Y;
    expect(import__12.Cartesian3.angleBetween(x, y)).toEqual(import__12.Math.PI_OVER_TWO);
    expect(import__12.Cartesian3.angleBetween(y, x)).toEqual(import__12.Math.PI_OVER_TWO);
  });
  it("angleBetween works for acute angles", function() {
    const x = new import__12.Cartesian3(0, 1, 0);
    const y = new import__12.Cartesian3(1, 1, 0);
    expect(import__12.Cartesian3.angleBetween(x, y)).toEqualEpsilon(
      import__12.Math.PI_OVER_FOUR,
      import__12.Math.EPSILON14
    );
    expect(import__12.Cartesian3.angleBetween(y, x)).toEqualEpsilon(
      import__12.Math.PI_OVER_FOUR,
      import__12.Math.EPSILON14
    );
  });
  it("angleBetween works for obtuse angles", function() {
    const x = new import__12.Cartesian3(0, 1, 0);
    const y = new import__12.Cartesian3(0, -1, -1);
    expect(import__12.Cartesian3.angleBetween(x, y)).toEqualEpsilon(
      import__12.Math.PI * 3 / 4,
      import__12.Math.EPSILON14
    );
    expect(import__12.Cartesian3.angleBetween(y, x)).toEqualEpsilon(
      import__12.Math.PI * 3 / 4,
      import__12.Math.EPSILON14
    );
  });
  it("angleBetween works for zero angles", function() {
    const x = import__12.Cartesian3.UNIT_X;
    expect(import__12.Cartesian3.angleBetween(x, x)).toEqual(0);
  });
  it("most orthogonal angle is x", function() {
    const v = new import__12.Cartesian3(0, 1, 2);
    expect(import__12.Cartesian3.mostOrthogonalAxis(v, new import__12.Cartesian3())).toEqual(
      import__12.Cartesian3.UNIT_X
    );
  });
  it("most orthogonal angle is y", function() {
    const v = new import__12.Cartesian3(1, 0, 2);
    expect(import__12.Cartesian3.mostOrthogonalAxis(v, new import__12.Cartesian3())).toEqual(
      import__12.Cartesian3.UNIT_Y
    );
  });
  it("most orthogonal angle is z", function() {
    let v = new import__12.Cartesian3(1, 3, 0);
    expect(import__12.Cartesian3.mostOrthogonalAxis(v, new import__12.Cartesian3())).toEqual(
      import__12.Cartesian3.UNIT_Z
    );
    v = new import__12.Cartesian3(3, 1, 0);
    expect(import__12.Cartesian3.mostOrthogonalAxis(v, new import__12.Cartesian3())).toEqual(
      import__12.Cartesian3.UNIT_Z
    );
  });
  it("equals", function() {
    const cartesian2 = new import__12.Cartesian3(1, 2, 3);
    expect(import__12.Cartesian3.equals(cartesian2, new import__12.Cartesian3(1, 2, 3))).toEqual(
      true
    );
    expect(import__12.Cartesian3.equals(cartesian2, new import__12.Cartesian3(2, 2, 3))).toEqual(
      false
    );
    expect(import__12.Cartesian3.equals(cartesian2, new import__12.Cartesian3(2, 1, 3))).toEqual(
      false
    );
    expect(import__12.Cartesian3.equals(cartesian2, new import__12.Cartesian3(1, 2, 4))).toEqual(
      false
    );
    expect(import__12.Cartesian3.equals(cartesian2, void 0)).toEqual(false);
  });
  it("equalsEpsilon", function() {
    let cartesian2 = new import__12.Cartesian3(1, 2, 3);
    expect(cartesian2.equalsEpsilon(new import__12.Cartesian3(1, 2, 3), 0)).toEqual(
      true
    );
    expect(cartesian2.equalsEpsilon(new import__12.Cartesian3(1, 2, 3), 1)).toEqual(
      true
    );
    expect(cartesian2.equalsEpsilon(new import__12.Cartesian3(2, 2, 3), 1)).toEqual(
      true
    );
    expect(cartesian2.equalsEpsilon(new import__12.Cartesian3(1, 3, 3), 1)).toEqual(
      true
    );
    expect(cartesian2.equalsEpsilon(new import__12.Cartesian3(1, 2, 4), 1)).toEqual(
      true
    );
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(2, 2, 3),
        import__12.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(1, 3, 3),
        import__12.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(1, 2, 4),
        import__12.Math.EPSILON6
      )
    ).toEqual(false);
    expect(cartesian2.equalsEpsilon(void 0, 1)).toEqual(false);
    cartesian2 = new import__12.Cartesian3(3e6, 4e6, 5e6);
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(3e6, 4e6, 5e6),
        0
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(30000002e-1, 4e6, 5e6),
        import__12.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(3e6, 40000002e-1, 5e6),
        import__12.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(3e6, 4e6, 50000002e-1),
        import__12.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(30000002e-1, 40000002e-1, 50000002e-1),
        import__12.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian2.equalsEpsilon(
        new import__12.Cartesian3(30000002e-1, 40000002e-1, 50000002e-1),
        import__12.Math.EPSILON9
      )
    ).toEqual(false);
    expect(cartesian2.equalsEpsilon(void 0, 1)).toEqual(false);
    expect(import__12.Cartesian3.equalsEpsilon(void 0, cartesian2, 1)).toEqual(false);
  });
  it("toString", function() {
    const cartesian2 = new import__12.Cartesian3(1.123, 2.345, 6.789);
    expect(cartesian2.toString()).toEqual("(1.123, 2.345, 6.789)");
  });
  it("cross works with a result parameter", function() {
    const left = new import__12.Cartesian3(1, 2, 5);
    const right = new import__12.Cartesian3(4, 3, 6);
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(-3, 14, -5);
    const returnedResult = import__12.Cartesian3.cross(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("cross works with a result parameter that is an input parameter", function() {
    const left = new import__12.Cartesian3(1, 2, 5);
    const right = new import__12.Cartesian3(4, 3, 6);
    const expectedResult = new import__12.Cartesian3(-3, 14, -5);
    const returnedResult = import__12.Cartesian3.cross(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("midpoint works with a result parameter", function() {
    const left = new import__12.Cartesian3(0, 0, 6);
    const right = new import__12.Cartesian3(0, 0, -6);
    const result = new import__12.Cartesian3();
    const expectedResult = new import__12.Cartesian3(0, 0, 0);
    const returnedResult = import__12.Cartesian3.midpoint(left, right, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqual(expectedResult);
  });
  it("midpoint throws with no left", function() {
    expect(function() {
      return import__12.Cartesian3.midpoint(void 0, new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("midpoint throws with no right", function() {
    expect(function() {
      return import__12.Cartesian3.midpoint(new import__12.Cartesian3(), void 0, new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("midpoint throws with no result", function() {
    expect(function() {
      return import__12.Cartesian3.midpoint(new import__12.Cartesian3(), new import__12.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("fromSpherical throws with no spherical parameter", function() {
    expect(function() {
      import__12.Cartesian3.fromSpherical(void 0);
    }).toThrowDeveloperError();
  });
  it("fromSpherical work with no result parameter", function() {
    expect(function() {
      import__12.Cartesian3.fromSpherical({
        clock: sixtyDegrees,
        cone: fortyFiveDegrees + Math.PI / 2,
        magnitude: Math.sqrt(8)
      });
    }).not.toThrowDeveloperError();
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__12.Cartesian3.clone()).toBeUndefined();
  });
  it("maximumComponent throws with no parameter", function() {
    expect(function() {
      import__12.Cartesian3.maximumComponent();
    }).toThrowDeveloperError();
  });
  it("minimumComponent throws with no parameter", function() {
    expect(function() {
      import__12.Cartesian3.minimumComponent();
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared throws with no parameter", function() {
    expect(function() {
      import__12.Cartesian3.magnitudeSquared();
    }).toThrowDeveloperError();
  });
  it("magnitude throws with no parameter", function() {
    expect(function() {
      import__12.Cartesian3.magnitude();
    }).toThrowDeveloperError();
  });
  it("normalize throws with no parameter", function() {
    expect(function() {
      import__12.Cartesian3.normalize();
    }).toThrowDeveloperError();
  });
  it("dot throws with no left parameter", function() {
    expect(function() {
      import__12.Cartesian3.dot(void 0, new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no left parameter", function() {
    const right = new import__12.Cartesian3(4, 5, 6);
    expect(function() {
      import__12.Cartesian3.multiplyComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no right parameter", function() {
    const left = new import__12.Cartesian3(4, 5, 6);
    expect(function() {
      import__12.Cartesian3.multiplyComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no left parameter", function() {
    const right = new import__12.Cartesian3(4, 5, 6);
    expect(function() {
      import__12.Cartesian3.divideComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no right parameter", function() {
    const left = new import__12.Cartesian3(4, 5, 6);
    expect(function() {
      import__12.Cartesian3.divideComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("dot throws with no right parameter", function() {
    expect(function() {
      import__12.Cartesian3.dot(new import__12.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("add throws with no left parameter", function() {
    expect(function() {
      import__12.Cartesian3.add(void 0, new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("add throws with no right parameter", function() {
    expect(function() {
      import__12.Cartesian3.add(new import__12.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("subtract throws with no left parameter", function() {
    expect(function() {
      import__12.Cartesian3.subtract(void 0, new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no right parameter", function() {
    expect(function() {
      import__12.Cartesian3.subtract(new import__12.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__12.Cartesian3.multiplyByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__12.Cartesian3.multiplyByScalar(new import__12.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__12.Cartesian3.divideByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__12.Cartesian3.divideByScalar(new import__12.Cartesian3(), void 0);
    }).toThrowDeveloperError();
  });
  it("negate throws with no cartesian parameter", function() {
    expect(function() {
      import__12.Cartesian3.negate(void 0);
    }).toThrowDeveloperError();
  });
  it("abs throws with no cartesian parameter", function() {
    expect(function() {
      import__12.Cartesian3.abs(void 0);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no start parameter", function() {
    const end = new import__12.Cartesian3(8, 20, 6);
    const t = 0.25;
    expect(function() {
      import__12.Cartesian3.lerp(void 0, end, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no end parameter", function() {
    const start = new import__12.Cartesian3(4, 8, 6);
    const t = 0.25;
    expect(function() {
      import__12.Cartesian3.lerp(start, void 0, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no t parameter", function() {
    const start = new import__12.Cartesian3(4, 8, 6);
    const end = new import__12.Cartesian3(8, 20, 6);
    expect(function() {
      import__12.Cartesian3.lerp(start, end, void 0);
    }).toThrowDeveloperError();
  });
  it("angleBetween throws with no left parameter", function() {
    const right = new import__12.Cartesian3(8, 20, 6);
    expect(function() {
      import__12.Cartesian3.angleBetween(void 0, right);
    }).toThrowDeveloperError();
  });
  it("angleBetween throws with no right parameter", function() {
    const left = new import__12.Cartesian3(4, 8, 6);
    expect(function() {
      import__12.Cartesian3.angleBetween(left, void 0);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no cartesian parameter", function() {
    expect(function() {
      import__12.Cartesian3.mostOrthogonalAxis(void 0);
    }).toThrowDeveloperError();
  });
  it("cross throw with no left paramater", function() {
    const right = new import__12.Cartesian3(4, 3, 6);
    expect(function() {
      import__12.Cartesian3.cross(void 0, right);
    }).toThrowDeveloperError();
  });
  it("cross throw with no left paramater", function() {
    const left = new import__12.Cartesian3(1, 2, 5);
    expect(function() {
      import__12.Cartesian3.cross(left, void 0);
    }).toThrowDeveloperError();
  });
  it("fromElements returns a cartesian3 with corrrect coordinates", function() {
    const cartesian2 = import__12.Cartesian3.fromElements(2, 2, 4);
    const expectedResult = new import__12.Cartesian3(2, 2, 4);
    expect(cartesian2).toEqual(expectedResult);
  });
  it("fromElements result param returns cartesian3 with correct coordinates", function() {
    const cartesian3 = new import__12.Cartesian3();
    import__12.Cartesian3.fromElements(2, 2, 4, cartesian3);
    const expectedResult = new import__12.Cartesian3(2, 2, 4);
    expect(cartesian3).toEqual(expectedResult);
  });
  it("fromDegrees", function() {
    const lon = -115;
    const lat = 37;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const actual = import__12.Cartesian3.fromDegrees(lon, lat);
    const expected = ellipsoid.cartographicToCartesian(
      import__12.Cartographic.fromDegrees(lon, lat)
    );
    expect(actual).toEqual(expected);
  });
  it("fromDegrees with height", function() {
    const lon = -115;
    const lat = 37;
    const height = 1e5;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const actual = import__12.Cartesian3.fromDegrees(lon, lat, height);
    const expected = ellipsoid.cartographicToCartesian(
      import__12.Cartographic.fromDegrees(lon, lat, height)
    );
    expect(actual).toEqual(expected);
  });
  it("fromDegrees with result", function() {
    const lon = -115;
    const lat = 37;
    const height = 1e5;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const result = new import__12.Cartesian3();
    const actual = import__12.Cartesian3.fromDegrees(lon, lat, height, ellipsoid, result);
    const expected = ellipsoid.cartographicToCartesian(
      import__12.Cartographic.fromDegrees(lon, lat, height)
    );
    expect(actual).toEqual(expected);
    expect(actual).toBe(result);
  });
  it("fromDegrees throws with no longitude", function() {
    expect(function() {
      import__12.Cartesian3.fromDegrees();
    }).toThrowDeveloperError();
  });
  it("fromDegrees throws with no latitude", function() {
    expect(function() {
      import__12.Cartesian3.fromDegrees(1);
    }).toThrowDeveloperError();
  });
  it("fromDegrees works works with default ellipsoid", function() {
    import__12.Ellipsoid.default = import__12.Ellipsoid.MOON;
    const expectedPosition = new import__12.Cartesian3(
      1593514338295244e-9,
      691991.9979835141,
      20442.318221152018
    );
    const position = import__12.Cartesian3.fromDegrees(23.47315, 0.67416);
    expect(position).toEqualEpsilon(expectedPosition, import__12.Math.EPSILON8);
  });
  it("fromRadians", function() {
    const lon = import__12.Math.toRadians(150);
    const lat = import__12.Math.toRadians(-40);
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const actual = import__12.Cartesian3.fromRadians(lon, lat);
    const expected = ellipsoid.cartographicToCartesian(
      new import__12.Cartographic(lon, lat)
    );
    expect(actual).toEqual(expected);
  });
  it("fromRadians with height", function() {
    const lon = import__12.Math.toRadians(150);
    const lat = import__12.Math.toRadians(-40);
    const height = 1e5;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const actual = import__12.Cartesian3.fromRadians(lon, lat, height);
    const expected = ellipsoid.cartographicToCartesian(
      new import__12.Cartographic(lon, lat, height)
    );
    expect(actual).toEqual(expected);
  });
  it("fromRadians with result", function() {
    const lon = import__12.Math.toRadians(150);
    const lat = import__12.Math.toRadians(-40);
    const height = 1e5;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const result = new import__12.Cartesian3();
    const actual = import__12.Cartesian3.fromRadians(lon, lat, height, ellipsoid, result);
    const expected = ellipsoid.cartographicToCartesian(
      new import__12.Cartographic(lon, lat, height)
    );
    expect(actual).toEqual(expected);
    expect(actual).toBe(result);
  });
  it("fromRadians works works with default ellipsoid", function() {
    import__12.Ellipsoid.default = import__12.Ellipsoid.MOON;
    const expectedPosition = new import__12.Cartesian3(
      1.5935143406204558e6,
      691991.9927155221,
      20442.315293410087
    );
    const position = import__12.Cartesian3.fromRadians(0.40968375, 0.01176631);
    expect(position).toEqualEpsilon(expectedPosition, import__12.Math.EPSILON8);
  });
  it("fromRadians throws with no longitude", function() {
    expect(function() {
      import__12.Cartesian3.fromRadians();
    }).toThrowDeveloperError();
  });
  it("fromRadians throws with no latitude", function() {
    expect(function() {
      import__12.Cartesian3.fromRadians(1);
    }).toThrowDeveloperError();
  });
  it("fromDegreesArray", function() {
    const lon1 = 90;
    const lat1 = -70;
    const lon2 = -100;
    const lat2 = 40;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const actual = import__12.Cartesian3.fromDegreesArray([lon1, lat1, lon2, lat2]);
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      import__12.Cartographic.fromDegrees(lon1, lat1),
      import__12.Cartographic.fromDegrees(lon2, lat2)
    ]);
    expect(actual).toEqual(expected);
  });
  it("fromDegreesArray works works with default ellipsoid", function() {
    import__12.Ellipsoid.default = import__12.Ellipsoid.MOON;
    const expectedPositions = [
      new import__12.Cartesian3(1593514338295244e-9, 691991.9979835141, 20442.318221152018),
      new import__12.Cartesian3(
        1.6538316133167143e6,
        -520773.6558050613,
        -110428.9555038242
      ),
      new import__12.Cartesian3(1.5566603478111108e6, 98714.16930719782, 765259.9782626687)
    ];
    const positions = import__12.Cartesian3.fromDegreesArray([
      23.47315,
      0.67416,
      342.52135,
      -3.64417,
      3.6285,
      26.13341
    ]);
    expect(positions).toEqualEpsilon(expectedPositions, import__12.Math.EPSILON8);
  });
  it("fromDegreesArray throws with no positions", function() {
    expect(function() {
      import__12.Cartesian3.fromDegreesArray();
    }).toThrowDeveloperError();
  });
  it("fromDegreesArray throws with positions length < 2", function() {
    expect(function() {
      import__12.Cartesian3.fromDegreesArray([]);
    }).toThrowDeveloperError();
  });
  it("fromDegreesArray throws with positions length not multiple of 2", function() {
    expect(function() {
      import__12.Cartesian3.fromDegreesArray([1, 3, 5]);
    }).toThrowDeveloperError();
  });
  it("fromRadiansArray", function() {
    const lon1 = import__12.Math.toRadians(90);
    const lat1 = import__12.Math.toRadians(-70);
    const lon2 = import__12.Math.toRadians(-100);
    const lat2 = import__12.Math.toRadians(40);
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const actual = import__12.Cartesian3.fromRadiansArray([lon1, lat1, lon2, lat2]);
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      new import__12.Cartographic(lon1, lat1),
      new import__12.Cartographic(lon2, lat2)
    ]);
    expect(actual).toEqual(expected);
  });
  it("fromRadiansArray with result", function() {
    const lon1 = import__12.Math.toRadians(90);
    const lat1 = import__12.Math.toRadians(-70);
    const lon2 = import__12.Math.toRadians(-100);
    const lat2 = import__12.Math.toRadians(40);
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const result = [new import__12.Cartesian3(), new import__12.Cartesian3()];
    const actual = import__12.Cartesian3.fromRadiansArray(
      [lon1, lat1, lon2, lat2],
      ellipsoid,
      result
    );
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      new import__12.Cartographic(lon1, lat1),
      new import__12.Cartographic(lon2, lat2)
    ]);
    expect(result).toEqual(expected);
    expect(actual).toBe(result);
  });
  it("fromRadiansArray works works with default ellipsoid", function() {
    import__12.Ellipsoid.default = import__12.Ellipsoid.MOON;
    const expectedPositions = [
      new import__12.Cartesian3(1.5935143406204558e6, 691991.9927155221, 20442.315293410087),
      new import__12.Cartesian3(
        1.6538316107836158e6,
        -520773.6656886929,
        -110428.94683022468
      ),
      new import__12.Cartesian3(1.5566603474447567e6, 98714.16630095398, 765259.9793956806)
    ];
    const positions = import__12.Cartesian3.fromRadiansArray([
      0.40968375,
      0.01176631,
      5.97812531,
      -0.06360276,
      0.06332927,
      0.45611405
    ]);
    expect(positions).toEqualEpsilon(expectedPositions, import__12.Math.EPSILON8);
  });
  it("fromRadiansArray throws with no positions", function() {
    expect(function() {
      import__12.Cartesian3.fromRadiansArray();
    }).toThrowDeveloperError();
  });
  it("fromRadiansArray throws with positions length < 2", function() {
    expect(function() {
      import__12.Cartesian3.fromRadiansArray([]);
    }).toThrowDeveloperError();
  });
  it("fromRadiansArray throws with positions length not multiple of 2", function() {
    expect(function() {
      import__12.Cartesian3.fromRadiansArray([1, 3, 5]);
    }).toThrowDeveloperError();
  });
  it("fromDegreesArrayHeights", function() {
    const lon1 = 90;
    const lat1 = -70;
    const alt1 = 2e5;
    const lon2 = -100;
    const lat2 = 40;
    const alt2 = 1e5;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const actual = import__12.Cartesian3.fromDegreesArrayHeights([
      lon1,
      lat1,
      alt1,
      lon2,
      lat2,
      alt2
    ]);
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      import__12.Cartographic.fromDegrees(lon1, lat1, alt1),
      import__12.Cartographic.fromDegrees(lon2, lat2, alt2)
    ]);
    expect(actual).toEqual(expected);
  });
  it("fromDegreesArrayHeights works works with default ellipsoid", function() {
    import__12.Ellipsoid.default = import__12.Ellipsoid.MOON;
    const expectedPositions = [
      new import__12.Cartesian3(1.5936060566294384e6, 692031.8271534222, 20443.494825170732),
      new import__12.Cartesian3(
        1.6539268033485617e6,
        -520803.63011470815,
        -110435.31149297487
      ),
      new import__12.Cartesian3(1.5567499449302435e6, 98719.85102524245, 765304.0245374623)
    ];
    const positions = import__12.Cartesian3.fromDegreesArrayHeights([
      23.47315,
      0.67416,
      100,
      342.52135,
      -3.64417,
      100,
      3.6285,
      26.13341,
      100
    ]);
    expect(positions).toEqualEpsilon(expectedPositions, import__12.Math.EPSILON8);
  });
  it("fromDegreesArrayHeights throws with no positions", function() {
    expect(function() {
      import__12.Cartesian3.fromDegreesArrayHeights();
    }).toThrowDeveloperError();
  });
  it("fromDegreesArrayHeights throws with positions length < 3", function() {
    expect(function() {
      import__12.Cartesian3.fromDegreesArrayHeights([]);
    }).toThrowDeveloperError();
  });
  it("fromDegreesArrayHeights throws with positions length not multiple of 3", function() {
    expect(function() {
      import__12.Cartesian3.fromDegreesArrayHeights([1, 3, 5, 2]);
    }).toThrowDeveloperError();
  });
  it("fromRadiansArrayHeights", function() {
    const lon1 = import__12.Math.toRadians(90);
    const lat1 = import__12.Math.toRadians(-70);
    const alt1 = 2e5;
    const lon2 = import__12.Math.toRadians(-100);
    const lat2 = import__12.Math.toRadians(40);
    const alt2 = 1e5;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const actual = import__12.Cartesian3.fromRadiansArrayHeights([
      lon1,
      lat1,
      alt1,
      lon2,
      lat2,
      alt2
    ]);
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      new import__12.Cartographic(lon1, lat1, alt1),
      new import__12.Cartographic(lon2, lat2, alt2)
    ]);
    expect(actual).toEqual(expected);
  });
  it("fromRadiansArrayHeights with result", function() {
    const lon1 = import__12.Math.toRadians(90);
    const lat1 = import__12.Math.toRadians(-70);
    const alt1 = 2e5;
    const lon2 = import__12.Math.toRadians(-100);
    const lat2 = import__12.Math.toRadians(40);
    const alt2 = 1e5;
    const ellipsoid = import__12.Ellipsoid.WGS84;
    const result = [new import__12.Cartesian3(), new import__12.Cartesian3()];
    const actual = import__12.Cartesian3.fromRadiansArrayHeights(
      [lon1, lat1, alt1, lon2, lat2, alt2],
      ellipsoid,
      result
    );
    const expected = ellipsoid.cartographicArrayToCartesianArray([
      new import__12.Cartographic(lon1, lat1, alt1),
      new import__12.Cartographic(lon2, lat2, alt2)
    ]);
    expect(result).toEqual(expected);
    expect(actual).toBe(result);
  });
  it("fromRadiansArrayHeights works works with default ellipsoid", function() {
    import__12.Ellipsoid.default = import__12.Ellipsoid.MOON;
    const expectedPositions = [
      new import__12.Cartesian3(1.5936060589547842e6, 692031.821885127, 20443.49189726029),
      new import__12.Cartesian3(
        1.6539268008153175e6,
        -520803.6399989086,
        -110435.30281887612
      ),
      new import__12.Cartesian3(1.5567499445638682e6, 98719.84801882556, 765304.0256705394)
    ];
    const positions = import__12.Cartesian3.fromRadiansArrayHeights([
      0.40968375,
      0.01176631,
      100,
      5.97812531,
      -0.06360276,
      100,
      0.06332927,
      0.45611405,
      100
    ]);
    expect(positions).toEqualEpsilon(expectedPositions, import__12.Math.EPSILON8);
  });
  it("fromRadiansArrayHeights throws with no positions", function() {
    expect(function() {
      import__12.Cartesian3.fromRadiansArrayHeights();
    }).toThrowDeveloperError();
  });
  it("fromRadiansArrayHeights throws with positions length < 3", function() {
    expect(function() {
      import__12.Cartesian3.fromRadiansArrayHeights([]);
    }).toThrowDeveloperError();
  });
  it("fromRadiansArrayHeights throws with positions length not multiple of 3", function() {
    expect(function() {
      import__12.Cartesian3.fromRadiansArrayHeights([1, 3, 5, 2]);
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.minimumByComponent(new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.maximumByComponent(new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("clamp throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.clamp(new import__12.Cartesian3(), new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("normalize throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.normalize(new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.multiplyComponents(new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("divideComponents throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.divideComponents(new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("add throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.add(new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.subtract(new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.multiplyByScalar(new import__12.Cartesian3(), 5);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.divideByScalar(new import__12.Cartesian3(), 5);
    }).toThrowDeveloperError();
  });
  it("negate throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.negate(new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("abs throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.abs(new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("cross throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.cross(new import__12.Cartesian3(), new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("lerp throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.lerp(new import__12.Cartesian3(), new import__12.Cartesian3(), 10);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no result", function() {
    expect(function() {
      import__12.Cartesian3.mostOrthogonalAxis(new import__12.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("projects vector a onto vector b", function() {
    let a = new import__12.Cartesian3(0, 1, 0);
    let b = new import__12.Cartesian3(1, 0, 0);
    let result = import__12.Cartesian3.projectVector(a, b, new import__12.Cartesian3());
    expect(result).toEqual(new import__12.Cartesian3(0, 0, 0));
    a = new import__12.Cartesian3(1, 1, 0);
    b = new import__12.Cartesian3(1, 0, 0);
    result = import__12.Cartesian3.projectVector(a, b, new import__12.Cartesian3());
    expect(result).toEqual(new import__12.Cartesian3(1, 0, 0));
  });
  it("projectVector throws when missing parameters", function() {
    expect(function() {
      return import__12.Cartesian3.projectVector(
        void 0,
        new import__12.Cartesian3(),
        new import__12.Cartesian3()
      );
    }).toThrowDeveloperError();
    expect(function() {
      return import__12.Cartesian3.projectVector(
        new import__12.Cartesian3(),
        void 0,
        new import__12.Cartesian3()
      );
    }).toThrowDeveloperError();
    expect(function() {
      return import__12.Cartesian3.projectVector(
        new import__12.Cartesian3(),
        new import__12.Cartesian3(),
        void 0
      );
    }).toThrowDeveloperError();
  });
  createPackableSpecs_default(import__12.Cartesian3, new import__12.Cartesian3(1, 2, 3), [1, 2, 3]);
  createPackableArraySpecs_default(
    import__12.Cartesian3,
    [new import__12.Cartesian3(1, 2, 3), new import__12.Cartesian3(4, 5, 6)],
    [1, 2, 3, 4, 5, 6],
    3
  );
});

// packages/engine/Specs/Core/Cartesian4Spec.js
var import__13 = __toESM(require_Cesium(), 1);
describe("Core/Cartesian4", function() {
  it("construct with default values", function() {
    const cartesian = new import__13.Cartesian4();
    expect(cartesian.x).toEqual(0);
    expect(cartesian.y).toEqual(0);
    expect(cartesian.z).toEqual(0);
    expect(cartesian.w).toEqual(0);
  });
  it("construct with all values", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    expect(cartesian.x).toEqual(1);
    expect(cartesian.y).toEqual(2);
    expect(cartesian.z).toEqual(3);
    expect(cartesian.w).toEqual(4);
  });
  it("fromArray creates a Cartesian4", function() {
    const cartesian = import__13.Cartesian4.fromArray([1, 2, 3, 4]);
    expect(cartesian).toEqual(new import__13.Cartesian4(1, 2, 3, 4));
  });
  it("fromArray with an offset creates a Cartesian4", function() {
    const cartesian = import__13.Cartesian4.fromArray([0, 1, 2, 3, 4, 0], 1);
    expect(cartesian).toEqual(new import__13.Cartesian4(1, 2, 3, 4));
  });
  it("fromArray creates a Cartesian4 with a result parameter", function() {
    const cartesian = new import__13.Cartesian4();
    const result = import__13.Cartesian4.fromArray([1, 2, 3, 4], 0, cartesian);
    expect(result).toBe(cartesian);
    expect(result).toEqual(new import__13.Cartesian4(1, 2, 3, 4));
  });
  it("fromArray throws without values", function() {
    expect(function() {
      import__13.Cartesian4.fromArray();
    }).toThrowDeveloperError();
  });
  it("fromElements returns a cartesian4 with corrrect coordinates", function() {
    const cartesian4 = import__13.Cartesian4.fromElements(2, 2, 4, 7);
    const expectedResult = new import__13.Cartesian4(2, 2, 4, 7);
    expect(cartesian4).toEqual(expectedResult);
  });
  it("fromElements result param returns cartesian4 with correct coordinates", function() {
    const cartesian4 = new import__13.Cartesian4();
    import__13.Cartesian4.fromElements(2, 2, 4, 7, cartesian4);
    const expectedResult = new import__13.Cartesian4(2, 2, 4, 7);
    expect(cartesian4).toEqual(expectedResult);
  });
  it("fromColor returns a cartesian4 with corrrect coordinates", function() {
    const cartesian4 = import__13.Cartesian4.fromColor(new import__13.Color(1, 2, 3, 4));
    expect(cartesian4).toEqual(new import__13.Cartesian4(1, 2, 3, 4));
  });
  it("fromColor result param returns cartesian4 with correct coordinates", function() {
    const cartesian4 = new import__13.Cartesian4();
    const result = import__13.Cartesian4.fromColor(
      new import__13.Color(1, 2, 3, 4),
      cartesian4
    );
    expect(cartesian4).toBe(result);
    expect(cartesian4).toEqual(new import__13.Cartesian4(1, 2, 3, 4));
  });
  it("fromColor throws without color", function() {
    expect(function() {
      import__13.Cartesian4.fromColor();
    }).toThrowDeveloperError();
  });
  it("clone without a result parameter", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    const result = import__13.Cartesian4.clone(cartesian, new import__13.Cartesian4());
    expect(cartesian).not.toBe(result);
    expect(cartesian).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    const result = new import__13.Cartesian4();
    const returnedResult = import__13.Cartesian4.clone(cartesian, result);
    expect(cartesian).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(cartesian).toEqual(result);
  });
  it("clone works with a result parameter that is an input parameter", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    const returnedResult = import__13.Cartesian4.clone(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
  });
  it("maximumComponent works when X is greater", function() {
    const cartesian = new import__13.Cartesian4(2, 1, 0, -1);
    expect(import__13.Cartesian4.maximumComponent(cartesian)).toEqual(cartesian.x);
  });
  it("maximumComponent works when Y is greater", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 0, -1);
    expect(import__13.Cartesian4.maximumComponent(cartesian)).toEqual(cartesian.y);
  });
  it("maximumComponent works when Z is greater", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, -1);
    expect(import__13.Cartesian4.maximumComponent(cartesian)).toEqual(cartesian.z);
  });
  it("maximumComponent works when W is greater", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    expect(import__13.Cartesian4.maximumComponent(cartesian)).toEqual(cartesian.w);
  });
  it("minimumComponent works when X is lesser", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    expect(import__13.Cartesian4.minimumComponent(cartesian)).toEqual(cartesian.x);
  });
  it("minimumComponent works when Y is lesser", function() {
    const cartesian = new import__13.Cartesian4(2, 1, 3, 4);
    expect(import__13.Cartesian4.minimumComponent(cartesian)).toEqual(cartesian.y);
  });
  it("minimumComponent works when Z is lesser", function() {
    const cartesian = new import__13.Cartesian4(2, 1, 0, 4);
    expect(import__13.Cartesian4.minimumComponent(cartesian)).toEqual(cartesian.z);
  });
  it("minimumComponent works when W is lesser", function() {
    const cartesian = new import__13.Cartesian4(2, 1, 0, -1);
    expect(import__13.Cartesian4.minimumComponent(cartesian)).toEqual(cartesian.w);
  });
  it("minimumByComponent", function() {
    let first;
    let second;
    let expected;
    const result = new import__13.Cartesian4();
    first = new import__13.Cartesian4(2, 0, 0, 0);
    second = new import__13.Cartesian4(1, 0, 0, 0);
    expected = new import__13.Cartesian4(1, 0, 0, 0);
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(1, 0, 0, 0);
    second = new import__13.Cartesian4(2, 0, 0, 0);
    expected = new import__13.Cartesian4(1, 0, 0, 0);
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 0, 0);
    second = new import__13.Cartesian4(1, -20, 0, 0);
    expected = new import__13.Cartesian4(1, -20, 0, 0);
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -20, 0, 0);
    second = new import__13.Cartesian4(1, -15, 0, 0);
    expected = new import__13.Cartesian4(1, -20, 0, 0);
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 26.4, 0);
    second = new import__13.Cartesian4(1, -20, 26.5, 0);
    expected = new import__13.Cartesian4(1, -20, 26.4, 0);
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 26.5, 0);
    second = new import__13.Cartesian4(1, -20, 26.4, 0);
    expected = new import__13.Cartesian4(1, -20, 26.4, 0);
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 26.4, -450);
    second = new import__13.Cartesian4(1, -20, 26.5, 450);
    expected = new import__13.Cartesian4(1, -20, 26.4, -450);
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 26.5, 450);
    second = new import__13.Cartesian4(1, -20, 26.4, -450);
    expected = new import__13.Cartesian4(1, -20, 26.4, -450);
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent with a result parameter", function() {
    const first = new import__13.Cartesian4(2, 0, 0, 0);
    const second = new import__13.Cartesian4(1, 0, 0, 0);
    const expected = new import__13.Cartesian4(1, 0, 0, 0);
    const result = new import__13.Cartesian4();
    const returnedResult = import__13.Cartesian4.minimumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("minimumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__13.Cartesian4(2, 0, 0, 0);
    const second = new import__13.Cartesian4(1, 0, 0, 0);
    const expected = new import__13.Cartesian4(1, 0, 0, 0);
    expect(import__13.Cartesian4.minimumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__13.Cartesian4.minimumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("minimumByComponent throws without first", function() {
    expect(function() {
      import__13.Cartesian4.minimumByComponent();
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws without second", function() {
    expect(function() {
      import__13.Cartesian4.minimumByComponent(new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("minimumByComponent works when first's or second's X is lesser", function() {
    const first = new import__13.Cartesian4(2, 0, 0, 0);
    const second = new import__13.Cartesian4(1, 0, 0, 0);
    const expected = new import__13.Cartesian4(1, 0, 0, 0);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 2;
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Y is lesser", function() {
    const first = new import__13.Cartesian4(0, 2, 0, 0);
    const second = new import__13.Cartesian4(0, 1, 0, 0);
    const expected = new import__13.Cartesian4(0, 1, 0, 0);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 2;
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's Z is lesser", function() {
    const first = new import__13.Cartesian4(0, 0, 2, 0);
    const second = new import__13.Cartesian4(0, 0, 1, 0);
    const expected = new import__13.Cartesian4(0, 0, 1, 0);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.z = 3;
    expected.z = 2;
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("minimumByComponent works when first's or second's W is lesser", function() {
    const first = new import__13.Cartesian4(0, 0, 0, 2);
    const second = new import__13.Cartesian4(0, 0, 0, 1);
    const expected = new import__13.Cartesian4(0, 0, 0, 1);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
    second.w = 3;
    expected.w = 2;
    expect(import__13.Cartesian4.minimumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent", function() {
    let first;
    let second;
    let expected;
    first = new import__13.Cartesian4(2, 0, 0, 0);
    second = new import__13.Cartesian4(1, 0, 0, 0);
    expected = new import__13.Cartesian4(2, 0, 0, 0);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(1, 0, 0, 0);
    second = new import__13.Cartesian4(2, 0, 0, 0);
    expected = new import__13.Cartesian4(2, 0, 0, 0);
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 0, 0);
    second = new import__13.Cartesian4(1, -20, 0, 0);
    expected = new import__13.Cartesian4(2, -15, 0, 0);
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -20, 0, 0);
    second = new import__13.Cartesian4(1, -15, 0, 0);
    expected = new import__13.Cartesian4(2, -15, 0, 0);
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 26.4, 0);
    second = new import__13.Cartesian4(1, -20, 26.5, 0);
    expected = new import__13.Cartesian4(2, -15, 26.5, 0);
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 26.5, 0);
    second = new import__13.Cartesian4(1, -20, 26.4, 0);
    expected = new import__13.Cartesian4(2, -15, 26.5, 0);
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 26.5, 450);
    second = new import__13.Cartesian4(1, -20, 26.4, -450);
    expected = new import__13.Cartesian4(2, -15, 26.5, 450);
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    first = new import__13.Cartesian4(2, -15, 26.5, -450);
    second = new import__13.Cartesian4(1, -20, 26.4, 450);
    expected = new import__13.Cartesian4(2, -15, 26.5, 450);
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent with a result parameter", function() {
    const first = new import__13.Cartesian4(2, 0, 0, 0);
    const second = new import__13.Cartesian4(1, 0, 0, 0);
    const expected = new import__13.Cartesian4(2, 0, 0, 0);
    const result = new import__13.Cartesian4();
    const returnedResult = import__13.Cartesian4.maximumByComponent(first, second, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("maximumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__13.Cartesian4(2, 0, 0, 0);
    const second = new import__13.Cartesian4(1, 0, 0, 0);
    const expected = new import__13.Cartesian4(2, 0, 0, 0);
    expect(import__13.Cartesian4.maximumByComponent(first, second, first)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__13.Cartesian4.maximumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("maximumByComponent with a result parameter that is an input parameter", function() {
    const first = new import__13.Cartesian4(2, 0, 0, 0);
    const second = new import__13.Cartesian4(1, 0, 0, 0);
    const expected = new import__13.Cartesian4(2, 0, 0, 0);
    expect(import__13.Cartesian4.maximumByComponent(first, second, second)).toEqual(
      expected
    );
    first.x = 1;
    second.x = 2;
    expect(import__13.Cartesian4.maximumByComponent(first, second, second)).toEqual(
      expected
    );
  });
  it("maximumByComponent throws without first", function() {
    expect(function() {
      import__13.Cartesian4.maximumByComponent();
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws without second", function() {
    expect(function() {
      import__13.Cartesian4.maximumByComponent(new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent works when first's or second's X is greater", function() {
    const first = new import__13.Cartesian4(2, 0, 0, 0);
    const second = new import__13.Cartesian4(1, 0, 0, 0);
    const expected = new import__13.Cartesian4(2, 0, 0, 0);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.x = 3;
    expected.x = 3;
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Y is greater", function() {
    const first = new import__13.Cartesian4(0, 2, 0, 0);
    const second = new import__13.Cartesian4(0, 1, 0, 0);
    const expected = new import__13.Cartesian4(0, 2, 0, 0);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.y = 3;
    expected.y = 3;
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's Z is greater", function() {
    const first = new import__13.Cartesian4(0, 0, 2, 0);
    const second = new import__13.Cartesian4(0, 0, 1, 0);
    const expected = new import__13.Cartesian4(0, 0, 2, 0);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.z = 3;
    expected.z = 3;
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("maximumByComponent works when first's or second's W is greater", function() {
    const first = new import__13.Cartesian4(0, 0, 0, 2);
    const second = new import__13.Cartesian4(0, 0, 0, 1);
    const expected = new import__13.Cartesian4(0, 0, 0, 2);
    const result = new import__13.Cartesian4();
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
    second.w = 3;
    expected.w = 3;
    expect(import__13.Cartesian4.maximumByComponent(first, second, result)).toEqual(
      expected
    );
  });
  it("clamp", function() {
    let value;
    let min;
    let max;
    let expected;
    const result = new import__13.Cartesian4();
    value = new import__13.Cartesian4(-1, 0, 0);
    min = new import__13.Cartesian4(0, 0, 0);
    max = new import__13.Cartesian4(1, 1, 1);
    expected = new import__13.Cartesian4(0, 0, 0);
    expect(import__13.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__13.Cartesian4(2, 0, 0);
    min = new import__13.Cartesian4(0, 0, 0);
    max = new import__13.Cartesian4(1, 1, 1);
    expected = new import__13.Cartesian4(1, 0, 0);
    expect(import__13.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__13.Cartesian4(0, -1, 0);
    min = new import__13.Cartesian4(0, 0, 0);
    max = new import__13.Cartesian4(1, 1, 1);
    expected = new import__13.Cartesian4(0, 0, 0);
    expect(import__13.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__13.Cartesian4(0, 2, 0);
    min = new import__13.Cartesian4(0, 0, 0);
    max = new import__13.Cartesian4(1, 1, 1);
    expected = new import__13.Cartesian4(0, 1, 0);
    expect(import__13.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__13.Cartesian4(0, 0, -1);
    min = new import__13.Cartesian4(0, 0, 0);
    max = new import__13.Cartesian4(1, 1, 1);
    expected = new import__13.Cartesian4(0, 0, 0);
    expect(import__13.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__13.Cartesian4(0, 0, 2);
    min = new import__13.Cartesian4(0, 0, 0);
    max = new import__13.Cartesian4(1, 1, 1);
    expected = new import__13.Cartesian4(0, 0, 1);
    expect(import__13.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__13.Cartesian4(-2, 3, 4);
    min = new import__13.Cartesian4(0, 0, 0);
    max = new import__13.Cartesian4(1, 1, 1);
    expected = new import__13.Cartesian4(0, 1, 1);
    expect(import__13.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
    value = new import__13.Cartesian4(0, 0, 0);
    min = new import__13.Cartesian4(1, 2, 3);
    max = new import__13.Cartesian4(1, 2, 3);
    expected = new import__13.Cartesian4(1, 2, 3);
    expect(import__13.Cartesian4.clamp(value, min, max, result)).toEqual(expected);
  });
  it("clamp with a result parameter", function() {
    const value = new import__13.Cartesian4(-1, -1, -1, -1);
    const min = new import__13.Cartesian4(0, 0, 0, 0);
    const max = new import__13.Cartesian4(1, 1, 1, 1);
    const expected = new import__13.Cartesian4(0, 0, 0, 0);
    const result = new import__13.Cartesian4();
    const returnedResult = import__13.Cartesian4.clamp(value, min, max, result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expected);
  });
  it("clamp with a result parameter that is an input parameter", function() {
    const value = new import__13.Cartesian4(-1, -1, -1, -1);
    const min = new import__13.Cartesian4(0, 0, 0, 0);
    const max = new import__13.Cartesian4(1, 1, 1, 1);
    const expected = new import__13.Cartesian4(0, 0, 0, 0);
    expect(import__13.Cartesian4.clamp(value, min, max, value)).toEqual(expected);
    import__13.Cartesian4.fromElements(-1, -1, -1, -1, value);
    expect(import__13.Cartesian4.clamp(value, min, max, min)).toEqual(expected);
    import__13.Cartesian4.fromElements(0, 0, 0, 0, min);
    expect(import__13.Cartesian4.clamp(value, min, max, max)).toEqual(expected);
  });
  it("clamp throws without value", function() {
    expect(function() {
      import__13.Cartesian4.clamp();
    }).toThrowDeveloperError();
  });
  it("clamp throws without min", function() {
    expect(function() {
      import__13.Cartesian4.clamp(new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("clamp throws without max", function() {
    expect(function() {
      import__13.Cartesian4.clamp(new import__13.Cartesian4(), new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared", function() {
    const cartesian = new import__13.Cartesian4(3, 4, 5, 6);
    expect(import__13.Cartesian4.magnitudeSquared(cartesian)).toEqual(86);
  });
  it("magnitude", function() {
    const cartesian = new import__13.Cartesian4(3, 4, 5, 6);
    expect(import__13.Cartesian4.magnitude(cartesian)).toEqual(Math.sqrt(86));
  });
  it("distance", function() {
    const distance = import__13.Cartesian4.distance(
      new import__13.Cartesian4(1, 0, 0, 0),
      new import__13.Cartesian4(2, 0, 0, 0)
    );
    expect(distance).toEqual(1);
  });
  it("distance throws without left", function() {
    expect(function() {
      import__13.Cartesian4.distance();
    }).toThrowDeveloperError();
  });
  it("distance throws without right", function() {
    expect(function() {
      import__13.Cartesian4.distance(import__13.Cartesian4.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("distanceSquared", function() {
    const distanceSquared = import__13.Cartesian4.distanceSquared(
      new import__13.Cartesian4(1, 0, 0, 0),
      new import__13.Cartesian4(3, 0, 0, 0)
    );
    expect(distanceSquared).toEqual(4);
  });
  it("distanceSquared throws without left", function() {
    expect(function() {
      import__13.Cartesian4.distanceSquared();
    }).toThrowDeveloperError();
  });
  it("distanceSquared throws without right", function() {
    expect(function() {
      import__13.Cartesian4.distanceSquared(import__13.Cartesian4.UNIT_X);
    }).toThrowDeveloperError();
  });
  it("normalize works with a result parameter", function() {
    const cartesian = new import__13.Cartesian4(2, 0, 0, 0);
    const expectedResult = new import__13.Cartesian4(1, 0, 0, 0);
    const result = new import__13.Cartesian4();
    const returnedResult = import__13.Cartesian4.normalize(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("normalize works with a result parameter that is an input parameter", function() {
    const cartesian = new import__13.Cartesian4(2, 0, 0, 0);
    const expectedResult = new import__13.Cartesian4(1, 0, 0, 0);
    const returnedResult = import__13.Cartesian4.normalize(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("normalize throws with zero vector", function() {
    expect(function() {
      import__13.Cartesian4.normalize(import__13.Cartesian4.ZERO, new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents works with a result parameter", function() {
    const left = new import__13.Cartesian4(2, 3, 6, 8);
    const right = new import__13.Cartesian4(4, 5, 7, 9);
    const result = new import__13.Cartesian4();
    const expectedResult = new import__13.Cartesian4(8, 15, 42, 72);
    const returnedResult = import__13.Cartesian4.multiplyComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyComponents works with a result parameter that is an input parameter", function() {
    const left = new import__13.Cartesian4(2, 3, 6, 8);
    const right = new import__13.Cartesian4(4, 5, 7, 9);
    const expectedResult = new import__13.Cartesian4(8, 15, 42, 72);
    const returnedResult = import__13.Cartesian4.multiplyComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter", function() {
    const left = new import__13.Cartesian4(2, 3, 6, 15);
    const right = new import__13.Cartesian4(4, 5, 8, 2);
    const result = new import__13.Cartesian4();
    const expectedResult = new import__13.Cartesian4(0.5, 0.6, 0.75, 7.5);
    const returnedResult = import__13.Cartesian4.divideComponents(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideComponents works with a result parameter that is an input parameter", function() {
    const left = new import__13.Cartesian4(2, 3, 6, 15);
    const right = new import__13.Cartesian4(4, 5, 8, 2);
    const expectedResult = new import__13.Cartesian4(0.5, 0.6, 0.75, 7.5);
    const returnedResult = import__13.Cartesian4.divideComponents(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("dot", function() {
    const left = new import__13.Cartesian4(2, 3, 6, 8);
    const right = new import__13.Cartesian4(4, 5, 7, 9);
    const expectedResult = 137;
    const result = import__13.Cartesian4.dot(left, right);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter", function() {
    const left = new import__13.Cartesian4(2, 3, 6, 8);
    const right = new import__13.Cartesian4(4, 5, 7, 9);
    const result = new import__13.Cartesian4();
    const expectedResult = new import__13.Cartesian4(6, 8, 13, 17);
    const returnedResult = import__13.Cartesian4.add(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("add works with a result parameter that is an input parameter", function() {
    const left = new import__13.Cartesian4(2, 3, 6, 8);
    const right = new import__13.Cartesian4(4, 5, 7, 9);
    const expectedResult = new import__13.Cartesian4(6, 8, 13, 17);
    const returnedResult = import__13.Cartesian4.add(left, right, left);
    expect(left).toBe(returnedResult);
    expect(left).toEqual(expectedResult);
  });
  it("subtract works with a result parameter", function() {
    const left = new import__13.Cartesian4(2, 3, 4, 8);
    const right = new import__13.Cartesian4(1, 5, 7, 9);
    const result = new import__13.Cartesian4();
    const expectedResult = new import__13.Cartesian4(1, -2, -3, -1);
    const returnedResult = import__13.Cartesian4.subtract(left, right, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("subtract works with this result parameter", function() {
    const left = new import__13.Cartesian4(2, 3, 4, 8);
    const right = new import__13.Cartesian4(1, 5, 7, 9);
    const expectedResult = new import__13.Cartesian4(1, -2, -3, -1);
    const returnedResult = import__13.Cartesian4.subtract(left, right, left);
    expect(returnedResult).toBe(left);
    expect(left).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    const result = new import__13.Cartesian4();
    const scalar = 2;
    const expectedResult = new import__13.Cartesian4(2, 4, 6, 8);
    const returnedResult = import__13.Cartesian4.multiplyByScalar(
      cartesian,
      scalar,
      result
    );
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("multiplyByScalar with a result parameter that is an input parameter", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    const scalar = 2;
    const expectedResult = new import__13.Cartesian4(2, 4, 6, 8);
    const returnedResult = import__13.Cartesian4.multiplyByScalar(
      cartesian,
      scalar,
      cartesian
    );
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    const result = new import__13.Cartesian4();
    const scalar = 2;
    const expectedResult = new import__13.Cartesian4(0.5, 1, 1.5, 2);
    const returnedResult = import__13.Cartesian4.divideByScalar(cartesian, scalar, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("divideByScalar with a result parameter that is an input parameter", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    const scalar = 2;
    const expectedResult = new import__13.Cartesian4(0.5, 1, 1.5, 2);
    const returnedResult = import__13.Cartesian4.divideByScalar(
      cartesian,
      scalar,
      cartesian
    );
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("negate with a result parameter", function() {
    const cartesian = new import__13.Cartesian4(1, -2, -5, 4);
    const result = new import__13.Cartesian4();
    const expectedResult = new import__13.Cartesian4(-1, 2, 5, -4);
    const returnedResult = import__13.Cartesian4.negate(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("negate with a result parameter that is an input parameter", function() {
    const cartesian = new import__13.Cartesian4(1, -2, -5);
    const expectedResult = new import__13.Cartesian4(-1, 2, 5);
    const returnedResult = import__13.Cartesian4.negate(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("abs with a result parameter", function() {
    const cartesian = new import__13.Cartesian4(1, -2, -4, -3);
    const result = new import__13.Cartesian4();
    const expectedResult = new import__13.Cartesian4(1, 2, 4, 3);
    const returnedResult = import__13.Cartesian4.abs(cartesian, result);
    expect(result).toBe(returnedResult);
    expect(result).toEqual(expectedResult);
  });
  it("abs with a result parameter that is an input parameter", function() {
    const cartesian = new import__13.Cartesian4(1, -2, -4, -3);
    const expectedResult = new import__13.Cartesian4(1, 2, 4, 3);
    const returnedResult = import__13.Cartesian4.abs(cartesian, cartesian);
    expect(cartesian).toBe(returnedResult);
    expect(cartesian).toEqual(expectedResult);
  });
  it("lerp works with a result parameter that is an input parameter", function() {
    const start = new import__13.Cartesian4(4, 8, 10, 20);
    const end = new import__13.Cartesian4(8, 20, 20, 30);
    const t = 0.25;
    const expectedResult = new import__13.Cartesian4(5, 11, 12.5, 22.5);
    const returnedResult = import__13.Cartesian4.lerp(start, end, t, start);
    expect(start).toBe(returnedResult);
    expect(start).toEqual(expectedResult);
  });
  it("lerp extrapolate forward", function() {
    const start = new import__13.Cartesian4(4, 8, 10, 20);
    const end = new import__13.Cartesian4(8, 20, 20, 30);
    const t = 2;
    let result = new import__13.Cartesian4();
    const expectedResult = new import__13.Cartesian4(12, 32, 30, 40);
    result = import__13.Cartesian4.lerp(start, end, t, result);
    expect(result).toEqual(expectedResult);
  });
  it("lerp extrapolate backward", function() {
    const start = new import__13.Cartesian4(4, 8, 10, 20);
    const end = new import__13.Cartesian4(8, 20, 20, 30);
    const t = -1;
    let result = new import__13.Cartesian4();
    const expectedResult = new import__13.Cartesian4(0, -4, 0, 10);
    result = import__13.Cartesian4.lerp(start, end, t, result);
    expect(result).toEqual(expectedResult);
  });
  it("most orthogonal angle is x", function() {
    const v = new import__13.Cartesian4(0, 1, 2, 3);
    expect(import__13.Cartesian4.mostOrthogonalAxis(v, new import__13.Cartesian4())).toEqual(
      import__13.Cartesian4.UNIT_X
    );
  });
  it("most orthogonal angle is y", function() {
    const v = new import__13.Cartesian4(1, 0, 2, 3);
    expect(import__13.Cartesian4.mostOrthogonalAxis(v, new import__13.Cartesian4())).toEqual(
      import__13.Cartesian4.UNIT_Y
    );
  });
  it("most orthogonal angle is z", function() {
    let v = new import__13.Cartesian4(2, 3, 0, 1);
    expect(import__13.Cartesian4.mostOrthogonalAxis(v, new import__13.Cartesian4())).toEqual(
      import__13.Cartesian4.UNIT_Z
    );
    v = new import__13.Cartesian4(3, 2, 0, 1);
    expect(import__13.Cartesian4.mostOrthogonalAxis(v, new import__13.Cartesian4())).toEqual(
      import__13.Cartesian4.UNIT_Z
    );
  });
  it("most orthogonal angle is w", function() {
    let v = new import__13.Cartesian4(1, 2, 3, 0);
    expect(import__13.Cartesian4.mostOrthogonalAxis(v, new import__13.Cartesian4())).toEqual(
      import__13.Cartesian4.UNIT_W
    );
    v = new import__13.Cartesian4(2, 3, 1, 0);
    expect(import__13.Cartesian4.mostOrthogonalAxis(v, new import__13.Cartesian4())).toEqual(
      import__13.Cartesian4.UNIT_W
    );
    v = new import__13.Cartesian4(3, 1, 2, 0);
    expect(import__13.Cartesian4.mostOrthogonalAxis(v, new import__13.Cartesian4())).toEqual(
      import__13.Cartesian4.UNIT_W
    );
    v = new import__13.Cartesian4(3, 2, 1, 0);
    expect(import__13.Cartesian4.mostOrthogonalAxis(v, new import__13.Cartesian4())).toEqual(
      import__13.Cartesian4.UNIT_W
    );
  });
  it("equals", function() {
    const cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    expect(
      import__13.Cartesian4.equals(cartesian, new import__13.Cartesian4(1, 2, 3, 4))
    ).toEqual(true);
    expect(
      import__13.Cartesian4.equals(cartesian, new import__13.Cartesian4(2, 2, 3, 4))
    ).toEqual(false);
    expect(
      import__13.Cartesian4.equals(cartesian, new import__13.Cartesian4(2, 1, 3, 4))
    ).toEqual(false);
    expect(
      import__13.Cartesian4.equals(cartesian, new import__13.Cartesian4(1, 2, 4, 4))
    ).toEqual(false);
    expect(
      import__13.Cartesian4.equals(cartesian, new import__13.Cartesian4(1, 2, 3, 5))
    ).toEqual(false);
    expect(import__13.Cartesian4.equals(cartesian, void 0)).toEqual(false);
  });
  it("equalsEpsilon", function() {
    let cartesian = new import__13.Cartesian4(1, 2, 3, 4);
    expect(
      cartesian.equalsEpsilon(new import__13.Cartesian4(1, 2, 3, 4), 0)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__13.Cartesian4(1, 2, 3, 4), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__13.Cartesian4(2, 2, 3, 4), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__13.Cartesian4(1, 3, 3, 4), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__13.Cartesian4(1, 2, 4, 4), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(new import__13.Cartesian4(1, 2, 3, 5), 1)
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(2, 2, 3, 4),
        import__13.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(1, 3, 3, 4),
        import__13.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(1, 2, 4, 4),
        import__13.Math.EPSILON6
      )
    ).toEqual(false);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(1, 2, 3, 5),
        import__13.Math.EPSILON6
      )
    ).toEqual(false);
    expect(cartesian.equalsEpsilon(void 0, 1)).toEqual(false);
    cartesian = new import__13.Cartesian4(3e6, 4e6, 5e6, 6e6);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(3e6, 4e6, 5e6, 6e6),
        0
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(30000002e-1, 4e6, 5e6, 6e6),
        import__13.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(3e6, 40000002e-1, 5e6, 6e6),
        import__13.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(3e6, 4e6, 50000002e-1, 6e6),
        import__13.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(3e6, 4e6, 5e6, 60000002e-1),
        import__13.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(30000002e-1, 40000002e-1, 50000002e-1, 60000002e-1),
        import__13.Math.EPSILON7
      )
    ).toEqual(true);
    expect(
      cartesian.equalsEpsilon(
        new import__13.Cartesian4(30000002e-1, 40000002e-1, 50000002e-1, 60000002e-1),
        import__13.Math.EPSILON9
      )
    ).toEqual(false);
    expect(cartesian.equalsEpsilon(void 0, 1)).toEqual(false);
    expect(import__13.Cartesian4.equalsEpsilon(void 0, cartesian, 1)).toEqual(false);
  });
  it("toString", function() {
    const cartesian = new import__13.Cartesian4(1.123, 2.345, 6.789, 6.123);
    expect(cartesian.toString()).toEqual("(1.123, 2.345, 6.789, 6.123)");
  });
  it("clone returns undefined with no parameter", function() {
    expect(import__13.Cartesian4.clone()).toBeUndefined();
  });
  it("maximumComponent throws with no parameter", function() {
    expect(function() {
      import__13.Cartesian4.maximumComponent();
    }).toThrowDeveloperError();
  });
  it("minimumComponent throws with no parameter", function() {
    expect(function() {
      import__13.Cartesian4.minimumComponent();
    }).toThrowDeveloperError();
  });
  it("magnitudeSquared throws with no parameter", function() {
    expect(function() {
      import__13.Cartesian4.magnitudeSquared();
    }).toThrowDeveloperError();
  });
  it("magnitude throws with no parameter", function() {
    expect(function() {
      import__13.Cartesian4.magnitude();
    }).toThrowDeveloperError();
  });
  it("normalize throws with no parameter", function() {
    expect(function() {
      import__13.Cartesian4.normalize();
    }).toThrowDeveloperError();
  });
  it("dot throws with no left parameter", function() {
    expect(function() {
      import__13.Cartesian4.dot(void 0, new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no left parameter", function() {
    const right = new import__13.Cartesian4(4, 5, 6, 7);
    expect(function() {
      import__13.Cartesian4.multiplyComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throw with no right parameter", function() {
    const left = new import__13.Cartesian4(4, 5, 6, 7);
    expect(function() {
      import__13.Cartesian4.multiplyComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no left parameter", function() {
    const right = new import__13.Cartesian4(4, 5, 6, 7);
    expect(function() {
      import__13.Cartesian4.divideComponents(void 0, right);
    }).toThrowDeveloperError();
  });
  it("divideComponents throw with no right parameter", function() {
    const left = new import__13.Cartesian4(4, 5, 6, 7);
    expect(function() {
      import__13.Cartesian4.divideComponents(left, void 0);
    }).toThrowDeveloperError();
  });
  it("dot throws with no right parameter", function() {
    expect(function() {
      import__13.Cartesian4.dot(new import__13.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("add throws with no left parameter", function() {
    expect(function() {
      import__13.Cartesian4.add(void 0, new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("add throws with no right parameter", function() {
    expect(function() {
      import__13.Cartesian4.add(new import__13.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("subtract throws with no left parameter", function() {
    expect(function() {
      import__13.Cartesian4.subtract(void 0, new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no right parameter", function() {
    expect(function() {
      import__13.Cartesian4.subtract(new import__13.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__13.Cartesian4.multiplyByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__13.Cartesian4.multiplyByScalar(new import__13.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no cartesian parameter", function() {
    expect(function() {
      import__13.Cartesian4.divideByScalar(void 0, 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no scalar parameter", function() {
    expect(function() {
      import__13.Cartesian4.divideByScalar(new import__13.Cartesian4(), void 0);
    }).toThrowDeveloperError();
  });
  it("negate throws with no cartesian parameter", function() {
    expect(function() {
      import__13.Cartesian4.negate(void 0);
    }).toThrowDeveloperError();
  });
  it("abs throws with no cartesian parameter", function() {
    expect(function() {
      import__13.Cartesian4.abs(void 0);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no start parameter", function() {
    const end = new import__13.Cartesian4(8, 20, 6);
    const t = 0.25;
    expect(function() {
      import__13.Cartesian4.lerp(void 0, end, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no end parameter", function() {
    const start = new import__13.Cartesian4(4, 8, 6);
    const t = 0.25;
    expect(function() {
      import__13.Cartesian4.lerp(start, void 0, t);
    }).toThrowDeveloperError();
  });
  it("lerp throws with no t parameter", function() {
    const start = new import__13.Cartesian4(4, 8, 6, 7);
    const end = new import__13.Cartesian4(8, 20, 6, 7);
    expect(function() {
      import__13.Cartesian4.lerp(start, end, void 0);
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no cartesian parameter", function() {
    expect(function() {
      import__13.Cartesian4.mostOrthogonalAxis(void 0);
    }).toThrowDeveloperError();
  });
  it("minimumByComponent throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.minimumByComponent(new import__13.Cartesian4(), new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("maximumByComponent throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.maximumByComponent(new import__13.Cartesian4(), new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("clamp throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.clamp(new import__13.Cartesian4(), new import__13.Cartesian4(), new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("normalize throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.normalize(new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("multiplyComponents throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.multiplyComponents(new import__13.Cartesian4(), new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("divideComponents throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.divideComponents(new import__13.Cartesian4(), new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("add throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.add(new import__13.Cartesian4(), new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("subtract throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.subtract(new import__13.Cartesian4(), new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("multiplyByScalar throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.multiplyByScalar(new import__13.Cartesian4(), 2);
    }).toThrowDeveloperError();
  });
  it("divideByScalar throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.divideByScalar(new import__13.Cartesian4(), 2);
    }).toThrowDeveloperError();
  });
  it("negate throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.negate(new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("abs throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.abs(new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("mostOrthogonalAxis throws with no result", function() {
    expect(function() {
      import__13.Cartesian4.mostOrthogonalAxis(new import__13.Cartesian4());
    }).toThrowDeveloperError();
  });
  it("packs and unpacks floating point values for representation as uint8 4-vectors", function() {
    function testFloat(float) {
      const packedFloat = import__13.Cartesian4.packFloat(float);
      expect(0 <= packedFloat.x && packedFloat.x <= 255).toBe(true);
      expect(0 <= packedFloat.y && packedFloat.y <= 255).toBe(true);
      expect(0 <= packedFloat.z && packedFloat.z <= 255).toBe(true);
      expect(0 <= packedFloat.w && packedFloat.w <= 255).toBe(true);
      const unpackedFloat = import__13.Cartesian4.unpackFloat(packedFloat);
      expect(unpackedFloat).toEqual(float);
    }
    function testFloatNaN(float) {
      expect(float).toBeNaN();
      const packedFloat = import__13.Cartesian4.packFloat(float);
      const unpackedFloat = import__13.Cartesian4.unpackFloat(packedFloat);
      expect(unpackedFloat).toBeNaN();
    }
    function testFloatOutOfRange(float) {
      const packedFloat = import__13.Cartesian4.packFloat(float);
      const unpackedFloat = import__13.Cartesian4.unpackFloat(packedFloat);
      expect(unpackedFloat).toEqual(import__13.Math.sign(float) * Infinity);
    }
    testFloat(0);
    testFloat(-1);
    testFloat(1);
    testFloat(123.5);
    testFloat(16777216);
    testFloat(Infinity);
    testFloat(-Infinity);
    testFloatNaN(NaN);
    testFloatOutOfRange(+Number.MAX_VALUE);
    testFloatOutOfRange(-Number.MAX_VALUE);
    const f32 = new Float32Array(1);
    f32[0] = Infinity;
    testFloat(f32[0]);
    f32[0] = -Infinity;
    testFloat(f32[0]);
    f32[0] = NaN;
    testFloatNaN(f32[0]);
  });
  createPackableSpecs_default(import__13.Cartesian4, new import__13.Cartesian4(1, 2, 3, 4), [1, 2, 3, 4]);
  createPackableArraySpecs_default(
    import__13.Cartesian4,
    [new import__13.Cartesian4(1, 2, 3, 4), new import__13.Cartesian4(5, 6, 7, 8)],
    [1, 2, 3, 4, 5, 6, 7, 8],
    4
  );
});

// packages/engine/Specs/Core/CartographicGeocoderServiceSpec.js
var import__14 = __toESM(require_Cesium(), 1);
describe("Core/CartographicGeocoderService", function() {
  const service = new import__14.CartographicGeocoderService();
  it("conforms to GeocoderService interface", function() {
    expect(import__14.CartographicGeocoderService).toConformToInterface(import__14.GeocoderService);
  });
  it("returns cartesian with matching coordinates for NS/EW input", function() {
    const query = "35N 75W";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].destination).toEqual(
        import__14.Cartesian3.fromDegrees(-75, 35, 300)
      );
    });
  });
  it("returns cartesian with matching coordinates for EW/NS input", function() {
    const query = "75W 35N";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].destination).toEqual(
        import__14.Cartesian3.fromDegrees(-75, 35, 300)
      );
    });
  });
  it("returns cartesian with matching coordinates for long/lat/height input", function() {
    const query = " 1.0, 2.0, 3.0 ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].destination).toEqual(
        import__14.Cartesian3.fromDegrees(1, 2, 3)
      );
    });
  });
  it("returns cartesian with matching coordinates for long/lat input", function() {
    const query = " 1.0, 2.0 ";
    const defaultHeight = 300;
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(1);
      expect(results[0].destination).toEqual(
        import__14.Cartesian3.fromDegrees(1, 2, defaultHeight)
      );
    });
  });
  it("returns empty array for input with only longitudinal coordinates", function() {
    const query = " 1e 1e ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
  it("returns empty array for input with only one NSEW coordinate", function() {
    const query = " 1e 1 ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
  it("returns empty array for input with only one number", function() {
    const query = " 2.0 ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
  it("returns empty array for with string", function() {
    const query = " aoeu ";
    return service.geocode(query).then(function(results) {
      expect(results.length).toEqual(0);
    });
  });
});

// packages/engine/Specs/Core/CartographicSpec.js
var import__15 = __toESM(require_Cesium(), 1);
describe("Core/Cartographic", function() {
  const surfaceCartesian = new import__15.Cartesian3(
    4.0943277921465295e6,
    1909216404474774e-9,
    4487348408865919e-9
  );
  const surfaceCartographic = new import__15.Cartographic(
    import__15.Math.toRadians(25),
    import__15.Math.toRadians(45),
    0
  );
  afterEach(function() {
    import__15.Ellipsoid.default = import__15.Ellipsoid.WGS84;
  });
  it("default constructor sets expected properties", function() {
    const c = new import__15.Cartographic();
    expect(c.longitude).toEqual(0);
    expect(c.latitude).toEqual(0);
    expect(c.height).toEqual(0);
  });
  it("constructor sets expected properties from parameters", function() {
    const c = new import__15.Cartographic(1, 2, 3);
    expect(c.longitude).toEqual(1);
    expect(c.latitude).toEqual(2);
    expect(c.height).toEqual(3);
  });
  it("toCartesian conversion from Cartographic input to Cartesian3 output", function() {
    const lon = import__15.Math.toRadians(150);
    const lat = import__15.Math.toRadians(-40);
    const height = 1e5;
    const ellipsoid = import__15.Ellipsoid.WGS84;
    const actual = import__15.Cartographic.toCartesian(new import__15.Cartographic(lon, lat, height));
    const expected = ellipsoid.cartographicToCartesian(
      new import__15.Cartographic(lon, lat, height)
    );
    expect(actual).toEqual(expected);
  });
  it("toCartesian uses default ellipsoid", function() {
    import__15.Ellipsoid.default = import__15.Ellipsoid.MOON;
    const expectedPosition = new import__15.Cartesian3(
      1593514338295244e-9,
      691991.9979835141,
      20442.318221152018
    );
    const cartographic = import__15.Cartographic.fromDegrees(23.47315, 0.67416);
    const position = import__15.Cartographic.toCartesian(cartographic);
    expect(position).toEqualEpsilon(expectedPosition, import__15.Math.EPSILON8);
  });
  it("fromRadians works without a result parameter", function() {
    const c = import__15.Cartographic.fromRadians(Math.PI / 2, Math.PI / 4, 100);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(100);
  });
  it("fromRadians works with a result parameter", function() {
    const result = new import__15.Cartographic();
    const c = import__15.Cartographic.fromRadians(Math.PI / 2, Math.PI / 4, 100, result);
    expect(result).toBe(c);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(100);
  });
  it("fromRadians throws without longitude or latitude parameter but defaults altitude", function() {
    expect(function() {
      import__15.Cartographic.fromRadians(void 0, 0);
    }).toThrowDeveloperError();
    expect(function() {
      import__15.Cartographic.fromRadians(0, void 0);
    }).toThrowDeveloperError();
    const c = import__15.Cartographic.fromRadians(Math.PI / 2, Math.PI / 4);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(0);
  });
  it("fromDegrees works without a result parameter", function() {
    const c = import__15.Cartographic.fromDegrees(90, 45, 100);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(100);
  });
  it("fromDegrees works with a result parameter", function() {
    const result = new import__15.Cartographic();
    const c = import__15.Cartographic.fromDegrees(90, 45, 100, result);
    expect(result).toBe(c);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(100);
  });
  it("fromDegrees throws without longitude or latitude parameter but defaults altitude", function() {
    expect(function() {
      import__15.Cartographic.fromDegrees(void 0, 0);
    }).toThrowDeveloperError();
    expect(function() {
      import__15.Cartographic.fromDegrees(0, void 0);
    }).toThrowDeveloperError();
    const c = import__15.Cartographic.fromDegrees(90, 45);
    expect(c.longitude).toEqual(Math.PI / 2);
    expect(c.latitude).toEqual(Math.PI / 4);
    expect(c.height).toEqual(0);
  });
  it("fromCartesian works without a result parameter", function() {
    const ellipsoid = import__15.Ellipsoid.WGS84;
    const c = import__15.Cartographic.fromCartesian(surfaceCartesian, ellipsoid);
    expect(c).toEqualEpsilon(surfaceCartographic, import__15.Math.EPSILON8);
  });
  it("fromCartesian works with a result parameter", function() {
    const ellipsoid = import__15.Ellipsoid.WGS84;
    const result = new import__15.Cartographic();
    const c = import__15.Cartographic.fromCartesian(surfaceCartesian, ellipsoid, result);
    expect(c).toEqualEpsilon(surfaceCartographic, import__15.Math.EPSILON8);
    expect(result).toBe(c);
  });
  it("fromCartesian works without an ellipsoid", function() {
    const c = import__15.Cartographic.fromCartesian(surfaceCartesian);
    expect(c).toEqualEpsilon(surfaceCartographic, import__15.Math.EPSILON8);
  });
  it("fromCartesian uses default ellipsoid", function() {
    import__15.Ellipsoid.default = import__15.Ellipsoid.MOON;
    const position = new import__15.Cartesian3(
      1593514338295244e-9,
      691991.9979835141,
      20442.318221152018
    );
    const cartographic = new import__15.Cartographic.fromCartesian(position);
    const expectedCartographic = import__15.Cartographic.fromDegrees(23.47315, 0.67416);
    expect(cartographic).toEqualEpsilon(
      expectedCartographic,
      import__15.Math.EPSILON8
    );
  });
  it("fromCartesian throws when there is no cartesian", function() {
    expect(function() {
      import__15.Cartographic.fromCartesian();
    }).toThrowDeveloperError();
  });
  it("fromCartesian works with a value that is above the ellipsoid surface", function() {
    const cartographic1 = import__15.Cartographic.fromDegrees(35.766989, 33.333602, 3e3);
    const cartesian1 = import__15.Cartesian3.fromRadians(
      cartographic1.longitude,
      cartographic1.latitude,
      cartographic1.height
    );
    const cartographic2 = import__15.Cartographic.fromCartesian(cartesian1);
    expect(cartographic2).toEqualEpsilon(cartographic1, import__15.Math.EPSILON8);
  });
  it("fromCartesian works with a value that is bellow the ellipsoid surface", function() {
    const cartographic1 = import__15.Cartographic.fromDegrees(35.766989, 33.333602, -3e3);
    const cartesian1 = import__15.Cartesian3.fromRadians(
      cartographic1.longitude,
      cartographic1.latitude,
      cartographic1.height
    );
    const cartographic2 = import__15.Cartographic.fromCartesian(cartesian1);
    expect(cartographic2).toEqualEpsilon(cartographic1, import__15.Math.EPSILON8);
  });
  it("clone without a result parameter", function() {
    const cartographic = new import__15.Cartographic(1, 2, 3);
    const result = cartographic.clone();
    expect(cartographic).not.toBe(result);
    expect(cartographic).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const cartographic = new import__15.Cartographic(1, 2, 3);
    const result = new import__15.Cartographic();
    const returnedResult = cartographic.clone(result);
    expect(cartographic).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(cartographic).toEqual(result);
  });
  it('clone works with "this" result parameter', function() {
    const cartographic = new import__15.Cartographic(1, 2, 3);
    const returnedResult = cartographic.clone(cartographic);
    expect(cartographic).toBe(returnedResult);
  });
  it("equals", function() {
    const cartographic = new import__15.Cartographic(1, 2, 3);
    expect(cartographic.equals(new import__15.Cartographic(1, 2, 3))).toEqual(true);
    expect(cartographic.equals(new import__15.Cartographic(2, 2, 3))).toEqual(false);
    expect(cartographic.equals(new import__15.Cartographic(2, 1, 3))).toEqual(false);
    expect(cartographic.equals(new import__15.Cartographic(1, 2, 4))).toEqual(false);
    expect(cartographic.equals(void 0)).toEqual(false);
  });
  it("equalsEpsilon", function() {
    const cartographic = new import__15.Cartographic(1, 2, 3);
    expect(
      cartographic.equalsEpsilon(new import__15.Cartographic(1, 2, 3), 0)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__15.Cartographic(1, 2, 3), 1)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__15.Cartographic(2, 2, 3), 1)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__15.Cartographic(1, 3, 3), 1)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__15.Cartographic(1, 2, 4), 1)
    ).toEqual(true);
    expect(
      cartographic.equalsEpsilon(new import__15.Cartographic(2, 2, 3), 0.99999)
    ).toEqual(false);
    expect(
      cartographic.equalsEpsilon(new import__15.Cartographic(1, 3, 3), 0.99999)
    ).toEqual(false);
    expect(
      cartographic.equalsEpsilon(new import__15.Cartographic(1, 2, 4), 0.99999)
    ).toEqual(false);
    expect(cartographic.equalsEpsilon(void 0, 1)).toEqual(false);
  });
  it("toString", function() {
    const cartographic = new import__15.Cartographic(1.123, 2.345, 6.789);
    expect(cartographic.toString()).toEqual("(1.123, 2.345, 6.789)");
  });
  it("clone returns undefined without cartographic parameter", function() {
    expect(import__15.Cartographic.clone(void 0)).toBeUndefined();
  });
});

// packages/engine/Specs/Core/CatmullRomSplineSpec.js
var import__16 = __toESM(require_Cesium(), 1);
describe("Core/CatmullRomSpline", function() {
  let points;
  let times;
  beforeEach(function() {
    points = [
      new import__16.Cartesian3(-1, -1, 0),
      new import__16.Cartesian3(-0.5, -0.125, 0),
      new import__16.Cartesian3(0.5, 0.125, 0),
      new import__16.Cartesian3(1, 1, 0)
    ];
    times = [0, 1, 2, 3];
  });
  it("constructor throws without points or times", function() {
    expect(function() {
      return new import__16.CatmullRomSpline();
    }).toThrowDeveloperError();
  });
  it("constructor throws when control points length is less than 2", function() {
    expect(function() {
      return new import__16.CatmullRomSpline({
        points: [import__16.Cartesian3.ZERO]
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws when times.length is not equal to points.length", function() {
    expect(function() {
      return new import__16.CatmullRomSpline({
        points,
        times: [0, 1]
      });
    }).toThrowDeveloperError();
  });
  it("sets start and end tangents", function() {
    const start = import__16.Cartesian3.subtract(points[1], points[0], new import__16.Cartesian3());
    const end = import__16.Cartesian3.subtract(
      points[points.length - 1],
      points[points.length - 2],
      new import__16.Cartesian3()
    );
    const crs = new import__16.CatmullRomSpline({
      points,
      times,
      firstTangent: start,
      lastTangent: end
    });
    expect(start).toEqual(crs.firstTangent);
    expect(end).toEqual(crs.lastTangent);
  });
  it("computes start and end tangents", function() {
    const controlPoint0 = import__16.Cartesian3.clone(points[0]);
    const controlPoint1 = import__16.Cartesian3.clone(points[1]);
    const controlPoint2 = import__16.Cartesian3.clone(points[2]);
    let start = new import__16.Cartesian3();
    start = import__16.Cartesian3.multiplyByScalar(
      import__16.Cartesian3.subtract(
        import__16.Cartesian3.subtract(
          import__16.Cartesian3.multiplyByScalar(controlPoint1, 2, start),
          controlPoint2,
          start
        ),
        controlPoint0,
        start
      ),
      0.5,
      start
    );
    const controlPointn0 = import__16.Cartesian3.clone(points[points.length - 1]);
    const controlPointn1 = import__16.Cartesian3.clone(points[points.length - 2]);
    const controlPointn2 = import__16.Cartesian3.clone(points[points.length - 3]);
    let end = new import__16.Cartesian3();
    end = import__16.Cartesian3.multiplyByScalar(
      import__16.Cartesian3.add(
        import__16.Cartesian3.subtract(
          controlPointn0,
          import__16.Cartesian3.multiplyByScalar(controlPointn1, 2, end),
          end
        ),
        controlPointn2,
        end
      ),
      0.5,
      end
    );
    const crs = new import__16.CatmullRomSpline({
      points,
      times
    });
    expect(start).toEqual(crs.firstTangent);
    expect(end).toEqual(crs.lastTangent);
  });
  it("evaluate throws without time", function() {
    const crs = new import__16.CatmullRomSpline({
      points,
      times
    });
    expect(function() {
      crs.evaluate();
    }).toThrowDeveloperError();
  });
  it("evaluate throws when time is out of range", function() {
    const crs = new import__16.CatmullRomSpline({
      points,
      times
    });
    expect(function() {
      crs.evaluate(times[0] - 1);
    }).toThrowDeveloperError();
  });
  it("check Catmull-Rom spline against a Hermite spline", function() {
    const crs = new import__16.CatmullRomSpline({
      points,
      times
    });
    const tangents = [crs.firstTangent];
    for (let i = 1; i < points.length - 1; ++i) {
      tangents.push(
        import__16.Cartesian3.multiplyByScalar(
          import__16.Cartesian3.subtract(points[i + 1], points[i - 1], new import__16.Cartesian3()),
          0.5,
          new import__16.Cartesian3()
        )
      );
    }
    tangents.push(crs.lastTangent);
    const hs = import__16.HermiteSpline.createC1({
      points,
      tangents,
      times
    });
    const granularity = 0.5;
    for (let j = times[0]; j <= times[points.length - 1]; j = j + granularity) {
      expect(hs.evaluate(j)).toEqualEpsilon(
        crs.evaluate(j),
        import__16.Math.EPSILON4
      );
    }
  });
  it("evaluate with result parameter", function() {
    const crs = new import__16.CatmullRomSpline({
      points,
      times
    });
    const result = new import__16.Cartesian3();
    const point = crs.evaluate(times[0], result);
    expect(point).toBe(result);
    expect(result).toEqual(points[0]);
  });
  it("spline with 2 control points defaults to lerp", function() {
    points = points.slice(0, 2);
    times = times.slice(0, 2);
    const crs = new import__16.CatmullRomSpline({
      points,
      times
    });
    const t = (times[0] + times[1]) * 0.5;
    expect(crs.evaluate(t)).toEqual(
      import__16.Cartesian3.lerp(points[0], points[1], t, new import__16.Cartesian3())
    );
  });
  it("spline with 2 control points defaults to lerp and result parameter", function() {
    points = points.slice(0, 2);
    times = times.slice(0, 2);
    const crs = new import__16.CatmullRomSpline({
      points,
      times
    });
    const t = (times[0] + times[1]) * 0.5;
    const result = new import__16.Cartesian3();
    const actual = crs.evaluate(t, result);
    expect(actual).toBe(result);
    expect(actual).toEqual(
      import__16.Cartesian3.lerp(points[0], points[1], t, new import__16.Cartesian3())
    );
  });
});

// packages/engine/Specs/Core/CesiumTerrainProviderSpec.js
var import__17 = __toESM(require_Cesium(), 1);
describe("Core/CesiumTerrainProvider", function() {
  beforeEach(function() {
    import__17.RequestScheduler.clearForSpecs();
  });
  afterEach(function() {
    import__17.Resource._Implementations.loadWithXhr = import__17.Resource._DefaultImplementations.loadWithXhr;
  });
  function returnTileJson(path) {
    const oldLoad = import__17.Resource._Implementations.loadWithXhr;
    import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
      if (url.indexOf("layer.json") >= 0) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          path,
          responseType,
          method,
          data,
          headers,
          deferred
        );
      } else {
        return oldLoad(
          url,
          responseType,
          method,
          data,
          headers,
          deferred,
          overrideMimeType
        );
      }
    };
  }
  function returnHeightmapTileJson() {
    return returnTileJson(
      "Data/CesiumTerrainTileJson/StandardHeightmap.tile.json"
    );
  }
  function returnQuantizedMeshTileJson() {
    return returnTileJson("Data/CesiumTerrainTileJson/QuantizedMesh.tile.json");
  }
  function returnVertexNormalTileJson() {
    return returnTileJson("Data/CesiumTerrainTileJson/VertexNormals.tile.json");
  }
  function returnOctVertexNormalTileJson() {
    return returnTileJson(
      "Data/CesiumTerrainTileJson/OctVertexNormals.tile.json"
    );
  }
  function returnWaterMaskTileJson() {
    return returnTileJson("Data/CesiumTerrainTileJson/WaterMask.tile.json");
  }
  function returnPartialAvailabilityTileJson() {
    return returnTileJson(
      "Data/CesiumTerrainTileJson/PartialAvailability.tile.json"
    );
  }
  function returnParentUrlTileJson() {
    const paths = [
      "Data/CesiumTerrainTileJson/ParentUrl.tile.json",
      "Data/CesiumTerrainTileJson/Parent.tile.json"
    ];
    let i = 0;
    const oldLoad = import__17.Resource._Implementations.loadWithXhr;
    import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
      if (url.indexOf("layer.json") >= 0) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          paths[i++],
          responseType,
          method,
          data,
          headers,
          deferred
        );
      } else {
        return oldLoad(
          url,
          responseType,
          method,
          data,
          headers,
          deferred,
          overrideMimeType
        );
      }
    };
  }
  function returnMetadataAvailabilityTileJson() {
    return returnTileJson(
      "Data/CesiumTerrainTileJson/MetadataAvailability.tile.json"
    );
  }
  function returnParentUrlTileJsonWithMetadataAvailability() {
    const paths = [
      "Data/CesiumTerrainTileJson/ParentUrlAvailability.tile.json",
      "Data/CesiumTerrainTileJson/ParentAvailability.tile.json"
    ];
    let i = 0;
    const oldLoad = import__17.Resource._Implementations.loadWithXhr;
    import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
      if (url.indexOf("layer.json") >= 0) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          paths[i++],
          responseType,
          method,
          data,
          headers,
          deferred
        );
      } else {
        return oldLoad(
          url,
          responseType,
          method,
          data,
          headers,
          deferred,
          overrideMimeType
        );
      }
    };
  }
  async function waitForTile(level, x, y, requestNormals, requestWaterMask, f) {
    const terrainProvider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url", {
      requestVertexNormals: requestNormals,
      requestWaterMask
    });
    return terrainProvider.requestTileGeometry(level, x, y);
  }
  function createRequest() {
    return new import__17.Request({
      throttleByServer: true
    });
  }
  it("conforms to TerrainProvider interface", function() {
    expect(import__17.CesiumTerrainProvider).toConformToInterface(import__17.TerrainProvider);
  });
  it("fromIonAssetId throws without assetId", async function() {
    await expectAsync(
      import__17.CesiumTerrainProvider.fromIonAssetId()
    ).toBeRejectedWithDeveloperError(
      "assetId is required, actual value was undefined"
    );
  });
  it("fromUrl throws without url", async function() {
    await expectAsync(
      import__17.CesiumTerrainProvider.fromUrl()
    ).toBeRejectedWithDeveloperError(
      "url is required, actual value was undefined"
    );
  });
  it("fromUrl resolves to created CesiumTerrainProvider", async function() {
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
    expect(provider).toBeInstanceOf(import__17.CesiumTerrainProvider);
  });
  it("fromUrl resolves with url promise", async function() {
    const provider = await import__17.CesiumTerrainProvider.fromUrl(
      Promise.resolve("made/up/url")
    );
    expect(provider).toBeInstanceOf(import__17.CesiumTerrainProvider);
  });
  it("fromUrl resolves with Resource", async function() {
    const resource = new import__17.Resource({
      url: "made/up/url"
    });
    const provider = await import__17.CesiumTerrainProvider.fromUrl(resource);
    expect(provider).toBeInstanceOf(import__17.CesiumTerrainProvider);
  });
  it("fromUrl rejects if url rejects", async function() {
    await expectAsync(
      import__17.CesiumTerrainProvider.fromUrl(Promise.reject(new Error("my message")))
    ).toBeRejectedWithError("my message");
  });
  it("uses geographic tiling scheme by default", async function() {
    returnHeightmapTileJson();
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
    expect(provider.tilingScheme).toBeInstanceOf(import__17.GeographicTilingScheme);
  });
  it("can use a custom ellipsoid", async function() {
    returnHeightmapTileJson();
    const ellipsoid = new import__17.Ellipsoid(1, 2, 3);
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url", {
      ellipsoid
    });
    expect(provider.tilingScheme.ellipsoid).toEqual(ellipsoid);
  });
  it("has error event", async function() {
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
    expect(provider.errorEvent).toBeDefined();
    expect(provider.errorEvent).toBe(provider.errorEvent);
  });
  it("returns reasonable geometric error for various levels", async function() {
    returnQuantizedMeshTileJson();
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
    expect(provider.getLevelMaximumGeometricError(0)).toBeGreaterThan(0);
    expect(provider.getLevelMaximumGeometricError(0)).toEqualEpsilon(
      provider.getLevelMaximumGeometricError(1) * 2,
      import__17.Math.EPSILON10
    );
    expect(provider.getLevelMaximumGeometricError(1)).toEqualEpsilon(
      provider.getLevelMaximumGeometricError(2) * 2,
      import__17.Math.EPSILON10
    );
  });
  it("credit is undefined if credit option is not provided", async function() {
    returnHeightmapTileJson();
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
    expect(provider.credit).toBeUndefined();
  });
  it("credit is defined if credit option is provided", async function() {
    returnHeightmapTileJson();
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url", {
      credit: "thanks to our awesome made up contributors!"
    });
    expect(provider.credit).toBeDefined();
  });
  it("has a water mask", async function() {
    returnHeightmapTileJson();
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
    expect(provider.hasWaterMask).toBe(true);
  });
  it("has vertex normals", async function() {
    returnOctVertexNormalTileJson();
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url", {
      requestVertexNormals: true
    });
    expect(provider.requestVertexNormals).toBe(true);
    expect(provider.hasVertexNormals).toBe(true);
  });
  it("does not request vertex normals", async function() {
    returnOctVertexNormalTileJson();
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url", {
      requestVertexNormals: false
    });
    expect(provider.requestVertexNormals).toBe(false);
    expect(provider.hasVertexNormals).toBe(false);
  });
  it("requests parent layer.json", async function() {
    returnParentUrlTileJson();
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url", {
      requestVertexNormals: true,
      requestWaterMask: true
    });
    expect(provider._tileCredits[0].html).toBe(
      "This is a child tileset! This amazing data is courtesy The Amazing Data Source!"
    );
    expect(provider.requestVertexNormals).toBe(true);
    expect(provider.requestWaterMask).toBe(true);
    expect(provider.hasVertexNormals).toBe(false);
    expect(provider.hasWaterMask).toBe(true);
    expect(provider.availability.isTileAvailable(1, 2, 1)).toBe(true);
    expect(provider.availability.isTileAvailable(1, 3, 1)).toBe(true);
    expect(provider.availability.isTileAvailable(2, 0, 0)).toBe(false);
    const layers = provider._layers;
    expect(layers.length).toBe(2);
    expect(layers[0].hasVertexNormals).toBe(false);
    expect(layers[0].hasWaterMask).toBe(true);
    expect(layers[0].availability.isTileAvailable(1, 2, 1)).toBe(true);
    expect(layers[0].availability.isTileAvailable(1, 3, 1)).toBe(false);
    expect(layers[0].availability.isTileAvailable(2, 0, 0)).toBe(false);
    expect(layers[1].hasVertexNormals).toBe(false);
    expect(layers[1].hasWaterMask).toBe(false);
    expect(layers[1].availability.isTileAvailable(1, 2, 1)).toBe(true);
    expect(layers[1].availability.isTileAvailable(1, 3, 1)).toBe(true);
    expect(layers[1].availability.isTileAvailable(2, 0, 0)).toBe(false);
  });
  it("fromUrl throws if layer.json specifies an unknown format", async function() {
    returnTileJson("Data/CesiumTerrainTileJson/InvalidFormat.tile.json");
    await expectAsync(
      import__17.CesiumTerrainProvider.fromUrl("made/up/url")
    ).toBeRejectedWithError(
      import__17.RuntimeError,
      'The tile format "awesometron-9000.0" is invalid or not supported.'
    );
  });
  it("fromUrl throws if layer.json does not specify quantized-mesh 1.x format", async function() {
    returnTileJson("Data/CesiumTerrainTileJson/QuantizedMesh2.0.tile.json");
    await expectAsync(
      import__17.CesiumTerrainProvider.fromUrl("made/up/url")
    ).toBeRejectedWithError(
      import__17.RuntimeError,
      'The tile format "quantized-mesh-2.0" is invalid or not supported.'
    );
  });
  it("fromUrl supports quantized-mesh1.x minor versions", async function() {
    returnTileJson("Data/CesiumTerrainTileJson/QuantizedMesh1.1.tile.json");
    await expectAsync(
      import__17.CesiumTerrainProvider.fromUrl("made/up/url")
    ).toBeResolved();
  });
  it("fromUrl throws if layer.json does not specify a tiles property", async function() {
    returnTileJson("Data/CesiumTerrainTileJson/NoTiles.tile.json");
    await expectAsync(
      import__17.CesiumTerrainProvider.fromUrl("made/up/url")
    ).toBeRejectedWithError(
      import__17.RuntimeError,
      "The layer.json file does not specify any tile URL templates."
    );
  });
  it("fromUrl throws if layer.json tiles property is an empty array", async function() {
    returnTileJson("Data/CesiumTerrainTileJson/EmptyTilesArray.tile.json");
    await expectAsync(
      import__17.CesiumTerrainProvider.fromUrl("made/up/url")
    ).toBeRejectedWithError(
      import__17.RuntimeError,
      "The layer.json file does not specify any tile URL templates."
    );
  });
  it("fromUrl uses attribution specified in layer.json", async function() {
    returnTileJson("Data/CesiumTerrainTileJson/WithAttribution.tile.json");
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
    expect(provider._tileCredits[0].html).toBe(
      "This amazing data is courtesy The Amazing Data Source!"
    );
  });
  it("formUrl does not add blank attribution if layer.json does not have one", async function() {
    returnTileJson("Data/CesiumTerrainTileJson/WaterMask.tile.json");
    const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
    expect(provider._tileCredit).toBeUndefined();
  });
  it("The undefined availability tile is returned at level 0", function() {
    const layer = {
      availabilityLevels: 10
    };
    expect(
      import__17.CesiumTerrainProvider._getAvailabilityTile(layer, 0, 0, 0)
    ).toBeUndefined();
    expect(
      import__17.CesiumTerrainProvider._getAvailabilityTile(layer, 1, 0, 0)
    ).toBeUndefined();
  });
  it("The correct availability tile is computed in first level", function() {
    const layer = {
      availabilityLevels: 10
    };
    expect(import__17.CesiumTerrainProvider._getAvailabilityTile(layer, 1, 1, 1)).toEqual({
      level: 0,
      x: 0,
      y: 0
    });
    expect(import__17.CesiumTerrainProvider._getAvailabilityTile(layer, 4, 2, 2)).toEqual({
      level: 0,
      x: 1,
      y: 0
    });
    expect(
      import__17.CesiumTerrainProvider._getAvailabilityTile(layer, 80, 50, 10)
    ).toEqual({
      level: 0,
      x: 0,
      y: 0
    });
  });
  it("The correct availability tile is computed in second level", function() {
    const layer = {
      availabilityLevels: 10
    };
    const expected = {
      level: 10,
      x: 80,
      y: 50
    };
    const xs = [expected.x, expected.x];
    const ys = [expected.y, expected.y];
    for (let i = 0; i < 10; ++i) {
      xs[0] *= 2;
      ys[0] *= 2;
      xs[1] = xs[1] * 2 + 1;
      ys[1] = ys[1] * 2 + 1;
    }
    expect(
      import__17.CesiumTerrainProvider._getAvailabilityTile(layer, xs[0], ys[0], 20)
    ).toEqual(expected);
    expect(
      import__17.CesiumTerrainProvider._getAvailabilityTile(layer, xs[1], ys[1], 20)
    ).toEqual(expected);
  });
  describe("requestTileGeometry", function() {
    it("uses multiple urls specified in layer.json", async function() {
      returnTileJson("Data/CesiumTerrainTileJson/MultipleUrls.tile.json");
      const provider = await import__17.CesiumTerrainProvider.fromUrl("made/up/url");
      spyOn(import__17.Resource._Implementations, "loadWithXhr").and.callThrough();
      try {
        await provider.requestTileGeometry(0, 0, 0);
      } catch (e) {
        expect(
          import__17.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo0.com");
      }
      try {
        await provider.requestTileGeometry(1, 0, 0);
      } catch (e) {
        expect(
          import__17.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo1.com");
      }
      try {
        await provider.requestTileGeometry(1, -1, 0);
      } catch (e) {
        expect(
          import__17.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo2.com");
      }
      try {
        await provider.requestTileGeometry(1, 0, 1);
      } catch (e) {
        expect(
          import__17.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo3.com");
      }
    });
    it("supports scheme-less template URLs in layer.json resolved with absolute URL", async function() {
      returnTileJson("Data/CesiumTerrainTileJson/MultipleUrls.tile.json");
      const url = (0, import__17.getAbsoluteUri)("Data/CesiumTerrainTileJson");
      const provider = await import__17.CesiumTerrainProvider.fromUrl(url);
      spyOn(import__17.Resource._Implementations, "loadWithXhr").and.callThrough();
      try {
        await provider.requestTileGeometry(0, 0, 0);
      } catch (e) {
        expect(
          import__17.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo0.com");
      }
      try {
        await provider.requestTileGeometry(1, 0, 0);
      } catch (e) {
        expect(
          import__17.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo1.com");
      }
      try {
        await provider.requestTileGeometry(1, -1, 0);
      } catch (e) {
        expect(
          import__17.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo2.com");
      }
      try {
        await provider.requestTileGeometry(1, 0, 1);
      } catch (e) {
        expect(
          import__17.Resource._Implementations.loadWithXhr.calls.mostRecent().args[0]
        ).toContain("foo3.com");
      }
    });
    it("provides HeightmapTerrainData", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        return import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/EarthOrientationParameters/IcrfToFixedStkComponentsRotationData.json",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnHeightmapTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.HeightmapTerrainData);
      });
    });
    it("provides QuantizedMeshTerrainData", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnQuantizedMeshTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
      });
    });
    it("provides QuantizedMeshTerrainData with 32bit indices", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.32bitIndices.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnQuantizedMeshTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
        expect(loadedData._indices.BYTES_PER_ELEMENT).toBe(4);
      });
    });
    it("provides QuantizedMeshTerrainData with VertexNormals", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.vertexnormals.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnVertexNormalTileJson();
      return waitForTile(0, 0, 0, true, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with WaterMask", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.watermask.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnWaterMaskTileJson();
      return waitForTile(0, 0, 0, false, true, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
        expect(loadedData._waterMask).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with VertexNormals and WaterMask", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.octvertexnormals.watermask.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnWaterMaskTileJson();
      return waitForTile(0, 0, 0, true, true, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
        expect(loadedData._waterMask).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with OctVertexNormals", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.octvertexnormals.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnOctVertexNormalTileJson();
      return waitForTile(0, 0, 0, true, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with VertexNormals and unknown extensions", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.vertexnormals.unknownext.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnVertexNormalTileJson();
      return waitForTile(0, 0, 0, true, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with OctVertexNormals and unknown extensions", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.octvertexnormals.unknownext.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnOctVertexNormalTileJson();
      return waitForTile(0, 0, 0, true, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
        expect(loadedData._encodedNormals).toBeDefined();
      });
    });
    it("provides QuantizedMeshTerrainData with unknown extension", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.unknownext.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnOctVertexNormalTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
      });
    });
    it("provides QuantizedMeshTerrainData with Metadata availability", async function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.metadataavailability.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnMetadataAvailabilityTileJson();
      const terrainProvider = await import__17.CesiumTerrainProvider.fromUrl(
        "made/up/url"
      );
      expect(terrainProvider.hasMetadata).toBe(true);
      expect(terrainProvider._layers[0].availabilityLevels).toBe(10);
      expect(terrainProvider.availability.isTileAvailable(0, 0, 0)).toBe(true);
      expect(terrainProvider.availability.isTileAvailable(0, 1, 0)).toBe(true);
      expect(terrainProvider.availability.isTileAvailable(1, 0, 0)).toBe(false);
      const loadedData = await terrainProvider.requestTileGeometry(0, 0, 0);
      expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
      expect(terrainProvider.availability.isTileAvailable(1, 0, 0)).toBe(true);
    });
    it("provides QuantizedMeshTerrainData with multiple layers and with Metadata availability ", async function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.metadataavailability.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnParentUrlTileJsonWithMetadataAvailability();
      const terrainProvider = await import__17.CesiumTerrainProvider.fromUrl(
        "made/up/url"
      );
      expect(terrainProvider.hasMetadata).toBe(true);
      const layers = terrainProvider._layers;
      expect(layers.length).toBe(2);
      expect(terrainProvider.availability.isTileAvailable(1, 0, 0)).toBe(false);
      const loadedData = await terrainProvider.requestTileGeometry(0, 0, 1);
      expect(loadedData).toBeInstanceOf(import__17.QuantizedMeshTerrainData);
      expect(terrainProvider.availability.isTileAvailable(1, 0, 0)).toBe(true);
    });
    it("returns undefined if too many requests are already in progress", async function() {
      const baseUrl = "made/up/url";
      const deferreds = [];
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        deferreds.push(deferred);
      };
      returnHeightmapTileJson();
      const terrainProvider = await import__17.CesiumTerrainProvider.fromUrl(baseUrl);
      let promise;
      let i;
      for (i = 0; i < import__17.RequestScheduler.maximumRequestsPerServer; ++i) {
        const request = new import__17.Request({
          throttle: true,
          throttleByServer: true
        });
        promise = terrainProvider.requestTileGeometry(0, 0, 0, request).then(fail).catch((e) => {
          expect(e.message).toContain("Mesh buffer doesn't exist.");
        });
      }
      import__17.RequestScheduler.update();
      expect(promise).toBeDefined();
      promise = terrainProvider.requestTileGeometry(0, 0, 0, createRequest());
      expect(promise).toBeUndefined();
      for (i = 0; i < deferreds.length; ++i) {
        deferreds[i].resolve();
      }
    });
    it("supports getTileDataAvailable()", async function() {
      const baseUrl = "made/up/url";
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnQuantizedMeshTileJson();
      const terrainProvider = await import__17.CesiumTerrainProvider.fromUrl(baseUrl);
      expect(terrainProvider.getTileDataAvailable(0, 0, 0)).toBe(true);
      expect(terrainProvider.getTileDataAvailable(0, 0, 2)).toBe(false);
    });
    it("getTileDataAvailable() converts xyz to tms", async function() {
      const baseUrl = "made/up/url";
      returnPartialAvailabilityTileJson();
      const terrainProvider = await import__17.CesiumTerrainProvider.fromUrl(baseUrl);
      expect(terrainProvider.getTileDataAvailable(1, 3, 2)).toBe(true);
      expect(terrainProvider.getTileDataAvailable(1, 0, 2)).toBe(false);
    });
    it("getTileDataAvailable() with Metadata availability", async function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/CesiumTerrainTileJson/tile.metadataavailability.terrain",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnMetadataAvailabilityTileJson();
      const terrainProvider = await import__17.CesiumTerrainProvider.fromUrl(
        "made/up/url"
      );
      expect(terrainProvider.getTileDataAvailable(0, 0, 0)).toBe(true);
      expect(terrainProvider.getTileDataAvailable(0, 0, 1)).toBeUndefined();
      await terrainProvider.requestTileGeometry(0, 0, 0);
      expect(terrainProvider.getTileDataAvailable(0, 0, 1)).toBe(true);
    });
    it("supports a query string in the base URL", function() {
      import__17.Resource._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
        import__17.Resource._DefaultImplementations.loadWithXhr(
          "Data/EarthOrientationParameters/IcrfToFixedStkComponentsRotationData.json",
          responseType,
          method,
          data,
          headers,
          deferred
        );
      };
      returnHeightmapTileJson();
      return waitForTile(0, 0, 0, false, false, function(loadedData) {
        expect(loadedData).toBeInstanceOf(import__17.HeightmapTerrainData);
      });
    });
    it("Uses query parameter extensions for ion resource", async function() {
      const terrainProvider = await import__17.CesiumTerrainProvider.fromUrl(
        import__17.IonResource.fromAssetId(1),
        {
          requestVertexNormals: true,
          requestWaterMask: true
        }
      );
      const getDerivedResource = spyOn(
        import__17.IonResource.prototype,
        "getDerivedResource"
      ).and.callThrough();
      await terrainProvider.requestTileGeometry(0, 0, 0);
      const options = getDerivedResource.calls.argsFor(0)[0];
      expect(options.queryParameters.extensions).toEqual(
        "octvertexnormals-watermask-metadata"
      );
    });
  });
});

// packages/engine/Specs/Core/CheckSpec.js
var import__18 = __toESM(require_Cesium(), 1);
describe("Core/Check", function() {
  describe("type checks", function() {
    it("Check.typeOf.bool does not throw when passed a boolean", function() {
      expect(function() {
        import__18.Check.typeOf.bool("bool", true);
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.bool throws when passed a non-boolean", function() {
      expect(function() {
        import__18.Check.typeOf.bool("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bool("mockName", []);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bool("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bool("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bool("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.bigint does not throw when passed a bigint", function() {
      if (!import__18.FeatureDetection.supportsBigInt()) {
        return;
      }
      expect(function() {
        import__18.Check.typeOf.bigint("bigint", BigInt());
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.bigint throws when passed a non-bigint", function() {
      if (!import__18.FeatureDetection.supportsBigInt()) {
        return;
      }
      expect(function() {
        import__18.Check.typeOf.bigint("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bigint("mockName", []);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bigint("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bigint("mockName", true);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bigint("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.bigint("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.func does not throw when passed a function", function() {
      expect(function() {
        import__18.Check.typeOf.func("mockName", function() {
          return true;
        });
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.func throws when passed a non-function", function() {
      expect(function() {
        import__18.Check.typeOf.func("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.func("mockName", [2]);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.func("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.func("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.func("mockName", true);
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.object does not throw when passed object", function() {
      expect(function() {
        import__18.Check.typeOf.object("mockName", {});
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.object throws when passed non-object", function() {
      expect(function() {
        import__18.Check.typeOf.object("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.object("mockName", true);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.object("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.object("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.number does not throw when passed number", function() {
      expect(function() {
        import__18.Check.typeOf.number("mockName", 2);
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.number throws when passed non-number", function() {
      expect(function() {
        import__18.Check.typeOf.number("mockName", "snth");
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.number("mockName", true);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.number("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.number("mockName", [2]);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.number("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
    it("Check.typeOf.string does not throw when passed a string", function() {
      expect(function() {
        import__18.Check.typeOf.string("mockName", "s");
      }).not.toThrowDeveloperError();
    });
    it("Check.typeOf.string throws on non-string", function() {
      expect(function() {
        import__18.Check.typeOf.string("mockName", {});
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.string("mockName", true);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.string("mockName", 1);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.string("mockName", [2]);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.string("mockName", function() {
          return true;
        });
      }).toThrowDeveloperError();
    });
  });
  describe("Check.defined", function() {
    it("does not throw unless passed value that is undefined or null", function() {
      expect(function() {
        import__18.Check.defined("mockName", {});
      }).not.toThrowDeveloperError();
      expect(function() {
        import__18.Check.defined("mockName", []);
      }).not.toThrowDeveloperError();
      expect(function() {
        import__18.Check.defined("mockName", 2);
      }).not.toThrowDeveloperError();
      expect(function() {
        import__18.Check.defined("mockName", function() {
          return true;
        });
      }).not.toThrowDeveloperError();
      expect(function() {
        import__18.Check.defined("mockName", "snt");
      }).not.toThrowDeveloperError();
    });
    it("throws when passed undefined", function() {
      expect(function() {
        import__18.Check.defined("mockName", void 0);
      }).toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.lessThan", function() {
    it("throws if test is equal to limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.lessThan("mockName", 3, 3);
      }).toThrowDeveloperError();
    });
    it("throws if test is greater than limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.lessThan("mockName", 4, 3);
      }).toThrowDeveloperError();
    });
    it("does not throw if test is less than limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.lessThan("mockName", 2, 3);
      }).not.toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.lessThanOrEquals", function() {
    it("throws if test is greater than limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.lessThanOrEquals("mockName", 4, 3);
      }).toThrowDeveloperError();
    });
    it("does not throw if test is equal to limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.lessThanOrEquals("mockName", 3, 3);
      }).not.toThrowDeveloperError();
    });
    it("does not throw if test is less than limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.lessThanOrEquals("mockName", 2, 3);
      }).not.toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.equals", function() {
    it("throws if either value is not a number", function() {
      expect(function() {
        import__18.Check.typeOf.number.equals("mockName1", "mockname2", "a", 3);
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.number.equals("mockName1", "mockname2", 3, "a");
      }).toThrowDeveloperError();
      expect(function() {
        import__18.Check.typeOf.number.equals("mockName1", "mockname2", "b", "a");
      }).toThrowDeveloperError();
    });
    it("throws if both the values are a number but not equal", function() {
      expect(function() {
        import__18.Check.typeOf.number.equals("mockName1", "mockName2", 1, 4);
      }).toThrowDeveloperError();
    });
    it("does not throw if both values are a number and are equal", function() {
      expect(function() {
        import__18.Check.typeOf.number.equal("mockName1", "mockName2", 3, 3);
      }).not.toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.greaterThan", function() {
    it("throws if test is equal to limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.greaterThan("mockName", 3, 3);
      }).toThrowDeveloperError();
    });
    it("throws if test is less than limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.greaterThan("mockName", 2, 3);
      }).toThrowDeveloperError();
    });
    it("does not throw if test is greater than limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.greaterThan("mockName", 4, 3);
      }).not.toThrowDeveloperError();
    });
  });
  describe("Check.typeOf.number.greaterThanOrEquals", function() {
    it("throws if test is less than limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.greaterThanOrEquals("mockName", 2, 3);
      }).toThrowDeveloperError();
    });
    it("does not throw if test is equal to limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.greaterThanOrEquals("mockName", 3, 3);
      }).not.toThrowDeveloperError();
    });
    it("does not throw if test is greater than limit", function() {
      expect(function() {
        import__18.Check.typeOf.number.greaterThanOrEquals("mockName", 4, 3);
      }).not.toThrowDeveloperError();
    });
  });
});

// packages/engine/Specs/Core/CircleGeometrySpec.js
var import__19 = __toESM(require_Cesium(), 1);
describe("Core/CircleGeometry", function() {
  it("throws without a center", function() {
    expect(function() {
      return new import__19.CircleGeometry({
        radius: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws without a radius", function() {
    expect(function() {
      return new import__19.CircleGeometry({
        center: import__19.Cartesian3.fromDegrees(0, 0)
      });
    }).toThrowDeveloperError();
  });
  it("throws with a negative granularity", function() {
    expect(function() {
      return new import__19.CircleGeometry({
        center: import__19.Cartesian3.fromDegrees(0, 0),
        radius: 1,
        granularity: -1
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__19.CircleGeometry.createGeometry(
      new import__19.CircleGeometry({
        vertexFormat: import__19.VertexFormat.POSITION_ONLY,
        ellipsoid: import__19.Ellipsoid.WGS84,
        center: import__19.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1
      })
    );
    const numVertices = 16;
    const numTriangles = 22;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("compute all vertex attributes", function() {
    const m = import__19.CircleGeometry.createGeometry(
      new import__19.CircleGeometry({
        vertexFormat: import__19.VertexFormat.ALL,
        ellipsoid: import__19.Ellipsoid.WGS84,
        center: import__19.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1
      })
    );
    const numVertices = 16;
    const numTriangles = 22;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes positions extruded", function() {
    const m = import__19.CircleGeometry.createGeometry(
      new import__19.CircleGeometry({
        vertexFormat: import__19.VertexFormat.POSITION_ONLY,
        ellipsoid: import__19.Ellipsoid.WGS84,
        center: import__19.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        extrudedHeight: 1e4
      })
    );
    const numVertices = 48;
    const numTriangles = 60;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("compute all vertex attributes extruded", function() {
    const m = import__19.CircleGeometry.createGeometry(
      new import__19.CircleGeometry({
        vertexFormat: import__19.VertexFormat.ALL,
        ellipsoid: import__19.Ellipsoid.WGS84,
        center: import__19.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        extrudedHeight: 1e4
      })
    );
    const numVertices = 48;
    const numTriangles = 60;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("compute texture coordinates with rotation", function() {
    const m = import__19.CircleGeometry.createGeometry(
      new import__19.CircleGeometry({
        vertexFormat: import__19.VertexFormat.POSITION_AND_ST,
        ellipsoid: import__19.Ellipsoid.WGS84,
        center: import__19.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        stRotation: import__19.Math.PI_OVER_TWO
      })
    );
    const positions = m.attributes.position.values;
    const st = m.attributes.st.values;
    const length2 = st.length;
    expect(positions.length).toEqual(3 * 16);
    expect(length2).toEqual(2 * 16);
    expect(m.indices.length).toEqual(3 * 22);
    expect(st[length2 - 2]).toEqualEpsilon(0.5, import__19.Math.EPSILON2);
    expect(st[length2 - 1]).toEqualEpsilon(0, import__19.Math.EPSILON2);
  });
  it("undefined is returned if radius is equal to or less than zero", function() {
    const circle0 = new import__19.CircleGeometry({
      center: import__19.Cartesian3.fromDegrees(-75.59777, 40.03883),
      radius: 0
    });
    const circle1 = new import__19.CircleGeometry({
      center: import__19.Cartesian3.fromDegrees(-75.59777, 40.03883),
      radius: -10
    });
    const geometry0 = import__19.CircleGeometry.createGeometry(circle0);
    const geometry1 = import__19.CircleGeometry.createGeometry(circle1);
    expect(geometry0).toBeUndefined();
    expect(geometry1).toBeUndefined();
  });
  it("computing rectangle property", function() {
    const center2 = import__19.Cartesian3.fromDegrees(-75.59777, 40.03883);
    const ellipse = new import__19.CircleGeometry({
      center: center2,
      radius: 1e3
    });
    const r = ellipse.rectangle;
    expect(r.north).toEqualEpsilon(0.698966597893341, import__19.Math.EPSILON15);
    expect(r.south).toEqualEpsilon(0.698652226072367, import__19.Math.EPSILON15);
    expect(r.east).toEqualEpsilon(-1.3192254919753026, import__19.Math.EPSILON15);
    expect(r.west).toEqualEpsilon(-1.3196344953554853, import__19.Math.EPSILON15);
  });
  it("computing textureCoordinateRotationPoints property", function() {
    const center2 = import__19.Cartesian3.fromDegrees(0, 0);
    const ellipse = new import__19.CircleGeometry({
      center: center2,
      radius: 1e3,
      stRotation: import__19.Math.toRadians(90)
    });
    const textureCoordinateRotationPoints = ellipse.textureCoordinateRotationPoints;
    expect(textureCoordinateRotationPoints.length).toEqual(6);
    expect(textureCoordinateRotationPoints[0]).toEqualEpsilon(
      0,
      import__19.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[1]).toEqualEpsilon(
      1,
      import__19.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[2]).toEqualEpsilon(
      1,
      import__19.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[3]).toEqualEpsilon(
      1,
      import__19.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[4]).toEqualEpsilon(
      0,
      import__19.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[5]).toEqualEpsilon(
      0,
      import__19.Math.EPSILON7
    );
  });
  const center = import__19.Cartesian3.fromDegrees(0, 0);
  const ellipsoid = import__19.Ellipsoid.WGS84;
  const packableInstance = new import__19.CircleGeometry({
    vertexFormat: import__19.VertexFormat.POSITION_AND_ST,
    ellipsoid,
    center,
    granularity: 0.1,
    radius: 1,
    stRotation: import__19.Math.PI_OVER_TWO
  });
  const packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    import__19.Math.PI_OVER_TWO,
    0,
    0.1,
    0,
    0,
    -1
  ];
  createPackableSpecs_default(import__19.CircleGeometry, packableInstance, packedInstance);
});

// packages/engine/Specs/Core/CircleOutlineGeometrySpec.js
var import__20 = __toESM(require_Cesium(), 1);
describe("Core/CircleOutlineGeometry", function() {
  it("throws without a center", function() {
    expect(function() {
      return new import__20.CircleOutlineGeometry({
        radius: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws without a radius", function() {
    expect(function() {
      return new import__20.CircleOutlineGeometry({
        center: import__20.Cartesian3.fromDegrees(0, 0)
      });
    }).toThrowDeveloperError();
  });
  it("throws with a negative granularity", function() {
    expect(function() {
      return new import__20.CircleOutlineGeometry({
        center: import__20.Cartesian3.fromDegrees(0, 0),
        radius: 1,
        granularity: -1
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__20.CircleOutlineGeometry.createGeometry(
      new import__20.CircleOutlineGeometry({
        ellipsoid: import__20.Ellipsoid.WGS84,
        center: import__20.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(8 * 2);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes positions extruded", function() {
    const m = import__20.CircleOutlineGeometry.createGeometry(
      new import__20.CircleOutlineGeometry({
        ellipsoid: import__20.Ellipsoid.WGS84,
        center: import__20.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        extrudedHeight: 5
      })
    );
    expect(m.attributes.position.values.length).toEqual(16 * 3);
    expect(m.indices.length).toEqual(24 * 2);
  });
  it("computes positions extruded, no lines between top and bottom", function() {
    const m = import__20.CircleOutlineGeometry.createGeometry(
      new import__20.CircleOutlineGeometry({
        ellipsoid: import__20.Ellipsoid.WGS84,
        center: import__20.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        radius: 1,
        extrudedHeight: 1e4,
        numberOfVerticalLines: 0
      })
    );
    expect(m.attributes.position.values.length).toEqual(16 * 3);
    expect(m.indices.length).toEqual(16 * 2);
  });
  it("undefined is returned if radius is equal to or less than zero", function() {
    const circleOutline0 = new import__20.CircleOutlineGeometry({
      center: import__20.Cartesian3.fromDegrees(-75.59777, 40.03883),
      radius: 0
    });
    const circleOutline1 = new import__20.CircleOutlineGeometry({
      center: import__20.Cartesian3.fromDegrees(-75.59777, 40.03883),
      radius: -10
    });
    const geometry0 = import__20.CircleOutlineGeometry.createGeometry(circleOutline0);
    const geometry1 = import__20.CircleOutlineGeometry.createGeometry(circleOutline1);
    expect(geometry0).toBeUndefined();
    expect(geometry1).toBeUndefined();
  });
  const center = new import__20.Cartesian3(8, 9, 10);
  const ellipsoid = new import__20.Ellipsoid(11, 12, 13);
  let packableInstance = new import__20.CircleOutlineGeometry({
    ellipsoid,
    center,
    granularity: 1,
    radius: 2,
    numberOfVerticalLines: 4,
    height: 5,
    extrudedHeight: 7
  });
  let packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    2,
    2,
    0,
    7,
    1,
    5,
    4,
    -1
  ];
  createPackableSpecs_default(
    import__20.CircleOutlineGeometry,
    packableInstance,
    packedInstance,
    "extruded"
  );
  packableInstance = new import__20.CircleOutlineGeometry({
    ellipsoid,
    center,
    granularity: 1,
    radius: 2,
    numberOfVerticalLines: 4,
    height: 5
  });
  packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    2,
    2,
    0,
    5,
    1,
    5,
    4,
    -1
  ];
  createPackableSpecs_default(
    import__20.CircleOutlineGeometry,
    packableInstance,
    packedInstance,
    "at height"
  );
});

// packages/engine/Specs/Core/ClockSpec.js
var import__21 = __toESM(require_Cesium(), 1);
describe("Core/Clock", function() {
  it("sets default parameters when constructed", function() {
    const clock = new import__21.Clock();
    expect(clock.stopTime).toEqual(
      import__21.JulianDate.addDays(clock.startTime, 1, new import__21.JulianDate())
    );
    expect(clock.startTime).toEqual(clock.currentTime);
    expect(clock.multiplier).toEqual(1);
    expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK_MULTIPLIER);
    expect(clock.clockRange).toEqual(import__21.ClockRange.UNBOUNDED);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("sets provided constructor parameters correctly", function() {
    const start = new import__21.JulianDate(12);
    const stop = new import__21.JulianDate(112);
    const currentTime = new import__21.JulianDate(13);
    const step = import__21.ClockStep.TICK_DEPENDENT;
    const range = import__21.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    let clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    expect(clock.startTime).toEqual(start);
    expect(clock.startTime).not.toBe(start);
    expect(clock.stopTime).toEqual(stop);
    expect(clock.stopTime).not.toBe(stop);
    expect(clock.currentTime).toEqual(currentTime);
    expect(clock.currentTime).not.toBe(currentTime);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
    clock = new import__21.Clock({
      canAnimate: false
    });
    expect(clock.canAnimate).toEqual(false);
    clock = new import__21.Clock({
      shouldAnimate: true
    });
    expect(clock.shouldAnimate).toEqual(true);
  });
  it("works when constructed with no currentTime parameter", function() {
    const start = new import__21.JulianDate(12);
    const stop = new import__21.JulianDate(112);
    const step = import__21.ClockStep.TICK_DEPENDENT;
    const range = import__21.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    expect(clock.startTime).toEqual(start);
    expect(clock.stopTime).toEqual(stop);
    expect(clock.currentTime).toEqual(start);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no startTime parameter", function() {
    const stop = new import__21.JulianDate(112);
    const currentTime = new import__21.JulianDate(13);
    const step = import__21.ClockStep.TICK_DEPENDENT;
    const range = import__21.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      stopTime: stop,
      currentTime,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    expect(clock.startTime).toEqual(currentTime);
    expect(clock.stopTime).toEqual(stop);
    expect(clock.currentTime).toEqual(currentTime);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no startTime or stopTime", function() {
    const currentTime = new import__21.JulianDate(12);
    const step = import__21.ClockStep.TICK_DEPENDENT;
    const range = import__21.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      currentTime,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    const expectedStop = import__21.JulianDate.addDays(currentTime, 1, new import__21.JulianDate());
    expect(clock.startTime).toEqual(currentTime);
    expect(clock.stopTime).toEqual(expectedStop);
    expect(clock.currentTime).toEqual(currentTime);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no startTime or currentTime", function() {
    const stop = new import__21.JulianDate(13);
    const step = import__21.ClockStep.TICK_DEPENDENT;
    const range = import__21.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      stopTime: stop,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    const expectedStart = import__21.JulianDate.addDays(stop, -1, new import__21.JulianDate());
    expect(clock.startTime).toEqual(expectedStart);
    expect(clock.stopTime).toEqual(stop);
    expect(clock.currentTime).toEqual(expectedStart);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no currentTime or stopTime", function() {
    const start = new import__21.JulianDate(12);
    const step = import__21.ClockStep.TICK_DEPENDENT;
    const range = import__21.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      startTime: start,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    const expectedStop = import__21.JulianDate.addDays(start, 1, new import__21.JulianDate());
    expect(clock.startTime).toEqual(start);
    expect(clock.stopTime).toEqual(expectedStop);
    expect(clock.currentTime).toEqual(start);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("works when constructed with no stopTime parameter", function() {
    const start = new import__21.JulianDate(12);
    const currentTime = new import__21.JulianDate(12);
    const step = import__21.ClockStep.TICK_DEPENDENT;
    const range = import__21.ClockRange.LOOP_STOP;
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      startTime: start,
      currentTime,
      clockStep: step,
      multiplier,
      clockRange: range
    });
    const expectedStop = import__21.JulianDate.addDays(start, 1, new import__21.JulianDate());
    expect(clock.startTime).toEqual(start);
    expect(clock.stopTime).toEqual(expectedStop);
    expect(clock.currentTime).toEqual(currentTime);
    expect(clock.clockStep).toEqual(step);
    expect(clock.clockRange).toEqual(range);
    expect(clock.multiplier).toEqual(multiplier);
    expect(clock.canAnimate).toEqual(true);
    expect(clock.shouldAnimate).toEqual(false);
  });
  it("throws when constructed if start time is after stop time", function() {
    const start = new import__21.JulianDate(1);
    const stop = new import__21.JulianDate(0);
    expect(function() {
      return new import__21.Clock({
        startTime: start,
        stopTime: stop
      });
    }).toThrowDeveloperError();
  });
  it("animates forward in TICK_DEPENDENT mode", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    let currentTime = new import__21.JulianDate(0.5);
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.LOOP_STOP,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
  });
  it("animates backwards in TICK_DEPENDENT mode", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    let currentTime = new import__21.JulianDate(0.5);
    const multiplier = -1.5;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.LOOP_STOP,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
  });
  it("animates forwards past stop time in UNBOUNDED TICK_DEPENDENT mode", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    let currentTime = stop;
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.UNBOUNDED,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
  });
  it("animates backwards past start time in UNBOUNDED TICK_DEPENDENT mode", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    let currentTime = start;
    const multiplier = -1.5;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.UNBOUNDED,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
  });
  it("loops back to start time when animating forward past stop time in LOOP_STOP TICK_DEPENDENT mode", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    let currentTime = stop;
    const multiplier = 1.5;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.LOOP_STOP,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(start, multiplier, new import__21.JulianDate());
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
    currentTime = import__21.JulianDate.addSeconds(
      currentTime,
      multiplier,
      new import__21.JulianDate()
    );
    expect(currentTime).toEqual(clock.tick());
    expect(clock.currentTime).toEqual(currentTime);
  });
  it("stops at start when animating backwards past start time in LOOP_STOP TICK_DEPENDENT mode", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    const currentTime = start;
    const multiplier = -100;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.LOOP_STOP,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    expect(start).toEqual(clock.tick());
    expect(start).toEqual(clock.currentTime);
  });
  it("stops at stop time when animating forwards past stop time in CLAMPED TICK_DEPENDENT mode", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    const currentTime = stop;
    const multiplier = 100;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.CLAMPED,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    expect(stop).toEqual(clock.tick());
    expect(stop).toEqual(clock.currentTime);
  });
  it("stops at start time when animating backwards past start time in CLAMPED TICK_DEPENDENT mode", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    const currentTime = start;
    const multiplier = -100;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.CLAMPED,
      shouldAnimate: true
    });
    expect(clock.currentTime).toEqual(currentTime);
    expect(start).toEqual(clock.tick());
    expect(start).toEqual(clock.currentTime);
  });
  it("fires onEnd event when endTime is reached and clock range is CLAMPED", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    const currentTime = stop;
    const multiplier = 100;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.CLAMPED,
      shouldAnimate: true
    });
    const onStopSpy = jasmine.createSpy("event");
    clock.onStop.addEventListener(onStopSpy);
    clock.tick();
    expect(onStopSpy).toHaveBeenCalled();
  });
  it("fires onEnd event when endTime is reached and clock range is LOOP_STOP", function() {
    const start = new import__21.JulianDate(0);
    const stop = new import__21.JulianDate(1);
    const currentTime = stop;
    const multiplier = 100;
    const clock = new import__21.Clock({
      startTime: start,
      stopTime: stop,
      currentTime,
      clockStep: import__21.ClockStep.TICK_DEPENDENT,
      multiplier,
      clockRange: import__21.ClockRange.LOOP_STOP,
      shouldAnimate: true
    });
    const onStopSpy = jasmine.createSpy("event");
    clock.onStop.addEventListener(onStopSpy);
    clock.tick();
    expect(onStopSpy).toHaveBeenCalled();
  });
  describe("SYSTEM_CLOCK modes", function() {
    const baseDate = new Date(2016, 6, 7);
    beforeEach(function() {
      jasmine.clock().install();
      jasmine.clock().mockDate(baseDate);
      if (typeof performance !== "undefined" && (0, import__21.defined)(performance.now)) {
        spyOn(performance, "now").and.callFake(function() {
          return Date.now();
        });
      }
    });
    afterEach(function() {
      jasmine.clock().uninstall();
    });
    it("uses current time in SYSTEM_CLOCK mode (real-time mode)", function() {
      const clock = new import__21.Clock({
        clockStep: import__21.ClockStep.SYSTEM_CLOCK
      });
      expect(clock.currentTime).toEqual(import__21.JulianDate.fromDate(baseDate));
      expect(clock.multiplier).toEqual(1);
      expect(clock.shouldAnimate).toEqual(true);
      const time1 = clock.tick();
      expect(time1).toEqual(import__21.JulianDate.fromDate(baseDate));
      jasmine.clock().tick(1e3);
      const time2 = clock.tick();
      expect(time2).toEqual(
        import__21.JulianDate.addSeconds(
          import__21.JulianDate.fromDate(baseDate),
          1,
          new import__21.JulianDate()
        )
      );
    });
    it("switches out of SYSTEM_CLOCK mode when changing currentTime", function() {
      const clock = new import__21.Clock({
        clockStep: import__21.ClockStep.SYSTEM_CLOCK
      });
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.currentTime = clock.currentTime;
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.currentTime = new import__21.JulianDate(1);
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK_MULTIPLIER);
    });
    it("switches out of SYSTEM_CLOCK mode when changing multiplier", function() {
      const clock = new import__21.Clock({
        clockStep: import__21.ClockStep.SYSTEM_CLOCK
      });
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.multiplier = clock.multiplier;
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.multiplier = 1.5;
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK_MULTIPLIER);
    });
    it("switches out of SYSTEM_CLOCK mode when changing shouldAnimate", function() {
      const clock = new import__21.Clock({
        clockStep: import__21.ClockStep.SYSTEM_CLOCK
      });
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.shouldAnimate = clock.shouldAnimate;
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.shouldAnimate = false;
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK_MULTIPLIER);
    });
    it("sets currentTime, multiplier and shouldAnimate when switching to SYSTEM_CLOCK mode", function() {
      const clock = new import__21.Clock({
        currentTime: new import__21.JulianDate(1),
        clockStep: import__21.ClockStep.SYSTEM_CLOCK_MULTIPLIER,
        multiplier: 1.5
      });
      clock.clockStep = import__21.ClockStep.SYSTEM_CLOCK;
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      expect(clock.currentTime).toEqual(import__21.JulianDate.fromDate(baseDate));
      expect(clock.multiplier).toEqual(1);
      expect(clock.shouldAnimate).toEqual(true);
    });
    it("stays in SYSTEM_CLOCK mode when changing other unrelated properties", function() {
      const clock = new import__21.Clock({
        clockStep: import__21.ClockStep.SYSTEM_CLOCK
      });
      clock.startTime = new import__21.JulianDate(1);
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.stopTime = new import__21.JulianDate(2);
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.clockRange = import__21.ClockRange.CLAMP;
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
      clock.canAnimate = false;
      expect(clock.clockStep).toEqual(import__21.ClockStep.SYSTEM_CLOCK);
    });
    it("uses multiplier in SYSTEM_CLOCK_MULTIPLIER mode", function() {
      const clock = new import__21.Clock({
        clockStep: import__21.ClockStep.SYSTEM_CLOCK_MULTIPLIER,
        multiplier: 2,
        shouldAnimate: true
      });
      const time1 = clock.tick();
      expect(time1).toEqual(import__21.JulianDate.fromDate(baseDate));
      jasmine.clock().tick(1e3);
      const time2 = clock.tick();
      expect(time2).toEqual(
        import__21.JulianDate.addSeconds(
          import__21.JulianDate.fromDate(baseDate),
          2,
          new import__21.JulianDate()
        )
      );
    });
    it("does not advance if shouldAnimate is false and does advance if true", function() {
      const start = import__21.JulianDate.fromDate(baseDate);
      const clock = new import__21.Clock({
        startTime: start,
        clockStep: import__21.ClockStep.SYSTEM_CLOCK_MULTIPLIER
      });
      expect(clock.currentTime).toEqual(start);
      clock.shouldAnimate = false;
      jasmine.clock().tick(1e3);
      let time1 = clock.tick();
      expect(time1).toEqual(start);
      expect(clock.currentTime).toEqual(start);
      clock.shouldAnimate = true;
      jasmine.clock().tick(1e3);
      time1 = clock.tick();
      expect(time1).toEqual(
        import__21.JulianDate.addSeconds(
          import__21.JulianDate.fromDate(baseDate),
          1,
          new import__21.JulianDate()
        )
      );
      jasmine.clock().tick(1e3);
      const time2 = clock.tick();
      expect(time2).toEqual(
        import__21.JulianDate.addSeconds(
          import__21.JulianDate.fromDate(baseDate),
          2,
          new import__21.JulianDate()
        )
      );
      clock.currentTime = start;
      clock.clockStep = import__21.ClockStep.TICK_DEPENDENT;
      clock.shouldAnimate = false;
      time1 = clock.tick();
      expect(time1).toEqual(start);
      expect(clock.currentTime).toEqual(start);
      clock.shouldAnimate = true;
      time1 = clock.tick();
      expect(time1).toEqual(
        import__21.JulianDate.addSeconds(
          import__21.JulianDate.fromDate(baseDate),
          1,
          new import__21.JulianDate()
        )
      );
    });
  });
});

// packages/engine/Specs/Core/ColorGeometryInstanceAttributeSpec.js
var import__22 = __toESM(require_Cesium(), 1);
describe("Core/ColorGeometryInstanceAttribute", function() {
  it("constructor", function() {
    const attribute = new import__22.ColorGeometryInstanceAttribute(1, 1, 0, 0.5);
    expect(attribute.componentDatatype).toEqual(
      import__22.ComponentDatatype.UNSIGNED_BYTE
    );
    expect(attribute.componentsPerAttribute).toEqual(4);
    expect(attribute.normalize).toEqual(true);
    const value = new Uint8Array(new import__22.Color(1, 1, 0, 0.5).toBytes());
    expect(attribute.value).toEqual(value);
  });
  it("fromColor", function() {
    const color = import__22.Color.AQUA;
    const attribute = import__22.ColorGeometryInstanceAttribute.fromColor(color);
    expect(attribute.componentDatatype).toEqual(
      import__22.ComponentDatatype.UNSIGNED_BYTE
    );
    expect(attribute.componentsPerAttribute).toEqual(4);
    expect(attribute.normalize).toEqual(true);
    const value = new Uint8Array(color.toBytes());
    expect(attribute.value).toEqual(value);
  });
  it("fromColor throws without color", function() {
    expect(function() {
      import__22.ColorGeometryInstanceAttribute.fromColor();
    }).toThrowDeveloperError();
  });
  it("toValue", function() {
    const color = import__22.Color.AQUA;
    const expectedResult = new Uint8Array(color.toBytes());
    expect(import__22.ColorGeometryInstanceAttribute.toValue(color)).toEqual(
      expectedResult
    );
  });
  it("toValue works with result parameter", function() {
    const color = import__22.Color.AQUA;
    const expectedResult = new Uint8Array(color.toBytes());
    const result = new Uint8Array(4);
    const returnedResult = import__22.ColorGeometryInstanceAttribute.toValue(
      color,
      result
    );
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("toValue throws without a color", function() {
    expect(function() {
      import__22.ColorGeometryInstanceAttribute.toValue();
    }).toThrowDeveloperError();
  });
  it("equals", function() {
    const color = new import__22.ColorGeometryInstanceAttribute(0.1, 0.2, 0.3, 0.4);
    expect(import__22.ColorGeometryInstanceAttribute.equals(color, color)).toEqual(true);
    expect(
      import__22.ColorGeometryInstanceAttribute.equals(
        color,
        new import__22.ColorGeometryInstanceAttribute(0.1, 0.2, 0.3, 0.4)
      )
    ).toEqual(true);
    expect(
      import__22.ColorGeometryInstanceAttribute.equals(
        color,
        new import__22.ColorGeometryInstanceAttribute(0.5, 0.2, 0.3, 0.4)
      )
    ).toEqual(false);
    expect(
      import__22.ColorGeometryInstanceAttribute.equals(
        color,
        new import__22.ColorGeometryInstanceAttribute(0.1, 0.5, 0.3, 0.4)
      )
    ).toEqual(false);
    expect(
      import__22.ColorGeometryInstanceAttribute.equals(
        color,
        new import__22.ColorGeometryInstanceAttribute(0.1, 0.2, 0.5, 0.4)
      )
    ).toEqual(false);
    expect(
      import__22.ColorGeometryInstanceAttribute.equals(
        color,
        new import__22.ColorGeometryInstanceAttribute(0.1, 0.2, 0.3, 0.5)
      )
    ).toEqual(false);
    expect(import__22.ColorGeometryInstanceAttribute.equals(color, void 0)).toEqual(
      false
    );
    expect(import__22.ColorGeometryInstanceAttribute.equals(void 0, color)).toEqual(
      false
    );
  });
});

// packages/engine/Specs/Core/ColorSpec.js
var import__23 = __toESM(require_Cesium(), 1);
describe("Core/Color", function() {
  it("Constructing without arguments produces expected defaults", function() {
    const v = new import__23.Color();
    expect(v.red).toEqual(1);
    expect(v.green).toEqual(1);
    expect(v.blue).toEqual(1);
    expect(v.alpha).toEqual(1);
  });
  it("Constructing with arguments sets property values", function() {
    const v = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    expect(v.red).toEqual(0.1);
    expect(v.green).toEqual(0.2);
    expect(v.blue).toEqual(0.3);
    expect(v.alpha).toEqual(0.4);
  });
  it("fromBytes without arguments produces expected defaults", function() {
    const v = new import__23.Color();
    expect(v.red).toEqual(1);
    expect(v.green).toEqual(1);
    expect(v.blue).toEqual(1);
    expect(v.alpha).toEqual(1);
  });
  it("fromBytes with arguments sets property values", function() {
    const v = import__23.Color.fromBytes(0, 255, 51, 102);
    expect(v.red).toEqual(0);
    expect(v.green).toEqual(1);
    expect(v.blue).toEqual(0.2);
    expect(v.alpha).toEqual(0.4);
  });
  it("fromBytes works with result parameter", function() {
    const result = new import__23.Color();
    const v = import__23.Color.fromBytes(0, 255, 51, 102, result);
    expect(v).toBe(result);
    expect(v.red).toEqual(0);
    expect(v.green).toEqual(1);
    expect(v.blue).toEqual(0.2);
    expect(v.alpha).toEqual(0.4);
  });
  it("toBytes returns the same values that fromBytes took", function() {
    const r = 5;
    const g = 87;
    const b = 23;
    const a = 88;
    const c = import__23.Color.fromBytes(r, g, b, a);
    const bytes = c.toBytes();
    expect(bytes).toEqual([r, g, b, a]);
  });
  it("toBytes works with a result parameter", function() {
    const color = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const result = [];
    const expectedResult = [25, 51, 76, 102];
    const returnedResult = color.toBytes(result);
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("byteToFloat works in all cases", function() {
    expect(import__23.Color.byteToFloat(0)).toEqual(0);
    expect(import__23.Color.byteToFloat(255)).toEqual(1);
    expect(import__23.Color.byteToFloat(127)).toEqual(127 / 255);
  });
  it("floatToByte works in all cases", function() {
    expect(import__23.Color.floatToByte(0)).toEqual(0);
    expect(import__23.Color.floatToByte(1)).toEqual(255);
    expect(import__23.Color.floatToByte(127 / 255)).toEqual(127);
  });
  it("fromCartesian4 returns a color with corrrect values", function() {
    const color = import__23.Color.fromCartesian4(new import__23.Cartesian4(1, 2, 3, 4));
    expect(color).toEqual(new import__23.Color(1, 2, 3, 4));
  });
  it("fromCartesian4 result param returns color with correct values", function() {
    const color = new import__23.Color();
    const result = import__23.Color.fromCartesian4(
      new import__23.Cartesian4(1, 2, 3, 4),
      color
    );
    expect(color).toBe(result);
    expect(color).toEqual(new import__23.Color(1, 2, 3, 4));
  });
  it("fromCartesian4 throws without a Cartesian4", function() {
    expect(function() {
      import__23.Color.fromCartesian4();
    }).toThrowDeveloperError();
  });
  it("clone with no parameters returns a new identical copy.", function() {
    const v = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const clone24 = v.clone();
    expect(clone24).toEqual(v);
    expect(clone24).not.toBe(v);
  });
  it("clone with a parameter modifies the parameter.", function() {
    const v = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const v2 = new import__23.Color();
    const clone24 = v.clone(v2);
    expect(clone24).toEqual(v2);
    expect(clone24).toBe(v2);
  });
  it("equals works", function() {
    const v = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const v2 = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const v3 = new import__23.Color(0.1, 0.2, 0.3, 0.5);
    const v4 = new import__23.Color(0.1, 0.2, 0.5, 0.4);
    const v5 = new import__23.Color(0.1, 0.5, 0.3, 0.4);
    const v6 = new import__23.Color(0.5, 0.2, 0.3, 0.4);
    expect(v.equals(v2)).toEqual(true);
    expect(v.equals(v3)).toEqual(false);
    expect(v.equals(v4)).toEqual(false);
    expect(v.equals(v5)).toEqual(false);
    expect(v.equals(v6)).toEqual(false);
  });
  it("equalsEpsilon works", function() {
    const v = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const v2 = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const v3 = new import__23.Color(0.1, 0.2, 0.3, 0.5);
    const v4 = new import__23.Color(0.1, 0.2, 0.5, 0.4);
    const v5 = new import__23.Color(0.1, 0.5, 0.3, 0.4);
    const v6 = new import__23.Color(0.5, 0.2, 0.3, 0.4);
    expect(v.equalsEpsilon(v2, 0)).toEqual(true);
    expect(v.equalsEpsilon(v3, 0)).toEqual(false);
    expect(v.equalsEpsilon(v4, 0)).toEqual(false);
    expect(v.equalsEpsilon(v5, 0)).toEqual(false);
    expect(v.equalsEpsilon(v6, 0)).toEqual(false);
    expect(v.equalsEpsilon(v2, 0.1)).toEqual(true);
    expect(v.equalsEpsilon(v3, 0.1)).toEqual(true);
    expect(v.equalsEpsilon(v4, 0.2)).toEqual(true);
    expect(v.equalsEpsilon(v5, 0.3)).toEqual(true);
    expect(v.equalsEpsilon(v6, 0.4)).toEqual(true);
  });
  it("toCssColorString produces expected output", function() {
    expect(import__23.Color.WHITE.toCssColorString()).toEqual("rgb(255,255,255)");
    expect(import__23.Color.RED.toCssColorString()).toEqual("rgb(255,0,0)");
    expect(import__23.Color.BLUE.toCssColorString()).toEqual("rgb(0,0,255)");
    expect(import__23.Color.LIME.toCssColorString()).toEqual("rgb(0,255,0)");
    expect(new import__23.Color(0, 0, 0, 1).toCssColorString()).toEqual(
      "rgb(0,0,0)"
    );
    expect(new import__23.Color(0.1, 0.2, 0.3, 0.4).toCssColorString()).toEqual(
      "rgba(25,51,76,0.4)"
    );
  });
  it("toCssHexString produces expected output", function() {
    expect(import__23.Color.WHITE.toCssHexString()).toEqual("#ffffff");
    expect(import__23.Color.RED.toCssHexString()).toEqual("#ff0000");
    expect(import__23.Color.BLUE.toCssHexString()).toEqual("#0000ff");
    expect(import__23.Color.LIME.toCssHexString()).toEqual("#00ff00");
    expect(new import__23.Color(0, 0, 0, 1).toCssHexString()).toEqual("#000000");
    expect(new import__23.Color(0.1, 0.2, 0.3, 0.4).toCssHexString()).toEqual("#19334c66");
  });
  it("fromCssColorString supports transparent", function() {
    expect(import__23.Color.fromCssColorString("transparent")).toEqual(
      new import__23.Color(0, 0, 0, 0)
    );
  });
  it("fromCssColorString supports the #rgb format", function() {
    expect(import__23.Color.fromCssColorString("#369")).toEqual(
      new import__23.Color(0.2, 0.4, 0.6, 1)
    );
  });
  it("fromCssColorString supports the #rgb format with lowercase", function() {
    expect(import__23.Color.fromCssColorString("#f00")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("#0f0")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("#00f")).toEqual(import__23.Color.BLUE);
  });
  it("fromCssColorString supports the #rgb format with uppercase", function() {
    expect(import__23.Color.fromCssColorString("#F00")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("#0F0")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("#00F")).toEqual(import__23.Color.BLUE);
  });
  it("fromCssColorString supports the #rgba format", function() {
    expect(import__23.Color.fromCssColorString("#369c")).toEqual(
      new import__23.Color(0.2, 0.4, 0.6, 0.8)
    );
  });
  it("fromCssColorString supports the #rgba format with uppercase", function() {
    expect(import__23.Color.fromCssColorString("#369C")).toEqual(
      new import__23.Color(0.2, 0.4, 0.6, 0.8)
    );
  });
  it("fromCssColorString supports the #rrggbb format", function() {
    expect(import__23.Color.fromCssColorString("#336699")).toEqual(
      new import__23.Color(0.2, 0.4, 0.6, 1)
    );
  });
  it("fromCssColorString supports the #rrggbb format with lowercase", function() {
    expect(import__23.Color.fromCssColorString("#ff0000")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("#00ff00")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("#0000ff")).toEqual(import__23.Color.BLUE);
  });
  it("fromCssColorString supports the #rrggbb format with uppercase", function() {
    expect(import__23.Color.fromCssColorString("#FF0000")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("#00FF00")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("#0000FF")).toEqual(import__23.Color.BLUE);
  });
  it("fromCssColorString supports the #rrggbbaa format", function() {
    expect(import__23.Color.fromCssColorString("#336699cc")).toEqual(
      new import__23.Color(0.2, 0.4, 0.6, 0.8)
    );
  });
  it("fromCssColorString supports the #rrggbbaa format with uppercase", function() {
    expect(import__23.Color.fromCssColorString("#336699CC")).toEqual(
      new import__23.Color(0.2, 0.4, 0.6, 0.8)
    );
  });
  it("fromCssColorString supports the rgb() format with absolute values", function() {
    expect(import__23.Color.fromCssColorString("rgb(255, 0, 0)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("rgb(0, 255, 0)")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("rgb(0, 0, 255)")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("rgb(51, 102, 204)")).toEqual(
      new import__23.Color(0.2, 0.4, 0.8, 1)
    );
  });
  it("fromCssColorString supports the rgb() format with absolute values (space-separated)", function() {
    expect(import__23.Color.fromCssColorString("rgb(255 0 0)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("rgb(0 255 0)")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("rgb(0 0 255)")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("rgb(51 102 204)")).toEqual(
      new import__23.Color(0.2, 0.4, 0.8, 1)
    );
  });
  it("fromCssColorString supports the rgb() format with percentages", function() {
    expect(import__23.Color.fromCssColorString("rgb(100%, 0, 0)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("rgb(0, 100%, 0)")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("rgb(0, 0, 100%)")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("rgb(20%, 40%, 80%)")).toEqual(
      new import__23.Color(0.2, 0.4, 0.8, 1)
    );
  });
  it("fromCssColorString supports the rgb() format with percentages (space-separated)", function() {
    expect(import__23.Color.fromCssColorString("rgb(100% 0 0)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("rgb(0 100% 0)")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("rgb(0 0 100%)")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("rgb(20% 40% 80%)")).toEqual(
      new import__23.Color(0.2, 0.4, 0.8, 1)
    );
  });
  it("fromCssColorString supports the rgba() format with absolute values", function() {
    expect(import__23.Color.fromCssColorString("rgba(255, 0, 0, 1.0)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("rgba(0, 255, 0, 1.0)")).toEqual(
      import__23.Color.LIME
    );
    expect(import__23.Color.fromCssColorString("rgba(0, 0, 255, 1.0)")).toEqual(
      import__23.Color.BLUE
    );
    expect(import__23.Color.fromCssColorString("rgba(51, 102, 204, 0.6)")).toEqual(
      new import__23.Color(0.2, 0.4, 0.8, 0.6)
    );
  });
  it("fromCssColorString supports the rgba() format with absolute values (space-separated)", function() {
    expect(import__23.Color.fromCssColorString("rgba(255 0 0 / 1.0)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("rgba(0 255 0 / 1.0)")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("rgba(0 0 255 / 1.0)")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("rgba(51 102 204 / 0.6)")).toEqual(
      new import__23.Color(0.2, 0.4, 0.8, 0.6)
    );
  });
  it("fromCssColorString supports the rgba() format with percentages", function() {
    expect(import__23.Color.fromCssColorString("rgba(100%, 0, 0, 1.0)")).toEqual(
      import__23.Color.RED
    );
    expect(import__23.Color.fromCssColorString("rgba(0, 100%, 0, 1.0)")).toEqual(
      import__23.Color.LIME
    );
    expect(import__23.Color.fromCssColorString("rgba(0, 0, 100%, 1.0)")).toEqual(
      import__23.Color.BLUE
    );
    expect(import__23.Color.fromCssColorString("rgba(20%, 40%, 80%, 0.6)")).toEqual(
      new import__23.Color(0.2, 0.4, 0.8, 0.6)
    );
  });
  it("fromCssColorString supports the rgba() format with percentages (space-separated)", function() {
    expect(import__23.Color.fromCssColorString("rgba(100% 0 0 / 1.0)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("rgba(0 100% 0 / 1.0)")).toEqual(
      import__23.Color.LIME
    );
    expect(import__23.Color.fromCssColorString("rgba(0 0 100% / 1.0)")).toEqual(
      import__23.Color.BLUE
    );
    expect(import__23.Color.fromCssColorString("rgba(20% 40% 80% / 0.6)")).toEqual(
      new import__23.Color(0.2, 0.4, 0.8, 0.6)
    );
  });
  it("fromCssColorString supports named colors regardless of case", function() {
    expect(import__23.Color.fromCssColorString("red")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("GREEN")).toEqual(import__23.Color.GREEN);
    expect(import__23.Color.fromCssColorString("BLue")).toEqual(import__23.Color.BLUE);
  });
  it("fromCssColorString supports the hsl() format", function() {
    expect(import__23.Color.fromCssColorString("hsl(0, 100%, 50%)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("hsl(120, 100%, 50%)")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("hsl(240, 100%, 50%)")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("hsl(220, 60%, 50%)")).toEqualEpsilon(
      new import__23.Color(0.2, 0.4, 0.8),
      import__23.Math.EPSILON15
    );
  });
  it("fromCssColorString supports the hsl() format (space-separated)", function() {
    expect(import__23.Color.fromCssColorString("hsl(0 100% 50%)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("hsl(120 100% 50%)")).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromCssColorString("hsl(240 100% 50%)")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("hsl(220 60% 50%)")).toEqualEpsilon(
      new import__23.Color(0.2, 0.4, 0.8),
      import__23.Math.EPSILON15
    );
  });
  it("fromCssColorString supports the hsla() format", function() {
    expect(import__23.Color.fromCssColorString("hsla(0, 100%, 50%, 1.0)")).toEqual(
      import__23.Color.RED
    );
    expect(import__23.Color.fromCssColorString("hsla(120, 100%, 50%, 1.0)")).toEqual(
      import__23.Color.LIME
    );
    expect(import__23.Color.fromCssColorString("hsla(240, 100%, 50%, 1.0)")).toEqual(
      import__23.Color.BLUE
    );
    expect(import__23.Color.fromCssColorString("hsla(220, 60%, 50%, 0.6)")).toEqualEpsilon(
      new import__23.Color(0.2, 0.4, 0.8, 0.6),
      import__23.Math.EPSILON15
    );
  });
  it("fromCssColorString supports the hsla() format (space-separated)", function() {
    expect(import__23.Color.fromCssColorString("hsla(0 100% 50% / 1.0)")).toEqual(
      import__23.Color.RED
    );
    expect(import__23.Color.fromCssColorString("hsla(120 100% 50% / 1.0)")).toEqual(
      import__23.Color.LIME
    );
    expect(import__23.Color.fromCssColorString("hsla(240 100% 50% / 1.0)")).toEqual(
      import__23.Color.BLUE
    );
    expect(import__23.Color.fromCssColorString("hsla(220 60% 50% / 0.6)")).toEqualEpsilon(
      new import__23.Color(0.2, 0.4, 0.8, 0.6),
      import__23.Math.EPSILON15
    );
  });
  it("fromCssColorString wraps hue into valid range for hsl() format", function() {
    expect(import__23.Color.fromCssColorString("hsl(720, 100%, 50%)")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("hsla(720, 100%, 50%, 1.0)")).toEqual(
      import__23.Color.RED
    );
  });
  it("fromCssColorString returns undefined for unknown colors", function() {
    expect(import__23.Color.fromCssColorString("not a color")).toBeUndefined();
  });
  it("fromCssColorString throws with undefined", function() {
    expect(function() {
      import__23.Color.fromCssColorString(void 0);
    }).toThrowDeveloperError();
  });
  it("fromCssColorString works with a result parameter.", function() {
    const c = new import__23.Color();
    let c2 = import__23.Color.fromCssColorString("yellow", c);
    expect(c).toBe(c2);
    expect(c).toEqual(import__23.Color.YELLOW);
    c2 = import__23.Color.fromCssColorString("#f00", c);
    expect(c).toBe(c2);
    expect(c).toEqual(import__23.Color.RED);
    c.alpha = 0.5;
    c2 = import__23.Color.fromCssColorString("#f00", c);
    expect(c).toBe(c2);
    expect(c).toEqual(import__23.Color.RED);
    c2 = import__23.Color.fromCssColorString("#0000ff", c);
    expect(c).toBe(c2);
    expect(c).toEqual(import__23.Color.BLUE);
    c2 = import__23.Color.fromCssColorString("rgb(0, 255, 255)", c);
    expect(c).toBe(c2);
    expect(c).toEqual(import__23.Color.CYAN);
    c2 = import__23.Color.fromCssColorString("hsl(120, 100%, 50%)", c);
    expect(c).toBe(c2);
    expect(c).toEqual(import__23.Color.LIME);
  });
  it("fromCssColorString understands the color string even with any number of unnecessary leading, trailing or middle spaces", function() {
    expect(import__23.Color.fromCssColorString(" rgb( 0, 0, 255)")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("rgb( 255, 255, 255) ")).toEqual(
      import__23.Color.WHITE
    );
    expect(import__23.Color.fromCssColorString("rgb (0 0 255) ")).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromCssColorString("  #FF0000")).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromCssColorString("#FF0  ")).toEqual(import__23.Color.YELLOW);
    expect(import__23.Color.fromCssColorString(" hsla(720,   100%, 50%, 1.0)  ")).toEqual(
      import__23.Color.RED
    );
    expect(import__23.Color.fromCssColorString("hsl (720, 100%, 50%)")).toEqual(import__23.Color.RED);
  });
  it("fromHsl produces expected output", function() {
    expect(import__23.Color.fromHsl(0, 1, 0.5, 1)).toEqual(import__23.Color.RED);
    expect(import__23.Color.fromHsl(120 / 360, 1, 0.5, 1)).toEqual(import__23.Color.LIME);
    expect(import__23.Color.fromHsl(240 / 360, 1, 0.5, 1)).toEqual(import__23.Color.BLUE);
    expect(import__23.Color.fromHsl(220 / 360, 0.6, 0.5, 0.7)).toEqualEpsilon(
      new import__23.Color(0.2, 0.4, 0.8, 0.7),
      import__23.Math.EPSILON15
    );
  });
  it("fromHsl properly wraps hue into valid range", function() {
    expect(import__23.Color.fromHsl(5, 1, 0.5, 1)).toEqual(import__23.Color.RED);
  });
  it("fromHsl works with result parameter", function() {
    const c1 = new import__23.Color();
    const c2 = import__23.Color.fromHsl(5, 1, 0.5, 1, c1);
    expect(c1).toEqual(import__23.Color.RED);
    expect(c1).toBe(c2);
  });
  it("fromRandom generates a random color with no options", function() {
    const color = import__23.Color.fromRandom();
    expect(color.red).toBeBetween(0, 1);
    expect(color.green).toBeBetween(0, 1);
    expect(color.blue).toBeBetween(0, 1);
    expect(color.alpha).toBeBetween(0, 1);
  });
  it("fromRandom generates a random color with no options", function() {
    const result = new import__23.Color();
    const color = import__23.Color.fromRandom({}, result);
    expect(result).toBe(color);
    expect(color.red).toBeBetween(0, 1);
    expect(color.green).toBeBetween(0, 1);
    expect(color.blue).toBeBetween(0, 1);
    expect(color.alpha).toBeBetween(0, 1);
  });
  it("fromRandom uses specified exact values", function() {
    const options = {
      red: 0.1,
      green: 0.2,
      blue: 0.3,
      alpha: 0.4
    };
    const color = import__23.Color.fromRandom(options);
    expect(color.red).toEqual(options.red);
    expect(color.green).toEqual(options.green);
    expect(color.blue).toEqual(options.blue);
    expect(color.alpha).toEqual(options.alpha);
  });
  it("fromRandom generates a random kind of Red color within intervals", function() {
    const options = {
      red: void 0,
      minimumRed: 0.1,
      maximumRed: 0.2,
      minimumGreen: 0.3,
      maximumGreen: 0.4,
      minimumBlue: 0.5,
      maximumBlue: 0.6,
      minimumAlpha: 0.7,
      maximumAlpha: 0.8
    };
    for (let i = 0; i < 100; i++) {
      const color = import__23.Color.fromRandom(options);
      expect(color.red).toBeBetween(options.minimumRed, options.maximumRed);
      expect(color.green).toBeBetween(
        options.minimumGreen,
        options.maximumGreen
      );
      expect(color.blue).toBeBetween(options.minimumBlue, options.maximumBlue);
      expect(color.alpha).toBeBetween(
        options.minimumAlpha,
        options.maximumAlpha
      );
    }
  });
  it("fromRandom throws with invalid minimum-maximum red values", function() {
    expect(function() {
      import__23.Color.fromRandom({
        minimumRed: 1,
        maximumRed: 0
      });
    }).toThrowDeveloperError();
  });
  it("fromRandom throws with invalid minimum-maximum green values", function() {
    expect(function() {
      import__23.Color.fromRandom({
        minimumGreen: 1,
        maximumGreen: 0
      });
    }).toThrowDeveloperError();
  });
  it("fromRandom throws with invalid minimum-maximum blue values", function() {
    expect(function() {
      import__23.Color.fromRandom({
        minimumBlue: 1,
        maximumBlue: 0
      });
    }).toThrowDeveloperError();
  });
  it("fromRandom throws with invalid minimum-maximum alpha values", function() {
    expect(function() {
      import__23.Color.fromRandom({
        minimumAlpha: 1,
        maximumAlpha: 0
      });
    }).toThrowDeveloperError();
  });
  it("fromAlpha works", function() {
    const result = import__23.Color.fromAlpha(import__23.Color.RED, 0.5);
    expect(result).toEqual(new import__23.Color(1, 0, 0, 0.5));
  });
  it("fromAlpha works with result parameter", function() {
    const resultParam = new import__23.Color();
    const result = import__23.Color.fromAlpha(import__23.Color.RED, 0.5, resultParam);
    expect(resultParam).toBe(result);
    expect(result).toEqual(new import__23.Color(1, 0, 0, 0.5));
  });
  it("fromAlpha throws with undefined color", function() {
    const result = new import__23.Color();
    expect(function() {
      import__23.Color.fromAlpha(void 0, 0.5, result);
    }).toThrowDeveloperError();
  });
  it("fromAlpha throws with undefined color", function() {
    const result = new import__23.Color();
    expect(function() {
      import__23.Color.fromAlpha(void 0, 0.5, result);
    }).toThrowDeveloperError();
  });
  it("fromAlpha throws with undefined alpha", function() {
    const result = new import__23.Color();
    const color = new import__23.Color();
    expect(function() {
      import__23.Color.fromAlpha(color, void 0, result);
    }).toThrowDeveloperError();
  });
  it("withAlpha works", function() {
    const resultParam = new import__23.Color();
    const result = import__23.Color.RED.withAlpha(0.5, resultParam);
    expect(resultParam).toBe(result);
    expect(result).toEqual(new import__23.Color(1, 0, 0, 0.5));
  });
  it("toString produces correct results", function() {
    expect(new import__23.Color(0.1, 0.2, 0.3, 0.4).toString()).toEqual(
      "(0.1, 0.2, 0.3, 0.4)"
    );
  });
  it("can convert to and from RGBA", function() {
    const color = import__23.Color.fromBytes(255, 204, 0, 238);
    const rgba = color.toRgba();
    expect(rgba).toBeGreaterThan(0);
    const result = new import__23.Color();
    const newColor = import__23.Color.fromRgba(rgba, result);
    expect(result).toBe(newColor);
    expect(color).toEqual(newColor);
  });
  it("fromRgba works with result parameter", function() {
    const color = import__23.Color.fromBytes(255, 204, 0, 238);
    const rgba = color.toRgba();
    const newColor = import__23.Color.fromRgba(rgba);
    expect(color).toEqual(newColor);
  });
  it("Can brighten", function() {
    const dark = new import__23.Color(0.2, 0.4, 0.6, 0.8);
    const brighter = dark.brighten(0.5, new import__23.Color());
    expect(brighter.red).toEqual(0.6);
    expect(brighter.green).toEqual(0.7);
    expect(brighter.blue).toEqual(0.8);
    expect(brighter.alpha).toEqual(0.8);
  });
  it("Can darken", function() {
    const dark = new import__23.Color(0.1, 0.6, 0.8, 0.8);
    const darker = dark.darken(0.2, new import__23.Color());
    expect(darker.red).toEqualEpsilon(0.08, import__23.Math.EPSILON15);
    expect(darker.green).toEqualEpsilon(0.48, import__23.Math.EPSILON15);
    expect(darker.blue).toEqualEpsilon(0.64, import__23.Math.EPSILON15);
    expect(darker.alpha).toEqualEpsilon(0.8, import__23.Math.EPSILON15);
  });
  it("brighten throws without result", function() {
    expect(function() {
      import__23.Color.RED.brighten(0.5, void 0);
    }).toThrowDeveloperError();
  });
  it("darken throws without result", function() {
    expect(function() {
      import__23.Color.RED.darken(0.5, void 0);
    }).toThrowDeveloperError();
  });
  it("brighten throws negative magnitude", function() {
    expect(function() {
      import__23.Color.RED.brighten(-0.5, new import__23.Color());
    }).toThrowDeveloperError();
  });
  it("darken throws negative magnitude", function() {
    expect(function() {
      import__23.Color.RED.darken(-0.5, new import__23.Color());
    }).toThrowDeveloperError();
  });
  it("brighten throws undefined magnitude", function() {
    expect(function() {
      import__23.Color.RED.brighten(void 0, new import__23.Color());
    }).toThrowDeveloperError();
  });
  it("darken throws undefined magnitude", function() {
    expect(function() {
      import__23.Color.RED.darken(void 0, new import__23.Color());
    }).toThrowDeveloperError();
  });
  it("Can add", function() {
    const left = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const right = new import__23.Color(0.3, 0.3, 0.3, 0.3);
    const result = import__23.Color.add(left, right, new import__23.Color());
    expect(result.red).toEqual(0.4);
    expect(result.green).toEqual(0.5);
    expect(result.blue).toEqual(0.6);
    expect(result.alpha).toEqual(0.7);
  });
  it("add throws with undefined parameters", function() {
    expect(function() {
      import__23.Color.add(void 0, new import__23.Color(), new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.add(new import__23.Color(), void 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.add(new import__23.Color(), new import__23.Color(), void 0);
    }).toThrowDeveloperError();
  });
  it("can add with a result parameter that is an input parameter", function() {
    const left = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const right = new import__23.Color(0.3, 0.3, 0.3, 0.3);
    const result = import__23.Color.add(left, right, left);
    expect(result.red).toEqual(0.4);
    expect(result.green).toEqual(0.5);
    expect(result.blue).toEqual(0.6);
    expect(result.alpha).toEqual(0.7);
  });
  it("Can subtract", function() {
    const left = new import__23.Color(1, 1, 1, 1);
    const right = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const result = import__23.Color.subtract(left, right, new import__23.Color());
    expect(result.red).toEqual(0.9);
    expect(result.green).toEqual(0.8);
    expect(result.blue).toEqual(0.7);
    expect(result.alpha).toEqual(0.6);
  });
  it("subtract throws with undefined parameters", function() {
    expect(function() {
      import__23.Color.subtract(void 0, new import__23.Color(), new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.subtract(new import__23.Color(), void 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.subtract(new import__23.Color(), new import__23.Color(), void 0);
    }).toThrowDeveloperError();
  });
  it("subtract multiply with a result parameter that is an input parameter", function() {
    const left = new import__23.Color(1, 1, 1, 1);
    const right = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const result = import__23.Color.subtract(left, right, left);
    expect(result.red).toEqual(0.9);
    expect(result.green).toEqual(0.8);
    expect(result.blue).toEqual(0.7);
    expect(result.alpha).toEqual(0.6);
  });
  it("Can multiply", function() {
    const left = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const right = new import__23.Color(0.2, 0.2, 0.2, 0.2);
    const result = import__23.Color.multiply(left, right, new import__23.Color());
    expect(result.red).toEqualEpsilon(0.02, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0.04, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.06, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.08, import__23.Math.EPSILON15);
  });
  it("multiply throws with undefined parameters", function() {
    expect(function() {
      import__23.Color.multiply(void 0, new import__23.Color(), new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.multiply(new import__23.Color(), void 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.multiply(new import__23.Color(), new import__23.Color(), void 0);
    }).toThrowDeveloperError();
  });
  it("can multiply with a result parameter that is an input parameter", function() {
    const left = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const right = new import__23.Color(0.2, 0.2, 0.2, 0.2);
    const result = import__23.Color.multiply(left, right, left);
    expect(result.red).toEqualEpsilon(0.02, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0.04, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.06, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.08, import__23.Math.EPSILON15);
  });
  it("Can divide", function() {
    const left = new import__23.Color(0.1, 0.2, 0.1, 0.2);
    const right = new import__23.Color(0.2, 0.2, 0.4, 0.4);
    const result = import__23.Color.divide(left, right, new import__23.Color());
    expect(result.red).toEqualEpsilon(0.5, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(1, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.25, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.5, import__23.Math.EPSILON15);
  });
  it("divide throws with undefined parameters", function() {
    expect(function() {
      import__23.Color.divide(void 0, new import__23.Color(), new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.divide(new import__23.Color(), void 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.divide(new import__23.Color(), new import__23.Color(), void 0);
    }).toThrowDeveloperError();
  });
  it("can divide with a result parameter that is an input parameter", function() {
    const left = new import__23.Color(0.1, 0.2, 0.1, 0.2);
    const right = new import__23.Color(0.2, 0.2, 0.4, 0.4);
    const result = import__23.Color.divide(left, right, left);
    expect(result.red).toEqualEpsilon(0.5, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(1, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.25, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.5, import__23.Math.EPSILON15);
  });
  it("Can mod", function() {
    const left = new import__23.Color(0.1, 0.2, 0.3, 0.2);
    const right = new import__23.Color(0.2, 0.2, 0.2, 0.4);
    const result = import__23.Color.mod(left, right, new import__23.Color());
    expect(result.red).toEqualEpsilon(0.1, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.1, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.2, import__23.Math.EPSILON15);
  });
  it("mod throws with undefined parameters", function() {
    expect(function() {
      import__23.Color.mod(void 0, new import__23.Color(), new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.mod(new import__23.Color(), void 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.mod(new import__23.Color(), new import__23.Color(), void 0);
    }).toThrowDeveloperError();
  });
  it("can mod with a result parameter that is an input parameter", function() {
    const left = new import__23.Color(0.1, 0.2, 0.3, 0.2);
    const right = new import__23.Color(0.2, 0.2, 0.2, 0.4);
    const result = import__23.Color.mod(left, right, left);
    expect(result.red).toEqualEpsilon(0.1, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.1, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.2, import__23.Math.EPSILON15);
  });
  it("Can multiply by scalar", function() {
    const color = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const result = import__23.Color.multiplyByScalar(color, 2, new import__23.Color());
    expect(result.red).toEqualEpsilon(0.2, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0.4, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.6, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.8, import__23.Math.EPSILON15);
  });
  it("multiply by scalar throws with undefined parameters", function() {
    expect(function() {
      import__23.Color.multiplyByScalar(void 0, new import__23.Color(), new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.multiplyByScalar(new import__23.Color(), void 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.multiplyByScalar(new import__23.Color(), new import__23.Color(), void 0);
    }).toThrowDeveloperError();
  });
  it("can multiply by scalar with a result parameter that is an input parameter", function() {
    const color = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const result = import__23.Color.multiplyByScalar(color, 2, color);
    expect(result.red).toEqualEpsilon(0.2, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0.4, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.6, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.8, import__23.Math.EPSILON15);
  });
  it("Can divide by scalar", function() {
    const color = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const result = import__23.Color.divideByScalar(color, 2, new import__23.Color());
    expect(result.red).toEqualEpsilon(0.05, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0.1, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.15, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.2, import__23.Math.EPSILON15);
  });
  it("divide by scalar throws with undefined parameters", function() {
    expect(function() {
      import__23.Color.divideByScalar(void 0, new import__23.Color(), new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.divideByScalar(new import__23.Color(), void 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.divideByScalar(new import__23.Color(), new import__23.Color(), void 0);
    }).toThrowDeveloperError();
  });
  it("can divide by scalar with a result parameter that is an input parameter", function() {
    const color = new import__23.Color(0.1, 0.2, 0.3, 0.4);
    const result = import__23.Color.divideByScalar(color, 2, color);
    expect(result.red).toEqualEpsilon(0.05, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0.1, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.15, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.2, import__23.Math.EPSILON15);
  });
  it("lerp throws with undefined parameters", function() {
    expect(function() {
      import__23.Color.lerp(void 0, new import__23.Color(), 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.lerp(new import__23.Color(), void 0, 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.lerp(new import__23.Color(), new import__23.Color(), void 0, new import__23.Color());
    }).toThrowDeveloperError();
    expect(function() {
      import__23.Color.lerp(new import__23.Color(), new import__23.Color(), 0, void 0);
    }).toThrowDeveloperError();
  });
  it("can lerp between two colors", function() {
    const colorA = new import__23.Color(0, 0, 0, 0);
    const colorB = new import__23.Color(1, 1, 1, 1);
    const result = import__23.Color.lerp(colorA, colorB, 0.5, new import__23.Color());
    expect(result.red).toEqualEpsilon(0.5, import__23.Math.EPSILON15);
    expect(result.green).toEqualEpsilon(0.5, import__23.Math.EPSILON15);
    expect(result.blue).toEqualEpsilon(0.5, import__23.Math.EPSILON15);
    expect(result.alpha).toEqualEpsilon(0.5, import__23.Math.EPSILON15);
  });
  createPackableSpecs_default(import__23.Color, new import__23.Color(0.1, 0.2, 0.3, 0.4), [
    0.1,
    0.2,
    0.3,
    0.4
  ]);
});

// packages/engine/Specs/Core/ComponentDatatypeSpec.js
var import__24 = __toESM(require_Cesium(), 1);
describe("Core/ComponentDatatype", function() {
  it("fromTypedArray works", function() {
    expect(import__24.ComponentDatatype.fromTypedArray(new Int8Array())).toBe(
      import__24.ComponentDatatype.BYTE
    );
    expect(import__24.ComponentDatatype.fromTypedArray(new Uint8Array())).toBe(
      import__24.ComponentDatatype.UNSIGNED_BYTE
    );
    expect(import__24.ComponentDatatype.fromTypedArray(new Int16Array())).toBe(
      import__24.ComponentDatatype.SHORT
    );
    expect(import__24.ComponentDatatype.fromTypedArray(new Uint16Array())).toBe(
      import__24.ComponentDatatype.UNSIGNED_SHORT
    );
    expect(import__24.ComponentDatatype.fromTypedArray(new Int32Array())).toBe(
      import__24.ComponentDatatype.INT
    );
    expect(import__24.ComponentDatatype.fromTypedArray(new Uint32Array())).toBe(
      import__24.ComponentDatatype.UNSIGNED_INT
    );
    expect(import__24.ComponentDatatype.fromTypedArray(new Float32Array())).toBe(
      import__24.ComponentDatatype.FLOAT
    );
    expect(import__24.ComponentDatatype.fromTypedArray(new Float64Array())).toBe(
      import__24.ComponentDatatype.DOUBLE
    );
  });
  it("fromTypedArray throws if array is not a valid typed array", function() {
    expect(function() {
      import__24.ComponentDatatype.fromTypedArray([]);
    }).toThrowDeveloperError();
  });
  it("validate works", function() {
    expect(import__24.ComponentDatatype.validate(import__24.ComponentDatatype.BYTE)).toBe(true);
    expect(import__24.ComponentDatatype.validate(import__24.ComponentDatatype.UNSIGNED_BYTE)).toBe(
      true
    );
    expect(import__24.ComponentDatatype.validate(import__24.ComponentDatatype.SHORT)).toBe(true);
    expect(import__24.ComponentDatatype.validate(import__24.ComponentDatatype.UNSIGNED_SHORT)).toBe(
      true
    );
    expect(import__24.ComponentDatatype.validate(import__24.ComponentDatatype.INT)).toBe(true);
    expect(import__24.ComponentDatatype.validate(import__24.ComponentDatatype.UNSIGNED_INT)).toBe(
      true
    );
    expect(import__24.ComponentDatatype.validate(import__24.ComponentDatatype.FLOAT)).toBe(true);
    expect(import__24.ComponentDatatype.validate(import__24.ComponentDatatype.DOUBLE)).toBe(true);
    expect(import__24.ComponentDatatype.validate(void 0)).toBe(false);
    expect(import__24.ComponentDatatype.validate({})).toBe(false);
  });
  it("createTypedArray works with size", function() {
    let typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.BYTE,
      0
    );
    expect(typedArray).toBeInstanceOf(Int8Array);
    expect(typedArray.length).toBe(0);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.UNSIGNED_BYTE,
      1
    );
    expect(typedArray).toBeInstanceOf(Uint8Array);
    expect(typedArray.length).toBe(1);
    typedArray = import__24.ComponentDatatype.createTypedArray(import__24.ComponentDatatype.SHORT, 2);
    expect(typedArray).toBeInstanceOf(Int16Array);
    expect(typedArray.length).toBe(2);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.UNSIGNED_SHORT,
      3
    );
    expect(typedArray).toBeInstanceOf(Uint16Array);
    expect(typedArray.length).toBe(3);
    typedArray = import__24.ComponentDatatype.createTypedArray(import__24.ComponentDatatype.INT, 4);
    expect(typedArray).toBeInstanceOf(Int32Array);
    expect(typedArray.length).toBe(4);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.UNSIGNED_INT,
      5
    );
    expect(typedArray).toBeInstanceOf(Uint32Array);
    expect(typedArray.length).toBe(5);
    typedArray = import__24.ComponentDatatype.createTypedArray(import__24.ComponentDatatype.FLOAT, 6);
    expect(typedArray).toBeInstanceOf(Float32Array);
    expect(typedArray.length).toBe(6);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.DOUBLE,
      7
    );
    expect(typedArray).toBeInstanceOf(Float64Array);
    expect(typedArray.length).toBe(7);
  });
  it("createTypedArray works with values", function() {
    const values = [34, 12, 4, 1];
    let typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.BYTE,
      values
    );
    expect(typedArray).toBeInstanceOf(Int8Array);
    expect(typedArray).toEqual(values);
    expect(typedArray.length).toBe(values.length);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.UNSIGNED_BYTE,
      values
    );
    expect(typedArray).toBeInstanceOf(Uint8Array);
    expect(typedArray).toEqual(values);
    expect(typedArray.length).toBe(values.length);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.SHORT,
      values
    );
    expect(typedArray).toBeInstanceOf(Int16Array);
    expect(typedArray).toEqual(values);
    expect(typedArray.length).toBe(values.length);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.UNSIGNED_SHORT,
      values
    );
    expect(typedArray).toBeInstanceOf(Uint16Array);
    expect(typedArray).toEqual(values);
    expect(typedArray.length).toBe(values.length);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.INT,
      values
    );
    expect(typedArray).toBeInstanceOf(Int32Array);
    expect(typedArray).toEqual(values);
    expect(typedArray.length).toBe(values.length);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.UNSIGNED_INT,
      values
    );
    expect(typedArray).toBeInstanceOf(Uint32Array);
    expect(typedArray).toEqual(values);
    expect(typedArray.length).toBe(values.length);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.FLOAT,
      values
    );
    expect(typedArray).toBeInstanceOf(Float32Array);
    expect(typedArray).toEqual(values);
    expect(typedArray.length).toBe(values.length);
    typedArray = import__24.ComponentDatatype.createTypedArray(
      import__24.ComponentDatatype.DOUBLE,
      values
    );
    expect(typedArray).toBeInstanceOf(Float64Array);
    expect(typedArray).toEqual(values);
    expect(typedArray.length).toBe(values.length);
  });
  it("createArrayBufferView works", function() {
    const buffer = new ArrayBuffer(100);
    expect(
      import__24.ComponentDatatype.createArrayBufferView(
        import__24.ComponentDatatype.BYTE,
        buffer,
        0,
        1
      )
    ).toBeInstanceOf(Int8Array);
    expect(
      import__24.ComponentDatatype.createArrayBufferView(
        import__24.ComponentDatatype.UNSIGNED_BYTE,
        buffer,
        0,
        1
      )
    ).toBeInstanceOf(Uint8Array);
    expect(
      import__24.ComponentDatatype.createArrayBufferView(
        import__24.ComponentDatatype.SHORT,
        buffer,
        0,
        1
      )
    ).toBeInstanceOf(Int16Array);
    expect(
      import__24.ComponentDatatype.createArrayBufferView(
        import__24.ComponentDatatype.UNSIGNED_SHORT,
        buffer,
        0,
        1
      )
    ).toBeInstanceOf(Uint16Array);
    expect(
      import__24.ComponentDatatype.createArrayBufferView(
        import__24.ComponentDatatype.INT,
        buffer,
        0,
        1
      )
    ).toBeInstanceOf(Int32Array);
    expect(
      import__24.ComponentDatatype.createArrayBufferView(
        import__24.ComponentDatatype.UNSIGNED_INT,
        buffer,
        0,
        1
      )
    ).toBeInstanceOf(Uint32Array);
    expect(
      import__24.ComponentDatatype.createArrayBufferView(
        import__24.ComponentDatatype.FLOAT,
        buffer,
        0,
        1
      )
    ).toBeInstanceOf(Float32Array);
    expect(
      import__24.ComponentDatatype.createArrayBufferView(
        import__24.ComponentDatatype.DOUBLE,
        buffer,
        0,
        1
      )
    ).toBeInstanceOf(Float64Array);
  });
  it("createTypedArray throws without type", function() {
    expect(function() {
      import__24.ComponentDatatype.createTypedArray(void 0, 1);
    }).toThrowDeveloperError();
  });
  it("createTypedArray throws without length or values", function() {
    expect(function() {
      import__24.ComponentDatatype.createTypedArray(import__24.ComponentDatatype.FLOAT, void 0);
    }).toThrowDeveloperError();
  });
  it("createArrayBufferView throws without type", function() {
    const buffer = new ArrayBuffer(100);
    expect(function() {
      import__24.ComponentDatatype.createTypedArray(void 0, buffer, 0, 1);
    }).toThrowDeveloperError();
  });
  it("createArrayBufferView throws with invalid type", function() {
    const buffer = new ArrayBuffer(100);
    expect(function() {
      import__24.ComponentDatatype.createTypedArray({}, buffer, 0, 1);
    }).toThrowDeveloperError();
  });
  it("createArrayBufferView throws without buffer", function() {
    expect(function() {
      import__24.ComponentDatatype.createTypedArray(
        import__24.ComponentDatatype.BYTE,
        void 0,
        0,
        1
      );
    }).toThrowDeveloperError();
  });
  it("fromName works", function() {
    expect(import__24.ComponentDatatype.fromName("BYTE")).toEqual(import__24.ComponentDatatype.BYTE);
    expect(import__24.ComponentDatatype.fromName("UNSIGNED_BYTE")).toEqual(
      import__24.ComponentDatatype.UNSIGNED_BYTE
    );
    expect(import__24.ComponentDatatype.fromName("SHORT")).toEqual(
      import__24.ComponentDatatype.SHORT
    );
    expect(import__24.ComponentDatatype.fromName("UNSIGNED_SHORT")).toEqual(
      import__24.ComponentDatatype.UNSIGNED_SHORT
    );
    expect(import__24.ComponentDatatype.fromName("INT")).toEqual(import__24.ComponentDatatype.INT);
    expect(import__24.ComponentDatatype.fromName("UNSIGNED_INT")).toEqual(
      import__24.ComponentDatatype.UNSIGNED_INT
    );
    expect(import__24.ComponentDatatype.fromName("FLOAT")).toEqual(
      import__24.ComponentDatatype.FLOAT
    );
    expect(import__24.ComponentDatatype.fromName("DOUBLE")).toEqual(
      import__24.ComponentDatatype.DOUBLE
    );
  });
  it("fromName throws without name", function() {
    expect(function() {
      import__24.ComponentDatatype.fromName();
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/ConstantSplineSpec.js
var import__25 = __toESM(require_Cesium(), 1);
describe("Core/ConstantSpline", function() {
  it("constructor throws without value", function() {
    expect(function() {
      return new import__25.ConstantSpline();
    }).toThrowDeveloperError();
  });
  it("constructor throws with invalid value type", function() {
    expect(function() {
      return new import__25.ConstantSpline({});
    }).toThrowDeveloperError();
  });
  it("value returns the input value", function() {
    const value = new import__25.Cartesian3(1, 2, 3);
    const spline = new import__25.ConstantSpline(value);
    expect(spline.value).toBe(value);
  });
  it("wrapTime returns constant value", function() {
    const spline = new import__25.ConstantSpline(10);
    expect(spline.wrapTime(-0.5)).toEqual(0);
    expect(spline.wrapTime(2.5)).toEqual(0);
  });
  it("clampTime returns constant value", function() {
    const spline = new import__25.ConstantSpline(10);
    expect(spline.clampTime(-0.5)).toEqual(0);
    expect(spline.clampTime(2.5)).toEqual(0);
  });
  it("wrapTime throws without a time", function() {
    const spline = new import__25.ConstantSpline(10);
    expect(function() {
      spline.wrapTime();
    }).toThrowDeveloperError();
  });
  it("clampTime throws without a time", function() {
    const spline = new import__25.ConstantSpline(10);
    expect(function() {
      spline.clampTime();
    }).toThrowDeveloperError();
  });
  it("findTimeInterval throws", function() {
    const spline = new import__25.ConstantSpline(10);
    expect(function() {
      spline.findTimeInterval(0);
    }).toThrowDeveloperError();
  });
  it("evaluate throws without time", function() {
    const spline = new import__25.ConstantSpline(10);
    expect(function() {
      spline.evaluate();
    }).toThrowDeveloperError();
  });
  it("evaluate returns number value", function() {
    const value = 10;
    const spline = new import__25.ConstantSpline(value);
    expect(spline.evaluate(0)).toEqual(value);
  });
  it("evaluate returns cartesian3 value", function() {
    const value = new import__25.Cartesian3(1, 2, 3);
    const spline = new import__25.ConstantSpline(value);
    const returnedValue = spline.evaluate(0);
    expect(value).toEqual(returnedValue);
  });
  it("evaluate returns cartesian3 value with result parameter", function() {
    const value = new import__25.Cartesian3(1, 2, 3);
    const spline = new import__25.ConstantSpline(value);
    const result = new import__25.Cartesian3();
    const returnedValue = spline.evaluate(0, result);
    expect(returnedValue).toBe(result);
    expect(value).toEqual(returnedValue);
  });
  it("evaluate returns quaternion value", function() {
    const value = new import__25.Quaternion(0.707, 0, 0.707, 1);
    const spline = new import__25.ConstantSpline(value);
    const returnedValue = spline.evaluate(0);
    expect(value).toEqual(returnedValue);
  });
  it("evaluate returns quaternion value with result parameter", function() {
    const value = new import__25.Quaternion(0.707, 0, 0.707, 1);
    const spline = new import__25.ConstantSpline(value);
    const result = new import__25.Quaternion();
    const returnedValue = spline.evaluate(0, result);
    expect(returnedValue).toBe(result);
    expect(value).toEqual(returnedValue);
  });
});

// packages/engine/Specs/Core/CoplanarPolygonGeometrySpec.js
var import__26 = __toESM(require_Cesium(), 1);
describe("Core/CoplanarPolygonGeometry", function() {
  it("throws with no hierarchy", function() {
    expect(function() {
      return new import__26.CoplanarPolygonGeometry();
    }).toThrowDeveloperError();
  });
  it("fromPositions throws without positions", function() {
    expect(function() {
      return import__26.CoplanarPolygonGeometry.fromPositions();
    }).toThrowDeveloperError();
  });
  it("returns undefined with less than 3 unique positions", function() {
    const geometry = import__26.CoplanarPolygonGeometry.createGeometry(
      import__26.CoplanarPolygonGeometry.fromPositions({
        positions: import__26.Cartesian3.fromDegreesArrayHeights([
          49,
          18,
          1e3,
          49,
          18,
          5e3,
          49,
          18,
          5e3,
          49,
          18,
          1e3
        ])
      })
    );
    expect(geometry).toBeUndefined();
  });
  it("returns undefined when positions are linear", function() {
    const geometry = import__26.CoplanarPolygonGeometry.createGeometry(
      import__26.CoplanarPolygonGeometry.fromPositions({
        positions: import__26.Cartesian3.fromDegreesArrayHeights([
          0,
          0,
          1,
          0,
          0,
          2,
          0,
          0,
          3
        ])
      })
    );
    expect(geometry).toBeUndefined();
  });
  it("createGeometry returns undefined due to duplicate hierarchy positions", function() {
    const hierarchy2 = {
      positions: import__26.Cartesian3.fromDegreesArray([1, 1, 1, 1, 1, 1]),
      holes: [
        {
          positions: import__26.Cartesian3.fromDegreesArray([
            0,
            0,
            0,
            0,
            0,
            0
          ])
        }
      ]
    };
    const geometry = import__26.CoplanarPolygonGeometry.createGeometry(
      new import__26.CoplanarPolygonGeometry({ polygonHierarchy: hierarchy2 })
    );
    expect(geometry).toBeUndefined();
  });
  it("computes positions", function() {
    const p = import__26.CoplanarPolygonGeometry.createGeometry(
      import__26.CoplanarPolygonGeometry.fromPositions({
        vertexFormat: import__26.VertexFormat.POSITION_ONLY,
        positions: import__26.Cartesian3.fromDegreesArrayHeights([
          -1,
          -1,
          0,
          -1,
          0,
          1,
          -1,
          1,
          1,
          -1,
          2,
          0
        ])
      })
    );
    expect(p.attributes.position.values.length).toEqual(4 * 3);
    expect(p.indices.length).toEqual(2 * 3);
  });
  it("computes all attributes", function() {
    const p = import__26.CoplanarPolygonGeometry.createGeometry(
      import__26.CoplanarPolygonGeometry.fromPositions({
        vertexFormat: import__26.VertexFormat.ALL,
        positions: import__26.Cartesian3.fromDegreesArrayHeights([
          -1,
          -1,
          0,
          -1,
          0,
          1,
          -1,
          1,
          1,
          -1,
          2,
          0
        ])
      })
    );
    const numVertices = 4;
    const numTriangles = 2;
    expect(p.attributes.position.values.length).toEqual(numVertices * 3);
    expect(p.attributes.st.values.length).toEqual(numVertices * 2);
    expect(p.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(p.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(p.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(p.indices.length).toEqual(numTriangles * 3);
  });
  it("flips normal to roughly match surface normal", function() {
    const p = import__26.CoplanarPolygonGeometry.createGeometry(
      import__26.CoplanarPolygonGeometry.fromPositions({
        vertexFormat: import__26.VertexFormat.ALL,
        positions: import__26.Cartesian3.fromDegreesArrayHeights([
          90,
          -1,
          0,
          90,
          1,
          0,
          92,
          1,
          0,
          92,
          -1,
          0
        ])
      })
    );
    const center = import__26.Cartesian3.fromDegrees(91, 0);
    const expectedNormal = import__26.Ellipsoid.WGS84.geodeticSurfaceNormal(center);
    const actual = import__26.Cartesian3.unpack(p.attributes.normal.values);
    expect(expectedNormal).toEqualEpsilon(actual, import__26.Math.EPSILON6);
  });
  const positions = import__26.Cartesian3.fromDegreesArray([
    -12.4,
    3.5,
    -12,
    3.5,
    -12,
    4
  ]);
  const holePositions0 = import__26.Cartesian3.fromDegreesArray([
    -12.2,
    3.5,
    -12.2,
    3.6,
    -12.3,
    3.6
  ]);
  const holePositions1 = import__26.Cartesian3.fromDegreesArray([
    -12.2,
    3.5,
    -12.25,
    3.5,
    -12.25,
    3.55
  ]);
  const hierarchy = {
    positions,
    holes: [
      {
        positions: holePositions0,
        holes: [
          {
            positions: holePositions1,
            holes: void 0
          }
        ]
      }
    ]
  };
  const polygon = new import__26.CoplanarPolygonGeometry({
    vertexFormat: import__26.VertexFormat.POSITION_ONLY,
    polygonHierarchy: hierarchy
  });
  function addPositions(array, positions2) {
    for (let i = 0; i < positions2.length; ++i) {
      array.push(positions2[i].x, positions2[i].y, positions2[i].z);
    }
  }
  function addPositions2D(array, positions2) {
    for (let i = 0; i < positions2.length; ++i) {
      array.push(positions2[i].x, positions2[i].y);
    }
  }
  const packedInstance = [3, 1];
  addPositions(packedInstance, positions);
  packedInstance.push(3, 1);
  addPositions(packedInstance, holePositions0);
  packedInstance.push(3, 0);
  addPositions(packedInstance, holePositions1);
  packedInstance.push(
    import__26.Ellipsoid.WGS84.radii.x,
    import__26.Ellipsoid.WGS84.radii.y,
    import__26.Ellipsoid.WGS84.radii.z
  );
  packedInstance.push(1, 0, 0, 0, 0, 0, 0, -1, 45);
  createPackableSpecs_default(import__26.CoplanarPolygonGeometry, polygon, packedInstance);
  const textureCoordinates = {
    positions: [
      new import__26.Cartesian2(0, 0),
      new import__26.Cartesian2(1, 0),
      new import__26.Cartesian2(0, 1),
      new import__26.Cartesian2(0.1, 0.1),
      new import__26.Cartesian2(0.5, 0.1),
      new import__26.Cartesian2(0.1, 0.5),
      new import__26.Cartesian2(0.2, 0.2),
      new import__26.Cartesian2(0.3, 0.2),
      new import__26.Cartesian2(0.2, 0.3)
    ],
    holes: void 0
  };
  const polygonTextured = new import__26.CoplanarPolygonGeometry({
    vertexFormat: import__26.VertexFormat.POSITION_ONLY,
    polygonHierarchy: hierarchy,
    textureCoordinates
  });
  const packedInstanceTextured = [3, 1];
  addPositions(packedInstanceTextured, positions);
  packedInstanceTextured.push(3, 1);
  addPositions(packedInstanceTextured, holePositions0);
  packedInstanceTextured.push(3, 0);
  addPositions(packedInstanceTextured, holePositions1);
  packedInstanceTextured.push(
    import__26.Ellipsoid.WGS84.radii.x,
    import__26.Ellipsoid.WGS84.radii.y,
    import__26.Ellipsoid.WGS84.radii.z
  );
  packedInstanceTextured.push(1, 0, 0, 0, 0, 0, 0);
  packedInstanceTextured.push(9, 0);
  addPositions2D(packedInstanceTextured, textureCoordinates.positions);
  packedInstanceTextured.push(64);
  createPackableSpecs_default(
    import__26.CoplanarPolygonGeometry,
    polygonTextured,
    packedInstanceTextured
  );
});

// packages/engine/Specs/Core/CoplanarPolygonOutlineGeometrySpec.js
var import__27 = __toESM(require_Cesium(), 1);
describe("Core/CoplanarPolygonOutlineGeometry", function() {
  it("throws with no hierarchy", function() {
    expect(function() {
      return new import__27.CoplanarPolygonOutlineGeometry();
    }).toThrowDeveloperError();
  });
  it("fromPositions throws without positions", function() {
    expect(function() {
      return import__27.CoplanarPolygonOutlineGeometry.fromPositions();
    }).toThrowDeveloperError();
  });
  it("returns undefined with less than 3 unique positions", function() {
    const geometry = import__27.CoplanarPolygonOutlineGeometry.createGeometry(
      import__27.CoplanarPolygonOutlineGeometry.fromPositions({
        positions: import__27.Cartesian3.fromDegreesArrayHeights([
          49,
          18,
          1e3,
          49,
          18,
          5e3,
          49,
          18,
          5e3,
          49,
          18,
          1e3
        ])
      })
    );
    expect(geometry).toBeUndefined();
  });
  it("returns undefined when positions are linear", function() {
    const geometry = import__27.CoplanarPolygonOutlineGeometry.createGeometry(
      import__27.CoplanarPolygonOutlineGeometry.fromPositions({
        positions: import__27.Cartesian3.fromDegreesArrayHeights([
          0,
          0,
          1,
          0,
          0,
          2,
          0,
          0,
          3
        ])
      })
    );
    expect(geometry).toBeUndefined();
  });
  it("createGeometry returns undefined due to duplicate hierarchy positions", function() {
    const hierarchy2 = {
      positions: import__27.Cartesian3.fromDegreesArray([1, 1, 1, 1, 1, 1]),
      holes: [
        {
          positions: import__27.Cartesian3.fromDegreesArray([
            0,
            0,
            0,
            0,
            0,
            0
          ])
        }
      ]
    };
    const geometry = import__27.CoplanarPolygonOutlineGeometry.createGeometry(
      new import__27.CoplanarPolygonOutlineGeometry({ polygonHierarchy: hierarchy2 })
    );
    expect(geometry).toBeUndefined();
  });
  it("creates positions", function() {
    const geometry = import__27.CoplanarPolygonOutlineGeometry.createGeometry(
      import__27.CoplanarPolygonOutlineGeometry.fromPositions({
        positions: import__27.Cartesian3.fromDegreesArrayHeights([
          -1,
          -1,
          0,
          -1,
          0,
          1,
          -1,
          1,
          1,
          -1,
          2,
          0
        ])
      })
    );
    expect(geometry.attributes.position.values.length).toEqual(4 * 3);
    expect(geometry.indices.length).toEqual(4 * 2);
  });
  const positions = import__27.Cartesian3.fromDegreesArray([
    -124,
    35,
    -110,
    35,
    -110,
    40
  ]);
  const holePositions0 = import__27.Cartesian3.fromDegreesArray([
    -122,
    36,
    -122,
    39,
    -112,
    39
  ]);
  const holePositions1 = import__27.Cartesian3.fromDegreesArray([
    -120,
    36.5,
    -114,
    36.5,
    -114,
    38.5
  ]);
  const hierarchy = {
    positions,
    holes: [
      {
        positions: holePositions0,
        holes: [
          {
            positions: holePositions1,
            holes: void 0
          }
        ]
      }
    ]
  };
  const polygon = new import__27.CoplanarPolygonOutlineGeometry({
    polygonHierarchy: hierarchy
  });
  function addPositions(array, positions2) {
    for (let i = 0; i < positions2.length; ++i) {
      array.push(positions2[i].x, positions2[i].y, positions2[i].z);
    }
  }
  const packedInstance = [3, 1];
  addPositions(packedInstance, positions);
  packedInstance.push(3, 1);
  addPositions(packedInstance, holePositions0);
  packedInstance.push(3, 0);
  addPositions(packedInstance, holePositions1);
  packedInstance.push(34);
  createPackableSpecs_default(import__27.CoplanarPolygonOutlineGeometry, polygon, packedInstance);
});

// packages/engine/Specs/Core/CorridorGeometrySpec.js
var import__28 = __toESM(require_Cesium(), 1);
describe("Core/CorridorGeometry", function() {
  it("throws without positions", function() {
    expect(function() {
      return new import__28.CorridorGeometry({});
    }).toThrowDeveloperError();
  });
  it("throws without width", function() {
    expect(function() {
      return new import__28.CorridorGeometry({
        positions: [new import__28.Cartesian3()]
      });
    }).toThrowDeveloperError();
  });
  it("createGeometry returns undefined without 2 unique positions", function() {
    let geometry = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        positions: import__28.Cartesian3.fromDegreesArray([90, -30, 90, -30]),
        width: 1e4
      })
    );
    expect(geometry).toBeUndefined();
    geometry = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        positions: [
          new import__28.Cartesian3(
            -1349511388149118e-9,
            -506397322857992e-8,
            3.6231416372688496e6
          ),
          //same lon/lat, different height
          new import__28.Cartesian3(
            -1.3490464811926484e6,
            -5062228688739784e-9,
            3.6218850521561056e6
          )
        ],
        width: 1e4
      })
    );
    expect(geometry).toBeUndefined();
  });
  it("computes positions", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4
      })
    );
    const numVertices = 12;
    const numTriangles = 10;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("compute all vertex attributes", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.ALL,
        positions: import__28.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4
      })
    );
    const numVertices = 12;
    const numTriangles = 10;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes positions extruded", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4,
        extrudedHeight: 3e4
      })
    );
    const numVertices = 72;
    const numTriangles = 44;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("compute all vertex attributes extruded", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.ALL,
        positions: import__28.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4,
        extrudedHeight: 3e4
      })
    );
    const numVertices = 72;
    const numTriangles = 44;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes offset attribute", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4,
        offsetAttribute: import__28.GeometryOffsetAttribute.TOP
      })
    );
    const numVertices = 12;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes offset attribute extruded for top vertices", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4,
        extrudedHeight: 3e4,
        offsetAttribute: import__28.GeometryOffsetAttribute.TOP
      })
    );
    const numVertices = 72;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(0).fill(1, 0, 12).fill(1, 24, 48);
    expect(offset).toEqual(expected);
  });
  it("computes offset attribute extruded for all vertices", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4,
        extrudedHeight: 3e4,
        offsetAttribute: import__28.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 72;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes right turn", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([
          90,
          -30,
          90,
          -31,
          91,
          -31
        ]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(6 * 3);
  });
  it("computes left turn", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([
          90,
          -30,
          90,
          -31,
          89,
          -31
        ]),
        cornerType: import__28.CornerType.MITERED,
        width: 3e4
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(6 * 3);
  });
  it("computes with rounded corners", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_AND_ST,
        positions: import__28.Cartesian3.fromDegreesArray([
          90,
          -30,
          90,
          -31,
          89,
          -31,
          89,
          -32
        ]),
        cornerType: import__28.CornerType.ROUNDED,
        width: 3e4
      })
    );
    const endCaps = 72;
    const corners = 37;
    const numVertices = 10 + endCaps + corners;
    const numTriangles = 8 + endCaps + corners;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes with beveled corners", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([
          90,
          -30,
          90,
          -31,
          89,
          -31,
          89,
          -32
        ]),
        cornerType: import__28.CornerType.BEVELED,
        width: 3e4
      })
    );
    expect(m.attributes.position.values.length).toEqual(10 * 3);
    expect(m.indices.length).toEqual(8 * 3);
  });
  it("computes sharp turns", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([
          2.00571672577652,
          52.7781459942399,
          1.99188457974115,
          52.7764958852886,
          2.01325961458495,
          52.7674170680511,
          1.98708058340534,
          52.7733979856253,
          2.00634853946644,
          52.7650460748473
        ]),
        cornerType: import__28.CornerType.BEVELED,
        width: 100
      })
    );
    expect(m.attributes.position.values.length).toEqual(13 * 3);
    expect(m.indices.length).toEqual(11 * 3);
  });
  it("computes straight corridors", function() {
    const m = import__28.CorridorGeometry.createGeometry(
      new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([
          -67.655,
          0,
          -67.655,
          15,
          -67.655,
          20
        ]),
        cornerType: import__28.CornerType.BEVELED,
        width: 4e5,
        granularity: Math.PI / 6
      })
    );
    expect(m.attributes.position.values.length).toEqual(4 * 3);
    expect(m.indices.length).toEqual(2 * 3);
  });
  it(
    "undefined is returned if there are less than two positions or the width is equal to or less than zero",
    function() {
      const corridor0 = new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([-72, 35]),
        width: 1e5
      });
      const corridor1 = new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([
          -67.655,
          0,
          -67.655,
          15,
          -67.655,
          20
        ]),
        width: 0
      });
      const corridor2 = new import__28.CorridorGeometry({
        vertexFormat: import__28.VertexFormat.POSITION_ONLY,
        positions: import__28.Cartesian3.fromDegreesArray([
          -67.655,
          0,
          -67.655,
          15,
          -67.655,
          20
        ]),
        width: -100
      });
      const geometry0 = import__28.CorridorGeometry.createGeometry(corridor0);
      const geometry1 = import__28.CorridorGeometry.createGeometry(corridor1);
      const geometry2 = import__28.CorridorGeometry.createGeometry(corridor2);
      expect(geometry0).toBeUndefined();
      expect(geometry1).toBeUndefined();
      expect(geometry2).toBeUndefined();
    }
  );
  it("computing rectangle property", function() {
    const c = new import__28.CorridorGeometry({
      vertexFormat: import__28.VertexFormat.POSITION_ONLY,
      positions: import__28.Cartesian3.fromDegreesArray([
        -67.655,
        0,
        -67.655,
        15,
        -67.655,
        20
      ]),
      cornerType: import__28.CornerType.MITERED,
      width: 1,
      granularity: Math.PI / 6
    });
    const r = c.rectangle;
    expect(import__28.Math.toDegrees(r.north)).toEqualEpsilon(
      20,
      import__28.Math.EPSILON13
    );
    expect(import__28.Math.toDegrees(r.south)).toEqualEpsilon(
      0,
      import__28.Math.EPSILON20
    );
    expect(import__28.Math.toDegrees(r.east)).toEqual(-67.65499522658291);
    expect(import__28.Math.toDegrees(r.west)).toEqual(-67.6550047734171);
  });
  it("computeRectangle", function() {
    const options = {
      vertexFormat: import__28.VertexFormat.POSITION_ONLY,
      positions: import__28.Cartesian3.fromDegreesArray([
        -67.655,
        0,
        -67.655,
        15,
        -67.655,
        20
      ]),
      cornerType: import__28.CornerType.MITERED,
      width: 1
    };
    const geometry = new import__28.CorridorGeometry(options);
    const expected = geometry.rectangle;
    const result = import__28.CorridorGeometry.computeRectangle(options);
    expect(result).toEqual(expected);
  });
  it("computeRectangle with result parameter", function() {
    const options = {
      positions: import__28.Cartesian3.fromDegreesArray([
        72,
        0,
        85,
        15,
        83,
        20
      ]),
      width: 5
    };
    const geometry = new import__28.CorridorGeometry(options);
    const result = new import__28.Rectangle();
    const expected = geometry.rectangle;
    const returned = import__28.CorridorGeometry.computeRectangle(options, result);
    expect(returned).toEqual(expected);
    expect(returned).toBe(result);
  });
  it("computing textureCoordinateRotationPoints property", function() {
    const c = new import__28.CorridorGeometry({
      vertexFormat: import__28.VertexFormat.POSITION_ONLY,
      positions: import__28.Cartesian3.fromDegreesArray([
        -67.655,
        0,
        -67.655,
        15,
        -67.655,
        20
      ]),
      cornerType: import__28.CornerType.MITERED,
      width: 1,
      granularity: Math.PI / 6
    });
    const textureCoordinateRotationPoints = c.textureCoordinateRotationPoints;
    expect(textureCoordinateRotationPoints.length).toEqual(6);
    expect(textureCoordinateRotationPoints[0]).toEqualEpsilon(
      0,
      import__28.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[1]).toEqualEpsilon(
      0,
      import__28.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[2]).toEqualEpsilon(
      0,
      import__28.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[3]).toEqualEpsilon(
      1,
      import__28.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[4]).toEqualEpsilon(
      1,
      import__28.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[5]).toEqualEpsilon(
      0,
      import__28.Math.EPSILON7
    );
  });
  const positions = import__28.Cartesian3.fromDegreesArray([90, -30, 90, -31]);
  const corridor = new import__28.CorridorGeometry({
    vertexFormat: import__28.VertexFormat.POSITION_ONLY,
    positions,
    cornerType: import__28.CornerType.BEVELED,
    width: 3e4,
    granularity: 0.1
  });
  const packedInstance = [
    2,
    positions[0].x,
    positions[0].y,
    positions[0].z,
    positions[1].x,
    positions[1].y,
    positions[1].z
  ];
  packedInstance.push(
    import__28.Ellipsoid.WGS84.radii.x,
    import__28.Ellipsoid.WGS84.radii.y,
    import__28.Ellipsoid.WGS84.radii.z
  );
  packedInstance.push(1, 0, 0, 0, 0, 0);
  packedInstance.push(3e4, 0, 0, 2, 0.1, 0, -1);
  createPackableSpecs_default(import__28.CorridorGeometry, corridor, packedInstance);
});

// packages/engine/Specs/Core/CorridorOutlineGeometrySpec.js
var import__29 = __toESM(require_Cesium(), 1);
describe("Core/CorridorOutlineGeometry", function() {
  it("throws without positions", function() {
    expect(function() {
      return new import__29.CorridorOutlineGeometry({});
    }).toThrowDeveloperError();
  });
  it("throws without width", function() {
    expect(function() {
      return new import__29.CorridorOutlineGeometry({
        positions: [new import__29.Cartesian3()]
      });
    }).toThrowDeveloperError();
  });
  it("createGeometry returns undefined without 2 unique positions", function() {
    let geometry = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([90, -30, 90, -30]),
        width: 1e4
      })
    );
    expect(geometry).toBeUndefined();
    geometry = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: [
          new import__29.Cartesian3(
            -1349511388149118e-9,
            -506397322857992e-8,
            3.6231416372688496e6
          ),
          //same lon/lat, different height
          new import__29.Cartesian3(
            -1.3490464811926484e6,
            -5062228688739784e-9,
            3.6218850521561056e6
          )
        ],
        width: 1e4
      })
    );
    expect(geometry).toBeUndefined();
  });
  it("computes positions", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__29.CornerType.MITERED,
        width: 3e4
      })
    );
    expect(m.attributes.position.values.length).toEqual(12 * 3);
    expect(m.indices.length).toEqual(12 * 2);
  });
  it("computes positions extruded", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__29.CornerType.MITERED,
        width: 3e4,
        extrudedHeight: 3e4
      })
    );
    expect(m.attributes.position.values.length).toEqual(24 * 3);
    expect(m.indices.length).toEqual(28 * 2);
  });
  it("computes offset attribute for top vertices", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__29.CornerType.MITERED,
        width: 3e4,
        offsetAttribute: import__29.GeometryOffsetAttribute.TOP
      })
    );
    const numVertices = 12;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes offset attribute extruded for top vertices", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__29.CornerType.MITERED,
        width: 3e4,
        extrudedHeight: 3e4,
        offsetAttribute: import__29.GeometryOffsetAttribute.TOP
      })
    );
    const numVertices = 24;
    expect(m.attributes.position.values.length).toEqual(24 * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(0).fill(1, 0, 12);
    expect(offset).toEqual(expected);
  });
  it("computes offset attribute extruded for all vertices", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([90, -30, 90, -35]),
        cornerType: import__29.CornerType.MITERED,
        width: 3e4,
        extrudedHeight: 3e4,
        offsetAttribute: import__29.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 24;
    expect(m.attributes.position.values.length).toEqual(24 * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes right turn", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([
          90,
          -30,
          90,
          -31,
          91,
          -31
        ]),
        cornerType: import__29.CornerType.MITERED,
        width: 3e4
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(8 * 2);
  });
  it("computes left turn", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([
          90,
          -30,
          90,
          -31,
          89,
          -31
        ]),
        cornerType: import__29.CornerType.MITERED,
        width: 3e4
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(8 * 2);
  });
  it("computes with rounded corners", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([
          90,
          -30,
          90,
          -31,
          89,
          -31,
          89,
          -32
        ]),
        cornerType: import__29.CornerType.ROUNDED,
        width: 3e4
      })
    );
    const endCaps = 72;
    const corners = 37;
    const numVertices = 10 + endCaps + corners;
    const numLines = 10 + endCaps + corners;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numLines * 2);
  });
  it("computes with beveled corners", function() {
    const m = import__29.CorridorOutlineGeometry.createGeometry(
      new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([
          90,
          -30,
          90,
          -31,
          89,
          -31,
          89,
          -32
        ]),
        cornerType: import__29.CornerType.BEVELED,
        width: 3e4
      })
    );
    expect(m.attributes.position.values.length).toEqual(10 * 3);
    expect(m.indices.length).toEqual(10 * 2);
  });
  it(
    "undefined is returned if there are less than two positions or the width is equal to or less than zero",
    function() {
      const corridorOutline0 = new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([-72, 35]),
        width: 1e5
      });
      const corridorOutline1 = new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([
          -67.655,
          0,
          -67.655,
          15,
          -67.655,
          20
        ]),
        width: 0
      });
      const corridorOutline2 = new import__29.CorridorOutlineGeometry({
        positions: import__29.Cartesian3.fromDegreesArray([
          -67.655,
          0,
          -67.655,
          15,
          -67.655,
          20
        ]),
        width: -100
      });
      const geometry0 = import__29.CorridorOutlineGeometry.createGeometry(
        corridorOutline0
      );
      const geometry1 = import__29.CorridorOutlineGeometry.createGeometry(
        corridorOutline1
      );
      const geometry2 = import__29.CorridorOutlineGeometry.createGeometry(
        corridorOutline2
      );
      expect(geometry0).toBeUndefined();
      expect(geometry1).toBeUndefined();
      expect(geometry2).toBeUndefined();
    }
  );
  const positions = import__29.Cartesian3.fromDegreesArray([90, -30, 90, -31]);
  const corridor = new import__29.CorridorOutlineGeometry({
    positions,
    cornerType: import__29.CornerType.BEVELED,
    width: 3e4,
    granularity: 0.1
  });
  const packedInstance = [
    2,
    positions[0].x,
    positions[0].y,
    positions[0].z,
    positions[1].x,
    positions[1].y,
    positions[1].z
  ];
  packedInstance.push(
    import__29.Ellipsoid.WGS84.radii.x,
    import__29.Ellipsoid.WGS84.radii.y,
    import__29.Ellipsoid.WGS84.radii.z
  );
  packedInstance.push(3e4, 0, 0, 2, 0.1, -1);
  createPackableSpecs_default(import__29.CorridorOutlineGeometry, corridor, packedInstance);
});

// packages/engine/Specs/Core/CubicRealPolynomialSpec.js
var import__30 = __toESM(require_Cesium(), 1);
describe("Core/CubicRealPolynomial", function() {
  it("discriminant throws without a", function() {
    expect(function() {
      import__30.CubicRealPolynomial.computeDiscriminant();
    }).toThrowDeveloperError();
  });
  it("discriminant throws without b", function() {
    expect(function() {
      import__30.CubicRealPolynomial.computeDiscriminant(1);
    }).toThrowDeveloperError();
  });
  it("discriminant throws without c", function() {
    expect(function() {
      import__30.CubicRealPolynomial.computeDiscriminant(1, 1);
    }).toThrowDeveloperError();
  });
  it("discriminant throws without d", function() {
    expect(function() {
      import__30.CubicRealPolynomial.computeDiscriminant(1, 1, 1);
    }).toThrowDeveloperError();
  });
  it("discriminant", function() {
    const a = 3;
    const b = 2;
    const c = 1;
    const d = 1;
    const expected = b * b * c * c - 4 * a * c * c * c - 4 * b * b * b * d - 27 * a * a * d * d + 18 * a * b * c * d;
    const actual = import__30.CubicRealPolynomial.computeDiscriminant(a, b, c, d);
    expect(actual).toEqualEpsilon(expected, import__30.Math.EPSILON14);
  });
  it("real roots throws without a", function() {
    expect(function() {
      import__30.CubicRealPolynomial.computeRealRoots();
    }).toThrowDeveloperError();
  });
  it("real roots throws without b", function() {
    expect(function() {
      import__30.CubicRealPolynomial.computeRealRoots(1);
    }).toThrowDeveloperError();
  });
  it("real roots throws without c", function() {
    expect(function() {
      import__30.CubicRealPolynomial.computeRealRoots(1, 1);
    }).toThrowDeveloperError();
  });
  it("real roots throws without d", function() {
    expect(function() {
      import__30.CubicRealPolynomial.computeRealRoots(1, 1, 1);
    }).toThrowDeveloperError();
  });
  it("three repeated roots", function() {
    const roots = import__30.CubicRealPolynomial.computeRealRoots(2, -12, 24, -16);
    expect(roots.length).toEqual(3);
    expect(roots[0]).toEqualEpsilon(2, import__30.Math.EPSILON15);
    expect(roots[1]).toEqualEpsilon(2, import__30.Math.EPSILON15);
    expect(roots[2]).toEqualEpsilon(2, import__30.Math.EPSILON15);
  });
  it("one unique and two repeated roots", function() {
    const roots = import__30.CubicRealPolynomial.computeRealRoots(2, 2, -2, -2);
    expect(roots.length).toEqual(3);
    expect(roots[0]).toEqualEpsilon(-1, import__30.Math.EPSILON15);
    expect(roots[1]).toEqualEpsilon(-1, import__30.Math.EPSILON15);
    expect(roots[2]).toEqualEpsilon(1, import__30.Math.EPSILON15);
  });
  it("three unique roots", function() {
    const roots = import__30.CubicRealPolynomial.computeRealRoots(2, 6, -26, -30);
    expect(roots.length).toEqual(3);
    expect(roots[0]).toEqualEpsilon(-5, import__30.Math.EPSILON15);
    expect(roots[1]).toEqualEpsilon(-1, import__30.Math.EPSILON15);
    expect(roots[2]).toEqualEpsilon(3, import__30.Math.EPSILON15);
  });
  it("complex roots", function() {
    const roots = import__30.CubicRealPolynomial.computeRealRoots(2, -6, 10, -6);
    expect(roots.length).toEqual(1);
    expect(roots[0]).toEqualEpsilon(1, import__30.Math.EPSILON15);
  });
  it("quadratic case", function() {
    const roots = import__30.CubicRealPolynomial.computeRealRoots(0, 2, -4, -6);
    expect(roots.length).toEqual(2);
    expect(roots[0]).toEqual(-1);
    expect(roots[1]).toEqual(3);
  });
  it("deflated case", function() {
    let roots = import__30.CubicRealPolynomial.computeRealRoots(1, 0, 1, 2);
    expect(roots.length).toEqual(1);
    expect(roots[0]).toEqualEpsilon(-1, import__30.Math.EPSILON14);
    roots = import__30.CubicRealPolynomial.computeRealRoots(1, 0, 0, -8);
    expect(roots.length).toEqual(3);
    expect(roots[0]).toEqualEpsilon(2, import__30.Math.EPSILON14);
    roots = import__30.CubicRealPolynomial.computeRealRoots(1, 0, -1, 0);
    expect(roots.length).toEqual(3);
    expect(roots[0]).toEqual(-1);
    expect(roots[1]).toEqual(0);
    expect(roots[2]).toEqual(1);
    roots = import__30.CubicRealPolynomial.computeRealRoots(1, 1, 0, 0);
    expect(roots.length).toEqual(3);
    expect(roots[0]).toEqual(-1);
    expect(roots[1]).toEqual(0);
    expect(roots[2]).toEqual(0);
    roots = import__30.CubicRealPolynomial.computeRealRoots(1, -1, 0, 0);
    expect(roots.length).toEqual(3);
    expect(roots[0]).toEqual(0);
    expect(roots[1]).toEqual(0);
    expect(roots[2]).toEqual(1);
    roots = import__30.CubicRealPolynomial.computeRealRoots(1, 1, 1, 0);
    expect(roots.length).toEqual(1);
    expect(roots[0]).toEqual(0);
  });
});

// packages/engine/Specs/Core/CullingVolumeSpec.js
var import__31 = __toESM(require_Cesium(), 1);
describe("Core/CullingVolume", function() {
  let cullingVolume;
  beforeEach(function() {
    const frustum = new import__31.PerspectiveFrustum();
    frustum.near = 1;
    frustum.far = 2;
    frustum.fov = Math.PI / 3;
    frustum.aspectRatio = 1;
    cullingVolume = frustum.computeCullingVolume(
      new import__31.Cartesian3(),
      import__31.Cartesian3.negate(import__31.Cartesian3.UNIT_Z, new import__31.Cartesian3()),
      import__31.Cartesian3.UNIT_Y
    );
  });
  it("computeVisibility throws without a bounding volume", function() {
    expect(function() {
      return new import__31.CullingVolume().computeVisibility();
    }).toThrowDeveloperError();
  });
  it("computeVisibilityWithPlaneMask throws without a bounding volume", function() {
    expect(function() {
      return new import__31.CullingVolume().computeVisibilityWithPlaneMask(
        void 0,
        import__31.CullingVolume.MASK_INDETERMINATE
      );
    }).toThrowDeveloperError();
  });
  it("computeVisibilityWithPlaneMask throws without a parent plane mask", function() {
    expect(function() {
      return new import__31.CullingVolume().computeVisibilityWithPlaneMask(
        new import__31.BoundingSphere(),
        void 0
      );
    }).toThrowDeveloperError();
  });
  function testWithAndWithoutPlaneMask(culling, bound, intersect) {
    expect(culling.computeVisibility(bound)).toEqual(intersect);
    const mask = culling.computeVisibilityWithPlaneMask(
      bound,
      import__31.CullingVolume.MASK_INDETERMINATE
    );
    if (intersect === import__31.Intersect.INSIDE) {
      expect(mask).toEqual(import__31.CullingVolume.MASK_INSIDE);
    } else if (intersect === import__31.Intersect.OUTSIDE) {
      expect(mask).toEqual(import__31.CullingVolume.MASK_OUTSIDE);
    } else {
      expect(mask).not.toEqual(import__31.CullingVolume.MASK_INSIDE);
      expect(mask).not.toEqual(import__31.CullingVolume.MASK_OUTSIDE);
    }
    expect(culling.computeVisibilityWithPlaneMask(bound, mask)).toEqual(mask);
  }
  describe("box intersections", function() {
    it("can contain an axis aligned bounding box", function() {
      const box1 = import__31.AxisAlignedBoundingBox.fromPoints([
        new import__31.Cartesian3(-0.5, 0, -1.25),
        new import__31.Cartesian3(0.5, 0, -1.25),
        new import__31.Cartesian3(-0.5, 0, -1.75),
        new import__31.Cartesian3(0.5, 0, -1.75)
      ]);
      testWithAndWithoutPlaneMask(cullingVolume, box1, import__31.Intersect.INSIDE);
    });
    describe("can partially contain an axis aligned bounding box", function() {
      it("on the far plane", function() {
        const box2 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-0.5, 0, -1.5),
          new import__31.Cartesian3(0.5, 0, -1.5),
          new import__31.Cartesian3(-0.5, 0, -2.5),
          new import__31.Cartesian3(0.5, 0, -2.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          box2,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the near plane", function() {
        const box3 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-0.5, 0, -0.5),
          new import__31.Cartesian3(0.5, 0, -0.5),
          new import__31.Cartesian3(-0.5, 0, -1.5),
          new import__31.Cartesian3(0.5, 0, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          box3,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the left plane", function() {
        const box4 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-1.5, 0, -1.25),
          new import__31.Cartesian3(0, 0, -1.25),
          new import__31.Cartesian3(-1.5, 0, -1.5),
          new import__31.Cartesian3(0, 0, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          box4,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the right plane", function() {
        const box5 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(0, 0, -1.25),
          new import__31.Cartesian3(1.5, 0, -1.25),
          new import__31.Cartesian3(0, 0, -1.5),
          new import__31.Cartesian3(1.5, 0, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          box5,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the top plane", function() {
        const box6 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-0.5, 0, -1.25),
          new import__31.Cartesian3(0.5, 0, -1.25),
          new import__31.Cartesian3(-0.5, 2, -1.75),
          new import__31.Cartesian3(0.5, 2, -1.75)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          box6,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the bottom plane", function() {
        const box7 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-0.5, -2, -1.25),
          new import__31.Cartesian3(0.5, 0, -1.25),
          new import__31.Cartesian3(-0.5, -2, -1.5),
          new import__31.Cartesian3(0.5, 0, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          box7,
          import__31.Intersect.INTERSECTING
        );
      });
    });
    describe("can not contain an axis aligned bounding box", function() {
      it("past the far plane", function() {
        const box8 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-0.5, 0, -2.25),
          new import__31.Cartesian3(0.5, 0, -2.25),
          new import__31.Cartesian3(-0.5, 0, -2.75),
          new import__31.Cartesian3(0.5, 0, -2.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, box8, import__31.Intersect.OUTSIDE);
      });
      it("before the near plane", function() {
        const box9 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-0.5, 0, -0.25),
          new import__31.Cartesian3(0.5, 0, -0.25),
          new import__31.Cartesian3(-0.5, 0, -0.75),
          new import__31.Cartesian3(0.5, 0, -0.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, box9, import__31.Intersect.OUTSIDE);
      });
      it("past the left plane", function() {
        const box10 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-5, 0, -1.25),
          new import__31.Cartesian3(-3, 0, -1.25),
          new import__31.Cartesian3(-5, 0, -1.75),
          new import__31.Cartesian3(-3, 0, -1.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, box10, import__31.Intersect.OUTSIDE);
      });
      it("past the right plane", function() {
        const box11 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(3, 0, -1.25),
          new import__31.Cartesian3(5, 0, -1.25),
          new import__31.Cartesian3(3, 0, -1.75),
          new import__31.Cartesian3(5, 0, -1.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, box11, import__31.Intersect.OUTSIDE);
      });
      it("past the top plane", function() {
        const box12 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-0.5, 3, -1.25),
          new import__31.Cartesian3(0.5, 3, -1.25),
          new import__31.Cartesian3(-0.5, 5, -1.75),
          new import__31.Cartesian3(0.5, 5, -1.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, box12, import__31.Intersect.OUTSIDE);
      });
      it("past the bottom plane", function() {
        const box13 = import__31.AxisAlignedBoundingBox.fromPoints([
          new import__31.Cartesian3(-0.5, -3, -1.25),
          new import__31.Cartesian3(0.5, -3, -1.25),
          new import__31.Cartesian3(-0.5, -5, -1.75),
          new import__31.Cartesian3(0.5, -5, -1.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, box13, import__31.Intersect.OUTSIDE);
      });
    });
  });
  describe("sphere intersection", function() {
    it("can contain a sphere", function() {
      const sphere1 = import__31.BoundingSphere.fromPoints([
        new import__31.Cartesian3(0, 0, -1.25),
        new import__31.Cartesian3(0, 0, -1.75)
      ]);
      testWithAndWithoutPlaneMask(cullingVolume, sphere1, import__31.Intersect.INSIDE);
    });
    describe("can partially contain a sphere", function() {
      it("on the far plane", function() {
        const sphere2 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(0, 0, -1.5),
          new import__31.Cartesian3(0, 0, -2.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          sphere2,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the near plane", function() {
        const sphere3 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(0, 0, -0.5),
          new import__31.Cartesian3(0, 0, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          sphere3,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the left plane", function() {
        const sphere4 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(-1, 0, -1.5),
          new import__31.Cartesian3(0, 0, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          sphere4,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the right plane", function() {
        const sphere5 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(0, 0, -1.5),
          new import__31.Cartesian3(1, 0, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          sphere5,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the top plane", function() {
        const sphere6 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(0, 0, -1.5),
          new import__31.Cartesian3(0, 2, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          sphere6,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the bottom plane", function() {
        const sphere7 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(0, -2, -1.5),
          new import__31.Cartesian3(0, 0, -1.5)
        ]);
        testWithAndWithoutPlaneMask(
          cullingVolume,
          sphere7,
          import__31.Intersect.INTERSECTING
        );
      });
    });
    describe("can not contain a sphere", function() {
      it("past the far plane", function() {
        const sphere8 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(0, 0, -2.25),
          new import__31.Cartesian3(0, 0, -2.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, sphere8, import__31.Intersect.OUTSIDE);
      });
      it("before the near plane", function() {
        const sphere9 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(0, 0, -0.25),
          new import__31.Cartesian3(0, 0, -0.5)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, sphere9, import__31.Intersect.OUTSIDE);
      });
      it("past the left plane", function() {
        const sphere10 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(-5, 0, -1.25),
          new import__31.Cartesian3(-4.5, 0, -1.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, sphere10, import__31.Intersect.OUTSIDE);
      });
      it("past the right plane", function() {
        const sphere11 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(4.5, 0, -1.25),
          new import__31.Cartesian3(5, 0, -1.75)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, sphere11, import__31.Intersect.OUTSIDE);
      });
      it("past the top plane", function() {
        const sphere12 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(-0.5, 4.5, -1.25),
          new import__31.Cartesian3(-0.5, 5, -1.25)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, sphere12, import__31.Intersect.OUTSIDE);
      });
      it("past the bottom plane", function() {
        const sphere13 = import__31.BoundingSphere.fromPoints([
          new import__31.Cartesian3(-0.5, -4.5, -1.25),
          new import__31.Cartesian3(-0.5, -5, -1.25)
        ]);
        testWithAndWithoutPlaneMask(cullingVolume, sphere13, import__31.Intersect.OUTSIDE);
      });
    });
  });
  describe("construct from bounding sphere", function() {
    const boundingSphereCullingVolume = new import__31.BoundingSphere(
      new import__31.Cartesian3(1e3, 2e3, 3e3),
      100
    );
    const cullingVolume2 = import__31.CullingVolume.fromBoundingSphere(
      boundingSphereCullingVolume
    );
    it("throws without a boundingSphere", function() {
      expect(function() {
        import__31.CullingVolume.fromBoundingSphere(void 0);
      }).toThrowDeveloperError();
    });
    it("can contain a volume", function() {
      const sphere1 = import__31.BoundingSphere.clone(boundingSphereCullingVolume);
      sphere1.radius *= 0.5;
      testWithAndWithoutPlaneMask(cullingVolume2, sphere1, import__31.Intersect.INSIDE);
    });
    describe("can partially contain a volume", function() {
      it("on the far plane", function() {
        const offset = new import__31.Cartesian3(
          0,
          0,
          boundingSphereCullingVolume.radius * 1.5
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere2 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(
          cullingVolume2,
          sphere2,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the near plane", function() {
        const offset = new import__31.Cartesian3(
          0,
          0,
          -boundingSphereCullingVolume.radius * 1.5
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere3 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(
          cullingVolume2,
          sphere3,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the left plane", function() {
        const offset = new import__31.Cartesian3(
          -boundingSphereCullingVolume.radius * 1.5,
          0,
          0
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere4 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(
          cullingVolume2,
          sphere4,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the right plane", function() {
        const offset = new import__31.Cartesian3(
          boundingSphereCullingVolume.radius * 1.5,
          0,
          0
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere5 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(
          cullingVolume2,
          sphere5,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the top plane", function() {
        const offset = new import__31.Cartesian3(
          0,
          boundingSphereCullingVolume.radius * 1.5,
          0
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere6 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(
          cullingVolume2,
          sphere6,
          import__31.Intersect.INTERSECTING
        );
      });
      it("on the bottom plane", function() {
        const offset = new import__31.Cartesian3(
          0,
          -boundingSphereCullingVolume.radius * 1.5,
          0
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere7 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(
          cullingVolume2,
          sphere7,
          import__31.Intersect.INTERSECTING
        );
      });
    });
    describe("can not contain a volume", function() {
      it("past the far plane", function() {
        const offset = new import__31.Cartesian3(
          0,
          0,
          boundingSphereCullingVolume.radius * 2
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere8 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(cullingVolume2, sphere8, import__31.Intersect.OUTSIDE);
      });
      it("before the near plane", function() {
        const offset = new import__31.Cartesian3(
          0,
          0,
          -boundingSphereCullingVolume.radius * 2
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere9 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(cullingVolume2, sphere9, import__31.Intersect.OUTSIDE);
      });
      it("past the left plane", function() {
        const offset = new import__31.Cartesian3(
          -boundingSphereCullingVolume.radius * 2,
          0,
          0
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere10 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(cullingVolume2, sphere10, import__31.Intersect.OUTSIDE);
      });
      it("past the right plane", function() {
        const offset = new import__31.Cartesian3(
          boundingSphereCullingVolume.radius * 2,
          0,
          0
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere11 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(cullingVolume2, sphere11, import__31.Intersect.OUTSIDE);
      });
      it("past the top plane", function() {
        const offset = new import__31.Cartesian3(
          0,
          boundingSphereCullingVolume.radius * 2,
          0
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere12 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(cullingVolume2, sphere12, import__31.Intersect.OUTSIDE);
      });
      it("past the bottom plane", function() {
        const offset = new import__31.Cartesian3(
          0,
          -boundingSphereCullingVolume.radius * 2,
          0
        );
        const center = import__31.Cartesian3.add(
          boundingSphereCullingVolume.center,
          offset,
          new import__31.Cartesian3()
        );
        const radius = boundingSphereCullingVolume.radius * 0.5;
        const sphere13 = new import__31.BoundingSphere(center, radius);
        testWithAndWithoutPlaneMask(cullingVolume2, sphere13, import__31.Intersect.OUTSIDE);
      });
    });
  });
});

// packages/engine/Specs/Core/CustomHeightmapTerrainProviderSpec.js
var import__32 = __toESM(require_Cesium(), 1);
describe("Core/CustomHeightmapTerrainProvider", function() {
  it("conforms to TerrainProvider interface", function() {
    expect(import__32.CustomHeightmapTerrainProvider).toConformToInterface(
      import__32.TerrainProvider
    );
  });
  it("constructor throws if callback is not provided", function() {
    const width = 2;
    const height = 2;
    expect(function() {
      return new import__32.CustomHeightmapTerrainProvider({
        width,
        height
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws if width is not provided", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    expect(function() {
      return new import__32.CustomHeightmapTerrainProvider({
        callback,
        height
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws if height is not provided", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    expect(function() {
      return new import__32.CustomHeightmapTerrainProvider({
        callback,
        width
      });
    }).toThrowDeveloperError();
  });
  it("constructs with a credit", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height,
      credit: "Credit"
    });
    expect(provider.credit).toBeDefined();
  });
  it("constructs with a tiling scheme", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height,
      tilingScheme: new import__32.WebMercatorTilingScheme()
    });
    expect(provider.tilingScheme).toBeInstanceOf(import__32.WebMercatorTilingScheme);
  });
  it("has error event", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    expect(provider.errorEvent).toBeDefined();
    expect(provider.errorEvent).toBe(provider.errorEvent);
  });
  it("gets geometric error", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const geometricError = import__32.TerrainProvider.getEstimatedLevelZeroGeometricErrorForAHeightmap(
      provider.tilingScheme.ellipsoid,
      Math.max(provider.width, provider.height),
      provider.tilingScheme.getNumberOfXTilesAtLevel(0)
    );
    expect(provider.getLevelMaximumGeometricError(0)).toBe(geometricError);
  });
  it("water mask is disabled", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    expect(provider.hasWaterMask).toBe(false);
  });
  it("vertex normals are disabled", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    expect(provider.hasVertexNormals).toBe(false);
  });
  it("requestTileGeometry receives heightmap data as Int8Array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Int8Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry receives heightmap data as Uint8Array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Uint8Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry receives heightmap data as Int16Array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Int16Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry receives heightmap data as Uint16Array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Uint16Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry receives heightmap data as Int32Array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Int32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry receives heightmap data as Uint32Array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Uint32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry receives heightmap data as Float32Array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry receives heightmap data as Float64Array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Float64Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry receives heightmap data as Number array", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      const buffer = new Array(4);
      buffer[0] = 0;
      buffer[1] = 0;
      buffer[2] = 0;
      buffer[3] = 0;
      return buffer;
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    const terrainData = provider.requestTileGeometry(0, 0, 0);
    expect(terrainData).toBeDefined();
  });
  it("requestTileGeometry returns undefined when callback function returns undefined", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return void 0;
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    expect(provider.requestTileGeometry()).toBeUndefined();
  });
  it("gets width and height", function() {
    const width = 2;
    const height = 3;
    const callback = function(x, y, level) {
      return new Float32Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    expect(provider.width).toEqual(width);
    expect(provider.height).toEqual(height);
  });
  it("returns undefined for getTileDataAvailable", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Int16Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    expect(provider.getTileDataAvailable()).toBeUndefined();
  });
  it("returns undefined for loadTileDataAvailability", function() {
    const width = 2;
    const height = 2;
    const callback = function(x, y, level) {
      return new Int16Array(width * height);
    };
    const provider = new import__32.CustomHeightmapTerrainProvider({
      callback,
      width,
      height
    });
    expect(provider.loadTileDataAvailability()).toBeUndefined();
  });
});

// packages/engine/Specs/Core/CylinderGeometrySpec.js
var import__33 = __toESM(require_Cesium(), 1);
describe("Core/CylinderGeometry", function() {
  it("constructor throws with no length", function() {
    expect(function() {
      return new import__33.CylinderGeometry({});
    }).toThrowDeveloperError();
  });
  it("constructor throws with no topRadius", function() {
    expect(function() {
      return new import__33.CylinderGeometry({
        length: 1
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws with no bottomRadius", function() {
    expect(function() {
      return new import__33.CylinderGeometry({
        length: 1,
        topRadius: 1
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws if slices is less than 3", function() {
    expect(function() {
      return new import__33.CylinderGeometry({
        length: 1,
        topRadius: 1,
        bottomRadius: 1,
        slices: 2
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__33.CylinderGeometry.createGeometry(
      new import__33.CylinderGeometry({
        vertexFormat: import__33.VertexFormat.POSITION_ONLY,
        length: 1,
        topRadius: 1,
        bottomRadius: 1,
        slices: 3
      })
    );
    const numVertices = 12;
    const numTriangles = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes offset attribute", function() {
    const m = import__33.CylinderGeometry.createGeometry(
      new import__33.CylinderGeometry({
        vertexFormat: import__33.VertexFormat.POSITION_ONLY,
        length: 1,
        topRadius: 1,
        bottomRadius: 1,
        slices: 3,
        offsetAttribute: import__33.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 12;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("compute all vertex attributes", function() {
    const m = import__33.CylinderGeometry.createGeometry(
      new import__33.CylinderGeometry({
        vertexFormat: import__33.VertexFormat.ALL,
        length: 1,
        topRadius: 1,
        bottomRadius: 1,
        slices: 3
      })
    );
    const numVertices = 12;
    const numTriangles = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes positions with topRadius equals 0", function() {
    const m = import__33.CylinderGeometry.createGeometry(
      new import__33.CylinderGeometry({
        vertexFormat: import__33.VertexFormat.POSITION_ONLY,
        length: 1,
        topRadius: 0,
        bottomRadius: 1,
        slices: 3
      })
    );
    const numVertices = 12;
    const numTriangles = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes positions with bottomRadius equals 0", function() {
    const m = import__33.CylinderGeometry.createGeometry(
      new import__33.CylinderGeometry({
        vertexFormat: import__33.VertexFormat.POSITION_ONLY,
        length: 1,
        topRadius: 1,
        bottomRadius: 0,
        slices: 3
      })
    );
    const numVertices = 12;
    const numTriangles = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it(
    "undefined is returned if the length is less than or equal to zero or if both radii are equal to zero or is either radii and less than zero",
    function() {
      const cylinder0 = new import__33.CylinderGeometry({
        length: 0,
        topRadius: 8e4,
        bottomRadius: 2e5
      });
      const cylinder1 = new import__33.CylinderGeometry({
        length: 2e5,
        topRadius: 0,
        bottomRadius: 0
      });
      const cylinder2 = new import__33.CylinderGeometry({
        length: 2e5,
        topRadius: -10,
        bottomRadius: 4
      });
      const cylinder3 = new import__33.CylinderGeometry({
        length: -2e5,
        topRadius: 100,
        bottomRadius: 100
      });
      const cylinder4 = new import__33.CylinderGeometry({
        length: 2e5,
        topRadius: 0,
        bottomRadius: -34
      });
      const geometry0 = import__33.CylinderGeometry.createGeometry(cylinder0);
      const geometry1 = import__33.CylinderGeometry.createGeometry(cylinder1);
      const geometry2 = import__33.CylinderGeometry.createGeometry(cylinder2);
      const geometry3 = import__33.CylinderGeometry.createGeometry(cylinder3);
      const geometry4 = import__33.CylinderGeometry.createGeometry(cylinder4);
      expect(geometry0).toBeUndefined();
      expect(geometry1).toBeUndefined();
      expect(geometry2).toBeUndefined();
      expect(geometry3).toBeUndefined();
      expect(geometry4).toBeUndefined();
    }
  );
  const cylinder = new import__33.CylinderGeometry({
    vertexFormat: import__33.VertexFormat.POSITION_ONLY,
    length: 1,
    topRadius: 1,
    bottomRadius: 0,
    slices: 3
  });
  const packedInstance = [
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    3,
    -1
  ];
  createPackableSpecs_default(import__33.CylinderGeometry, cylinder, packedInstance);
});

// packages/engine/Specs/Core/CylinderOutlineGeometrySpec.js
var import__34 = __toESM(require_Cesium(), 1);
describe("Core/CylinderOutlineGeometry", function() {
  it("constructor throws with no length", function() {
    expect(function() {
      return new import__34.CylinderOutlineGeometry({});
    }).toThrowDeveloperError();
  });
  it("constructor throws with no topRadius", function() {
    expect(function() {
      return new import__34.CylinderOutlineGeometry({
        length: 1
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws with no bottomRadius", function() {
    expect(function() {
      return new import__34.CylinderOutlineGeometry({
        length: 1,
        topRadius: 1
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws if slices is less than 3", function() {
    expect(function() {
      return new import__34.CylinderOutlineGeometry({
        length: 1,
        topRadius: 1,
        bottomRadius: 1,
        slices: 2
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__34.CylinderOutlineGeometry.createGeometry(
      new import__34.CylinderOutlineGeometry({
        length: 1,
        topRadius: 1,
        bottomRadius: 1,
        slices: 3
      })
    );
    expect(m.attributes.position.values.length).toEqual(6 * 3);
    expect(m.indices.length).toEqual(9 * 2);
  });
  it("computes offset attribute", function() {
    const m = import__34.CylinderOutlineGeometry.createGeometry(
      new import__34.CylinderOutlineGeometry({
        length: 1,
        topRadius: 1,
        bottomRadius: 1,
        slices: 3,
        offsetAttribute: import__34.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 6;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes positions with no lines along the length", function() {
    const m = import__34.CylinderOutlineGeometry.createGeometry(
      new import__34.CylinderOutlineGeometry({
        length: 1,
        topRadius: 1,
        bottomRadius: 1,
        slices: 3,
        numberOfVerticalLines: 0
      })
    );
    const numVertices = 6;
    const numLines = 6;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numLines * 2);
  });
  it(
    "undefined is returned if the length is less than or equal to zero or if both radii are equal to zero or is either radii and less than zero",
    function() {
      const cylinderOutline0 = new import__34.CylinderOutlineGeometry({
        length: 0,
        topRadius: 8e4,
        bottomRadius: 2e5
      });
      const cylinderOutline1 = new import__34.CylinderOutlineGeometry({
        length: 2e5,
        topRadius: 0,
        bottomRadius: 0
      });
      const cylinderOutline2 = new import__34.CylinderOutlineGeometry({
        length: 2e5,
        topRadius: -10,
        bottomRadius: 4
      });
      const cylinderOutline3 = new import__34.CylinderOutlineGeometry({
        length: -2e5,
        topRadius: 100,
        bottomRadius: 100
      });
      const cylinderOutline4 = new import__34.CylinderOutlineGeometry({
        length: 2e5,
        topRadius: 32,
        bottomRadius: -100
      });
      const geometry0 = import__34.CylinderOutlineGeometry.createGeometry(
        cylinderOutline0
      );
      const geometry1 = import__34.CylinderOutlineGeometry.createGeometry(
        cylinderOutline1
      );
      const geometry2 = import__34.CylinderOutlineGeometry.createGeometry(
        cylinderOutline2
      );
      const geometry3 = import__34.CylinderOutlineGeometry.createGeometry(
        cylinderOutline3
      );
      const geometry4 = import__34.CylinderOutlineGeometry.createGeometry(
        cylinderOutline4
      );
      expect(geometry0).toBeUndefined();
      expect(geometry1).toBeUndefined();
      expect(geometry2).toBeUndefined();
      expect(geometry3).toBeUndefined();
      expect(geometry4).toBeUndefined();
    }
  );
  const cylinder = new import__34.CylinderOutlineGeometry({
    length: 1,
    topRadius: 1,
    bottomRadius: 0,
    slices: 3,
    numberOfVerticalLines: 0
  });
  const packedInstance = [1, 1, 0, 3, 0, -1];
  createPackableSpecs_default(import__34.CylinderOutlineGeometry, cylinder, packedInstance);
});

// packages/engine/Specs/Core/DeveloperErrorSpec.js
var import__35 = __toESM(require_Cesium(), 1);
describe("Core/DeveloperError", function() {
  const name = "DeveloperError";
  const testMessage = "Testing";
  let e;
  beforeEach(function() {
    e = new import__35.DeveloperError(testMessage);
  });
  it("has a name property", function() {
    expect(e.name).toEqual(name);
  });
  it("has a message property", function() {
    expect(e.message).toEqual(testMessage);
  });
  it("has a stack property", function() {
    if (!window.specsUsingRelease) {
      expect(e.stack).toContain(name);
    }
  });
  it("has a working toString", function() {
    const str = new import__35.DeveloperError(testMessage).toString();
    if (!window.specsUsingRelease) {
      expect(str).toContain(`${name}: ${testMessage}`);
    } else {
      expect(str).toContain(testMessage);
    }
  });
});

// packages/engine/Specs/Core/DistanceDisplayConditionGeometryInstanceAttributeSpec.js
var import__36 = __toESM(require_Cesium(), 1);
describe("Core/DistanceDisplayConditionGeometryInstanceAttribute", function() {
  it("constructor", function() {
    const attribute = new import__36.DistanceDisplayConditionGeometryInstanceAttribute(
      10,
      100
    );
    expect(attribute.componentDatatype).toEqual(import__36.ComponentDatatype.FLOAT);
    expect(attribute.componentsPerAttribute).toEqual(2);
    expect(attribute.normalize).toEqual(false);
    const value = new Float32Array([10, 100]);
    expect(attribute.value).toEqual(value);
  });
  it("constructor throws with far > near", function() {
    expect(function() {
      return new import__36.DistanceDisplayConditionGeometryInstanceAttribute(100, 10);
    }).toThrowDeveloperError();
  });
  it("fromDistanceDisplayCondition", function() {
    const dc = new import__36.DistanceDisplayCondition(10, 100);
    const attribute = import__36.DistanceDisplayConditionGeometryInstanceAttribute.fromDistanceDisplayCondition(
      dc
    );
    expect(attribute.componentDatatype).toEqual(import__36.ComponentDatatype.FLOAT);
    expect(attribute.componentsPerAttribute).toEqual(2);
    expect(attribute.normalize).toEqual(false);
    const value = new Float32Array([dc.near, dc.far]);
    expect(attribute.value).toEqual(value);
  });
  it("fromDistanceDisplayCondition throws without distanceDisplayCondition", function() {
    expect(function() {
      import__36.DistanceDisplayConditionGeometryInstanceAttribute.fromDistanceDisplayCondition();
    }).toThrowDeveloperError();
  });
  it("fromDistanceDisplayCondition throws with far >= near", function() {
    expect(function() {
      import__36.DistanceDisplayConditionGeometryInstanceAttribute.fromDistanceDisplayCondition(
        new import__36.DistanceDisplayCondition(100, 10)
      );
    }).toThrowDeveloperError();
  });
  it("toValue", function() {
    const dc = new import__36.DistanceDisplayCondition(10, 200);
    const expectedResult = new Float32Array([dc.near, dc.far]);
    expect(
      import__36.DistanceDisplayConditionGeometryInstanceAttribute.toValue(dc)
    ).toEqual(expectedResult);
  });
  it("toValue works with result parameter", function() {
    const dc = new import__36.DistanceDisplayCondition(10, 200);
    const expectedResult = new Float32Array([dc.near, dc.far]);
    const result = new Float32Array(2);
    const returnedResult = import__36.DistanceDisplayConditionGeometryInstanceAttribute.toValue(
      dc,
      result
    );
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("toValue throws without a distanceDisplayCondition", function() {
    expect(function() {
      import__36.DistanceDisplayConditionGeometryInstanceAttribute.toValue();
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/DistanceDisplayConditionSpec.js
var import__37 = __toESM(require_Cesium(), 1);
describe("Core/DistanceDisplayCondition", function() {
  it("default constructs", function() {
    const dc = new import__37.DistanceDisplayCondition();
    expect(dc.near).toEqual(0);
    expect(dc.far).toEqual(Number.MAX_VALUE);
  });
  it("constructs with parameters", function() {
    const near = 10;
    const far = 100;
    const dc = new import__37.DistanceDisplayCondition(near, far);
    expect(dc.near).toEqual(near);
    expect(dc.far).toEqual(far);
  });
  it("gets and sets properties", function() {
    const dc = new import__37.DistanceDisplayCondition();
    const near = 10;
    const far = 100;
    dc.near = near;
    dc.far = far;
    expect(dc.near).toEqual(near);
    expect(dc.far).toEqual(far);
  });
  it("determines equality with static function", function() {
    const dc = new import__37.DistanceDisplayCondition(10, 100);
    expect(
      import__37.DistanceDisplayCondition.equals(
        dc,
        new import__37.DistanceDisplayCondition(10, 100)
      )
    ).toEqual(true);
    expect(
      import__37.DistanceDisplayCondition.equals(
        dc,
        new import__37.DistanceDisplayCondition(11, 100)
      )
    ).toEqual(false);
    expect(
      import__37.DistanceDisplayCondition.equals(
        dc,
        new import__37.DistanceDisplayCondition(10, 101)
      )
    ).toEqual(false);
    expect(import__37.DistanceDisplayCondition.equals(dc, void 0)).toEqual(false);
  });
  it("determines equality with prototype function", function() {
    const dc = new import__37.DistanceDisplayCondition(10, 100);
    expect(dc.equals(new import__37.DistanceDisplayCondition(10, 100))).toEqual(true);
    expect(dc.equals(new import__37.DistanceDisplayCondition(11, 100))).toEqual(false);
    expect(dc.equals(new import__37.DistanceDisplayCondition(10, 101))).toEqual(false);
    expect(dc.equals(void 0)).toEqual(false);
  });
  it("static clones", function() {
    const dc = new import__37.DistanceDisplayCondition(10, 100);
    const result = import__37.DistanceDisplayCondition.clone(dc);
    expect(dc).toEqual(result);
  });
  it("static clone with a result parameter", function() {
    const dc = new import__37.DistanceDisplayCondition(10, 100);
    const result = new import__37.DistanceDisplayCondition();
    const returnedResult = import__37.DistanceDisplayCondition.clone(dc, result);
    expect(dc).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(dc).toEqual(result);
  });
  it("static clone works with a result parameter that is an input parameter", function() {
    const dc = new import__37.DistanceDisplayCondition(10, 100);
    const returnedResult = import__37.DistanceDisplayCondition.clone(dc, dc);
    expect(dc).toBe(returnedResult);
  });
  it("clones", function() {
    const dc = new import__37.DistanceDisplayCondition(10, 100);
    const result = dc.clone();
    expect(dc).toEqual(result);
  });
  it("clone with a result parameter", function() {
    const dc = new import__37.DistanceDisplayCondition(10, 100);
    const result = new import__37.DistanceDisplayCondition();
    const returnedResult = dc.clone(result);
    expect(dc).not.toBe(result);
    expect(result).toBe(returnedResult);
    expect(dc).toEqual(result);
  });
  it("clone works with a result parameter that is an input parameter", function() {
    const dc = new import__37.DistanceDisplayCondition(10, 100);
    const returnedResult = dc.clone(dc);
    expect(dc).toBe(returnedResult);
  });
  createPackableSpecs_default(
    import__37.DistanceDisplayCondition,
    new import__37.DistanceDisplayCondition(1, 2),
    [1, 2]
  );
});

// packages/engine/Specs/Core/DoubleEndedPriorityQueueSpec.js
var import__38 = __toESM(require_Cesium(), 1);
describe("Core/DoubleEndedPriorityQueue", function() {
  function comparator(a, b) {
    return a - b;
  }
  it("constructor throws without options", function() {
    expect(function() {
      return new import__38.DoubleEndedPriorityQueue();
    }).toThrowDeveloperError();
  });
  it("constructor throws if maximum length is less than zero", function() {
    expect(function() {
      return new import__38.DoubleEndedPriorityQueue({
        comparator,
        maximumLength: -1
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without comparator", function() {
    expect(function() {
      return new import__38.DoubleEndedPriorityQueue({
        comparator: void 0
      });
    }).toThrowDeveloperError();
  });
  it("gets comparator", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    const returnedComparator = queue.comparator;
    expect(returnedComparator).toEqual(comparator);
  });
  it("uses different comparator", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator: function(a, b) {
        return b - a;
      }
    });
    queue.insert(1);
    queue.insert(2);
    expect(queue.length).toEqual(2);
    expect(queue.getMinimum()).toEqual(2);
    expect(queue.getMaximum()).toEqual(1);
  });
  it("checks state of default empty queue", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    expect(queue.length).toEqual(0);
    expect(queue.maximumLength).toBeUndefined();
    expect(queue.internalArray.length).toEqual(0);
    expect(queue.getMinimum()).toBeUndefined();
    expect(queue.getMaximum()).toBeUndefined();
  });
  it("inserts one element into queue", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    queue.insert(1);
    expect(queue.length).toEqual(1);
    expect(queue.internalArray.length).toEqual(1);
    expect(queue.getMinimum()).toEqual(1);
    expect(queue.getMaximum()).toEqual(1);
  });
  it("inserts two elements into queue", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    queue.insert(1);
    queue.insert(2);
    expect(queue.length).toEqual(2);
    expect(queue.internalArray.length).toEqual(2);
    expect(queue.getMinimum()).toEqual(1);
    expect(queue.getMaximum()).toEqual(2);
  });
  it("inserts three elements into queue", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    queue.insert(1);
    queue.insert(2);
    queue.insert(3);
    expect(queue.length).toEqual(3);
    expect(queue.internalArray.length).toEqual(3);
    expect(queue.getMinimum()).toEqual(1);
    expect(queue.getMaximum()).toEqual(3);
  });
  it("inserts four elements into queue", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    queue.insert(1);
    queue.insert(2);
    queue.insert(3);
    queue.insert(4);
    expect(queue.length).toEqual(4);
    expect(queue.internalArray.length).toEqual(4);
    expect(queue.getMinimum()).toEqual(1);
    expect(queue.getMaximum()).toEqual(4);
  });
  it("insert removes and returns minimum element when the queue is full", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator,
      maximumLength: 1
    });
    const nothing = queue.insert(1);
    const removed = queue.insert(2);
    expect(queue.length).toEqual(1);
    expect(queue.maximumLength).toEqual(1);
    expect(queue.internalArray.length).toEqual(1);
    expect(queue.getMinimum()).toEqual(2);
    expect(queue.getMaximum()).toEqual(2);
    expect(nothing).toBeUndefined();
    expect(removed).toEqual(1);
  });
  it("insert returns undefined when new element is less than or equal priority to the minimum element and the queue is full", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator: function(a, b) {
        return a.value - b.value;
      },
      maximumLength: 2
    });
    const obj1 = { value: 1, id: 0 };
    const obj2 = { value: 2, id: 0 };
    const obj3 = { value: 1, id: 1 };
    const obj4 = { value: 0, id: 1 };
    const result1 = queue.insert(obj1);
    const result2 = queue.insert(obj2);
    const result3 = queue.insert(obj3);
    const result4 = queue.insert(obj4);
    expect(queue.length).toEqual(2);
    expect(queue.maximumLength).toEqual(2);
    expect(queue.internalArray.length).toEqual(2);
    expect(queue.getMinimum().id).toEqual(0);
    expect(result1).toBeUndefined();
    expect(result2).toBeUndefined();
    expect(result3).toEqual(obj3);
    expect(result4).toEqual(obj4);
  });
  it("remove and return minimum element", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    queue.insert(1);
    queue.insert(2);
    queue.insert(3);
    const minimumValue = queue.removeMinimum();
    expect(queue.length).toEqual(2);
    expect(minimumValue).toEqual(1);
    expect(queue.getMinimum()).toEqual(2);
    expect(queue.internalArray[2]).toBeUndefined();
  });
  it("removeMinimum returns undefined when queue is empty", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    const minimumValue = queue.removeMinimum();
    expect(minimumValue).toBeUndefined();
  });
  it("remove and return maximum element", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    queue.insert(1);
    queue.insert(2);
    queue.insert(3);
    const maximumValue = queue.removeMaximum();
    expect(queue.length).toEqual(2);
    expect(maximumValue).toEqual(3);
    expect(queue.getMaximum()).toEqual(2);
    expect(queue.internalArray[2]).toBeUndefined();
  });
  it("removeMaximum returns undefined when queue is empty", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    const maximumValue = queue.removeMaximum();
    expect(maximumValue).toBeUndefined();
  });
  it("clones queue", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator,
      maximumLength: 4
    });
    queue.insert(1);
    queue.insert(2);
    const clone24 = queue.clone();
    expect(clone24.length).toEqual(queue.length);
    expect(clone24.maximumLength).toEqual(queue.maximumLength);
    expect(clone24.comparator).toEqual(queue.comparator);
    expect(clone24.getMaximum()).toEqual(queue.getMaximum());
    expect(clone24.getMinimum()).toEqual(queue.getMinimum());
  });
  it("resets queue", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    queue.insert(1);
    queue.insert(2);
    queue.reset();
    expect(queue.length).toEqual(0);
    expect(queue.getMinimum()).toBeUndefined();
    expect(queue.getMaximum()).toBeUndefined();
    expect(queue.internalArray.length).toEqual(0);
  });
  it("resets queue with maximum length", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator,
      maximumLength: 1
    });
    queue.insert(1);
    queue.reset();
    expect(queue.length).toEqual(0);
    expect(queue.getMinimum()).toBeUndefined();
    expect(queue.getMaximum()).toBeUndefined();
    expect(queue.internalArray.length).toEqual(1);
    expect(queue.internalArray[0]).toBeUndefined();
  });
  it("creates queue with maximum length of zero", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator,
      maximumLength: 0
    });
    queue.insert(1);
    expect(queue.length).toEqual(0);
    expect(queue.maximumLength).toEqual(0);
    expect(queue.internalArray.length).toEqual(0);
    expect(queue.getMinimum()).toBeUndefined();
    expect(queue.getMaximum()).toBeUndefined();
  });
  it("creates queue with maximum length of one", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator,
      maximumLength: 1
    });
    queue.insert(1);
    queue.insert(2);
    expect(queue.length).toEqual(1);
    expect(queue.maximumLength).toEqual(1);
    expect(queue.internalArray.length).toEqual(1);
    expect(queue.getMinimum()).toEqual(2);
    expect(queue.getMaximum()).toEqual(2);
  });
  it("throws when maximum length is set to less than zero", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    expect(function() {
      queue.maximumLength = -1;
    }).toThrowDeveloperError();
  });
  it("sets maximum length to undefined", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    queue.maximumLength = 2;
    queue.insert(1);
    queue.insert(2);
    queue.maximumLength = void 0;
    queue.insert(3);
    expect(queue.length).toEqual(3);
    expect(queue.maximumLength).toBeUndefined();
    expect(queue.getMinimum()).toEqual(1);
    expect(queue.getMaximum()).toEqual(3);
  });
  it("sets maximum length to less than current length", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    const maximumLength = 5;
    for (let i = 0; i < maximumLength * 2; i++) {
      const value = i;
      queue.insert(value);
    }
    queue.maximumLength = maximumLength;
    expect(queue.length).toEqual(maximumLength);
    expect(queue.maximumLength).toEqual(maximumLength);
    expect(queue.internalArray.length).toEqual(maximumLength);
    expect(queue.getMinimum()).toEqual(maximumLength);
    expect(queue.getMaximum()).toEqual(maximumLength * 2 - 1);
  });
  function isValidQueue(queue) {
    const minArray = [];
    const maxArray = [];
    const minQueue = queue.clone();
    const maxQueue = queue.clone();
    while (minQueue.length > 0) {
      minArray.push(minQueue.removeMinimum());
    }
    while (maxQueue.length > 0) {
      maxArray.push(maxQueue.removeMaximum());
    }
    if (minQueue.length !== 0 || maxQueue.length !== 0) {
      return false;
    }
    let i;
    for (i = 0; i < minArray.length - 1; i++) {
      if (minArray[i] > minArray[i + 1]) {
        return false;
      }
    }
    for (i = 0; i < maxArray.length - 1; i++) {
      if (maxArray[i] < maxArray[i + 1]) {
        return false;
      }
    }
    return true;
  }
  it("maintains priority with ascending insertions", function() {
    const length2 = 200;
    const maximumLength = 100;
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator,
      maximumLength
    });
    let pass = true;
    for (let i = 0; i < length2; ++i) {
      const value = i;
      queue.insert(value);
      pass = pass && isValidQueue(queue);
    }
    expect(pass).toBe(true);
  });
  it("maintains priority with descending insertions", function() {
    const length2 = 200;
    const maximumLength = 100;
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator,
      maximumLength
    });
    let pass = true;
    for (let i = 0; i < length2; ++i) {
      const value = length2 - 1 - i;
      queue.insert(value);
      pass = pass && isValidQueue(queue);
    }
    expect(pass).toBe(true);
  });
  it("maintains priority with random insertions", function() {
    const length2 = 200;
    const maximumLength = 100;
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator,
      maximumLength
    });
    let pass = true;
    for (let i = 0; i < length2; ++i) {
      const value = Math.random();
      queue.insert(value);
      pass = pass && isValidQueue(queue);
    }
    expect(pass).toBe(true);
  });
  it("resorts queue", function() {
    const queue = new import__38.DoubleEndedPriorityQueue({
      comparator
    });
    let i;
    const length2 = 200;
    for (i = 0; i < length2; ++i) {
      queue.insert(0);
    }
    const array = queue.internalArray;
    for (i = 0; i < length2; i++) {
      array[i] = Math.random();
    }
    queue.resort();
    const pass = isValidQueue(queue);
    expect(pass).toBe(true);
  });
});

// packages/engine/Specs/Core/DoublyLinkedListSpec.js
var import__39 = __toESM(require_Cesium(), 1);
describe("Core/DoublyLinkedList", function() {
  it("constructs", function() {
    const list = new import__39.DoublyLinkedList();
    expect(list.head).not.toBeDefined();
    expect(list.tail).not.toBeDefined();
    expect(list.length).toEqual(0);
  });
  it("adds items", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    expect(list.head).toEqual(node);
    expect(list.tail).toEqual(node);
    expect(list.length).toEqual(1);
    expect(node).toBeDefined();
    expect(node.item).toEqual(1);
    expect(node.previous).not.toBeDefined();
    expect(node.next).not.toBeDefined();
    const node2 = list.add(2);
    expect(list.head).toEqual(node);
    expect(list.tail).toEqual(node2);
    expect(list.length).toEqual(2);
    expect(node2).toBeDefined();
    expect(node2.item).toEqual(2);
    expect(node2.previous).toEqual(node);
    expect(node2.next).not.toBeDefined();
    expect(node.next).toEqual(node2);
    const node3 = list.add(3);
    expect(list.head).toEqual(node);
    expect(list.tail).toEqual(node3);
    expect(list.length).toEqual(3);
    expect(node3).toBeDefined();
    expect(node3.item).toEqual(3);
    expect(node3.previous).toEqual(node2);
    expect(node3.next).not.toBeDefined();
    expect(node2.next).toEqual(node3);
  });
  it("removes from a list with one item", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    list.remove(node);
    expect(list.head).not.toBeDefined();
    expect(list.tail).not.toBeDefined();
    expect(list.length).toEqual(0);
  });
  it("removes head of list", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    list.remove(node);
    expect(list.head).toEqual(node2);
    expect(list.tail).toEqual(node2);
    expect(list.length).toEqual(1);
  });
  it("removes tail of list", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    list.remove(node2);
    expect(list.head).toEqual(node);
    expect(list.tail).toEqual(node);
    expect(list.length).toEqual(1);
  });
  it("removes middle of list", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    list.remove(node2);
    expect(list.head).toEqual(node);
    expect(list.tail).toEqual(node3);
    expect(list.length).toEqual(2);
  });
  it("removes nothing", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    list.remove(void 0);
    expect(list.head).toEqual(node);
    expect(list.tail).toEqual(node);
    expect(list.length).toEqual(1);
  });
  function expectOrder(list, nodes) {
    const length2 = nodes.length;
    expect(list.length).toEqual(length2);
    expect(list.head).toEqual(nodes[0]);
    expect(list.tail).toEqual(nodes[length2 - 1]);
    let node = list.head;
    for (let i = 0; i < length2; ++i) {
      const nextNode = i === length2 - 1 ? void 0 : nodes[i + 1];
      const previousNode = i === 0 ? void 0 : nodes[i - 1];
      expect(node).toEqual(nodes[i]);
      expect(node.next).toEqual(nextNode);
      expect(node.previous).toEqual(previousNode);
      node = node.next;
    }
  }
  it("splices nextNode before node", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    const node4 = list.add(4);
    const node5 = list.add(5);
    list.splice(node4, node2);
    expectOrder(list, [node, node3, node4, node2, node5]);
  });
  it("splices nextNode after node", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    const node4 = list.add(4);
    const node5 = list.add(5);
    list.splice(node2, node4);
    expectOrder(list, [node, node2, node4, node3, node5]);
  });
  it("splices nextNode immediately before node", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    const node4 = list.add(4);
    list.splice(node3, node2);
    expectOrder(list, [node, node3, node2, node4]);
  });
  it("splices nextNode immediately after node", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    const node4 = list.add(4);
    list.splice(node2, node3);
    expectOrder(list, [node, node2, node3, node4]);
  });
  it("splices node === nextNode", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    list.splice(node2, node2);
    expectOrder(list, [node, node2, node3]);
  });
  it("splices when nextNode was tail", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    const node4 = list.add(4);
    list.splice(node2, node4);
    expectOrder(list, [node, node2, node4, node3]);
  });
  it("splices when node was tail", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    const node4 = list.add(4);
    list.splice(node4, node2);
    expectOrder(list, [node, node3, node4, node2]);
  });
  it("splices when nextNode was head", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    const node4 = list.add(4);
    list.splice(node3, node);
    expectOrder(list, [node2, node3, node, node4]);
  });
  it("splices when node was head", function() {
    const list = new import__39.DoublyLinkedList();
    const node = list.add(1);
    const node2 = list.add(2);
    const node3 = list.add(3);
    const node4 = list.add(4);
    list.splice(node, node3);
    expectOrder(list, [node, node3, node2, node4]);
  });
});

// packages/engine/Specs/Core/EarthOrientationParametersSpec.js
var import__40 = __toESM(require_Cesium(), 1);
describe("Core/EarthOrientationParameters", function() {
  let officialLeapSeconds;
  beforeAll(function() {
    officialLeapSeconds = import__40.JulianDate.leapSeconds.slice(0);
  });
  afterEach(function() {
    import__40.JulianDate.leapSeconds = officialLeapSeconds.slice(0);
  });
  it("adds leap seconds found in the data by default", function() {
    const eop = new import__40.EarthOrientationParameters({
      data: {
        columnNames: [
          "dateIso8601",
          "modifiedJulianDateUtc",
          "xPoleWanderRadians",
          "yPoleWanderRadians",
          "xCelestialPoleOffsetRadians",
          "yCelestialPoleOffsetRadians",
          "ut1MinusUtcSeconds",
          "taiMinusUtcSeconds",
          "lengthOfDayCorrectionSeconds"
        ],
        samples: [
          "2011-08-25T00:00:00Z",
          55798,
          2117957047295119e-22,
          2111518721609984e-21,
          3393695767766752e-26,
          33452143996557983e-26,
          -0.2908948,
          34,
          -2956e-7,
          "2011-08-26T00:00:00Z",
          55799,
          2193297093339541e-22,
          2115460256837405e-21,
          -8241832578862112e-26,
          5623838700870617e-25,
          -0.29065,
          34.5,
          -1824e-7,
          "2011-08-27T00:00:00Z",
          55800,
          2262286080161428e-22,
          21191157519929706e-22,
          -3490658503988659e-25,
          6981317007977318e-25,
          -0.2905572,
          34.5,
          19e-7,
          "2011-08-28T00:00:00Z",
          55801,
          23411652660779493e-23,
          2122751854601292e-21,
          -6205615118202061e-25,
          7853981633974483e-25,
          -0.2907007,
          34.5,
          2695e-7
        ]
      }
    });
    expect(eop).not.toBeNull();
    const leapSeconds = import__40.JulianDate.leapSeconds;
    expect(leapSeconds.length).toBe(officialLeapSeconds.length + 1);
    const newDate = new import__40.JulianDate(24557995e-1, 34.5, import__40.TimeStandard.TAI);
    let foundNew = false;
    let previousDate;
    for (let i = 0, len = leapSeconds.length; i < len; ++i) {
      const leapSecond = leapSeconds[i];
      if (leapSecond.julianDate.equals(newDate)) {
        foundNew = true;
      }
      if ((0, import__40.defined)(previousDate)) {
        expect(
          import__40.JulianDate.compare(previousDate, leapSecond.julianDate)
        ).toBeLessThan(0);
      }
      previousDate = leapSecond.julianDate;
    }
    expect(foundNew).toBe(true);
  });
  it("does not add leap seconds if told not to do so", function() {
    const eop = new import__40.EarthOrientationParameters({
      addNewLeapSeconds: false,
      data: {
        columnNames: [
          "dateIso8601",
          "modifiedJulianDateUtc",
          "xPoleWanderRadians",
          "yPoleWanderRadians",
          "xCelestialPoleOffsetRadians",
          "yCelestialPoleOffsetRadians",
          "ut1MinusUtcSeconds",
          "taiMinusUtcSeconds",
          "lengthOfDayCorrectionSeconds"
        ],
        samples: [
          "2011-08-25T00:00:00Z",
          55798,
          2117957047295119e-22,
          2111518721609984e-21,
          3393695767766752e-26,
          33452143996557983e-26,
          -0.2908948,
          35,
          -2956e-7,
          "2011-08-26T00:00:00Z",
          55799,
          2193297093339541e-22,
          2115460256837405e-21,
          -8241832578862112e-26,
          5623838700870617e-25,
          -0.29065,
          36,
          -1824e-7,
          "2011-08-27T00:00:00Z",
          55800,
          2262286080161428e-22,
          21191157519929706e-22,
          -3490658503988659e-25,
          6981317007977318e-25,
          -0.2905572,
          36,
          19e-7,
          "2011-08-28T00:00:00Z",
          55801,
          23411652660779493e-23,
          2122751854601292e-21,
          -6205615118202061e-25,
          7853981633974483e-25,
          -0.2907007,
          36,
          2695e-7
        ]
      }
    });
    expect(eop).not.toBeNull();
    const leapSeconds = import__40.JulianDate.leapSeconds;
    expect(leapSeconds.length).toBe(officialLeapSeconds.length);
  });
  describe("loading eop", function() {
    function linearInterp(dx, y1, y2) {
      return y1 + dx * (y2 - y1);
    }
    it("interpolates data correctly under normal circumstances", function() {
      const eopDescription = {
        data: {
          columnNames: [
            "dateIso8601",
            "modifiedJulianDateUtc",
            "xPoleWanderRadians",
            "yPoleWanderRadians",
            "xCelestialPoleOffsetRadians",
            "yCelestialPoleOffsetRadians",
            "ut1MinusUtcSeconds",
            "taiMinusUtcSeconds",
            "lengthOfDayCorrectionSeconds"
          ],
          samples: [
            "2011-07-01T00:00:00Z",
            55743,
            2117957047295119e-22,
            2111518721609984e-21,
            3393695767766752e-26,
            33452143996557983e-26,
            -0.2908948,
            34,
            -2956e-7,
            "2011-07-02T00:00:00Z",
            55744,
            2193297093339541e-22,
            2115460256837405e-21,
            -8241832578862112e-26,
            5623838700870617e-25,
            -0.29065,
            34,
            -1824e-7,
            "2011-07-03T00:00:00Z",
            55745,
            2262286080161428e-22,
            21191157519929706e-22,
            -3490658503988659e-25,
            6981317007977318e-25,
            -0.2905572,
            34,
            19e-7,
            "2011-07-04T00:00:00Z",
            55746,
            23411652660779493e-23,
            2122751854601292e-21,
            -6205615118202061e-25,
            7853981633974483e-25,
            -0.2907007,
            34,
            2695e-7
          ]
        }
      };
      const eop = new import__40.EarthOrientationParameters(eopDescription);
      const date = import__40.JulianDate.fromIso8601("2011-07-02T12:34:56Z");
      const result = eop.compute(date);
      const nColumns = eopDescription.data.columnNames.length;
      let x0 = eopDescription.data.samples[1 * nColumns + 2];
      let x1 = eopDescription.data.samples[2 * nColumns + 2];
      const dt = import__40.JulianDate.secondsDifference(
        date,
        import__40.JulianDate.fromIso8601(eopDescription.data.samples[nColumns])
      ) / 86400;
      let expected = linearInterp(dt, x0, x1);
      expect(result.xPoleWander).toEqualEpsilon(expected, 1e-22);
      x0 = eopDescription.data.samples[1 * nColumns + 3];
      x1 = eopDescription.data.samples[2 * nColumns + 3];
      expected = linearInterp(dt, x0, x1);
      expect(result.yPoleWander).toEqualEpsilon(expected, 1e-22);
      x0 = eopDescription.data.samples[1 * nColumns + 4];
      x1 = eopDescription.data.samples[2 * nColumns + 4];
      expected = linearInterp(dt, x0, x1);
      expect(result.xPoleOffset).toEqualEpsilon(expected, 1e-22);
      x0 = eopDescription.data.samples[1 * nColumns + 5];
      x1 = eopDescription.data.samples[2 * nColumns + 5];
      expected = linearInterp(dt, x0, x1);
      expect(result.yPoleOffset).toEqualEpsilon(expected, 1e-22);
      x0 = eopDescription.data.samples[1 * nColumns + 6];
      x1 = eopDescription.data.samples[2 * nColumns + 6];
      expected = linearInterp(dt, x0, x1);
      expect(result.ut1MinusUtc).toEqualEpsilon(expected, 1e-15);
    });
    it("interpolates UT1 correctly over a leap second", function() {
      const eopDescription = {
        data: {
          columnNames: [
            "dateIso8601",
            "modifiedJulianDateUtc",
            "xPoleWanderRadians",
            "yPoleWanderRadians",
            "xCelestialPoleOffsetRadians",
            "yCelestialPoleOffsetRadians",
            "ut1MinusUtcSeconds",
            "taiMinusUtcSeconds",
            "lengthOfDayCorrectionSeconds"
          ],
          samples: [
            "2008-12-30T00:00:00Z",
            54830,
            -46702101901281595e-24,
            6989752766028624e-22,
            -780550026586353e-24,
            -1052045688007693e-24,
            -0.5911461,
            33,
            57e-5,
            "2008-12-31T00:00:00Z",
            54831,
            -6507169227852191e-23,
            702873178598983e-21,
            -780550026586353e-24,
            -18907733563271904e-25,
            -0.59187,
            33,
            8303e-7,
            "2009-01-01T00:00:00Z",
            54832,
            -825443773457096e-22,
            7089575902969077e-22,
            -8047907106418297e-25,
            -20604581447155277e-25,
            0.4071533,
            34,
            10604e-7,
            "2009-01-02T00:00:00Z",
            54833,
            -9884381330461219e-23,
            7147559619229779e-22,
            -8435758051305926e-25,
            -18228994409718553e-25,
            0.4059739,
            34,
            12279e-7,
            "2009-01-03T00:00:00Z",
            54834,
            -11269009203710055e-23,
            7226826656091187e-22,
            -9066015836748322e-25,
            -15029224114395617e-25,
            0.404674,
            34,
            13014e-7
          ]
        }
      };
      const eop = new import__40.EarthOrientationParameters(eopDescription);
      const dateAtLeapSecond = import__40.JulianDate.fromIso8601("2009-01-01T00:00:00Z");
      const dateSlightlyBefore = import__40.JulianDate.addSeconds(
        dateAtLeapSecond,
        -1,
        new import__40.JulianDate()
      );
      const dateSlightlyAfter = import__40.JulianDate.addSeconds(
        dateAtLeapSecond,
        1,
        new import__40.JulianDate()
      );
      const nColumns = eopDescription.data.columnNames.length;
      const x0 = eopDescription.data.samples[1 * nColumns + 6];
      const x1 = eopDescription.data.samples[2 * nColumns + 6];
      const x2 = eopDescription.data.samples[3 * nColumns + 6];
      const t0 = import__40.JulianDate.fromIso8601(eopDescription.data.samples[nColumns]);
      const t1 = import__40.JulianDate.fromIso8601(
        eopDescription.data.samples[2 * nColumns]
      );
      let dt = import__40.JulianDate.secondsDifference(dateSlightlyBefore, t0) / (86400 + 1);
      const expectedBefore = linearInterp(dt, x0, x1 - 1);
      const resultBefore = eop.compute(dateSlightlyBefore);
      expect(resultBefore.ut1MinusUtc).toEqualEpsilon(expectedBefore, 1e-15);
      const expectedAt = eopDescription.data.samples[2 * nColumns + 6];
      const resultAt = eop.compute(dateAtLeapSecond);
      expect(resultAt.ut1MinusUtc).toEqualEpsilon(expectedAt, 1e-15);
      dt = import__40.JulianDate.secondsDifference(dateSlightlyAfter, t1) / 86400;
      const expectedAfter = linearInterp(dt, x1, x2);
      const resultAfter = eop.compute(dateSlightlyAfter);
      expect(resultAfter.ut1MinusUtc).toEqualEpsilon(expectedAfter, 1e-15);
      expect(
        Math.abs(resultBefore.ut1MinusUtc - resultAfter.ut1MinusUtc) > 0.5
      ).toEqual(true);
    });
  });
  it("fromUrl loads EOP data", async function() {
    const eop = await import__40.EarthOrientationParameters.fromUrl(
      "Data/EarthOrientationParameters/EOP-2011-July.json"
    );
    expect(eop).toBeInstanceOf(import__40.EarthOrientationParameters);
    const time2 = new import__40.JulianDate(2455745, 43200);
    const result = eop.compute(time2);
    expect(result.xPoleWander).not.toEqual(0);
    expect(result.yPoleWander).not.toEqual(0);
    expect(result.xPoleOffset).not.toEqual(0);
    expect(result.yPoleOffset).not.toEqual(0);
    expect(result.ut1MinusUtc).not.toEqual(0);
  });
  it("fromUrl throws a RuntimeError when loading invalid EOP data", async function() {
    await expectAsync(
      import__40.EarthOrientationParameters.fromUrl(
        "Data/EarthOrientationParameters/EOP-Invalid.json"
      )
    ).toBeRejectedWithError(
      import__40.RuntimeError,
      "Error in loaded EOP data: The columnNames property is required."
    );
  });
  it("fromUrl throws a RuntimeError when using a missing EOP data file", async function() {
    await expectAsync(
      import__40.EarthOrientationParameters.fromUrl(
        "Data/EarthOrientationParameters/EOP-DoesNotExist.json"
      )
    ).toBeRejectedWithError(
      import__40.RuntimeError,
      "An error occurred while retrieving the EOP data from the URL Data/EarthOrientationParameters/EOP-DoesNotExist.json."
    );
  });
});

// packages/engine/Specs/Core/EllipseGeometrySpec.js
var import__41 = __toESM(require_Cesium(), 1);
describe("Core/EllipseGeometry", function() {
  it("throws without a center", function() {
    expect(function() {
      return new import__41.EllipseGeometry({
        semiMajorAxis: 1,
        semiMinorAxis: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws without a semiMajorAxis", function() {
    expect(function() {
      return new import__41.EllipseGeometry({
        center: import__41.Cartesian3.fromDegrees(0, 0),
        semiMinorAxis: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws without a semiMinorAxis", function() {
    expect(function() {
      return new import__41.EllipseGeometry({
        center: import__41.Cartesian3.fromDegrees(0, 0),
        semiMajorAxis: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws with a negative granularity", function() {
    expect(function() {
      return new import__41.EllipseGeometry({
        center: import__41.Cartesian3.fromDegrees(0, 0),
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        granularity: -1
      });
    }).toThrowDeveloperError();
  });
  it("throws when semiMajorAxis is less than the semiMajorAxis", function() {
    expect(function() {
      return new import__41.EllipseGeometry({
        center: import__41.Cartesian3.fromDegrees(0, 0),
        semiMajorAxis: 1,
        semiMinorAxis: 2
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__41.EllipseGeometry.createGeometry(
      new import__41.EllipseGeometry({
        vertexFormat: import__41.VertexFormat.POSITION_ONLY,
        ellipsoid: import__41.Ellipsoid.WGS84,
        center: import__41.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1
      })
    );
    expect(m.attributes.position.values.length).toEqual(16 * 3);
    expect(m.indices.length).toEqual(22 * 3);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("compute all vertex attributes", function() {
    const m = import__41.EllipseGeometry.createGeometry(
      new import__41.EllipseGeometry({
        vertexFormat: import__41.VertexFormat.ALL,
        ellipsoid: import__41.Ellipsoid.WGS84,
        center: import__41.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1
      })
    );
    const numVertices = 16;
    const numTriangles = 22;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("compute texture coordinates with rotation", function() {
    const m = import__41.EllipseGeometry.createGeometry(
      new import__41.EllipseGeometry({
        vertexFormat: import__41.VertexFormat.POSITION_AND_ST,
        ellipsoid: import__41.Ellipsoid.WGS84,
        center: import__41.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        stRotation: import__41.Math.PI_OVER_TWO
      })
    );
    const positions = m.attributes.position.values;
    const st = m.attributes.st.values;
    const length2 = st.length;
    const numVertices = 16;
    const numTriangles = 22;
    expect(positions.length).toEqual(numVertices * 3);
    expect(length2).toEqual(numVertices * 2);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(st[length2 - 2]).toEqualEpsilon(0.5, import__41.Math.EPSILON2);
    expect(st[length2 - 1]).toEqualEpsilon(0, import__41.Math.EPSILON2);
  });
  it("computes positions extruded", function() {
    const m = import__41.EllipseGeometry.createGeometry(
      new import__41.EllipseGeometry({
        vertexFormat: import__41.VertexFormat.POSITION_ONLY,
        ellipsoid: import__41.Ellipsoid.WGS84,
        center: import__41.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        extrudedHeight: 5e4
      })
    );
    const numVertices = 48;
    const numTriangles = 60;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes offset attribute", function() {
    const m = import__41.EllipseGeometry.createGeometry(
      new import__41.EllipseGeometry({
        vertexFormat: import__41.VertexFormat.POSITION_ONLY,
        ellipsoid: import__41.Ellipsoid.WGS84,
        center: import__41.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        offsetAttribute: import__41.GeometryOffsetAttribute.TOP
      })
    );
    const numVertices = 16;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes offset attribute extruded for top vertices", function() {
    const m = import__41.EllipseGeometry.createGeometry(
      new import__41.EllipseGeometry({
        vertexFormat: import__41.VertexFormat.POSITION_ONLY,
        ellipsoid: import__41.Ellipsoid.WGS84,
        center: import__41.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        extrudedHeight: 5e4,
        offsetAttribute: import__41.GeometryOffsetAttribute.TOP
      })
    );
    const numVertices = 48;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(0).fill(1, 0, 16).fill(1, 32, 40);
    expect(offset).toEqual(expected);
  });
  it("computes offset attribute extruded for all vertices", function() {
    const m = import__41.EllipseGeometry.createGeometry(
      new import__41.EllipseGeometry({
        vertexFormat: import__41.VertexFormat.POSITION_ONLY,
        ellipsoid: import__41.Ellipsoid.WGS84,
        center: import__41.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        extrudedHeight: 5e4,
        offsetAttribute: import__41.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 48;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("compute all vertex attributes extruded", function() {
    const m = import__41.EllipseGeometry.createGeometry(
      new import__41.EllipseGeometry({
        vertexFormat: import__41.VertexFormat.ALL,
        ellipsoid: import__41.Ellipsoid.WGS84,
        center: import__41.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        extrudedHeight: 5e4
      })
    );
    const numVertices = 48;
    const numTriangles = 60;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("undefined is returned if the minor axis is equal to or less than zero", function() {
    const ellipse0 = new import__41.EllipseGeometry({
      center: import__41.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: 3e5,
      semiMinorAxis: 0
    });
    const ellipse1 = new import__41.EllipseGeometry({
      center: import__41.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: 0,
      semiMinorAxis: -1
    });
    const ellipse2 = new import__41.EllipseGeometry({
      center: import__41.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: 3e5,
      semiMinorAxis: -10
    });
    const ellipse3 = new import__41.EllipseGeometry({
      center: import__41.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: -1,
      semiMinorAxis: -2
    });
    const geometry0 = import__41.EllipseGeometry.createGeometry(ellipse0);
    const geometry1 = import__41.EllipseGeometry.createGeometry(ellipse1);
    const geometry2 = import__41.EllipseGeometry.createGeometry(ellipse2);
    const geometry3 = import__41.EllipseGeometry.createGeometry(ellipse3);
    expect(geometry0).toBeUndefined();
    expect(geometry1).toBeUndefined();
    expect(geometry2).toBeUndefined();
    expect(geometry3).toBeUndefined();
  });
  it("createShadowVolume uses properties from geometry", function() {
    const m = new import__41.EllipseGeometry({
      center: import__41.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: 3e3,
      semiMinorAxis: 1500,
      ellipsoid: import__41.Ellipsoid.WGS84,
      rotation: import__41.Math.PI_OVER_TWO,
      stRotation: import__41.Math.PI_OVER_FOUR,
      granularity: 1e4,
      extrudedHeight: 0,
      height: 100,
      vertexFormat: import__41.VertexFormat.ALL
    });
    const minHeightFunc = function() {
      return 100;
    };
    const maxHeightFunc = function() {
      return 1e3;
    };
    const sv = import__41.EllipseGeometry.createShadowVolume(
      m,
      minHeightFunc,
      maxHeightFunc
    );
    expect(sv._center.equals(m._center)).toBe(true);
    expect(sv._semiMajorAxis).toBe(m._semiMajorAxis);
    expect(sv._semiMinorAxis).toBe(m._semiMinorAxis);
    expect(sv._ellipsoid.equals(m._ellipsoid)).toBe(true);
    expect(sv._rotation).toBe(m._rotation);
    expect(sv._stRotation).toBe(m._stRotation);
    expect(sv._granularity).toBe(m._granularity);
    expect(sv._extrudedHeight).toBe(minHeightFunc());
    expect(sv._height).toBe(maxHeightFunc());
    expect(sv._vertexFormat.bitangent).toBe(
      import__41.VertexFormat.POSITION_ONLY.bitangent
    );
    expect(sv._vertexFormat.color).toBe(import__41.VertexFormat.POSITION_ONLY.color);
    expect(sv._vertexFormat.normal).toBe(import__41.VertexFormat.POSITION_ONLY.normal);
    expect(sv._vertexFormat.position).toBe(import__41.VertexFormat.POSITION_ONLY.position);
    expect(sv._vertexFormat.st).toBe(import__41.VertexFormat.POSITION_ONLY.st);
    expect(sv._vertexFormat.tangent).toBe(import__41.VertexFormat.POSITION_ONLY.tangent);
  });
  it("computing rectangle property", function() {
    let center2 = import__41.Cartesian3.fromDegrees(-75.59777, 40.03883);
    let ellipse = new import__41.EllipseGeometry({
      center: center2,
      semiMajorAxis: 2e3,
      semiMinorAxis: 1e3
    });
    let r = ellipse.rectangle;
    expect(r.north).toEqualEpsilon(0.6989665987920752, import__41.Math.EPSILON7);
    expect(r.south).toEqualEpsilon(0.6986522252554146, import__41.Math.EPSILON7);
    expect(r.east).toEqualEpsilon(-1.3190209903056758, import__41.Math.EPSILON7);
    expect(r.west).toEqualEpsilon(-1.3198389970251112, import__41.Math.EPSILON7);
    center2 = import__41.Cartesian3.fromDegrees(0, 90);
    ellipse = new import__41.EllipseGeometry({
      center: center2,
      semiMajorAxis: 2e3,
      semiMinorAxis: 1e3
    });
    r = ellipse.rectangle;
    expect(r.north).toEqualEpsilon(
      import__41.Math.PI_OVER_TWO - import__41.Math.EPSILON7,
      import__41.Math.EPSILON7
    );
    expect(r.south).toEqualEpsilon(1.570483806950967, import__41.Math.EPSILON7);
    expect(r.east).toEqualEpsilon(import__41.Math.PI, import__41.Math.EPSILON7);
    expect(r.west).toEqualEpsilon(-import__41.Math.PI, import__41.Math.EPSILON7);
  });
  it("computeRectangle", function() {
    const options = {
      center: import__41.Cartesian3.fromDegrees(-30, 33),
      semiMajorAxis: 2e3,
      semiMinorAxis: 1e3,
      rotation: import__41.Math.PI_OVER_TWO,
      granularity: 0.5,
      ellipsoid: import__41.Ellipsoid.UNIT_SPHERE
    };
    const geometry = new import__41.EllipseGeometry(options);
    const expected = geometry.rectangle;
    const result = import__41.EllipseGeometry.computeRectangle(options);
    expect(result).toEqual(expected);
  });
  it("computeRectangle with result parameter", function() {
    const options = {
      center: import__41.Cartesian3.fromDegrees(30, -33),
      semiMajorAxis: 500,
      semiMinorAxis: 200
    };
    const geometry = new import__41.EllipseGeometry(options);
    const result = new import__41.Rectangle();
    const expected = geometry.rectangle;
    const returned = import__41.EllipseGeometry.computeRectangle(options, result);
    expect(returned).toEqual(expected);
    expect(returned).toBe(result);
  });
  it("computing textureCoordinateRotationPoints property", function() {
    const center2 = import__41.Cartesian3.fromDegrees(0, 0);
    let ellipse = new import__41.EllipseGeometry({
      center: center2,
      semiMajorAxis: 2e3,
      semiMinorAxis: 1e3,
      stRotation: import__41.Math.toRadians(90)
    });
    let textureCoordinateRotationPoints = ellipse.textureCoordinateRotationPoints;
    expect(textureCoordinateRotationPoints.length).toEqual(6);
    expect(textureCoordinateRotationPoints[0]).toEqualEpsilon(
      0,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[1]).toEqualEpsilon(
      1,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[2]).toEqualEpsilon(
      1,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[3]).toEqualEpsilon(
      1,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[4]).toEqualEpsilon(
      0,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[5]).toEqualEpsilon(
      0,
      import__41.Math.EPSILON7
    );
    ellipse = new import__41.EllipseGeometry({
      center: center2,
      semiMajorAxis: 2e3,
      semiMinorAxis: 1e3,
      stRotation: import__41.Math.toRadians(0)
    });
    textureCoordinateRotationPoints = ellipse.textureCoordinateRotationPoints;
    expect(textureCoordinateRotationPoints.length).toEqual(6);
    expect(textureCoordinateRotationPoints[0]).toEqualEpsilon(
      0,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[1]).toEqualEpsilon(
      0,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[2]).toEqualEpsilon(
      0,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[3]).toEqualEpsilon(
      1,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[4]).toEqualEpsilon(
      1,
      import__41.Math.EPSILON7
    );
    expect(textureCoordinateRotationPoints[5]).toEqualEpsilon(
      0,
      import__41.Math.EPSILON7
    );
  });
  const center = import__41.Cartesian3.fromDegrees(0, 0);
  const ellipsoid = import__41.Ellipsoid.WGS84;
  const packableInstance = new import__41.EllipseGeometry({
    vertexFormat: import__41.VertexFormat.POSITION_AND_ST,
    ellipsoid,
    center,
    granularity: 0.1,
    semiMajorAxis: 1,
    semiMinorAxis: 1,
    stRotation: import__41.Math.PI_OVER_TWO
  });
  const packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    import__41.Math.PI_OVER_TWO,
    0,
    0.1,
    0,
    0,
    -1
  ];
  createPackableSpecs_default(import__41.EllipseGeometry, packableInstance, packedInstance);
});

// packages/engine/Specs/Core/EllipseOutlineGeometrySpec.js
var import__42 = __toESM(require_Cesium(), 1);
describe("Core/EllipseOutlineGeometry", function() {
  it("throws without a center", function() {
    expect(function() {
      return new import__42.EllipseOutlineGeometry({
        semiMajorAxis: 1,
        semiMinorAxis: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws without a semiMajorAxis", function() {
    expect(function() {
      return new import__42.EllipseOutlineGeometry({
        center: import__42.Cartesian3.fromDegrees(0, 0),
        semiMinorAxis: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws without a semiMinorAxis", function() {
    expect(function() {
      return new import__42.EllipseOutlineGeometry({
        center: import__42.Cartesian3.fromDegrees(0, 0),
        semiMajorAxis: 1
      });
    }).toThrowDeveloperError();
  });
  it("throws with a negative granularity", function() {
    expect(function() {
      return new import__42.EllipseOutlineGeometry({
        center: import__42.Cartesian3.fromDegrees(0, 0),
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        granularity: -1
      });
    }).toThrowDeveloperError();
  });
  it("throws when semiMajorAxis is less than the semiMajorAxis", function() {
    expect(function() {
      return new import__42.EllipseOutlineGeometry({
        center: import__42.Cartesian3.fromDegrees(0, 0),
        semiMajorAxis: 1,
        semiMinorAxis: 2
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__42.EllipseOutlineGeometry.createGeometry(
      new import__42.EllipseOutlineGeometry({
        ellipsoid: import__42.Ellipsoid.WGS84,
        center: import__42.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1
      })
    );
    expect(m.attributes.position.values.length).toEqual(8 * 3);
    expect(m.indices.length).toEqual(8 * 2);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes positions extruded", function() {
    const m = import__42.EllipseOutlineGeometry.createGeometry(
      new import__42.EllipseOutlineGeometry({
        ellipsoid: import__42.Ellipsoid.WGS84,
        center: import__42.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        extrudedHeight: 5
      })
    );
    expect(m.attributes.position.values.length).toEqual(16 * 3);
    expect(m.indices.length).toEqual(24 * 2);
  });
  it("computes offset attribute", function() {
    const m = import__42.EllipseOutlineGeometry.createGeometry(
      new import__42.EllipseOutlineGeometry({
        ellipsoid: import__42.Ellipsoid.WGS84,
        center: import__42.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        offsetAttribute: import__42.GeometryOffsetAttribute.TOP
      })
    );
    const numVertices = 8;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes offset attribute extruded for top vertices", function() {
    const m = import__42.EllipseOutlineGeometry.createGeometry(
      new import__42.EllipseOutlineGeometry({
        ellipsoid: import__42.Ellipsoid.WGS84,
        center: import__42.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        extrudedHeight: 5,
        offsetAttribute: import__42.GeometryOffsetAttribute.TOP
      })
    );
    const numVertices = 16;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(0).fill(1, 0, 8);
    expect(offset).toEqual(expected);
  });
  it("computes offset attribute extruded for all vertices", function() {
    const m = import__42.EllipseOutlineGeometry.createGeometry(
      new import__42.EllipseOutlineGeometry({
        ellipsoid: import__42.Ellipsoid.WGS84,
        center: import__42.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        extrudedHeight: 5,
        offsetAttribute: import__42.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 16;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes positions extruded, no lines drawn between top and bottom", function() {
    const m = import__42.EllipseOutlineGeometry.createGeometry(
      new import__42.EllipseOutlineGeometry({
        ellipsoid: import__42.Ellipsoid.WGS84,
        center: import__42.Cartesian3.fromDegrees(0, 0),
        granularity: 0.1,
        semiMajorAxis: 1,
        semiMinorAxis: 1,
        extrudedHeight: 5,
        numberOfVerticalLines: 0
      })
    );
    expect(m.attributes.position.values.length).toEqual(16 * 3);
    expect(m.indices.length).toEqual(16 * 2);
  });
  it("undefined is returned if the minor axis is equal to or less than zero", function() {
    const ellipseOutline0 = new import__42.EllipseOutlineGeometry({
      center: import__42.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: 3e5,
      semiMinorAxis: 0
    });
    const ellipseOutline1 = new import__42.EllipseOutlineGeometry({
      center: import__42.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: 0,
      semiMinorAxis: -1
    });
    const ellipseOutline2 = new import__42.EllipseOutlineGeometry({
      center: import__42.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: 3e5,
      semiMinorAxis: -10
    });
    const ellipseOutline3 = new import__42.EllipseOutlineGeometry({
      center: import__42.Cartesian3.fromDegrees(-75.59777, 40.03883),
      semiMajorAxis: -1,
      semiMinorAxis: -2
    });
    const geometry0 = import__42.EllipseOutlineGeometry.createGeometry(ellipseOutline0);
    const geometry1 = import__42.EllipseOutlineGeometry.createGeometry(ellipseOutline1);
    const geometry2 = import__42.EllipseOutlineGeometry.createGeometry(ellipseOutline2);
    const geometry3 = import__42.EllipseOutlineGeometry.createGeometry(ellipseOutline3);
    expect(geometry0).toBeUndefined();
    expect(geometry1).toBeUndefined();
    expect(geometry2).toBeUndefined();
    expect(geometry3).toBeUndefined();
  });
  const center = new import__42.Cartesian3(8, 9, 10);
  const ellipsoid = new import__42.Ellipsoid(11, 12, 13);
  let packableInstance = new import__42.EllipseOutlineGeometry({
    ellipsoid,
    center,
    granularity: 1,
    semiMinorAxis: 2,
    semiMajorAxis: 3,
    numberOfVerticalLines: 4,
    height: 5,
    rotation: 6,
    extrudedHeight: 7
  });
  let packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    3,
    2,
    6,
    7,
    1,
    5,
    4,
    -1
  ];
  createPackableSpecs_default(
    import__42.EllipseOutlineGeometry,
    packableInstance,
    packedInstance,
    "extruded"
  );
  packableInstance = new import__42.EllipseOutlineGeometry({
    ellipsoid,
    center,
    granularity: 1,
    semiMinorAxis: 2,
    semiMajorAxis: 3,
    numberOfVerticalLines: 4,
    height: 5,
    rotation: 6
  });
  packedInstance = [
    center.x,
    center.y,
    center.z,
    ellipsoid.radii.x,
    ellipsoid.radii.y,
    ellipsoid.radii.z,
    3,
    2,
    6,
    5,
    1,
    5,
    4,
    -1
  ];
  createPackableSpecs_default(
    import__42.EllipseOutlineGeometry,
    packableInstance,
    packedInstance,
    "at height"
  );
});

// packages/engine/Specs/Core/EllipsoidGeodesicSpec.js
var import__43 = __toESM(require_Cesium(), 1);
describe("Core/EllipsoidGeodesic", function() {
  it("throws without start", function() {
    expect(function() {
      const elGeo = new import__43.EllipsoidGeodesic();
      return elGeo.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("throws without end", function() {
    expect(function() {
      const elGeo = new import__43.EllipsoidGeodesic(new import__43.Cartographic(Math.PI, Math.PI));
      return elGeo.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("throws without unique position", function() {
    expect(function() {
      const elGeo = new import__43.EllipsoidGeodesic(
        new import__43.Cartographic(Math.PI, Math.PI),
        new import__43.Cartographic(0, Math.PI)
      );
      return elGeo.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("setEndPoints throws without start", function() {
    expect(function() {
      const elGeo = new import__43.EllipsoidGeodesic();
      elGeo.setEndPoints();
    }).toThrowDeveloperError();
  });
  it("setEndPoints throws without end", function() {
    expect(function() {
      const start = new import__43.Cartographic(import__43.Math.PI_OVER_TWO, 0);
      const elGeo = new import__43.EllipsoidGeodesic();
      elGeo.setEndPoints(start);
      return elGeo.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("getSurfaceDistance throws if start or end never defined", function() {
    expect(function() {
      const elGeo = new import__43.EllipsoidGeodesic();
      return elGeo.surfaceDistance;
    }).toThrowDeveloperError();
  });
  it("getStartHeading throws if start or end never defined", function() {
    expect(function() {
      const elGeo = new import__43.EllipsoidGeodesic();
      return elGeo.startHeading;
    }).toThrowDeveloperError();
  });
  it("getEndHeading throws if start or end never defined", function() {
    expect(function() {
      const elGeo = new import__43.EllipsoidGeodesic();
      return elGeo.endHeading;
    }).toThrowDeveloperError();
  });
  it("works with two points", function() {
    const fifteenDegrees = Math.PI / 12;
    const start = new import__43.Cartographic(fifteenDegrees, fifteenDegrees);
    const thirtyDegrees = Math.PI / 6;
    const end = new import__43.Cartographic(thirtyDegrees, thirtyDegrees);
    const geodesic = new import__43.EllipsoidGeodesic(start, end);
    expect(start).toEqual(geodesic.start);
    expect(end).toEqual(geodesic.end);
  });
  it("sets end points", function() {
    const start = new import__43.Cartographic(import__43.Math.PI_OVER_TWO, 0);
    const end = new import__43.Cartographic(
      import__43.Math.PI_OVER_TWO,
      import__43.Math.PI_OVER_TWO
    );
    const geodesic = new import__43.EllipsoidGeodesic();
    geodesic.setEndPoints(start, end);
    expect(start).toEqual(geodesic.start);
    expect(end).toEqual(geodesic.end);
  });
  it("gets start heading", function() {
    const ellipsoid = new import__43.Ellipsoid(6, 6, 3);
    const start = new import__43.Cartographic(import__43.Math.PI_OVER_TWO, 0);
    const end = new import__43.Cartographic(Math.PI, 0);
    const geodesic = new import__43.EllipsoidGeodesic(start, end, ellipsoid);
    expect(import__43.Math.PI_OVER_TWO).toEqualEpsilon(
      geodesic.startHeading,
      import__43.Math.EPSILON11
    );
  });
  it("gets end heading", function() {
    const ellipsoid = new import__43.Ellipsoid(6, 6, 3);
    const start = new import__43.Cartographic(import__43.Math.PI_OVER_TWO, 0);
    const end = new import__43.Cartographic(Math.PI, 0);
    const geodesic = new import__43.EllipsoidGeodesic(start, end, ellipsoid);
    expect(import__43.Math.PI_OVER_TWO).toEqualEpsilon(
      geodesic.endHeading,
      import__43.Math.EPSILON11
    );
  });
  it("computes distance at equator", function() {
    const ellipsoid = new import__43.Ellipsoid(6, 6, 3);
    const start = new import__43.Cartographic(import__43.Math.PI_OVER_TWO, 0);
    const end = new import__43.Cartographic(Math.PI, 0);
    const geodesic = new import__43.EllipsoidGeodesic(start, end, ellipsoid);
    expect(import__43.Math.PI_OVER_TWO * 6).toEqualEpsilon(
      geodesic.surfaceDistance,
      import__43.Math.EPSILON11
    );
  });
  it("computes distance very close to equator", function() {
    const ellipsoid = new import__43.Ellipsoid(6, 6, 3);
    const start = new import__43.Cartographic(-import__43.Math.EPSILON10, import__43.Math.EPSILON10);
    const end = new import__43.Cartographic(+import__43.Math.EPSILON10, import__43.Math.EPSILON10);
    const geodesic = new import__43.EllipsoidGeodesic(start, end, ellipsoid);
    expect(geodesic.surfaceDistance).not.toBeNaN();
  });
  it("computes distance at meridian", function() {
    const ellipsoid = new import__43.Ellipsoid(6, 6, 6);
    const fifteenDegrees = Math.PI / 12;
    const start = new import__43.Cartographic(import__43.Math.PI_OVER_TWO, fifteenDegrees);
    const fortyfiveDegrees = Math.PI / 4;
    const end = new import__43.Cartographic(import__43.Math.PI_OVER_TWO, fortyfiveDegrees);
    const geodesic = new import__43.EllipsoidGeodesic(start, end, ellipsoid);
    const thirtyDegrees = Math.PI / 6;
    expect(thirtyDegrees * 6).toEqualEpsilon(
      geodesic.surfaceDistance,
      import__43.Math.EPSILON11
    );
  });
  it("computes distance at pole", function() {
    const ellipsoid = new import__43.Ellipsoid(6, 6, 6);
    const seventyfiveDegrees = Math.PI / 12 * 5;
    const fortyfiveDegrees = Math.PI / 4;
    const start = new import__43.Cartographic(0, -fortyfiveDegrees);
    const end = new import__43.Cartographic(Math.PI, -seventyfiveDegrees);
    const geodesic = new import__43.EllipsoidGeodesic(start, end, ellipsoid);
    const sixtyDegrees = Math.PI / 3;
    expect(sixtyDegrees * 6).toEqualEpsilon(
      geodesic.surfaceDistance,
      import__43.Math.EPSILON11
    );
  });
  it("interpolates start and end points", function() {
    const fifteenDegrees = Math.PI / 12;
    const start = new import__43.Cartographic(fifteenDegrees, fifteenDegrees);
    const thirtyDegrees = Math.PI / 6;
    const end = new import__43.Cartographic(thirtyDegrees, thirtyDegrees);
    const geodesic = new import__43.EllipsoidGeodesic(start, end);
    const distance = geodesic.surfaceDistance;
    const first = geodesic.interpolateUsingSurfaceDistance(0);
    const last = geodesic.interpolateUsingSurfaceDistance(distance);
    expect(start.longitude).toEqualEpsilon(
      first.longitude,
      import__43.Math.EPSILON13
    );
    expect(start.latitude).toEqualEpsilon(first.latitude, import__43.Math.EPSILON13);
    expect(end.longitude).toEqualEpsilon(last.longitude, import__43.Math.EPSILON13);
    expect(end.latitude).toEqualEpsilon(last.latitude, import__43.Math.EPSILON13);
  });
  it("interpolates midpoint", function() {
    const fifteenDegrees = Math.PI / 12;
    const start = new import__43.Cartographic(fifteenDegrees, 0);
    const fortyfiveDegrees = Math.PI / 4;
    const end = new import__43.Cartographic(fortyfiveDegrees, 0);
    const thirtyDegrees = Math.PI / 6;
    const expectedMid = new import__43.Cartographic(thirtyDegrees, 0);
    const geodesic = new import__43.EllipsoidGeodesic(start, end);
    const distance = import__43.Ellipsoid.WGS84.radii.x * fifteenDegrees;
    const midpoint = geodesic.interpolateUsingSurfaceDistance(distance);
    expect(expectedMid.longitude).toEqualEpsilon(
      midpoint.longitude,
      import__43.Math.EPSILON13
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      midpoint.latitude,
      import__43.Math.EPSILON13
    );
  });
  it("interpolates start and end points using fraction", function() {
    const fifteenDegrees = Math.PI / 12;
    const start = new import__43.Cartographic(fifteenDegrees, fifteenDegrees);
    const thirtyDegrees = Math.PI / 6;
    const end = new import__43.Cartographic(thirtyDegrees, thirtyDegrees);
    const geodesic = new import__43.EllipsoidGeodesic(start, end);
    const first = geodesic.interpolateUsingFraction(0);
    const last = geodesic.interpolateUsingFraction(1);
    expect(start.longitude).toEqualEpsilon(
      first.longitude,
      import__43.Math.EPSILON13
    );
    expect(start.latitude).toEqualEpsilon(first.latitude, import__43.Math.EPSILON13);
    expect(end.longitude).toEqualEpsilon(last.longitude, import__43.Math.EPSILON13);
    expect(end.latitude).toEqualEpsilon(last.latitude, import__43.Math.EPSILON13);
  });
  it("interpolates midpoint using fraction", function() {
    const fifteenDegrees = Math.PI / 12;
    const start = new import__43.Cartographic(fifteenDegrees, 0);
    const fortyfiveDegrees = Math.PI / 4;
    const end = new import__43.Cartographic(fortyfiveDegrees, 0);
    const thirtyDegrees = Math.PI / 6;
    const expectedMid = new import__43.Cartographic(thirtyDegrees, 0);
    const geodesic = new import__43.EllipsoidGeodesic(start, end);
    const midpoint = geodesic.interpolateUsingFraction(0.5);
    expect(expectedMid.longitude).toEqualEpsilon(
      midpoint.longitude,
      import__43.Math.EPSILON12
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      midpoint.latitude,
      import__43.Math.EPSILON12
    );
  });
  it("interpolates midpoint fraction using result parameter", function() {
    const fifteenDegrees = Math.PI / 12;
    const start = new import__43.Cartographic(fifteenDegrees, 0);
    const fortyfiveDegrees = Math.PI / 4;
    const end = new import__43.Cartographic(fortyfiveDegrees, 0);
    const thirtyDegrees = Math.PI / 6;
    const expectedMid = new import__43.Cartographic(thirtyDegrees, 0);
    const geodesic = new import__43.EllipsoidGeodesic(start, end);
    const result = new import__43.Cartographic();
    const midpoint = geodesic.interpolateUsingFraction(0.5, result);
    expect(result).toBe(midpoint);
    expect(expectedMid.longitude).toEqualEpsilon(
      result.longitude,
      import__43.Math.EPSILON12
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      result.latitude,
      import__43.Math.EPSILON12
    );
  });
  it("interpolates midpoint using result parameter", function() {
    const fifteenDegrees = Math.PI / 12;
    const start = new import__43.Cartographic(fifteenDegrees, 0);
    const fortyfiveDegrees = Math.PI / 4;
    const end = new import__43.Cartographic(fortyfiveDegrees, 0);
    const thirtyDegrees = Math.PI / 6;
    const expectedMid = new import__43.Cartographic(thirtyDegrees, 0);
    const geodesic = new import__43.EllipsoidGeodesic(start, end);
    const distance = import__43.Ellipsoid.WGS84.radii.x * fifteenDegrees;
    const result = new import__43.Cartographic();
    const midpoint = geodesic.interpolateUsingSurfaceDistance(distance, result);
    expect(result).toBe(midpoint);
    expect(expectedMid.longitude).toEqualEpsilon(
      result.longitude,
      import__43.Math.EPSILON13
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      result.latitude,
      import__43.Math.EPSILON13
    );
  });
});

// packages/engine/Specs/Core/EllipsoidGeometrySpec.js
var import__44 = __toESM(require_Cesium(), 1);
describe("Core/EllipsoidGeometry", function() {
  it("constructor rounds floating-point slicePartitions", function() {
    const m = new import__44.EllipsoidGeometry({
      slicePartitions: 3.5,
      stackPartitions: 3
    });
    expect(m._slicePartitions).toEqual(4);
  });
  it("constructor rounds floating-point stackPartitions", function() {
    const m = new import__44.EllipsoidGeometry({
      slicePartitions: 3,
      stackPartitions: 3.5
    });
    expect(m._stackPartitions).toEqual(4);
  });
  it("constructor throws with invalid slicePartitions", function() {
    expect(function() {
      return new import__44.EllipsoidGeometry({
        slicePartitions: -1
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws with invalid stackPartitions", function() {
    expect(function() {
      return new import__44.EllipsoidGeometry({
        stackPartitions: -1
      });
    }).toThrowDeveloperError();
  });
  it("computes positions", function() {
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.POSITION_ONLY,
        slicePartitions: 3,
        stackPartitions: 3
      })
    );
    const numVertices = 36;
    const numTriangles = 18;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes offset attribute", function() {
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.POSITION_ONLY,
        slicePartitions: 3,
        stackPartitions: 3,
        offsetAttribute: import__44.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 36;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("compute all vertex attributes", function() {
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.ALL,
        slicePartitions: 3,
        stackPartitions: 3
      })
    );
    const numVertices = 36;
    const numTriangles = 18;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
  });
  it("computes attributes for a unit sphere", function() {
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.ALL,
        slicePartitions: 3,
        stackPartitions: 3
      })
    );
    const positions = m.attributes.position.values;
    const normals = m.attributes.normal.values;
    const tangents = m.attributes.tangent.values;
    const bitangents = m.attributes.bitangent.values;
    for (let i = 0; i < positions.length; i += 3) {
      const position = import__44.Cartesian3.fromArray(positions, i);
      const normal = import__44.Cartesian3.fromArray(normals, i);
      const tangent = import__44.Cartesian3.fromArray(tangents, i);
      const bitangent = import__44.Cartesian3.fromArray(bitangents, i);
      expect(import__44.Cartesian3.magnitude(position)).toEqualEpsilon(
        1,
        import__44.Math.EPSILON10
      );
      expect(normal).toEqualEpsilon(
        import__44.Cartesian3.normalize(position, new import__44.Cartesian3()),
        import__44.Math.EPSILON7
      );
      expect(import__44.Cartesian3.dot(import__44.Cartesian3.UNIT_Z, tangent)).not.toBeLessThan(0);
      expect(bitangent).toEqualEpsilon(
        import__44.Cartesian3.cross(normal, tangent, new import__44.Cartesian3()),
        import__44.Math.EPSILON7
      );
    }
  });
  it("computes positions with inner surface", function() {
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.POSITION_ONLY,
        slicePartitions: 3,
        stackPartitions: 3,
        innerRadii: new import__44.Cartesian3(0.5, 0.5, 0.5)
      })
    );
    const numVertices = 72;
    const numTriangles = 36;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes positions with inner surface and partial clock range", function() {
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.POSITION_ONLY,
        slicePartitions: 4,
        stackPartitions: 4,
        innerRadii: new import__44.Cartesian3(0.5, 0.5, 0.5),
        minimumClock: import__44.Math.toRadians(90),
        maximumClock: import__44.Math.toRadians(270)
      })
    );
    const numVertices = 70;
    const numTriangles = 48;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes positions with inner surface and partial clock range and open top", function() {
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.POSITION_ONLY,
        slicePartitions: 4,
        stackPartitions: 4,
        innerRadii: new import__44.Cartesian3(0.5, 0.5, 0.5),
        minimumClock: import__44.Math.toRadians(90),
        maximumClock: import__44.Math.toRadians(270),
        minimumCone: import__44.Math.toRadians(30)
      })
    );
    const numVertices = 60;
    const numTriangles = 40;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes partitions to default to 2 if less than 2", function() {
    const geometry = new import__44.EllipsoidGeometry({
      radii: new import__44.Cartesian3(0.5, 0.5, 0.5)
    });
    geometry._slicePartitions = 0;
    geometry._stackPartitions = 0;
    const m = import__44.EllipsoidGeometry.createGeometry(geometry);
    expect(m.indices.length).toEqual(6);
  });
  it("negates normals on an ellipsoid", function() {
    let negatedNormals = 0;
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.ALL,
        radii: new import__44.Cartesian3(1, 1, 1),
        innerRadii: new import__44.Cartesian3(0.5, 0.5, 0.5),
        minimumCone: import__44.Math.toRadians(60),
        maximumCone: import__44.Math.toRadians(140)
      })
    );
    const positions = m.attributes.position.values;
    const normals = m.attributes.normal.values;
    for (let i = 0; i < positions.length; i += 3) {
      const normal = import__44.Cartesian3.fromArray(normals, i);
      if (normal.x < 0 && normal.y < 0 && normal.z < 0) {
        negatedNormals++;
      }
    }
    expect(negatedNormals).toEqual(496);
  });
  it("computes the unit ellipsoid", function() {
    const ellipsoid = import__44.EllipsoidGeometry.getUnitEllipsoid();
    expect(ellipsoid).toBeDefined();
    expect(ellipsoid.boundingSphere.radius).toEqual(1);
    expect(import__44.EllipsoidGeometry.getUnitEllipsoid()).toBe(ellipsoid);
  });
  it("computes positions with inner surface and partial clock range and open top and bottom", function() {
    const m = import__44.EllipsoidGeometry.createGeometry(
      new import__44.EllipsoidGeometry({
        vertexFormat: import__44.VertexFormat.POSITION_ONLY,
        slicePartitions: 4,
        stackPartitions: 4,
        innerRadii: new import__44.Cartesian3(0.5, 0.5, 0.5),
        minimumClock: import__44.Math.toRadians(90),
        maximumClock: import__44.Math.toRadians(270),
        minimumCone: import__44.Math.toRadians(30),
        maximumCone: import__44.Math.toRadians(120)
      })
    );
    const numVertices = 50;
    const numTriangles = 32;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("undefined is returned if the x, y, or z radii or innerRadii are equal or less than zero", function() {
    const ellipsoid0 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(0, 5e5, 5e5)
    });
    const ellipsoid1 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(1e6, 0, 5e5)
    });
    const ellipsoid2 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(1e6, 5e5, 0)
    });
    const ellipsoid3 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(-10, 5e5, 5e5)
    });
    const ellipsoid4 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(1e6, -10, 5e5)
    });
    const ellipsoid5 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(1e6, 5e5, -10)
    });
    const ellipsoid6 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__44.Cartesian3(0, 1e5, 1e5)
    });
    const ellipsoid7 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__44.Cartesian3(1e5, 0, 1e5)
    });
    const ellipsoid8 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__44.Cartesian3(1e5, 1e5, 0)
    });
    const ellipsoid9 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__44.Cartesian3(-10, 1e5, 1e5)
    });
    const ellipsoid10 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__44.Cartesian3(1e5, -10, 1e5)
    });
    const ellipsoid11 = new import__44.EllipsoidGeometry({
      vertexFormat: import__44.VertexFormat.POSITION_ONLY,
      radii: new import__44.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__44.Cartesian3(1e5, 1e5, -10)
    });
    const geometry0 = import__44.EllipsoidGeometry.createGeometry(ellipsoid0);
    const geometry1 = import__44.EllipsoidGeometry.createGeometry(ellipsoid1);
    const geometry2 = import__44.EllipsoidGeometry.createGeometry(ellipsoid2);
    const geometry3 = import__44.EllipsoidGeometry.createGeometry(ellipsoid3);
    const geometry4 = import__44.EllipsoidGeometry.createGeometry(ellipsoid4);
    const geometry5 = import__44.EllipsoidGeometry.createGeometry(ellipsoid5);
    const geometry6 = import__44.EllipsoidGeometry.createGeometry(ellipsoid6);
    const geometry7 = import__44.EllipsoidGeometry.createGeometry(ellipsoid7);
    const geometry8 = import__44.EllipsoidGeometry.createGeometry(ellipsoid8);
    const geometry9 = import__44.EllipsoidGeometry.createGeometry(ellipsoid9);
    const geometry10 = import__44.EllipsoidGeometry.createGeometry(ellipsoid10);
    const geometry11 = import__44.EllipsoidGeometry.createGeometry(ellipsoid11);
    expect(geometry0).toBeUndefined();
    expect(geometry1).toBeUndefined();
    expect(geometry2).toBeUndefined();
    expect(geometry3).toBeUndefined();
    expect(geometry4).toBeUndefined();
    expect(geometry5).toBeUndefined();
    expect(geometry6).toBeUndefined();
    expect(geometry7).toBeUndefined();
    expect(geometry8).toBeUndefined();
    expect(geometry9).toBeUndefined();
    expect(geometry10).toBeUndefined();
    expect(geometry11).toBeUndefined();
  });
  const ellipsoidgeometry = new import__44.EllipsoidGeometry({
    vertexFormat: import__44.VertexFormat.POSITION_ONLY,
    radii: new import__44.Cartesian3(1, 2, 3),
    innerRadii: new import__44.Cartesian3(0.5, 0.6, 0.7),
    minimumClock: 0.1,
    maximumClock: 0.2,
    minimumCone: 0.3,
    maximumCone: 0.4,
    slicePartitions: 3,
    stackPartitions: 3
  });
  const packedInstance = [
    1,
    2,
    3,
    0.5,
    0.6,
    0.7,
    1,
    0,
    0,
    0,
    0,
    0,
    0.1,
    0.2,
    0.3,
    0.4,
    3,
    3,
    -1
  ];
  createPackableSpecs_default(import__44.EllipsoidGeometry, ellipsoidgeometry, packedInstance);
});

// packages/engine/Specs/Core/EllipsoidOutlineGeometrySpec.js
var import__45 = __toESM(require_Cesium(), 1);
describe("Core/EllipsoidOutlineGeometry", function() {
  it("constructor throws if stackPartitions less than 1", function() {
    expect(function() {
      return new import__45.EllipsoidOutlineGeometry({
        stackPartitions: 0
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws if slicePartitions less than 0", function() {
    expect(function() {
      return new import__45.EllipsoidOutlineGeometry({
        slicePartitions: -1
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws if subdivisions less than 0", function() {
    expect(function() {
      return new import__45.EllipsoidOutlineGeometry({
        subdivisions: -2
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws if offset attribute is equal to GeometryOffsetAttribute.TOP", function() {
    expect(function() {
      return new import__45.EllipsoidOutlineGeometry({
        offsetAttribute: import__45.GeometryOffsetAttribute.TOP
      });
    }).toThrowDeveloperError();
  });
  it("constructor rounds floating-point slicePartitions", function() {
    const m = new import__45.EllipsoidOutlineGeometry({
      slicePartitions: 3.5,
      stackPartitions: 3,
      subdivisions: 3
    });
    expect(m._slicePartitions).toEqual(4);
  });
  it("constructor rounds floating-point stackPartitions", function() {
    const m = new import__45.EllipsoidOutlineGeometry({
      slicePartitions: 3,
      stackPartitions: 3.5,
      subdivisions: 3
    });
    expect(m._stackPartitions).toEqual(4);
  });
  it("constructor rounds floating-point subdivisions", function() {
    const m = new import__45.EllipsoidOutlineGeometry({
      slicePartitions: 3,
      stackPartitions: 3,
      subdivisions: 3.5
    });
    expect(m._subdivisions).toEqual(4);
  });
  it("computes positions", function() {
    const m = import__45.EllipsoidOutlineGeometry.createGeometry(
      new import__45.EllipsoidOutlineGeometry({
        stackPartitions: 3,
        slicePartitions: 3,
        subdivisions: 3
      })
    );
    expect(m.attributes.position.values.length).toEqual(24 * 3);
    expect(m.indices.length).toEqual(16 * 2);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes positions for partial ellipsoid", function() {
    const m = import__45.EllipsoidOutlineGeometry.createGeometry(
      new import__45.EllipsoidOutlineGeometry({
        innerRadii: new import__45.Cartesian3(0.5, 0.5, 0.5),
        minimumClock: import__45.Math.toRadians(90),
        maximumClock: import__45.Math.toRadians(270),
        minimumCone: import__45.Math.toRadians(30),
        maximumCone: import__45.Math.toRadians(120),
        stackPartitions: 3,
        slicePartitions: 3,
        subdivisions: 3
      })
    );
    expect(m.attributes.position.values.length).toEqual(24 * 3);
    expect(m.indices.length).toEqual(20 * 2);
    expect(m.boundingSphere.radius).toEqual(1);
  });
  it("computes offset attribute", function() {
    const m = import__45.EllipsoidOutlineGeometry.createGeometry(
      new import__45.EllipsoidOutlineGeometry({
        stackPartitions: 3,
        slicePartitions: 3,
        subdivisions: 3,
        offsetAttribute: import__45.GeometryOffsetAttribute.ALL
      })
    );
    const numVertices = 24;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    const offset = m.attributes.applyOffset.values;
    expect(offset.length).toEqual(numVertices);
    const expected = new Array(offset.length).fill(1);
    expect(offset).toEqual(expected);
  });
  it("computes partitions to default to 2 if less than 2", function() {
    const geometry = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(0.5, 0.5, 0.5)
    });
    geometry._slicePartitions = 0;
    geometry._stackPartitions = 0;
    const m = import__45.EllipsoidOutlineGeometry.createGeometry(geometry);
    expect(m.indices.length).toEqual(1016);
  });
  it("undefined is returned if the x, y, or z radii are equal or less than zero", function() {
    const ellipsoidOutline0 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(0, 5e5, 5e5)
    });
    const ellipsoidOutline1 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(1e6, 0, 5e5)
    });
    const ellipsoidOutline2 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(1e6, 5e5, 0)
    });
    const ellipsoidOutline3 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(-10, 5e5, 5e5)
    });
    const ellipsoidOutline4 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(1e6, -10, 5e5)
    });
    const ellipsoidOutline5 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(1e6, 5e5, -10)
    });
    const ellipsoidOutline6 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__45.Cartesian3(0, 1e5, 1e5)
    });
    const ellipsoidOutline7 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__45.Cartesian3(1e5, 0, 1e5)
    });
    const ellipsoidOutline8 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__45.Cartesian3(1e5, 1e5, 0)
    });
    const ellipsoidOutline9 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__45.Cartesian3(-10, 1e5, 1e5)
    });
    const ellipsoidOutline10 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__45.Cartesian3(1e5, -10, 1e5)
    });
    const ellipsoidOutline11 = new import__45.EllipsoidOutlineGeometry({
      radii: new import__45.Cartesian3(5e5, 5e5, 5e5),
      innerRadii: new import__45.Cartesian3(1e5, 1e5, -10)
    });
    const geometry0 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline0
    );
    const geometry1 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline1
    );
    const geometry2 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline2
    );
    const geometry3 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline3
    );
    const geometry4 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline4
    );
    const geometry5 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline5
    );
    const geometry6 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline6
    );
    const geometry7 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline7
    );
    const geometry8 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline8
    );
    const geometry9 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline9
    );
    const geometry10 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline10
    );
    const geometry11 = import__45.EllipsoidOutlineGeometry.createGeometry(
      ellipsoidOutline11
    );
    expect(geometry0).toBeUndefined();
    expect(geometry1).toBeUndefined();
    expect(geometry2).toBeUndefined();
    expect(geometry3).toBeUndefined();
    expect(geometry4).toBeUndefined();
    expect(geometry5).toBeUndefined();
    expect(geometry6).toBeUndefined();
    expect(geometry7).toBeUndefined();
    expect(geometry8).toBeUndefined();
    expect(geometry9).toBeUndefined();
    expect(geometry10).toBeUndefined();
    expect(geometry11).toBeUndefined();
  });
  const ellipsoidgeometry = new import__45.EllipsoidOutlineGeometry({
    radii: new import__45.Cartesian3(1, 2, 3),
    innerRadii: new import__45.Cartesian3(0.5, 0.6, 0.7),
    minimumClock: 0.1,
    maximumClock: 0.2,
    minimumCone: 0.3,
    maximumCone: 0.4,
    slicePartitions: 3,
    stackPartitions: 3,
    subdivisions: 3
  });
  const packedInstance = [
    1,
    2,
    3,
    0.5,
    0.6,
    0.7,
    0.1,
    0.2,
    0.3,
    0.4,
    3,
    3,
    3,
    -1
  ];
  createPackableSpecs_default(
    import__45.EllipsoidOutlineGeometry,
    ellipsoidgeometry,
    packedInstance
  );
});

// packages/engine/Specs/Core/EllipsoidRhumbLineSpec.js
var import__46 = __toESM(require_Cesium(), 1);
describe("Core/EllipsoidRhumbLine", function() {
  const oneDegree = import__46.Math.RADIANS_PER_DEGREE;
  const fifteenDegrees = Math.PI / 12;
  const thirtyDegrees = Math.PI / 6;
  const fortyfiveDegrees = Math.PI / 4;
  const threeHundredDegrees = 5 * Math.PI / 6;
  it("throws without start", function() {
    expect(function() {
      const rhumb = new import__46.EllipsoidRhumbLine();
      return rhumb.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("throws without end", function() {
    expect(function() {
      const rhumb = new import__46.EllipsoidRhumbLine(new import__46.Cartographic(Math.PI, Math.PI));
      return rhumb.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("throws without unique position", function() {
    expect(function() {
      const rhumb = new import__46.EllipsoidRhumbLine(
        new import__46.Cartographic(Math.PI, Math.PI),
        new import__46.Cartographic(0, Math.PI)
      );
      return rhumb.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("setEndPoints throws without start", function() {
    expect(function() {
      const rhumb = new import__46.EllipsoidRhumbLine();
      rhumb.setEndPoints();
    }).toThrowDeveloperError();
  });
  it("setEndPoints throws without end", function() {
    expect(function() {
      const start = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, 0);
      const rhumb = new import__46.EllipsoidRhumbLine();
      rhumb.setEndPoints(start);
      return rhumb.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("can create using fromStartHeadingDistance function", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const start = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const heading = fifteenDegrees;
    const distance = fifteenDegrees * ellipsoid.maximumRadius;
    const rhumb = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      start,
      heading,
      distance,
      ellipsoid
    );
    expect(start).toEqual(rhumb.start);
    expect(distance).toEqualEpsilon(rhumb.surfaceDistance, import__46.Math.EPSILON6);
    expect(heading).toEqualEpsilon(rhumb.heading, import__46.Math.EPSILON12);
  });
  it("can create using fromStartHeadingDistance function with result", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const scratch = new import__46.EllipsoidRhumbLine(void 0, void 0, ellipsoid);
    const start = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const heading = fifteenDegrees;
    const distance = fifteenDegrees * ellipsoid.maximumRadius;
    const rhumb = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      start,
      heading,
      distance,
      ellipsoid,
      scratch
    );
    expect(rhumb).toBe(scratch);
    expect(rhumb.ellipsoid).toBe(ellipsoid);
    expect(start).toEqual(rhumb.start);
    expect(distance).toEqualEpsilon(rhumb.surfaceDistance, import__46.Math.EPSILON6);
    expect(heading).toEqualEpsilon(rhumb.heading, import__46.Math.EPSILON12);
  });
  it("getSurfaceDistance throws if start or end never defined", function() {
    expect(function() {
      const rhumb = new import__46.EllipsoidRhumbLine();
      return rhumb.surfaceDistance;
    }).toThrowDeveloperError();
  });
  it("getHeading throws if start or end never defined", function() {
    expect(function() {
      const rhumb = new import__46.EllipsoidRhumbLine();
      return rhumb.heading;
    }).toThrowDeveloperError();
  });
  it("works with two points", function() {
    const start = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const end = new import__46.Cartographic(thirtyDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    expect(start).toEqual(rhumb.start);
    expect(end).toEqual(rhumb.end);
  });
  it("sets end points", function() {
    const start = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, 0);
    const end = new import__46.Cartographic(
      import__46.Math.PI_OVER_TWO,
      import__46.Math.PI_OVER_TWO
    );
    const rhumb = new import__46.EllipsoidRhumbLine();
    rhumb.setEndPoints(start, end);
    expect(start).toEqual(rhumb.start);
    expect(end).toEqual(rhumb.end);
  });
  it("gets heading", function() {
    const ellipsoid = new import__46.Ellipsoid(6, 6, 3);
    const start = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, 0);
    const end = new import__46.Cartographic(Math.PI, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    expect(import__46.Math.PI_OVER_TWO).toEqualEpsilon(
      rhumb.heading,
      import__46.Math.EPSILON12
    );
  });
  it("computes heading not going over the pole", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const start = new import__46.Cartographic(0, 1.2);
    const end = new import__46.Cartographic(Math.PI, 1.5);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    expect(0).not.toEqual(rhumb.heading);
  });
  it("computes heading going over the pole", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const start = new import__46.Cartographic(1.3, import__46.Math.PI_OVER_TWO);
    const end = new import__46.Cartographic(0, import__46.Math.PI / 2.4);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    expect(0).not.toEqual(rhumb.heading);
  });
  it("heading works when going around the world at constant latitude", function() {
    const ellipsoid = new import__46.Ellipsoid(6, 6, 6);
    let start = new import__46.Cartographic(0, 0.3);
    let end = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, 0.3);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    expect(import__46.Math.PI_OVER_TWO).toEqualEpsilon(
      rhumb.heading,
      import__46.Math.EPSILON12
    );
    start = new import__46.Cartographic(3 * import__46.Math.PI_OVER_TWO, 0.3);
    end = new import__46.Cartographic(import__46.Math.PI, 0.3);
    const rhumb2 = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    expect(-import__46.Math.PI_OVER_TWO).toEqualEpsilon(
      rhumb2.heading,
      import__46.Math.EPSILON12
    );
  });
  it("computes heading for vertical lines", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const start = new import__46.Cartographic(0, 1.2);
    const end = new import__46.Cartographic(0, 1.5);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    expect(0).toEqualEpsilon(rhumb.heading, import__46.Math.EPSILON12);
    const rhumb2 = new import__46.EllipsoidRhumbLine(end, start, ellipsoid);
    expect(import__46.Math.PI).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
  });
  it("computes distance at equator", function() {
    const ellipsoid = new import__46.Ellipsoid(6, 6, 3);
    const start = new import__46.Cartographic(-import__46.Math.PI_OVER_FOUR, 0);
    const end = new import__46.Cartographic(import__46.Math.PI_OVER_FOUR, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    expect(import__46.Math.PI_OVER_TWO * 6).toEqualEpsilon(
      rhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
  });
  it("computes distance at meridian", function() {
    const ellipsoid = new import__46.Ellipsoid(6, 6, 6);
    const start = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, fifteenDegrees);
    const end = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, fortyfiveDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    expect(thirtyDegrees * 6).toEqualEpsilon(
      rhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
  });
  it("computes equal distance on sphere for 90 degrees arcs along meridian and equator", function() {
    const ellipsoid = new import__46.Ellipsoid(6, 6, 6);
    const fortyFiveSouth = new import__46.Cartographic(0, -import__46.Math.PI_OVER_FOUR);
    const fortyFiveNorth = new import__46.Cartographic(0, import__46.Math.PI_OVER_FOUR);
    const fortyFiveWest = new import__46.Cartographic(-import__46.Math.PI_OVER_FOUR, 0);
    const fortyFiveEast = new import__46.Cartographic(import__46.Math.PI_OVER_FOUR, 0);
    const westEastRhumb = new import__46.EllipsoidRhumbLine(
      fortyFiveWest,
      fortyFiveEast,
      ellipsoid
    );
    const southNorthRhumb = new import__46.EllipsoidRhumbLine(
      fortyFiveSouth,
      fortyFiveNorth,
      ellipsoid
    );
    const eastWestRhumb = new import__46.EllipsoidRhumbLine(
      fortyFiveEast,
      fortyFiveWest,
      ellipsoid
    );
    const northSouthRhumb = new import__46.EllipsoidRhumbLine(
      fortyFiveNorth,
      fortyFiveSouth,
      ellipsoid
    );
    expect(import__46.Math.PI_OVER_TWO * 6).toEqualEpsilon(
      westEastRhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
    expect(import__46.Math.PI_OVER_TWO * 6).toEqualEpsilon(
      southNorthRhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
    expect(westEastRhumb.surfaceDistance).toEqualEpsilon(
      southNorthRhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
    expect(import__46.Math.PI_OVER_TWO * 6).toEqualEpsilon(
      eastWestRhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
    expect(import__46.Math.PI_OVER_TWO * 6).toEqualEpsilon(
      northSouthRhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
    expect(eastWestRhumb.surfaceDistance).toEqualEpsilon(
      northSouthRhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
  });
  it("computes distance at same latitude", function() {
    const ellipsoid = new import__46.Ellipsoid(6, 6, 6);
    const start = new import__46.Cartographic(0, -fortyfiveDegrees);
    const end = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, -fortyfiveDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end, ellipsoid);
    const distance = Math.cos(fortyfiveDegrees) * import__46.Math.PI_OVER_TWO * 6;
    expect(distance).toEqualEpsilon(
      rhumb.surfaceDistance,
      import__46.Math.EPSILON12
    );
  });
  it("throws when interpolating rhumb line of zero length", function() {
    const radius = 6378137;
    const ellipsoid = new import__46.Ellipsoid(radius, radius, radius);
    const initial = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    expect(function() {
      const rhumb = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
        initial,
        fifteenDegrees,
        0,
        ellipsoid
      );
      return rhumb.interpolateUsingSurfaceDistance(0);
    }).toThrowDeveloperError();
  });
  it("computes heading and distance given endpoints on sphere ", function() {
    const radius = 6378137;
    const ellipsoid = new import__46.Ellipsoid(radius, radius, radius);
    const initial = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const distance = radius * fifteenDegrees;
    const rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      fifteenDegrees,
      distance,
      ellipsoid
    );
    const rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(fifteenDegrees).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(distance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
  });
  it("computes heading and distance given endpoints on sphereoid", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const initial = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const distance = ellipsoid.maximumRadius * fifteenDegrees;
    const rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      fifteenDegrees,
      distance,
      ellipsoid
    );
    const rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(fifteenDegrees).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(distance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
  });
  it("tests sphere close to 90 degrees", function() {
    const radius = 6378137;
    const ellipsoid = new import__46.Ellipsoid(radius, radius, radius);
    const initial = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const distance = radius * fifteenDegrees;
    const eightyNineDegrees = 89 * oneDegree;
    const eightyNinePointNineDegrees = 89.9 * oneDegree;
    const ninetyDegrees = 90 * oneDegree;
    const ninetyPointOneDegrees = 90.1 * oneDegree;
    const ninetyPointZeroTwoDegrees = 90.02 * oneDegree;
    let rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      eightyNineDegrees,
      distance,
      ellipsoid
    );
    let rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      eightyNinePointNineDegrees,
      distance,
      ellipsoid
    );
    rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      ninetyDegrees,
      distance,
      ellipsoid
    );
    rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      ninetyPointOneDegrees,
      distance,
      ellipsoid
    );
    rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      ninetyPointZeroTwoDegrees,
      distance,
      ellipsoid
    );
    rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
  });
  it("tests spheroid close to 90 degrees", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const initial = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const distance = ellipsoid.maximumRadius * fifteenDegrees;
    const eightyNineDegrees = 89 * oneDegree;
    const eightyNinePointNineDegrees = 89.9 * oneDegree;
    const ninetyDegrees = 90 * oneDegree;
    const ninetyPointOneDegrees = 90.1 * oneDegree;
    const ninetyPointZeroTwoDegrees = 90.02 * oneDegree;
    let rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      eightyNineDegrees,
      distance,
      ellipsoid
    );
    let rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      eightyNinePointNineDegrees,
      distance,
      ellipsoid
    );
    rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      ninetyDegrees,
      distance,
      ellipsoid
    );
    rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      ninetyPointOneDegrees,
      distance,
      ellipsoid
    );
    rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      ninetyPointZeroTwoDegrees,
      distance,
      ellipsoid
    );
    rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
  });
  it("test sphereoid across meridian", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const initial = new import__46.Cartographic(-fifteenDegrees, 0);
    const final = new import__46.Cartographic(fifteenDegrees, 0);
    const distance = ellipsoid.maximumRadius * 2 * fifteenDegrees;
    const rhumb1 = new import__46.EllipsoidRhumbLine(initial, final, ellipsoid);
    const rhumb2 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      import__46.Math.PI_OVER_TWO,
      distance,
      ellipsoid
    );
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
  });
  it("test across IDL with -PI to PI range of longitude", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const initial = new import__46.Cartographic(-import__46.Math.PI + fifteenDegrees, 0);
    const final = new import__46.Cartographic(import__46.Math.PI - fifteenDegrees, 0);
    const distance = ellipsoid.maximumRadius * 2 * fifteenDegrees;
    const rhumb1 = new import__46.EllipsoidRhumbLine(initial, final, ellipsoid);
    const rhumb2 = new import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      3 * import__46.Math.PI_OVER_TWO,
      distance,
      ellipsoid
    );
    expect(-import__46.Math.PI_OVER_TWO).toEqualEpsilon(
      rhumb1.heading,
      import__46.Math.EPSILON12
    );
    expect(distance).toEqualEpsilon(
      rhumb1.surfaceDistance,
      import__46.Math.EPSILON6
    );
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
    const rhumb3 = new import__46.EllipsoidRhumbLine(final, initial, ellipsoid);
    const rhumb4 = new import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      final,
      import__46.Math.PI_OVER_TWO,
      distance,
      ellipsoid
    );
    expect(import__46.Math.PI_OVER_TWO).toEqualEpsilon(
      rhumb3.heading,
      import__46.Math.EPSILON12
    );
    expect(distance).toEqualEpsilon(
      rhumb3.surfaceDistance,
      import__46.Math.EPSILON6
    );
    expect(rhumb3.heading).toEqualEpsilon(rhumb4.heading, import__46.Math.EPSILON12);
    expect(rhumb3.surfaceDistance).toEqualEpsilon(
      rhumb4.surfaceDistance,
      import__46.Math.EPSILON6
    );
  });
  it("test across equator", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const initial = new import__46.Cartographic(fifteenDegrees, -oneDegree);
    const final = new import__46.Cartographic(fifteenDegrees, oneDegree);
    const rhumb = new import__46.EllipsoidRhumbLine(initial, final, ellipsoid);
    const geodesic = new import__46.EllipsoidGeodesic(initial, final, ellipsoid);
    expect(0).toEqualEpsilon(rhumb.heading, import__46.Math.EPSILON12);
    expect(geodesic.startHeading).toEqualEpsilon(
      rhumb.heading,
      import__46.Math.EPSILON12
    );
    expect(geodesic.surfaceDistance).toEqualEpsilon(
      rhumb.surfaceDistance,
      import__46.Math.EPSILON6
    );
  });
  it("test on equator", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const initial = new import__46.Cartographic(0, 0);
    const final = new import__46.Cartographic(import__46.Math.PI - 1, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(initial, final, ellipsoid);
    const geodesic = new import__46.EllipsoidGeodesic(initial, final, ellipsoid);
    expect(import__46.Math.PI_OVER_TWO).toEqualEpsilon(
      rhumb.heading,
      import__46.Math.EPSILON12
    );
    expect(geodesic.startHeading).toEqualEpsilon(
      rhumb.heading,
      import__46.Math.EPSILON12
    );
    expect(geodesic.surfaceDistance).toEqualEpsilon(
      rhumb.surfaceDistance,
      import__46.Math.EPSILON4
    );
  });
  it("test close to poles", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const fiveDegrees = import__46.Math.PI / 36;
    const eightyDegrees = 16 * fiveDegrees;
    const distance = fifteenDegrees * ellipsoid.maximumRadius;
    const initial = new import__46.Cartographic(0, eightyDegrees);
    const rhumb1 = import__46.EllipsoidRhumbLine.fromStartHeadingDistance(
      initial,
      eightyDegrees,
      distance,
      ellipsoid
    );
    const rhumb2 = new import__46.EllipsoidRhumbLine(initial, rhumb1.end, ellipsoid);
    expect(rhumb1.heading).toEqualEpsilon(rhumb2.heading, import__46.Math.EPSILON12);
    expect(rhumb1.surfaceDistance).toEqualEpsilon(
      rhumb2.surfaceDistance,
      import__46.Math.EPSILON6
    );
  });
  it("test interpolate fraction", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const initial = new import__46.Cartographic(0, 0);
    const final = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, 0);
    const halfway = new import__46.Cartographic(import__46.Math.PI_OVER_FOUR, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(initial, final, ellipsoid);
    const interpolatedPoint = rhumb.interpolateUsingFraction(0.5);
    expect(halfway.longitude).toEqualEpsilon(
      interpolatedPoint.longitude,
      import__46.Math.EPSILON12
    );
    expect(halfway.latitude).toEqualEpsilon(
      interpolatedPoint.latitude,
      import__46.Math.EPSILON12
    );
  });
  it("test interpolate distance", function() {
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const initial = new import__46.Cartographic(0, 0);
    const final = new import__46.Cartographic(import__46.Math.PI_OVER_TWO, 0);
    const halfway = new import__46.Cartographic(import__46.Math.PI_OVER_FOUR, 0);
    const distance = ellipsoid.maximumRadius * import__46.Math.PI_OVER_FOUR;
    const rhumb = new import__46.EllipsoidRhumbLine(initial, final, ellipsoid);
    const interpolatedPoint = rhumb.interpolateUsingSurfaceDistance(distance);
    expect(halfway.longitude).toEqualEpsilon(
      interpolatedPoint.longitude,
      import__46.Math.EPSILON12
    );
    expect(halfway.latitude).toEqualEpsilon(
      interpolatedPoint.latitude,
      import__46.Math.EPSILON12
    );
  });
  it("interpolates start and end points", function() {
    const start = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const end = new import__46.Cartographic(thirtyDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const distance = rhumb.surfaceDistance;
    const first = rhumb.interpolateUsingSurfaceDistance(0);
    const last = rhumb.interpolateUsingSurfaceDistance(distance);
    expect(start.longitude).toEqualEpsilon(
      first.longitude,
      import__46.Math.EPSILON12
    );
    expect(start.latitude).toEqualEpsilon(first.latitude, import__46.Math.EPSILON12);
    expect(end.longitude).toEqualEpsilon(last.longitude, import__46.Math.EPSILON12);
    expect(end.latitude).toEqualEpsilon(last.latitude, import__46.Math.EPSILON12);
  });
  it("interpolates midpoint", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fortyfiveDegrees, 0);
    const expectedMid = new import__46.Cartographic(thirtyDegrees, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const distance = import__46.Ellipsoid.WGS84.radii.x * fifteenDegrees;
    const midpoint = rhumb.interpolateUsingSurfaceDistance(distance);
    expect(expectedMid.longitude).toEqualEpsilon(
      midpoint.longitude,
      import__46.Math.EPSILON12
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      midpoint.latitude,
      import__46.Math.EPSILON12
    );
  });
  it("interpolates start and end points using fraction", function() {
    const start = new import__46.Cartographic(fifteenDegrees, fifteenDegrees);
    const end = new import__46.Cartographic(thirtyDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const first = rhumb.interpolateUsingFraction(0);
    const last = rhumb.interpolateUsingFraction(1);
    expect(start.longitude).toEqualEpsilon(
      first.longitude,
      import__46.Math.EPSILON12
    );
    expect(start.latitude).toEqualEpsilon(first.latitude, import__46.Math.EPSILON12);
    expect(end.longitude).toEqualEpsilon(last.longitude, import__46.Math.EPSILON12);
    expect(end.latitude).toEqualEpsilon(last.latitude, import__46.Math.EPSILON12);
  });
  it("interpolates midpoint using fraction", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fortyfiveDegrees, 0);
    const expectedMid = new import__46.Cartographic(thirtyDegrees, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const midpoint = rhumb.interpolateUsingFraction(0.5);
    expect(expectedMid.longitude).toEqualEpsilon(
      midpoint.longitude,
      import__46.Math.EPSILON12
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      midpoint.latitude,
      import__46.Math.EPSILON12
    );
  });
  it("interpolates when heading is near 90 degrees", function() {
    const start = new import__46.Cartographic(0, 0);
    const end = new import__46.Cartographic(Math.PI / 2, 0);
    const expectedMid = new import__46.Cartographic(fortyfiveDegrees, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    expect(rhumb.heading).toEqualEpsilon(Math.PI / 2, import__46.Math.EPSILON12);
    const midpoint = rhumb.interpolateUsingFraction(0.5);
    expect(expectedMid.longitude).toEqualEpsilon(
      midpoint.longitude,
      import__46.Math.EPSILON12
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      midpoint.latitude,
      import__46.Math.EPSILON12
    );
  });
  it("interpolates when heading is near 0 degrees", function() {
    const start = new import__46.Cartographic(-threeHundredDegrees, fifteenDegrees);
    const end = new import__46.Cartographic(-threeHundredDegrees, fortyfiveDegrees);
    const expectedMid = new import__46.Cartographic(-threeHundredDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    expect(rhumb.heading).toEqualEpsilon(0, import__46.Math.EPSILON12);
    const midpoint = rhumb.interpolateUsingFraction(0.5);
    expect(expectedMid.longitude).toEqualEpsilon(
      midpoint.longitude,
      import__46.Math.EPSILON12
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      midpoint.latitude,
      import__46.Math.EPSILON3
    );
  });
  it("interpolates midpoint fraction using result parameter", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fortyfiveDegrees, 0);
    const expectedMid = new import__46.Cartographic(thirtyDegrees, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const result = new import__46.Cartographic();
    const midpoint = rhumb.interpolateUsingFraction(0.5, result);
    expect(result).toBe(midpoint);
    expect(expectedMid.longitude).toEqualEpsilon(
      result.longitude,
      import__46.Math.EPSILON12
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      result.latitude,
      import__46.Math.EPSILON12
    );
  });
  it("interpolates midpoint using result parameter", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fortyfiveDegrees, 0);
    const expectedMid = new import__46.Cartographic(thirtyDegrees, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const distance = import__46.Ellipsoid.WGS84.radii.x * fifteenDegrees;
    const result = new import__46.Cartographic();
    const midpoint = rhumb.interpolateUsingSurfaceDistance(distance, result);
    expect(result).toBe(midpoint);
    expect(expectedMid.longitude).toEqualEpsilon(
      result.longitude,
      import__46.Math.EPSILON12
    );
    expect(expectedMid.latitude).toEqualEpsilon(
      result.latitude,
      import__46.Math.EPSILON12
    );
  });
  it("finds midpoint and other points using intersection with longitude", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fortyfiveDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const midpointUsingInterpolation = rhumb.interpolateUsingFraction(0.5);
    const midpointUsingIntersection = rhumb.findIntersectionWithLongitude(
      midpointUsingInterpolation.longitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        midpointUsingInterpolation,
        midpointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
    let pointUsingInterpolation = rhumb.interpolateUsingFraction(0.1);
    let pointUsingIntersection = rhumb.findIntersectionWithLongitude(
      pointUsingInterpolation.longitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        pointUsingInterpolation,
        pointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
    pointUsingInterpolation = rhumb.interpolateUsingFraction(0.75);
    pointUsingIntersection = rhumb.findIntersectionWithLongitude(
      pointUsingInterpolation.longitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        pointUsingInterpolation,
        pointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
    pointUsingInterpolation = rhumb.interpolateUsingFraction(1.1);
    pointUsingIntersection = rhumb.findIntersectionWithLongitude(
      pointUsingInterpolation.longitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        pointUsingInterpolation,
        pointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
  });
  it("finds correct intersection with IDL", function() {
    const start = import__46.Cartographic.fromDegrees(170, 10);
    const end = import__46.Cartographic.fromDegrees(-170, 23);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    let idlIntersection1 = rhumb.findIntersectionWithLongitude(-Math.PI);
    let idlIntersection2 = rhumb.findIntersectionWithLongitude(Math.PI);
    expect(
      import__46.Cartographic.equalsEpsilon(
        idlIntersection1,
        idlIntersection2,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
    expect(idlIntersection1.longitude).toEqualEpsilon(
      Math.PI,
      import__46.Math.EPSILON14
    );
    expect(idlIntersection2.longitude).toEqualEpsilon(
      Math.PI,
      import__46.Math.EPSILON14
    );
    rhumb.setEndPoints(end, start);
    idlIntersection1 = rhumb.findIntersectionWithLongitude(-Math.PI);
    idlIntersection2 = rhumb.findIntersectionWithLongitude(Math.PI);
    expect(
      import__46.Cartographic.equalsEpsilon(
        idlIntersection1,
        idlIntersection2,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
    expect(idlIntersection1.longitude).toEqualEpsilon(
      -Math.PI,
      import__46.Math.EPSILON14
    );
    expect(idlIntersection2.longitude).toEqualEpsilon(
      -Math.PI,
      import__46.Math.EPSILON14
    );
  });
  it("intersection with longitude handles E-W lines", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fortyfiveDegrees, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const midpointUsingInterpolation = rhumb.interpolateUsingFraction(0.5);
    const midpointUsingIntersection = rhumb.findIntersectionWithLongitude(
      midpointUsingInterpolation.longitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        midpointUsingInterpolation,
        midpointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
  });
  it("intersection with longitude handles N-S lines", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fifteenDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const midpointUsingInterpolation = rhumb.interpolateUsingFraction(0.5);
    const midpointUsingIntersection = rhumb.findIntersectionWithLongitude(
      midpointUsingInterpolation.longitude
    );
    expect(midpointUsingIntersection).not.toBeDefined();
  });
  it("intersection with longitude handles N-S lines with different longitude", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fifteenDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const midpointUsingIntersection = rhumb.findIntersectionWithLongitude(
      thirtyDegrees
    );
    expect(midpointUsingIntersection.latitude).toEqualEpsilon(
      import__46.Math.PI_OVER_TWO,
      import__46.Math.EPSILON12
    );
  });
  it("finds midpoint and other points using intersection with latitude", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fortyfiveDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const midpointUsingInterpolation = rhumb.interpolateUsingFraction(0.5);
    const midpointUsingIntersection = rhumb.findIntersectionWithLatitude(
      midpointUsingInterpolation.latitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        midpointUsingInterpolation,
        midpointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
    let pointUsingInterpolation = rhumb.interpolateUsingFraction(0.1);
    let pointUsingIntersection = rhumb.findIntersectionWithLatitude(
      pointUsingInterpolation.latitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        pointUsingInterpolation,
        pointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
    pointUsingInterpolation = rhumb.interpolateUsingFraction(0.75);
    pointUsingIntersection = rhumb.findIntersectionWithLatitude(
      pointUsingInterpolation.latitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        pointUsingInterpolation,
        pointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
    pointUsingInterpolation = rhumb.interpolateUsingFraction(1.1);
    pointUsingIntersection = rhumb.findIntersectionWithLatitude(
      pointUsingInterpolation.latitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        pointUsingInterpolation,
        pointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
  });
  it("intersection with latitude handles E-W lines", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fortyfiveDegrees, 0);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const midpointUsingInterpolation = rhumb.interpolateUsingFraction(0.5);
    const midpointUsingIntersection = rhumb.findIntersectionWithLatitude(
      midpointUsingInterpolation.latitude
    );
    expect(midpointUsingIntersection).not.toBeDefined();
  });
  it("intersection with latitude handles N-S lines", function() {
    const start = new import__46.Cartographic(fifteenDegrees, 0);
    const end = new import__46.Cartographic(fifteenDegrees, thirtyDegrees);
    const rhumb = new import__46.EllipsoidRhumbLine(start, end);
    const midpointUsingInterpolation = rhumb.interpolateUsingFraction(0.5);
    const midpointUsingIntersection = rhumb.findIntersectionWithLatitude(
      midpointUsingInterpolation.latitude
    );
    expect(
      import__46.Cartographic.equalsEpsilon(
        midpointUsingInterpolation,
        midpointUsingIntersection,
        import__46.Math.EPSILON12
      )
    ).toBe(true);
  });
  it("returns the start point when interpolating at surface distance 0.0", function() {
    const p0 = new import__46.Cartesian3(
      899411.2767873341,
      -5079219747324299e-9,
      3738850924729517e-9
    );
    const p1 = new import__46.Cartesian3(
      899411.0994891181,
      -5079219778719673e-9,
      3.7388509247295167e6
    );
    const ellipsoid = import__46.Ellipsoid.WGS84;
    const c0 = ellipsoid.cartesianToCartographic(p0, new import__46.Cartographic());
    const c1 = ellipsoid.cartesianToCartographic(p1, new import__46.Cartographic());
    const rhumb = new import__46.EllipsoidRhumbLine(c0, c1, ellipsoid);
    const c = rhumb.interpolateUsingSurfaceDistance(0, new import__46.Cartographic());
    const p = ellipsoid.cartographicToCartesian(c, new import__46.Cartesian3());
    expect(p).toEqualEpsilon(p0, import__46.Math.EPSILON7);
  });
});

// packages/engine/Specs/Core/EllipsoidSpec.js
var import__47 = __toESM(require_Cesium(), 1);
describe("Core/Ellipsoid", function() {
  const radii = new import__47.Cartesian3(1, 2, 3);
  const radiiSquared = import__47.Cartesian3.multiplyComponents(
    radii,
    radii,
    new import__47.Cartesian3()
  );
  const radiiToTheFourth = import__47.Cartesian3.multiplyComponents(
    radiiSquared,
    radiiSquared,
    new import__47.Cartesian3()
  );
  const oneOverRadii = new import__47.Cartesian3(1 / radii.x, 1 / radii.y, 1 / radii.z);
  const oneOverRadiiSquared = new import__47.Cartesian3(
    1 / radiiSquared.x,
    1 / radiiSquared.y,
    1 / radiiSquared.z
  );
  const minimumRadius = 1;
  const maximumRadius = 3;
  const spaceCartesian = new import__47.Cartesian3(
    4582719882730089e-9,
    -4582719882730088e-9,
    1.7255104250797231e6
  );
  const spaceCartesianGeodeticSurfaceNormal = new import__47.Cartesian3(
    0.6829975339864266,
    -0.6829975339864265,
    0.25889908678270795
  );
  const spaceCartographic = new import__47.Cartographic(
    import__47.Math.toRadians(-45),
    import__47.Math.toRadians(15),
    33e4
  );
  const spaceCartographicGeodeticSurfaceNormal = new import__47.Cartesian3(
    0.6830127018922194,
    -0.6830127018922193,
    0.25881904510252074
  );
  const surfaceCartesian = new import__47.Cartesian3(
    4.0943277921465295e6,
    1909216404474774e-9,
    4487348408865919e-9
  );
  const surfaceCartographic = new import__47.Cartographic(
    import__47.Math.toRadians(25),
    import__47.Math.toRadians(45),
    0
  );
  it("default constructor creates zero Ellipsoid", function() {
    const ellipsoid = new import__47.Ellipsoid();
    expect(ellipsoid.radii).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.radiiSquared).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.radiiToTheFourth).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.oneOverRadii).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.oneOverRadiiSquared).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.minimumRadius).toEqual(0);
    expect(ellipsoid.maximumRadius).toEqual(0);
  });
  it("fromCartesian3 creates zero Ellipsoid with no parameters", function() {
    const ellipsoid = import__47.Ellipsoid.fromCartesian3();
    expect(ellipsoid.radii).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.radiiSquared).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.radiiToTheFourth).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.oneOverRadii).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.oneOverRadiiSquared).toEqual(import__47.Cartesian3.ZERO);
    expect(ellipsoid.minimumRadius).toEqual(0);
    expect(ellipsoid.maximumRadius).toEqual(0);
  });
  it("constructor computes correct values", function() {
    const ellipsoid = new import__47.Ellipsoid(radii.x, radii.y, radii.z);
    expect(ellipsoid.radii).toEqual(radii);
    expect(ellipsoid.radiiSquared).toEqual(radiiSquared);
    expect(ellipsoid.radiiToTheFourth).toEqual(radiiToTheFourth);
    expect(ellipsoid.oneOverRadii).toEqual(oneOverRadii);
    expect(ellipsoid.oneOverRadiiSquared).toEqual(oneOverRadiiSquared);
    expect(ellipsoid.minimumRadius).toEqual(minimumRadius);
    expect(ellipsoid.maximumRadius).toEqual(maximumRadius);
  });
  it("fromCartesian3 computes correct values", function() {
    const ellipsoid = import__47.Ellipsoid.fromCartesian3(radii);
    expect(ellipsoid.radii).toEqual(radii);
    expect(ellipsoid.radiiSquared).toEqual(radiiSquared);
    expect(ellipsoid.radiiToTheFourth).toEqual(radiiToTheFourth);
    expect(ellipsoid.oneOverRadii).toEqual(oneOverRadii);
    expect(ellipsoid.oneOverRadiiSquared).toEqual(oneOverRadiiSquared);
    expect(ellipsoid.minimumRadius).toEqual(minimumRadius);
    expect(ellipsoid.maximumRadius).toEqual(maximumRadius);
  });
  it("geodeticSurfaceNormalCartographic works without a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.geodeticSurfaceNormalCartographic(
      spaceCartographic
    );
    expect(returnedResult).toEqualEpsilon(
      spaceCartographicGeodeticSurfaceNormal,
      import__47.Math.EPSILON15
    );
  });
  it("geodeticSurfaceNormalCartographic works with a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const result = new import__47.Cartesian3();
    const returnedResult = ellipsoid.geodeticSurfaceNormalCartographic(
      spaceCartographic,
      result
    );
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqualEpsilon(
      spaceCartographicGeodeticSurfaceNormal,
      import__47.Math.EPSILON15
    );
  });
  it("geodeticSurfaceNormal works without a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.geodeticSurfaceNormal(spaceCartesian);
    expect(returnedResult).toEqualEpsilon(
      spaceCartesianGeodeticSurfaceNormal,
      import__47.Math.EPSILON15
    );
  });
  it("geodeticSurfaceNormal returns undefined when given the origin", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.geodeticSurfaceNormal(import__47.Cartesian3.ZERO);
    expect(returnedResult).toBeUndefined();
  });
  it("geodeticSurfaceNormal works with a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const result = new import__47.Cartesian3();
    const returnedResult = ellipsoid.geodeticSurfaceNormal(
      spaceCartesian,
      result
    );
    expect(returnedResult).toBe(result);
    expect(returnedResult).toEqualEpsilon(
      spaceCartesianGeodeticSurfaceNormal,
      import__47.Math.EPSILON15
    );
  });
  it("cartographicToCartesian works without a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.cartographicToCartesian(spaceCartographic);
    expect(returnedResult).toEqualEpsilon(spaceCartesian, import__47.Math.EPSILON7);
  });
  it("cartographicToCartesian works with a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const result = new import__47.Cartesian3();
    const returnedResult = ellipsoid.cartographicToCartesian(
      spaceCartographic,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqualEpsilon(spaceCartesian, import__47.Math.EPSILON7);
  });
  it("cartographicArrayToCartesianArray works without a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.cartographicArrayToCartesianArray([
      spaceCartographic,
      surfaceCartographic
    ]);
    expect(returnedResult.length).toEqual(2);
    expect(returnedResult[0]).toEqualEpsilon(
      spaceCartesian,
      import__47.Math.EPSILON7
    );
    expect(returnedResult[1]).toEqualEpsilon(
      surfaceCartesian,
      import__47.Math.EPSILON7
    );
  });
  it("cartographicArrayToCartesianArray works with a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const resultCartesian = new import__47.Cartesian3();
    const result = [resultCartesian];
    const returnedResult = ellipsoid.cartographicArrayToCartesianArray(
      [spaceCartographic, surfaceCartographic],
      result
    );
    expect(result).toBe(returnedResult);
    expect(result[0]).toBe(resultCartesian);
    expect(returnedResult.length).toEqual(2);
    expect(returnedResult[0]).toEqualEpsilon(
      spaceCartesian,
      import__47.Math.EPSILON7
    );
    expect(returnedResult[1]).toEqualEpsilon(
      surfaceCartesian,
      import__47.Math.EPSILON7
    );
  });
  it("cartesianToCartographic works without a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.cartesianToCartographic(surfaceCartesian);
    expect(returnedResult).toEqualEpsilon(
      surfaceCartographic,
      import__47.Math.EPSILON8
    );
  });
  it("cartesianToCartographic works with a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const result = new import__47.Cartographic();
    const returnedResult = ellipsoid.cartesianToCartographic(
      surfaceCartesian,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqualEpsilon(
      surfaceCartographic,
      import__47.Math.EPSILON8
    );
  });
  it("cartesianToCartographic works close to center", function() {
    const expected = new import__47.Cartographic(
      9999999999999999e-26,
      10067394967422763e-36,
      -6378137
    );
    const returnedResult = import__47.Ellipsoid.WGS84.cartesianToCartographic(
      new import__47.Cartesian3(1e-50, 1e-60, 1e-70)
    );
    expect(returnedResult).toEqual(expected);
  });
  it("cartesianToCartographic return undefined very close to center", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.cartesianToCartographic(
      new import__47.Cartesian3(1e-150, 1e-150, 1e-150)
    );
    expect(returnedResult).toBeUndefined();
  });
  it("cartesianToCartographic return undefined at center", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.cartesianToCartographic(import__47.Cartesian3.ZERO);
    expect(returnedResult).toBeUndefined();
  });
  it("cartesianArrayToCartographicArray works without a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const returnedResult = ellipsoid.cartesianArrayToCartographicArray([
      spaceCartesian,
      surfaceCartesian
    ]);
    expect(returnedResult.length).toEqual(2);
    expect(returnedResult[0]).toEqualEpsilon(
      spaceCartographic,
      import__47.Math.EPSILON7
    );
    expect(returnedResult[1]).toEqualEpsilon(
      surfaceCartographic,
      import__47.Math.EPSILON7
    );
  });
  it("cartesianArrayToCartographicArray works with a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const resultCartographic = new import__47.Cartographic();
    const result = [resultCartographic];
    const returnedResult = ellipsoid.cartesianArrayToCartographicArray(
      [spaceCartesian, surfaceCartesian],
      result
    );
    expect(result).toBe(returnedResult);
    expect(result.length).toEqual(2);
    expect(result[0]).toBe(resultCartographic);
    expect(result[0]).toEqualEpsilon(spaceCartographic, import__47.Math.EPSILON7);
    expect(result[1]).toEqualEpsilon(surfaceCartographic, import__47.Math.EPSILON7);
  });
  it("scaleToGeodeticSurface scaled in the x direction", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(1, 0, 0);
    const cartesian = new import__47.Cartesian3(9, 0, 0);
    const returnedResult = ellipsoid.scaleToGeodeticSurface(cartesian);
    expect(returnedResult).toEqual(expected);
  });
  it("scaleToGeodeticSurface scaled in the y direction", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(0, 2, 0);
    const cartesian = new import__47.Cartesian3(0, 8, 0);
    const returnedResult = ellipsoid.scaleToGeodeticSurface(cartesian);
    expect(returnedResult).toEqual(expected);
  });
  it("scaleToGeodeticSurface scaled in the z direction", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(0, 0, 3);
    const cartesian = new import__47.Cartesian3(0, 0, 8);
    const returnedResult = ellipsoid.scaleToGeodeticSurface(cartesian);
    expect(returnedResult).toEqual(expected);
  });
  it("scaleToGeodeticSurface works without a result parameter", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(
      0.2680893773941855,
      1.1160466902266495,
      2.3559801120411263
    );
    const cartesian = new import__47.Cartesian3(4, 5, 6);
    const returnedResult = ellipsoid.scaleToGeodeticSurface(cartesian);
    expect(returnedResult).toEqualEpsilon(expected, import__47.Math.EPSILON16);
  });
  it("scaleToGeodeticSurface works with a result parameter", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(
      0.2680893773941855,
      1.1160466902266495,
      2.3559801120411263
    );
    const cartesian = new import__47.Cartesian3(4, 5, 6);
    const result = new import__47.Cartesian3();
    const returnedResult = ellipsoid.scaleToGeodeticSurface(cartesian, result);
    expect(returnedResult).toBe(result);
    expect(result).toEqualEpsilon(expected, import__47.Math.EPSILON16);
  });
  it("scaleToGeocentricSurface scaled in the x direction", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(1, 0, 0);
    const cartesian = new import__47.Cartesian3(9, 0, 0);
    const returnedResult = ellipsoid.scaleToGeocentricSurface(cartesian);
    expect(returnedResult).toEqual(expected);
  });
  it("scaleToGeocentricSurface scaled in the y direction", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(0, 2, 0);
    const cartesian = new import__47.Cartesian3(0, 8, 0);
    const returnedResult = ellipsoid.scaleToGeocentricSurface(cartesian);
    expect(returnedResult).toEqual(expected);
  });
  it("scaleToGeocentricSurface scaled in the z direction", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(0, 0, 3);
    const cartesian = new import__47.Cartesian3(0, 0, 8);
    const returnedResult = ellipsoid.scaleToGeocentricSurface(cartesian);
    expect(returnedResult).toEqual(expected);
  });
  it("scaleToGeocentricSurface works without a result parameter", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(
      0.7807200583588266,
      0.9759000729485333,
      1.1710800875382399
    );
    const cartesian = new import__47.Cartesian3(4, 5, 6);
    const returnedResult = ellipsoid.scaleToGeocentricSurface(cartesian);
    expect(returnedResult).toEqualEpsilon(expected, import__47.Math.EPSILON16);
  });
  it("scaleToGeocentricSurface works with a result parameter", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const expected = new import__47.Cartesian3(
      0.7807200583588266,
      0.9759000729485333,
      1.1710800875382399
    );
    const cartesian = new import__47.Cartesian3(4, 5, 6);
    const result = new import__47.Cartesian3();
    const returnedResult = ellipsoid.scaleToGeocentricSurface(
      cartesian,
      result
    );
    expect(returnedResult).toBe(result);
    expect(result).toEqualEpsilon(expected, import__47.Math.EPSILON16);
  });
  it("scaleToGeodeticSurface returns undefined at center", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    const cartesian = new import__47.Cartesian3(0, 0, 0);
    const returnedResult = ellipsoid.scaleToGeodeticSurface(cartesian);
    expect(returnedResult).toBeUndefined();
  });
  it("transformPositionToScaledSpace works without a result parameter", function() {
    const ellipsoid = new import__47.Ellipsoid(2, 3, 4);
    const expected = new import__47.Cartesian3(2, 2, 2);
    const cartesian = new import__47.Cartesian3(4, 6, 8);
    const returnedResult = ellipsoid.transformPositionToScaledSpace(cartesian);
    expect(returnedResult).toEqualEpsilon(expected, import__47.Math.EPSILON16);
  });
  it("transformPositionToScaledSpace works with a result parameter", function() {
    const ellipsoid = new import__47.Ellipsoid(2, 3, 4);
    const expected = new import__47.Cartesian3(3, 3, 3);
    const cartesian = new import__47.Cartesian3(6, 9, 12);
    const result = new import__47.Cartesian3();
    const returnedResult = ellipsoid.transformPositionToScaledSpace(
      cartesian,
      result
    );
    expect(returnedResult).toBe(result);
    expect(result).toEqualEpsilon(expected, import__47.Math.EPSILON16);
  });
  it("transformPositionFromScaledSpace works without a result parameter", function() {
    const ellipsoid = new import__47.Ellipsoid(2, 3, 4);
    const expected = new import__47.Cartesian3(4, 6, 8);
    const cartesian = new import__47.Cartesian3(2, 2, 2);
    const returnedResult = ellipsoid.transformPositionFromScaledSpace(
      cartesian
    );
    expect(returnedResult).toEqualEpsilon(expected, import__47.Math.EPSILON16);
  });
  it("transformPositionFromScaledSpace works with a result parameter", function() {
    const ellipsoid = new import__47.Ellipsoid(2, 3, 4);
    const expected = new import__47.Cartesian3(6, 9, 12);
    const cartesian = new import__47.Cartesian3(3, 3, 3);
    const result = new import__47.Cartesian3();
    const returnedResult = ellipsoid.transformPositionFromScaledSpace(
      cartesian,
      result
    );
    expect(returnedResult).toBe(result);
    expect(result).toEqualEpsilon(expected, import__47.Math.EPSILON16);
  });
  it("equals works in all cases", function() {
    const ellipsoid = new import__47.Ellipsoid(1, 0, 0);
    expect(ellipsoid.equals(new import__47.Ellipsoid(1, 0, 0))).toEqual(true);
    expect(ellipsoid.equals(new import__47.Ellipsoid(1, 1, 0))).toEqual(false);
    expect(ellipsoid.equals(void 0)).toEqual(false);
  });
  it("toString produces expected values", function() {
    const expected = "(1, 2, 3)";
    const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
    expect(ellipsoid.toString()).toEqual(expected);
  });
  it("constructor throws if x less than 0", function() {
    expect(function() {
      return new import__47.Ellipsoid(-1, 0, 0);
    }).toThrowDeveloperError();
  });
  it("constructor throws if y less than 0", function() {
    expect(function() {
      return new import__47.Ellipsoid(0, -1, 0);
    }).toThrowDeveloperError();
  });
  it("constructor throws if z less than 0", function() {
    expect(function() {
      return new import__47.Ellipsoid(0, 0, -1);
    }).toThrowDeveloperError();
  });
  it("expect Ellipsoid.geocentricSurfaceNormal is be Cartesian3.normalize", function() {
    expect(import__47.Ellipsoid.WGS84.geocentricSurfaceNormal).toBe(import__47.Cartesian3.normalize);
  });
  it("geodeticSurfaceNormalCartographic throws with no cartographic", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.geodeticSurfaceNormalCartographic(void 0);
    }).toThrowDeveloperError();
  });
  it("geodeticSurfaceNormal throws with no cartesian", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.geodeticSurfaceNormal(void 0);
    }).toThrowDeveloperError();
  });
  it("cartographicToCartesian throws with no cartographic", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.cartographicToCartesian(void 0);
    }).toThrowDeveloperError();
  });
  it("cartographicArrayToCartesianArray throws with no cartographics", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.cartographicArrayToCartesianArray(void 0);
    }).toThrowDeveloperError();
  });
  it("cartesianToCartographic throws with no cartesian", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.cartesianToCartographic(void 0);
    }).toThrowDeveloperError();
  });
  it("cartesianArrayToCartographicArray throws with no cartesians", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.cartesianArrayToCartographicArray(void 0);
    }).toThrowDeveloperError();
  });
  it("scaleToGeodeticSurface throws with no cartesian", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.scaleToGeodeticSurface(void 0);
    }).toThrowDeveloperError();
  });
  it("scaleToGeocentricSurface throws with no cartesian", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.scaleToGeocentricSurface(void 0);
    }).toThrowDeveloperError();
  });
  it("clone copies any object with the proper structure", function() {
    const myEllipsoid = {
      _radii: { x: 1, y: 2, z: 3 },
      _radiiSquared: { x: 4, y: 5, z: 6 },
      _radiiToTheFourth: { x: 7, y: 8, z: 9 },
      _oneOverRadii: { x: 10, y: 11, z: 12 },
      _oneOverRadiiSquared: { x: 13, y: 14, z: 15 },
      _minimumRadius: 16,
      _maximumRadius: 17,
      _centerToleranceSquared: 18
    };
    const cloned = import__47.Ellipsoid.clone(myEllipsoid);
    expect(cloned).toBeInstanceOf(import__47.Ellipsoid);
    expect(cloned).toEqual(myEllipsoid);
  });
  it("clone uses result parameter if provided", function() {
    const myEllipsoid = {
      _radii: { x: 1, y: 2, z: 3 },
      _radiiSquared: { x: 4, y: 5, z: 6 },
      _radiiToTheFourth: { x: 7, y: 8, z: 9 },
      _oneOverRadii: { x: 10, y: 11, z: 12 },
      _oneOverRadiiSquared: { x: 13, y: 14, z: 15 },
      _minimumRadius: 16,
      _maximumRadius: 17,
      _centerToleranceSquared: 18
    };
    const result = new import__47.Ellipsoid();
    const cloned = import__47.Ellipsoid.clone(myEllipsoid, result);
    expect(cloned).toBe(result);
    expect(cloned).toEqual(myEllipsoid);
  });
  it("getSurfaceNormalIntersectionWithZAxis throws with no position", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.getSurfaceNormalIntersectionWithZAxis(void 0);
    }).toThrowDeveloperError();
  });
  it("getSurfaceNormalIntersectionWithZAxis throws if the ellipsoid is not an ellipsoid of revolution", function() {
    expect(function() {
      const ellipsoid = new import__47.Ellipsoid(1, 2, 3);
      const cartesian = new import__47.Cartesian3();
      ellipsoid.getSurfaceNormalIntersectionWithZAxis(cartesian);
    }).toThrowDeveloperError();
  });
  it("getSurfaceNormalIntersectionWithZAxis throws if the ellipsoid has radii.z === 0", function() {
    expect(function() {
      const ellipsoid = new import__47.Ellipsoid(1, 2, 0);
      const cartesian = new import__47.Cartesian3();
      ellipsoid.getSurfaceNormalIntersectionWithZAxis(cartesian);
    }).toThrowDeveloperError();
  });
  it("getSurfaceNormalIntersectionWithZAxis works without a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const cartographic = import__47.Cartographic.fromDegrees(35.23, 33.23);
    const cartesianOnTheSurface = ellipsoid.cartographicToCartesian(
      cartographic
    );
    const returnedResult = ellipsoid.getSurfaceNormalIntersectionWithZAxis(
      cartesianOnTheSurface
    );
    expect(returnedResult).toBeInstanceOf(import__47.Cartesian3);
  });
  it("getSurfaceNormalIntersectionWithZAxis works with a result parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const cartographic = import__47.Cartographic.fromDegrees(35.23, 33.23);
    const cartesianOnTheSurface = ellipsoid.cartographicToCartesian(
      cartographic
    );
    const returnedResult = ellipsoid.getSurfaceNormalIntersectionWithZAxis(
      cartesianOnTheSurface,
      void 0,
      cartesianOnTheSurface
    );
    expect(returnedResult).toBe(cartesianOnTheSurface);
  });
  it("getSurfaceNormalIntersectionWithZAxis returns undefined if the result is outside the ellipsoid with buffer parameter", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const cartographic = import__47.Cartographic.fromDegrees(35.23, 33.23);
    const cartesianOnTheSurface = ellipsoid.cartographicToCartesian(
      cartographic
    );
    const returnedResult = ellipsoid.getSurfaceNormalIntersectionWithZAxis(
      cartesianOnTheSurface,
      ellipsoid.radii.z
    );
    expect(returnedResult).toBe(void 0);
  });
  it("getSurfaceNormalIntersectionWithZAxis returns undefined if the result is outside the ellipsoid without buffer parameter", function() {
    const majorAxis = 10;
    const minorAxis = 1;
    const ellipsoid = new import__47.Ellipsoid(majorAxis, majorAxis, minorAxis);
    const cartographic = import__47.Cartographic.fromDegrees(45, 90);
    const cartesianOnTheSurface = ellipsoid.cartographicToCartesian(
      cartographic
    );
    const returnedResult = ellipsoid.getSurfaceNormalIntersectionWithZAxis(
      cartesianOnTheSurface,
      void 0
    );
    expect(returnedResult).toBe(void 0);
  });
  it("getSurfaceNormalIntersectionWithZAxis returns a result that is equal to a value that computed in a different way", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const cartographic = import__47.Cartographic.fromDegrees(35.23, 33.23);
    let cartesianOnTheSurface = ellipsoid.cartographicToCartesian(cartographic);
    const surfaceNormal = ellipsoid.geodeticSurfaceNormal(
      cartesianOnTheSurface
    );
    const magnitude = cartesianOnTheSurface.x / surfaceNormal.x;
    const expected = new import__47.Cartesian3();
    expected.z = cartesianOnTheSurface.z - surfaceNormal.z * magnitude;
    let result = ellipsoid.getSurfaceNormalIntersectionWithZAxis(
      cartesianOnTheSurface,
      void 0
    );
    expect(result).toEqualEpsilon(expected, import__47.Math.EPSILON8);
    cartesianOnTheSurface = new import__47.Cartesian3(ellipsoid.radii.x, 0, 0);
    result = ellipsoid.getSurfaceNormalIntersectionWithZAxis(
      cartesianOnTheSurface,
      void 0
    );
    expect(result).toEqualEpsilon(import__47.Cartesian3.ZERO, import__47.Math.EPSILON8);
  });
  it("getSurfaceNormalIntersectionWithZAxis returns a result that when it's used as an origin for a vector with the surface normal direction it produces an accurate cartographic", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    let cartographic = import__47.Cartographic.fromDegrees(35.23, 33.23);
    let cartesianOnTheSurface = ellipsoid.cartographicToCartesian(cartographic);
    let surfaceNormal = ellipsoid.geodeticSurfaceNormal(cartesianOnTheSurface);
    let result = ellipsoid.getSurfaceNormalIntersectionWithZAxis(
      cartesianOnTheSurface,
      void 0
    );
    let surfaceNormalWithLength = import__47.Cartesian3.multiplyByScalar(
      surfaceNormal,
      ellipsoid.maximumRadius,
      new import__47.Cartesian3()
    );
    let position = import__47.Cartesian3.add(
      result,
      surfaceNormalWithLength,
      new import__47.Cartesian3()
    );
    let resultCartographic = ellipsoid.cartesianToCartographic(position);
    resultCartographic.height = 0;
    expect(resultCartographic).toEqualEpsilon(
      cartographic,
      import__47.Math.EPSILON8
    );
    cartographic = import__47.Cartographic.fromDegrees(0, 90);
    cartesianOnTheSurface = new import__47.Cartesian3(0, 0, ellipsoid.radii.z);
    surfaceNormal = ellipsoid.geodeticSurfaceNormal(cartesianOnTheSurface);
    surfaceNormalWithLength = import__47.Cartesian3.multiplyByScalar(
      surfaceNormal,
      ellipsoid.maximumRadius,
      new import__47.Cartesian3()
    );
    result = ellipsoid.getSurfaceNormalIntersectionWithZAxis(
      cartesianOnTheSurface,
      void 0
    );
    position = import__47.Cartesian3.add(
      result,
      surfaceNormalWithLength,
      new import__47.Cartesian3()
    );
    resultCartographic = ellipsoid.cartesianToCartographic(position);
    resultCartographic.height = 0;
    expect(resultCartographic).toEqualEpsilon(
      cartographic,
      import__47.Math.EPSILON8
    );
  });
  it("getLocalCurvature throws with no position", function() {
    expect(function() {
      import__47.Ellipsoid.WGS84.getLocalCurvature(void 0);
    }).toThrowDeveloperError();
  });
  it("getLocalCurvature returns expected values at the equator", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const cartographic = import__47.Cartographic.fromDegrees(0, 0);
    const cartesianOnTheSurface = ellipsoid.cartographicToCartesian(
      cartographic
    );
    const returnedResult = ellipsoid.getLocalCurvature(cartesianOnTheSurface);
    const expectedResult = new import__47.Cartesian2(
      1 / ellipsoid.maximumRadius,
      ellipsoid.maximumRadius / (ellipsoid.minimumRadius * ellipsoid.minimumRadius)
    );
    expect(returnedResult).toEqualEpsilon(expectedResult, import__47.Math.EPSILON8);
  });
  it("getLocalCurvature returns expected values at the north pole", function() {
    const ellipsoid = import__47.Ellipsoid.WGS84;
    const cartographic = import__47.Cartographic.fromDegrees(0, 90);
    const cartesianOnTheSurface = ellipsoid.cartographicToCartesian(
      cartographic
    );
    const returnedResult = ellipsoid.getLocalCurvature(cartesianOnTheSurface);
    const semiLatusRectum = ellipsoid.maximumRadius * ellipsoid.maximumRadius / ellipsoid.minimumRadius;
    const expectedResult = new import__47.Cartesian2(
      1 / semiLatusRectum,
      1 / semiLatusRectum
    );
    expect(returnedResult).toEqualEpsilon(expectedResult, import__47.Math.EPSILON8);
  });
  it("ellipsoid is initialized with _squaredXOverSquaredZ property", function() {
    const ellipsoid = new import__47.Ellipsoid(4, 4, 3);
    const squaredXOverSquaredZ = ellipsoid.radiiSquared.x / ellipsoid.radiiSquared.z;
    expect(ellipsoid._squaredXOverSquaredZ).toEqual(squaredXOverSquaredZ);
  });
  it("surfaceArea throws without rectangle", function() {
    expect(function() {
      return import__47.Ellipsoid.WGS84.surfaceArea(void 0);
    }).toThrowDeveloperError();
  });
  it("computes surfaceArea", function() {
    let ellipsoid = new import__47.Ellipsoid(4, 4, 3);
    let a2 = ellipsoid.radiiSquared.x;
    let c2 = ellipsoid.radiiSquared.z;
    let e = Math.sqrt(1 - c2 / a2);
    let area = import__47.Math.TWO_PI * a2 + import__47.Math.PI * (c2 / e) * Math.log((1 + e) / (1 - e));
    expect(
      ellipsoid.surfaceArea(
        new import__47.Rectangle(
          -import__47.Math.PI,
          -import__47.Math.PI_OVER_TWO,
          import__47.Math.PI,
          import__47.Math.PI_OVER_TWO
        )
      )
    ).toEqualEpsilon(area, import__47.Math.EPSILON3);
    ellipsoid = new import__47.Ellipsoid(3, 3, 4);
    a2 = ellipsoid.radiiSquared.x;
    c2 = ellipsoid.radiiSquared.z;
    e = Math.sqrt(1 - a2 / c2);
    const a = ellipsoid.radii.x;
    const c = ellipsoid.radii.z;
    area = import__47.Math.TWO_PI * a2 + import__47.Math.TWO_PI * (a * c / e) * Math.asin(e);
    expect(
      ellipsoid.surfaceArea(
        new import__47.Rectangle(
          -import__47.Math.PI,
          -import__47.Math.PI_OVER_TWO,
          import__47.Math.PI,
          import__47.Math.PI_OVER_TWO
        )
      )
    ).toEqualEpsilon(area, import__47.Math.EPSILON3);
  });
  createPackableSpecs_default(import__47.Ellipsoid, import__47.Ellipsoid.WGS84, [
    import__47.Ellipsoid.WGS84.radii.x,
    import__47.Ellipsoid.WGS84.radii.y,
    import__47.Ellipsoid.WGS84.radii.z
  ]);
  it("set default throws if undefined", function() {
    expect(function() {
      import__47.Ellipsoid.default = void 0;
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/EllipsoidTangentPlaneSpec.js
var import__48 = __toESM(require_Cesium(), 1);
describe("Core/EllipsoidTangentPlane", function() {
  it("constructor defaults to WGS84", function() {
    const origin = new import__48.Cartesian3(import__48.Ellipsoid.WGS84.radii.x, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin);
    expect(tangentPlane.ellipsoid).toBe(import__48.Ellipsoid.WGS84);
    expect(tangentPlane.origin).toEqual(origin);
  });
  it("constructor sets expected values", function() {
    const tangentPlane = new import__48.EllipsoidTangentPlane(
      import__48.Cartesian3.UNIT_X,
      import__48.Ellipsoid.UNIT_SPHERE
    );
    expect(tangentPlane.ellipsoid).toBe(import__48.Ellipsoid.UNIT_SPHERE);
    expect(tangentPlane.origin).toEqual(import__48.Cartesian3.UNIT_X);
  });
  it("fromPoints sets expected values", function() {
    const points = [
      new import__48.Cartesian3(2, 0, 0),
      new import__48.Cartesian3(0, 0, 0)
    ];
    const tangentPlane = import__48.EllipsoidTangentPlane.fromPoints(
      points,
      import__48.Ellipsoid.UNIT_SPHERE
    );
    expect(tangentPlane.ellipsoid).toBe(import__48.Ellipsoid.UNIT_SPHERE);
    expect(tangentPlane.origin).toEqual(import__48.Cartesian3.UNIT_X);
  });
  it("projectPointOntoPlane returns undefined for unsolvable projections", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = new import__48.Cartesian3(0, 0, 1);
    const returnedResult = tangentPlane.projectPointOntoPlane(positions);
    expect(returnedResult).toBeUndefined();
  });
  it("projectPointOntoPlane works without a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = new import__48.Cartesian3(1, 0, 1);
    const expectedResult = new import__48.Cartesian2(0, 1);
    const returnedResult = tangentPlane.projectPointOntoPlane(positions);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("projectPointOntoPlane works with a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = new import__48.Cartesian3(1, 0, 1);
    const expectedResult = new import__48.Cartesian2(0, 1);
    const result = new import__48.Cartesian2();
    const returnedResult = tangentPlane.projectPointOntoPlane(
      positions,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("projectPointsOntoPlane works without a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = [
      new import__48.Cartesian3(1, 0, 1),
      new import__48.Cartesian3(1, 0, 0),
      new import__48.Cartesian3(1, 1, 0)
    ];
    const expectedResults = [
      new import__48.Cartesian2(0, 1),
      new import__48.Cartesian2(0, 0),
      new import__48.Cartesian2(1, 0)
    ];
    const returnedResults = tangentPlane.projectPointsOntoPlane(positions);
    expect(returnedResults).toEqual(expectedResults);
  });
  it("projectPointsOntoPlane works with a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = [
      new import__48.Cartesian3(1, 0, 1),
      new import__48.Cartesian3(1, 0, 0),
      new import__48.Cartesian3(1, 1, 0)
    ];
    const expectedResults = [
      new import__48.Cartesian2(0, 1),
      new import__48.Cartesian2(0, 0),
      new import__48.Cartesian2(1, 0)
    ];
    const index0 = new import__48.Cartesian2();
    const result = [index0];
    const returnedResults = tangentPlane.projectPointsOntoPlane(
      positions,
      result
    );
    expect(result).toBe(returnedResults);
    expect(result[0]).toBe(index0);
    expect(returnedResults).toEqual(expectedResults);
  });
  it("projectPointsOntoPlane works when some points cannot be projected", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = [
      new import__48.Cartesian3(1, 0, 1),
      new import__48.Cartesian3(1, 0, 0),
      new import__48.Cartesian3(0, 0, 1),
      new import__48.Cartesian3(1, 1, 0),
      new import__48.Cartesian3(0, 1, 0)
    ];
    const expectedResults = [
      new import__48.Cartesian2(0, 1),
      new import__48.Cartesian2(0, 0),
      new import__48.Cartesian2(1, 0)
    ];
    const returnedResults = tangentPlane.projectPointsOntoPlane(positions);
    expect(returnedResults).toEqual(expectedResults);
  });
  it("projectPointOntoEllipsoid works without a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const position = new import__48.Cartesian3(2, 2, 0);
    const expectedResult = new import__48.Cartesian3(1 / 3, 2 / 3, 2 / 3);
    const returnedResult = tangentPlane.projectPointOntoEllipsoid(position);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("projectPointOntoEllipsoid works with a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const position = new import__48.Cartesian3(2, -2, 0);
    const expectedResult = new import__48.Cartesian3(1 / 3, 2 / 3, -2 / 3);
    const result = new import__48.Cartesian3();
    const returnedResult = tangentPlane.projectPointOntoEllipsoid(
      position,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("projectPointsOntoEllipsoid works without a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = [
      new import__48.Cartesian3(2, -2, 0),
      new import__48.Cartesian3(2, 2, 0)
    ];
    const expectedResults = [
      new import__48.Cartesian3(1 / 3, 2 / 3, -2 / 3),
      new import__48.Cartesian3(1 / 3, 2 / 3, 2 / 3)
    ];
    const returnedResults = tangentPlane.projectPointsOntoEllipsoid(positions);
    expect(returnedResults).toEqual(expectedResults);
  });
  it("projectPointsOntoEllipsoid works with a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = [
      new import__48.Cartesian3(2, -2, 0),
      new import__48.Cartesian3(2, 2, 0)
    ];
    const expectedResults = [
      new import__48.Cartesian3(1 / 3, 2 / 3, -2 / 3),
      new import__48.Cartesian3(1 / 3, 2 / 3, 2 / 3)
    ];
    const index0 = new import__48.Cartesian3();
    const result = [index0];
    const returnedResults = tangentPlane.projectPointsOntoEllipsoid(
      positions,
      result
    );
    expect(result).toBe(returnedResults);
    expect(result[0]).toBe(index0);
    expect(returnedResults).toEqual(expectedResults);
  });
  it("projectPointToNearestOnPlane works without a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = new import__48.Cartesian3(1, 0, 1);
    const expectedResult = new import__48.Cartesian2(0, 1);
    const returnedResult = tangentPlane.projectPointToNearestOnPlane(positions);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("projectPointToNearestOnPlane works projecting from various distances", function() {
    const ellipsoid = import__48.Ellipsoid.ZERO;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    expect(
      tangentPlane.projectPointToNearestOnPlane(new import__48.Cartesian3(2, 0, 0))
    ).toEqual(new import__48.Cartesian2(0, 0));
    expect(
      tangentPlane.projectPointToNearestOnPlane(new import__48.Cartesian3(1, 0, 0))
    ).toEqual(new import__48.Cartesian2(0, 0));
    expect(
      tangentPlane.projectPointToNearestOnPlane(new import__48.Cartesian3(0, 0, 0))
    ).toEqual(new import__48.Cartesian2(0, 0));
    expect(
      tangentPlane.projectPointToNearestOnPlane(new import__48.Cartesian3(-1, 0, 0))
    ).toEqual(new import__48.Cartesian2(0, 0));
  });
  it("projectPointToNearestOnPlane works with a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = new import__48.Cartesian3(1, 0, 1);
    const expectedResult = new import__48.Cartesian2(0, 1);
    const result = new import__48.Cartesian2();
    const returnedResult = tangentPlane.projectPointToNearestOnPlane(
      positions,
      result
    );
    expect(result).toBe(returnedResult);
    expect(returnedResult).toEqual(expectedResult);
  });
  it("projectPointsToNearestOnPlane works without a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = [
      new import__48.Cartesian3(1, 0, 1),
      new import__48.Cartesian3(1, 0, 0),
      new import__48.Cartesian3(1, 1, 0)
    ];
    const expectedResults = [
      new import__48.Cartesian2(0, 1),
      new import__48.Cartesian2(0, 0),
      new import__48.Cartesian2(1, 0)
    ];
    const returnedResults = tangentPlane.projectPointsToNearestOnPlane(
      positions
    );
    expect(returnedResults).toEqual(expectedResults);
  });
  it("projectPointsToNearestOnPlane works with a result parameter", function() {
    const ellipsoid = import__48.Ellipsoid.UNIT_SPHERE;
    const origin = new import__48.Cartesian3(1, 0, 0);
    const tangentPlane = new import__48.EllipsoidTangentPlane(origin, ellipsoid);
    const positions = [
      new import__48.Cartesian3(1, 0, 1),
      new import__48.Cartesian3(1, 0, 0),
      new import__48.Cartesian3(1, 1, 0)
    ];
    const expectedResults = [
      new import__48.Cartesian2(0, 1),
      new import__48.Cartesian2(0, 0),
      new import__48.Cartesian2(1, 0)
    ];
    const index0 = new import__48.Cartesian2();
    const result = [index0];
    const returnedResults = tangentPlane.projectPointsToNearestOnPlane(
      positions,
      result
    );
    expect(result).toBe(returnedResults);
    expect(result[0]).toBe(index0);
    expect(returnedResults).toEqual(expectedResults);
  });
  it("constructor throws without origin", function() {
    expect(function() {
      return new import__48.EllipsoidTangentPlane(void 0, import__48.Ellipsoid.WGS84);
    }).toThrowDeveloperError();
  });
  it("constructor throws if origin is at the center of the ellipsoid", function() {
    expect(function() {
      return new import__48.EllipsoidTangentPlane(import__48.Cartesian3.ZERO, import__48.Ellipsoid.WGS84);
    }).toThrowDeveloperError();
  });
  it("fromPoints throws without cartesians", function() {
    expect(function() {
      return import__48.EllipsoidTangentPlane.fromPoints(void 0, import__48.Ellipsoid.WGS84);
    }).toThrowDeveloperError();
  });
  it("projectPointOntoPlane throws without cartesian", function() {
    const tangentPlane = new import__48.EllipsoidTangentPlane(
      import__48.Cartesian3.UNIT_X,
      import__48.Ellipsoid.UNIT_SPHERE
    );
    expect(function() {
      return tangentPlane.projectPointOntoPlane(void 0);
    }).toThrowDeveloperError();
  });
  it("projectPointsOntoPlane throws without cartesians", function() {
    const tangentPlane = new import__48.EllipsoidTangentPlane(
      import__48.Cartesian3.UNIT_X,
      import__48.Ellipsoid.UNIT_SPHERE
    );
    expect(function() {
      return tangentPlane.projectPointsOntoPlane(void 0);
    }).toThrowDeveloperError();
  });
  it("projectPointToNearestOnPlane throws without cartesian", function() {
    const tangentPlane = new import__48.EllipsoidTangentPlane(
      import__48.Cartesian3.UNIT_X,
      import__48.Ellipsoid.UNIT_SPHERE
    );
    expect(function() {
      return tangentPlane.projectPointToNearestOnPlane(void 0);
    }).toThrowDeveloperError();
  });
  it("projectPointsToNearestOnPlane throws without cartesians", function() {
    const tangentPlane = new import__48.EllipsoidTangentPlane(
      import__48.Cartesian3.UNIT_X,
      import__48.Ellipsoid.UNIT_SPHERE
    );
    expect(function() {
      return tangentPlane.projectPointsToNearestOnPlane(void 0);
    }).toThrowDeveloperError();
  });
  it("projectPointsOntoEllipsoid throws without cartesians", function() {
    const tangentPlane = new import__48.EllipsoidTangentPlane(
      import__48.Cartesian3.UNIT_X,
      import__48.Ellipsoid.UNIT_SPHERE
    );
    expect(function() {
      return tangentPlane.projectPointsOntoEllipsoid(void 0);
    }).toThrowDeveloperError();
  });
  it("projectPointsOntoEllipsoid works with an arbitrary ellipsoid using fromPoints", function() {
    const points = import__48.Cartesian3.fromDegreesArray([
      -72,
      40,
      -68,
      35,
      -75,
      30,
      -70,
      30,
      -68,
      40
    ]);
    const tangentPlane = import__48.EllipsoidTangentPlane.fromPoints(
      points,
      import__48.Ellipsoid.WGS84
    );
    const points2D = tangentPlane.projectPointsOntoPlane(points);
    const positionsBack = tangentPlane.projectPointsOntoEllipsoid(points2D);
    expect(positionsBack[0].x).toBeCloseTo(points[0].x);
    expect(positionsBack[0].y).toBeCloseTo(points[0].y);
    expect(positionsBack[0].z).toBeCloseTo(points[0].z);
  });
});

// packages/engine/Specs/Core/EllipsoidTerrainProviderSpec.js
var import__49 = __toESM(require_Cesium(), 1);

// Specs/createContext.js
var import_engine6 = __toESM(require_Cesium(), 1);

// Specs/createCanvas.js
var import_engine3 = __toESM(require_Cesium(), 1);
var canvasCount = 0;
function createCanvas(width, height) {
  width = (0, import_engine3.defaultValue)(width, 1);
  height = (0, import_engine3.defaultValue)(height, 1);
  const canvas = document.createElement("canvas");
  canvas.id = `canvas${canvasCount++}`;
  canvas.setAttribute("width", width);
  canvas.setAttribute("clientWidth", width);
  canvas.setAttribute("height", height);
  canvas.setAttribute("clientHeight", height);
  canvas.innerHTML = "To view this web page, upgrade your browser; it does not support the HTML5 canvas element.";
  document.body.appendChild(canvas);
  return canvas;
}
var createCanvas_default = createCanvas;

// Specs/createFrameState.js
var import_engine4 = __toESM(require_Cesium(), 1);
function createFrameState(context, camera, frameNumber, time2) {
  const frameState2 = new import_engine4.FrameState(
    context,
    new import_engine4.CreditDisplay(
      document.createElement("div"),
      void 0,
      document.createElement("div")
    ),
    new import_engine4.JobScheduler()
  );
  const projection = new import_engine4.GeographicProjection();
  frameState2.mapProjection = projection;
  frameState2.frameNumber = (0, import_engine4.defaultValue)(frameNumber, 1);
  frameState2.time = (0, import_engine4.defaultValue)(
    time2,
    import_engine4.JulianDate.fromDate(/* @__PURE__ */ new Date("January 1, 2011 12:00:00 EST"))
  );
  camera = (0, import_engine4.defaultValue)(
    camera,
    new import_engine4.Camera({
      drawingBufferWidth: 1,
      drawingBufferHeight: 1,
      mapProjection: projection
    })
  );
  frameState2.camera = camera;
  frameState2.cullingVolume = camera.frustum.computeCullingVolume(
    camera.position,
    camera.direction,
    camera.up
  );
  frameState2.verticalExaggeration = 1;
  frameState2.verticalExaggerationRelativeHeight = 0;
  frameState2.passes.render = true;
  frameState2.passes.pick = false;
  frameState2.minimumDisableDepthTestDistance = 0;
  frameState2.atmosphere = new import_engine4.Atmosphere();
  return frameState2;
}
var createFrameState_default = createFrameState;

// Specs/getWebGLStub.js
var import_engine5 = __toESM(require_Cesium(), 1);
function getWebGLStub(canvas, options) {
  const stub = (0, import_engine5.clone)(import_engine5.WebGLConstants);
  stub.canvas = canvas;
  stub.drawingBufferWidth = Math.max(canvas.width, 1);
  stub.drawingBufferHeight = Math.max(canvas.height, 1);
  stub.activeTexture = noop;
  stub.attachShader = noop;
  stub.bindAttribLocation = noop;
  stub.bindBuffer = noop;
  stub.bindFramebuffer = noop;
  stub.bindRenderbuffer = noop;
  stub.bindTexture = noop;
  stub.blendColor = noop;
  stub.blendEquation = noop;
  stub.blendEquationSeparate = noop;
  stub.blendFunc = noop;
  stub.blendFuncSeparate = noop;
  stub.bufferData = noop;
  stub.bufferSubData = noop;
  stub.checkFramebufferStatus = checkFramebufferStatusStub;
  stub.clear = noop;
  stub.clearColor = noop;
  stub.clearDepth = noop;
  stub.clearStencil = noop;
  stub.colorMask = noop;
  stub.compileShader = noop;
  stub.compressedTexImage2D = noop;
  stub.compressedTexSubImage2D = noop;
  stub.copyTexImage2D = noop;
  stub.copyTexSubImage2D = noop;
  stub.createBuffer = createStub;
  stub.createFramebuffer = createStub;
  stub.createProgram = createStub;
  stub.createRenderbuffer = createStub;
  stub.createShader = createStub;
  stub.createTexture = createStub;
  stub.cullFace = noop;
  stub.deleteBuffer = noop;
  stub.deleteFramebuffer = noop;
  stub.deleteProgram = noop;
  stub.deleteRenderbuffer = noop;
  stub.deleteShader = noop;
  stub.deleteTexture = noop;
  stub.depthFunc = noop;
  stub.depthMask = noop;
  stub.depthRange = noop;
  stub.detachShader = noop;
  stub.disable = noop;
  stub.disableVertexAttribArray = noop;
  stub.drawArrays = noop;
  stub.drawElements = noop;
  stub.enable = noop;
  stub.enableVertexAttribArray = noop;
  stub.finish = noop;
  stub.flush = noop;
  stub.framebufferRenderbuffer = noop;
  stub.framebufferTexture2D = noop;
  stub.frontFace = noop;
  stub.generateMipmap = noop;
  stub.getActiveAttrib = getStub;
  stub.getActiveUniform = getStub;
  stub.getAttachedShaders = getStubWarning;
  stub.getAttribLocation = getStub;
  stub.getBufferParameter = getStubWarning;
  stub.getContextAttributes = getContextAttributesStub(options);
  stub.getError = getErrorStub;
  stub.getExtension = getExtensionStub;
  stub.getFramebufferAttachmentParameter = getStubWarning;
  stub.getParameter = getParameterStub(options);
  stub.getProgramParameter = getProgramParameterStub;
  stub.getProgramInfoLog = getStub;
  stub.getRenderbufferParameter = getStubWarning;
  stub.getShaderParameter = getShaderParameterStub;
  stub.getShaderInfoLog = getStub;
  stub.getShaderPrecisionFormat = getShaderPrecisionStub;
  stub.getShaderSource = getStubWarning;
  stub.getSupportedExtensions = getStubWarning;
  stub.getTexParameter = getStubWarning;
  stub.getUniform = getStub;
  stub.getUniformLocation = getStub;
  stub.getVertexAttrib = getStubWarning;
  stub.getVertexAttribOffset = getStubWarning;
  stub.hint = noop;
  stub.isBuffer = getStubWarning;
  stub.isContextLost = getStubWarning;
  stub.isEnabled = getStubWarning;
  stub.isFramebuffer = getStubWarning;
  stub.isProgram = getStubWarning;
  stub.isRenderbuffer = getStubWarning;
  stub.isShader = getStubWarning;
  stub.isTexture = getStubWarning;
  stub.lineWidth = noop;
  stub.linkProgram = noop;
  stub.pixelStorei = noop;
  stub.polygonOffset = noop;
  stub.readPixels = readPixelsStub;
  stub.renderbufferStorage = noop;
  stub.sampleCoverage = noop;
  stub.scissor = noop;
  stub.shaderSource = noop;
  stub.stencilFunc = noop;
  stub.stencilFuncSeparate = noop;
  stub.stencilMask = noop;
  stub.stencilMaskSeparate = noop;
  stub.stencilOp = noop;
  stub.stencilOpSeparate = noop;
  stub.texParameterf = noop;
  stub.texParameteri = noop;
  stub.texImage2D = noop;
  stub.texSubImage2D = noop;
  stub.uniform1f = noop;
  stub.uniform1fv = noop;
  stub.uniform1i = noop;
  stub.uniform1iv = noop;
  stub.uniform2f = noop;
  stub.uniform2fv = noop;
  stub.uniform2i = noop;
  stub.uniform2iv = noop;
  stub.uniform3f = noop;
  stub.uniform3fv = noop;
  stub.uniform3i = noop;
  stub.uniform3iv = noop;
  stub.uniform4f = noop;
  stub.uniform4fv = noop;
  stub.uniform4i = noop;
  stub.uniform4iv = noop;
  stub.uniformMatrix2fv = noop;
  stub.uniformMatrix3fv = noop;
  stub.uniformMatrix4fv = noop;
  stub.useProgram = noop;
  stub.validateProgram = noop;
  stub.vertexAttrib1f = noop;
  stub.vertexAttrib1fv = noop;
  stub.vertexAttrib2f = noop;
  stub.vertexAttrib2fv = noop;
  stub.vertexAttrib3f = noop;
  stub.vertexAttrib3fv = noop;
  stub.vertexAttrib4f = noop;
  stub.vertexAttrib4fv = noop;
  stub.vertexAttribPointer = noop;
  stub.viewport = noop;
  return stub;
}
var instancedArraysStub = {
  drawElementsInstancedANGLE: noop,
  drawArraysInstancedANGLE: noop,
  vertexAttribDivisorANGLE: noop
};
function noop() {
}
function createStub() {
  return {};
}
function getStub() {
  return {};
}
function getStubWarning() {
  throw new import_engine5.DeveloperError(
    "A stub for this get/is function is not defined.  Can it use getStub() or does it need a new one?"
  );
}
function checkFramebufferStatusStub(target) {
  return import_engine5.WebGLConstants.FRAMEBUFFER_COMPLETE;
}
function getContextAttributesStub(options) {
  const contextAttributes = {
    alpha: (0, import_engine5.defaultValue)(options.alpha, true),
    depth: (0, import_engine5.defaultValue)(options.depth, true),
    stencil: (0, import_engine5.defaultValue)(options.stencil, false),
    antialias: (0, import_engine5.defaultValue)(options.antialias, true),
    premultipliedAlpha: (0, import_engine5.defaultValue)(options.premultipliedAlpha, true),
    preserveDrawingBuffer: (0, import_engine5.defaultValue)(options.preserveDrawingBuffer, false),
    powerPreference: (0, import_engine5.defaultValue)(options.powerPreference, false),
    failIfMajorPerformanceCaveat: (0, import_engine5.defaultValue)(
      options.failIfMajorPerformanceCaveat,
      false
    )
  };
  return function() {
    return contextAttributes;
  };
}
function getErrorStub() {
  return import_engine5.WebGLConstants.NO_ERROR;
}
function getExtensionStub(name) {
  if (name === "ANGLE_instanced_arrays") {
    return instancedArraysStub;
  }
  if (name === "OES_texture_float") {
    return {};
  }
  return null;
}
function getParameterStub(options) {
  const parameterStubValues = {};
  parameterStubValues[import_engine5.WebGLConstants.STENCIL_BITS] = options.stencil ? 8 : 0;
  parameterStubValues[import_engine5.WebGLConstants.MAX_COMBINED_TEXTURE_IMAGE_UNITS] = 32;
  parameterStubValues[import_engine5.WebGLConstants.MAX_CUBE_MAP_TEXTURE_SIZE] = 16384;
  parameterStubValues[import_engine5.WebGLConstants.MAX_FRAGMENT_UNIFORM_VECTORS] = 1024;
  parameterStubValues[import_engine5.WebGLConstants.MAX_TEXTURE_IMAGE_UNITS] = 16;
  parameterStubValues[import_engine5.WebGLConstants.MAX_RENDERBUFFER_SIZE] = 16384;
  parameterStubValues[import_engine5.WebGLConstants.MAX_TEXTURE_SIZE] = 16384;
  parameterStubValues[import_engine5.WebGLConstants.MAX_VARYING_VECTORS] = 30;
  parameterStubValues[import_engine5.WebGLConstants.MAX_VERTEX_ATTRIBS] = 16;
  parameterStubValues[import_engine5.WebGLConstants.MAX_VERTEX_TEXTURE_IMAGE_UNITS] = 16;
  parameterStubValues[import_engine5.WebGLConstants.MAX_VERTEX_UNIFORM_VECTORS] = 4096;
  parameterStubValues[import_engine5.WebGLConstants.ALIASED_LINE_WIDTH_RANGE] = [1, 1];
  parameterStubValues[import_engine5.WebGLConstants.ALIASED_POINT_SIZE_RANGE] = [1, 1024];
  parameterStubValues[import_engine5.WebGLConstants.MAX_VIEWPORT_DIMS] = [16384, 16384];
  parameterStubValues[import_engine5.WebGLConstants.MAX_TEXTURE_MAX_ANISOTROPY_EXT] = 16;
  parameterStubValues[import_engine5.WebGLConstants.MAX_DRAW_BUFFERS] = 8;
  parameterStubValues[import_engine5.WebGLConstants.MAX_COLOR_ATTACHMENTS] = 8;
  parameterStubValues[import_engine5.WebGLConstants.MAX_SAMPLES] = 8;
  return function(pname) {
    const value = parameterStubValues[pname];
    if (!(0, import_engine5.defined)(value)) {
      throw new import_engine5.DeveloperError(
        `A WebGL parameter stub for ${pname} is not defined. Add it.`
      );
    }
    return value;
  };
}
function getProgramParameterStub(program, pname) {
  if (pname === import_engine5.WebGLConstants.LINK_STATUS || pname === import_engine5.WebGLConstants.VALIDATE_STATUS) {
    return true;
  }
  if (pname === import_engine5.WebGLConstants.ACTIVE_UNIFORMS || pname === import_engine5.WebGLConstants.ACTIVE_ATTRIBUTES) {
    return 0;
  }
  throw new import_engine5.DeveloperError(
    `A WebGL parameter stub for ${pname} is not defined. Add it.`
  );
}
function getShaderParameterStub(shader, pname) {
  if (pname !== import_engine5.WebGLConstants.COMPILE_STATUS) {
    throw new import_engine5.DeveloperError(
      `A WebGL parameter stub for ${pname} is not defined. Add it.`
    );
  }
  return true;
}
function getShaderPrecisionStub(shadertype, precisiontype) {
  if (shadertype !== import_engine5.WebGLConstants.FRAGMENT_SHADER) {
    throw new import_engine5.DeveloperError(
      "getShaderPrecision only has a stub for FRAGMENT_SHADER. Update it."
    );
  }
  if (precisiontype !== import_engine5.WebGLConstants.HIGH_FLOAT && precisiontype !== import_engine5.WebGLConstants.HIGH_INT) {
    throw new import_engine5.DeveloperError(
      "getShaderPrecision only has a stub for HIGH_FLOAT and HIGH_INT. Update it."
    );
  }
  if (precisiontype === import_engine5.WebGLConstants.HIGH_FLOAT) {
    return {
      rangeMin: 127,
      rangeMax: 127,
      precision: 23
    };
  }
  return {
    rangeMin: 31,
    rangeMax: 30,
    precision: 0
  };
}
function readPixelsStub(x, y, width, height, format, type, pixels) {
  return [0, 0, 0, 0];
}
var getWebGLStub_default = getWebGLStub;

// Specs/createContext.js
function createContext(options, canvasWidth, canvasHeight) {
  options = (0, import_engine6.clone)((0, import_engine6.defaultValue)(options, {}));
  options.webgl = (0, import_engine6.clone)((0, import_engine6.defaultValue)(options.webgl, {}));
  options.webgl.antialias = (0, import_engine6.defaultValue)(options.webgl.antialias, false);
  if (!!window.webglStub) {
    options.getWebGLStub = getWebGLStub_default;
  }
  const canvas = createCanvas_default(canvasWidth, canvasHeight);
  const context = new import_engine6.Context(canvas, options);
  if (!!window.webglValidation) {
    context.validateShaderProgram = true;
    context.validateFramebuffer = true;
    context.logShaderCompilation = true;
    context.throwOnWebGLError = true;
  }
  const us = context.uniformState;
  us.update(createFrameState_default(context));
  context.destroyForSpecs = function() {
    document.body.removeChild(context.canvas);
    return context.destroy();
  };
  return context;
}
var createContext_default = createContext;

// packages/engine/Specs/Core/EllipsoidTerrainProviderSpec.js
describe(
  "Core/EllipsoidTerrainProvider",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("conforms to TerrainProvider interface", function() {
      expect(import__49.EllipsoidTerrainProvider).toConformToInterface(import__49.TerrainProvider);
    });
    it("requestTileGeometry creates terrain data.", function() {
      const terrain = new import__49.EllipsoidTerrainProvider();
      const terrainData = terrain.requestTileGeometry(0, 0, 0);
      expect(terrainData).toBeDefined();
    });
    it("has error event", function() {
      const provider = new import__49.EllipsoidTerrainProvider();
      expect(provider.errorEvent).toBeDefined();
      expect(provider.errorEvent).toBe(provider.errorEvent);
    });
    it("returns undefined on getTileDataAvailable()", function() {
      const provider = new import__49.EllipsoidTerrainProvider();
      expect(provider.getTileDataAvailable()).toBeUndefined();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Core/EllipsoidalOccluderSpec.js
var import__50 = __toESM(require_Cesium(), 1);
describe("Core/EllipsoidalOccluder", function() {
  it("uses ellipsoid", function() {
    const ellipsoid = new import__50.Ellipsoid(2, 3, 4);
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid);
    expect(occluder.ellipsoid).toEqual(ellipsoid);
  });
  it("throws if ellipsoid is not provided to constructor", function() {
    function createOccluderWithoutEllipsoid() {
      return new import__50.EllipsoidalOccluder(void 0, new import__50.Cartesian3(1, 2, 3));
    }
    expect(createOccluderWithoutEllipsoid).toThrowDeveloperError();
  });
  it("isPointVisible example works as claimed", function() {
    const cameraPosition = new import__50.Cartesian3(0, 0, 2.5);
    const ellipsoid = new import__50.Ellipsoid(1, 1.1, 0.9);
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid, cameraPosition);
    const point = new import__50.Cartesian3(0, -3, -3);
    expect(occluder.isPointVisible(point)).toEqual(true);
  });
  it("isScaledSpacePointVisible example works as claimed", function() {
    const cameraPosition = new import__50.Cartesian3(0, 0, 2.5);
    const ellipsoid = new import__50.Ellipsoid(1, 1.1, 0.9);
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid, cameraPosition);
    const point = new import__50.Cartesian3(0, -3, -3);
    const scaledSpacePoint = ellipsoid.transformPositionToScaledSpace(point);
    expect(occluder.isScaledSpacePointVisible(scaledSpacePoint)).toEqual(true);
  });
  it("isScaledSpacePointVisiblePossiblyUnderEllipsoid example works as claimed", function() {
    const cameraPosition = new import__50.Cartesian3(0, 0, 1);
    const ellipsoid = new import__50.Ellipsoid(1, 1, 1);
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid, cameraPosition);
    const height = -0.5;
    let direction = import__50.Cartesian3.normalize(
      new import__50.Cartesian3(1, 1, 1),
      new import__50.Cartesian3()
    );
    let point = import__50.Cartesian3.multiplyByScalar(direction, 0.5, new import__50.Cartesian3());
    let scaledSpacePoint = occluder.computeHorizonCullingPoint(point, [point]);
    let scaledSpacePointShrunk = occluder.computeHorizonCullingPointPossiblyUnderEllipsoid(
      point,
      [point],
      height
    );
    expect(occluder.isScaledSpacePointVisible(scaledSpacePoint)).toEqual(false);
    expect(
      occluder.isScaledSpacePointVisiblePossiblyUnderEllipsoid(
        scaledSpacePointShrunk,
        height
      )
    ).toEqual(true);
    direction = new import__50.Cartesian3(0, 1, 0);
    point = import__50.Cartesian3.multiplyByScalar(direction, 0.5, new import__50.Cartesian3());
    scaledSpacePoint = occluder.computeHorizonCullingPoint(point, [point]);
    scaledSpacePointShrunk = occluder.computeHorizonCullingPointPossiblyUnderEllipsoid(
      point,
      [point],
      height
    );
    expect(occluder.isScaledSpacePointVisible(scaledSpacePoint)).toEqual(false);
    expect(
      occluder.isScaledSpacePointVisiblePossiblyUnderEllipsoid(
        scaledSpacePointShrunk,
        height
      )
    ).toEqual(false);
  });
  it("reports not visible when point is directly behind ellipsoid", function() {
    const ellipsoid = import__50.Ellipsoid.WGS84;
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid);
    occluder.cameraPosition = new import__50.Cartesian3(7e6, 0, 0);
    const point = new import__50.Cartesian3(-7e6, 0, 0);
    expect(occluder.isPointVisible(point)).toEqual(false);
  });
  it("reports not visible when point is directly behind ellipsoid and camera is inside the ellispoid", function() {
    const ellipsoid = import__50.Ellipsoid.WGS84;
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid);
    occluder.cameraPosition = new import__50.Cartesian3(
      ellipsoid.minimumRadius - 100,
      0,
      0
    );
    const point = new import__50.Cartesian3(-7e6, 0, 0);
    expect(occluder.isPointVisible(point)).toEqual(false);
  });
  it("reports visible when point is in front of ellipsoid", function() {
    const ellipsoid = import__50.Ellipsoid.WGS84;
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid);
    occluder.cameraPosition = new import__50.Cartesian3(7e6, 0, 0);
    const point = new import__50.Cartesian3(69e5, 0, 0);
    expect(occluder.isPointVisible(point)).toEqual(true);
  });
  it("reports visible when point is in opposite direction from ellipsoid", function() {
    const ellipsoid = import__50.Ellipsoid.WGS84;
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid);
    occluder.cameraPosition = new import__50.Cartesian3(7e6, 0, 0);
    const point = new import__50.Cartesian3(71e5, 0, 0);
    expect(occluder.isPointVisible(point)).toEqual(true);
  });
  it("reports not visible when point is over horizon", function() {
    const ellipsoid = import__50.Ellipsoid.WGS84;
    const occluder = new import__50.EllipsoidalOccluder(ellipsoid);
    occluder.cameraPosition = new import__50.Cartesian3(7e6, 0, 0);
    const point = new import__50.Cartesian3(4510635, 4510635, 0);
    expect(occluder.isPointVisible(point)).toEqual(false);
  });
  describe("computeHorizonCullingPoint", function() {
    it("requires directionToPoint and positions", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 12345, 12345);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [new import__50.Cartesian3(-12345, 12345, 12345)];
      const directionToPoint = import__50.BoundingSphere.fromPoints(positions).center;
      expect(function() {
        ellipsoidalOccluder.computeHorizonCullingPoint(void 0, positions);
      }).toThrowDeveloperError();
      expect(function() {
        ellipsoidalOccluder.computeHorizonCullingPoint(
          directionToPoint,
          void 0
        );
      }).toThrowDeveloperError();
    });
    it("returns point on ellipsoid when single position is on center line", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 4567, 8910);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [new import__50.Cartesian3(12345, 0, 0)];
      const directionToPoint = new import__50.Cartesian3(1, 0, 0);
      const result = ellipsoidalOccluder.computeHorizonCullingPoint(
        directionToPoint,
        positions
      );
      expect(result.x).toEqualEpsilon(1, import__50.Math.EPSILON14);
      expect(result.y).toEqualEpsilon(0, import__50.Math.EPSILON14);
      expect(result.z).toEqualEpsilon(0, import__50.Math.EPSILON14);
    });
    it("returns undefined when horizon of single point is parallel to center line", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 4567, 8910);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [new import__50.Cartesian3(0, 4567, 0)];
      const directionToPoint = new import__50.Cartesian3(1, 0, 0);
      const result = ellipsoidalOccluder.computeHorizonCullingPoint(
        directionToPoint,
        positions
      );
      expect(result).toBeUndefined();
    });
    it("returns undefined when single point is in the opposite direction of the center line", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 4567, 8910);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [new import__50.Cartesian3(-14e3, -1e3, 0)];
      const directionToPoint = new import__50.Cartesian3(1, 0, 0);
      const result = ellipsoidalOccluder.computeHorizonCullingPoint(
        directionToPoint,
        positions
      );
      expect(result).toBeUndefined();
    });
    it("returns undefined when any point is in the opposite direction of the center line", function() {
      const ellipsoid = new import__50.Ellipsoid(1, 1, 1);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [
        new import__50.Cartesian3(2, 0, 0),
        new import__50.Cartesian3(-1, 0, 0)
      ];
      const directionToPoint = new import__50.Cartesian3(1, 0, 0);
      const result = ellipsoidalOccluder.computeHorizonCullingPoint(
        directionToPoint,
        positions
      );
      expect(result).toBeUndefined();
    });
    it("returns undefined when the direction is zero", function() {
      const ellipsoid = new import__50.Ellipsoid(1, 1, 1);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [new import__50.Cartesian3(1, 0, 0)];
      const directionToPoint = new import__50.Cartesian3(0, 0, 0);
      const result = ellipsoidalOccluder.computeHorizonCullingPoint(
        directionToPoint,
        positions
      );
      expect(result).toBeUndefined();
    });
    it("computes a point from a single position with a grazing altitude close to zero", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 12345, 12345);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [
        new import__50.Cartesian3(-12345, 12345, 12345),
        new import__50.Cartesian3(-12346, 12345, 12345)
      ];
      const boundingSphere = import__50.BoundingSphere.fromPoints(positions);
      const firstPositionArray = [positions[0]];
      const result = ellipsoidalOccluder.computeHorizonCullingPoint(
        boundingSphere.center,
        firstPositionArray
      );
      const unscaledResult = import__50.Cartesian3.multiplyComponents(
        result,
        ellipsoid.radii,
        new import__50.Cartesian3()
      );
      const direction = import__50.Cartesian3.normalize(
        import__50.Cartesian3.subtract(positions[0], unscaledResult, new import__50.Cartesian3()),
        new import__50.Cartesian3()
      );
      const nearest = import__50.IntersectionTests.grazingAltitudeLocation(
        new import__50.Ray(unscaledResult, direction),
        ellipsoid
      );
      const nearestCartographic = ellipsoid.cartesianToCartographic(nearest);
      expect(nearestCartographic.height).toEqualEpsilon(
        0,
        import__50.Math.EPSILON5
      );
    });
    it("computes a point from multiple positions with a grazing altitude close to zero for one of the positions and less than zero for the others", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 12345, 12345);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [
        new import__50.Cartesian3(-12345, 12345, 12345),
        new import__50.Cartesian3(-12346, 12345, 12345),
        new import__50.Cartesian3(-12446, 12445, 12445)
      ];
      const boundingSphere = import__50.BoundingSphere.fromPoints(positions);
      const result = ellipsoidalOccluder.computeHorizonCullingPoint(
        boundingSphere.center,
        positions
      );
      const unscaledResult = import__50.Cartesian3.multiplyComponents(
        result,
        ellipsoid.radii,
        new import__50.Cartesian3()
      );
      let foundOneNearZero = false;
      for (let i = 0; i < positions.length; ++i) {
        const direction = import__50.Cartesian3.normalize(
          import__50.Cartesian3.subtract(positions[i], unscaledResult, new import__50.Cartesian3()),
          new import__50.Cartesian3()
        );
        const nearest = import__50.IntersectionTests.grazingAltitudeLocation(
          new import__50.Ray(unscaledResult, direction),
          ellipsoid
        );
        const nearestCartographic = ellipsoid.cartesianToCartographic(nearest);
        if (Math.abs(nearestCartographic.height) < import__50.Math.EPSILON5) {
          foundOneNearZero = true;
        } else {
          expect(nearestCartographic.height).toBeLessThan(0);
        }
      }
      expect(foundOneNearZero).toBe(true);
    });
    it("computes a point under the ellipsoid with computeHorizonCullingPointPossiblyUnderEllipsoid", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 4567, 8910);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [new import__50.Cartesian3(12344, 0, 0)];
      const directionToPoint = new import__50.Cartesian3(1, 0, 0);
      const result = ellipsoidalOccluder.computeHorizonCullingPointPossiblyUnderEllipsoid(
        directionToPoint,
        positions,
        -1
      );
      expect(result.x).toEqualEpsilon(1, import__50.Math.EPSILON14);
      expect(result.y).toEqualEpsilon(0, import__50.Math.EPSILON14);
      expect(result.z).toEqualEpsilon(0, import__50.Math.EPSILON14);
    });
  });
  describe("computeHorizonCullingPointFromVertices", function() {
    it("requires directionToPoint, vertices, and stride", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 12345, 12345);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [
        new import__50.Cartesian3(-12345, 12345, 12345),
        new import__50.Cartesian3(-12346, 12345, 12345),
        new import__50.Cartesian3(-12446, 12445, 12445)
      ];
      const boundingSphere = import__50.BoundingSphere.fromPoints(positions);
      const vertices = [];
      for (let i = 0; i < positions.length; ++i) {
        const position = positions[i];
        vertices.push(position.x);
        vertices.push(position.y);
        vertices.push(position.z);
        vertices.push(1);
        vertices.push(2);
        vertices.push(3);
        vertices.push(4);
      }
      ellipsoidalOccluder.computeHorizonCullingPointFromVertices(
        boundingSphere.center,
        vertices,
        7
      );
      expect(function() {
        ellipsoidalOccluder.computeHorizonCullingPointFromVertices(
          void 0,
          vertices,
          7
        );
      }).toThrowDeveloperError();
      expect(function() {
        ellipsoidalOccluder.computeHorizonCullingPointFromVertices(
          boundingSphere.center,
          void 0,
          7
        );
      }).toThrowDeveloperError();
      expect(function() {
        ellipsoidalOccluder.computeHorizonCullingPointFromVertices(
          boundingSphere.center,
          vertices,
          void 0
        );
      }).toThrowDeveloperError();
    });
    it("produces same answers as computeHorizonCullingPoint", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 12345, 12345);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const positions = [
        new import__50.Cartesian3(-12345, 12345, 12345),
        new import__50.Cartesian3(-12346, 12345, 12345),
        new import__50.Cartesian3(-12446, 12445, 12445)
      ];
      const boundingSphere = import__50.BoundingSphere.fromPoints(positions);
      const center = new import__50.Cartesian3(-12e3, 12e3, 12e3);
      const vertices = [];
      for (let i = 0; i < positions.length; ++i) {
        const position = positions[i];
        vertices.push(position.x - center.x);
        vertices.push(position.y - center.y);
        vertices.push(position.z - center.z);
        vertices.push(1);
        vertices.push(2);
        vertices.push(3);
        vertices.push(4);
      }
      const result1 = ellipsoidalOccluder.computeHorizonCullingPoint(
        boundingSphere.center,
        positions
      );
      const result2 = ellipsoidalOccluder.computeHorizonCullingPointFromVertices(
        boundingSphere.center,
        vertices,
        7,
        center
      );
      expect(result1.x).toEqualEpsilon(result2.x, import__50.Math.EPSILON14);
      expect(result1.y).toEqualEpsilon(result2.y, import__50.Math.EPSILON14);
      expect(result1.z).toEqualEpsilon(result2.z, import__50.Math.EPSILON14);
    });
    it("computes a point under the ellipsoid with computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 4567, 8910);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const vertices = [12344, 0, 0];
      const directionToPoint = new import__50.Cartesian3(1, 0, 0);
      const center = import__50.Cartesian3.ZERO;
      const result = ellipsoidalOccluder.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid(
        directionToPoint,
        vertices,
        3,
        center,
        -1
      );
      expect(result.x).toEqualEpsilon(1, import__50.Math.EPSILON14);
      expect(result.y).toEqualEpsilon(0, import__50.Math.EPSILON14);
      expect(result.z).toEqualEpsilon(0, import__50.Math.EPSILON14);
    });
  });
  describe("computeHorizonCullingPointFromRectangle", function() {
    it("returns undefined for global rectangle", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 12345, 12345);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const rectangle = import__50.Rectangle.MAX_VALUE;
      const result = ellipsoidalOccluder.computeHorizonCullingPointFromRectangle(
        rectangle,
        ellipsoid
      );
      expect(result).toBeUndefined();
    });
    it("computes a point with a grazing altitude close to zero for one of the rectangle corners and less than or equal to zero for the others", function() {
      const ellipsoid = new import__50.Ellipsoid(12345, 12345, 12345);
      const ellipsoidalOccluder = new import__50.EllipsoidalOccluder(ellipsoid);
      const rectangle = new import__50.Rectangle(0.1, 0.2, 0.3, 0.4);
      const result = ellipsoidalOccluder.computeHorizonCullingPointFromRectangle(
        rectangle,
        ellipsoid
      );
      expect(result).toBeDefined();
      const unscaledResult = import__50.Cartesian3.multiplyComponents(
        result,
        ellipsoid.radii,
        new import__50.Cartesian3()
      );
      const positions = [
        ellipsoid.cartographicToCartesian(import__50.Rectangle.southwest(rectangle)),
        ellipsoid.cartographicToCartesian(import__50.Rectangle.southeast(rectangle)),
        ellipsoid.cartographicToCartesian(import__50.Rectangle.northwest(rectangle)),
        ellipsoid.cartographicToCartesian(import__50.Rectangle.northeast(rectangle))
      ];
      let foundOneNearZero = false;
      for (let i = 0; i < positions.length; ++i) {
        const direction = import__50.Cartesian3.normalize(
          import__50.Cartesian3.subtract(positions[i], unscaledResult, new import__50.Cartesian3()),
          new import__50.Cartesian3()
        );
        const nearest = import__50.IntersectionTests.grazingAltitudeLocation(
          new import__50.Ray(unscaledResult, direction),
          ellipsoid
        );
        const nearestCartographic = ellipsoid.cartesianToCartographic(nearest);
        if (Math.abs(nearestCartographic.height) < import__50.Math.EPSILON5) {
          foundOneNearZero = true;
        } else {
          expect(nearestCartographic.height).toBeLessThanOrEqual(0);
        }
      }
      expect(foundOneNearZero).toBe(true);
    });
  });
});

// packages/engine/Specs/Core/EncodedCartesian3Spec.js
var import__51 = __toESM(require_Cesium(), 1);
describe("Core/EncodedCartesian3", function() {
  it("construct with default values", function() {
    const encoded = new import__51.EncodedCartesian3();
    expect(encoded.high).toEqual(import__51.Cartesian3.ZERO);
    expect(encoded.low).toEqual(import__51.Cartesian3.ZERO);
  });
  it("endcode encodes a positive value", function() {
    const encoded = import__51.EncodedCartesian3.encode(-1e7);
    expect(encoded.high + encoded.low).toEqual(-1e7);
  });
  it("endcode encodes a negative value", function() {
    const encoded = import__51.EncodedCartesian3.encode(1e7);
    expect(encoded.high + encoded.low).toEqual(1e7);
  });
  it("endcode encodes with a result parameter", function() {
    const result = {
      high: 0,
      low: 0
    };
    const returnedResult = import__51.EncodedCartesian3.encode(0, result);
    expect(result).toBe(returnedResult);
    expect(returnedResult.high + returnedResult.low).toEqual(0);
  });
  it("fromCartesian encodes a cartesian", function() {
    const c = new import__51.Cartesian3(-1e7, 0, 1e7);
    const encoded = import__51.EncodedCartesian3.fromCartesian(c);
    expect(encoded.high.x + encoded.low.x).toEqual(-1e7);
    expect(encoded.high.y + encoded.low.y).toEqual(0);
    expect(encoded.high.z + encoded.low.z).toEqual(1e7);
  });
  it("fromCartesian encodes a cartesian with a result parameter", function() {
    const p = new import__51.Cartesian3(-1e7, 0, 1e7);
    const encoded = import__51.EncodedCartesian3.fromCartesian(p);
    const positions = new Float32Array(6);
    import__51.EncodedCartesian3.writeElements(p, positions, 0);
    expect(encoded.high.x).toEqual(positions[0]);
    expect(encoded.high.y).toEqual(positions[1]);
    expect(encoded.high.z).toEqual(positions[2]);
    expect(encoded.low.x).toEqual(positions[3]);
    expect(encoded.low.y).toEqual(positions[4]);
    expect(encoded.low.z).toEqual(positions[5]);
  });
  it("writeElements encodes a cartesian", function() {
    const c = new import__51.Cartesian3(-1e7, 0, 1e7);
    const encoded = new import__51.EncodedCartesian3();
    const encoded2 = import__51.EncodedCartesian3.fromCartesian(c, encoded);
    expect(encoded2).toBe(encoded);
    expect(encoded.high.x + encoded.low.x).toEqual(-1e7);
    expect(encoded.high.y + encoded.low.y).toEqual(0);
    expect(encoded.high.z + encoded.low.z).toEqual(1e7);
  });
  it("encode throws without a value", function() {
    expect(function() {
      import__51.EncodedCartesian3.encode();
    }).toThrowDeveloperError();
  });
  it("fromCartesian throws without a cartesian", function() {
    expect(function() {
      import__51.EncodedCartesian3.fromCartesian();
    }).toThrowDeveloperError();
  });
  it("writeElements throws without a cartesian", function() {
    expect(function() {
      import__51.EncodedCartesian3.writeElements();
    }).toThrowDeveloperError();
  });
  it("writeElements throws without a cartesianArray", function() {
    expect(function() {
      import__51.EncodedCartesian3.writeElements(new import__51.Cartesian3());
    }).toThrowDeveloperError();
  });
  it("writeElements throws without an index", function() {
    expect(function() {
      import__51.EncodedCartesian3.writeElements(new import__51.Cartesian3(), new Float32Array(6));
    }).toThrowDeveloperError();
  });
  it("writeElements throws with a negative index", function() {
    expect(function() {
      import__51.EncodedCartesian3.writeElements(
        new import__51.Cartesian3(),
        new Float32Array(6),
        -1
      );
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/EventSpec.js
var import__52 = __toESM(require_Cesium(), 1);
describe("Core/Event", function() {
  let event;
  let spyListener;
  beforeEach(function() {
    event = new import__52.Event();
    spyListener = jasmine.createSpy("listener");
  });
  it("works with no scope", function() {
    const someValue = 123;
    event.addEventListener(spyListener);
    event.raiseEvent(someValue);
    expect(spyListener).toHaveBeenCalledWith(someValue);
    spyListener.calls.reset();
    event.removeEventListener(spyListener);
    event.raiseEvent(someValue);
    expect(spyListener).not.toHaveBeenCalled();
  });
  it("works with scope", function() {
    const someValue = 123;
    const scope = {};
    event.addEventListener(spyListener, scope);
    event.raiseEvent(someValue);
    expect(spyListener).toHaveBeenCalledWith(someValue);
    expect(spyListener.calls.first().object).toBe(scope);
    spyListener.calls.reset();
    event.removeEventListener(spyListener, scope);
    event.raiseEvent(someValue);
    expect(spyListener).not.toHaveBeenCalled();
  });
  it("can remove from within a callback", function() {
    const doNothing = function(evt) {
    };
    const removeEventCb = function(evt) {
      event.removeEventListener(removeEventCb);
    };
    const doNothing2 = function(evt) {
    };
    event.addEventListener(doNothing);
    event.addEventListener(removeEventCb);
    event.addEventListener(doNothing2);
    event.raiseEvent();
    expect(event.numberOfListeners).toEqual(2);
    event.removeEventListener(doNothing);
    event.removeEventListener(doNothing2);
    expect(event.numberOfListeners).toEqual(0);
  });
  it("can remove multiple listeners within a callback", function() {
    const removeEvent0 = event.addEventListener(function() {
      removeEvent0();
    });
    event.addEventListener(function() {
    });
    const removeEvent2 = event.addEventListener(function() {
      removeEvent2();
    });
    event.addEventListener(function() {
    });
    const removeEvent4 = event.addEventListener(function() {
      removeEvent4();
    });
    event.addEventListener(function() {
    });
    const removeEvent6 = event.addEventListener(function() {
      removeEvent6();
    });
    event.addEventListener(function() {
    });
    const removeEvent8 = event.addEventListener(function() {
      removeEvent8();
    });
    event.addEventListener(function() {
    });
    expect(event.numberOfListeners).toEqual(10);
    event.raiseEvent();
    expect(event.numberOfListeners).toEqual(5);
    event.raiseEvent();
    expect(event.numberOfListeners).toEqual(5);
  });
  it("addEventListener and removeEventListener works with same function of different scopes", function() {
    const Scope = function() {
      this.timesCalled = 0;
    };
    Scope.prototype.myCallback = function() {
      this.timesCalled++;
    };
    const scope1 = new Scope();
    const scope2 = new Scope();
    event.addEventListener(Scope.prototype.myCallback, scope1);
    event.addEventListener(Scope.prototype.myCallback, scope2);
    event.raiseEvent();
    expect(scope1.timesCalled).toEqual(1);
    expect(scope2.timesCalled).toEqual(1);
    event.removeEventListener(Scope.prototype.myCallback, scope1);
    expect(event.numberOfListeners).toEqual(1);
    event.raiseEvent();
    expect(scope1.timesCalled).toEqual(1);
    expect(scope2.timesCalled).toEqual(2);
    event.removeEventListener(Scope.prototype.myCallback, scope2);
    expect(event.numberOfListeners).toEqual(0);
  });
  it("numberOfListeners returns the correct number", function() {
    const callback1 = function() {
    };
    const callback2 = function() {
    };
    expect(event.numberOfListeners).toEqual(0);
    event.addEventListener(callback1);
    expect(event.numberOfListeners).toEqual(1);
    event.addEventListener(callback2);
    expect(event.numberOfListeners).toEqual(2);
    event.removeEventListener(callback2);
    expect(event.numberOfListeners).toEqual(1);
  });
  it("removeEventListener indicates if the listener is registered with the event", function() {
    const callback = function() {
    };
    event.addEventListener(callback);
    expect(event.numberOfListeners).toEqual(1);
    expect(event.removeEventListener(callback)).toEqual(true);
    expect(event.numberOfListeners).toEqual(0);
    expect(event.removeEventListener(callback)).toEqual(false);
  });
  it("removeEventListener does not remove a registered listener of a different scope", function() {
    const myFunc = function() {
    };
    const scope = {};
    event.addEventListener(myFunc, scope);
    expect(event.removeEventListener(myFunc)).toEqual(false);
  });
  it("works with no listeners", function() {
    event.raiseEvent(123);
  });
  it("addEventListener returns a function allowing removal", function() {
    const someValue = 123;
    const remove = event.addEventListener(spyListener);
    event.raiseEvent(someValue);
    expect(spyListener).toHaveBeenCalledWith(someValue);
    spyListener.calls.reset();
    remove();
    event.raiseEvent(someValue);
    expect(spyListener).not.toHaveBeenCalled();
  });
  it("addEventListener with scope returns a function allowing removal", function() {
    const someValue = 123;
    const scope = {};
    const remove = event.addEventListener(spyListener, scope);
    event.raiseEvent(someValue);
    expect(spyListener).toHaveBeenCalledWith(someValue);
    spyListener.calls.reset();
    remove();
    event.raiseEvent(someValue);
    expect(spyListener).not.toHaveBeenCalled();
  });
  it("addEventListener throws with undefined listener", function() {
    expect(function() {
      event.addEventListener(void 0);
    }).toThrowDeveloperError();
  });
  it("addEventListener throws with null listener", function() {
    expect(function() {
      event.addEventListener(null);
    }).toThrowDeveloperError();
  });
  it("addEventListener throws with non-function listener", function() {
    expect(function() {
      event.addEventListener({});
    }).toThrowDeveloperError();
  });
  it("removeEventListener throws with undefined listener", function() {
    expect(function() {
      event.removeEventListener(void 0);
    }).toThrowDeveloperError();
  });
  it("removeEventListener throws with null listener", function() {
    expect(function() {
      event.removeEventListener(null);
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/FeatureDetectionSpec.js
var import__53 = __toESM(require_Cesium(), 1);

// Specs/createScene.js
var import_engine7 = __toESM(require_Cesium(), 1);
function createScene(options) {
  options = (0, import_engine7.defaultValue)(options, {});
  const debugWidth = window.debugCanvasWidth;
  const debugHeight = (0, import_engine7.defaultValue)(
    window.debugCanvasHeight,
    window.debugCanvasWidth
  );
  const canvas = (0, import_engine7.defined)(options.canvas) ? options.canvas : createCanvas_default(debugWidth, debugHeight);
  options.canvas = void 0;
  options = (0, import_engine7.clone)(options, true);
  options.canvas = canvas;
  options.contextOptions = (0, import_engine7.defaultValue)(options.contextOptions, {});
  const contextOptions = options.contextOptions;
  contextOptions.webgl = (0, import_engine7.defaultValue)(contextOptions.webgl, {});
  contextOptions.webgl.antialias = (0, import_engine7.defaultValue)(
    contextOptions.webgl.antialias,
    false
  );
  contextOptions.webgl.stencil = (0, import_engine7.defaultValue)(
    contextOptions.webgl.stencil,
    true
  );
  if (!!window.webglStub) {
    contextOptions.getWebGLStub = getWebGLStub_default;
  }
  const scene2 = new import_engine7.Scene(options);
  scene2.highDynamicRange = false;
  if (!!window.webglValidation) {
    const context = scene2.context;
    context.validateShaderProgram = true;
    context.validateFramebuffer = true;
    context.logShaderCompilation = true;
    context.throwOnWebGLError = true;
  }
  scene2.destroyForSpecs = function() {
    const canvas2 = this.canvas;
    this.destroy();
    document.body.removeChild(canvas2);
  };
  scene2.renderForSpecs = function(time2) {
    this.initializeFrame();
    this.render(time2);
  };
  scene2.pickForSpecs = function() {
    this.pick(new import_engine7.Cartesian2(0, 0));
  };
  scene2.rethrowRenderErrors = (0, import_engine7.defaultValue)(options.rethrowRenderErrors, true);
  return scene2;
}
var createScene_default = createScene;

// packages/engine/Specs/Core/FeatureDetectionSpec.js
describe("Core/FeatureDetection", function() {
  it("detects fullscreen support", function() {
    const supportsFullscreen = import__53.FeatureDetection.supportsFullscreen();
    expect(typeof supportsFullscreen).toEqual("boolean");
  });
  it("detects web worker support", function() {
    const supportsWebWorkers = import__53.FeatureDetection.supportsWebWorkers();
    expect(typeof supportsWebWorkers).toEqual("boolean");
  });
  it("detects typed array support", function() {
    const supportsTypedArrays = import__53.FeatureDetection.supportsTypedArrays();
    expect(typeof supportsTypedArrays).toEqual("boolean");
  });
  it("detects BigInt64Array support", function() {
    const supportsBigInt64Array = import__53.FeatureDetection.supportsBigInt64Array();
    expect(typeof supportsBigInt64Array).toEqual("boolean");
  });
  it("detects BigUint64Array support", function() {
    const supportsBigUint64Array = import__53.FeatureDetection.supportsBigUint64Array();
    expect(typeof supportsBigUint64Array).toEqual("boolean");
  });
  it("detects BigInt support", function() {
    const supportsBigInt = import__53.FeatureDetection.supportsBigInt();
    expect(typeof supportsBigInt).toEqual("boolean");
  });
  it("detects web assembly support", function() {
    const supportsWebAssembly = import__53.FeatureDetection.supportsWebAssembly();
    expect(typeof supportsWebAssembly).toEqual("boolean");
  });
  function checkVersionArray(array) {
    expect(Array.isArray(array)).toEqual(true);
    array.forEach(function(d) {
      expect(typeof d).toEqual("number");
    });
  }
  it("detects Chrome", function() {
    const isChrome = import__53.FeatureDetection.isChrome();
    expect(typeof isChrome).toEqual("boolean");
    if (isChrome) {
      const chromeVersion = import__53.FeatureDetection.chromeVersion();
      checkVersionArray(chromeVersion);
      console.log(`detected Chrome ${chromeVersion.join(".")}`);
    }
  });
  it("detects Safari", function() {
    const isSafari = import__53.FeatureDetection.isSafari();
    expect(typeof isSafari).toEqual("boolean");
    if (isSafari) {
      const safariVersion = import__53.FeatureDetection.safariVersion();
      checkVersionArray(safariVersion);
      console.log(`detected Safari ${safariVersion.join(".")}`);
    }
  });
  it("detects Webkit", function() {
    const isWebkit = import__53.FeatureDetection.isWebkit();
    expect(typeof isWebkit).toEqual("boolean");
    if (isWebkit) {
      const webkitVersion = import__53.FeatureDetection.webkitVersion();
      checkVersionArray(webkitVersion);
      expect(typeof webkitVersion.isNightly).toEqual("boolean");
      console.log(
        `detected Webkit ${webkitVersion.join(".")}${webkitVersion.isNightly ? " (Nightly)" : ""}`
      );
    }
  });
  it("detects Internet Explorer", function() {
    const isInternetExplorer = import__53.FeatureDetection.isInternetExplorer();
    expect(typeof isInternetExplorer).toEqual("boolean");
    if (isInternetExplorer) {
      const internetExplorerVersion = import__53.FeatureDetection.internetExplorerVersion();
      checkVersionArray(internetExplorerVersion);
      console.log(
        `detected Internet Explorer ${internetExplorerVersion.join(".")}`
      );
    }
  });
  it("detects Edge", function() {
    const isEdge = import__53.FeatureDetection.isEdge();
    expect(typeof isEdge).toEqual("boolean");
    if (isEdge) {
      const edgeVersion = import__53.FeatureDetection.edgeVersion();
      checkVersionArray(edgeVersion);
      console.log(`detected Edge ${edgeVersion.join(".")}`);
    }
  });
  it("detects Firefox", function() {
    const isFirefox = import__53.FeatureDetection.isFirefox();
    expect(typeof isFirefox).toEqual("boolean");
    if (isFirefox) {
      const firefoxVersion = import__53.FeatureDetection.firefoxVersion();
      checkVersionArray(firefoxVersion);
      console.log(`detected Firefox ${firefoxVersion.join(".")}`);
    }
  });
  it("detects iPad or iOS", function() {
    const iPadOrIOS = import__53.FeatureDetection.isIPadOrIOS();
    expect(typeof iPadOrIOS).toEqual("boolean");
  });
  it("detects imageRendering support", function() {
    const supportsImageRenderingPixelated = import__53.FeatureDetection.supportsImageRenderingPixelated();
    expect(typeof supportsImageRenderingPixelated).toEqual("boolean");
    if (supportsImageRenderingPixelated) {
      expect(import__53.FeatureDetection.imageRenderingValue()).toBeDefined();
    } else {
      expect(import__53.FeatureDetection.imageRenderingValue()).not.toBeDefined();
    }
  });
  it("supportWebP throws when it has not been initialized", function() {
    import__53.FeatureDetection.supportsWebP._promise = void 0;
    import__53.FeatureDetection.supportsWebP._result = void 0;
    expect(function() {
      import__53.FeatureDetection.supportsWebP();
    }).toThrowDeveloperError();
  });
  it("detects WebP support", function() {
    import__53.FeatureDetection.supportsWebP._promise = void 0;
    import__53.FeatureDetection.supportsWebP._result = void 0;
    return import__53.FeatureDetection.supportsWebP.initialize().then(function(supportsWebP) {
      expect(typeof supportsWebP).toEqual("boolean");
      expect(import__53.FeatureDetection.supportsWebP()).toEqual(supportsWebP);
    });
  });
  it("detects WebGL2 support", function() {
    const scene2 = createScene_default();
    expect(import__53.FeatureDetection.supportsWebgl2(scene2)).toEqual(
      scene2.context.webgl2
    );
    scene2.destroyForSpecs();
  });
});

// packages/engine/Specs/Core/FrustumGeometrySpec.js
var import__54 = __toESM(require_Cesium(), 1);
describe("Core/FrustumGeometry", function() {
  it("constructor throws without options", function() {
    expect(function() {
      return new import__54.FrustumGeometry();
    }).toThrowDeveloperError();
  });
  it("constructor throws without frustum", function() {
    expect(function() {
      return new import__54.FrustumGeometry({
        origin: import__54.Cartesian3.ZERO,
        orientation: import__54.Quaternion.IDENTITY
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without position", function() {
    expect(function() {
      return new import__54.FrustumGeometry({
        frustum: new import__54.PerspectiveFrustum(),
        orientation: import__54.Quaternion.IDENTITY
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without orientation", function() {
    expect(function() {
      return new import__54.FrustumGeometry({
        frustum: new import__54.PerspectiveFrustum(),
        origin: import__54.Cartesian3.ZERO
      });
    }).toThrowDeveloperError();
  });
  it("constructor computes all vertex attributes", function() {
    const frustum = new import__54.PerspectiveFrustum();
    frustum.fov = import__54.Math.toRadians(30);
    frustum.aspectRatio = 1920 / 1080;
    frustum.near = 1;
    frustum.far = 3;
    const m = import__54.FrustumGeometry.createGeometry(
      new import__54.FrustumGeometry({
        frustum,
        origin: import__54.Cartesian3.ZERO,
        orientation: import__54.Quaternion.IDENTITY,
        vertexFormat: import__54.VertexFormat.ALL
      })
    );
    const numVertices = 24;
    const numTriangles = 12;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.attributes.normal.values.length).toEqual(numVertices * 3);
    expect(m.attributes.tangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.bitangent.values.length).toEqual(numVertices * 3);
    expect(m.attributes.st.values.length).toEqual(numVertices * 2);
    expect(m.indices.length).toEqual(numTriangles * 3);
    expect(m.boundingSphere.center).toEqual(new import__54.Cartesian3(0, 0, 2));
    expect(m.boundingSphere.radius).toBeGreaterThan(1);
    expect(m.boundingSphere.radius).toBeLessThan(2);
  });
  const packableFrustum = new import__54.PerspectiveFrustum();
  packableFrustum.fov = 1;
  packableFrustum.aspectRatio = 2;
  packableFrustum.near = 3;
  packableFrustum.far = 4;
  createPackableSpecs_default(
    import__54.FrustumGeometry,
    new import__54.FrustumGeometry({
      frustum: packableFrustum,
      origin: import__54.Cartesian3.ZERO,
      orientation: import__54.Quaternion.IDENTITY,
      vertexFormat: import__54.VertexFormat.POSITION_ONLY
    }),
    [
      0,
      1,
      2,
      3,
      4,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      1
    ]
  );
});

// packages/engine/Specs/Core/FrustumOutlineGeometrySpec.js
var import__55 = __toESM(require_Cesium(), 1);
describe("Core/FrustumOutlineGeometry", function() {
  it("constructor throws without options", function() {
    expect(function() {
      return new import__55.FrustumOutlineGeometry();
    }).toThrowDeveloperError();
  });
  it("constructor throws without frustum", function() {
    expect(function() {
      return new import__55.FrustumOutlineGeometry({
        origin: import__55.Cartesian3.ZERO,
        orientation: import__55.Quaternion.IDENTITY
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without position", function() {
    expect(function() {
      return new import__55.FrustumOutlineGeometry({
        frustum: new import__55.PerspectiveFrustum(),
        orientation: import__55.Quaternion.IDENTITY
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without orientation", function() {
    expect(function() {
      return new import__55.FrustumOutlineGeometry({
        frustum: new import__55.PerspectiveFrustum(),
        origin: import__55.Cartesian3.ZERO
      });
    }).toThrowDeveloperError();
  });
  it("constructor computes all vertex attributes", function() {
    const frustum = new import__55.PerspectiveFrustum();
    frustum.fov = import__55.Math.toRadians(30);
    frustum.aspectRatio = 1920 / 1080;
    frustum.near = 1;
    frustum.far = 3;
    const m = import__55.FrustumOutlineGeometry.createGeometry(
      new import__55.FrustumOutlineGeometry({
        frustum,
        origin: import__55.Cartesian3.ZERO,
        orientation: import__55.Quaternion.IDENTITY
      })
    );
    const numVertices = 8;
    const numLines = 12;
    expect(m.attributes.position.values.length).toEqual(numVertices * 3);
    expect(m.indices.length).toEqual(numLines * 2);
    expect(m.boundingSphere.center).toEqual(new import__55.Cartesian3(0, 0, 2));
    expect(m.boundingSphere.radius).toBeGreaterThan(1);
    expect(m.boundingSphere.radius).toBeLessThan(2);
  });
  const packableFrustum = new import__55.PerspectiveFrustum();
  packableFrustum.fov = 1;
  packableFrustum.aspectRatio = 2;
  packableFrustum.near = 3;
  packableFrustum.far = 4;
  createPackableSpecs_default(
    import__55.FrustumOutlineGeometry,
    new import__55.FrustumOutlineGeometry({
      frustum: packableFrustum,
      origin: import__55.Cartesian3.ZERO,
      orientation: import__55.Quaternion.IDENTITY,
      vertexFormat: import__55.VertexFormat.POSITION_ONLY
    }),
    [0, 1, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1]
  );
});

// packages/engine/Specs/Core/FullscreenSpec.js
var import__56 = __toESM(require_Cesium(), 1);
describe("Core/Fullscreen", function() {
  it("can tell if fullscreen is supported", function() {
    expect(import__56.Fullscreen.supportsFullscreen()).toBeDefined();
  });
  it("can tell if fullscreen is enabled", function() {
    if (import__56.Fullscreen.supportsFullscreen()) {
      expect(import__56.Fullscreen.enabled).toBeDefined();
    } else {
      expect(import__56.Fullscreen.enabled).toBeUndefined();
    }
  });
  it("can get fullscreen element", function() {
    if (import__56.Fullscreen.supportsFullscreen()) {
      expect(import__56.Fullscreen.element).toBeNull();
    } else {
      expect(import__56.Fullscreen.element).toBeUndefined();
    }
  });
  it("can tell if the browser is in fullscreen", function() {
    if (import__56.Fullscreen.supportsFullscreen()) {
      expect(import__56.Fullscreen.fullscreen).toEqual(false);
    } else {
      expect(import__56.Fullscreen.fullscreen).toBeUndefined();
    }
  });
  it("can request fullscreen", function() {
    if (import__56.Fullscreen.supportsFullscreen()) {
      spyOn(document.body, import__56.Fullscreen._names.requestFullscreen);
      spyOn(document, import__56.Fullscreen._names.exitFullscreen);
      import__56.Fullscreen.requestFullscreen(document.body);
      expect(
        document.body[import__56.Fullscreen._names.requestFullscreen]
      ).toHaveBeenCalled();
      import__56.Fullscreen.exitFullscreen();
      expect(document[import__56.Fullscreen._names.exitFullscreen]).toHaveBeenCalled();
    } else {
      import__56.Fullscreen.requestFullscreen(document.body);
      import__56.Fullscreen.exitFullscreen();
    }
  });
  if (!import__56.FeatureDetection.isInternetExplorer()) {
    it("can get the fullscreen change event name", function() {
      if (import__56.Fullscreen.supportsFullscreen()) {
        expect(document[`on${import__56.Fullscreen.changeEventName}`]).toBeDefined();
      } else {
        expect(import__56.Fullscreen.changeEventName).toBeUndefined();
      }
    });
    it("can get the fullscreen error event name", function() {
      if (import__56.Fullscreen.supportsFullscreen()) {
        expect(document[`on${import__56.Fullscreen.errorEventName}`]).toBeDefined();
      } else {
        expect(import__56.Fullscreen.errorEventName).toBeUndefined();
      }
    });
  }
});

// packages/engine/Specs/Core/GeographicProjectionSpec.js
var import__57 = __toESM(require_Cesium(), 1);
describe("Core/GeographicProjection", function() {
  it("construct0", function() {
    const projection = new import__57.GeographicProjection();
    expect(projection.ellipsoid).toEqual(import__57.Ellipsoid.WGS84);
  });
  it("construct1", function() {
    const ellipsoid = import__57.Ellipsoid.UNIT_SPHERE;
    const projection = new import__57.GeographicProjection(ellipsoid);
    expect(projection.ellipsoid).toEqual(ellipsoid);
  });
  it("project0", function() {
    const height = 10;
    const cartographic = new import__57.Cartographic(0, 0, height);
    const projection = new import__57.GeographicProjection();
    expect(projection.project(cartographic)).toEqual(
      new import__57.Cartesian3(0, 0, height)
    );
  });
  it("project1", function() {
    const ellipsoid = import__57.Ellipsoid.WGS84;
    const cartographic = new import__57.Cartographic(Math.PI, import__57.Math.PI_OVER_TWO, 0);
    const expected = new import__57.Cartesian3(
      Math.PI * ellipsoid.radii.x,
      import__57.Math.PI_OVER_TWO * ellipsoid.radii.x,
      0
    );
    const projection = new import__57.GeographicProjection(ellipsoid);
    expect(projection.project(cartographic)).toEqual(expected);
  });
  it("project2", function() {
    const ellipsoid = import__57.Ellipsoid.UNIT_SPHERE;
    const cartographic = new import__57.Cartographic(
      -Math.PI,
      import__57.Math.PI_OVER_TWO,
      0
    );
    const expected = new import__57.Cartesian3(-Math.PI, import__57.Math.PI_OVER_TWO, 0);
    const projection = new import__57.GeographicProjection(ellipsoid);
    expect(projection.project(cartographic)).toEqual(expected);
  });
  it("project3", function() {
    const ellipsoid = import__57.Ellipsoid.WGS84;
    const cartographic = new import__57.Cartographic(Math.PI, import__57.Math.PI_OVER_TWO, 0);
    const expected = new import__57.Cartesian3(
      Math.PI * ellipsoid.radii.x,
      import__57.Math.PI_OVER_TWO * ellipsoid.radii.x,
      0
    );
    const projection = new import__57.GeographicProjection(ellipsoid);
    const result = new import__57.Cartesian3(0, 0, 0);
    const returnValue = projection.project(cartographic, result);
    expect(result).toEqual(returnValue);
    expect(result).toEqual(expected);
  });
  it("unproject0", function() {
    const cartographic = new import__57.Cartographic(
      import__57.Math.PI_OVER_TWO,
      import__57.Math.PI_OVER_FOUR,
      12
    );
    const projection = new import__57.GeographicProjection();
    const projected = projection.project(cartographic);
    expect(projection.unproject(projected)).toEqual(cartographic);
  });
  it("unproject1", function() {
    const cartographic = new import__57.Cartographic(
      import__57.Math.PI_OVER_TWO,
      import__57.Math.PI_OVER_FOUR,
      12
    );
    const projection = new import__57.GeographicProjection();
    const projected = projection.project(cartographic);
    const result = new import__57.Cartographic(0, 0, 0);
    const returnValue = projection.unproject(projected, result);
    expect(result).toEqual(returnValue);
    expect(result).toEqual(cartographic);
  });
  it("project throws without cartesian", function() {
    const projection = new import__57.GeographicProjection();
    expect(function() {
      return projection.unproject();
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/GeographicTilingSchemeSpec.js
var import__58 = __toESM(require_Cesium(), 1);
describe("Core/GeographicTilingScheme", function() {
  it("conforms to TilingScheme interface.", function() {
    expect(import__58.GeographicTilingScheme).toConformToInterface(import__58.TilingScheme);
  });
  describe("Conversions from tile indices to cartographic rectangles.", function() {
    it("tileXYToRectangle returns full rectangle for single root tile.", function() {
      const tilingScheme = new import__58.GeographicTilingScheme({
        numberOfLevelZeroTilesX: 1,
        numberOfLevelZeroTilesY: 1
      });
      const tilingSchemeRectangle = tilingScheme.rectangle;
      const rectangle = tilingScheme.tileXYToRectangle(0, 0, 0);
      expect(rectangle.west).toEqualEpsilon(
        tilingSchemeRectangle.west,
        import__58.Math.EPSILON10
      );
      expect(rectangle.south).toEqualEpsilon(
        tilingSchemeRectangle.south,
        import__58.Math.EPSILON10
      );
      expect(rectangle.east).toEqualEpsilon(
        tilingSchemeRectangle.east,
        import__58.Math.EPSILON10
      );
      expect(rectangle.north).toEqualEpsilon(
        tilingSchemeRectangle.north,
        import__58.Math.EPSILON10
      );
    });
    it("tileXYToRectangle uses result parameter if provided", function() {
      const tilingScheme = new import__58.GeographicTilingScheme({
        numberOfLevelZeroTilesX: 1,
        numberOfLevelZeroTilesY: 1
      });
      const tilingSchemeRectangle = tilingScheme.rectangle;
      const result = new import__58.Rectangle(0, 0, 0);
      const rectangle = tilingScheme.tileXYToRectangle(0, 0, 0, result);
      expect(result).toEqual(rectangle);
      expect(rectangle.west).toEqualEpsilon(
        tilingSchemeRectangle.west,
        import__58.Math.EPSILON10
      );
      expect(rectangle.south).toEqualEpsilon(
        tilingSchemeRectangle.south,
        import__58.Math.EPSILON10
      );
      expect(rectangle.east).toEqualEpsilon(
        tilingSchemeRectangle.east,
        import__58.Math.EPSILON10
      );
      expect(rectangle.north).toEqualEpsilon(
        tilingSchemeRectangle.north,
        import__58.Math.EPSILON10
      );
    });
    it("tiles are numbered from the northwest corner.", function() {
      const tilingScheme = new import__58.GeographicTilingScheme({
        numberOfLevelZeroTilesX: 2,
        numberOfLevelZeroTilesY: 2
      });
      const northwest = tilingScheme.tileXYToRectangle(0, 0, 1);
      const northeast = tilingScheme.tileXYToRectangle(1, 0, 1);
      const southeast = tilingScheme.tileXYToRectangle(1, 1, 1);
      const southwest = tilingScheme.tileXYToRectangle(0, 1, 1);
      expect(northeast.north).toEqual(northwest.north);
      expect(northeast.south).toEqual(northwest.south);
      expect(southeast.north).toEqual(southwest.north);
      expect(southeast.south).toEqual(southwest.south);
      expect(northwest.west).toEqual(southwest.west);
      expect(northwest.east).toEqual(southwest.east);
      expect(northeast.west).toEqual(southeast.west);
      expect(northeast.east).toEqual(southeast.east);
      expect(northeast.north).toBeGreaterThan(southeast.north);
      expect(northeast.south).toBeGreaterThan(southeast.south);
      expect(northwest.north).toBeGreaterThan(southwest.north);
      expect(northwest.south).toBeGreaterThan(southwest.south);
      expect(northeast.east).toBeGreaterThan(northwest.east);
      expect(northeast.west).toBeGreaterThan(northwest.west);
      expect(southeast.east).toBeGreaterThan(southwest.east);
      expect(southeast.west).toBeGreaterThan(southwest.west);
    });
    it("adjacent tiles have overlapping coordinates", function() {
      const tilingScheme = new import__58.GeographicTilingScheme({
        numberOfLevelZeroTilesX: 2,
        numberOfLevelZeroTilesY: 2
      });
      const northwest = tilingScheme.tileXYToRectangle(0, 0, 1);
      const northeast = tilingScheme.tileXYToRectangle(1, 0, 1);
      const southeast = tilingScheme.tileXYToRectangle(1, 1, 1);
      const southwest = tilingScheme.tileXYToRectangle(0, 1, 1);
      expect(northeast.south).toEqualEpsilon(
        southeast.north,
        import__58.Math.EPSILON15
      );
      expect(northwest.south).toEqualEpsilon(
        southwest.north,
        import__58.Math.EPSILON15
      );
      expect(northeast.west).toEqualEpsilon(
        northwest.east,
        import__58.Math.EPSILON15
      );
      expect(southeast.west).toEqualEpsilon(
        southwest.east,
        import__58.Math.EPSILON15
      );
    });
  });
  it("uses a GeographicProjection", function() {
    const tilingScheme = new import__58.GeographicTilingScheme();
    expect(tilingScheme.projection).toBeInstanceOf(import__58.GeographicProjection);
  });
  describe("rectangleToNativeRectangle", function() {
    it("converts radians to degrees", function() {
      const tilingScheme = new import__58.GeographicTilingScheme();
      const rectangleInRadians = new import__58.Rectangle(0.1, 0.2, 0.3, 0.4);
      const nativeRectangle = tilingScheme.rectangleToNativeRectangle(
        rectangleInRadians
      );
      expect(nativeRectangle.west).toEqualEpsilon(
        rectangleInRadians.west * 180 / Math.PI,
        import__58.Math.EPSILON13
      );
      expect(nativeRectangle.south).toEqualEpsilon(
        rectangleInRadians.south * 180 / Math.PI,
        import__58.Math.EPSILON13
      );
      expect(nativeRectangle.east).toEqualEpsilon(
        rectangleInRadians.east * 180 / Math.PI,
        import__58.Math.EPSILON13
      );
      expect(nativeRectangle.north).toEqualEpsilon(
        rectangleInRadians.north * 180 / Math.PI,
        import__58.Math.EPSILON13
      );
    });
    it("uses result parameter if provided", function() {
      const tilingScheme = new import__58.GeographicTilingScheme();
      const rectangleInRadians = new import__58.Rectangle(0.1, 0.2, 0.3, 0.4);
      const resultRectangle = new import__58.Rectangle(0, 0, 0, 0);
      const outputRectangle = tilingScheme.rectangleToNativeRectangle(
        rectangleInRadians,
        resultRectangle
      );
      expect(outputRectangle).toEqual(resultRectangle);
      expect(resultRectangle.west).toEqualEpsilon(
        rectangleInRadians.west * 180 / Math.PI,
        import__58.Math.EPSILON13
      );
      expect(resultRectangle.south).toEqualEpsilon(
        rectangleInRadians.south * 180 / Math.PI,
        import__58.Math.EPSILON13
      );
      expect(resultRectangle.east).toEqualEpsilon(
        rectangleInRadians.east * 180 / Math.PI,
        import__58.Math.EPSILON13
      );
      expect(resultRectangle.north).toEqualEpsilon(
        rectangleInRadians.north * 180 / Math.PI,
        import__58.Math.EPSILON13
      );
    });
  });
  describe("positionToTileXY", function() {
    it("returns undefined when outside rectangle", function() {
      const tilingScheme = new import__58.GeographicTilingScheme({
        rectangle: new import__58.Rectangle(0.1, 0.2, 0.3, 0.4)
      });
      const tooFarWest = new import__58.Cartographic(0.05, 0.3);
      expect(tilingScheme.positionToTileXY(tooFarWest, 0)).toBeUndefined();
      const tooFarSouth = new import__58.Cartographic(0.2, 0.1);
      expect(tilingScheme.positionToTileXY(tooFarSouth, 0)).toBeUndefined();
      const tooFarEast = new import__58.Cartographic(0.4, 0.3);
      expect(tilingScheme.positionToTileXY(tooFarEast, 0)).toBeUndefined();
      const tooFarNorth = new import__58.Cartographic(0.2, 0.5);
      expect(tilingScheme.positionToTileXY(tooFarNorth, 0)).toBeUndefined();
    });
    it("returns correct tile for position in center of tile", function() {
      const tilingScheme = new import__58.GeographicTilingScheme();
      const centerOfWesternRootTile = new import__58.Cartographic(-Math.PI / 2, 0);
      expect(tilingScheme.positionToTileXY(centerOfWesternRootTile, 0)).toEqual(
        new import__58.Cartesian2(0, 0)
      );
      const centerOfNortheastChildOfEasternRootTile = new import__58.Cartographic(
        3 * Math.PI / 4,
        Math.PI / 2
      );
      expect(
        tilingScheme.positionToTileXY(
          centerOfNortheastChildOfEasternRootTile,
          1
        )
      ).toEqual(new import__58.Cartesian2(3, 0));
    });
    it("returns Southeast tile when on the boundary between tiles", function() {
      const tilingScheme = new import__58.GeographicTilingScheme();
      const centerOfMap = new import__58.Cartographic(0, 0);
      expect(tilingScheme.positionToTileXY(centerOfMap, 1)).toEqual(
        new import__58.Cartesian2(2, 1)
      );
    });
    it("does not return tile outside valid range", function() {
      const tilingScheme = new import__58.GeographicTilingScheme();
      const southeastCorner = new import__58.Cartographic(Math.PI, -Math.PI / 2);
      expect(tilingScheme.positionToTileXY(southeastCorner, 0)).toEqual(
        new import__58.Cartesian2(1, 0)
      );
    });
    it("uses result parameter if supplied", function() {
      const tilingScheme = new import__58.GeographicTilingScheme();
      const centerOfNortheastChildOfEasternRootTile = new import__58.Cartographic(
        3 * Math.PI / 4,
        Math.PI / 2
      );
      const resultParameter = new import__58.Cartesian2(0, 0);
      const returnedResult = tilingScheme.positionToTileXY(
        centerOfNortheastChildOfEasternRootTile,
        1,
        resultParameter
      );
      expect(resultParameter).toEqual(returnedResult);
      expect(resultParameter).toEqual(new import__58.Cartesian2(3, 0));
    });
  });
});

// packages/engine/Specs/Core/GeometryAttributeSpec.js
var import__59 = __toESM(require_Cesium(), 1);
describe("Core/GeometryAttribute", function() {
  it("constructor", function() {
    const color = new import__59.GeometryAttribute({
      componentDatatype: import__59.ComponentDatatype.UNSIGNED_BYTE,
      componentsPerAttribute: 4,
      normalize: true,
      values: new Uint8Array([255, 0, 0, 255, 0, 255, 0, 255, 0, 0, 255, 255])
    });
    expect(color.componentDatatype).toEqual(import__59.ComponentDatatype.UNSIGNED_BYTE);
    expect(color.componentsPerAttribute).toEqual(4);
    expect(color.normalize).toEqual(true);
    expect(color.values).toEqual([
      255,
      0,
      0,
      255,
      0,
      255,
      0,
      255,
      0,
      0,
      255,
      255
    ]);
  });
  it("constructor throws without componentDatatype", function() {
    expect(function() {
      return new import__59.GeometryAttribute({
        componentsPerAttribute: 4,
        values: new Uint8Array([
          255,
          0,
          0,
          255,
          0,
          255,
          0,
          255,
          0,
          0,
          255,
          255
        ])
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without componentsPerAttribute", function() {
    expect(function() {
      return new import__59.GeometryAttribute({
        componentDatatype: import__59.ComponentDatatype.UNSIGNED_BYTE,
        values: new Uint8Array([
          255,
          0,
          0,
          255,
          0,
          255,
          0,
          255,
          0,
          0,
          255,
          255
        ])
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws when componentsPerAttribute is less than 1 or greater than 4", function() {
    expect(function() {
      return new import__59.GeometryAttribute({
        componentDatatype: import__59.ComponentDatatype.UNSIGNED_BYTE,
        componentsPerAttribute: 7,
        values: new Uint8Array([
          255,
          0,
          0,
          255,
          0,
          255,
          0,
          255,
          0,
          0,
          255,
          255
        ])
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without values", function() {
    expect(function() {
      return new import__59.GeometryAttribute({
        componentDatatype: import__59.ComponentDatatype.UNSIGNED_BYTE,
        componentsPerAttribute: 4
      });
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/GeometryInstanceAttributeSpec.js
var import__60 = __toESM(require_Cesium(), 1);
describe("Core/GeometryInstanceAttribute", function() {
  it("constructor", function() {
    const color = new import__60.GeometryInstanceAttribute({
      componentDatatype: import__60.ComponentDatatype.UNSIGNED_BYTE,
      componentsPerAttribute: 4,
      normalize: true,
      value: new Uint8Array([255, 255, 0, 255])
    });
    expect(color.componentDatatype).toEqual(import__60.ComponentDatatype.UNSIGNED_BYTE);
    expect(color.componentsPerAttribute).toEqual(4);
    expect(color.normalize).toEqual(true);
    expect(color.value).toEqual([255, 255, 0, 255]);
  });
  it("constructor throws without componentDatatype", function() {
    expect(function() {
      return new import__60.GeometryInstanceAttribute({
        componentsPerAttribute: 4,
        value: new Uint8Array([255, 255, 0, 255])
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without componentsPerAttribute", function() {
    expect(function() {
      return new import__60.GeometryInstanceAttribute({
        componentDatatype: import__60.ComponentDatatype.UNSIGNED_BYTE,
        value: new Uint8Array([255, 255, 0, 255])
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws when componentsPerAttribute is less than 1 or greater than 4", function() {
    expect(function() {
      return new import__60.GeometryInstanceAttribute({
        componentDatatype: import__60.ComponentDatatype.UNSIGNED_BYTE,
        componentsPerAttribute: 7,
        value: new Uint8Array([255, 255, 0, 255])
      });
    }).toThrowDeveloperError();
  });
  it("constructor throws without values", function() {
    expect(function() {
      return new import__60.GeometryInstanceAttribute({
        componentDatatype: import__60.ComponentDatatype.UNSIGNED_BYTE,
        componentsPerAttribute: 4
      });
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/GeometryInstanceSpec.js
var import__61 = __toESM(require_Cesium(), 1);
describe("Core/GeometryInstance", function() {
  it("constructor", function() {
    const geometry = new import__61.Geometry({
      attributes: {
        position: new import__61.GeometryAttribute({
          componentDatatype: import__61.ComponentDatatype.DOUBLE,
          componentsPerAttribute: 3,
          values: new Float64Array([
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            1,
            0
          ])
        })
      },
      indices: new Uint16Array([0, 1, 2]),
      primitiveType: import__61.PrimitiveType.TRIANGLES,
      boundingSphere: new import__61.BoundingSphere(new import__61.Cartesian3(0.5, 0.5, 0), 1)
    });
    const modelMatrix = import__61.Matrix4.multiplyByTranslation(
      import__61.Matrix4.IDENTITY,
      new import__61.Cartesian3(0, 0, 9e6),
      new import__61.Matrix4()
    );
    const attributes = {
      color: new import__61.GeometryInstanceAttribute({
        componentDatatype: import__61.ComponentDatatype.UNSIGNED_BYTE,
        componentsPerAttribute: 4,
        normalize: true,
        value: new Uint8Array([255, 255, 0, 255])
      })
    };
    const instance = new import__61.GeometryInstance({
      geometry,
      modelMatrix,
      id: "geometry",
      attributes
    });
    expect(instance.geometry).toBe(geometry);
    expect(instance.modelMatrix).toEqual(modelMatrix);
    expect(instance.id).toEqual("geometry");
    expect(attributes).toBe(attributes);
  });
  it("constructor throws without geometry", function() {
    expect(function() {
      return new import__61.GeometryInstance();
    }).toThrowDeveloperError();
  });
});

// packages/engine/Specs/Core/GeometryPipelineSpec.js
var import__62 = __toESM(require_Cesium(), 1);
describe("Core/GeometryPipeline", function() {
  it("converts triangles to wireframe in place", function() {
    const geometry = import__62.GeometryPipeline.toWireframe(
      new import__62.Geometry({
        attributes: {},
        indices: [0, 1, 2, 3, 4, 5],
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    );
    expect(geometry.primitiveType).toEqual(import__62.PrimitiveType.LINES);
    const v = geometry.indices;
    expect(v.length).toEqual(12);
    expect(v[0]).toEqual(0);
    expect(v[1]).toEqual(1);
    expect(v[2]).toEqual(1);
    expect(v[3]).toEqual(2);
    expect(v[4]).toEqual(2);
    expect(v[5]).toEqual(0);
    expect(v[6]).toEqual(3);
    expect(v[7]).toEqual(4);
    expect(v[8]).toEqual(4);
    expect(v[9]).toEqual(5);
    expect(v[10]).toEqual(5);
    expect(v[11]).toEqual(3);
  });
  it("converts a triangle fan to wireframe in place", function() {
    const geometry = import__62.GeometryPipeline.toWireframe(
      new import__62.Geometry({
        attributes: {},
        indices: [0, 1, 2, 3],
        primitiveType: import__62.PrimitiveType.TRIANGLE_FAN
      })
    );
    expect(geometry.primitiveType).toEqual(import__62.PrimitiveType.LINES);
    const v = geometry.indices;
    expect(v.length).toEqual(12);
    expect(v[0]).toEqual(0);
    expect(v[1]).toEqual(1);
    expect(v[2]).toEqual(1);
    expect(v[3]).toEqual(2);
    expect(v[4]).toEqual(2);
    expect(v[5]).toEqual(0);
    expect(v[6]).toEqual(0);
    expect(v[7]).toEqual(2);
    expect(v[8]).toEqual(2);
    expect(v[9]).toEqual(3);
    expect(v[10]).toEqual(3);
    expect(v[11]).toEqual(0);
  });
  it("converts a triangle strip to wireframe in place", function() {
    const geometry = import__62.GeometryPipeline.toWireframe(
      new import__62.Geometry({
        attributes: {},
        indices: [0, 1, 2, 3],
        primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
      })
    );
    expect(geometry.primitiveType).toEqual(import__62.PrimitiveType.LINES);
    const v = geometry.indices;
    expect(v.length).toEqual(12);
    expect(v[0]).toEqual(0);
    expect(v[1]).toEqual(1);
    expect(v[2]).toEqual(1);
    expect(v[3]).toEqual(2);
    expect(v[4]).toEqual(2);
    expect(v[5]).toEqual(0);
    expect(v[6]).toEqual(2);
    expect(v[7]).toEqual(3);
    expect(v[8]).toEqual(3);
    expect(v[9]).toEqual(1);
    expect(v[10]).toEqual(1);
    expect(v[11]).toEqual(2);
  });
  it("toWireframe throws without a geometry", function() {
    expect(function() {
      import__62.GeometryPipeline.toWireframe(void 0);
    }).toThrowDeveloperError();
  });
  it("toWireframe throws when primitiveType is not a triangle type", function() {
    expect(function() {
      import__62.GeometryPipeline.toWireframe(
        new import__62.Geometry({
          attributes: {},
          indices: [],
          primitiveType: import__62.PrimitiveType.POINTS
        })
      );
    }).toThrowDeveloperError();
  });
  it("createLineSegmentsForVectors", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0]
        }),
        normal: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: [0, 0, 1, 0, 0, 1, 0, 0, 1]
        })
      },
      primitiveType: import__62.PrimitiveType.TRIANGLES,
      boundingSphere: new import__62.BoundingSphere(new import__62.Cartesian3(0.5, 0.5, 0), 1)
    });
    const lines = import__62.GeometryPipeline.createLineSegmentsForVectors(
      geometry,
      "normal",
      1
    );
    const linePositions = [
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1
    ];
    expect(lines.attributes).toBeDefined();
    expect(lines.attributes.position).toBeDefined();
    expect(lines.attributes.position.values).toEqual(linePositions);
    expect(lines.primitiveType).toEqual(import__62.PrimitiveType.LINES);
    expect(lines.boundingSphere.center).toEqual(geometry.boundingSphere.center);
    expect(lines.boundingSphere.radius).toEqual(
      geometry.boundingSphere.radius + 1
    );
  });
  it("createLineSegmentsForVectors throws without geometry", function() {
    expect(function() {
      import__62.GeometryPipeline.createLineSegmentsForVectors();
    }).toThrowDeveloperError();
  });
  it("createLineSegmentsForVectors throws without geometry.attributes.position", function() {
    expect(function() {
      import__62.GeometryPipeline.createLineSegmentsForVectors();
    }).toThrowDeveloperError();
  });
  it("createLineSegmentsForVectors throws when geometry.attributes does not have an attributeName property", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: [0, 1, 2, 3, 4, 5]
        })
      },
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    expect(function() {
      import__62.GeometryPipeline.createLineSegmentsForVectors(geometry, "bitangent");
    }).toThrowDeveloperError();
  });
  it("creates attribute indices", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: []
        }),
        normal: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: []
        }),
        color: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.UNSIGNED_BYTE,
          componentsPerAttribute: 4,
          values: []
        })
      },
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    const indices = import__62.GeometryPipeline.createAttributeLocations(geometry);
    const validIndices = [0, 1, 2];
    expect(validIndices).toContain(indices.position);
    expect(validIndices).toContain(indices.normal);
    expect(validIndices).toContain(indices.color);
    expect(indices.position).not.toEqual(indices.normal);
    expect(indices.position).not.toEqual(indices.color);
  });
  it("createAttributeLocations throws without a geometry", function() {
    expect(function() {
      import__62.GeometryPipeline.createAttributeLocations(void 0);
    }).toThrowDeveloperError();
  });
  it("reorderForPreVertexCache reorders all indices and attributes for the pre vertex cache", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        weight: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 1,
          values: [0, 1, 2, 3, 4, 5]
        }),
        positions: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: [
            0,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            9,
            10,
            11,
            12,
            13,
            14,
            15,
            16,
            17
          ]
        })
      },
      indices: [5, 3, 2, 0, 1, 4, 4, 1, 3, 2, 5, 0],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    import__62.GeometryPipeline.reorderForPreVertexCache(geometry);
    expect(geometry.indices[0]).toEqual(0);
    expect(geometry.indices[1]).toEqual(1);
    expect(geometry.indices[2]).toEqual(2);
    expect(geometry.indices[3]).toEqual(3);
    expect(geometry.indices[4]).toEqual(4);
    expect(geometry.indices[5]).toEqual(5);
    expect(geometry.indices[6]).toEqual(5);
    expect(geometry.indices[7]).toEqual(4);
    expect(geometry.indices[8]).toEqual(1);
    expect(geometry.indices[9]).toEqual(2);
    expect(geometry.indices[10]).toEqual(0);
    expect(geometry.indices[11]).toEqual(3);
    expect(geometry.attributes.weight.values[0]).toEqual(5);
    expect(geometry.attributes.weight.values[1]).toEqual(3);
    expect(geometry.attributes.weight.values[2]).toEqual(2);
    expect(geometry.attributes.weight.values[3]).toEqual(0);
    expect(geometry.attributes.weight.values[4]).toEqual(1);
    expect(geometry.attributes.weight.values[5]).toEqual(4);
    expect(geometry.attributes.positions.values[0]).toEqual(15);
    expect(geometry.attributes.positions.values[1]).toEqual(16);
    expect(geometry.attributes.positions.values[2]).toEqual(17);
    expect(geometry.attributes.positions.values[3]).toEqual(9);
    expect(geometry.attributes.positions.values[4]).toEqual(10);
    expect(geometry.attributes.positions.values[5]).toEqual(11);
    expect(geometry.attributes.positions.values[6]).toEqual(6);
    expect(geometry.attributes.positions.values[7]).toEqual(7);
    expect(geometry.attributes.positions.values[8]).toEqual(8);
    expect(geometry.attributes.positions.values[9]).toEqual(0);
    expect(geometry.attributes.positions.values[10]).toEqual(1);
    expect(geometry.attributes.positions.values[11]).toEqual(2);
    expect(geometry.attributes.positions.values[12]).toEqual(3);
    expect(geometry.attributes.positions.values[13]).toEqual(4);
    expect(geometry.attributes.positions.values[14]).toEqual(5);
    expect(geometry.attributes.positions.values[15]).toEqual(12);
    expect(geometry.attributes.positions.values[16]).toEqual(13);
    expect(geometry.attributes.positions.values[17]).toEqual(14);
  });
  it("reoderForPreVertexCache removes unused vertices", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        weight: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 1,
          values: [0, 1, 2, 3, 4, 5]
        }),
        positions: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: [
            0,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            9,
            10,
            11,
            12,
            13,
            14,
            15,
            16,
            17
          ]
        })
      },
      indices: [5, 3, 2, 4, 1, 3],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    import__62.GeometryPipeline.reorderForPreVertexCache(geometry);
    expect(geometry.indices.length).toEqual(6);
    expect(geometry.attributes.positions.values.length).toEqual((6 - 1) * 3);
    expect(geometry.attributes.weight.values.length).toEqual(6 - 1);
  });
  it("reorderForPreVertexCache throws without a geometry", function() {
    expect(function() {
      import__62.GeometryPipeline.reorderForPreVertexCache(void 0);
    }).toThrowDeveloperError();
  });
  it("reorderForPreVertexCache throws when attributes have a different number of attributes", function() {
    expect(function() {
      const geometry = new import__62.Geometry({
        attributes: {
          attribute1: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 1,
            values: [0, 1, 2]
          }),
          attribute2: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 1, 2, 3, 4, 5]
          })
        }
      });
      import__62.GeometryPipeline.reorderForPreVertexCache(geometry);
    }).toThrowDeveloperError();
  });
  it("reorderForPostVertexCache reorders indices for the post vertex cache", function() {
    let geometry = import__62.EllipsoidGeometry.createGeometry(new import__62.EllipsoidGeometry());
    const acmrBefore = import__62.Tipsify.calculateACMR({
      indices: geometry.indices,
      cacheSize: 24
    });
    expect(acmrBefore).toBeGreaterThan(1);
    geometry = import__62.GeometryPipeline.reorderForPostVertexCache(geometry);
    const acmrAfter = import__62.Tipsify.calculateACMR({
      indices: geometry.indices,
      cacheSize: 24
    });
    expect(acmrAfter).toBeLessThan(0.7);
  });
  it("reorderForPostVertexCache throws without a geometry", function() {
    expect(function() {
      import__62.GeometryPipeline.reorderForPostVertexCache(void 0);
    }).toThrowDeveloperError();
  });
  it("fitToUnsignedShortIndicestoThrowDeveloperErrorot change geometry", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        time: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 1,
          values: [10]
        }),
        heat: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 1,
          values: [1]
        })
      },
      indices: [0, 0, 0],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    const geometries = import__62.GeometryPipeline.fitToUnsignedShortIndices(geometry);
    expect(geometries.length).toEqual(1);
    expect(geometries[0]).toBe(geometry);
  });
  it("fitToUnsignedShortIndices creates one geometry", function() {
    const sixtyFourK = import__62.Math.SIXTY_FOUR_KILOBYTES;
    const times = [];
    for (let i = 0; i < sixtyFourK + 1; ++i) {
      times.push(i);
    }
    const geometry = new import__62.Geometry({
      attributes: {
        time: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 1,
          values: times
        })
      },
      indices: [0, 0, 0, sixtyFourK, sixtyFourK, sixtyFourK, 0, sixtyFourK, 0],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    const geometries = import__62.GeometryPipeline.fitToUnsignedShortIndices(geometry);
    expect(geometries.length).toEqual(1);
    expect(geometries[0].attributes.time.componentDatatype).toEqual(
      import__62.ComponentDatatype.FLOAT
    );
    expect(geometries[0].attributes.time.componentsPerAttribute).toEqual(1);
    expect(geometries[0].attributes.time.values).toEqual([0, sixtyFourK]);
    expect(geometries[0].primitiveType).toEqual(import__62.PrimitiveType.TRIANGLES);
    expect(geometries[0].indices).toEqual([0, 0, 0, 1, 1, 1, 0, 1, 0]);
  });
  it("fitToUnsignedShortIndices creates two triangle geometries", function() {
    const sixtyFourK = import__62.Math.SIXTY_FOUR_KILOBYTES;
    const positions = [];
    for (let i = 0; i < sixtyFourK + 1; ++i) {
      positions.push(i, i, i);
    }
    const indices = [];
    for (let j = sixtyFourK; j > 1; j -= 3) {
      indices.push(j, j - 1, j - 2);
    }
    indices.push(0, 1, 2);
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: positions
        })
      },
      indices,
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    const geometries = import__62.GeometryPipeline.fitToUnsignedShortIndices(geometry);
    expect(geometries.length).toEqual(2);
    expect(geometries[0].attributes.position.values.length).toEqual(
      positions.length - 6
    );
    expect(geometries[0].indices.length).toEqual(indices.length - 3);
    expect(geometries[1].attributes.position.values.length).toEqual(9);
    expect(geometries[1].indices.length).toEqual(3);
  });
  it("fitToUnsignedShortIndices creates two line geometries", function() {
    const sixtyFourK = import__62.Math.SIXTY_FOUR_KILOBYTES;
    const positions = [];
    for (let i = 0; i < sixtyFourK + 2; ++i) {
      positions.push(i, i, i);
    }
    const indices = [];
    for (let j = sixtyFourK; j > 1; j -= 2) {
      indices.push(j, j - 1);
    }
    indices.push(0, 1);
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: positions
        })
      },
      indices,
      primitiveType: import__62.PrimitiveType.LINES
    });
    const geometries = import__62.GeometryPipeline.fitToUnsignedShortIndices(geometry);
    expect(geometries.length).toEqual(2);
    expect(geometries[0].attributes.position.values.length).toEqual(
      positions.length - 12
    );
    expect(geometries[0].indices.length).toEqual(indices.length - 4);
    expect(geometries[1].attributes.position.values.length).toEqual(9);
    expect(geometries[1].indices.length).toEqual(4);
  });
  it("fitToUnsignedShortIndices creates two point geometries", function() {
    const sixtyFourK = import__62.Math.SIXTY_FOUR_KILOBYTES;
    const positions = [];
    const indices = [];
    for (let i = 0; i < sixtyFourK + 1; ++i) {
      positions.push(i, i, i);
      indices.push(i);
    }
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 3,
          values: positions
        })
      },
      indices,
      primitiveType: import__62.PrimitiveType.POINTS
    });
    const geometries = import__62.GeometryPipeline.fitToUnsignedShortIndices(geometry);
    expect(geometries.length).toEqual(2);
    expect(geometries[0].attributes.position.values.length).toEqual(
      positions.length - 6
    );
    expect(geometries[0].indices.length).toEqual(indices.length - 2);
    expect(geometries[1].attributes.position.values.length).toEqual(6);
    expect(geometries[1].indices.length).toEqual(2);
  });
  it("fitToUnsignedShortIndices throws without a geometry", function() {
    expect(function() {
      import__62.GeometryPipeline.fitToUnsignedShortIndices(void 0);
    }).toThrowDeveloperError();
  });
  it("fitToUnsignedShortIndices throws without triangles, lines, or points", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        time: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 1,
          values: [10, 11, 12]
        })
      },
      indices: [0, 1, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
    });
    expect(function() {
      return import__62.GeometryPipeline.fitToUnsignedShortIndices(geometry);
    }).toThrowDeveloperError();
  });
  it("fitToUnsignedShortIndices throws with different numbers of attributes", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        time: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 1,
          values: [10]
        }),
        heat: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.FLOAT,
          componentsPerAttribute: 1,
          values: [1, 2]
        })
      },
      indices: [0, 0, 0],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    expect(function() {
      return import__62.GeometryPipeline.fitToUnsignedShortIndices(geometry);
    }).toThrowDeveloperError();
  });
  it("projectTo2D", function() {
    const p1 = new import__62.Cartesian3(1e5, 2e5, 3e5);
    const p2 = new import__62.Cartesian3(4e5, 5e5, 6e5);
    let geometry = {};
    geometry.attributes = {};
    geometry.attributes.position = {
      componentDatatype: import__62.ComponentDatatype.DOUBLE,
      componentsPerAttribute: 3,
      values: [p1.x, p1.y, p1.z, p2.x, p2.y, p2.z]
    };
    geometry = import__62.GeometryPipeline.projectTo2D(
      geometry,
      "position",
      "position3D",
      "position2D"
    );
    const ellipsoid = import__62.Ellipsoid.WGS84;
    const projection = new import__62.GeographicProjection();
    const projectedP1 = projection.project(
      ellipsoid.cartesianToCartographic(p1)
    );
    const projectedP2 = projection.project(
      ellipsoid.cartesianToCartographic(p2)
    );
    expect(geometry.attributes.position2D.values[0]).toEqual(projectedP1.x);
    expect(geometry.attributes.position2D.values[1]).toEqual(projectedP1.y);
    expect(geometry.attributes.position2D.values[2]).toEqual(projectedP1.z);
    expect(geometry.attributes.position2D.values[3]).toEqual(projectedP2.x);
    expect(geometry.attributes.position2D.values[4]).toEqual(projectedP2.y);
    expect(geometry.attributes.position2D.values[5]).toEqual(projectedP2.z);
    expect(geometry.attributes.position3D.values[0]).toEqual(p1.x);
    expect(geometry.attributes.position3D.values[1]).toEqual(p1.y);
    expect(geometry.attributes.position3D.values[2]).toEqual(p1.z);
    expect(geometry.attributes.position3D.values[3]).toEqual(p2.x);
    expect(geometry.attributes.position3D.values[4]).toEqual(p2.y);
    expect(geometry.attributes.position3D.values[5]).toEqual(p2.z);
  });
  it("projectTo2D throws without a geometry", function() {
    expect(function() {
      import__62.GeometryPipeline.projectTo2D(void 0);
    }).toThrowDeveloperError();
  });
  it("projectTo2D throws without attributeName", function() {
    expect(function() {
      import__62.GeometryPipeline.projectTo2D(
        new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: [0, 0, 0]
            })
          },
          primitiveType: import__62.PrimitiveType.POINTS
        })
      );
    }).toThrowDeveloperError();
  });
  it("projectTo2D throws without attributeName3D", function() {
    expect(function() {
      import__62.GeometryPipeline.projectTo2D(
        new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: [0, 0, 0]
            })
          },
          primitiveType: import__62.PrimitiveType.POINTS
        }),
        "position"
      );
    }).toThrowDeveloperError();
  });
  it("projectTo2D throws without attributeName2D", function() {
    expect(function() {
      import__62.GeometryPipeline.projectTo2D(
        new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: [0, 0, 0]
            })
          },
          primitiveType: import__62.PrimitiveType.POINTS
        }),
        "position",
        "position3D"
      );
    }).toThrowDeveloperError();
  });
  it("projectTo2D throws without attribute", function() {
    expect(function() {
      import__62.GeometryPipeline.projectTo2D(
        new import__62.Geometry({
          attributes: {
            normal: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: [0, 0, 0]
            })
          },
          primitiveType: import__62.PrimitiveType.POINTS
        }),
        "position",
        "position3D",
        "position2D"
      );
    }).toThrowDeveloperError();
  });
  it("projectTo2D throws without ComponentDatatype.DOUBLE", function() {
    expect(function() {
      const geometry = new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.UNSIGNED_SHORT,
            componentsPerAttribute: 1,
            values: [0]
          })
        }
      });
      import__62.GeometryPipeline.projectTo2D(
        geometry,
        "position",
        "position3D",
        "position2D"
      );
    }).toThrowDeveloperError();
  });
  it("projectTo2D throws when trying to project a point close to the origin", function() {
    const geometry = {};
    geometry.attributes = {};
    geometry.attributes.position = {
      componentDatatype: import__62.ComponentDatatype.DOUBLE,
      componentsPerAttribute: 3,
      values: [1e5, 2e5, 3e5, 0, 0, 0]
    };
    expect(function() {
      return import__62.GeometryPipeline.projectTo2D(
        geometry,
        "position",
        "position3D",
        "position2D"
      );
    }).toThrowDeveloperError();
  });
  it("encodeAttribute encodes positions", function() {
    const c = new import__62.Cartesian3(-1e7, 0, 1e7);
    const encoded = import__62.EncodedCartesian3.fromCartesian(c);
    let geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          componentDatatype: import__62.ComponentDatatype.DOUBLE,
          componentsPerAttribute: 3,
          values: [c.x, c.y, c.z]
        })
      },
      primitiveType: import__62.PrimitiveType.POINTS
    });
    geometry = import__62.GeometryPipeline.encodeAttribute(
      geometry,
      "position",
      "positionHigh",
      "positionLow"
    );
    expect(geometry.attributes.positionHigh).toBeDefined();
    expect(geometry.attributes.positionHigh.values[0]).toEqual(encoded.high.x);
    expect(geometry.attributes.positionHigh.values[1]).toEqual(encoded.high.y);
    expect(geometry.attributes.positionHigh.values[2]).toEqual(encoded.high.z);
    expect(geometry.attributes.positionLow).toBeDefined();
    expect(geometry.attributes.positionLow.values[0]).toEqual(encoded.low.x);
    expect(geometry.attributes.positionLow.values[1]).toEqual(encoded.low.y);
    expect(geometry.attributes.positionLow.values[2]).toEqual(encoded.low.z);
    expect(geometry.attributes.position).not.toBeDefined();
  });
  it("encodeAttribute throws without a geometry", function() {
    expect(function() {
      import__62.GeometryPipeline.encodeAttribute(void 0);
    }).toThrowDeveloperError();
  });
  it("encodeAttribute throws without attributeName", function() {
    expect(function() {
      import__62.GeometryPipeline.encodeAttribute(
        new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: [0, 0, 0]
            })
          },
          primitiveType: import__62.PrimitiveType.POINTS
        })
      );
    }).toThrowDeveloperError();
  });
  it("encodeAttribute throws without attributeHighName", function() {
    expect(function() {
      import__62.GeometryPipeline.encodeAttribute(
        new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: [0, 0, 0]
            })
          },
          primitiveType: import__62.PrimitiveType.POINTS
        }),
        "position"
      );
    }).toThrowDeveloperError();
  });
  it("encodeAttribute throws without attributeLowName", function() {
    expect(function() {
      import__62.GeometryPipeline.encodeAttribute(
        new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: [0, 0, 0]
            })
          },
          primitiveType: import__62.PrimitiveType.POINTS
        }),
        "position",
        "positionHigh"
      );
    }).toThrowDeveloperError();
  });
  it("encodeAttribute throws without attribute", function() {
    expect(function() {
      import__62.GeometryPipeline.encodeAttribute(
        new import__62.Geometry({
          attributes: {
            normal: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: [0, 0, 0]
            })
          },
          primitiveType: import__62.PrimitiveType.POINTS
        }),
        "position",
        "positionHigh",
        "positionLow"
      );
    }).toThrowDeveloperError();
  });
  it("encodeAttribute throws without ComponentDatatype.DOUBLE", function() {
    expect(function() {
      const geometry = new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.UNSIGNED_SHORT,
            componentsPerAttribute: 1,
            values: [0]
          })
        }
      });
      import__62.GeometryPipeline.encodeAttribute(
        geometry,
        "position",
        "positionHigh",
        "positionLow"
      );
    }).toThrowDeveloperError();
  });
  it("transformToWorldCoordinates", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 0, 0, 0, 1, 0]
          }),
          normal: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 1, 0, 0, 1, 0, 0, 1]
          })
        },
        indices: [0, 1, 2],
        primitiveType: import__62.PrimitiveType.TRIANGLES,
        boundingSphere: new import__62.BoundingSphere(new import__62.Cartesian3(0.5, 0.5, 0), 1)
      }),
      modelMatrix: new import__62.Matrix4(
        0,
        0,
        1,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        0,
        1
      )
    });
    const transformed = import__62.GeometryPipeline.transformToWorldCoordinates(instance);
    const transformedPositions = [0, 0, 0, 0, 1, 0, 0, 0, 1];
    const transformedNormals = [1, 0, 0, 1, 0, 0, 1, 0, 0];
    expect(transformed.geometry.attributes.position.values).toEqual(
      transformedPositions
    );
    expect(transformed.geometry.attributes.normal.values).toEqual(
      transformedNormals
    );
    expect(transformed.geometry.boundingSphere).toEqual(
      new import__62.BoundingSphere(new import__62.Cartesian3(0, 0.5, 0.5), 1)
    );
    expect(transformed.modelMatrix).toEqual(import__62.Matrix4.IDENTITY);
  });
  it("transformToWorldCoordinates with non-uniform scale", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 0, 0, 0, 1, 0]
          }),
          normal: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 1, 0, 0, 1, 0, 0, 1]
          })
        },
        indices: [0, 1, 2],
        primitiveType: import__62.PrimitiveType.TRIANGLES,
        boundingSphere: new import__62.BoundingSphere(new import__62.Cartesian3(0.5, 0.5, 0), 1)
      }),
      modelMatrix: import__62.Matrix4.fromScale(new import__62.Cartesian3(1, 2, 4))
    });
    const transformed = import__62.GeometryPipeline.transformToWorldCoordinates(instance);
    const transformedPositions = [0, 0, 0, 1, 0, 0, 0, 2, 0];
    const transformedNormals = [0, 0, 1, 0, 0, 1, 0, 0, 1];
    expect(transformed.geometry.attributes.position.values).toEqual(
      transformedPositions
    );
    expect(transformed.geometry.attributes.normal.values).toEqual(
      transformedNormals
    );
    expect(transformed.geometry.boundingSphere).toEqual(
      new import__62.BoundingSphere(new import__62.Cartesian3(0.5, 1, 0), 4)
    );
    expect(transformed.modelMatrix).toEqual(import__62.Matrix4.IDENTITY);
  });
  it("transformToWorldCoordinates does nothing when already in world coordinates", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 0, 0, 0, 1, 0]
          }),
          normal: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 1, 0, 0, 1, 0, 0, 1]
          })
        },
        indices: [0, 1, 2],
        primitiveType: import__62.PrimitiveType.TRIANGLES,
        boundingSphere: new import__62.BoundingSphere(new import__62.Cartesian3(0.5, 0.5, 0), 1)
      }),
      modelMatrix: import__62.Matrix4.IDENTITY
    });
    const transformed = import__62.GeometryPipeline.transformToWorldCoordinates(instance);
    const transformedPositions = [0, 0, 0, 1, 0, 0, 0, 1, 0];
    const transformedNormals = [0, 0, 1, 0, 0, 1, 0, 0, 1];
    expect(transformed.geometry.attributes.position.values).toEqual(
      transformedPositions
    );
    expect(transformed.geometry.attributes.normal.values).toEqual(
      transformedNormals
    );
    expect(transformed.geometry.boundingSphere).toEqual(
      new import__62.BoundingSphere(new import__62.Cartesian3(0.5, 0.5, 0), 1)
    );
    expect(transformed.modelMatrix).toEqual(import__62.Matrix4.IDENTITY);
  });
  it("transformToWorldCoordinates throws without an instance", function() {
    expect(function() {
      import__62.GeometryPipeline.transformToWorldCoordinates();
    }).toThrowDeveloperError();
  });
  it("combineInstances combines one geometry", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: new Float32Array([0, 0, 0])
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      })
    });
    const combined = import__62.GeometryPipeline.combineInstances([instance])[0];
    expect(combined).toEqual(instance.geometry);
  });
  it("combineInstances combines several geometries without indicess", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0]
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      })
    });
    const anotherInstance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [1, 1, 1]
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      })
    });
    const combined = import__62.GeometryPipeline.combineInstances([
      instance,
      anotherInstance
    ])[0];
    expect(combined).toEqual(
      new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: new Float32Array([0, 0, 0, 1, 1, 1])
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      })
    );
  });
  it("combineInstances combines several geometries with indicess", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 1, 1, 2, 2, 2]
          }),
          normal: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 1, 1, 2, 2, 2]
          })
        },
        indices: [0, 1, 2],
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    const anotherInstance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [3, 3, 3, 4, 4, 4, 5, 5, 5]
          })
        },
        indices: [0, 1, 2],
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    const combined = import__62.GeometryPipeline.combineInstances([
      instance,
      anotherInstance
    ])[0];
    expect(combined).toEqual(
      new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: new Float32Array([
              0,
              0,
              0,
              1,
              1,
              1,
              2,
              2,
              2,
              3,
              3,
              3,
              4,
              4,
              4,
              5,
              5,
              5
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2, 3, 4, 5]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    );
  });
  it("combineInstances with geometry that is and is not split by the IDL", function() {
    const instances = [
      import__62.GeometryPipeline.splitLongitude(
        new import__62.GeometryInstance({
          geometry: import__62.PolygonGeometry.createGeometry(
            import__62.PolygonGeometry.fromPositions({
              positions: import__62.Cartesian3.fromDegreesArray([
                179,
                1,
                179,
                -1,
                -179,
                -1,
                -179,
                1
              ]),
              vertexFormat: import__62.VertexFormat.POSITION_ONLY,
              granularity: 2 * import__62.Math.RADIANS_PER_DEGREE
            })
          )
        })
      ),
      new import__62.GeometryInstance({
        geometry: import__62.PolygonGeometry.createGeometry(
          import__62.PolygonGeometry.fromPositions({
            positions: import__62.Cartesian3.fromDegreesArray([
              -1,
              1,
              -1,
              -1,
              1,
              -1,
              1,
              1
            ]),
            vertexFormat: import__62.VertexFormat.POSITION_ONLY,
            granularity: 2 * import__62.Math.RADIANS_PER_DEGREE
          })
        )
      })
    ];
    const combinedInstances = import__62.GeometryPipeline.combineInstances(instances);
    expect(combinedInstances.length).toEqual(3);
  });
  it("combineInstances combines bounding spheres", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 0, 0, 0, 1, 0]
          })
        },
        indices: [0, 1, 2],
        primitiveType: import__62.PrimitiveType.TRIANGLES,
        boundingSphere: new import__62.BoundingSphere(new import__62.Cartesian3(0.5, 0.5, 0), 1)
      })
    });
    const anotherInstance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [1, 0, 0, 2, 0, 0, 1, 1, 0]
          })
        },
        indices: [0, 1, 2],
        primitiveType: import__62.PrimitiveType.TRIANGLES,
        boundingSphere: new import__62.BoundingSphere(new import__62.Cartesian3(1.5, 0.5, 0), 1)
      })
    });
    const combined = import__62.GeometryPipeline.combineInstances([
      instance,
      anotherInstance
    ])[0];
    const expected = import__62.BoundingSphere.union(
      instance.geometry.boundingSphere,
      anotherInstance.geometry.boundingSphere
    );
    expect(combined.boundingSphere).toEqual(expected);
  });
  it("combineInstances throws without instances", function() {
    expect(function() {
      import__62.GeometryPipeline.combineInstances();
    }).toThrowDeveloperError();
  });
  it("combineInstances throws when instances.length is zero", function() {
    expect(function() {
      import__62.GeometryPipeline.combineInstances([]);
    }).toThrowDeveloperError();
  });
  it("combineInstances throws when instances.modelMatrix do not match", function() {
    const instance0 = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0]
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      }),
      modelMatrix: import__62.Matrix4.fromScale(new import__62.Cartesian3(1, 1, 1))
    });
    const instance1 = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0]
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      }),
      modelMatrix: import__62.Matrix4.fromScale(new import__62.Cartesian3(2, 2, 2))
    });
    expect(function() {
      import__62.GeometryPipeline.combineInstances([instance0, instance1]);
    }).toThrowDeveloperError();
  });
  it("combineInstances throws when instance geometries do not all have or not have an indices", function() {
    const instance0 = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0]
          })
        },
        indices: [0],
        primitiveType: import__62.PrimitiveType.POINTS
      })
    });
    const instance1 = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0]
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      })
    });
    expect(function() {
      import__62.GeometryPipeline.combineInstances([instance0, instance1]);
    }).toThrowDeveloperError();
  });
  it("combineInstances throws when instance geometries do not all have the same primitive type", function() {
    const instance0 = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0]
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      })
    });
    const instance1 = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: [0, 0, 0, 1, 0, 0]
          })
        },
        primitiveType: import__62.PrimitiveType.LINES
      })
    });
    expect(function() {
      import__62.GeometryPipeline.combineInstances([instance0, instance1]);
    }).toThrowDeveloperError();
  });
  it("computeNormal throws when geometry is undefined", function() {
    expect(function() {
      import__62.GeometryPipeline.computeNormal();
    }).toThrowDeveloperError();
  });
  it("computeNormal throws when geometry.attributes.position is undefined", function() {
    const geometry = new import__62.Geometry({
      attributes: {},
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    expect(function() {
      import__62.GeometryPipeline.computeNormal(geometry);
    }).toThrowDeveloperError();
  });
  it("computeNormal throws when geometry.indices is undefined", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    expect(function() {
      import__62.GeometryPipeline.computeNormal(geometry);
    }).toThrowDeveloperError();
  });
  it("computeNormal throws when geometry.indices.length is not a multiple of 3", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    expect(function() {
      import__62.GeometryPipeline.computeNormal(geometry);
    }).toThrowDeveloperError();
  });
  it("computeNormal throws when primitive type is not triangle", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
    });
    expect(function() {
      import__62.GeometryPipeline.computeNormal(geometry);
    }).toThrowDeveloperError();
  });
  it("computeNormal computes normal for one triangle", function() {
    let geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    geometry = import__62.GeometryPipeline.computeNormal(geometry);
    expect(geometry.attributes.normal.values.length).toEqual(3 * 3);
    expect(geometry.attributes.normal.values).toEqual([
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1
    ]);
  });
  it("computeNormal computes normal for two triangles", function() {
    let geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 1, 1, 1, 1, 2, 0, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2, 1, 3, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    geometry = import__62.GeometryPipeline.computeNormal(geometry);
    const normals = geometry.attributes.normal.values;
    expect(normals.length).toEqual(4 * 3);
    let a = import__62.Cartesian3.normalize(new import__62.Cartesian3(-1, 0, 1), new import__62.Cartesian3());
    expect(import__62.Cartesian3.fromArray(normals, 0)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
    expect(import__62.Cartesian3.fromArray(normals, 3)).toEqualEpsilon(
      import__62.Cartesian3.UNIT_Z,
      import__62.Math.EPSILON7
    );
    expect(import__62.Cartesian3.fromArray(normals, 6)).toEqualEpsilon(
      import__62.Cartesian3.UNIT_Z,
      import__62.Math.EPSILON7
    );
    a = import__62.Cartesian3.normalize(new import__62.Cartesian3(1, 0, 1), new import__62.Cartesian3());
    expect(import__62.Cartesian3.fromArray(normals, 9)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
  });
  it("computeNormal computes normal for six triangles", function() {
    let geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            1,
            0
          ],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2, 3, 0, 2, 4, 0, 3, 4, 5, 0, 5, 6, 0, 6, 1, 0],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    geometry = import__62.GeometryPipeline.computeNormal(geometry);
    const normals = geometry.attributes.normal.values;
    expect(normals.length).toEqual(7 * 3);
    let a = import__62.Cartesian3.normalize(new import__62.Cartesian3(-1, -1, -1), new import__62.Cartesian3());
    expect(import__62.Cartesian3.fromArray(normals, 0)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
    a = import__62.Cartesian3.normalize(new import__62.Cartesian3(0, -1, -1), new import__62.Cartesian3());
    expect(import__62.Cartesian3.fromArray(normals, 3)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
    expect(import__62.Cartesian3.fromArray(normals, 6)).toEqualEpsilon(
      import__62.Cartesian3.negate(import__62.Cartesian3.UNIT_Y, new import__62.Cartesian3()),
      import__62.Math.EPSILON7
    );
    a = import__62.Cartesian3.normalize(new import__62.Cartesian3(-1, -1, 0), new import__62.Cartesian3());
    expect(import__62.Cartesian3.fromArray(normals, 9)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
    expect(import__62.Cartesian3.fromArray(normals, 12)).toEqualEpsilon(
      import__62.Cartesian3.negate(import__62.Cartesian3.UNIT_X, new import__62.Cartesian3()),
      import__62.Math.EPSILON7
    );
    a = import__62.Cartesian3.normalize(new import__62.Cartesian3(-1, 0, -1), new import__62.Cartesian3());
    expect(import__62.Cartesian3.fromArray(normals, 15)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
    expect(import__62.Cartesian3.fromArray(normals, 18)).toEqualEpsilon(
      import__62.Cartesian3.negate(import__62.Cartesian3.UNIT_Z, new import__62.Cartesian3()),
      import__62.Math.EPSILON7
    );
  });
  it("computeNormal computes normal of (0,0,1) for a degenerate triangle", function() {
    let geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 0],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    geometry = import__62.GeometryPipeline.computeNormal(geometry);
    expect(geometry.attributes.normal.values.length).toEqual(2 * 3);
    expect(geometry.attributes.normal.values).toEqual([0, 0, 1, 0, 0, 1]);
  });
  it("computeNormal takes first normal for two coplanar triangles with opposite winding orders", function() {
    let geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 1, 1, 1, 1],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2, 2, 1, 0],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    geometry = import__62.GeometryPipeline.computeNormal(geometry);
    const normals = geometry.attributes.normal.values;
    expect(normals.length).toEqual(3 * 3);
    const a = import__62.Cartesian3.normalize(new import__62.Cartesian3(-1, 0, 1), new import__62.Cartesian3());
    expect(import__62.Cartesian3.fromArray(normals, 0)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
    expect(import__62.Cartesian3.fromArray(normals, 3)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
    expect(import__62.Cartesian3.fromArray(normals, 6)).toEqualEpsilon(
      a,
      import__62.Math.EPSILON7
    );
  });
  it("computeTangentAndBitangent throws when geometry is undefined", function() {
    expect(function() {
      import__62.GeometryPipeline.computeTangentAndBitangent();
    }).toThrowDeveloperError();
  });
  it("computeTangentAndBitangent throws when position is undefined", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        normal: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        st: new import__62.GeometryAttribute({
          values: [0, 0, 1, 1],
          componentsPerAttribute: 2,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
    });
    expect(function() {
      import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    }).toThrowDeveloperError();
  });
  it("computeTangentAndBitangent throws when normal is undefined", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        st: new import__62.GeometryAttribute({
          values: [0, 0, 1, 1],
          componentsPerAttribute: 2,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
    });
    expect(function() {
      import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    }).toThrowDeveloperError();
  });
  it("computeTangentAndBitangent throws when st is undefined", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        normal: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
    });
    expect(function() {
      import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    }).toThrowDeveloperError();
  });
  it("computeTangentAndBitangent throws when geometry.indices is undefined", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        normal: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        st: new import__62.GeometryAttribute({
          values: [0, 0, 1, 1],
          componentsPerAttribute: 2,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      primitiveType: import__62.PrimitiveType.POINTS
    });
    expect(function() {
      import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    }).toThrowDeveloperError();
  });
  it("computeTangentAndBitangent throws when indices is not a multiple of 3", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        normal: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        st: new import__62.GeometryAttribute({
          values: [0, 0, 1, 1],
          componentsPerAttribute: 2,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2, 3, 4],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    expect(function() {
      import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    }).toThrowDeveloperError();
  });
  it("computeTangentAndBitangent throws when primitive type is not triangle", function() {
    const geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        normal: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        st: new import__62.GeometryAttribute({
          values: [0, 0, 1, 1],
          componentsPerAttribute: 2,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
    });
    expect(function() {
      import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    }).toThrowDeveloperError();
  });
  it("computeTangentAndBitangent computes tangent and bitangent for one triangle", function() {
    let geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 0, 0, 1, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        st: new import__62.GeometryAttribute({
          values: [0, 0, 1, 0, 0, 1],
          componentsPerAttribute: 2,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    geometry = import__62.GeometryPipeline.computeNormal(geometry);
    geometry = import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    expect(geometry.attributes.tangent.values).toEqual([
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0
    ]);
    expect(geometry.attributes.bitangent.values).toEqual([
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0
    ]);
  });
  it("computeTangentAndBitangent computes tangent and bitangent for two triangles", function() {
    let geometry = new import__62.Geometry({
      attributes: {
        position: new import__62.GeometryAttribute({
          values: [0, 0, 0, 1, 0, 1, 1, 1, 1, 2, 0, 0],
          componentsPerAttribute: 3,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        }),
        st: new import__62.GeometryAttribute({
          values: [0, 0, 1, 0, 1, 1, 0, 1],
          componentsPerAttribute: 2,
          componentDatatype: import__62.ComponentDatatype.FLOAT
        })
      },
      indices: [0, 1, 2, 1, 3, 2],
      primitiveType: import__62.PrimitiveType.TRIANGLES
    });
    geometry = import__62.GeometryPipeline.computeNormal(geometry);
    geometry = import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    expect(geometry.attributes.tangent.values).toEqualEpsilon(
      [
        0.7071067811865475,
        0,
        0.7071067811865475,
        0,
        1,
        0,
        0,
        1,
        0,
        -0.5773502691896258,
        0.5773502691896258,
        0.5773502691896258
      ],
      import__62.Math.EPSILON7
    );
    expect(geometry.attributes.bitangent.values).toEqualEpsilon(
      [
        0,
        1,
        0,
        -1,
        0,
        0,
        -1,
        0,
        0,
        -0.4082482904638631,
        -0.8164965809277261,
        0.4082482904638631
      ],
      import__62.Math.EPSILON7
    );
  });
  it("computeTangentAndBitangent computes tangent and bitangent for BoxGeometry", function() {
    let geometry = import__62.BoxGeometry.createGeometry(
      new import__62.BoxGeometry({
        vertexFormat: new import__62.VertexFormat({
          position: true,
          normal: true,
          st: true
        }),
        maximum: new import__62.Cartesian3(25e4, 25e4, 25e4),
        minimum: new import__62.Cartesian3(-25e4, -25e4, -25e4)
      })
    );
    geometry = import__62.GeometryPipeline.computeTangentAndBitangent(geometry);
    const actualTangents = geometry.attributes.tangent.values;
    const actualBitangents = geometry.attributes.bitangent.values;
    const expectedGeometry = import__62.BoxGeometry.createGeometry(
      new import__62.BoxGeometry({
        vertexFormat: import__62.VertexFormat.ALL,
        maximum: new import__62.Cartesian3(25e4, 25e4, 25e4),
        minimum: new import__62.Cartesian3(-25e4, -25e4, -25e4)
      })
    );
    const expectedTangents = expectedGeometry.attributes.tangent.values;
    const expectedBitangents = expectedGeometry.attributes.bitangent.values;
    expect(actualTangents.length).toEqual(expectedTangents.length);
    expect(actualBitangents.length).toEqual(expectedBitangents.length);
    for (let i = 0; i < actualTangents.length; i += 3) {
      let actual = import__62.Cartesian3.fromArray(actualTangents, i);
      let expected = import__62.Cartesian3.fromArray(expectedTangents, i);
      expect(actual).toEqualEpsilon(expected, import__62.Math.EPSILON1);
      actual = import__62.Cartesian3.fromArray(actualBitangents, i);
      expected = import__62.Cartesian3.fromArray(expectedBitangents, i);
      expect(actual).toEqualEpsilon(expected, import__62.Math.EPSILON1);
    }
  });
  it("compressVertices throws without geometry", function() {
    expect(function() {
      return import__62.GeometryPipeline.compressVertices();
    }).toThrowDeveloperError();
  });
  it("compressVertices on geometry without normals or texture coordinates does nothing", function() {
    let geometry = import__62.BoxGeometry.createGeometry(
      new import__62.BoxGeometry({
        vertexFormat: new import__62.VertexFormat({
          position: true
        }),
        maximum: new import__62.Cartesian3(25e4, 25e4, 25e4),
        minimum: new import__62.Cartesian3(-25e4, -25e4, -25e4)
      })
    );
    expect(geometry.attributes.normal).not.toBeDefined();
    geometry = import__62.GeometryPipeline.compressVertices(geometry);
    expect(geometry.attributes.normal).not.toBeDefined();
  });
  it("compressVertices compresses normals", function() {
    let geometry = import__62.BoxGeometry.createGeometry(
      new import__62.BoxGeometry({
        vertexFormat: new import__62.VertexFormat({
          position: true,
          normal: true
        }),
        maximum: new import__62.Cartesian3(25e4, 25e4, 25e4),
        minimum: new import__62.Cartesian3(-25e4, -25e4, -25e4)
      })
    );
    expect(geometry.attributes.normal).toBeDefined();
    const originalNormals = geometry.attributes.normal.values.slice();
    geometry = import__62.GeometryPipeline.compressVertices(geometry);
    expect(geometry.attributes.compressedAttributes).toBeDefined();
    const normals = geometry.attributes.compressedAttributes.values;
    expect(normals.length).toEqual(originalNormals.length / 3);
    for (let i = 0; i < normals.length; ++i) {
      expect(
        import__62.AttributeCompression.octDecodeFloat(normals[i], new import__62.Cartesian3())
      ).toEqualEpsilon(
        import__62.Cartesian3.fromArray(originalNormals, i * 3),
        import__62.Math.EPSILON2
      );
    }
  });
  it("compressVertices compresses texture coordinates", function() {
    let geometry = import__62.BoxGeometry.createGeometry(
      new import__62.BoxGeometry({
        vertexFormat: new import__62.VertexFormat({
          position: true,
          st: true
        }),
        maximum: new import__62.Cartesian3(25e4, 25e4, 25e4),
        minimum: new import__62.Cartesian3(-25e4, -25e4, -25e4)
      })
    );
    expect(geometry.attributes.st).toBeDefined();
    const originalST = geometry.attributes.st.values.slice();
    geometry = import__62.GeometryPipeline.compressVertices(geometry);
    expect(geometry.attributes.st).not.toBeDefined();
    expect(geometry.attributes.compressedAttributes).toBeDefined();
    const st = geometry.attributes.compressedAttributes.values;
    expect(st.length).toEqual(originalST.length / 2);
    for (let i = 0; i < st.length; ++i) {
      const temp = st[i] / 4096;
      const stx = Math.floor(temp) / 4096;
      const sty = temp - Math.floor(temp);
      const texCoord = new import__62.Cartesian2(stx, sty);
      expect(texCoord).toEqualEpsilon(
        import__62.Cartesian2.fromArray(originalST, i * 2, new import__62.Cartesian2()),
        import__62.Math.EPSILON2
      );
    }
  });
  it("compressVertices packs compressed normals with texture coordinates", function() {
    let geometry = import__62.BoxGeometry.createGeometry(
      new import__62.BoxGeometry({
        vertexFormat: new import__62.VertexFormat({
          position: true,
          normal: true,
          st: true
        }),
        maximum: new import__62.Cartesian3(25e4, 25e4, 25e4),
        minimum: new import__62.Cartesian3(-25e4, -25e4, -25e4)
      })
    );
    expect(geometry.attributes.normal).toBeDefined();
    expect(geometry.attributes.st).toBeDefined();
    const originalNormals = geometry.attributes.normal.values.slice();
    const originalST = geometry.attributes.st.values.slice();
    geometry = import__62.GeometryPipeline.compressVertices(geometry);
    expect(geometry.attributes.normal).not.toBeDefined();
    expect(geometry.attributes.st).not.toBeDefined();
    expect(geometry.attributes.compressedAttributes).toBeDefined();
    const stNormal = geometry.attributes.compressedAttributes.values;
    expect(stNormal.length).toEqual(originalST.length);
    for (let i = 0; i < stNormal.length; i += 2) {
      expect(
        import__62.AttributeCompression.decompressTextureCoordinates(
          stNormal[i],
          new import__62.Cartesian2()
        )
      ).toEqualEpsilon(
        import__62.Cartesian2.fromArray(originalST, i, new import__62.Cartesian2()),
        import__62.Math.EPSILON2
      );
      expect(
        import__62.AttributeCompression.octDecodeFloat(stNormal[i + 1], new import__62.Cartesian3())
      ).toEqualEpsilon(
        import__62.Cartesian3.fromArray(originalNormals, i / 2 * 3),
        import__62.Math.EPSILON2
      );
    }
  });
  it("compressVertices packs compressed tangents and bitangents", function() {
    let geometry = import__62.BoxGeometry.createGeometry(
      new import__62.BoxGeometry({
        vertexFormat: new import__62.VertexFormat({
          position: true,
          normal: true,
          tangent: true,
          bitangent: true
        }),
        maximum: new import__62.Cartesian3(25e4, 25e4, 25e4),
        minimum: new import__62.Cartesian3(-25e4, -25e4, -25e4)
      })
    );
    expect(geometry.attributes.normal).toBeDefined();
    expect(geometry.attributes.tangent).toBeDefined();
    expect(geometry.attributes.bitangent).toBeDefined();
    const originalNormals = geometry.attributes.normal.values.slice();
    const originalTangents = geometry.attributes.tangent.values.slice();
    const originalBitangents = geometry.attributes.bitangent.values.slice();
    geometry = import__62.GeometryPipeline.compressVertices(geometry);
    expect(geometry.attributes.tangent).not.toBeDefined();
    expect(geometry.attributes.bitangent).not.toBeDefined();
    expect(geometry.attributes.compressedAttributes).toBeDefined();
    const compressedNormals = geometry.attributes.compressedAttributes.values;
    expect(compressedNormals.length).toEqual(originalNormals.length / 3 * 2);
    const normal = new import__62.Cartesian3();
    const tangent = new import__62.Cartesian3();
    const bitangent = new import__62.Cartesian3();
    for (let i = 0; i < compressedNormals.length; i += 2) {
      const compressed = import__62.Cartesian2.fromArray(
        compressedNormals,
        i,
        new import__62.Cartesian2()
      );
      import__62.AttributeCompression.octUnpack(compressed, normal, tangent, bitangent);
      expect(normal).toEqualEpsilon(
        import__62.Cartesian3.fromArray(originalNormals, i / 2 * 3),
        import__62.Math.EPSILON2
      );
      expect(tangent).toEqualEpsilon(
        import__62.Cartesian3.fromArray(originalTangents, i / 2 * 3),
        import__62.Math.EPSILON2
      );
      expect(bitangent).toEqualEpsilon(
        import__62.Cartesian3.fromArray(originalBitangents, i / 2 * 3),
        import__62.Math.EPSILON2
      );
    }
  });
  it("splitLongitude does nothing for geometry not split by the IDL", function() {
    const instance = new import__62.GeometryInstance({
      geometry: import__62.PolygonGeometry.createGeometry(
        import__62.PolygonGeometry.fromPositions({
          positions: import__62.Cartesian3.fromDegreesArray([
            -1,
            1,
            -1,
            -1,
            1,
            -1,
            1,
            1
          ]),
          vertexFormat: import__62.VertexFormat.POSITION_ONLY,
          granularity: 2 * import__62.Math.RADIANS_PER_DEGREE
        })
      )
    });
    const splitInstance = import__62.GeometryPipeline.splitLongitude(instance);
    expect(splitInstance).toBe(instance);
  });
  it("splitLongitude interpolates custom attributes for geometry split by the IDL", function() {
    const p0 = import__62.Cartesian3.fromDegrees(-179, 0);
    const p1 = import__62.Cartesian3.fromDegrees(179, 0);
    const p2 = import__62.Cartesian3.fromDegrees(-179, 1);
    const positions = new Float64Array([
      p0.x,
      p0.y,
      p0.z,
      p1.x,
      p1.y,
      p1.z,
      p2.x,
      p2.y,
      p2.z
    ]);
    const vec4s = new Uint8Array([0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0]);
    const vec3s = new Uint8Array([0, 0, 0, 0, 0, 255, 0, 0, 0]);
    const vec2s = new Uint8Array([0, 0, 0, 255, 0, 0]);
    const scalars = new Uint8Array([0, 255, 0]);
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: positions
          }),
          vec4s: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 4,
            values: vec4s
          }),
          vec3s: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 3,
            values: vec3s
          }),
          vec2s: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 2,
            values: vec2s
          }),
          scalars: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 1,
            values: scalars
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES,
        boundingSphere: import__62.BoundingSphere.fromVertices(positions)
      })
    });
    const splitInstance = import__62.GeometryPipeline.splitLongitude(instance);
    const eastHemisphereGeometry = splitInstance.eastHemisphereGeometry;
    expect(eastHemisphereGeometry.indices.length).toEqual(3);
    let newVec4s = eastHemisphereGeometry.attributes.vec4s.values;
    let newVec3s = eastHemisphereGeometry.attributes.vec3s.values;
    let newVec2s = eastHemisphereGeometry.attributes.vec2s.values;
    let newScalars = eastHemisphereGeometry.attributes.scalars.values;
    let i;
    let index;
    expect(Array.prototype.indexOf.call(newScalars, 127)).not.toBe(-1);
    expect(Array.prototype.indexOf.call(newVec4s, 127)).not.toBe(-1);
    expect(Array.prototype.indexOf.call(newVec3s, 127)).not.toBe(-1);
    expect(Array.prototype.indexOf.call(newVec2s, 127)).not.toBe(-1);
    for (i = 0; i < 3; i++) {
      expect(newScalars[i] === 255 || newScalars[i] === 127).toBe(true);
      index = i * 2;
      expect(newVec2s[index]).toBe(0);
      expect(newVec2s[index + 1] === 255 || newVec2s[index + 1] === 127).toBe(
        true
      );
      index = i * 3;
      expect(newVec3s[index]).toBe(0);
      expect(newVec3s[index + 1]).toBe(0);
      expect(newVec3s[index + 2] === 255 || newVec3s[index + 2] === 127).toBe(
        true
      );
      index = i * 4;
      expect(newVec4s[index]).toBe(0);
      expect(newVec4s[index + 1]).toBe(0);
      expect(newVec4s[index + 2]).toBe(0);
      expect(newVec4s[index + 3] === 255 || newVec4s[index + 3] === 127).toBe(
        true
      );
    }
    const westHemisphereGeometry = splitInstance.westHemisphereGeometry;
    expect(westHemisphereGeometry.indices.length).toEqual(6);
    newVec4s = westHemisphereGeometry.attributes.vec4s.values;
    newVec3s = westHemisphereGeometry.attributes.vec3s.values;
    newVec2s = westHemisphereGeometry.attributes.vec2s.values;
    newScalars = westHemisphereGeometry.attributes.scalars.values;
    expect(Array.prototype.indexOf.call(newScalars, 127)).not.toBe(-1);
    expect(Array.prototype.indexOf.call(newVec4s, 127)).not.toBe(-1);
    expect(Array.prototype.indexOf.call(newVec3s, 127)).not.toBe(-1);
    expect(Array.prototype.indexOf.call(newVec2s, 127)).not.toBe(-1);
    for (i = 0; i < 4; i++) {
      expect(newScalars[i] === 0 || newScalars[i] === 127).toBe(true);
      index = i * 2;
      expect(newVec2s[index]).toBe(0);
      expect(newVec2s[index + 1] === 0 || newVec2s[index + 1] === 127).toBe(
        true
      );
      index = i * 3;
      expect(newVec3s[index]).toBe(0);
      expect(newVec3s[index + 1]).toBe(0);
      expect(newVec3s[index + 2] === 0 || newVec3s[index + 2] === 127).toBe(
        true
      );
      index = i * 4;
      expect(newVec4s[index]).toBe(0);
      expect(newVec4s[index + 1]).toBe(0);
      expect(newVec4s[index + 2]).toBe(0);
      expect(newVec4s[index + 3] === 0 || newVec4s[index + 3] === 127).toBe(
        true
      );
    }
  });
  it("splitLongitude provides indices for an un-indexed triangle list", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6,
              5,
              4,
              3,
              2,
              1,
              0
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry.indices).toEqual([0, 1, 2, 3, 4, 5]);
  });
  it("splitLongitude returns unchanged geometry if indices are already defined for an un-indexed triangle list", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6,
              5,
              4,
              3,
              2,
              1,
              0
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.TRIANGLES,
        indices: new Uint16Array([0, 1, 2, 3, 4, 5])
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry.indices).toEqual([0, 1, 2, 3, 4, 5]);
  });
  it("splitLongitude throws when primitive type is TRIANGLES and number of vertices is less than 3", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([0, 1, 2])
          })
        },
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    expect(function() {
      import__62.GeometryPipeline.splitLongitude(instance);
    }).toThrowDeveloperError();
  });
  it("splitLongitude throws when primitive type is TRIANGLES and number of vertices is not a multiple of 3", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6,
              5,
              4,
              3,
              2,
              1
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    expect(function() {
      import__62.GeometryPipeline.splitLongitude(instance);
    }).toThrowDeveloperError();
  });
  it("splitLongitude creates indexed triangles for a triangle fan", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.TRIANGLE_FAN
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry.primitiveType).toEqual(import__62.PrimitiveType.TRIANGLES);
    expect(instance.geometry.indices).toEqual([0, 1, 2, 2, 1, 3]);
  });
  it("splitLongitude throws when primitive type is TRIANGLE_FAN and number of vertices is less than 3", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([0, 1, 2])
          })
        },
        primitiveType: import__62.PrimitiveType.TRIANGLE_FAN
      })
    });
    expect(function() {
      import__62.GeometryPipeline.splitLongitude(instance);
    }).toThrowDeveloperError();
  });
  it("splitLongitude creates indexd triangles for triangle strips", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6,
              5,
              4,
              3,
              2,
              1,
              0
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry.primitiveType).toEqual(import__62.PrimitiveType.TRIANGLES);
    expect(instance.geometry.indices).toEqual([
      0,
      1,
      2,
      0,
      2,
      3,
      3,
      2,
      4,
      3,
      4,
      5
    ]);
  });
  it("splitLongitude throws when the primitive type is TRIANGLE_STRIP and number of vertices is less than 3", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([0, 1, 2])
          })
        },
        primitiveType: import__62.PrimitiveType.TRIANGLE_STRIP
      })
    });
    expect(function() {
      import__62.GeometryPipeline.splitLongitude(instance);
    }).toThrowDeveloperError();
  });
  it("splitLongitude creates indexed lines", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.LINES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry.indices).toEqual([0, 1, 2, 3]);
  });
  it("splitLongitude returns lines unchanged if indices are provided", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.LINES,
        indices: new Uint16Array([0, 1, 2, 3])
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry.indices).toEqual([0, 1, 2, 3]);
  });
  it("splitLongitude throws when primitive type is LINES and number of vertices is less than 2", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([0, 1, 2])
          })
        },
        primitiveType: import__62.PrimitiveType.LINES
      })
    });
    expect(function() {
      import__62.GeometryPipeline.splitLongitude(instance);
    }).toThrowDeveloperError();
  });
  it("splitLongitude throws when primitive type is LINES and number of vertices is not a multiple 2", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.LINES
      })
    });
    expect(function() {
      import__62.GeometryPipeline.splitLongitude(instance);
    }).toThrowDeveloperError();
  });
  it("splitLongitude creates indexed lines from line strip", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.LINE_STRIP
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry.primitiveType).toEqual(import__62.PrimitiveType.LINES);
    expect(instance.geometry.indices).toEqual([0, 1, 1, 2, 2, 3]);
  });
  it("splitLongitude throws when primitive type is LINE_STRIP and number of vertices is less than 2", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([0, 1, 2])
          })
        },
        primitiveType: import__62.PrimitiveType.LINE_STRIP
      })
    });
    expect(function() {
      import__62.GeometryPipeline.splitLongitude(instance);
    }).toThrowDeveloperError();
  });
  it("splitLongitude creates indexed lines from line loops", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              0,
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              8,
              7,
              6
            ])
          })
        },
        primitiveType: import__62.PrimitiveType.LINE_LOOP
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry.primitiveType).toEqual(import__62.PrimitiveType.LINES);
    expect(instance.geometry.indices).toEqual([0, 1, 1, 2, 2, 3, 3, 0]);
  });
  it("splitLongitude throws when the primitive type is LINE_LOOP and number of vertices is less than 2", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([0, 1, 2])
          })
        },
        primitiveType: import__62.PrimitiveType.LINE_LOOP
      })
    });
    expect(function() {
      import__62.GeometryPipeline.splitLongitude(instance);
    }).toThrowDeveloperError();
  });
  it("splitLongitude subdivides triangle crossing the international date line, p0 behind", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -1,
              -1,
              0,
              -1,
              1,
              2,
              -1,
              2,
              2
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry).not.toBeDefined();
    expect(instance.westHemisphereGeometry).toBeDefined();
    expect(instance.westHemisphereGeometry.indices).toBeDefined();
    expect(instance.westHemisphereGeometry.indices.length).toEqual(3);
    expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.position.values.length
    ).toEqual(3 * 3);
    expect(instance.eastHemisphereGeometry).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices.length).toEqual(6);
    expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.position.values.length
    ).toEqual(5 * 3);
  });
  it("splitLongitude subdivides triangle crossing the international date line, p1 behind", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -1,
              1,
              2,
              -1,
              -1,
              0,
              -1,
              2,
              2
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry).not.toBeDefined();
    expect(instance.westHemisphereGeometry).toBeDefined();
    expect(instance.westHemisphereGeometry.indices).toBeDefined();
    expect(instance.westHemisphereGeometry.indices.length).toEqual(3);
    expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.position.values.length
    ).toEqual(3 * 3);
    expect(instance.eastHemisphereGeometry).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices.length).toEqual(6);
    expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.position.values.length
    ).toEqual(5 * 3);
  });
  it("splitLongitude subdivides triangle crossing the international date line, p2 behind", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -1,
              1,
              2,
              -1,
              2,
              2,
              -1,
              -1,
              0
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry).not.toBeDefined();
    expect(instance.westHemisphereGeometry).toBeDefined();
    expect(instance.westHemisphereGeometry.indices).toBeDefined();
    expect(instance.westHemisphereGeometry.indices.length).toEqual(3);
    expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.position.values.length
    ).toEqual(3 * 3);
    expect(instance.eastHemisphereGeometry).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices.length).toEqual(6);
    expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.position.values.length
    ).toEqual(5 * 3);
  });
  it("splitLongitude subdivides triangle crossing the international date line, p0 ahead", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -1,
              1,
              0,
              -1,
              -1,
              0,
              -2,
              -1,
              0
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry).not.toBeDefined();
    expect(instance.westHemisphereGeometry).toBeDefined();
    expect(instance.westHemisphereGeometry.indices).toBeDefined();
    expect(instance.westHemisphereGeometry.indices.length).toEqual(6);
    expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.position.values.length
    ).toEqual(5 * 3);
    expect(instance.eastHemisphereGeometry).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices.length).toEqual(3);
    expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.position.values.length
    ).toEqual(3 * 3);
  });
  it("splitLongitude subdivides triangle crossing the international date line, p1 ahead", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -2,
              -1,
              0,
              -1,
              1,
              0,
              -1,
              -1,
              0
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry).not.toBeDefined();
    expect(instance.westHemisphereGeometry).toBeDefined();
    expect(instance.westHemisphereGeometry.indices).toBeDefined();
    expect(instance.westHemisphereGeometry.indices.length).toEqual(6);
    expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.position.values.length
    ).toEqual(5 * 3);
    expect(instance.eastHemisphereGeometry).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices.length).toEqual(3);
    expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.position.values.length
    ).toEqual(3 * 3);
  });
  it("splitLongitude subdivides triangle crossing the international date line, p2 ahead", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -1,
              -1,
              0,
              -2,
              -1,
              0,
              -1,
              1,
              0
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry).not.toBeDefined();
    expect(instance.westHemisphereGeometry).toBeDefined();
    expect(instance.westHemisphereGeometry.indices).toBeDefined();
    expect(instance.westHemisphereGeometry.indices.length).toEqual(6);
    expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.position.values.length
    ).toEqual(5 * 3);
    expect(instance.eastHemisphereGeometry).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices.length).toEqual(3);
    expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.position.values.length
    ).toEqual(3 * 3);
  });
  it("splitLongitude returns offset triangle that touches the international date line", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -1,
              0,
              1,
              -1,
              import__62.Math.EPSILON14,
              2,
              -2,
              2,
              2
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    const geometry = instance.geometry;
    expect(geometry.indices).toEqual([0, 1, 2]);
    const positions = geometry.attributes.position.values;
    expect(positions).toEqual([
      -1,
      import__62.Math.EPSILON6,
      1,
      -1,
      import__62.Math.EPSILON6,
      2,
      -2,
      2,
      2
    ]);
    expect(positions.length).toEqual(3 * 3);
  });
  it("splitLongitude returns the same points if the triangle doesn't cross the international date line, behind", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -1,
              -1,
              1,
              -1,
              -2,
              1,
              -1,
              -2,
              2
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    const geometry = instance.geometry;
    expect(geometry.indices).toEqual([0, 1, 2]);
    const positions = geometry.attributes.position.values;
    expect(positions).toEqual([
      -1,
      -1,
      1,
      -1,
      -2,
      1,
      -1,
      -2,
      2
    ]);
    expect(positions.length).toEqual(3 * 3);
  });
  it("splitLongitude returns the same points if the triangle doesn't cross the international date line, ahead", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -1,
              1,
              1,
              -1,
              2,
              1,
              -1,
              2,
              2
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    const geometry = instance.geometry;
    expect(geometry.indices).toEqual([0, 1, 2]);
    const positions = geometry.attributes.position.values;
    expect(positions).toEqual([-1, 1, 1, -1, 2, 1, -1, 2, 2]);
    expect(positions.length).toEqual(3 * 3);
  });
  it("splitLongitude returns the same points if the triangle doesn't cross the international date line, positive x", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              1,
              1,
              1,
              1,
              2,
              1,
              1,
              2,
              2
            ])
          })
        },
        indices: new Uint16Array([0, 1, 2]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    const geometry = instance.geometry;
    expect(geometry.indices).toEqual([0, 1, 2]);
    const positions = geometry.attributes.position.values;
    expect(positions).toEqual([1, 1, 1, 1, 2, 1, 1, 2, 2]);
    expect(positions.length).toEqual(3 * 3);
  });
  it("splitLongitude computes all attributes for a triangle crossing the international date line", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([
              -2,
              -1,
              0,
              -3,
              1,
              0,
              -1,
              1,
              0
            ])
          }),
          normal: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: new Float32Array([
              0,
              0,
              1,
              0,
              0,
              1,
              0,
              0,
              1
            ])
          }),
          tangent: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: new Float32Array([
              -1,
              0,
              0,
              -1,
              0,
              0,
              -1,
              0,
              0
            ])
          }),
          bitangent: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 3,
            values: new Float32Array([
              0,
              -1,
              0,
              0,
              -1,
              0,
              0,
              -1,
              0
            ])
          }),
          st: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.FLOAT,
            componentsPerAttribute: 2,
            values: new Float32Array([0, 0, 1, 0, 0.5, 0.5])
          })
        },
        indices: new Uint16Array([1, 2, 0]),
        primitiveType: import__62.PrimitiveType.TRIANGLES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry).not.toBeDefined();
    expect(instance.westHemisphereGeometry).toBeDefined();
    expect(instance.westHemisphereGeometry.indices).toBeDefined();
    expect(instance.westHemisphereGeometry.indices.length).toEqual(3);
    expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.position.values.length
    ).toEqual(3 * 3);
    expect(instance.westHemisphereGeometry.attributes.normal).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.normal.values.length
    ).toEqual(3 * 3);
    expect(instance.westHemisphereGeometry.attributes.bitangent).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.bitangent.values.length
    ).toEqual(3 * 3);
    expect(instance.westHemisphereGeometry.attributes.tangent).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.tangent.values.length
    ).toEqual(3 * 3);
    expect(instance.westHemisphereGeometry.attributes.st).toBeDefined();
    expect(instance.westHemisphereGeometry.attributes.st.values.length).toEqual(
      3 * 2
    );
    expect(instance.eastHemisphereGeometry).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices.length).toEqual(6);
    expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.position.values.length
    ).toEqual(5 * 3);
    expect(instance.eastHemisphereGeometry.attributes.normal).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.normal.values.length
    ).toEqual(5 * 3);
    expect(instance.eastHemisphereGeometry.attributes.bitangent).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.bitangent.values.length
    ).toEqual(5 * 3);
    expect(instance.eastHemisphereGeometry.attributes.tangent).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.tangent.values.length
    ).toEqual(5 * 3);
    expect(instance.eastHemisphereGeometry.attributes.st).toBeDefined();
    expect(instance.eastHemisphereGeometry.attributes.st.values.length).toEqual(
      5 * 2
    );
  });
  it("splitLongitude subdivides line crossing the international date line", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([-1, -1, 0, -1, 1, 2])
          })
        },
        indices: new Uint16Array([0, 1]),
        primitiveType: import__62.PrimitiveType.LINES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    expect(instance.geometry).not.toBeDefined();
    expect(instance.westHemisphereGeometry).toBeDefined();
    expect(instance.westHemisphereGeometry.indices).toBeDefined();
    expect(instance.westHemisphereGeometry.indices.length).toEqual(2);
    expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.westHemisphereGeometry.attributes.position.values.length
    ).toEqual(2 * 3);
    expect(instance.eastHemisphereGeometry).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices).toBeDefined();
    expect(instance.eastHemisphereGeometry.indices.length).toEqual(2);
    expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
    expect(
      instance.eastHemisphereGeometry.attributes.position.values.length
    ).toEqual(2 * 3);
  });
  it("splitLongitude returns offset line that touches the international date line", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([-1, 0, 0, -1, 1, 2])
          })
        },
        indices: new Uint16Array([0, 1]),
        primitiveType: import__62.PrimitiveType.LINES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    const geometry = instance.geometry;
    expect(geometry.indices).toEqual([0, 1]);
    const positions = geometry.attributes.position.values;
    expect(positions).toEqual([-1, import__62.Math.EPSILON6, 0, -1, 1, 2]);
  });
  it("splitLongitude returns the same points if the line doesn't cross the international date line", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([1, 1, 0, 1, 1, 2])
          })
        },
        indices: new Uint16Array([0, 1]),
        primitiveType: import__62.PrimitiveType.LINES
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    const geometry = instance.geometry;
    expect(geometry.indices).toEqual([0, 1]);
    const positions = geometry.attributes.position.values;
    expect(positions).toEqual([1, 1, 0, 1, 1, 2]);
  });
  it("splitLongitude does nothing for points", function() {
    const instance = new import__62.GeometryInstance({
      geometry: new import__62.Geometry({
        attributes: {
          position: new import__62.GeometryAttribute({
            componentDatatype: import__62.ComponentDatatype.DOUBLE,
            componentsPerAttribute: 3,
            values: new Float64Array([1, 1, 0, 1, 1, 2])
          })
        },
        primitiveType: import__62.PrimitiveType.POINTS
      })
    });
    import__62.GeometryPipeline.splitLongitude(instance);
    const geometry = instance.geometry;
    expect(geometry.indices).not.toBeDefined();
    const positions = geometry.attributes.position.values;
    expect(positions).toEqual([1, 1, 0, 1, 1, 2]);
  });
  describe("splitLongitude polylines", function() {
    it("subdivides wide line crossing the international date line", function() {
      const instance = new import__62.GeometryInstance({
        geometry: new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
                -1,
                -1,
                0,
                -1,
                -1,
                0,
                -1,
                1,
                2,
                -1,
                1,
                2
              ])
            }),
            nextPosition: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
                -1,
                1,
                2,
                -1,
                1,
                2,
                -1,
                2,
                3,
                -1,
                2,
                3
              ])
            }),
            prevPosition: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
                -1,
                -2,
                -1,
                -1,
                -2,
                -1,
                -1,
                -1,
                0,
                -1,
                -1,
                0
              ])
            }),
            expandAndWidth: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.FLOAT,
              componentsPerAttribute: 2,
              values: new Float32Array([
                -1,
                5,
                1,
                5,
                -1,
                -5,
                1,
                -5
              ])
            })
          },
          indices: new Uint16Array([0, 2, 1, 1, 2, 3]),
          primitiveType: import__62.PrimitiveType.TRIANGLES,
          geometryType: import__62.GeometryType.POLYLINES
        })
      });
      import__62.GeometryPipeline.splitLongitude(instance);
      expect(instance.geometry).not.toBeDefined();
      expect(instance.westHemisphereGeometry).toBeDefined();
      expect(instance.westHemisphereGeometry.indices).toBeDefined();
      expect(instance.westHemisphereGeometry.indices.length).toEqual(6);
      expect(instance.westHemisphereGeometry.attributes.position).toBeDefined();
      expect(
        instance.westHemisphereGeometry.attributes.position.values.length
      ).toEqual(4 * 3);
      expect(
        instance.westHemisphereGeometry.attributes.nextPosition
      ).toBeDefined();
      expect(
        instance.westHemisphereGeometry.attributes.nextPosition.values.length
      ).toEqual(4 * 3);
      expect(
        instance.westHemisphereGeometry.attributes.prevPosition
      ).toBeDefined();
      expect(
        instance.westHemisphereGeometry.attributes.prevPosition.values.length
      ).toEqual(4 * 3);
      expect(
        instance.westHemisphereGeometry.attributes.expandAndWidth
      ).toBeDefined();
      expect(
        instance.westHemisphereGeometry.attributes.expandAndWidth.values.length
      ).toEqual(4 * 2);
      expect(instance.eastHemisphereGeometry).toBeDefined();
      expect(instance.eastHemisphereGeometry.indices).toBeDefined();
      expect(instance.eastHemisphereGeometry.indices.length).toEqual(6);
      expect(instance.eastHemisphereGeometry.attributes.position).toBeDefined();
      expect(
        instance.eastHemisphereGeometry.attributes.position.values.length
      ).toEqual(4 * 3);
      expect(
        instance.eastHemisphereGeometry.attributes.nextPosition
      ).toBeDefined();
      expect(
        instance.eastHemisphereGeometry.attributes.nextPosition.values.length
      ).toEqual(4 * 3);
      expect(
        instance.eastHemisphereGeometry.attributes.prevPosition
      ).toBeDefined();
      expect(
        instance.eastHemisphereGeometry.attributes.prevPosition.values.length
      ).toEqual(4 * 3);
      expect(
        instance.eastHemisphereGeometry.attributes.expandAndWidth
      ).toBeDefined();
      expect(
        instance.eastHemisphereGeometry.attributes.expandAndWidth.values.length
      ).toEqual(4 * 2);
    });
    it("returns offset wide line with first point on the IDL and the second is east", function() {
      const instance = new import__62.GeometryInstance({
        geometry: new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
                -1,
                0,
                0,
                -1,
                0,
                0,
                -1,
                1,
                2,
                -1,
                1,
                2
              ])
            }),
            nextPosition: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
                -1,
                1,
                2,
                -1,
                1,
                2,
                -1,
                2,
                3,
                -1,
                2,
                3
              ])
            }),
            prevPosition: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
                -1,
                -2,
                -1,
                -1,
                -2,
                -1,
                -1,
                0,
                0,
                -1,
                0,
                0
              ])
            }),
            expandAndWidth: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.FLOAT,
              componentsPerAttribute: 2,
              values: new Float32Array([
                -1,
                5,
                1,
                5,
                -1,
                -5,
                1,
                -5
              ])
            })
          },
          indices: new Uint16Array([0, 2, 1, 1, 2, 3]),
          primitiveType: import__62.PrimitiveType.TRIANGLES,
          geometryType: import__62.GeometryType.POLYLINES
        })
      });
      import__62.GeometryPipeline.splitLongitude(instance);
      const geometry = instance.geometry;
      expect(geometry.indices).toEqual([0, 2, 1, 1, 2, 3]);
      const positions = geometry.attributes.position.values;
      const nextPositions = geometry.attributes.nextPosition.values;
      const prevPositions = geometry.attributes.prevPosition.values;
      expect(positions).toEqual([
        -1,
        import__62.Math.EPSILON6,
        0,
        -1,
        import__62.Math.EPSILON6,
        0,
        -1,
        1,
        2,
        -1,
        1,
        2
      ]);
      expect(prevPositions).toEqual([
        -1,
        import__62.Math.EPSILON6,
        0,
        -1,
        import__62.Math.EPSILON6,
        0,
        -1,
        import__62.Math.EPSILON6,
        0,
        -1,
        import__62.Math.EPSILON6,
        0
      ]);
      expect(nextPositions).toEqual([
        -1,
        1,
        2,
        -1,
        1,
        2,
        -1,
        2,
        3,
        -1,
        2,
        3
      ]);
    });
    it("returns offset wide line with first point on the IDL and the second is west", function() {
      const instance = new import__62.GeometryInstance({
        geometry: new import__62.Geometry({
          attributes: {
            position: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
                -1,
                0,
                0,
                -1,
                0,
                0,
                -1,
                -1,
                2,
                -1,
                -1,
                2
              ])
            }),
            nextPosition: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
                -1,
                -1,
                2,
                -1,
                -1,
                2,
                -1,
                -2,
                0,
                -1,
                -2,
                0
              ])
            }),
            prevPosition: new import__62.GeometryAttribute({
              componentDatatype: import__62.ComponentDatatype.DOUBLE,
              componentsPerAttribute: 3,
              values: new Float64Array([
     