/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.versioning;

import java.util.Objects;

public final class VersionRange<T extends Comparable<T>> {
    private static final VersionRange<?> EMPTY = new VersionRange<Object>(null, null);
    private static final VersionRange<?> ALL = new VersionRange<Object>(null, null);
    private final T minimum;
    private final T maximum;

    public static <T extends Comparable<T>> VersionRange<T> empty() {
        return EMPTY;
    }

    public static <T extends Comparable<T>> VersionRange<T> all() {
        return ALL;
    }

    public static <T extends Comparable<T>> VersionRange<T> between(T minimum, T maximum) {
        assert (minimum.compareTo(maximum) <= 0);
        return new VersionRange<T>(minimum, maximum);
    }

    public static <T extends Comparable<T>> VersionRange<T> atLeast(T minimum) {
        assert (minimum != null);
        return new VersionRange<Object>(minimum, null);
    }

    public static <T extends Comparable<T>> VersionRange<T> atMost(T maximum) {
        assert (maximum != null);
        return new VersionRange<Object>(null, maximum);
    }

    private VersionRange(T minimum, T maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public T getMinimum() {
        return this.minimum;
    }

    public T getMaximum() {
        return this.maximum;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isAll() {
        return !this.isEmpty() && this.minimum == null && this.maximum == null;
    }

    public boolean contains(T versionNumber) {
        if (versionNumber == null) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (this.isAll()) {
            return true;
        }
        return !(this.minimum != null && this.minimum.compareTo(versionNumber) > 0 || this.maximum != null && this.maximum.compareTo(versionNumber) < 0);
    }

    public boolean isOverlappedBy(VersionRange<T> that) {
        if (this.isEmpty() || that.isEmpty()) {
            return false;
        }
        if (this.isAll() || that.isAll()) {
            return true;
        }
        if (this.minimum == null) {
            return that.minimum == null || that.minimum.compareTo(this.maximum) <= 0;
        }
        if (this.maximum == null) {
            return that.maximum == null || that.maximum.compareTo(this.minimum) >= 0;
        }
        return that.contains(this.minimum) || that.contains(this.maximum) || that.minimum != null && this.contains(that.minimum);
    }

    public VersionRange<T> intersectionWith(VersionRange<T> that) {
        T newMinimum;
        if (this.isAll()) {
            return that;
        }
        if (that.isAll()) {
            return this;
        }
        if (!this.isOverlappedBy(that)) {
            return VersionRange.empty();
        }
        if (this.minimum == null) {
            newMinimum = that.minimum;
        } else if (that.minimum == null) {
            newMinimum = this.minimum;
        } else {
            T t = newMinimum = this.minimum.compareTo(that.minimum) >= 0 ? this.minimum : that.minimum;
        }
        T newMaximum = this.maximum == null ? that.maximum : (that.maximum == null ? this.maximum : (this.maximum.compareTo(that.maximum) <= 0 ? this.maximum : that.maximum));
        return new VersionRange<T>(newMinimum, newMaximum);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 1121763849;
        }
        if (this.isAll()) {
            return -475303149;
        }
        return Objects.hash(this.minimum) ^ Objects.hash(this.maximum);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange that = (VersionRange)obj;
        return this.isEmpty() == that.isEmpty() && this.isAll() == that.isAll() && Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "EMPTY";
        }
        if (this.isAll()) {
            return "ALL";
        }
        if (this.minimum == null) {
            return "At most " + this.maximum;
        }
        if (this.maximum == null) {
            return "At least " + this.minimum;
        }
        return "[" + this.minimum + ".." + this.maximum + "]";
    }
}

