/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class CommandBuilder {
    private static final Pattern UNSTABLE_OPTION_PATTERN = Pattern.compile("-XX:(?<key>[a-zA-Z0-9]+)=(?<value>.*)");
    private static final Pattern UNSTABLE_BOOLEAN_OPTION_PATTERN = Pattern.compile("-XX:(?<value>[+\\-])(?<key>[a-zA-Z0-9]+)");
    private final OperatingSystem os;
    private final List<Item> raw = new ArrayList<Item>();

    public CommandBuilder() {
        this(OperatingSystem.CURRENT_OS);
    }

    public CommandBuilder(OperatingSystem os) {
        this.os = os;
    }

    private String parse(String s) {
        if (OperatingSystem.WINDOWS == this.os) {
            return CommandBuilder.toBatchStringLiteral(s);
        }
        return CommandBuilder.toShellStringLiteral(s);
    }

    public CommandBuilder add(String ... args) {
        for (String s : args) {
            this.raw.add(new Item(s, true));
        }
        return this;
    }

    public CommandBuilder addAll(Collection<String> args) {
        for (String s : args) {
            this.raw.add(new Item(s, true));
        }
        return this;
    }

    public CommandBuilder addWithoutParsing(String ... args) {
        for (String s : args) {
            this.raw.add(new Item(s, false));
        }
        return this;
    }

    public CommandBuilder addAllWithoutParsing(Collection<String> args) {
        for (String s : args) {
            this.raw.add(new Item(s, false));
        }
        return this;
    }

    public void addAllDefault(Collection<String> args) {
        this.addAllDefault(args, true);
    }

    public void addAllDefaultWithoutParsing(Collection<String> args) {
        this.addAllDefault(args, false);
    }

    private void addAllDefault(Collection<String> args, boolean parse) {
        block0: for (String arg : args) {
            if (arg.startsWith("-D")) {
                int idx = arg.indexOf(61);
                if (idx >= 0) {
                    this.addDefault(arg.substring(0, idx + 1), arg.substring(idx + 1), parse);
                    continue;
                }
                String opt = arg + "=";
                for (Item item : this.raw) {
                    if (item.arg.startsWith(opt)) {
                        Logging.LOG.info("Default option '" + arg + "' is suppressed by '" + item.arg + "'");
                        continue block0;
                    }
                    if (!item.arg.equals(arg)) continue;
                    continue block0;
                }
                this.raw.add(new Item(arg, parse));
                continue;
            }
            if (arg.startsWith("-XX:")) {
                Matcher matcher = UNSTABLE_OPTION_PATTERN.matcher(arg);
                if (matcher.matches()) {
                    this.addUnstableDefault(matcher.group("key"), matcher.group("value"), parse);
                    continue;
                }
                matcher = UNSTABLE_BOOLEAN_OPTION_PATTERN.matcher(arg);
                if (matcher.matches()) {
                    this.addUnstableDefault(matcher.group("key"), "+".equals(matcher.group("value")), parse);
                    continue;
                }
            }
            if (arg.startsWith("-X")) {
                String opt = null;
                String value = null;
                for (String prefix : new String[]{"-Xmx", "-Xms", "-Xmn", "-Xss"}) {
                    if (!arg.startsWith(prefix)) continue;
                    opt = prefix;
                    value = arg.substring(prefix.length());
                    break;
                }
                if (opt != null) {
                    this.addDefault(opt, value, parse);
                    continue;
                }
            }
            for (Item item : this.raw) {
                if (!item.arg.equals(arg)) continue;
                continue block0;
            }
            this.raw.add(new Item(arg, parse));
        }
    }

    public String addDefault(String opt, String value) {
        return this.addDefault(opt, value, true);
    }

    private String addDefault(String opt, String value, boolean parse) {
        for (Item item : this.raw) {
            if (!item.arg.startsWith(opt)) continue;
            Logging.LOG.info("Default option '" + opt + value + "' is suppressed by '" + item.arg + "'");
            return item.arg;
        }
        this.raw.add(new Item(opt + value, parse));
        return null;
    }

    public String addUnstableDefault(String opt, boolean value) {
        return this.addUnstableDefault(opt, value, true);
    }

    private String addUnstableDefault(String opt, boolean value, boolean parse) {
        for (Item item : this.raw) {
            Matcher matcher = UNSTABLE_BOOLEAN_OPTION_PATTERN.matcher(item.arg);
            if (!matcher.matches() || !matcher.group("key").equals(opt)) continue;
            return item.arg;
        }
        if (value) {
            this.raw.add(new Item("-XX:+" + opt, parse));
        } else {
            this.raw.add(new Item("-XX:-" + opt, parse));
        }
        return null;
    }

    public String addUnstableDefault(String opt, String value) {
        return this.addUnstableDefault(opt, value, true);
    }

    private String addUnstableDefault(String opt, String value, boolean parse) {
        for (Item item : this.raw) {
            Matcher matcher = UNSTABLE_OPTION_PATTERN.matcher(item.arg);
            if (!matcher.matches() || !matcher.group("key").equals(opt)) continue;
            return item.arg;
        }
        this.raw.add(new Item("-XX:" + opt + "=" + value, parse));
        return null;
    }

    public boolean removeIf(Predicate<String> pred) {
        return this.raw.removeIf((? super E i) -> pred.test(i.arg));
    }

    public boolean noneMatch(Predicate<String> predicate) {
        return this.raw.stream().noneMatch((? super T it) -> predicate.test(it.arg));
    }

    public String toString() {
        return this.raw.stream().map(i -> i.parse ? this.parse(i.arg) : i.arg).collect(Collectors.joining(" "));
    }

    public List<String> asList() {
        return this.raw.stream().map(i -> i.arg).collect(Collectors.toList());
    }

    public List<String> asMutableList() {
        return this.raw.stream().map(i -> i.arg).collect(Collectors.toCollection(ArrayList::new));
    }

    public static String pwshString(String str) {
        return "'" + str.replace("'", "''") + "'";
    }

    public static boolean hasExecutionPolicy() {
        boolean bl;
        if (OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS) {
            return true;
        }
        Process process = Runtime.getRuntime().exec(new String[]{"powershell", "-Command", "Get-ExecutionPolicy"});
        if (!process.waitFor(5L, TimeUnit.SECONDS)) {
            process.destroy();
            return false;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), OperatingSystem.NATIVE_CHARSET));
        try {
            String policy = reader.readLine();
            bl = "Unrestricted".equalsIgnoreCase(policy) || "RemoteSigned".equalsIgnoreCase(policy);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public static boolean setExecutionPolicy() {
        if (OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS) {
            return true;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"powershell", "-Command", "Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser"});
            if (!process.waitFor(5L, TimeUnit.SECONDS)) {
                process.destroy();
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private static boolean containsEscape(String str, String escapeChars) {
        for (int i = 0; i < escapeChars.length(); ++i) {
            if (str.indexOf(escapeChars.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    private static String escape(String str, char ... escapeChars) {
        for (char ch : escapeChars) {
            str = str.replace("" + ch, "\\" + ch);
        }
        return str;
    }

    public static String toBatchStringLiteral(String s) {
        return CommandBuilder.containsEscape(s, " \t\"^&<>|") ? '\"' + CommandBuilder.escape(s, '\\', '\"') + '\"' : s;
    }

    public static String toShellStringLiteral(String s) {
        return CommandBuilder.containsEscape(s, " \t\"!#$&'()*,;<=>?[\\]^`{|}~") ? '\"' + CommandBuilder.escape(s, '\"', '$', '&', '`') + '\"' : s;
    }

    private static class Item {
        final String arg;
        final boolean parse;

        Item(String arg, boolean parse) {
            this.arg = arg;
            this.parse = parse;
        }

        public String toString() {
            return this.parse ? (OperatingSystem.WINDOWS == OperatingSystem.CURRENT_OS ? CommandBuilder.toBatchStringLiteral(this.arg) : CommandBuilder.toShellStringLiteral(this.arg)) : this.arg;
        }
    }
}

