/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import com.google.gson.JsonParseException;
import fi.iki.elonen.NanoHTTPD;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public class HttpServer
extends NanoHTTPD {
    private int traceId = 0;
    protected final List<Route> routes = new ArrayList<Route>();

    public HttpServer(int port) {
        super(port);
    }

    public HttpServer(String hostname, int port) {
        super(hostname, port);
    }

    public String getRootUrl() {
        return "http://localhost:" + this.getListeningPort();
    }

    protected void addRoute(NanoHTTPD.Method method, Pattern path, ExceptionalFunction<Request, NanoHTTPD.Response, ?> server) {
        this.routes.add(new DefaultRoute(method, path, server));
    }

    protected static NanoHTTPD.Response ok(Object response) {
        Logging.LOG.info(String.format("Response %s", JsonUtils.GSON.toJson(response)));
        return HttpServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/json", JsonUtils.GSON.toJson(response));
    }

    protected static NanoHTTPD.Response notFound() {
        return HttpServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/html", "404 not found");
    }

    protected static NanoHTTPD.Response noContent() {
        return HttpServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NO_CONTENT, "text/html", "");
    }

    protected static NanoHTTPD.Response badRequest() {
        return HttpServer.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "text/html", "400 bad request");
    }

    protected static NanoHTTPD.Response internalError() {
        return HttpServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/html", "500 internal error");
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        int currentId = this.traceId++;
        Logging.LOG.info(String.format("[%d] %s --> %s", currentId, session.getMethod().name(), session.getUri() + Optional.ofNullable(session.getQueryParameterString()).map(s -> "?" + s).orElse("")));
        NanoHTTPD.Response response = null;
        for (Route route : this.routes) {
            Matcher pathMatcher;
            if (route.method != session.getMethod() || !(pathMatcher = route.pathPattern.matcher(session.getUri())).find()) continue;
            response = route.serve(new Request(pathMatcher, Lang.mapOf(NetworkUtils.parseQuery(session.getQueryParameterString())), session));
            break;
        }
        if (response == null) {
            response = HttpServer.notFound();
        }
        Logging.LOG.info(String.format("[%d] %s <--", currentId, response.getStatus()));
        return response;
    }

    public static class DefaultRoute
    extends Route {
        private final ExceptionalFunction<Request, NanoHTTPD.Response, ?> server;

        public DefaultRoute(NanoHTTPD.Method method, Pattern pathPattern, ExceptionalFunction<Request, NanoHTTPD.Response, ?> server) {
            super(method, pathPattern);
            this.server = server;
        }

        @Override
        public NanoHTTPD.Response serve(Request request) {
            try {
                return this.server.apply(request);
            }
            catch (JsonParseException e) {
                return HttpServer.badRequest();
            }
            catch (Exception e) {
                Logging.LOG.log(Level.SEVERE, "Error handling " + request.getSession().getUri(), e);
                return HttpServer.internalError();
            }
        }
    }

    public static abstract class Route {
        NanoHTTPD.Method method;
        Pattern pathPattern;

        public Route(NanoHTTPD.Method method, Pattern pathPattern) {
            this.method = method;
            this.pathPattern = pathPattern;
        }

        public NanoHTTPD.Method getMethod() {
            return this.method;
        }

        public Pattern getPathPattern() {
            return this.pathPattern;
        }

        public abstract NanoHTTPD.Response serve(Request var1);
    }

    public static class Request {
        Matcher pathVariables;
        Map<String, String> query;
        NanoHTTPD.IHTTPSession session;

        public Request(Matcher pathVariables, Map<String, String> query, NanoHTTPD.IHTTPSession session) {
            this.pathVariables = pathVariables;
            this.query = query;
            this.session = session;
        }

        public Matcher getPathVariables() {
            return this.pathVariables;
        }

        public Map<String, String> getQuery() {
            return this.query;
        }

        public NanoHTTPD.IHTTPSession getSession() {
            return this.session;
        }
    }
}

