/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.Renderer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class NativePatcher {
    private static final Library NONEXISTENT_LIBRARY = new Library(null);
    private static final Map<Platform, Map<String, Library>> natives = new HashMap<Platform, Map<String, Library>>();

    private NativePatcher() {
    }

    private static Map<String, Library> getNatives(Platform platform) {
        return natives.computeIfAbsent(platform, p -> {
            Map map;
            InputStreamReader reader = new InputStreamReader(NativePatcher.class.getResourceAsStream("/assets/natives.json"), StandardCharsets.UTF_8);
            try {
                Map natives = (Map)JsonUtils.GSON.fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Library>>>(){}.getType());
                map = natives.getOrDefault(p.toString(), Collections.emptyMap());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to load native library list", e);
                    return Collections.emptyMap();
                }
            }
            ((Reader)reader).close();
            return map;
        });
    }

    public static Version patchNative(Version version, String gameVersion, JavaVersion javaVersion, VersionSetting settings) {
        GameVersionNumber gameVersionNumber;
        if (settings.getNativesDirType() == NativesDirectoryType.CUSTOM) {
            if (gameVersion != null && GameVersionNumber.compare(gameVersion, "1.19") < 0) {
                return version;
            }
            ArrayList<Library> newLibraries = new ArrayList<Library>();
            for (Library library2 : version.getLibraries()) {
                if (!library2.appliesToCurrentEnvironment() || library2.getClassifier() != null && library2.getArtifactId().startsWith("lwjgl") && library2.getClassifier().startsWith("natives")) continue;
                newLibraries.add(library2);
            }
            return version.setLibraries(newLibraries);
        }
        boolean useNativeGLFW = settings.isUseNativeGLFW();
        boolean useNativeOpenAL = settings.isUseNativeOpenAL();
        if (OperatingSystem.CURRENT_OS.isLinuxOrBSD() && (useNativeGLFW || useNativeOpenAL) && GameVersionNumber.compare(gameVersion, "1.19") >= 0) {
            version = version.setLibraries(version.getLibraries().stream().filter(library -> {
                if (library.getClassifier() != null && library.getClassifier().startsWith("natives") && "org.lwjgl".equals(library.getGroupId()) && (useNativeGLFW && "lwjgl-glfw".equals(library.getArtifactId()) || useNativeOpenAL && "lwjgl-openal".equals(library.getArtifactId()))) {
                    Logging.LOG.info("Filter out " + library.getName());
                    return false;
                }
                return true;
            }).collect(Collectors.toList()));
        }
        OperatingSystem os = javaVersion.getPlatform().getOperatingSystem();
        Architecture arch = javaVersion.getArchitecture();
        GameVersionNumber gameVersionNumber2 = gameVersionNumber = gameVersion != null ? GameVersionNumber.asGameVersion(gameVersion) : null;
        if (settings.isNotPatchNatives()) {
            return version;
        }
        if (arch.isX86() && (os == OperatingSystem.WINDOWS || os == OperatingSystem.LINUX || os == OperatingSystem.OSX)) {
            return version;
        }
        if (arch == Architecture.ARM64 && (os == OperatingSystem.OSX || os == OperatingSystem.WINDOWS) && gameVersionNumber != null && gameVersionNumber.compareTo("1.19") >= 0) {
            return version;
        }
        Map<String, Library> replacements = NativePatcher.getNatives(javaVersion.getPlatform());
        if (replacements.isEmpty()) {
            Logging.LOG.warning("No alternative native library provided for platform " + javaVersion.getPlatform());
            return version;
        }
        ArrayList<Library> newLibraries = new ArrayList<Library>();
        for (Library library3 : version.getLibraries()) {
            Library replacement;
            if (!library3.appliesToCurrentEnvironment()) continue;
            if (library3.isNative()) {
                replacement = replacements.getOrDefault(library3.getName() + ":natives", NONEXISTENT_LIBRARY);
                if (replacement == NONEXISTENT_LIBRARY) {
                    Logging.LOG.warning("No alternative native library " + library3.getName() + " provided for platform " + javaVersion.getPlatform());
                    newLibraries.add(library3);
                    continue;
                }
                if (replacement == null) continue;
                newLibraries.add(replacement);
                continue;
            }
            replacement = replacements.getOrDefault(library3.getName(), NONEXISTENT_LIBRARY);
            if (replacement == NONEXISTENT_LIBRARY) {
                newLibraries.add(library3);
                continue;
            }
            if (replacement == null) continue;
            newLibraries.add(replacement);
        }
        return version.setLibraries(newLibraries);
    }

    public static Library getMesaLoader(JavaVersion javaVersion, Renderer renderer) {
        return NativePatcher.getNatives(javaVersion.getPlatform()).get(renderer == Renderer.LLVMPIPE ? "software-renderer-loader" : "mesa-loader");
    }
}

