/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.download.game.GameAssetDownloadTask;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.LauncherHelper;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.AuthlibInjectorServers;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.CreateAccountPane;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.ModpackInstallWizardProvider;
import org.jackhuang.hmcl.ui.export.ExportWizardProvider;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Versions {
    private Versions() {
    }

    public static void addNewGame() {
        Controllers.getDownloadPage().showGameDownloads();
        Controllers.navigate((Node)Controllers.getDownloadPage());
    }

    public static void importModpack() {
        Profile profile = Profiles.getSelectedProfile();
        if (profile.getRepository().isLoaded()) {
            Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(profile), I18n.i18n("install.modpack"));
        }
    }

    public static void downloadModpackImpl(Profile profile, String version, RemoteMod.Version file) {
        URL downloadURL;
        Path modpack;
        try {
            modpack = Files.createTempFile("modpack", ".zip", new FileAttribute[0]);
            downloadURL = new URL(file.getFile().getUrl());
        }
        catch (IOException e2) {
            Controllers.dialog(I18n.i18n("install.failed.downloading.detail", file.getFile().getUrl()) + "\n" + StringUtils.getStackTrace(e2), I18n.i18n("download.failed"), MessageDialogPane.MessageType.ERROR);
            return;
        }
        Controllers.taskDialog(new FileDownloadTask(downloadURL, modpack.toFile()).whenComplete(Schedulers.javafx(), e -> {
            if (e == null) {
                Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(profile, modpack.toFile()));
            } else if (e instanceof CancellationException) {
                Controllers.showToast(I18n.i18n("message.cancelled"));
            } else {
                Controllers.dialog(I18n.i18n("install.failed.downloading.detail", file.getFile().getUrl()) + "\n" + StringUtils.getStackTrace(e), I18n.i18n("download.failed"), MessageDialogPane.MessageType.ERROR);
            }
        }).executor(true), I18n.i18n("message.downloading"), TaskCancellationAction.NORMAL);
    }

    public static void deleteVersion(Profile profile, String version) {
        boolean isIndependent = profile.getVersionSetting(version).getGameDirType() == GameDirectoryType.VERSION_FOLDER;
        boolean isMovingToTrashSupported = FileUtils.isMovingToTrashSupported();
        String message = isIndependent ? I18n.i18n("version.manage.remove.confirm.independent", version) : (isMovingToTrashSupported ? I18n.i18n("version.manage.remove.confirm.trash", version, version + "_removed") : I18n.i18n("version.manage.remove.confirm", version));
        JFXButton deleteButton = new JFXButton(I18n.i18n("button.delete"));
        deleteButton.getStyleClass().add((Object)"dialog-error");
        deleteButton.setOnAction(e -> profile.getRepository().removeVersionFromDisk(version));
        Controllers.confirmAction(message, I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, (ButtonBase)deleteButton);
    }

    public static CompletableFuture<String> renameVersion(Profile profile, String version) {
        return Controllers.prompt(I18n.i18n("version.manage.rename.message"), (newName, resolve, reject) -> {
            if (!OperatingSystem.isNameValid(newName)) {
                reject.accept(I18n.i18n("install.new_game.malformed"));
                return;
            }
            if (profile.getRepository().renameVersion(version, (String)newName)) {
                resolve.run();
                profile.getRepository().refreshVersionsAsync().thenRunAsync(Schedulers.javafx(), () -> {
                    if (profile.getRepository().hasVersion((String)newName)) {
                        profile.setSelectedVersion((String)newName);
                    }
                }).start();
            } else {
                reject.accept(I18n.i18n("version.manage.rename.fail"));
            }
        }, version);
    }

    public static void exportVersion(Profile profile, String version) {
        Controllers.getDecorator().startWizard(new ExportWizardProvider(profile, version), I18n.i18n("modpack.wizard"));
    }

    public static void openFolder(Profile profile, String version) {
        FXUtils.openFolder(profile.getRepository().getRunDirectory(version));
    }

    public static void duplicateVersion(Profile profile, String version) {
        Controllers.prompt(new PromptDialogPane.Builder(I18n.i18n("version.manage.duplicate.prompt"), (res, resolve, reject) -> {
            String newVersionName = (String)((PromptDialogPane.Builder.StringQuestion)res.get(1)).getValue();
            boolean copySaves = (Boolean)((PromptDialogPane.Builder.BooleanQuestion)res.get(2)).getValue();
            Task.runAsync(() -> profile.getRepository().duplicateVersion(version, newVersionName, copySaves)).thenComposeAsync(profile.getRepository().refreshVersionsAsync()).whenComplete(Schedulers.javafx(), (result, exception) -> {
                if (exception == null) {
                    resolve.run();
                } else {
                    reject.accept(StringUtils.getStackTrace(exception));
                    profile.getRepository().removeVersionFromDisk(newVersionName);
                }
            }).start();
        }).addQuestion(new PromptDialogPane.Builder.HintQuestion(I18n.i18n("version.manage.duplicate.confirm"))).addQuestion(new PromptDialogPane.Builder.StringQuestion(null, version, new Validator(I18n.i18n("install.new_game.already_exists"), newVersionName -> !profile.getRepository().hasVersion((String)newVersionName)))).addQuestion(new PromptDialogPane.Builder.BooleanQuestion(I18n.i18n("version.manage.duplicate.duplicate_save"), false)));
    }

    public static void updateVersion(Profile profile, String version) {
        Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(profile, version));
    }

    public static void updateGameAssets(Profile profile, String version) {
        TaskExecutor executor = new GameAssetDownloadTask(profile.getDependency(), profile.getRepository().getVersion(version), true, true).executor();
        Controllers.taskDialog(executor, I18n.i18n("version.manage.redownload_assets_index"), TaskCancellationAction.NO_CANCEL);
        executor.start();
    }

    public static void cleanVersion(Profile profile, String id) {
        try {
            profile.getRepository().clean(id);
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Unable to clean game directory", e);
        }
    }

    public static void generateLaunchScript(Profile profile, String id) {
        if (!Versions.checkVersionForLaunching(profile, id)) {
            return;
        }
        Versions.ensureSelectedAccount(account -> {
            HMCLGameRepository repository = profile.getRepository();
            FileChooser chooser = new FileChooser();
            if (repository.getRunDirectory(id).isDirectory()) {
                chooser.setInitialDirectory(repository.getRunDirectory(id));
            }
            chooser.setTitle(I18n.i18n("version.launch_script.save"));
            chooser.getExtensionFilters().add((Object)(OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? new FileChooser.ExtensionFilter(I18n.i18n("extension.bat"), new String[]{"*.bat"}) : new FileChooser.ExtensionFilter(I18n.i18n("extension.sh"), new String[]{"*.sh"})));
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("extension.ps1"), new String[]{"*.ps1"}));
            File file = chooser.showSaveDialog((Window)Controllers.getStage());
            if (file != null) {
                new LauncherHelper(profile, (Account)account, id).makeLaunchScript(file);
            }
        });
    }

    public static void launch(Profile profile) {
        Versions.launch(profile, profile.getSelectedVersion());
    }

    public static void launch(Profile profile, String id) {
        Versions.launch(profile, id, null);
    }

    public static void launch(Profile profile, String id, Consumer<LauncherHelper> injecter) {
        if (!Versions.checkVersionForLaunching(profile, id)) {
            return;
        }
        Versions.ensureSelectedAccount(account -> {
            LauncherHelper launcherHelper = new LauncherHelper(profile, (Account)account, id);
            if (injecter != null) {
                injecter.accept(launcherHelper);
            }
            launcherHelper.launch();
        });
    }

    public static void testGame(Profile profile, String id) {
        Versions.launch(profile, id, LauncherHelper::setTestMode);
    }

    private static boolean checkVersionForLaunching(Profile profile, String id) {
        if (id == null || !profile.getRepository().isLoaded() || !profile.getRepository().hasVersion(id)) {
            Controllers.dialog(I18n.i18n("version.empty.launch"), I18n.i18n("launch.failed"), MessageDialogPane.MessageType.ERROR, () -> Controllers.navigate((Node)Controllers.getDownloadPage()));
            return false;
        }
        return true;
    }

    private static void ensureSelectedAccount(Consumer<Account> action) {
        Account account = Accounts.getSelectedAccount();
        if (!(!ConfigHolder.isNewlyCreated() || AuthlibInjectorServers.getServers().isEmpty() || account instanceof AuthlibInjectorAccount && AuthlibInjectorServers.getServers().contains(((AuthlibInjectorAccount)account).getServer()))) {
            CreateAccountPane dialog = new CreateAccountPane(AuthlibInjectorServers.getServers().iterator().next());
            dialog.addEventHandler(DialogCloseEvent.CLOSE, e -> {
                Account newAccount = Accounts.getSelectedAccount();
                if (newAccount != null) {
                    Platform.runLater(() -> action.accept(newAccount));
                }
            });
            Controllers.dialog((Region)dialog);
        } else if (account == null) {
            CreateAccountPane dialog = new CreateAccountPane();
            dialog.addEventHandler(DialogCloseEvent.CLOSE, e -> {
                Account newAccount = Accounts.getSelectedAccount();
                if (newAccount != null) {
                    Platform.runLater(() -> action.accept(newAccount));
                }
            });
            Controllers.dialog((Region)dialog);
        } else {
            action.accept(account);
        }
    }

    public static void modifyGlobalSettings(Profile profile) {
        Controllers.getSettingsPage().showGameSettings(profile);
        Controllers.navigate((Node)Controllers.getSettingsPage());
    }

    public static void modifyGameSettings(Profile profile, String version) {
        Controllers.getVersionPage().setVersion(version, profile);
        Controllers.navigate((Node)Controllers.getVersionPage());
    }
}

