/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public class InstallerListPage
extends ListPageBase<InstallerItem>
implements VersionPage.VersionLoadable {
    private Profile profile;
    private String versionId;
    private Version version;
    private String gameVersion;

    public InstallerListPage() {
        FXUtils.applyDragListener((Node)this, it -> Arrays.asList("jar", "exe").contains(FileUtils.getExtension(it)), mods -> {
            if (!mods.isEmpty()) {
                this.doInstallOffline((File)mods.get(0));
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new InstallerListPageSkin();
    }

    @Override
    public void loadVersion(Profile profile, String versionId) {
        this.profile = profile;
        this.versionId = versionId;
        this.version = profile.getRepository().getVersion(versionId);
        this.gameVersion = null;
        CompletableFuture.supplyAsync(() -> {
            this.gameVersion = profile.getRepository().getGameVersion(this.version).orElse(null);
            return LibraryAnalyzer.analyze(profile.getRepository().getResolvedPreservingPatchesVersion(versionId), this.gameVersion);
        }).thenAcceptAsync(analyzer -> {
            Function<String, Runnable> removeAction = libraryId -> () -> profile.getDependency().removeLibraryAsync(this.version, (String)libraryId).thenComposeAsync(profile.getRepository()::saveAsync).withComposeAsync(profile.getRepository().refreshVersionsAsync()).withRunAsync(Schedulers.javafx(), () -> this.loadVersion(this.profile, this.versionId)).start();
            this.itemsProperty().clear();
            InstallerItem.InstallerItemGroup group = new InstallerItem.InstallerItemGroup(this.gameVersion);
            for (InstallerItem installerItem : group.getLibraries()) {
                String libraryId2 = installerItem.getLibraryId();
                String libraryVersion = analyzer.getVersion(libraryId2).orElse(null);
                installerItem.libraryVersion.set((Object)libraryVersion);
                installerItem.upgradable.set(libraryVersion != null);
                installerItem.installable.set(true);
                installerItem.action.set(e -> Controllers.getDecorator().startWizard(new UpdateInstallerWizardProvider(profile, this.gameVersion, this.version, libraryId2, libraryVersion)));
                boolean removable = !LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId().equals(libraryId2) && libraryVersion != null;
                installerItem.removable.set(removable);
                if (removable) {
                    Runnable action = removeAction.apply(libraryId2);
                    installerItem.removeAction.set(e -> action.run());
                }
                this.itemsProperty().add((Object)installerItem);
            }
            for (LibraryAnalyzer.LibraryMark mark : analyzer) {
                String libraryId3 = mark.getLibraryId();
                String libraryVersion = mark.getLibraryVersion();
                if (LibraryAnalyzer.LibraryType.fromPatchId(libraryId3) != null) continue;
                Runnable action = removeAction.apply(libraryId3);
                InstallerItem installerItem = new InstallerItem(libraryId3);
                installerItem.libraryVersion.set((Object)libraryVersion);
                installerItem.installable.set(false);
                installerItem.upgradable.bind((ObservableValue)installerItem.installable);
                installerItem.removable.set(true);
                installerItem.removeAction.set(e -> action.run());
                if (libraryVersion != null && Lang.test(() -> profile.getDependency().getVersionList(libraryId3))) {
                    installerItem.installable.set(true);
                    installerItem.action.set(e -> Controllers.getDecorator().startWizard(new UpdateInstallerWizardProvider(profile, this.gameVersion, this.version, libraryId3, libraryVersion)));
                }
                this.itemsProperty().add((Object)installerItem);
            }
        }, Platform::runLater);
    }

    public void installOffline() {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("install.installer.install_offline.extension"), new String[]{"*.jar", "*.exe"}));
        File file = chooser.showOpenDialog((Window)Controllers.getStage());
        if (file != null) {
            this.doInstallOffline(file);
        }
    }

    private void doInstallOffline(File file) {
        Task<Void> task = this.profile.getDependency().installLibraryAsync(this.version, file.toPath()).thenComposeAsync(this.profile.getRepository()::saveAsync).thenComposeAsync(this.profile.getRepository().refreshVersionsAsync());
        task.setName(I18n.i18n("install.installer.install_offline"));
        TaskExecutor executor = task.executor(new TaskListener(){

            @Override
            public void onStop(boolean success, TaskExecutor executor) {
                FXUtils.runInFX(() -> {
                    if (success) {
                        InstallerListPage.this.loadVersion(InstallerListPage.this.profile, InstallerListPage.this.versionId);
                        Controllers.dialog(I18n.i18n("install.success"));
                    } else {
                        if (executor.getException() == null) {
                            return;
                        }
                        UpdateInstallerWizardProvider.alertFailureMessage(executor.getException(), null);
                    }
                });
            }
        });
        Controllers.taskDialog(executor, I18n.i18n("install.installer.install_offline"), TaskCancellationAction.NO_CANCEL);
        executor.start();
    }

    private class InstallerListPageSkin
    extends ToolbarListPageSkin<InstallerListPage> {
        InstallerListPageSkin() {
            super(InstallerListPage.this);
        }

        @Override
        protected List<Node> initializeToolbar(InstallerListPage skinnable) {
            return Collections.singletonList(InstallerListPageSkin.createToolbarButton2(I18n.i18n("install.installer.install_offline"), SVG.PLUS, skinnable::installOffline));
        }
    }
}

