/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.GameItem;
import org.jackhuang.hmcl.util.StringUtils;

public class GameItemSkin
extends SkinBase<GameItem> {
    public GameItemSkin(GameItem skinnable) {
        super((Control)skinnable);
        HBox center = new HBox();
        center.setSpacing(8.0);
        center.setAlignment(Pos.CENTER_LEFT);
        StackPane imageViewContainer = new StackPane();
        FXUtils.setLimitWidth((Region)imageViewContainer, 32.0);
        FXUtils.setLimitHeight((Region)imageViewContainer, 32.0);
        ImageView imageView = new ImageView();
        FXUtils.limitSize(imageView, 32.0, 32.0);
        imageView.imageProperty().bind(skinnable.imageProperty());
        imageViewContainer.getChildren().setAll((Object[])new Node[]{imageView});
        TwoLineListItem item = new TwoLineListItem();
        item.titleProperty().bind((ObservableValue)skinnable.titleProperty());
        FXUtils.onChangeAndOperate(skinnable.tagProperty(), tag -> {
            if (StringUtils.isNotBlank(tag)) {
                item.getTags().setAll((Object[])new String[]{tag});
            } else {
                item.getTags().clear();
            }
        });
        item.subtitleProperty().bind((ObservableValue)skinnable.subtitleProperty());
        BorderPane.setAlignment((Node)item, (Pos)Pos.CENTER);
        center.getChildren().setAll((Object[])new Node[]{imageView, item});
        this.getChildren().setAll((Object[])new Node[]{center});
    }
}

