/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXSpinner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.fabric.FabricAPIRemoteVersion;
import org.jackhuang.hmcl.download.fabric.FabricRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.neoforge.NeoForgeRemoteVersion;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.download.quilt.QuiltAPIRemoteVersion;
import org.jackhuang.hmcl.download.quilt.QuiltRemoteVersion;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.IconedTwoLineListItem;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.HMCLService;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class VersionsPage
extends BorderPane
implements WizardPage,
Refreshable {
    private final String gameVersion;
    private final String libraryId;
    private final String title;
    private final Navigation navigation;
    private final JFXListView<RemoteVersion> list;
    private final JFXSpinner spinner;
    private final StackPane failedPane;
    private final StackPane emptyPane;
    private final TransitionPane root;
    private final JFXCheckBox chkRelease;
    private final JFXCheckBox chkSnapshot;
    private final JFXCheckBox chkOld;
    private final JFXButton btnRefresh;
    private final HBox checkPane;
    private final ComponentList centrePane;
    private final StackPane center;
    private final VersionList<?> versionList;
    private CompletableFuture<?> executor;

    public VersionsPage(Navigation navigation, String title, String gameVersion, DownloadProvider downloadProvider, String libraryId, Runnable callback) {
        this.title = title;
        this.gameVersion = gameVersion;
        this.libraryId = libraryId;
        this.navigation = navigation;
        HintPane hintPane = new HintPane();
        hintPane.setText(I18n.i18n("sponsor.bmclapi"));
        hintPane.getStyleClass().add((Object)"sponsor-pane");
        hintPane.setOnMouseClicked(e -> this.onSponsor());
        BorderPane.setMargin((Node)hintPane, (Insets)new Insets(10.0, 10.0, 0.0, 10.0));
        this.setTop((Node)hintPane);
        this.root = new TransitionPane();
        this.spinner = new JFXSpinner();
        this.center = new StackPane();
        this.center.setStyle("-fx-padding: 10;");
        this.centrePane = new ComponentList();
        this.centrePane.getStyleClass().add((Object)"no-padding");
        this.checkPane = new HBox();
        this.checkPane.setSpacing(10.0);
        this.chkRelease = new JFXCheckBox(I18n.i18n("version.game.releases"));
        this.chkRelease.setSelected(true);
        HBox.setMargin((Node)this.chkRelease, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        this.chkSnapshot = new JFXCheckBox(I18n.i18n("version.game.snapshots"));
        HBox.setMargin((Node)this.chkSnapshot, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        this.chkOld = new JFXCheckBox(I18n.i18n("version.game.old"));
        HBox.setMargin((Node)this.chkOld, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        HBox pane = new HBox();
        HBox.setHgrow((Node)pane, (Priority)Priority.ALWAYS);
        this.btnRefresh = new JFXButton(I18n.i18n("button.refresh"));
        this.btnRefresh.getStyleClass().add((Object)"jfx-tool-bar-button");
        this.btnRefresh.setOnAction(e -> this.onRefresh());
        this.checkPane.getChildren().setAll((Object[])new Node[]{this.chkRelease, this.chkSnapshot, this.chkOld, pane, this.btnRefresh});
        this.list = new JFXListView();
        this.list.getStyleClass().add((Object)"jfx-list-view-float");
        VBox.setVgrow(this.list, (Priority)Priority.ALWAYS);
        this.centrePane.getContent().setAll((Object[])new Node[]{this.checkPane, this.list});
        this.center.getChildren().setAll((Object[])new Node[]{this.centrePane});
        this.failedPane = new StackPane();
        this.failedPane.getStyleClass().add((Object)"notice-pane");
        Label label = new Label(I18n.i18n("download.failed.refresh"));
        label.setOnMouseClicked(e -> this.onRefresh());
        this.failedPane.getChildren().setAll((Object[])new Node[]{label});
        this.emptyPane = new StackPane();
        this.emptyPane.getStyleClass().add((Object)"notice-pane");
        label = new Label(I18n.i18n("download.failed.empty"));
        label.setOnMouseClicked(e -> this.onBack());
        this.emptyPane.getChildren().setAll((Object[])new Node[]{label});
        this.setCenter((Node)this.root);
        this.versionList = downloadProvider.getVersionListById(libraryId);
        if (this.versionList.hasType()) {
            this.centrePane.getContent().setAll((Object[])new Node[]{this.checkPane, this.list});
        } else {
            this.centrePane.getContent().setAll((Object[])new Node[]{this.list});
        }
        ComponentList.setVgrow(this.list, Priority.ALWAYS);
        InvalidationListener listener = o -> this.list.getItems().setAll(this.loadVersions());
        this.chkRelease.selectedProperty().addListener(listener);
        this.chkSnapshot.selectedProperty().addListener(listener);
        this.chkOld.selectedProperty().addListener(listener);
        this.btnRefresh.setGraphic(ToolbarListPageSkin.wrap(SVG.REFRESH.createIcon((Paint)Theme.blackFill(), -1.0, -1.0)));
        Holder lastCell = new Holder();
        this.list.setCellFactory(listView -> new RemoteVersionListCell(lastCell));
        this.list.setOnMouseClicked(e -> {
            if (this.list.getSelectionModel().getSelectedIndex() < 0) {
                return;
            }
            navigation.getSettings().put(libraryId, this.list.getSelectionModel().getSelectedItem());
            callback.run();
        });
        this.refresh();
    }

    private List<RemoteVersion> loadVersions() {
        return this.versionList.getVersions(this.gameVersion).stream().filter(it -> {
            switch (it.getVersionType()) {
                case RELEASE: {
                    return this.chkRelease.isSelected();
                }
                case SNAPSHOT: {
                    return this.chkSnapshot.isSelected();
                }
                case OLD: {
                    return this.chkOld.isSelected();
                }
            }
            return true;
        }).sorted().collect(Collectors.toList());
    }

    @Override
    public void refresh() {
        VersionList<?> currentVersionList = this.versionList;
        this.root.setContent((Node)this.spinner, ContainerAnimations.FADE.getAnimationProducer());
        this.executor = currentVersionList.refreshAsync(this.gameVersion).whenComplete((result, exception) -> {
            if (exception == null) {
                List<RemoteVersion> items = this.loadVersions();
                Platform.runLater(() -> {
                    if (this.versionList != currentVersionList) {
                        return;
                    }
                    if (currentVersionList.getVersions(this.gameVersion).isEmpty()) {
                        this.root.setContent((Node)this.emptyPane, ContainerAnimations.FADE.getAnimationProducer());
                    } else {
                        if (items.isEmpty()) {
                            this.chkRelease.setSelected(true);
                            this.chkSnapshot.setSelected(true);
                            this.chkOld.setSelected(true);
                        } else {
                            this.list.getItems().setAll((Collection)items);
                        }
                        this.root.setContent((Node)this.center, ContainerAnimations.FADE.getAnimationProducer());
                    }
                });
            } else {
                Logging.LOG.log(Level.WARNING, "Failed to fetch versions list", (Throwable)exception);
                Platform.runLater(() -> {
                    if (this.versionList != currentVersionList) {
                        return;
                    }
                    this.root.setContent((Node)this.failedPane, ContainerAnimations.FADE.getAnimationProducer());
                });
            }
            System.gc();
        });
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(this.libraryId);
        if (this.executor != null) {
            this.executor.cancel(true);
        }
    }

    private void onRefresh() {
        this.refresh();
    }

    private void onBack() {
        this.navigation.onPrev(true);
    }

    private void onSponsor() {
        HMCLService.openRedirectLink("bmclapi_sponsor");
    }

    private static class RemoteVersionListCell
    extends ListCell<RemoteVersion> {
        final IconedTwoLineListItem content = new IconedTwoLineListItem();
        final RipplerContainer ripplerContainer = new RipplerContainer((Node)this.content);
        final StackPane pane = new StackPane();
        private final Holder<RemoteVersionListCell> lastCell;

        RemoteVersionListCell(Holder<RemoteVersionListCell> lastCell) {
            this.lastCell = lastCell;
            this.pane.getStyleClass().add((Object)"md-list-cell");
            StackPane.setMargin((Node)this.content, (Insets)new Insets(10.0, 16.0, 10.0, 16.0));
            this.pane.getChildren().setAll((Object[])new Node[]{this.ripplerContainer});
        }

        public void updateItem(RemoteVersion remoteVersion, boolean empty) {
            super.updateItem((Object)remoteVersion, empty);
            if (this == this.lastCell.value && !this.isVisible()) {
                return;
            }
            this.lastCell.value = this;
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.setGraphic((Node)this.pane);
            this.content.setTitle(remoteVersion.getSelfVersion());
            if (remoteVersion.getReleaseDate() != null) {
                this.content.setSubtitle(I18n.formatDateTime(remoteVersion.getReleaseDate()));
            } else {
                this.content.setSubtitle(null);
            }
            if (remoteVersion instanceof GameRemoteVersion) {
                switch (remoteVersion.getVersionType()) {
                    case RELEASE: {
                        this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.release")});
                        this.content.setImage(VersionIconType.GRASS.getIcon());
                        break;
                    }
                    case SNAPSHOT: {
                        this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.snapshot")});
                        this.content.setImage(VersionIconType.COMMAND.getIcon());
                        break;
                    }
                    default: {
                        this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.old")});
                        this.content.setImage(VersionIconType.CRAFT_TABLE.getIcon());
                        break;
                    }
                }
            } else {
                VersionIconType iconType = remoteVersion instanceof LiteLoaderRemoteVersion ? VersionIconType.CHICKEN : (remoteVersion instanceof OptiFineRemoteVersion ? VersionIconType.OPTIFINE : (remoteVersion instanceof ForgeRemoteVersion ? VersionIconType.FORGE : (remoteVersion instanceof NeoForgeRemoteVersion ? VersionIconType.NEO_FORGE : (remoteVersion instanceof FabricRemoteVersion || remoteVersion instanceof FabricAPIRemoteVersion ? VersionIconType.FABRIC : (remoteVersion instanceof QuiltRemoteVersion || remoteVersion instanceof QuiltAPIRemoteVersion ? VersionIconType.QUILT : null)))));
                this.content.setImage(iconType != null ? iconType.getIcon() : null);
                if (this.content.getSubtitle() == null) {
                    this.content.setSubtitle(remoteVersion.getGameVersion());
                } else {
                    this.content.getTags().setAll((Object[])new String[]{remoteVersion.getGameVersion()});
                }
            }
        }
    }
}

