/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.validation.base.ValidatorBase;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.ModpackPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class RemoteModpackPage
extends ModpackPage {
    private final ServerModpackManifest manifest;
    public static final String MODPACK_SERVER_MANIFEST = "MODPACK_SERVER_MANIFEST";
    public static final String MODPACK_NAME = "MODPACK_NAME";
    public static final String MODPACK_MANIFEST = "MODPACK_MANIFEST";

    public RemoteModpackPage(WizardController controller) {
        super(controller);
        this.manifest = Lang.tryCast(controller.getSettings().get(MODPACK_SERVER_MANIFEST), ServerModpackManifest.class).orElseThrow(() -> new IllegalStateException("MODPACK_SERVER_MANIFEST should exist"));
        this.lblModpackLocation.setText(this.manifest.getFileApi());
        try {
            controller.getSettings().put(MODPACK_MANIFEST, this.manifest.toModpack(null));
        }
        catch (IOException e) {
            Controllers.dialog(I18n.i18n("modpack.type.server.malformed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            Platform.runLater(controller::onEnd);
            return;
        }
        this.lblName.setText(this.manifest.getName());
        this.lblVersion.setText(this.manifest.getVersion());
        this.lblAuthor.setText(this.manifest.getAuthor());
        Profile profile = (Profile)controller.getSettings().get("PROFILE");
        Optional<String> name = Lang.tryCast(controller.getSettings().get(MODPACK_NAME), String.class);
        if (name.isPresent()) {
            this.txtModpackName.setText(name.get());
            this.txtModpackName.setDisable(true);
        } else {
            this.txtModpackName.setText(this.manifest.getName().trim());
            this.txtModpackName.getValidators().addAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !profile.getRepository().versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
        }
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(MODPACK_SERVER_MANIFEST);
    }

    @Override
    protected void onInstall() {
        if (!this.txtModpackName.validate()) {
            return;
        }
        this.controller.getSettings().put(MODPACK_NAME, this.txtModpackName.getText());
        this.controller.onFinish();
    }

    @Override
    protected void onDescribe() {
        FXUtils.showWebDialog(I18n.i18n("modpack.description"), this.manifest.getDescription());
    }
}

