/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.animation;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationHandler;
import org.jackhuang.hmcl.ui.animation.AnimationProducer;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;

public class TransitionPane
extends StackPane
implements AnimationHandler {
    private Duration duration;
    private Node previousNode;
    private Node currentNode = this.getChildren().stream().findFirst().orElse(null);
    private final EmptyPane EMPTY_PANE;

    public TransitionPane() {
        FXUtils.setOverflowHidden((Region)this);
        this.EMPTY_PANE = new EmptyPane();
    }

    @Override
    public Node getPreviousNode() {
        return this.previousNode;
    }

    @Override
    public Node getCurrentNode() {
        return this.currentNode;
    }

    public StackPane getCurrentRoot() {
        return this;
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    public void setContent(Node newView, AnimationProducer transition) {
        this.setContent(newView, transition, Duration.millis((double)160.0));
    }

    public void setContent(Node newView, AnimationProducer transition, Duration duration) {
        this.duration = duration;
        this.updateContent(newView);
        if (this.previousNode == this.EMPTY_PANE) {
            this.setMouseTransparent(false);
            this.getChildren().setAll((Object[])new Node[]{newView});
            return;
        }
        if (AnimationUtils.isAnimationEnabled()) {
            transition.init(this);
            Platform.runLater(() -> {
                Timeline newAnimation = new Timeline();
                newAnimation.getKeyFrames().addAll(transition.animate(this));
                newAnimation.getKeyFrames().add((Object)new KeyFrame(duration, e -> {
                    this.setMouseTransparent(false);
                    this.getChildren().remove((Object)this.previousNode);
                }, new KeyValue[0]));
                FXUtils.playAnimation((Node)this, "transition_pane", newAnimation);
            });
        } else {
            this.setMouseTransparent(false);
            this.getChildren().remove((Object)this.previousNode);
        }
    }

    private void updateContent(Node newView) {
        if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
            this.previousNode = this.currentNode;
            if (this.previousNode == null) {
                this.previousNode = this.EMPTY_PANE;
            }
        } else {
            this.previousNode = this.EMPTY_PANE;
        }
        if (this.previousNode == newView) {
            this.previousNode = this.EMPTY_PANE;
        }
        this.setMouseTransparent(true);
        this.currentNode = newView;
        this.getChildren().setAll((Object[])new Node[]{this.previousNode, this.currentNode});
    }

    public static class EmptyPane
    extends StackPane {
    }
}

