/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.mod.MismatchedModpackTypeException;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackProvider;
import org.jackhuang.hmcl.mod.ModpackUpdateTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCInstanceConfiguration;
import org.jackhuang.hmcl.mod.multimc.MultiMCManifest;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackInstallTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class MultiMCModpackProvider
implements ModpackProvider {
    public static final MultiMCModpackProvider INSTANCE = new MultiMCModpackProvider();

    @Override
    public String getName() {
        return "MultiMC";
    }

    @Override
    public Task<?> createCompletionTask(DefaultDependencyManager dependencyManager, String version) {
        return null;
    }

    @Override
    public Task<?> createUpdateTask(DefaultDependencyManager dependencyManager, String name, File zipFile, Modpack modpack) throws MismatchedModpackTypeException {
        if (!(modpack.getManifest() instanceof MultiMCInstanceConfiguration)) {
            throw new MismatchedModpackTypeException(this.getName(), modpack.getManifest().getProvider().getName());
        }
        return new ModpackUpdateTask(dependencyManager.getGameRepository(), name, new MultiMCModpackInstallTask(dependencyManager, zipFile, modpack, (MultiMCInstanceConfiguration)modpack.getManifest(), name));
    }

    private static boolean testPath(Path root) {
        return Files.exists(root.resolve("instance.cfg"), new LinkOption[0]);
    }

    public static Path getRootPath(Path root) throws IOException {
        if (MultiMCModpackProvider.testPath(root)) {
            return root;
        }
        try (Stream<Path> stream = Files.list(root);){
            Path candidate = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findAny().orElseThrow(() -> new IOException("Not a valid MultiMC modpack"));
            if (MultiMCModpackProvider.testPath(candidate)) {
                Path path = candidate;
                return path;
            }
            throw new IOException("Not a valid MultiMC modpack");
        }
    }

    private static String getRootEntryName(ZipFile file) throws IOException {
        String instanceFileName = "instance.cfg";
        if (file.getEntry("instance.cfg") != null) {
            return "";
        }
        Enumeration<ZipArchiveEntry> entries = file.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            String entryName = entry.getName();
            int idx = entryName.indexOf(47);
            if (idx < 0 || entryName.length() != idx + "instance.cfg".length() + 1 || !entryName.startsWith("instance.cfg", idx + 1)) continue;
            return entryName.substring(0, idx + 1);
        }
        throw new IOException("Not a valid MultiMC modpack");
    }

    @Override
    public Modpack readManifest(ZipFile modpackFile, Path modpackPath, Charset encoding) throws IOException {
        String rootEntryName = MultiMCModpackProvider.getRootEntryName(modpackFile);
        MultiMCManifest manifest = MultiMCManifest.readMultiMCModpackManifest(modpackFile, rootEntryName);
        String name = rootEntryName.isEmpty() ? FileUtils.getNameWithoutExtension(modpackPath) : rootEntryName.substring(0, rootEntryName.length() - 1);
        ZipArchiveEntry instanceEntry = modpackFile.getEntry(rootEntryName + "instance.cfg");
        if (instanceEntry == null) {
            throw new IOException("`instance.cfg` not found, " + modpackFile + " is not a valid MultiMC modpack.");
        }
        try (InputStream instanceStream = modpackFile.getInputStream(instanceEntry);){
            final MultiMCInstanceConfiguration cfg = new MultiMCInstanceConfiguration(name, instanceStream, manifest);
            Modpack modpack = new Modpack(cfg.getName(), "", "", cfg.getGameVersion(), cfg.getNotes(), encoding, cfg){

                @Override
                public Task<?> getInstallTask(DefaultDependencyManager dependencyManager, File zipFile, String name) {
                    return new MultiMCModpackInstallTask(dependencyManager, zipFile, this, cfg, name);
                }
            };
            return modpack;
        }
    }
}

