/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.mcbbs;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.curse.CurseMetaMod;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackManifest;
import org.jackhuang.hmcl.task.CompletableFutureTask;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskCompletableFuture;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class McbbsModpackCompletionTask
extends CompletableFutureTask<Void> {
    private final DefaultDependencyManager dependency;
    private final DefaultGameRepository repository;
    private final ModManager modManager;
    private final String version;
    private final File configurationFile;
    private ModpackConfiguration<McbbsModpackManifest> configuration;
    private McbbsModpackManifest manifest;
    private final List<Task<?>> dependencies = new ArrayList();
    private final AtomicBoolean allNameKnown = new AtomicBoolean(true);
    private final AtomicInteger finished = new AtomicInteger(0);
    private final AtomicBoolean notFound = new AtomicBoolean(false);

    public McbbsModpackCompletionTask(DefaultDependencyManager dependencyManager, String version) {
        this(dependencyManager, version, null);
    }

    public McbbsModpackCompletionTask(DefaultDependencyManager dependencyManager, String version, ModpackConfiguration<McbbsModpackManifest> configuration) {
        this.dependency = dependencyManager;
        this.repository = dependencyManager.getGameRepository();
        this.modManager = this.repository.getModManager(version);
        this.version = version;
        this.configurationFile = this.repository.getModpackConfiguration(version);
        this.configuration = configuration;
        this.setStage("hmcl.modpack.download");
    }

    @Override
    public CompletableFuture<Void> getFuture(TaskCompletableFuture executor) {
        return McbbsModpackCompletionTask.breakable(((CompletableFuture)CompletableFuture.runAsync(Lang.wrap(() -> {
            if (this.configuration == null) {
                try {
                    this.configuration = (ModpackConfiguration)JsonUtils.fromNonNullJson(FileUtils.readText(this.configurationFile), new TypeToken<ModpackConfiguration<McbbsModpackManifest>>(){}.getType());
                }
                catch (JsonParseException | IOException e) {
                    throw new IOException("Malformed modpack configuration");
                }
            }
            this.manifest = this.configuration.getManifest();
            if (this.manifest == null) {
                throw new CompletableFutureTask.CustomException();
            }
        })).thenComposeAsync((T unused) -> McbbsModpackCompletionTask.breakable(((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(Lang.wrap(() -> {
            if (StringUtils.isBlank(this.manifest.getFileApi())) {
                throw new CompletableFutureTask.CustomException();
            }
        })).thenComposeAsync(Lang.wrap(unused1 -> executor.one(new GetTask(new URL(this.manifest.getFileApi() + "/manifest.json")))))).thenComposeAsync(Lang.wrap(remoteManifestJson -> {
            Path actualPath;
            McbbsModpackManifest remoteManifest;
            try {
                remoteManifest = JsonUtils.fromNonNullJson(remoteManifestJson, McbbsModpackManifest.class);
            }
            catch (JsonParseException e) {
                throw new IOException("Unable to parse server manifest.json from " + this.manifest.getFileApi(), e);
            }
            Path rootPath = this.repository.getVersionRoot(this.version).toPath();
            Map localFiles = this.manifest.getFiles().stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
            ArrayList<McbbsModpackManifest.File> newFiles = new ArrayList<McbbsModpackManifest.File>(remoteManifest.getFiles().size());
            ArrayList tasks = new ArrayList();
            for (McbbsModpackManifest.File file : remoteManifest.getFiles()) {
                actualPath = this.getFilePath(file);
                McbbsModpackManifest.File oldFile = (McbbsModpackManifest.File)localFiles.remove(file);
                boolean download = false;
                if (oldFile == null) {
                    download = true;
                } else if (actualPath != null) {
                    if (!Files.exists(actualPath, new LinkOption[0])) {
                        download = true;
                    } else if (this.getFileHash(file) != null) {
                        String fileHash = DigestUtils.digestToString("SHA-1", actualPath);
                        String oldHash = this.getFileHash(oldFile);
                        String newHash = this.getFileHash(file);
                        if (oldHash == null) {
                            download = true;
                        } else if (!Objects.equals(fileHash, newHash)) {
                            if (file.isForce()) {
                                download = true;
                            } else if (Objects.equals(oldHash, fileHash)) {
                                download = true;
                            }
                        }
                    }
                }
                if (download) {
                    tasks.add(this.downloadFile(remoteManifest, file));
                }
                newFiles.add(this.mergeFile(oldFile, file));
            }
            for (McbbsModpackManifest.File file : localFiles.keySet()) {
                actualPath = this.getFilePath(file);
                if (actualPath == null || !Files.exists(actualPath, new LinkOption[0])) continue;
                Files.deleteIfExists(actualPath);
            }
            this.manifest = remoteManifest.setFiles(newFiles);
            return executor.all(tasks.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }))).thenAcceptAsync(Lang.wrapConsumer(unused1 -> {
            File manifestFile = this.repository.getModpackConfiguration(this.version);
            FileUtils.writeText(manifestFile, JsonUtils.GSON.toJson(new ModpackConfiguration<McbbsModpackManifest>(this.manifest, this.configuration.getType(), this.manifest.getName(), this.manifest.getVersion(), this.manifest.getFiles().stream().flatMap(file -> file instanceof McbbsModpackManifest.AddonFile ? Stream.of((McbbsModpackManifest.AddonFile)file) : Stream.empty()).map(file -> new ModpackConfiguration.FileInformation(file.getPath(), file.getHash())).collect(Collectors.toList()))));
        }))))).thenComposeAsync((T unused) -> {
            AtomicBoolean allNameKnown = new AtomicBoolean(true);
            AtomicInteger finished = new AtomicInteger(0);
            AtomicBoolean notFound = new AtomicBoolean(false);
            return McbbsModpackCompletionTask.breakable(((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(Lang.wrap(unused1 -> {
                McbbsModpackManifest newManifest;
                ArrayList dependencies = new ArrayList();
                this.manifest = newManifest = this.manifest.setFiles(this.manifest.getFiles().parallelStream().map(rawFile -> {
                    this.updateProgress(finished.incrementAndGet(), this.manifest.getFiles().size());
                    if (rawFile instanceof McbbsModpackManifest.CurseFile) {
                        McbbsModpackManifest.CurseFile file = (McbbsModpackManifest.CurseFile)rawFile;
                        if (StringUtils.isBlank(file.getFileName())) {
                            try {
                                return file.withFileName(NetworkUtils.detectFileName(file.getUrl()));
                            }
                            catch (IOException e) {
                                try {
                                    String result = NetworkUtils.doGet(NetworkUtils.toURL(String.format("https://cursemeta.dries007.net/%d/%d.json", file.getProjectID(), file.getFileID())));
                                    CurseMetaMod mod = JsonUtils.fromNonNullJson(result, CurseMetaMod.class);
                                    return file.withFileName(mod.getFileNameOnDisk()).withURL(mod.getDownloadURL());
                                }
                                catch (FileNotFoundException fof) {
                                    Logging.LOG.log(Level.WARNING, "Could not query cursemeta for deleted mods: " + file.getUrl(), fof);
                                    notFound.set(true);
                                    return file;
                                }
                                catch (JsonParseException | IOException e2) {
                                    try {
                                        String result = NetworkUtils.doGet(NetworkUtils.toURL(String.format("https://addons-ecs.forgesvc.net/api/v2/addon/%d/file/%d", file.getProjectID(), file.getFileID())));
                                        CurseMetaMod mod = JsonUtils.fromNonNullJson(result, CurseMetaMod.class);
                                        return file.withFileName(mod.getFileName()).withURL(mod.getDownloadURL());
                                    }
                                    catch (FileNotFoundException fof) {
                                        Logging.LOG.log(Level.WARNING, "Could not query forgesvc for deleted mods: " + file.getUrl(), fof);
                                        notFound.set(true);
                                        return file;
                                    }
                                    catch (JsonParseException | IOException e3) {
                                        Logging.LOG.log(Level.WARNING, "Unable to fetch the file name of URL: " + file.getUrl(), e);
                                        Logging.LOG.log(Level.WARNING, "Unable to fetch the file name of URL: " + file.getUrl(), e2);
                                        Logging.LOG.log(Level.WARNING, "Unable to fetch the file name of URL: " + file.getUrl(), e3);
                                        allNameKnown.set(false);
                                        return file;
                                    }
                                }
                            }
                        }
                        return file;
                    }
                    return rawFile;
                }).collect(Collectors.toList()));
                this.configuration = this.configuration.setManifest(newManifest);
                FileUtils.writeText(this.configurationFile, JsonUtils.GSON.toJson(this.configuration));
                for (McbbsModpackManifest.File file : newManifest.getFiles()) {
                    McbbsModpackManifest.CurseFile curseFile;
                    if (!(file instanceof McbbsModpackManifest.CurseFile) || !StringUtils.isNotBlank((curseFile = (McbbsModpackManifest.CurseFile)file).getFileName()) || this.modManager.hasSimpleMod(curseFile.getFileName())) continue;
                    FileDownloadTask task = new FileDownloadTask(curseFile.getUrl(), this.modManager.getSimpleModPath(curseFile.getFileName()).toFile());
                    task.setCacheRepository(this.dependency.getCacheRepository());
                    task.setCaching(true);
                    dependencies.add(task.withCounter("hmcl.modpack.download"));
                }
                if (!dependencies.isEmpty()) {
                    this.getProperties().put("total", dependencies.size());
                    this.notifyPropertiesChanged();
                }
                return executor.all(dependencies);
            }))).whenComplete(Lang.wrap((unused1, ex) -> {
                if (notFound.get()) {
                    throw new ModpackCompletionException(new FileNotFoundException());
                }
                if (!allNameKnown.get() || ex != null) {
                    throw new ModpackCompletionException();
                }
            })));
        }));
    }

    @Nullable
    private Path getFilePath(McbbsModpackManifest.File file) {
        if (file instanceof McbbsModpackManifest.AddonFile) {
            return this.modManager.getRepository().getRunDirectory(this.modManager.getVersion()).toPath().resolve(((McbbsModpackManifest.AddonFile)file).getPath());
        }
        if (file instanceof McbbsModpackManifest.CurseFile) {
            String fileName = ((McbbsModpackManifest.CurseFile)file).getFileName();
            if (fileName == null) {
                return null;
            }
            return this.modManager.getSimpleModPath(fileName);
        }
        throw new IllegalArgumentException();
    }

    private String getFileHash(McbbsModpackManifest.File file) {
        if (file instanceof McbbsModpackManifest.AddonFile) {
            return ((McbbsModpackManifest.AddonFile)file).getHash();
        }
        return null;
    }

    private Task<?> downloadFile(McbbsModpackManifest remoteManifest, McbbsModpackManifest.File file) throws IOException {
        if (file instanceof McbbsModpackManifest.AddonFile) {
            McbbsModpackManifest.AddonFile addonFile = (McbbsModpackManifest.AddonFile)file;
            return new FileDownloadTask(new URL(remoteManifest.getFileApi() + "/overrides/" + NetworkUtils.encodeLocation(addonFile.getPath())), this.modManager.getSimpleModPath(addonFile.getPath()).toFile(), addonFile.getHash() != null ? new FileDownloadTask.IntegrityCheck("SHA-1", addonFile.getHash()) : null);
        }
        if (file instanceof McbbsModpackManifest.CurseFile) {
            return null;
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private McbbsModpackManifest.File mergeFile(@Nullable McbbsModpackManifest.File oldFile, @NotNull McbbsModpackManifest.File newFile) {
        if (newFile instanceof McbbsModpackManifest.AddonFile) {
            return newFile;
        }
        if (newFile instanceof McbbsModpackManifest.CurseFile) {
            return oldFile != null ? oldFile : newFile;
        }
        throw new IllegalArgumentException();
    }
}

