/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccount;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.auth.offline.Skin;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureModel;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccount;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilService;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public final class TexturesLoader {
    private static final ThreadPoolExecutor POOL = Lang.threadPool("TexturesDownload", true, 2, 10L, TimeUnit.SECONDS);
    private static final Path TEXTURES_DIR = Metadata.MINECRAFT_DIRECTORY.resolve("assets").resolve("skins");
    private static final Map<TextureModel, LoadedTexture> DEFAULT_SKINS = new EnumMap<TextureModel, LoadedTexture>(TextureModel.class);

    private TexturesLoader() {
    }

    private static Path getTexturePath(Texture texture) {
        String hash;
        String url = texture.getUrl();
        int slash = url.lastIndexOf(47);
        int dot = url.lastIndexOf(46);
        if (dot < slash) {
            dot = url.length();
        }
        String prefix = (hash = url.substring(slash + 1, dot)).length() > 2 ? hash.substring(0, 2) : "xx";
        return TEXTURES_DIR.resolve(prefix).resolve(hash);
    }

    public static LoadedTexture loadTexture(Texture texture) throws Throwable {
        Image img;
        if (StringUtils.isBlank(texture.getUrl())) {
            throw new IOException("Texture url is empty");
        }
        Path file = TexturesLoader.getTexturePath(texture);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            try {
                new FileDownloadTask(new URL(texture.getUrl()), file.toFile()).run();
                Logging.LOG.info("Texture downloaded: " + texture.getUrl());
            }
            catch (Exception e) {
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    Logging.LOG.log(Level.WARNING, "Failed to download texture " + texture.getUrl() + ", but the file is available", e);
                }
                throw new IOException("Failed to download texture " + texture.getUrl());
            }
        }
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            img = new Image(in);
        }
        if (img.isError()) {
            throw img.getException();
        }
        Map<String, String> metadata = texture.getMetadata();
        if (metadata == null) {
            metadata = Collections.emptyMap();
        }
        return new LoadedTexture(img, metadata);
    }

    private static void loadDefaultSkin(String path, TextureModel model) {
        DEFAULT_SKINS.put(model, new LoadedTexture(FXUtils.newBuiltinImage(path), Collections.singletonMap("model", model.modelName)));
    }

    public static LoadedTexture getDefaultSkin(TextureModel model) {
        return DEFAULT_SKINS.get((Object)model);
    }

    public static ObjectBinding<LoadedTexture> skinBinding(YggdrasilService service, UUID uuid) {
        LoadedTexture uuidFallback = TexturesLoader.getDefaultSkin(TextureModel.detectUUID(uuid));
        return BindingMapping.of(service.getProfileRepository().binding(uuid)).map(profile -> profile.flatMap(it -> {
            try {
                return YggdrasilService.getTextures(it);
            }
            catch (ServerResponseMalformedException e) {
                Logging.LOG.log(Level.WARNING, "Failed to parse texture payload", e);
                return Optional.empty();
            }
        }).flatMap(it -> Optional.ofNullable((Texture)it.get((Object)TextureType.SKIN))).filter(it -> StringUtils.isNotBlank(it.getUrl()))).asyncMap(it -> {
            if (it.isPresent()) {
                Texture texture = (Texture)it.get();
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return TexturesLoader.loadTexture(texture);
                    }
                    catch (Throwable e) {
                        Logging.LOG.log(Level.WARNING, "Failed to load texture " + texture.getUrl() + ", using fallback texture", e);
                        return uuidFallback;
                    }
                }, POOL);
            }
            return CompletableFuture.completedFuture(uuidFallback);
        }, uuidFallback);
    }

    public static ObservableValue<LoadedTexture> skinBinding(Account account) {
        LoadedTexture uuidFallback = TexturesLoader.getDefaultSkin(TextureModel.detectUUID(account.getUUID()));
        if (account instanceof OfflineAccount) {
            OfflineAccount offlineAccount = (OfflineAccount)account;
            SimpleObjectProperty binding = new SimpleObjectProperty();
            InvalidationListener listener = o -> {
                Skin skin = offlineAccount.getSkin();
                String username = offlineAccount.getUsername();
                binding.set((Object)uuidFallback);
                if (skin != null) {
                    skin.load(username).setExecutor(POOL).whenComplete(Schedulers.javafx(), (result, exception) -> {
                        if (exception != null) {
                            Logging.LOG.log(Level.WARNING, "Failed to load texture", exception);
                        } else if (result != null && result.getSkin() != null && result.getSkin().getImage() != null) {
                            Map<String, String> metadata = result.getModel() != null ? Collections.singletonMap("model", result.getModel().modelName) : Collections.emptyMap();
                            binding.set((Object)new LoadedTexture(result.getSkin().getImage(), metadata));
                        }
                    }).start();
                }
            };
            listener.invalidated((Observable)offlineAccount);
            binding.addListener(new Holder<InvalidationListener>(listener));
            offlineAccount.addListener((InvalidationListener)new WeakInvalidationListener(listener));
            return binding;
        }
        return BindingMapping.of(account.getTextures()).asyncMap(textures -> {
            Texture texture;
            if (textures.isPresent() && (texture = (Texture)((Map)textures.get()).get((Object)TextureType.SKIN)) != null && StringUtils.isNotBlank(texture.getUrl())) {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return TexturesLoader.loadTexture(texture);
                    }
                    catch (Throwable e) {
                        Logging.LOG.log(Level.WARNING, "Failed to load texture " + texture.getUrl() + ", using fallback texture", e);
                        return uuidFallback;
                    }
                }, POOL);
            }
            return CompletableFuture.completedFuture(uuidFallback);
        }, uuidFallback);
    }

    public static void drawAvatar(Canvas canvas, Image skin) {
        GraphicsContext g = canvas.getGraphicsContext2D();
        g.clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        int size = (int)canvas.getWidth();
        int scale = (int)skin.getWidth() / 64;
        int faceOffset = (int)Math.round((double)size / 18.0);
        try {
            g.setImageSmoothing(false);
            TexturesLoader.drawAvatar(g, skin, size, scale, faceOffset);
        }
        catch (NoSuchMethodError ignored) {
            TexturesLoader.drawAvatarSlow(g, skin, size, scale, faceOffset);
        }
    }

    private static void drawAvatar(GraphicsContext g, Image skin, int size, int scale, int faceOffset) {
        g.drawImage(skin, (double)(8 * scale), (double)(8 * scale), (double)(8 * scale), (double)(8 * scale), (double)faceOffset, (double)faceOffset, (double)(size - 2 * faceOffset), (double)(size - 2 * faceOffset));
        g.drawImage(skin, (double)(40 * scale), (double)(8 * scale), (double)(8 * scale), (double)(8 * scale), 0.0, 0.0, (double)size, (double)size);
    }

    private static void drawAvatarSlow(GraphicsContext g, Image skin, int size, int scale, int faceOffset) {
        PixelReader reader = skin.getPixelReader();
        PixelWriter writer = g.getPixelWriter();
        TexturesLoader.drawImage(writer, reader, 8 * scale, 8 * scale, 8 * scale, 8 * scale, faceOffset, faceOffset, size - 2 * faceOffset, size - 2 * faceOffset);
        TexturesLoader.drawImage(writer, reader, 40 * scale, 8 * scale, 8 * scale, 8 * scale, 0, 0, size, size);
    }

    private static void drawImage(PixelWriter writer, PixelReader reader, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        double xScale = (double)sw / (double)dw;
        double yScale = (double)sh / (double)dh;
        for (int xOffset = 0; xOffset < dw; ++xOffset) {
            for (int yOffset = 0; yOffset < dh; ++yOffset) {
                int color = reader.getArgb(sx + (int)((double)xOffset * xScale), sy + (int)((double)yOffset * yScale));
                if (color >>> 24 == 0) continue;
                writer.setArgb(dx + xOffset, dy + yOffset, color);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fxAvatarBinding(Canvas canvas, ObservableValue<LoadedTexture> skinBinding) {
        WeakHashMap<Canvas, SkinBindingChangeListener> weakHashMap = SkinBindingChangeListener.hole;
        synchronized (weakHashMap) {
            SkinBindingChangeListener oldListener = SkinBindingChangeListener.hole.remove(canvas);
            if (oldListener != null) {
                oldListener.binding.removeListener((ChangeListener)oldListener);
            }
            SkinBindingChangeListener listener = new SkinBindingChangeListener(canvas, skinBinding);
            listener.changed(skinBinding, null, (LoadedTexture)skinBinding.getValue());
            skinBinding.addListener((ChangeListener)listener);
            SkinBindingChangeListener.hole.put(canvas, listener);
        }
    }

    public static void bindAvatar(Canvas canvas, YggdrasilService service, UUID uuid) {
        TexturesLoader.fxAvatarBinding(canvas, TexturesLoader.skinBinding(service, uuid));
    }

    public static void bindAvatar(Canvas canvas, Account account) {
        if (account instanceof YggdrasilAccount || account instanceof MicrosoftAccount || account instanceof OfflineAccount) {
            TexturesLoader.fxAvatarBinding(canvas, TexturesLoader.skinBinding(account));
        } else {
            TexturesLoader.unbindAvatar(canvas);
            TexturesLoader.drawAvatar(canvas, TexturesLoader.getDefaultSkin(TextureModel.detectUUID(account.getUUID())).image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unbindAvatar(Canvas canvas) {
        WeakHashMap<Canvas, SkinBindingChangeListener> weakHashMap = SkinBindingChangeListener.hole;
        synchronized (weakHashMap) {
            SkinBindingChangeListener oldListener = SkinBindingChangeListener.hole.remove(canvas);
            if (oldListener != null) {
                oldListener.binding.removeListener((ChangeListener)oldListener);
            }
        }
    }

    static {
        TexturesLoader.loadDefaultSkin("/assets/img/skin/steve.png", TextureModel.STEVE);
        TexturesLoader.loadDefaultSkin("/assets/img/skin/alex.png", TextureModel.ALEX);
    }

    public static class LoadedTexture {
        private final Image image;
        private final Map<String, String> metadata;

        public LoadedTexture(Image image, Map<String, String> metadata) {
            this.image = Objects.requireNonNull(image);
            this.metadata = Objects.requireNonNull(metadata);
        }

        public Image getImage() {
            return this.image;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }

    private static final class SkinBindingChangeListener
    implements ChangeListener<LoadedTexture> {
        static final WeakHashMap<Canvas, SkinBindingChangeListener> hole = new WeakHashMap();
        final WeakReference<Canvas> canvasRef;
        final ObservableValue<LoadedTexture> binding;

        SkinBindingChangeListener(Canvas canvas, ObservableValue<LoadedTexture> binding) {
            this.canvasRef = new WeakReference<Canvas>(canvas);
            this.binding = binding;
        }

        public void changed(ObservableValue<? extends LoadedTexture> observable, LoadedTexture oldValue, LoadedTexture loadedTexture) {
            Canvas canvas = (Canvas)this.canvasRef.get();
            if (canvas != null) {
                TexturesLoader.drawAvatar(canvas, loadedTexture.image);
            }
        }
    }
}

