/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Zipper;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class LogExporter {
    private LogExporter() {
    }

    public static CompletableFuture<Void> exportLogs(Path zipFile, DefaultGameRepository gameRepository, String versionId, String logs, String launchScript) {
        Path runDirectory = gameRepository.getRunDirectory(versionId).toPath();
        Path baseDirectory = gameRepository.getBaseDirectory().toPath();
        ArrayList<String> versions = new ArrayList<String>();
        String currentVersionId = versionId;
        HashSet<String> resolvedSoFar = new HashSet<String>();
        while (!resolvedSoFar.contains(currentVersionId)) {
            resolvedSoFar.add(currentVersionId);
            Version currentVersion = gameRepository.getVersion(currentVersionId);
            versions.add(currentVersionId);
            if (!StringUtils.isNotBlank(currentVersion.getInheritsFrom())) break;
            currentVersionId = currentVersion.getInheritsFrom();
        }
        return CompletableFuture.runAsync(() -> {
            try (Zipper zipper = new Zipper(zipFile);){
                LogExporter.processLogs(runDirectory.resolve("liteconfig"), "*.log", "liteconfig", zipper);
                LogExporter.processLogs(runDirectory.resolve("logs"), "*.log", "logs", zipper);
                LogExporter.processLogs(runDirectory, "*.log", "runDirectory", zipper);
                LogExporter.processLogs(runDirectory.resolve("crash-reports"), "*.txt", "crash-reports", zipper);
                zipper.putTextFile(Logging.getLogs(), "hmcl.log");
                zipper.putTextFile(logs, "minecraft.log");
                zipper.putTextFile(Logging.filterForbiddenToken(launchScript), OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "launch.bat" : "launch.sh");
                for (String id : versions) {
                    Path versionJson = baseDirectory.resolve("versions").resolve(id).resolve(id + ".json");
                    if (!Files.exists(versionJson, new LinkOption[0])) continue;
                    zipper.putFile(versionJson, id + ".json");
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static void processLogs(Path directory, String fileExtension, String logDirectory, Zipper zipper) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, fileExtension);){
            long processStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
            for (Path file : stream) {
                FileTime time;
                if (!Files.isRegularFile(file, new LinkOption[0]) || (time = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime()).toMillis() < processStartTime) continue;
                String crashLog = Logging.filterForbiddenToken(FileUtils.readText(file, OperatingSystem.NATIVE_CHARSET));
                zipper.putTextFile(crashLog, file.getFileName().toString());
            }
        }
        catch (Throwable e) {
            Logging.LOG.log(Level.WARNING, "Failed to find any log on " + logDirectory, e);
        }
    }
}

