/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;

public abstract class LocalizedRemoteModRepository
implements RemoteModRepository {
    private static final int CONTAIN_CHINESE_WEIGHT = 10;
    private static final int INITIAL_CAPACITY = 16;

    protected abstract RemoteModRepository getBackedRemoteModRepository();

    protected abstract RemoteModRepository.SortType getBackedRemoteModRepositorySortOrder();

    @Override
    public RemoteModRepository.SearchResult search(String gameVersion, RemoteModRepository.Category category, int pageOffset, int pageSize, String searchFilter, RemoteModRepository.SortType sort, RemoteModRepository.SortOrder sortOrder) throws IOException {
        if (!StringUtils.containsChinese(searchFilter)) {
            return this.getBackedRemoteModRepository().search(gameVersion, category, pageOffset, pageSize, searchFilter, sort, sortOrder);
        }
        HashSet<String> englishSearchFiltersSet = new HashSet<String>(16);
        int count = 0;
        for (ModTranslations.Mod mod : ModTranslations.getTranslationsByRepositoryType(this.getType()).searchMod(searchFilter)) {
            for (String englishWord : StringUtils.tokenize(StringUtils.isNotBlank(mod.getSubname()) ? mod.getSubname() : mod.getName())) {
                if (englishSearchFiltersSet.contains(englishWord)) continue;
                englishSearchFiltersSet.add(englishWord);
            }
            if (++count < 3) continue;
            break;
        }
        RemoteMod[] searchResultArray = new RemoteMod[pageSize];
        int chineseIndex = 0;
        int englishIndex = pageSize - 1;
        RemoteModRepository.SearchResult searchResult = this.getBackedRemoteModRepository().search(gameVersion, category, pageOffset, pageSize, String.join((CharSequence)" ", englishSearchFiltersSet), this.getBackedRemoteModRepositorySortOrder(), sortOrder);
        Iterator iterator = searchResult.getUnsortedResults().iterator();
        while (iterator.hasNext()) {
            if (chineseIndex > englishIndex) {
                Logging.LOG.log(Level.WARNING, "Too many search results! Are the backed remote mod repository broken? Or are the API broken?");
                continue;
            }
            RemoteMod remoteMod2 = (RemoteMod)iterator.next();
            ModTranslations.Mod chineseTranslation = ModTranslations.getTranslationsByRepositoryType(this.getType()).getModByCurseForgeId(remoteMod2.getSlug());
            if (chineseTranslation != null && !StringUtils.isBlank(chineseTranslation.getName()) && StringUtils.containsChinese(chineseTranslation.getName())) {
                searchResultArray[chineseIndex++] = remoteMod2;
                continue;
            }
            searchResultArray[englishIndex--] = remoteMod2;
        }
        int totalPages = searchResult.getTotalPages();
        StringUtils.LevCalculator levCalculator = new StringUtils.LevCalculator();
        return new RemoteModRepository.SearchResult(Stream.concat(Arrays.stream(searchResultArray, 0, chineseIndex).map(remoteMod -> {
            ModTranslations.Mod chineseRemoteMod = ModTranslations.getTranslationsByRepositoryType(this.getType()).getModByCurseForgeId(remoteMod.getSlug());
            if (chineseRemoteMod == null || StringUtils.isBlank(chineseRemoteMod.getName()) || !StringUtils.containsChinese(chineseRemoteMod.getName())) {
                return Pair.pair(remoteMod, Integer.MAX_VALUE);
            }
            String chineseRemoteModName = chineseRemoteMod.getName();
            if (searchFilter.isEmpty() || chineseRemoteModName.isEmpty()) {
                return Pair.pair(remoteMod, Math.max(searchFilter.length(), chineseRemoteModName.length()));
            }
            int l = levCalculator.calc(searchFilter, chineseRemoteModName);
            for (int i = 0; i < searchFilter.length(); ++i) {
                if (chineseRemoteModName.indexOf(searchFilter.charAt(i)) < 0) continue;
                l -= 10;
            }
            return Pair.pair(remoteMod, l);
        }).sorted(Comparator.comparingInt(Pair::getValue)).map(Pair::getKey), Arrays.stream(searchResultArray, englishIndex + 1, searchResultArray.length)), totalPages);
    }

    @Override
    public Stream<RemoteModRepository.Category> getCategories() throws IOException {
        return this.getBackedRemoteModRepository().getCategories();
    }

    @Override
    public Optional<RemoteMod.Version> getRemoteVersionByLocalFile(LocalModFile localModFile, Path file) throws IOException {
        return this.getBackedRemoteModRepository().getRemoteVersionByLocalFile(localModFile, file);
    }

    @Override
    public RemoteMod getModById(String id) throws IOException {
        return this.getBackedRemoteModRepository().getModById(id);
    }

    @Override
    public RemoteMod.File getModFile(String modId, String fileId) throws IOException {
        return this.getBackedRemoteModRepository().getModFile(modId, fileId);
    }

    @Override
    public Stream<RemoteMod.Version> getRemoteVersionsById(String id) throws IOException {
        return this.getBackedRemoteModRepository().getRemoteVersionsById(id);
    }
}

