/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.File;
import java.io.Serializable;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.ProcessPriority;
import org.jackhuang.hmcl.game.Renderer;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jetbrains.annotations.NotNull;

public class LaunchOptions
implements Serializable {
    private File gameDir;
    private JavaVersion java;
    private String versionName;
    private String versionType;
    private String profileName;
    private final List<String> gameArguments = new ArrayList<String>();
    private final List<String> overrideJavaArguments = new ArrayList<String>();
    private final List<String> javaArguments = new ArrayList<String>();
    private final List<String> javaAgents = new ArrayList<String>(0);
    private final Map<String, String> environmentVariables = new LinkedHashMap<String, String>();
    private Integer minMemory;
    private Integer maxMemory;
    private Integer metaspace;
    private Integer width;
    private Integer height;
    private boolean fullscreen;
    private String serverIp;
    private String wrapper;
    private Proxy proxy;
    private String proxyUser;
    private String proxyPass;
    private boolean noGeneratedJVMArgs;
    private String preLaunchCommand;
    private String postExitCommand;
    private NativesDirectoryType nativesDirType;
    private String nativesDir;
    private ProcessPriority processPriority = ProcessPriority.NORMAL;
    private Renderer renderer = Renderer.DEFAULT;
    private boolean useNativeGLFW;
    private boolean useNativeOpenAL;
    private boolean daemon;

    public File getGameDir() {
        return this.gameDir;
    }

    public JavaVersion getJava() {
        return this.java;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public String getProfileName() {
        return this.profileName;
    }

    @NotNull
    public List<String> getGameArguments() {
        return Collections.unmodifiableList(this.gameArguments);
    }

    @NotNull
    public List<String> getOverrideJavaArguments() {
        return Collections.unmodifiableList(this.overrideJavaArguments);
    }

    @NotNull
    public List<String> getJavaArguments() {
        return Collections.unmodifiableList(this.javaArguments);
    }

    @NotNull
    public List<String> getJavaAgents() {
        return Collections.unmodifiableList(this.javaAgents);
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Integer getMinMemory() {
        return this.minMemory;
    }

    public Integer getMaxMemory() {
        return this.maxMemory;
    }

    public Integer getMetaspace() {
        return this.metaspace;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public String getWrapper() {
        return this.wrapper;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public boolean isNoGeneratedJVMArgs() {
        return this.noGeneratedJVMArgs;
    }

    public String getPreLaunchCommand() {
        return this.preLaunchCommand;
    }

    public String getPostExitCommand() {
        return this.postExitCommand;
    }

    public NativesDirectoryType getNativesDirType() {
        return this.nativesDirType;
    }

    public String getNativesDir() {
        return this.nativesDir;
    }

    public ProcessPriority getProcessPriority() {
        return this.processPriority;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public boolean isUseNativeGLFW() {
        return this.useNativeGLFW;
    }

    public boolean isUseNativeOpenAL() {
        return this.useNativeOpenAL;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public static class Builder {
        private final LaunchOptions options = new LaunchOptions();

        public LaunchOptions create() {
            return this.options;
        }

        public List<String> getGameArguments() {
            return this.options.gameArguments;
        }

        public List<String> getOverrideJavaArguments() {
            return this.options.overrideJavaArguments;
        }

        public List<String> getJavaArguments() {
            return this.options.javaArguments;
        }

        public List<String> getJavaAgents() {
            return this.options.javaAgents;
        }

        public Builder setGameDir(File gameDir) {
            this.options.gameDir = gameDir;
            return this;
        }

        public Builder setJava(JavaVersion java) {
            this.options.java = java;
            return this;
        }

        public Builder setVersionName(String versionName) {
            this.options.versionName = versionName;
            return this;
        }

        public Builder setVersionType(String versionType) {
            this.options.versionType = versionType;
            return this;
        }

        public Builder setProfileName(String profileName) {
            this.options.profileName = profileName;
            return this;
        }

        public Builder setGameArguments(List<String> gameArguments) {
            this.options.gameArguments.clear();
            this.options.gameArguments.addAll(gameArguments);
            return this;
        }

        public Builder setOverrideJavaArguments(List<String> overrideJavaArguments) {
            this.options.overrideJavaArguments.clear();
            this.options.overrideJavaArguments.addAll(overrideJavaArguments);
            return this;
        }

        public Builder setJavaArguments(List<String> javaArguments) {
            this.options.javaArguments.clear();
            this.options.javaArguments.addAll(javaArguments);
            return this;
        }

        public Builder setJavaAgents(List<String> javaAgents) {
            this.options.javaAgents.clear();
            this.options.javaAgents.addAll(javaAgents);
            return this;
        }

        public Builder setEnvironmentVariables(Map<String, String> env) {
            this.options.environmentVariables.clear();
            this.options.environmentVariables.putAll(env);
            return this;
        }

        public Builder setMinMemory(Integer minMemory) {
            this.options.minMemory = minMemory;
            return this;
        }

        public Builder setMaxMemory(Integer maxMemory) {
            this.options.maxMemory = maxMemory;
            return this;
        }

        public Builder setMetaspace(Integer metaspace) {
            this.options.metaspace = metaspace;
            return this;
        }

        public Builder setWidth(Integer width) {
            this.options.width = width;
            return this;
        }

        public Builder setHeight(Integer height) {
            this.options.height = height;
            return this;
        }

        public Builder setFullscreen(boolean fullscreen) {
            this.options.fullscreen = fullscreen;
            return this;
        }

        public Builder setServerIp(String serverIp) {
            this.options.serverIp = serverIp;
            return this;
        }

        public Builder setWrapper(String wrapper) {
            this.options.wrapper = wrapper;
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            this.options.proxy = proxy;
            return this;
        }

        public Builder setProxyUser(String proxyUser) {
            this.options.proxyUser = proxyUser;
            return this;
        }

        public Builder setProxyPass(String proxyPass) {
            this.options.proxyPass = proxyPass;
            return this;
        }

        public Builder setNoGeneratedJVMArgs(boolean noGeneratedJVMArgs) {
            this.options.noGeneratedJVMArgs = noGeneratedJVMArgs;
            return this;
        }

        public Builder setPreLaunchCommand(String preLaunchCommand) {
            this.options.preLaunchCommand = preLaunchCommand;
            return this;
        }

        public Builder setPostExitCommand(String postExitCommand) {
            this.options.postExitCommand = postExitCommand;
            return this;
        }

        public Builder setNativesDirType(NativesDirectoryType nativesDirType) {
            this.options.nativesDirType = nativesDirType;
            return this;
        }

        public Builder setNativesDir(String nativesDir) {
            this.options.nativesDir = nativesDir;
            return this;
        }

        public Builder setProcessPriority(@NotNull ProcessPriority processPriority) {
            this.options.processPriority = processPriority;
            return this;
        }

        public Builder setRenderer(@NotNull Renderer renderer) {
            this.options.renderer = renderer;
            return this;
        }

        public Builder setUseNativeGLFW(boolean useNativeGLFW) {
            this.options.useNativeGLFW = useNativeGLFW;
            return this;
        }

        public Builder setUseNativeOpenAL(boolean useNativeOpenAL) {
            this.options.useNativeOpenAL = useNativeOpenAL;
            return this;
        }

        public Builder setDaemon(boolean daemon) {
            this.options.daemon = daemon;
            return this;
        }
    }
}

