/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.util.List;
import java.util.Objects;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionRange;
import org.jetbrains.annotations.Nullable;

public enum JavaVersionConstraint {
    VANILLA_JAVA_8(1, GameVersionNumber.atLeast("1.13"), VersionNumber.atLeast("1.8")),
    VANILLA_JAVA_16(1, GameVersionNumber.atLeast("1.17"), VersionNumber.atLeast("16")),
    VANILLA_JAVA_17(1, GameVersionNumber.atLeast("1.18"), VersionNumber.atLeast("17")),
    MODDED_JAVA_7(2, (VersionRange)GameVersionNumber.atMost("1.7.2"), (VersionRange)VersionNumber.atMost("1.7.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            return version != null && analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    MODDED_JAVA_8(2, (VersionRange)GameVersionNumber.between("1.7.10", "1.16.999"), (VersionRange)VersionNumber.between("1.8", "1.8.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            return analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    MODDED_JAVA_16(2, (VersionRange)GameVersionNumber.between("1.17", "1.17.999"), (VersionRange)VersionNumber.between("16", "16.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            return analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    MODDED_JAVA_17(2, (VersionRange)GameVersionNumber.atLeast("1.18"), (VersionRange)VersionNumber.between("17", "17.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            return analyzer != null && analyzer.has(LibraryAnalyzer.LibraryType.FORGE);
        }
    }
    ,
    LAUNCH_WRAPPER(1, (VersionRange)GameVersionNumber.atMost("1.12.999"), (VersionRange)VersionNumber.atMost("1.8.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            if (version == null) {
                return false;
            }
            return "net.minecraft.launchwrapper.Launch".equals(version.getMainClass()) && version.getLibraries().stream().filter(library -> "launchwrapper".equals(library.getArtifactId())).anyMatch(library -> VersionNumber.asVersion(library.getVersion()).compareTo(VersionNumber.asVersion("1.13")) < 0);
        }
    }
    ,
    VANILLA_JAVA_8_51(2, GameVersionNumber.atLeast("1.13"), VersionNumber.atLeast("1.8.0_51")),
    GAME_JSON(1, VersionRange.all(), VersionRange.all()){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            if (version == null) {
                return false;
            }
            return gameVersionNumber.compareTo("1.7.10") >= 0 && version.getJavaVersion() != null;
        }

        @Override
        public VersionRange<VersionNumber> getJavaVersionRange(Version version) {
            String javaVersion = Objects.requireNonNull(version.getJavaVersion()).getMajorVersion() >= 9 ? "" + version.getJavaVersion().getMajorVersion() : "1." + version.getJavaVersion().getMajorVersion();
            return VersionNumber.atLeast(javaVersion);
        }
    }
    ,
    VANILLA_LINUX_JAVA_8(1, (VersionRange)GameVersionNumber.atMost("1.12.999"), (VersionRange)VersionNumber.atMost("1.8.999")){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            return OperatingSystem.CURRENT_OS == OperatingSystem.LINUX && Architecture.SYSTEM_ARCH == Architecture.X86_64 && (javaVersion == null || javaVersion.getArchitecture() == Architecture.X86_64);
        }

        @Override
        public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaVersion javaVersion) {
            return javaVersion.getArchitecture() != Architecture.X86_64 || super.checkJava(gameVersionNumber, version, javaVersion);
        }
    }
    ,
    VANILLA_X86(2, VersionRange.all(), VersionRange.all()){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            if (javaVersion == null || javaVersion.getArchitecture() != Architecture.ARM64) {
                return false;
            }
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                return gameVersionNumber.compareTo("1.6") < 0;
            }
            return false;
        }

        @Override
        public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaVersion javaVersion) {
            return javaVersion.getArchitecture().isX86();
        }
    }
    ,
    MODLAUNCHER_8(2, (VersionRange)GameVersionNumber.between("1.16.3", "1.17.1"), VersionRange.all()){

        @Override
        protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
            if (version == null || javaVersion == null || analyzer == null) {
                return false;
            }
            VersionNumber forgePatchVersion = analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).map(VersionNumber::asVersion).orElse(null);
            if (forgePatchVersion == null) {
                return false;
            }
            switch (gameVersionNumber.toString()) {
                case "1.16.3": {
                    return forgePatchVersion.compareTo(VersionNumber.asVersion("34.1.27")) >= 0;
                }
                case "1.16.4": {
                    return true;
                }
                case "1.16.5": {
                    return forgePatchVersion.compareTo(VersionNumber.asVersion("36.2.23")) <= 0;
                }
                case "1.17.1": {
                    return VersionNumber.between("37.0.60", "37.0.75").contains(forgePatchVersion);
                }
            }
            return false;
        }

        @Override
        public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaVersion javaVersion) {
            int parsedJavaVersion = javaVersion.getParsedVersion();
            if (parsedJavaVersion > 17) {
                return false;
            }
            if (parsedJavaVersion == 8) {
                return javaVersion.getVersionNumber().compareTo(VersionNumber.asVersion("1.8.0_321")) < 0;
            }
            if (parsedJavaVersion == 11) {
                return javaVersion.getVersionNumber().compareTo(VersionNumber.asVersion("11.0.14")) < 0;
            }
            if (parsedJavaVersion == 15) {
                return javaVersion.getVersionNumber().compareTo(VersionNumber.asVersion("15.0.6")) < 0;
            }
            if (parsedJavaVersion == 17) {
                return javaVersion.getVersionNumber().compareTo(VersionNumber.asVersion("17.0.2")) < 0;
            }
            return true;
        }
    };

    private final int type;
    private final VersionRange<GameVersionNumber> gameVersionRange;
    private final VersionRange<VersionNumber> javaVersionRange;
    public static final List<JavaVersionConstraint> ALL;
    public static final int RULE_MANDATORY = 1;
    public static final int RULE_SUGGESTED = 2;

    private JavaVersionConstraint(int type, VersionRange<GameVersionNumber> gameVersionRange, VersionRange<VersionNumber> javaVersionRange) {
        this.type = type;
        this.gameVersionRange = gameVersionRange;
        this.javaVersionRange = javaVersionRange;
    }

    public int getType() {
        return this.type;
    }

    public VersionRange<GameVersionNumber> getGameVersionRange() {
        return this.gameVersionRange;
    }

    public VersionRange<VersionNumber> getJavaVersionRange(Version version) {
        return this.javaVersionRange;
    }

    public final boolean appliesToVersion(@Nullable GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, LibraryAnalyzer analyzer) {
        return this.gameVersionRange.contains(gameVersionNumber) && this.appliesToVersionImpl(gameVersionNumber, version, javaVersion, analyzer);
    }

    protected boolean appliesToVersionImpl(GameVersionNumber gameVersionNumber, @Nullable Version version, @Nullable JavaVersion javaVersion, @Nullable LibraryAnalyzer analyzer) {
        return true;
    }

    public boolean checkJava(GameVersionNumber gameVersionNumber, Version version, JavaVersion javaVersion) {
        return this.getJavaVersionRange(version).contains(javaVersion.getVersionNumber());
    }

    public static VersionRanges findSuitableJavaVersionRange(GameVersionNumber gameVersion, Version version) {
        VersionRange<VersionNumber> mandatoryJavaRange = VersionRange.all();
        VersionRange<VersionNumber> suggestedJavaRange = VersionRange.all();
        LibraryAnalyzer analyzer = version != null ? LibraryAnalyzer.analyze(version, gameVersion != null ? gameVersion.toString() : null) : null;
        for (JavaVersionConstraint java : ALL) {
            if (!java.appliesToVersion(gameVersion, version, null, analyzer)) continue;
            VersionRange<VersionNumber> javaVersionRange = java.getJavaVersionRange(version);
            if (java.type == 1) {
                mandatoryJavaRange = mandatoryJavaRange.intersectionWith(javaVersionRange);
                suggestedJavaRange = suggestedJavaRange.intersectionWith(javaVersionRange);
                continue;
            }
            if (java.type != 2) continue;
            suggestedJavaRange = suggestedJavaRange.intersectionWith(javaVersionRange);
        }
        return new VersionRanges(mandatoryJavaRange, suggestedJavaRange);
    }

    @Nullable
    public static JavaVersion findSuitableJavaVersion(GameVersionNumber gameVersion, Version version) throws InterruptedException {
        VersionRanges range = JavaVersionConstraint.findSuitableJavaVersionRange(gameVersion, version);
        boolean forceX86 = Architecture.SYSTEM_ARCH == Architecture.ARM64 && (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || OperatingSystem.CURRENT_OS == OperatingSystem.OSX) && gameVersion.compareTo("1.6") < 0;
        JavaVersion mandatory = null;
        JavaVersion suggested = null;
        for (JavaVersion javaVersion : JavaVersion.getJavas()) {
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64 && javaVersion.getArchitecture() == Architecture.X86 || forceX86 && !javaVersion.getArchitecture().isX86()) continue;
            VersionNumber javaVersionNumber = javaVersion.getVersionNumber();
            if (range.getMandatory().contains(javaVersionNumber)) {
                if (mandatory == null) {
                    mandatory = javaVersion;
                } else if (JavaVersionConstraint.compareJavaVersion(javaVersion, mandatory) > 0) {
                    mandatory = javaVersion;
                }
            }
            if (!range.getSuggested().contains(javaVersionNumber)) continue;
            if (suggested == null) {
                suggested = javaVersion;
                continue;
            }
            if (JavaVersionConstraint.compareJavaVersion(javaVersion, suggested) <= 0) continue;
            suggested = javaVersion;
        }
        if (suggested != null) {
            return suggested;
        }
        return mandatory;
    }

    private static int compareJavaVersion(JavaVersion javaVersion1, JavaVersion javaVersion2) {
        Architecture arch2;
        Architecture arch1 = javaVersion1.getArchitecture();
        if (arch1 != (arch2 = javaVersion2.getArchitecture())) {
            if (arch1 == Architecture.X86_64) {
                return 1;
            }
            if (arch2 == Architecture.X86_64) {
                return -1;
            }
        }
        return javaVersion1.getVersionNumber().compareTo(javaVersion2.getVersionNumber());
    }

    static {
        ALL = Lang.immutableListOf(JavaVersionConstraint.values());
    }

    public static final class VersionRanges {
        private final VersionRange<VersionNumber> mandatory;
        private final VersionRange<VersionNumber> suggested;

        public VersionRanges(VersionRange<VersionNumber> mandatory, VersionRange<VersionNumber> suggested) {
            this.mandatory = mandatory;
            this.suggested = suggested;
        }

        public VersionRange<VersionNumber> getMandatory() {
            return this.mandatory;
        }

        public VersionRange<VersionNumber> getSuggested() {
            return this.suggested;
        }
    }
}

