/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.neoforge;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.neoforge.NeoForgeRemoteVersion;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class NeoForgeBMCLVersionList
extends VersionList<NeoForgeRemoteVersion> {
    private final String apiRoot;

    public NeoForgeBMCLVersionList(String apiRoot) {
        this.apiRoot = apiRoot;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public CompletableFuture<?> loadAsync() {
        throw new UnsupportedOperationException("NeoForgeBMCLVersionList does not support loading the entire NeoForge remote version list.");
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        throw new UnsupportedOperationException("NeoForgeBMCLVersionList does not support loading the entire NeoForge remote version list.");
    }

    @Override
    public Optional<NeoForgeRemoteVersion> getVersion(String gameVersion, String remoteVersion) {
        if (gameVersion.equals("1.20.1")) {
            remoteVersion = VersionNumber.compare(remoteVersion = NeoForgeRemoteVersion.fixInvalidVersion(remoteVersion), "47.1.85") >= 0 ? "1.20.1-" + remoteVersion : remoteVersion;
        }
        return super.getVersion(gameVersion, remoteVersion);
    }

    @Override
    public CompletableFuture<?> refreshAsync(String gameVersion) {
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenApplyAsync(Lang.wrap(unused -> (List)HttpRequest.GET(this.apiRoot + "/neoforge/list/" + gameVersion).getJson(new TypeToken<List<NeoForgeVersion>>(){}.getType())))).thenAcceptAsync(neoForgeVersions -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear(gameVersion);
                for (NeoForgeVersion neoForgeVersion : neoForgeVersions) {
                    String nf = StringUtils.removePrefix(neoForgeVersion.version, "1.20.1".equals(gameVersion) ? "1.20.1-forge-" : "neoforge-");
                    this.versions.put(gameVersion, new NeoForgeRemoteVersion(neoForgeVersion.mcVersion, nf, Lang.immutableListOf(this.apiRoot + "/neoforge/version/" + neoForgeVersion.version + "/download/installer.jar")));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    @Immutable
    private static final class NeoForgeVersion
    implements Validation {
        private final String rawVersion;
        private final String version;
        @SerializedName(value="mcversion")
        private final String mcVersion;

        public NeoForgeVersion(String rawVersion, String version, String mcVersion) {
            this.rawVersion = rawVersion;
            this.version = version;
            this.mcVersion = mcVersion;
        }

        @Override
        public void validate() throws JsonParseException {
            if (this.rawVersion == null) {
                throw new JsonParseException("NeoForgeVersion rawVersion cannot be null.");
            }
            if (this.version == null) {
                throw new JsonParseException("NeoForgeVersion version cannot be null.");
            }
            if (this.mcVersion == null) {
                throw new JsonParseException("NeoForgeVersion mcversion cannot be null.");
            }
        }
    }
}

