/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.java.JavaDownloadTask;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.CacheRepository;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;

public final class JavaRepository {
    private JavaRepository() {
    }

    public static Task<JavaVersion> downloadJava(GameJavaVersion javaVersion, DownloadProvider downloadProvider) {
        return new JavaDownloadTask(javaVersion, JavaRepository.getJavaStoragePath(), downloadProvider).thenSupplyAsync(() -> {
            String platform = JavaRepository.getSystemJavaPlatform().orElseThrow(JavaDownloadTask.UnsupportedPlatformException::new);
            return JavaRepository.addJava(JavaRepository.getJavaHome(javaVersion, platform));
        });
    }

    public static JavaVersion addJava(Path javaHome) throws InterruptedException, IOException {
        Path executable;
        if (Files.isDirectory(javaHome, new LinkOption[0]) && Files.isRegularFile(executable = JavaVersion.getExecutable(javaHome), new LinkOption[0])) {
            JavaVersion javaVersion = JavaVersion.fromExecutable(executable);
            JavaVersion.getJavas().add(javaVersion);
            return javaVersion;
        }
        throw new IOException("Incorrect java home " + javaHome);
    }

    public static Stream<Optional<Path>> findMinecraftRuntimeDirs() {
        switch (OperatingSystem.CURRENT_OS) {
            case WINDOWS: {
                return Stream.of(FileUtils.tryGetPath(System.getenv("localappdata"), "Packages\\Microsoft.4297127D64EC6_8wekyb3d8bbwe\\LocalCache\\Local\\runtime"), FileUtils.tryGetPath(Optional.ofNullable(System.getenv("ProgramFiles(x86)")).orElse("C:\\Program Files (x86)"), "Minecraft Launcher\\runtime"));
            }
            case LINUX: 
            case FREEBSD: {
                return Stream.of(FileUtils.tryGetPath(System.getProperty("user.home", ".minecraft/runtime"), new String[0]));
            }
            case OSX: {
                return Stream.of(FileUtils.tryGetPath(System.getProperty("user.home"), "Library/Application Support/minecraft/runtime"));
            }
        }
        return Stream.empty();
    }

    public static Stream<Path> findJavaHomeInMinecraftRuntimeDir(Path runtimeDir) {
        if (!Files.isDirectory(runtimeDir, new LinkOption[0])) {
            return Stream.empty();
        }
        ArrayList javaHomes = new ArrayList();
        Consumer<String> action = platform -> {
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(runtimeDir);){
                for (Path component : dir) {
                    JavaRepository.findJavaHomeInComponentDir(platform, component).ifPresent(javaHomes::add);
                }
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to list java-runtime directory " + runtimeDir, e);
            }
        };
        JavaRepository.getSystemJavaPlatform().ifPresent(action);
        if (Platform.SYSTEM_PLATFORM == Platform.OSX_ARM64) {
            action.accept("mac-os-arm64");
        }
        return javaHomes.stream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Path> findJavaHomeInComponentDir(String platform, Path component) {
        Path sha1File = component.resolve(platform).resolve(component.getFileName() + ".sha1");
        if (!Files.isRegularFile(sha1File, new LinkOption[0])) {
            return Optional.empty();
        }
        Path dir = component.resolve(platform).resolve(component.getFileName());
        try (BufferedReader reader = Files.newBufferedReader(sha1File);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                int idx = line.indexOf(" /#//");
                if (idx <= 0) {
                    throw new IOException("Illegal line: " + line);
                }
                Path file = dir.resolve(line.substring(0, idx));
                if (!Files.notExists(file, new LinkOption[0])) continue;
                throw new NoSuchFileException(file.toAbsolutePath().toString());
            }
            if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                Path macPath = dir.resolve("jre.bundle/Contents/Home");
                if (Files.exists(macPath, new LinkOption[0])) {
                    Optional<Path> optional = Optional.of(macPath);
                    return optional;
                }
                Logging.LOG.warning("The Java is not in 'jre.bundle/Contents/Home'");
            }
            Optional<Path> optional = Optional.of(dir);
            return optional;
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to verify Java in " + component, e);
            return Optional.empty();
        }
    }

    public static Optional<String> getSystemJavaPlatform() {
        if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX) {
            if (Architecture.SYSTEM_ARCH == Architecture.X86) {
                return Optional.of("linux-i386");
            }
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                return Optional.of("linux");
            }
        } else if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64 || Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                return Optional.of("mac-os");
            }
        } else if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            if (Architecture.SYSTEM_ARCH == Architecture.X86) {
                return Optional.of("windows-x86");
            }
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64) {
                return Optional.of("windows-x64");
            }
            if (Architecture.SYSTEM_ARCH == Architecture.ARM64) {
                if (OperatingSystem.SYSTEM_BUILD_NUMBER >= 21277) {
                    return Optional.of("windows-x64");
                }
                return Optional.of("windows-x86");
            }
        }
        return Optional.empty();
    }

    public static Path getJavaStoragePath() {
        return CacheRepository.getInstance().getCacheDirectory().resolve("java");
    }

    public static Path getJavaHome(GameJavaVersion javaVersion, String platform) {
        Path javaHome = JavaRepository.getJavaStoragePath().resolve(javaVersion.getComponent()).resolve(platform).resolve(javaVersion.getComponent());
        if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
            javaHome = javaHome.resolve("jre.bundle/Contents/Home");
        }
        return javaHome;
    }
}

