/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import org.jackhuang.hmcl.download.AbstractDependencyManager;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.DefaultCacheRepository;
import org.jackhuang.hmcl.download.game.LibraryDownloadException;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pack200Utils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.tukaani.xz.XZInputStream;

public class LibraryDownloadTask
extends Task<Void> {
    private FileDownloadTask task;
    protected final File jar;
    protected final DefaultCacheRepository cacheRepository;
    protected final AbstractDependencyManager dependencyManager;
    private final File xzFile;
    protected final Library library;
    protected final String url;
    protected boolean xz;
    private final Library originalLibrary;
    private boolean cached = false;

    public LibraryDownloadTask(AbstractDependencyManager dependencyManager, File file, Library library) {
        this.dependencyManager = dependencyManager;
        this.originalLibrary = library;
        this.setSignificance(Task.TaskSignificance.MODERATE);
        if (library.is("net.minecraftforge", "forge")) {
            library = library.setClassifier("universal");
        }
        this.library = library;
        this.cacheRepository = dependencyManager.getCacheRepository();
        this.url = library.getDownload().getUrl();
        this.jar = file;
        this.xzFile = new File(file.getAbsoluteFile().getParentFile(), file.getName() + ".pack.xz");
    }

    @Override
    public Collection<Task<?>> getDependents() {
        if (this.cached) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.task);
    }

    @Override
    public boolean isRelyingOnDependents() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        if (this.cached) {
            return;
        }
        if (!this.isDependentsSucceeded()) {
            Exception t = this.task.getException();
            if (t instanceof DownloadException) {
                throw new LibraryDownloadException(this.library, t.getCause());
            }
            if (t instanceof CancellationException) {
                throw new CancellationException();
            }
            throw new LibraryDownloadException(this.library, (Throwable)t);
        }
        if (this.xz) {
            LibraryDownloadTask.unpackLibrary(this.jar, Files.readAllBytes(this.xzFile.toPath()));
        }
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() {
        Optional<Path> libPath = this.cacheRepository.getLibrary(this.originalLibrary);
        if (libPath.isPresent()) {
            try {
                FileUtils.copyFile(libPath.get().toFile(), this.jar);
                this.cached = true;
                return;
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to copy file from cache", e);
            }
        }
        if (Pack200Utils.isSupported() && this.testURLExistence(this.url)) {
            List<URL> urls = this.dependencyManager.getDownloadProvider().injectURLWithCandidates(this.url + ".pack.xz");
            this.task = new FileDownloadTask(urls, this.xzFile, null);
            this.task.setCacheRepository(this.cacheRepository);
            this.task.setCaching(true);
            this.xz = true;
        } else {
            List<URL> urls = this.dependencyManager.getDownloadProvider().injectURLWithCandidates(this.url);
            this.task = new FileDownloadTask(urls, this.jar, this.library.getDownload().getSha1() != null ? new FileDownloadTask.IntegrityCheck("SHA-1", this.library.getDownload().getSha1()) : null);
            this.task.setCacheRepository(this.cacheRepository);
            this.task.setCaching(true);
            this.task.addIntegrityCheckHandler(FileDownloadTask.ZIP_INTEGRITY_CHECK_HANDLER);
            this.xz = false;
        }
    }

    private boolean testURLExistence(String rawUrl) {
        List<URL> urls = this.dependencyManager.getDownloadProvider().injectURLWithCandidates(rawUrl);
        for (URL url : urls) {
            URL xzURL = NetworkUtils.toURL(url.toString() + ".pack.xz");
            for (int retry = 0; retry < 3; ++retry) {
                try {
                    return NetworkUtils.urlExists(xzURL);
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to test for url existence: " + url + ".pack.xz", e);
                    continue;
                }
            }
        }
        return false;
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        if (!this.cached) {
            try {
                this.cacheRepository.cacheLibrary(this.library, this.jar.toPath(), this.xz);
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to cache downloaded library " + this.library, e);
            }
        }
    }

    public static boolean checksumValid(File libPath, List<String> checksums) {
        try {
            if (checksums == null || checksums.isEmpty()) {
                return true;
            }
            byte[] fileData = Files.readAllBytes(libPath.toPath());
            boolean valid = checksums.contains(DigestUtils.digestToString("SHA-1", fileData));
            if (!valid && libPath.getName().endsWith(".jar")) {
                valid = LibraryDownloadTask.validateJar(fileData, checksums);
            }
            return valid;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean validateJar(byte[] data, List<String> checksums) throws IOException {
        HashMap<String, String> files = new HashMap<String, String>();
        String[] hashes = null;
        JarInputStream jar = new JarInputStream(new ByteArrayInputStream(data));
        JarEntry entry = jar.getNextJarEntry();
        while (entry != null) {
            byte[] eData = IOUtils.readFullyWithoutClosing(jar);
            if (entry.getName().equals("checksums.sha1")) {
                hashes = new String(eData, StandardCharsets.UTF_8).split("\n");
            }
            if (!entry.isDirectory()) {
                files.put(entry.getName(), DigestUtils.digestToString("SHA-1", eData));
            }
            entry = jar.getNextJarEntry();
        }
        jar.close();
        if (hashes != null) {
            boolean failed;
            boolean bl = failed = !checksums.contains(files.get("checksums.sha1"));
            if (!failed) {
                for (String hash : hashes) {
                    if (hash.trim().equals("") || !hash.contains(" ")) continue;
                    String[] e = hash.split(" ");
                    String validChecksum = e[0];
                    String target = hash.substring(validChecksum.length() + 1);
                    String checksum = (String)files.get(target);
                    if (!files.containsKey(target) || checksum == null) {
                        Logging.LOG.warning("    " + target + " : missing");
                        failed = true;
                        break;
                    }
                    if (checksum.equals(validChecksum)) continue;
                    Logging.LOG.warning("    " + target + " : failed (" + checksum + ", " + validChecksum + ")");
                    failed = true;
                    break;
                }
            }
            return !failed;
        }
        return false;
    }

    private static void unpackLibrary(File dest, byte[] src) throws IOException {
        byte[] decompressed;
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Unable to delete file " + dest);
        }
        try {
            decompressed = IOUtils.readFullyAsByteArray(new XZInputStream(new ByteArrayInputStream(src)));
        }
        catch (IOException e) {
            throw new ArtifactMalformedException("Library " + dest + " is malformed");
        }
        String end = new String(decompressed, decompressed.length - 4, 4);
        if (!end.equals("SIGN")) {
            throw new IOException("Unpacking failed, signature missing " + end);
        }
        int x = decompressed.length;
        int len = decompressed[x - 8] & 0xFF | (decompressed[x - 7] & 0xFF) << 8 | (decompressed[x - 6] & 0xFF) << 16 | (decompressed[x - 5] & 0xFF) << 24;
        Path temp = Files.createTempFile("minecraft", ".pack", new FileAttribute[0]);
        byte[] checksums = Arrays.copyOfRange(decompressed, decompressed.length - len - 8, decompressed.length - 8);
        try (OutputStream out = Files.newOutputStream(temp, new OpenOption[0]);){
            out.write(decompressed, 0, decompressed.length - len - 8);
        }
        try (FileOutputStream jarBytes = new FileOutputStream(dest);
             JarOutputStream jos = new JarOutputStream(jarBytes);){
            Pack200Utils.unpack(temp.toFile(), jos);
            JarEntry checksumsFile = new JarEntry("checksums.sha1");
            checksumsFile.setTime(0L);
            jos.putNextEntry(checksumsFile);
            jos.write(checksums);
            jos.closeEntry();
        }
        Files.delete(temp);
    }
}

