/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersionInfo;
import org.jackhuang.hmcl.download.game.GameRemoteVersions;
import org.jackhuang.hmcl.util.io.HttpRequest;

public final class GameVersionList
extends VersionList<GameRemoteVersion> {
    private final DownloadProvider downloadProvider;

    public GameVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return true;
    }

    @Override
    protected Collection<GameRemoteVersion> getVersionsImpl(String gameVersion) {
        return this.versions.values();
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        return HttpRequest.GET(this.downloadProvider.getVersionListURL()).getJsonAsync(GameRemoteVersions.class).thenAcceptAsync(root -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                for (GameRemoteVersionInfo remoteVersion : root.getVersions()) {
                    this.versions.put(remoteVersion.getGameVersion(), new GameRemoteVersion(remoteVersion.getGameVersion(), remoteVersion.getGameVersion(), Collections.singletonList(remoteVersion.getUrl()), remoteVersion.getType(), remoteVersion.getReleaseTime()));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }
}

