/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.offline;

import com.google.gson.reflect.TypeToken;
import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glavo.png.javafx.PNGJavaFXUtils;
import org.jackhuang.hmcl.auth.offline.Skin;
import org.jackhuang.hmcl.auth.offline.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.GameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.TextureModel;
import org.jackhuang.hmcl.util.KeyUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.io.HttpServer;

public class YggdrasilServer
extends HttpServer {
    private final Map<UUID, Character> charactersByUuid = new HashMap<UUID, Character>();
    private final Map<String, Character> charactersByName = new HashMap<String, Character>();
    private static final KeyPair keyPair = KeyUtils.generateKey();

    public YggdrasilServer(int port) {
        super(port);
        this.addRoute(NanoHTTPD.Method.GET, Pattern.compile("^/$"), this::root);
        this.addRoute(NanoHTTPD.Method.GET, Pattern.compile("/status"), this::status);
        this.addRoute(NanoHTTPD.Method.POST, Pattern.compile("/api/profiles/minecraft"), this::profiles);
        this.addRoute(NanoHTTPD.Method.GET, Pattern.compile("/sessionserver/session/minecraft/hasJoined"), this::hasJoined);
        this.addRoute(NanoHTTPD.Method.POST, Pattern.compile("/sessionserver/session/minecraft/join"), this::joinServer);
        this.addRoute(NanoHTTPD.Method.GET, Pattern.compile("/sessionserver/session/minecraft/profile/(?<uuid>[a-f0-9]{32})"), this::profile);
        this.addRoute(NanoHTTPD.Method.GET, Pattern.compile("/textures/(?<hash>[a-f0-9]{64})"), this::texture);
    }

    private NanoHTTPD.Response root(HttpServer.Request request) {
        return YggdrasilServer.ok(Lang.mapOf(Pair.pair("signaturePublickey", KeyUtils.toPEMPublicKey(YggdrasilServer.getSignaturePublicKey())), Pair.pair("skinDomains", Arrays.asList("127.0.0.1", "localhost")), Pair.pair("meta", Lang.mapOf(Pair.pair("serverName", "HMCL"), Pair.pair("implementationName", "HMCL"), Pair.pair("implementationVersion", "1.0"), Pair.pair("feature.non_email_login", true)))));
    }

    private NanoHTTPD.Response status(HttpServer.Request request) {
        return YggdrasilServer.ok(Lang.mapOf(Pair.pair("user.count", this.charactersByUuid.size()), Pair.pair("token.count", 0), Pair.pair("pendingAuthentication.count", 0)));
    }

    private NanoHTTPD.Response profiles(HttpServer.Request request) throws IOException {
        List names = (List)JsonUtils.fromNonNullJsonFully(request.getSession().getInputStream(), new TypeToken<List<String>>(){}.getType());
        return YggdrasilServer.ok(names.stream().distinct().map(this::findCharacterByName).flatMap(Lang::toStream).map(Character::toSimpleResponse).collect(Collectors.toList()));
    }

    private NanoHTTPD.Response hasJoined(HttpServer.Request request) {
        if (!request.getQuery().containsKey("username")) {
            return YggdrasilServer.badRequest();
        }
        Optional<Character> character = this.findCharacterByName(request.getQuery().get("username"));
        if (character.isPresent()) {
            return YggdrasilServer.ok(character.get().toCompleteResponse(this.getRootUrl()));
        }
        return HttpServer.noContent();
    }

    private NanoHTTPD.Response joinServer(HttpServer.Request request) {
        return YggdrasilServer.noContent();
    }

    private NanoHTTPD.Response profile(HttpServer.Request request) {
        String uuid = request.getPathVariables().group("uuid");
        Optional<Character> character = this.findCharacterByUuid(UUIDTypeAdapter.fromString(uuid));
        if (character.isPresent()) {
            return YggdrasilServer.ok(character.get().toCompleteResponse(this.getRootUrl()));
        }
        return HttpServer.noContent();
    }

    private NanoHTTPD.Response texture(HttpServer.Request request) {
        String hash = request.getPathVariables().group("hash");
        if (Texture.hasTexture(hash)) {
            Texture texture = Texture.getTexture(hash);
            byte[] data = PNGJavaFXUtils.writeImageToArray(texture.getImage());
            NanoHTTPD.Response response = YggdrasilServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "image/png", new ByteArrayInputStream(data), data.length);
            response.addHeader("Etag", String.format("\"%s\"", hash));
            response.addHeader("Cache-Control", "max-age=2592000, public");
            return response;
        }
        return YggdrasilServer.notFound();
    }

    private Optional<Character> findCharacterByUuid(UUID uuid) {
        return Optional.ofNullable(this.charactersByUuid.get(uuid));
    }

    private Optional<Character> findCharacterByName(String uuid) {
        return Optional.ofNullable(this.charactersByName.get(uuid));
    }

    public void addCharacter(Character character) {
        this.charactersByUuid.put(character.getUUID(), character);
        this.charactersByName.put(character.getName(), character);
    }

    public static PublicKey getSignaturePublicKey() {
        return keyPair.getPublic();
    }

    private static String sign(String data) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(keyPair.getPrivate(), new SecureRandom());
            signature.update(data.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @SafeVarargs
    public static List<?> properties(Map.Entry<String, String> ... entries) {
        return YggdrasilServer.properties(false, entries);
    }

    @SafeVarargs
    public static List<?> properties(boolean sign, Map.Entry<String, String> ... entries) {
        return Stream.of(entries).map(entry -> {
            LinkedHashMap<String, String> property = new LinkedHashMap<String, String>();
            property.put("name", (String)entry.getKey());
            property.put("value", (String)entry.getValue());
            if (sign) {
                property.put("signature", YggdrasilServer.sign((String)entry.getValue()));
            }
            return property;
        }).collect(Collectors.toList());
    }

    public static class Character {
        private final UUID uuid;
        private final String name;
        private final Skin.LoadedSkin skin;

        public Character(UUID uuid, String name, Skin.LoadedSkin skin) {
            this.uuid = uuid;
            this.name = name;
            this.skin = skin;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public GameProfile toSimpleResponse() {
            return new GameProfile(this.uuid, this.name);
        }

        public Object toCompleteResponse(String rootUrl) {
            HashMap realTextures = new HashMap();
            if (this.skin != null && this.skin.getSkin() != null) {
                if (this.skin.getModel() == TextureModel.ALEX) {
                    realTextures.put("SKIN", Lang.mapOf(Pair.pair("url", rootUrl + "/textures/" + this.skin.getSkin().getHash()), Pair.pair("metadata", Lang.mapOf(Pair.pair("model", "slim")))));
                } else {
                    realTextures.put("SKIN", Lang.mapOf(Pair.pair("url", rootUrl + "/textures/" + this.skin.getSkin().getHash())));
                }
            }
            if (this.skin != null && this.skin.getCape() != null) {
                realTextures.put("CAPE", Lang.mapOf(Pair.pair("url", rootUrl + "/textures/" + this.skin.getCape().getHash())));
            }
            Map textureResponse = Lang.mapOf(Pair.pair("timestamp", System.currentTimeMillis()), Pair.pair("profileId", this.uuid), Pair.pair("profileName", this.name), Pair.pair("textures", realTextures));
            return Lang.mapOf(Pair.pair("id", this.uuid), Pair.pair("name", this.name), Pair.pair("properties", YggdrasilServer.properties(true, Pair.pair("textures", new String(Base64.getEncoder().encode(JsonUtils.GSON.toJson(textureResponse).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8)))));
        }
    }
}

