/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.microsoft;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import javafx.beans.binding.ObjectBinding;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.OAuthAccount;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftService;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftSession;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilService;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class MicrosoftAccount
extends OAuthAccount {
    protected final MicrosoftService service;
    protected UUID characterUUID;
    private boolean authenticated = false;
    private MicrosoftSession session;

    protected MicrosoftAccount(MicrosoftService service, MicrosoftSession session) {
        this.service = Objects.requireNonNull(service);
        this.session = Objects.requireNonNull(session);
        this.characterUUID = Objects.requireNonNull(session.getProfile().getId());
    }

    protected MicrosoftAccount(MicrosoftService service, CharacterSelector characterSelector) throws AuthenticationException {
        this.service = Objects.requireNonNull(service);
        MicrosoftSession acquiredSession = service.authenticate();
        this.session = acquiredSession.getProfile() == null ? service.refresh(acquiredSession) : acquiredSession;
        this.characterUUID = this.session.getProfile().getId();
        this.authenticated = true;
    }

    @Override
    public String getUsername() {
        return "";
    }

    @Override
    public String getCharacter() {
        return this.session.getProfile().getName();
    }

    @Override
    public UUID getUUID() {
        return this.session.getProfile().getId();
    }

    @Override
    public String getIdentifier() {
        return "microsoft:" + this.getUUID();
    }

    @Override
    public AuthInfo logIn() throws AuthenticationException {
        if (!this.authenticated || !this.service.validate(this.session.getNotAfter(), this.session.getTokenType(), this.session.getAccessToken())) {
            MicrosoftSession acquiredSession = this.service.refresh(this.session);
            if (!Objects.equals(acquiredSession.getProfile().getId(), this.session.getProfile().getId())) {
                throw new ServerResponseMalformedException("Selected profile changed");
            }
            this.session = acquiredSession;
            this.authenticated = true;
            this.invalidate();
        }
        return this.session.toAuthInfo();
    }

    @Override
    public AuthInfo logInWhenCredentialsExpired() throws AuthenticationException {
        MicrosoftSession acquiredSession = this.service.authenticate();
        if (!Objects.equals(this.characterUUID, acquiredSession.getProfile().getId())) {
            throw new OAuthAccount.WrongAccountException(this.characterUUID, acquiredSession.getProfile().getId());
        }
        this.session = acquiredSession.getProfile() == null ? this.service.refresh(acquiredSession) : acquiredSession;
        this.authenticated = true;
        this.invalidate();
        return this.session.toAuthInfo();
    }

    @Override
    public AuthInfo playOffline() {
        return this.session.toAuthInfo();
    }

    @Override
    public Map<Object, Object> toStorage() {
        return this.session.toStorage();
    }

    public MicrosoftService getService() {
        return this.service;
    }

    @Override
    public ObjectBinding<Optional<Map<TextureType, Texture>>> getTextures() {
        return BindingMapping.of(this.service.getProfileRepository().binding(this.getUUID())).map(profile -> profile.flatMap(it -> {
            try {
                return YggdrasilService.getTextures(it);
            }
            catch (ServerResponseMalformedException e) {
                Logging.LOG.log(Level.WARNING, "Failed to parse texture payload", e);
                return Optional.empty();
            }
        }));
    }

    @Override
    public void clearCache() {
        this.authenticated = false;
    }

    @Override
    public String toString() {
        return "MicrosoftAccount[uuid=" + this.characterUUID + ", name=" + this.getCharacter() + "]";
    }

    @Override
    public int hashCode() {
        return this.characterUUID.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MicrosoftAccount that = (MicrosoftAccount)o;
        return this.isPortable() == that.isPortable() && this.characterUUID.equals(that.characterUUID);
    }
}

