/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.tree;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;

public final class ZipFileTree
extends ArchiveFileTree<ZipFile, ZipArchiveEntry> {
    public ZipFileTree(ZipFile file) throws IOException {
        super(file);
        try {
            Enumeration<ZipArchiveEntry> entries = file.getEntries();
            while (entries.hasMoreElements()) {
                this.addEntry(entries.nextElement());
            }
        }
        catch (Throwable e) {
            try {
                file.close();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        ((ZipFile)this.file).close();
    }

    @Override
    public InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        return ((ZipFile)this.getFile()).getInputStream(entry);
    }

    @Override
    public boolean isLink(ZipArchiveEntry entry) {
        return entry.isUnixSymlink();
    }

    @Override
    public String getLink(ZipArchiveEntry entry) throws IOException {
        return ((ZipFile)this.getFile()).getUnixSymlink(entry);
    }

    @Override
    public boolean isExecutable(ZipArchiveEntry entry) {
        return !entry.isDirectory() && !entry.isUnixSymlink() && (entry.getUnixMode() & 0x40) != 0;
    }
}

