/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.versions.ModCheckUpdatesTask;
import org.jackhuang.hmcl.ui.versions.ModListPageSkin;
import org.jackhuang.hmcl.ui.versions.ModUpdatesPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class ModListPage
extends ListPageBase<ModListPageSkin.ModInfoObject>
implements VersionPage.VersionLoadable,
PageAware {
    private final BooleanProperty modded = new SimpleBooleanProperty((Object)this, "modded", false);
    private ModManager modManager;
    private LibraryAnalyzer libraryAnalyzer;
    private Profile profile;
    private String versionId;

    public ModListPage() {
        FXUtils.applyDragListener((Node)this, it -> Arrays.asList("jar", "zip", "litemod").contains(FileUtils.getExtension(it)), mods -> {
            mods.forEach(it -> {
                try {
                    this.modManager.addMod(it.toPath());
                }
                catch (IOException | IllegalArgumentException e) {
                    Logger.LOG.warning("Unable to parse mod file " + it, e);
                }
            });
            this.loadMods(this.modManager);
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new ModListPageSkin(this);
    }

    public void refresh() {
        this.loadMods(this.modManager);
    }

    @Override
    public void loadVersion(Profile profile, String id) {
        this.profile = profile;
        this.versionId = id;
        HMCLGameRepository repository = profile.getRepository();
        Version resolved = repository.getResolvedPreservingPatchesVersion(id);
        this.libraryAnalyzer = LibraryAnalyzer.analyze(resolved, repository.getGameVersion(resolved).orElse(null));
        this.modded.set(this.libraryAnalyzer.hasModLoader());
        this.loadMods(profile.getRepository().getModManager(id));
    }

    private CompletableFuture<?> loadMods(ModManager modManager) {
        this.modManager = modManager;
        return CompletableFuture.supplyAsync(() -> {
            try {
                ModListPage modListPage = this;
                synchronized (modListPage) {
                    FXUtils.runInFX(() -> this.loadingProperty().set(true));
                    modManager.refreshMods();
                    return new ArrayList<LocalModFile>(modManager.getMods());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, Schedulers.defaultScheduler()).whenCompleteAsync((list, exception) -> {
            this.loadingProperty().set(false);
            if (exception == null) {
                this.itemsProperty().setAll((Collection)list.stream().map(ModListPageSkin.ModInfoObject::new).sorted().collect(Collectors.toList()));
            } else {
                this.getProperties().remove(ModListPage.class);
            }
            System.gc();
        }, Platform::runLater);
    }

    public void add() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("mods.choose_mod"));
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18n.i18n("extension.mod"), new String[]{"*.jar", "*.zip", "*.litemod"})});
        List res = chooser.showOpenMultipleDialog((Window)Controllers.getStage());
        if (res == null) {
            return;
        }
        ArrayList succeeded = new ArrayList(res.size());
        ArrayList failed = new ArrayList();
        Task.runAsync(() -> {
            for (File file : res) {
                try {
                    this.modManager.addMod(file.toPath());
                    succeeded.add(file.getName());
                }
                catch (Exception e) {
                    Logger.LOG.warning("Unable to add mod " + file, e);
                    failed.add(file.getName());
                }
            }
        }).withRunAsync(Schedulers.javafx(), () -> {
            ArrayList<String> prompt = new ArrayList<String>(1);
            if (!succeeded.isEmpty()) {
                prompt.add(I18n.i18n("mods.add.success", String.join((CharSequence)", ", succeeded)));
            }
            if (!failed.isEmpty()) {
                prompt.add(I18n.i18n("mods.add.failed", String.join((CharSequence)", ", failed)));
            }
            Controllers.dialog(String.join((CharSequence)"\n", prompt), I18n.i18n("mods.add"));
            this.loadMods(this.modManager);
        }).start();
    }

    public void removeSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        try {
            this.modManager.removeMods((LocalModFile[])selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).toArray(LocalModFile[]::new));
            this.loadMods(this.modManager);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void enableSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).forEach(info -> info.setActive(true));
    }

    public void disableSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).forEach(info -> info.setActive(false));
    }

    public void openModFolder() {
        FXUtils.openFolder(new File(this.profile.getRepository().getRunDirectory(this.versionId), "mods"));
    }

    public void checkUpdates() {
        Runnable action = () -> Controllers.taskDialog(Task.composeAsync(() -> {
            Optional<String> gameVersion = this.profile.getRepository().getGameVersion(this.versionId);
            if (gameVersion.isPresent()) {
                return new ModCheckUpdatesTask(gameVersion.get(), this.modManager.getMods());
            }
            return null;
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception != null || result == null) {
                Controllers.dialog("Failed to check updates", "failed", MessageDialogPane.MessageType.ERROR);
            } else if (result.isEmpty()) {
                Controllers.dialog(I18n.i18n("mods.check_updates.empty"));
            } else {
                Controllers.navigate((Node)new ModUpdatesPage(this.modManager, (List<LocalModFile.ModUpdate>)result));
            }
        }).withStagesHint(Collections.singletonList("mods.check_updates")), I18n.i18n("update.checking"), TaskCancellationAction.NORMAL);
        if (this.profile.getRepository().isModpack(this.versionId)) {
            Controllers.confirm(I18n.i18n("mods.update_modpack_mod.warning"), null, MessageDialogPane.MessageType.WARNING, action, null);
        } else {
            action.run();
        }
    }

    public void download() {
        Controllers.getDownloadPage().showModDownloads().selectVersion(this.versionId);
        Controllers.navigate((Node)Controllers.getDownloadPage());
    }

    public void rollback(LocalModFile from, LocalModFile to) {
        try {
            this.modManager.rollback(from, to);
            this.refresh();
        }
        catch (IOException ex) {
            Controllers.showToast(I18n.i18n("message.failed"));
        }
    }

    public boolean isModded() {
        return this.modded.get();
    }

    public BooleanProperty moddedProperty() {
        return this.modded;
    }

    public void setModded(boolean modded) {
        this.modded.set(modded);
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getVersionId() {
        return this.versionId;
    }
}

