/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.effects.JFXDepthManager;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.mod.Datapack;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.FloatListCell;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.DatapackListPage;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

class DatapackListPageSkin
extends SkinBase<DatapackListPage> {
    DatapackListPageSkin(DatapackListPage skinnable) {
        super((Control)skinnable);
        BorderPane root = new BorderPane();
        root.getStyleClass().add((Object)"content-background");
        final JFXListView listView = new JFXListView();
        HBox toolbar = new HBox();
        toolbar.getStyleClass().add((Object)"jfx-tool-bar-second");
        JFXDepthManager.setDepth((Node)toolbar, 1);
        toolbar.setPickOnBounds(false);
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("datapack.add"), SVG.PLUS, skinnable::add));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("button.remove"), SVG.DELETE, () -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> skinnable.removeSelected((ObservableList<DatapackInfoObject>)listView.getSelectionModel().getSelectedItems()), null)));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("mods.enable"), SVG.CHECK, () -> skinnable.enableSelected((ObservableList<DatapackInfoObject>)listView.getSelectionModel().getSelectedItems())));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("mods.disable"), SVG.CLOSE, () -> skinnable.disableSelected((ObservableList<DatapackInfoObject>)listView.getSelectionModel().getSelectedItems())));
        root.setTop((Node)toolbar);
        SpinnerPane center = new SpinnerPane();
        center.getStyleClass().add((Object)"large-spinner-pane");
        center.loadingProperty().bind((ObservableValue)skinnable.loadingProperty());
        listView.setCellFactory(x -> new FloatListCell<DatapackInfoObject>(listView){
            JFXCheckBox checkBox;
            TwoLineListItem content;
            BooleanProperty booleanProperty;
            {
                super(listView2);
                this.checkBox = new JFXCheckBox();
                this.content = new TwoLineListItem();
                Region clippedContainer = (Region)listView.lookup(".clipped-container");
                HBox container = new HBox(8.0);
                container.setPadding(new Insets(0.0, 0.0, 0.0, 6.0));
                container.setAlignment(Pos.CENTER_LEFT);
                this.pane.getChildren().add((Object)container);
                this.pane.setPadding(new Insets(8.0, 8.0, 8.0, 0.0));
                if (clippedContainer != null) {
                    this.maxWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                    this.prefWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                    this.minWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                }
                container.getChildren().setAll((Object[])new Node[]{this.checkBox, this.content});
            }

            @Override
            protected void updateControl(DatapackInfoObject dataItem, boolean empty) {
                if (empty) {
                    return;
                }
                this.content.setTitle(dataItem.getTitle());
                this.content.setSubtitle(dataItem.getSubtitle());
                if (this.booleanProperty != null) {
                    this.checkBox.selectedProperty().unbindBidirectional((Property)this.booleanProperty);
                }
                this.booleanProperty = dataItem.active;
                this.checkBox.selectedProperty().bindBidirectional((Property)this.booleanProperty);
            }
        });
        listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Bindings.bindContent((List)listView.getItems(), skinnable.getItems());
        center.setContent((Node)listView);
        root.setCenter((Node)center);
        this.getChildren().setAll((Object[])new Node[]{root});
    }

    static class DatapackInfoObject
    extends RecursiveTreeObject<DatapackInfoObject> {
        private final BooleanProperty active;
        private final Datapack.Pack packInfo;

        DatapackInfoObject(Datapack.Pack packInfo) {
            this.packInfo = packInfo;
            this.active = packInfo.activeProperty();
        }

        String getTitle() {
            return this.packInfo.getId();
        }

        String getSubtitle() {
            return StringUtils.parseColorEscapes(this.packInfo.getDescription().toString());
        }

        Datapack.Pack getPackInfo() {
            return this.packInfo;
        }
    }
}

