/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.validation.base.ValidatorBase;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.ManuallyCreatedModpackException;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WebPage;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.ModpackPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class LocalModpackPage
extends ModpackPage {
    private final BooleanProperty installAsVersion = new SimpleBooleanProperty(true);
    private Modpack manifest = null;
    private Charset charset;
    public static final String MODPACK_FILE = "MODPACK_FILE";
    public static final String MODPACK_NAME = "MODPACK_NAME";
    public static final String MODPACK_MANIFEST = "MODPACK_MANIFEST";
    public static final String MODPACK_CHARSET = "MODPACK_CHARSET";
    public static final String MODPACK_MANUALLY_CREATED = "MODPACK_MANUALLY_CREATED";

    public LocalModpackPage(WizardController controller) {
        super(controller);
        File selectedFile;
        Profile profile = (Profile)controller.getSettings().get("PROFILE");
        Optional<String> name = Lang.tryCast(controller.getSettings().get(MODPACK_NAME), String.class);
        if (name.isPresent()) {
            this.txtModpackName.setText(name.get());
            this.txtModpackName.setDisable(true);
        } else {
            FXUtils.onChangeAndOperate(this.installAsVersion, installAsVersion -> {
                if (installAsVersion.booleanValue()) {
                    this.txtModpackName.getValidators().setAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !profile.getRepository().versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
                } else {
                    this.txtModpackName.getValidators().setAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !ModpackHelper.isExternalGameNameConflicts(str) && Profiles.getProfiles().stream().noneMatch(p -> p.getName().equals(str))), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
                }
            });
        }
        this.btnDescription.setVisible(false);
        Optional<File> filePath = Lang.tryCast(controller.getSettings().get(MODPACK_FILE), File.class);
        if (filePath.isPresent()) {
            selectedFile = filePath.get();
        } else {
            FileChooser chooser = new FileChooser();
            chooser.setTitle(I18n.i18n("modpack.choose"));
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip"}));
            selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
            if (selectedFile == null) {
                controller.onEnd();
                return;
            }
            controller.getSettings().put(MODPACK_FILE, selectedFile);
        }
        this.showSpinner();
        Task.supplyAsync(() -> CompressingUtils.findSuitableEncoding(selectedFile.toPath())).thenApplyAsync(encoding -> {
            this.charset = encoding;
            this.manifest = ModpackHelper.readModpackManifest(selectedFile.toPath(), encoding);
            return this.manifest;
        }).whenComplete(Schedulers.javafx(), (manifest, exception) -> {
            if (exception instanceof ManuallyCreatedModpackException) {
                this.hideSpinner();
                this.lblName.setText(selectedFile.getName());
                this.installAsVersion.set(false);
                if (!name.isPresent()) {
                    this.txtModpackName.setText(FileUtils.getNameWithoutExtension(selectedFile));
                }
                Controllers.confirm(I18n.i18n("modpack.type.manual.warning"), I18n.i18n("install.modpack"), MessageDialogPane.MessageType.WARNING, () -> {}, controller::onEnd);
                controller.getSettings().put(MODPACK_MANUALLY_CREATED, true);
            } else if (exception != null) {
                Logger.LOG.warning("Failed to read modpack manifest", exception);
                Controllers.dialog(I18n.i18n("modpack.task.install.error"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                Platform.runLater(controller::onEnd);
            } else {
                this.hideSpinner();
                controller.getSettings().put(MODPACK_MANIFEST, manifest);
                this.lblName.setText(manifest.getName());
                this.lblVersion.setText(manifest.getVersion());
                this.lblAuthor.setText(manifest.getAuthor());
                if (!name.isPresent()) {
                    this.txtModpackName.setText(manifest.getName().trim());
                }
                this.btnDescription.setVisible(StringUtils.isNotBlank(manifest.getDescription()));
            }
        }).start();
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(MODPACK_FILE);
    }

    @Override
    protected void onInstall() {
        if (!this.txtModpackName.validate()) {
            return;
        }
        this.controller.getSettings().put(MODPACK_NAME, this.txtModpackName.getText());
        this.controller.getSettings().put(MODPACK_CHARSET, this.charset);
        this.controller.onFinish();
    }

    @Override
    protected void onDescribe() {
        if (this.manifest != null) {
            Controllers.navigate((Node)new WebPage(I18n.i18n("modpack.description"), this.manifest.getDescription()));
        }
    }
}

