/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import java.io.IOException;
import java.net.URL;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.HTMLRenderer;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public final class UpgradeDialog
extends JFXDialogLayout {
    public UpgradeDialog(RemoteVersion remoteVersion, Runnable updateRunnable) {
        this.setHeading(new Node[]{new Label(I18n.i18n("update.changelog"))});
        this.setBody(new Node[]{new ProgressIndicator()});
        String url = "https://docs.hmcl.net/changelog/" + remoteVersion.getChannel().channelName + ".html";
        Task.supplyAsync(Schedulers.io(), () -> {
            Document document = Jsoup.parse(new URL(url), 30000);
            org.jsoup.nodes.Node node = document.selectFirst("#nowchange");
            if (node == null) {
                throw new IOException("Cannot find #nowchange in document");
            }
            HTMLRenderer renderer = new HTMLRenderer(uri -> {
                Logger.LOG.info("Open link: " + uri);
                FXUtils.openLink(uri.toString());
            });
            do {
                renderer.appendNode(node);
            } while ((node = node.nextSibling()) != null);
            return renderer.render();
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                ScrollPane scrollPane = new ScrollPane((Node)result);
                scrollPane.setFitToWidth(true);
                this.setBody(new Node[]{scrollPane});
            } else {
                Logger.LOG.warning("Failed to load update log, trying to open it in browser");
                FXUtils.openLink(url);
                this.setBody(new Node[0]);
            }
        }).start();
        JFXHyperlink openInBrowser = new JFXHyperlink(I18n.i18n("web.view_in_browser"));
        openInBrowser.setExternalLink(url);
        JFXButton updateButton = new JFXButton(I18n.i18n("update.accept"));
        updateButton.getStyleClass().add((Object)"dialog-accept");
        updateButton.setOnAction(e -> updateRunnable.run());
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"dialog-cancel");
        cancelButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
        this.setActions(new Node[]{openInBrowser, updateButton, cancelButton});
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
    }
}

