/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public class InstallerItem
extends Control {
    private final String id;
    private final VersionIconType iconType;
    private final Style style;
    private final ObjectProperty<InstalledState> versionProperty = new SimpleObjectProperty((Object)this, "version", null);
    private final ObjectProperty<State> resolvedStateProperty = new SimpleObjectProperty((Object)this, "resolvedState", (Object)InstallableState.INSTANCE);
    private final ObjectProperty<Runnable> onInstall = new SimpleObjectProperty((Object)this, "onInstall");
    private final ObjectProperty<Runnable> onRemove = new SimpleObjectProperty((Object)this, "onRemove");

    public InstallerItem(LibraryAnalyzer.LibraryType id, Style style) {
        this(id.getPatchId(), style);
    }

    public InstallerItem(String id, Style style) {
        this.id = id;
        this.style = style;
        switch (id) {
            case "game": {
                this.iconType = VersionIconType.GRASS;
                break;
            }
            case "fabric": 
            case "fabric-api": {
                this.iconType = VersionIconType.FABRIC;
                break;
            }
            case "forge": {
                this.iconType = VersionIconType.FORGE;
                break;
            }
            case "liteloader": {
                this.iconType = VersionIconType.CHICKEN;
                break;
            }
            case "optifine": {
                this.iconType = VersionIconType.OPTIFINE;
                break;
            }
            case "quilt": 
            case "quilt-api": {
                this.iconType = VersionIconType.QUILT;
                break;
            }
            case "neoforge": {
                this.iconType = VersionIconType.NEO_FORGE;
                break;
            }
            default: {
                this.iconType = null;
            }
        }
    }

    public String getLibraryId() {
        return this.id;
    }

    public ObjectProperty<InstalledState> versionProperty() {
        return this.versionProperty;
    }

    public ObjectProperty<State> resolvedStateProperty() {
        return this.resolvedStateProperty;
    }

    public ObjectProperty<Runnable> onInstallProperty() {
        return this.onInstall;
    }

    public Runnable getOnInstall() {
        return (Runnable)this.onInstall.get();
    }

    public void setOnInstall(Runnable onInstall) {
        this.onInstall.set((Object)onInstall);
    }

    public ObjectProperty<Runnable> onRemoveProperty() {
        return this.onRemove;
    }

    public Runnable getOnRemove() {
        return (Runnable)this.onRemove.get();
    }

    public void setOnRemove(Runnable onRemove) {
        this.onRemove.set((Object)onRemove);
    }

    protected Skin<?> createDefaultSkin() {
        return new InstallerItemSkin(this);
    }

    public static enum Style {
        LIST_ITEM,
        CARD;

    }

    public static final class InstallableState
    implements State {
        public static final InstallableState INSTANCE = new InstallableState();

        private InstallableState() {
        }
    }

    private static final class InstallerItemSkin
    extends SkinBase<InstallerItem> {
        private static final PseudoClass LIST_ITEM = PseudoClass.getPseudoClass((String)"list-item");
        private static final PseudoClass CARD = PseudoClass.getPseudoClass((String)"card");
        private static final WeakListenerHolder holder = new WeakListenerHolder();

        InstallerItemSkin(InstallerItem control) {
            super((Control)control);
            VBox pane;
            if (control.style == Style.CARD) {
                pane = new VBox();
                holder.add(FXUtils.onWeakChange(pane.widthProperty(), arg_0 -> InstallerItemSkin.lambda$new$0((Pane)pane, arg_0)));
            } else {
                pane = new HBox();
            }
            pane.getStyleClass().add((Object)"installer-item");
            RipplerContainer container = new RipplerContainer((Node)pane);
            this.getChildren().setAll((Object[])new Node[]{container});
            pane.pseudoClassStateChanged(LIST_ITEM, control.style == Style.LIST_ITEM);
            pane.pseudoClassStateChanged(CARD, control.style == Style.CARD);
            if (control.iconType != null) {
                ImageView view = new ImageView(control.iconType.getIcon());
                Node node = FXUtils.limitingSize((Node)view, 32.0, 32.0);
                node.setMouseTransparent(true);
                node.getStyleClass().add((Object)"installer-item-image");
                pane.getChildren().add((Object)node);
                if (control.style == Style.CARD) {
                    VBox.setMargin((Node)node, (Insets)new Insets(8.0, 0.0, 16.0, 0.0));
                }
            }
            Label nameLabel = new Label();
            nameLabel.getStyleClass().add((Object)"installer-item-name");
            nameLabel.setMouseTransparent(true);
            pane.getChildren().add((Object)nameLabel);
            nameLabel.textProperty().set((Object)(I18n.hasKey("install.installer." + control.id) ? I18n.i18n("install.installer." + control.id) : control.id));
            HBox.setMargin((Node)nameLabel, (Insets)new Insets(0.0, 4.0, 0.0, 4.0));
            Label statusLabel = new Label();
            statusLabel.getStyleClass().add((Object)"installer-item-status");
            statusLabel.setMouseTransparent(true);
            pane.getChildren().add((Object)statusLabel);
            HBox.setHgrow((Node)statusLabel, (Priority)Priority.ALWAYS);
            statusLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                State state = (State)control.resolvedStateProperty.get();
                if (state instanceof InstalledState) {
                    InstalledState s = (InstalledState)state;
                    if (s.incompatibleWithGame) {
                        return I18n.i18n("install.installer.change_version", s.version);
                    }
                    if (s.external) {
                        return I18n.i18n("install.installer.external_version", s.version);
                    }
                    return I18n.i18n("install.installer.version", s.version);
                }
                if (state instanceof InstallableState) {
                    return I18n.i18n("install.installer.not_installed");
                }
                if (state instanceof IncompatibleState) {
                    return I18n.i18n("install.installer.incompatible", I18n.i18n("install.installer." + ((IncompatibleState)state).incompatibleItemName));
                }
                throw new AssertionError((Object)("Unknown state type: " + state.getClass()));
            }, (Observable[])new Observable[]{control.resolvedStateProperty}));
            BorderPane.setMargin((Node)statusLabel, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
            BorderPane.setAlignment((Node)statusLabel, (Pos)Pos.CENTER_LEFT);
            HBox buttonsContainer = new HBox();
            buttonsContainer.setSpacing(8.0);
            buttonsContainer.setAlignment(Pos.CENTER);
            pane.getChildren().add((Object)buttonsContainer);
            JFXButton removeButton = new JFXButton();
            removeButton.setGraphic(SVG.CLOSE.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
            removeButton.getStyleClass().add((Object)"toggle-icon4");
            if (control.id.equals(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId())) {
                removeButton.setVisible(false);
            } else {
                removeButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> control.resolvedStateProperty.get() instanceof InstalledState, (Observable[])new Observable[]{control.resolvedStateProperty}));
            }
            removeButton.managedProperty().bind((ObservableValue)removeButton.visibleProperty());
            removeButton.setOnAction(e -> {
                Runnable onRemove = control.getOnRemove();
                if (onRemove != null) {
                    onRemove.run();
                }
            });
            buttonsContainer.getChildren().add((Object)removeButton);
            JFXButton installButton = new JFXButton();
            installButton.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> control.resolvedStateProperty.get() instanceof InstallableState ? SVG.ARROW_RIGHT.createIcon((Paint)Theme.blackFill(), -1.0, -1.0) : SVG.UPDATE.createIcon((Paint)Theme.blackFill(), -1.0, -1.0), (Observable[])new Observable[]{control.resolvedStateProperty}));
            installButton.getStyleClass().add((Object)"toggle-icon4");
            installButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                if (control.getOnInstall() == null) {
                    return false;
                }
                State state = (State)control.resolvedStateProperty.get();
                if (state instanceof InstallableState) {
                    return true;
                }
                if (state instanceof InstalledState) {
                    return !((InstalledState)state).external;
                }
                return false;
            }, (Observable[])new Observable[]{control.resolvedStateProperty, control.onInstall}));
            installButton.managedProperty().bind((ObservableValue)installButton.visibleProperty());
            installButton.setOnAction(e -> {
                Runnable onInstall = control.getOnInstall();
                if (onInstall != null) {
                    onInstall.run();
                }
            });
            buttonsContainer.getChildren().add((Object)installButton);
            FXUtils.onChangeAndOperate(installButton.visibleProperty(), arg_0 -> InstallerItemSkin.lambda$new$8(container, control, (Pane)pane, arg_0));
        }

        private static /* synthetic */ void lambda$new$8(RipplerContainer container, InstallerItem control, Pane pane, Boolean clickable) {
            if (clickable.booleanValue()) {
                container.setOnMouseClicked(event -> {
                    Runnable onInstall = control.getOnInstall();
                    if (onInstall != null && event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 1) {
                        onInstall.run();
                        event.consume();
                    }
                });
                pane.setCursor(Cursor.HAND);
            } else {
                container.setOnMouseClicked(null);
                pane.setCursor(Cursor.DEFAULT);
            }
        }

        private static /* synthetic */ void lambda$new$0(Pane pane, Number v) {
            FXUtils.setLimitHeight((Region)pane, v.doubleValue() * 0.7);
        }
    }

    public static final class InstallerItemGroup {
        private final InstallerItem game;
        private final InstallerItem[] libraries;

        private Set<InstallerItem> getIncompatibles(Map<InstallerItem, Set<InstallerItem>> incompatibleMap, InstallerItem item) {
            return incompatibleMap.computeIfAbsent(item, it -> new HashSet());
        }

        private void addIncompatibles(Map<InstallerItem, Set<InstallerItem>> incompatibleMap, InstallerItem item, InstallerItem ... others) {
            Set<InstallerItem> set = this.getIncompatibles(incompatibleMap, item);
            for (InstallerItem other : others) {
                set.add(other);
                this.getIncompatibles(incompatibleMap, other).add(item);
            }
        }

        private void mutualIncompatible(Map<InstallerItem, Set<InstallerItem>> incompatibleMap, InstallerItem ... items) {
            for (InstallerItem item : items) {
                Set<InstallerItem> set = this.getIncompatibles(incompatibleMap, item);
                for (InstallerItem item2 : items) {
                    if (item2 == item) continue;
                    set.add(item2);
                }
            }
        }

        public InstallerItemGroup(String gameVersion, Style style) {
            InstallerItem[] all;
            this.game = new InstallerItem(LibraryAnalyzer.LibraryType.MINECRAFT, style);
            InstallerItem fabric = new InstallerItem(LibraryAnalyzer.LibraryType.FABRIC, style);
            InstallerItem fabricApi = new InstallerItem(LibraryAnalyzer.LibraryType.FABRIC_API, style);
            InstallerItem forge = new InstallerItem(LibraryAnalyzer.LibraryType.FORGE, style);
            InstallerItem neoForge = new InstallerItem(LibraryAnalyzer.LibraryType.NEO_FORGE, style);
            InstallerItem liteLoader = new InstallerItem(LibraryAnalyzer.LibraryType.LITELOADER, style);
            InstallerItem optiFine = new InstallerItem(LibraryAnalyzer.LibraryType.OPTIFINE, style);
            InstallerItem quilt = new InstallerItem(LibraryAnalyzer.LibraryType.QUILT, style);
            InstallerItem quiltApi = new InstallerItem(LibraryAnalyzer.LibraryType.QUILT_API, style);
            HashMap<InstallerItem, Set<InstallerItem>> incompatibleMap = new HashMap<InstallerItem, Set<InstallerItem>>();
            this.mutualIncompatible(incompatibleMap, forge, fabric, quilt, neoForge);
            this.addIncompatibles(incompatibleMap, liteLoader, fabric, quilt, neoForge);
            this.addIncompatibles(incompatibleMap, optiFine, fabric, quilt, neoForge);
            this.addIncompatibles(incompatibleMap, fabricApi, forge, quiltApi, neoForge, liteLoader, optiFine);
            this.addIncompatibles(incompatibleMap, quiltApi, forge, fabric, fabricApi, neoForge, liteLoader, optiFine);
            for (Map.Entry entry : incompatibleMap.entrySet()) {
                InstallerItem item = (InstallerItem)((Object)entry.getKey());
                Set incompatibleItems = (Set)entry.getValue();
                Observable[] bindings = new Observable[incompatibleItems.size() + 1];
                bindings[0] = item.versionProperty;
                int i = 1;
                for (InstallerItem other : incompatibleItems) {
                    bindings[i++] = other.versionProperty;
                }
                item.resolvedStateProperty.bind((ObservableValue)Bindings.createObjectBinding(() -> {
                    InstalledState itemVersion = (InstalledState)item.versionProperty.get();
                    if (itemVersion != null) {
                        return itemVersion;
                    }
                    for (InstallerItem other : incompatibleItems) {
                        InstalledState otherVersion = (InstalledState)other.versionProperty.get();
                        if (otherVersion == null) continue;
                        return new IncompatibleState(other.id, otherVersion.version);
                    }
                    return InstallableState.INSTANCE;
                }, (Observable[])bindings));
            }
            if (gameVersion != null) {
                this.game.versionProperty.set((Object)new InstalledState(gameVersion, false, false));
            }
            for (InstallerItem item : all = new InstallerItem[]{this.game, forge, neoForge, liteLoader, optiFine, fabric, fabricApi, quilt, quiltApi}) {
                if (item.resolvedStateProperty.isBound()) continue;
                item.resolvedStateProperty.bind((ObservableValue)item.versionProperty);
            }
            this.libraries = gameVersion == null ? all : (GameVersionNumber.compare(gameVersion, "1.13") < 0 ? new InstallerItem[]{this.game, forge, liteLoader, optiFine} : new InstallerItem[]{this.game, forge, neoForge, optiFine, fabric, fabricApi, quilt, quiltApi});
        }

        public InstallerItem getGame() {
            return this.game;
        }

        public InstallerItem[] getLibraries() {
            return this.libraries;
        }
    }

    public static final class InstalledState
    implements State {
        private final String version;
        private final boolean external;
        private final boolean incompatibleWithGame;

        public InstalledState(String version, boolean external, boolean incompatibleWithGame) {
            this.version = version;
            this.external = external;
            this.incompatibleWithGame = incompatibleWithGame;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isExternal() {
            return this.external;
        }

        public boolean isIncompatibleWithGame() {
            return this.incompatibleWithGame;
        }
    }

    public static final class IncompatibleState
    implements State {
        private final String incompatibleItemName;
        private final String incompatibleItemVersion;

        public IncompatibleState(String incompatibleItemName, String incompatibleItemVersion) {
            this.incompatibleItemName = incompatibleItemName;
            this.incompatibleItemVersion = incompatibleItemVersion;
        }

        public String getIncompatibleItemName() {
            return this.incompatibleItemName;
        }

        public String getIncompatibleItemVersion() {
            return this.incompatibleItemVersion;
        }
    }

    public static interface State {
    }
}

