/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCInstanceConfiguration;
import org.jackhuang.hmcl.mod.multimc.MultiMCInstancePatch;
import org.jackhuang.hmcl.mod.multimc.MultiMCManifest;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackProvider;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class MultiMCModpackInstallTask
extends Task<Void> {
    private final File zipFile;
    private final Modpack modpack;
    private final MultiMCInstanceConfiguration manifest;
    private final String name;
    private final DefaultGameRepository repository;
    private final List<Task<?>> dependencies = new ArrayList(1);
    private final List<Task<?>> dependents = new ArrayList(4);

    public MultiMCModpackInstallTask(DefaultDependencyManager dependencyManager, File zipFile, Modpack modpack, MultiMCInstanceConfiguration manifest, String name) {
        this.zipFile = zipFile;
        this.modpack = modpack;
        this.manifest = manifest;
        this.name = name;
        this.repository = dependencyManager.getGameRepository();
        File json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && !json.exists()) {
            throw new IllegalArgumentException("Version " + name + " already exists.");
        }
        GameBuilder builder = dependencyManager.gameBuilder().name(name).gameVersion(manifest.getGameVersion());
        if (manifest.getMmcPack() != null) {
            Optional<MultiMCManifest.MultiMCManifestComponent> forge = manifest.getMmcPack().getComponents().stream().filter(e -> e.getUid().equals("net.minecraftforge")).findAny();
            forge.ifPresent(c -> {
                if (c.getVersion() != null) {
                    builder.version("forge", c.getVersion());
                }
            });
            Optional<MultiMCManifest.MultiMCManifestComponent> neoForge = manifest.getMmcPack().getComponents().stream().filter(e -> e.getUid().equals("net.neoforged")).findAny();
            neoForge.ifPresent(c -> {
                if (c.getVersion() != null) {
                    builder.version("neoforge", c.getVersion());
                }
            });
            Optional<MultiMCManifest.MultiMCManifestComponent> liteLoader = manifest.getMmcPack().getComponents().stream().filter(e -> e.getUid().equals("com.mumfrey.liteloader")).findAny();
            liteLoader.ifPresent(c -> {
                if (c.getVersion() != null) {
                    builder.version("liteloader", c.getVersion());
                }
            });
            Optional<MultiMCManifest.MultiMCManifestComponent> fabric = manifest.getMmcPack().getComponents().stream().filter(e -> e.getUid().equals("net.fabricmc.fabric-loader")).findAny();
            fabric.ifPresent(c -> {
                if (c.getVersion() != null) {
                    builder.version("fabric", c.getVersion());
                }
            });
            Optional<MultiMCManifest.MultiMCManifestComponent> quilt = manifest.getMmcPack().getComponents().stream().filter(e -> e.getUid().equals("org.quiltmc.quilt-loader")).findAny();
            quilt.ifPresent(c -> {
                if (c.getVersion() != null) {
                    builder.version("quilt", c.getVersion());
                }
            });
        }
        this.dependents.add(builder.buildAsync());
        this.onDone().register(event -> {
            if (event.isFailed()) {
                this.repository.removeVersionFromDisk(name);
            }
        });
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        String subDirectory;
        File run = this.repository.getRunDirectory(this.name);
        File json = this.repository.getModpackConfiguration(this.name);
        ModpackConfiguration<MultiMCInstanceConfiguration> config = null;
        try {
            if (json.exists()) {
                config = JsonUtils.GSON.fromJson(FileUtils.readText(json), ModpackConfiguration.typeOf(MultiMCInstanceConfiguration.class));
                if (!MultiMCModpackProvider.INSTANCE.getName().equals(config.getType())) {
                    throw new IllegalArgumentException("Version " + this.name + " is not a MultiMC modpack. Cannot update this version.");
                }
            }
        }
        catch (JsonParseException | IOException exception) {
            // empty catch block
        }
        try (FileSystem fs = CompressingUtils.readonly(this.zipFile.toPath()).setEncoding(this.modpack.getEncoding()).build();){
            subDirectory = Files.exists(fs.getPath("/.minecraft", new String[0]), new LinkOption[0]) ? "/.minecraft" : (Files.exists(fs.getPath("/minecraft", new String[0]), new LinkOption[0]) ? "/minecraft" : (Files.exists(fs.getPath("/" + this.manifest.getName() + "/.minecraft", new String[0]), new LinkOption[0]) ? "/" + this.manifest.getName() + "/.minecraft" : (Files.exists(fs.getPath("/" + this.manifest.getName() + "/minecraft", new String[0]), new LinkOption[0]) ? "/" + this.manifest.getName() + "/minecraft" : "/" + this.manifest.getName() + "/.minecraft")));
        }
        this.dependents.add(new ModpackInstallTask<MultiMCInstanceConfiguration>(this.zipFile, run, this.modpack.getEncoding(), Collections.singletonList(subDirectory), any -> true, config).withStage("hmcl.modpack"));
        this.dependents.add(new MinecraftInstanceTask<MultiMCInstanceConfiguration>(this.zipFile, this.modpack.getEncoding(), Collections.singletonList(subDirectory), this.manifest, MultiMCModpackProvider.INSTANCE, this.manifest.getName(), null, this.repository.getModpackConfiguration(this.name)).withStage("hmcl.modpack"));
    }

    @Override
    public List<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public void execute() throws Exception {
        Version version = this.repository.readVersionJson(this.name);
        try (FileSystem fs = CompressingUtils.readonly(this.zipFile.toPath()).setAutoDetectEncoding(true).build();){
            Path jarmods;
            Path libraries;
            Path root = MultiMCModpackProvider.getRootPath(fs.getPath("/", new String[0]));
            Path patches = root.resolve("patches");
            if (Files.exists(patches, new LinkOption[0])) {
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(patches);){
                    for (Path patchJson : directoryStream) {
                        if (!patchJson.toString().endsWith(".json")) continue;
                        MultiMCInstancePatch multiMCPatch = JsonUtils.GSON.fromJson(FileUtils.readText(patchJson), MultiMCInstancePatch.class);
                        ArrayList<String> arguments = new ArrayList<String>();
                        for (String arg : multiMCPatch.getTweakers()) {
                            arguments.add("--tweakClass");
                            arguments.add(arg);
                        }
                        Version patch = new Version(multiMCPatch.getName(), multiMCPatch.getVersion(), 1, new Arguments().addGameArguments(arguments), multiMCPatch.getMainClass(), multiMCPatch.getLibraries());
                        version = version.addPatch(patch);
                    }
                }
            }
            if (Files.exists(libraries = root.resolve("libraries"), new LinkOption[0])) {
                FileUtils.copyDirectory(libraries, this.repository.getVersionRoot(this.name).toPath().resolve("libraries"));
            }
            if (Files.exists(jarmods = root.resolve("jarmods"), new LinkOption[0])) {
                FileUtils.copyDirectory(jarmods, this.repository.getVersionRoot(this.name).toPath().resolve("jarmods"));
            }
        }
        this.dependencies.add(this.repository.saveAsync(version));
    }
}

