/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.concurrency;

import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;

public class JFXUtilities {
    public static void runInFX(Runnable doRun) {
        if (Platform.isFxApplicationThread()) {
            doRun.run();
            return;
        }
        Platform.runLater((Runnable)doRun);
    }

    public static void runInFXAndWait(Runnable doRun) {
        if (Platform.isFxApplicationThread()) {
            doRun.run();
            return;
        }
        CountDownLatch doneLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                doRun.run();
            }
            finally {
                doneLatch.countDown();
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

