# 📝 OpenNotes

**OpenNotes** is a modern, lightweight, and privacy-respecting note-taking app built with **Jetpack Compose**, following **MVVM** and **Clean Architecture** principles. The app is 100% offline and open source.

---

## 🚀 Tech Stack

### 🧱 Architecture

- **MVVM (Model-View-ViewModel):** Clean separation between UI, business logic, and data layers.
- **Clean Architecture:** Modular layer-based design — UI → Domain → Data.

### 🛠 Core Technologies

| Technology            | Purpose                                                   |
|-----------------------|------------------------------------------------------------|
| **Kotlin**            | Modern Android development language                        |
| **Jetpack Compose**   | Declarative UI toolkit for building modern UIs             |
| **Room**              | Local database abstraction over SQLite                     |
| **Hilt (Dagger)**     | Dependency injection for modular and testable code         |
| **Kotlin Coroutines** | Asynchronous and background task handling                  |
| **Kotlin Flow**       | Reactive stream handling between data and UI               |
| **Navigation**        | Type-safe, stateful screen transitions                     |

---

## ✨ Features

- ✅ Create, edit, and delete notes  
- 🔍 Search notes by title and content  
- 🌙 AMOLED dark theme & Material You dynamic theming  
- 🔐 Fully offline — no cloud, no tracking  
- 🚫 No ads, no analytics  
- 💉 Built using scalable Clean Architecture & Dependency Injection  

---

## 📦 Installation

- 📥 Download the latest `.apk` from the [Releases](https://github.com/Fandroid745/Open-notes/releases) page.

---

## 🛡️ License

This project is licensed under the terms of the **GNU General Public License v3.0**.

```text
OpenNotes - A note-taking app  
Copyright (C) 2025 Open Notes

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <https://www.gnu.org/licenses/>.
