﻿
namespace GMap.NET
{
   using System.ComponentModel;

   /// <summary>
   /// This enum contains all possible languages for the Google maps. 
   /// You can find latest information about supported languages in the:
   /// http://tinyurl.com/yh4va36 <- http://spreadsheets.server.com/pub?key=p9pdwsai2hDMsLkXsoM05KQ&gid=1
   /// </summary>
   public enum LanguageType
   {
      [Description("ar")]
      Arabic,

      [Description("bg")]
      Bulgarian,

      [Description("bn")]
      Bengali,

      [Description("ca")]
      Catalan,

      [Description("cs")]
      Czech,

      [Description("da")]
      Danish,

      [Description("de")]
      German,

      [Description("el")]
      Greek,

      [Description("en")]
      English,

      [Description("en-AU")]
      EnglishAustralian,

      [Description("en-GB")]
      EnglishGreatBritain,

      [Description("es")]
      Spanish,

      [Description("eu")]
      Basque,

      [Description("fa")]
      FARSI,

      [Description("fi")]
      Finnish,

      [Description("fil")]
      Filipino,

      [Description("fr")]
      French,

      [Description("gl")]
      Galician,

      [Description("gu")]
      Gujarati,
      [Description("hi")]
      Hindi,

      [Description("hr")]
      Croatian,

      [Description("hu")]
      Hungarian,

      [Description("id")]
      Indonesian,

      [Description("it")]
      Italian,

      [Description("iw")]
      Hebrew,

      [Description("ja")]
      Japanese,

      [Description("kn")]
      Kannada,

      [Description("ko")]
      Korean,

      [Description("lt")]
      Lithuanian,

      [Description("lv")]
      Latvian,

      [Description("ml")]
      Malayalam,

      [Description("mr")]
      Marathi,

      [Description("nl")]
      Dutch,

      [Description("nn")]
      NorwegianNynorsk,

      [Description("no")]
      Norwegian,

      [Description("or")]
      Oriya,

      [Description("pl")]
      Polish,

      [Description("pt")]
      Portuguese,

      [Description("pt-BR")]
      PortugueseBrazil,

      [Description("pt-PT")]
      PortuguesePortugal,

      [Description("rm")]
      Romansch,
      [Description("ro")]
      Romanian,

      [Description("ru")]
      Russian,

      [Description("sk")]
      Slovak,

      [Description("sl")]
      Slovenian,

      [Description("sr")]
      Serbian,

      [Description("sv")]
      Swedish,

      [Description("tl")]
      TAGALOG,

      [Description("ta")]
      Tamil,

      [Description("te")]
      Telugu,

      [Description("th")]
      Thai,

      [Description("tr")]
      Turkish,

      [Description("uk")]
      Ukrainian,

      [Description("vi")]
      Vietnamese,

      [Description("zh-CN")]
      ChineseSimplified,

      [Description("zh-TW")]
      ChineseTraditional,
   }
}
