/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.embedded.EmbeddedEngine;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transformations
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transformations.class);
    private static final String TYPE_SUFFIX = ".type";
    private final Configuration config;
    private final List<Transformation<SourceRecord>> transforms = new ArrayList<Transformation<SourceRecord>>();

    public Transformations(Configuration config) {
        this.config = config;
        String transformationList = config.getString(EmbeddedEngine.TRANSFORMS);
        if (transformationList == null) {
            return;
        }
        for (String transfName : transformationList.split(",")) {
            transfName = transfName.trim();
            Transformation<SourceRecord> transformation = this.getTransformation(transfName);
            transformation.configure(config.subset(this.transformationConfigNamespace(transfName), true).asMap());
            this.transforms.add(transformation);
        }
    }

    private String transformationConfigNamespace(String name) {
        return EmbeddedEngine.TRANSFORMS.name() + "." + name;
    }

    private Transformation<SourceRecord> getTransformation(String name) {
        Transformation transformation = null;
        try {
            transformation = this.config.getInstance(EmbeddedEngine.TRANSFORMS.name() + "." + name + TYPE_SUFFIX, Transformation.class);
        }
        catch (Exception e) {
            throw new DebeziumException("Error while instantiating transformation '" + name + "'", e);
        }
        if (transformation == null) {
            throw new DebeziumException("Cannot instatiate transformation '" + name + "'");
        }
        return transformation;
    }

    public SourceRecord transform(SourceRecord record) {
        Transformation<SourceRecord> t;
        Iterator<Transformation<SourceRecord>> iterator = this.transforms.iterator();
        while (iterator.hasNext() && (record = (t = iterator.next()).apply(record)) != null) {
        }
        return record;
    }

    @Override
    public void close() throws IOException {
        for (Transformation<SourceRecord> t : this.transforms) {
            try {
                t.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error while closing transformation", (Throwable)e);
            }
        }
    }
}

