/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.compress;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteBufferInputStream;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteBufferOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyFactory {
    private SnappyFactory() {
    }

    public static OutputStream wrapForOutput(ByteBufferOutputStream buffer) {
        try {
            return new SnappyOutputStream((OutputStream)buffer);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    public static InputStream wrapForInput(ByteBuffer buffer) {
        try {
            return new SnappyInputStream((InputStream)new ByteBufferInputStream(buffer));
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }
}

