/****************************************************************************
 Copyright (c) 2020-2023 Xiamen Yaji Software Co., Ltd.

 http://www.cocos.com

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 of the Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
****************************************************************************/

#include "TBBJobGraph.h"

namespace cc {

void TBBJobGraph::makeEdge(uint32_t j1, uint32_t j2) noexcept {
    if (j1 & PARALLEL_JOB_FLAG) {
        j1 = _parallelJobs[j1 & PARALLEL_JOB_MASK].successor;
    }

    if (j2 & PARALLEL_JOB_FLAG) {
        j2 = _parallelJobs[j2 & PARALLEL_JOB_MASK].predecessor;
    }

    tbb::flow::make_edge(_nodes[j1], _nodes[j2]);
}

void TBBJobGraph::run() noexcept {
    _nodes.front().try_put(tbb::flow::continue_msg());
    _pending = true;
}

} // namespace cc
