/* eslint-disable quote-props */
const pkg = require('../../../package.json');
const { mixin, link } = require('../../i18n-utils');
const version = pkg.version.replace(/(^\d+\.\d+)\..*$/, (str, a) => {
    return a;
});

const url = 'https://docs.cocos.com/creator';

module.exports = link(mixin({
    common: {
        'attribute': {
            'title': 'Attribute:&nbsp;',
            'description': 'Description:&nbsp;',
        },
    },
    classes: {
        'cc': {
            'animation': {
                'TCVariableBinding': {
                    menu: 'Variable Binding',
                    tooltip: 'Use the variable\'s value as condition value.',
                    properties: {
                        'variableName': {
                            label: 'Variable',
                            tooltip: 'Variable name.',
                        },
                    },
                },
                'TCAuxiliaryCurveBinding': {
                    menu: 'Auxiliary Curve Binding',
                    tooltip: 'Use the auxiliary curve \'s current value as condition value.',
                    properties: {
                        'curveName': {
                            label: 'Curve',
                            tooltip: 'Auxiliary curve name.',
                        },
                    },
                },
                'TCStateWeightBinding': {
                    menu: 'State Weight Binding',
                    tooltip: 'Use the state \'s weight as condition value.',
                    abbr: {
                        label: 'State Weight',
                        tooltip: 'The current weight of transition source state.',
                    },
                },
                'TCStateMotionTimeBinding': {
                    menu: 'Motion Time Binding',
                    tooltip: 'Use the elapsed (normalized) time of motions in state as condition value.',
                    abbr: {
                        label: 'Motion Elapsed Time',
                        tooltip: 'The elapsed (normalized) time of motions in transition source state.',
                    },
                },
            },
            CurveRange: {
                properties: {
                    spline: {
                        displayName: 'Spline',
                    },
                    splineMin: {
                        displayName: 'Spline Min',
                    },
                    splineMax: {
                        displayName: 'Spline Max',
                    },
                },
            },
        },
    },

    help: {
        cc: {
            Node: `${url}/${version}/manual/en/concepts/scene/node-component.html`,
            MeshRenderer: `${url}/${version}/manual/en/engine/renderable/model-component.html`,
            UITransform: `${url}/${version}/manual/en/ui-system/components/editor/ui-transform.html`,
            Sprite: `${url}/${version}/manual/en/ui-system/components/editor/sprite.html`,
            SubContextView: `${url}/${version}/manual/en/editor/publish/build-open-data-context.html`,
            BlockInputEvents: `${url}/${version}/manual/en/ui-system/components/editor/block-input-events.html`,
            Camera: `${url}/${version}/manual/en/editor/components/camera-component.html`,
            Canvas: `${url}/${version}/manual/en/ui-system/components/editor/canvas.html`,
            SkinnedMeshRenderer: `${url}/${version}/manual/en/animation/skeletal-animation.html`,
            SkinnedMeshBatchRenderer: `${url}/${version}/manual/en/animation/skeletal-animation.html`,
            Ambient: `${url}/${version}/manual/en/concepts/scene/light/lightType/ambient.html`,
            Skybox: `${url}/${version}/manual/en/concepts/scene/skybox.html`,
            Fog: `${url}/${version}/manual/en/concepts/scene/fog.html`,
            Shadow: `${url}/${version}/manual/en/concepts/scene/light/shadow.html`,
            DirectionalLight: `${url}/${version}/manual/en/concepts/scene/light/lightType/dir-light.html`,
            SphereLight: `${url}/${version}/manual/en/concepts/scene/light/lightType/sphere-light.html`,
            SpotLight: `${url}/${version}/manual/en/concepts/scene/light/lightType/spot-light.html`,
            LightProbeGroup: `${url}/${version}/manual/en/concepts/scene/light/probe/light-probe.html`,
            UICoordinateTracker: `${url}/${version}/manual/en/ui-system/components/editor/ui-coordinate-tracker.html`,
            Animation: `${url}/${version}/manual/en/animation/animation-component.html`,
            SkeletalAnimation: `${url}/${version}/manual/en/animation/skeletal-animation.html`,
            animation: {
                AnimationController: `${url}/${version}/manual/en/animation/marionette/animation-controller.html`,
            },
            AudioSource: `${url}/${version}/manual/en/audio-system/overview.html`,
            Billboard: `${url}/${version}/manual/en/particle-system/billboard-component.html`,
            Line: `${url}/${version}/manual/en/particle-system/line-component.html`,
            ParticleSystem: `${url}/${version}/manual/en/particle-system/main-module.html`,
            Button: `${url}/${version}/manual/en/ui-system/components/editor/button.html`,
            Label: `${url}/${version}/manual/en/ui-system/components/editor/label.html`,
            EditBox: `${url}/${version}/manual/en/ui-system/components/editor/editbox.html`,
            Layout: `${url}/${version}/manual/en/ui-system/components/editor/layout.html`,
            Graphics: `${url}/${version}/manual/en/ui-system/components/editor/graphics.html`,
            Mask: `${url}/${version}/manual/en/ui-system/components/editor/mask.html`,
            ProgressBar: `${url}/${version}/manual/en/ui-system/components/editor/progress.html`,
            LabelOutline: `${url}/${version}/manual/en/ui-system/components/editor/label-outline.html`,
            RichText: `${url}/${version}/manual/en/ui-system/components/editor/richtext.html`,
            ScrollBar: `${url}/${version}/manual/en/ui-system/components/editor/scrollbar.html`,
            ScrollView: `${url}/${version}/manual/en/ui-system/components/editor/scrollview.html`,
            Slider: `${url}/${version}/manual/en/ui-system/components/editor/slider.html`,
            ToggleContainer: `${url}/${version}/manual/en/ui-system/components/editor/toggleContainer.html`,
            Toggle: `${url}/${version}/manual/en/ui-system/components/editor/toggle.html`,
            UIMeshRenderer: `${url}/${version}/manual/en/ui-system/components/editor/ui-model.html`,
            Widget: `${url}/${version}/manual/en/ui-system/components/editor/widget.html`,
            PageViewIndicator: `${url}/${version}/manual/en/ui-system/components/editor/pageviewindicator.html`,
            PageView: `${url}/${version}/manual/en/ui-system/components/editor/pageview.html`,
            UIStaticBatch: `${url}/${version}/manual/en/ui-system/components/editor/ui-static.html`,
            UIOpacity: `${url}/${version}/manual/en/ui-system/components/editor/ui-opacity.html`,
            BoxCollider2D: `${url}/${version}/manual/en/physics-2d/physics-2d-collider.html`,
            CircleCollider2D: `${url}/${version}/manual/en/physics-2d/physics-2d-collider.html`,
            PolygonCollider2D: `${url}/${version}/manual/en/physics-2d/physics-2d-collider.html`,
            RigidBody2D: `${url}/${version}/manual/en/physics-2d/physics-2d-rigid-body.html`,
            Joint2D: `${url}/${version}/manual/en/physics-2d/physics-2d-joint.html`,
            BoxCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            CapsuleCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            ConeCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            CylinderCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            MeshCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            PlaneCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            SphereCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            SimplexCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            TerrainCollider: `${url}/${version}/manual/en/physics/physics-collider.html`,
            ConfigurableConstraint: `${url}/${version}/manual/en/physics/physics-constraint.html`,
            FixedConstraint: `${url}/${version}/manual/en/physics/physics-constraint.html`,
            HingeConstraint: `${url}/${version}/manual/en/physics/physics-constraint.html`,
            PointToPointConstraint: `${url}/${version}/manual/en/physics/physics-constraint.html`,
            RigidBody: `${url}/${version}/manual/en/physics/physics-rigidbody.html`,
            BoxCharacterController: `${url}/${version}/manual/en/physics/character-controller/index.html`,
            CapsuleCharacterController: `${url}/${version}/manual/en/physics/character-controller/index.html`,
            PhysicsMaterial: `${url}/${version}/manual/en/physics/physics-material.html`,
            ConstantForce: `${url}/${version}/manual/en/physics/physics-component.html`,
            VideoPlayer: `${url}/${version}/manual/en/ui-system/components/editor/videoplayer.html`,
            WebView: `${url}/${version}/manual/en/ui-system/components/editor/webview.html`,
            SafeArea: `${url}/${version}/manual/en/ui-system/components/editor/safearea.html`,
            Terrain: `${url}/${version}/manual/en/editor/terrain/`,
            TiledMap: `${url}/${version}/manual/en/editor/components/tiledmap.html`,
            TiledTile: `${url}/${version}/manual/en/editor/components/tiledtile.html`,
            Spine: `${url}/${version}/manual/en/editor/components/spine.html`,
            DragonBones: `${url}/${version}/manual/en/editor/components/dragonbones.html`,
            OctreeCulling: `${url}/${version}/manual/en/advanced-topics/native-scene-culling.html`,
            LightProbe: ``,
            PostProcess: `${url}/${version}/manual/en/render-pipeline/post-process/post-process.html`,
            BlitScreen: `${url}/${version}/manual/en/render-pipeline/post-process/blit-screen.html`,
            TAA: `${url}/${version}/manual/en/render-pipeline/post-process/index.html`,
            FSR: `${url}/${version}/manual/en/render-pipeline/post-process/index.html`,
            FXAA: `${url}/${version}/manual/en/render-pipeline/post-process/index.html`,
            Bloom: `${url}/${version}/manual/en/render-pipeline/post-process/index.html`,
            HBAO: `${url}/${version}/manual/en/render-pipeline/post-process/index.html`,
            ColorGrading: `${url}/${version}/manual/en/render-pipeline/post-process/index.html`,
            Skin: `${url}/${version}/manual/en/shader/advanced-shader/skin.html`,
            RenderRoot2D: `${url}/${version}/manual/en/ui-system/components/editor/renderroot2d.html`,
            ReflectionProbe: `${url}/${version}/manual/en/concepts/scene/light/probe/reflection-art-workflow.html`,
            Sorting: `${url}/${version}/manual/en/engine/rendering/sorting.html`,
            Sorting2D: `${url}/${version}/manual/en/engine/rendering/sorting-2d.html`,
        },
        assets: {
            javascript: `${url}/${version}/manual/en/concepts/scripting/plugin-scripts.html`,
            texture: `${url}/${version}/manual/en/asset/texture.html`,
            'texture-cube': `${url}/${version}/manual/en/asset/texture-cube.html`,
            typescript: `${url}/${version}/manual/en/scripting/setup.html`,
            'animation-clip': `${url}/${version}/manual/en/animation/animation-clip.html`,
            'animation-graph': `${url}/${version}/manual/en/animation/marionette/animation-graph.html`,
            'animation-mask': `${url}/${version}/manual/en/animation/marionette/animation-mask.html`,
            'audio-clip': `${url}/${version}/manual/en/asset/audio.html`,
            'auto-atlas': `${url}/${version}/manual/en/asset/auto-atlas.html`,
            'bitmap-font': `${url}/${version}/manual/en/asset/font.html#bitmap-fonts`,
            buffer: ``,
            'effect-header': `${url}/${version}/manual/en/shader/effect-chunk-index.html`,
            effect: `${url}/${version}/manual/en/shader/effect-inspector.html`,
            'erp-texture-cube': `${url}/${version}/manual/en/asset/texture-cube.html`,
            gltf: `${url}/${version}/manual/en/asset/model/glTF.html`,
            fbx: `${url}/${version}/manual/en/asset/model/mesh.html`,
            json: `${url}/${version}/manual/en/asset/json.html`,
            'label-atlas': `${url}/${version}/manual/en/asset/label-atlas.html`,
            material: `${url}/${version}/manual/en/asset/material.html`,
            particle: '',
            'physics-material': `${url}/${version}/manual/en/physics/physics-material.html`,
            prefab: `${url}/${version}/manual/en/asset/prefab.html`,
            'render-flow': `${url}/${version}/manual/en/render-pipeline/user-pipeline.html`,
            'render-pipeline': `${url}/${version}/manual/en/render-pipeline/user-pipeline.html`,
            'render-stage': `${url}/${version}/manual/en/render-pipeline/user-pipeline.html`,
            'spine-data': `${url}/${version}/manual/en/asset/spine.html`,
            'sprite-atlas': `${url}/${version}/manual/en/asset/atlas.html`,
            'sprite-frame': `${url}/${version}/manual/en/asset/sprite-frame.html`,
            terrain: `${url}/${version}/manual/en/editor/terrain/#creating-terrain-objects-and-assets`,
            text: `${url}/${version}/manual/en/asset/text.html`,
            'tiled-map': `${url}/${version}/manual/en/asset/tiledmap.html`,
            'ttf-font': `${url}/${version}/manual/en/asset/font.html#dynamic-fonts`,
            'video-clip': ``,
            'render-texture': `${url}/${version}/manual/en/asset/render-texture.html`,
            dragonbones: `${url}/${version}/manual/en/asset/dragonbones.html`,
            'dragonbones-atlas': `${url}/${version}/manual/en/asset/dragonbones.html`,
            scene: `${url}/${version}/manual/en/asset/scene.html`,
            image: `${url}/${version}/manual/en/asset/image.html`,
            'gltf-animation':`${url}/${version}/manual/en/animation/animation-clip.html`,
            'gltf-embeded-image': `${url}/${version}/manual/en/asset/model/glTF.html#gltf-image`,
            'gltf-material': `${url}/${version}/manual/en/asset/material.html`,
            'gltf-mesh': `${url}/${version}/manual/en/asset/model/glTF.html#gltf-mesh`,
            'gltf-scene': `${url}/${version}/manual/en/asset/model/glTF.html#gltf-scene`,
            'gltf-skeleton': `${url}/${version}/manual/en/asset/model/glTF.html#gltf-skins`,
        },
    },
    ambient: {
        skyLightingColor: 'Sky Color (Upper sphere lighting source).',
        groundLightingColor: 'Ground Color (Lower sphere lighting source).',
        skyIllum: 'Ambient lighting intensity.',
    },
    skybox: {
        EnvironmentLightingType: 'Choose environment lighting types: <br>Custom hemisphere diffuse, no reflections. <br>Autogen hemisphere diffuse, with reflections.<br>More accuracy diffuse map, with reflections.',
        enabled: 'Enable or disable skybox rendering with Envmap cube texture settings.',
        useHDR: 'Toggle HDR or LDR mode. <br>Each mode has seperate light source settings, <br>HDR mode uses physical luminosity unit with camera exposure attributes, <br>and LDR mode uses none-unit without exposure calculations.',
        envmap: 'Set skybox texture and environment light source. <br>Support cross / longitude and latitude / 6-separated cube textures. <br>Support hdr / tga / png file type.',
        rotationAngle: 'Adjust Y-axis rotation for skybox and sky lighting.',
        material: 'Set custom skybox material, see skybox.effect.',
    },
    fog: {
        enabled: 'Enable or disable global fog effect.',
        accurate: 'Toggle vertex fog and pixel fog. <br>Pixel fog has more accurate visual effect with low vertex count objects, <br>but vertex fog has better performance.',
        fogColor: 'Fog In-Scattering Color.',
        type: 'Different calculation models.',
        fogDensity: 'The larger the value, the more foggy it looks.',
        fogStart: 'Fog will start with this value (world space unit). <br>Increase this value if you want more clarity nearby.',
        fogEnd: 'Further than this value (world space unit), will receive maximum fog effect.',
        fogAtten: 'The smaller the value, the more foggy it looks.',
        fogTop: 'Objects above this height value (world space unit) are not affected by fog.',
        fogRange: 'Fog extends down this range value (world space unit) from the top point.',
    },
    shadow: {
        enabled: 'Enable or disable real time shadows.',
        type: 'Shadow effect type',
        shadowColor: 'The planar shadow color',
        planeDirection: 'The normal vector of the plane which receives shadow.',
        planeHeight: 'The height from the origin of the plane which receives shadow.',
        planeBias:'Positional offset values in planar shading calculations.',
        shadowMapSize: 'Shadowmap resolutions.',
        maxReceived: 'Number of the effective light sources that produce shadows.',
    },
    animation: {
        default_clip: 'When checking, the default animation clip is automatically played.',
        clips: 'You can access and play animation clips via a script',
        play_on_load: 'Automatically play animation clip with the scene is loaded',
        use_baked_animation:
            'Whether to bake animations. <br>Default to true, which substantially increases performance while making all animations completely fixed',
        sockets:
            'The joint sockets this animation component maintains.<br>Sockets have to be registered before attaching custom nodes to animated joints',
    },
    audio: {
        clip: 'The default AudioClip to be played for this audio source',
        volume: 'The volume of this audio source',
        loop: 'Is looping enabled for this audio source?',
        playOnAwake: 'Is auto-play enabled for this audio source?',
    },
    batched_skinning_model: {
        atlas_size: 'Size of the generated texture atlas',
        batchable_texture_names:
            "Texture properties that will be actually using the generated atlas.<br>The first unit's texture will be used if not specified",
        units: 'Source skinning model components, <br>containing all the data to be batched',
    },
    camera: {
        priority: 'Render priority of the camera, in ascending-order',
        visibility: 'Visibility mask, declaring a set of node layers that will be visible to this camera',
        clear_flags: 'Clearing flags of the camera, <br>specifies which part of the framebuffer will be actually cleared every frame',
        color: 'Clearing color of the camera',
        depth: 'Clearing depth of the camera',
        stencil: 'Clearing stencil of the camera',
        projection: 'Projection type of the camera',
        fov_axis: 'The axis on which the FOV would be fixed regardless of screen aspect changes',
        fov: 'Field of view of the camera',
        ortho_height: 'Viewport height in orthographic mode',
        near: 'Near clipping distance of the camera, <br>should be as large as possible within acceptable range',
        far: 'Far clipping distance of the camera, <br>should be as small as possible within acceptable range',
        aperture: 'Camera aperture, controls the exposure parameter',
        shutter: 'Camera shutter, controls the exposure parameter',
        ISO: 'Camera ISO, controls the exposure parameter',
        rect: 'The size of the viewport that this camera will eventually render to the screen.',
        target_texture: 'Output render texture of the camera. Default to null, which outputs directly to screen',
        use_postprocess: 'Whether this camera should use post process.',
        postprocess: 'If camera post process is not specified, will use the global post process.',
    },
    lights: {
        color: 'Color of the light',
        use_color_temperature: 'Whether to enable light color temperature',
        color_temperature: 'Color Temperature of the light',
        illuminance: 'Illuminance of the light',
        luminous_power: 'Luminous power of the light',
        luminance: 'Luminance of the light',
        visibility: 'Visibility mask, declaring a set of node layers that will be visible to this valid punctual Light(Does not work with directional light)',
        term: 'The photometric term currently being used',
        size: 'Size of the light',
        range: 'Range of the light',
        spotAngle: 'Cone angle of the spotlight',
        angleAttenuationStrength: 'The angle attenuation strength of the light. The larger the value, the softer the edge, and the smaller the value, the harder the edge.',
        shadowEnabled: 'Enable or disable real time shadows',
        shadowPcf: 'Enable soft shadows',
        shadowBias: 'Bias value (world space unit) that can avoid moire artifacts with shadows. <br>The more the value, the more the light leakage',
        shadowNormalBias: 'Bias value (world space unit) that can avoid moire artifacts with surfaces that parallel to the directional light',
        shadowSaturation: 'Shadow saturation. This value should be 1.0.<br>We recommend that you\'d rather increase ambient lighting than modify this value',
        shadowDistance: 'Shadows do not appear beyond this distance (world space unit)',
        shadowInvisibleOcclusionRange: 'If some shadow near the camera is missing, <br>increase this value (world space unit) to fix it',
        enableCSM: 'Enable CSM',
        shadowFixedArea: 'Toggle CSM and fixed area shadows. <br>When checking, shadow will not follow camera, it distributes around directional light position. <br>It is a legacy mode that we do not recommend',
        shadowNear: 'Fix area start',
        shadowFar: 'Fix area end',
        shadowOrthoSize: 'Fix area size, the larger value, the lower precision of shadows',
        shadowAdvancedOptions: 'shadow advanced options',
        csmLayersTransition: 'Enable or disable CSM layers transition(Improve quality, reduce performance)',
        csmTransitionRange: 'CSM layers transition range(in NDC space: value range is 0 to 1)',
    },
    sprite: {
        original_size: "Use the Image's original size as the Node size?",
        edit_button: 'Edit',
        select_button: 'Select In Atlas',
        select_tooltip: 'Choose Atlas',
        edit_tooltip: 'Open Sprite Editor, set squares and other data',
        fill_type: 'The direction of filling, choose from Horizontal, Vertical and Radial',
        fill_center: 'For radial filling, set the center of the circle, value range is 0 to 1',
        fill_start: 'The normalized value indicates where to start filling',
        fill_range: 'The normalizad value indicates how much of the sprite we want to show',
        src_blend_factor: 'The source image blend mode',
        dst_blend_factor: 'The destination image blend mode',
    },
    UIOpacity: {
        opacity: 'The value between 0 to 255 showing the transparency of the object',
    },
    billboard: {
        texture: 'Billboard texture',
        height: 'Billboard height',
        width: 'Billboard width',
        rotation: 'Angle of rotation around the center point of Billboard',
    },
    button: {
        click_event: {
            target: 'Node that receives click events',
            component: 'Component that receive click events',
            handler: 'Component method to respond to click events',
            customEventData: "The extra event data passed to the event handler, <br>it's passed in as the last argument in the event handler. ",
        },
        interactable: 'Interactable state of the button, <br>when this item is unchecked, the button is disabled',
        transition: 'Transition type when the button state changes',
        normal_color: 'Button color',
        pressed_color: 'Button color when pressed',
        hover_color: 'Button color when the mouse hovers over it',
        disabled_color: 'Button color when disabled',
        duration: 'Transition time for button color change or zoom change',
        zoom_scale:
            'When the user clicks the button, <br>the button is scaled to a value equal to the original scale of the Button * zoomScale, <br>zoomScale can be a negative number',
        auto_gray_effect: 'When this flag is true, <br>Button target sprite will turn gray when interactable is false.',
        normal_sprite: 'The sprite frame used when the button is in a normal sate.',
        pressed_sprite: 'The sprite frame used when the button is in a pressed sate.',
        hover_sprite: 'The sprite frame used when the button is in hovered over.',
        disabled_sprite: 'The sprite frame used when the button is in a disabled sate.',
        target:
            "reference to the Sprite as target's background. <br>When the state of the target changes the sprite's color or sprite frame will be updated.",
        click_events: 'By changing the number to 1 or more, <br>you can set the receiver and the handler for each click event',
    },
    canvas: {
        camera: '2D rendering camera',
        align: 'Automatically calculate parameters for the camera.',
        design_resolution: 'The resolution of the assets used in the game, in pixels.',
        fit_height: 'Canvas allows designers to automatically scale the resolution to the full height of devices screen',
        fit_width: 'Canvas allows designers to automatically scale the resolution to the full width of devices screen',
    },
    forceOvertimeModule: {
        x: 'Acceleration component along X-axis',
        y: 'Acceleration component along Y-axis',
        z: 'Acceleration component along Z-axis',
        space: 'Space where acceleration calculated',
    },
    label: {
        horizontal_align_left: 'Align Left',
        horizontal_align_center: 'Align Horizontal Center',
        horizontal_align_right: 'Align Right',
        vertical_align_top: 'Align Top',
        vertical_align_center: 'Align Vertical Center',
        vertical_align_bottom: 'Align Bottom',
    },
    labelOutline: {
        color: 'Outline color',
        width: 'Outline width',
    },
    labelShadow: {
        color: 'Shadow color',
        offset: 'Offset between font and shadow.',
        blur: 'A non-negative float specifying the level of shadow blur.',
    },
    limitVelocityOvertimeModule: {
        limitX: 'Minimum speed along X-axis',
        limitY: 'Minimum speed along Y-axis',
        limitZ: 'Minimum speed along Z-axis',
        limit: 'Minimum speed',
        dampen: 'Lerp value between current speed and minimum speed',
        separateAxes: 'Set X,Y and Z limitation respectively',
        space: 'Space where minimum speed calculated',
    },
    line: {
        texture: 'Line texture',
        wordSpace: 'Which coordinate the point in line belongs to. <br>Check if in world space, otherwise local space',
        positions: 'Position of control point',
        width: 'Fixed line width if constant input, or line width gradually changes according to the value if curve input',
        tile: 'Number of texture tiles',
        offset: 'Texture coordinates offset',
        color: 'Fixed color if constant input, or color gradually changes according to the value if gradient color input',
    },
    progress: {
        bar_sprite: 'A progress bar is displayed with the Sprite node that can dynamically change the size',
        mode: 'Progress bar display modes, including: <br> 1. HORIZONTAL: horizontal mode <br> 2. VERTICAL: vertical mode <br> 3. FILLED: fan-fill mode',
        total_length: 'Length of progress bar. The maximum length of 100',
        progress: 'Current progress indicator, ranging from 0-1',
        reverse: 'Can the progress bar update negatively (i.e go backwards)',
    },
    scrollbar: {
        handle: 'reference to the interactive bar sprite',
        direction: 'Scroll direction',
        auto_hide: 'Automatically hide',
        auto_hide_time: 'How long will the scroll bar to be hidden after no scrolling action.<br>Note: Only valid if "enableAutoHide" is true',
    },
    scrollview: {
        content: 'A scrollable display of the Nodes content',
        horizontal: 'Horizontal scroll',
        vertical: 'Vertical scroll',
        inertia: 'When inertia is set, the content will continue to move when touch ended',
        brake: 'It determines how quickly the content stop moving.<br>A value of 1 will stop the movement immediately.<br>A value of 0 will never stop the movement until it reaches to the boundary of scrollview.',
        elastic: "If elastic is set, the content will bounce back when it's moved out of scroll boundary.",
        horizontal_bar: 'Horizontal scrollbar',
        vertical_bar: 'Vertical scrollbar',
        bounceDuration: 'The elapse time for bouncing. <br>A value of 0 means the content will bounce back immediately.',
        scrollEvents: 'Scrollview events callback',
        cancelInnerEvents: 'If cancelInnerEvents is set to true, <br>the scroll behavior will cancel touch events on inner content nodes',
    },
    pageview: {
        sizeMode: 'Specify the size type of each page in PageView',
        direction: 'The page view direction',
        scrollThreshold:
            'The scroll threshold value, when drag exceeds this value, <br>release the next page will automatically scroll, less than the restore',
        pageTurningEventTiming:
            "Change the AutoScroll stop epsilon value of PageView, <br>change this value could adjust the PageView's event triggering timing.",
        indicator: 'The Page View Indicator',
        pageTurningSpeed: 'The time required to turn over a page. unit: second',
        pageEvents: 'PageView events callback',
        autoPageTurningThreshold:
            'The turning velocity threshold for page turning.<br>When user swipes the PageView quickly, <br>a velocity is calculated based on the swipe distance and time.<br>If the velocity is larger than the threshold, the page will be flipped',
    },
    pageview_indicator: {
        spriteFrame: 'The sprite frame for each element',
        direction: 'The location direction of page view indicator',
        cell_size: 'The cellSize for each element',
        spacing: 'The distance between each element',
    },
    particleSystemRenderer: {
        renderMode: 'Particle render mode',
        velocityScale: 'Lerp speed of particle along move direction when render mode is Stretched Billboard',
        lengthScale: 'Lerp length of particle along move direction when render mode is Stretched Billboard',
        mesh: 'Particle emit mesh',
        particleMaterial: 'Particle material',
        trailMaterial: 'Trail material of particle',
        useGPU: 'Enable GPU particle',
    },
    UIRenderer: {
        srcBlendFactor: 'Source blend factor',
        dstBlendFactor: 'Destination blend factor',
    },
    rotationOvertimeModule: {
        separateAxes: 'Set rotation of X, Y and Z respectively (not supported now)',
        x: 'Set rotation of X-axis',
        y: 'Set rotation of Y-axis',
        z: 'Set rotation of Z-axis',
    },
    sizeOvertimeModule: {
        separateAxes: 'Set particle size in X, Y and Z respectively',
        size: 'How particle size will change during its lifetime',
        x: 'How particle size along X-axis will change during its lifetime',
        y: 'How particle size along Y-axis will change during its lifetime',
        z: 'How particle size along Z-axis will change during its lifetime',
    },
    textureAnimationModule: {
        mode: 'Set mode of texture animation (support Grid only now)',
        numTilesX: 'Animation frames along X-axis',
        numTilesY: 'Animation frames along Y-axis',
        animation: 'Animation play mode',
        frameOverTime: 'How frame speed changes over time in a cycle',
        startFrame: 'Which frame start to play during the lifetime of particle system',
        cycleCount: 'Playing cycle count of whole lifetime',
        randomRow: 'Generate animation by a row of texture random selected,<br>only valid in SingleRow',
        rowIndex: 'Generate animation by a row of texture at [rowIndex],<br>only valid in SingleRow and randomRow is disabled',
    },
    toggle: {
        interactable: 'Interactive Toggle? When this one is not selected, the Toggle is in a disabled state',
        transition: 'Transition Type: when the state changes',
        normal_color: 'Toggle color',
        pressed_color: 'Toggle color when pressed',
        hover_color: 'Toggle color when the mouse hovers over it',
        disabled_color: 'Toggle color when disabled',
        duration: 'How long until the Toggle color/scale transitions to a new color?',
        zoom_scale:
            'When user press the Toggle, the Toggle will zoom to a scale.<br>The final scale of the Toggle  equals (Toggle original scale * zoomScale), zoomScale could be negative value.',
        auto_gray_effect: 'When this flag is true, <br>the Toggle target sprite will turn gray when interactable is false.',
        normal_sprite: 'The Sprite that is used when the Toggle is in a normal sate.',
        pressed_sprite: 'The Sprite that is used when the Toggle is in a pressed sate.',
        hover_sprite: 'The Sprite that is used when the Toggle is hovered over.',
        disabled_sprite: 'The Sprite that is used when the Toggle is in a disabled sate.',
        target:
            "reference to the Sprite as Toggle's background. <br>When the state of the button changes the sprite's color or sprite frame will be updated.",
        isChecked:
            'If this flag is true, the associated checkMark sprite component will be enabled, <br>otherwise the checkMark will be disabled.',
        checkMark: 'The Sprite component displayed when Toggle is checked.',
        toggleGroup:
            'The toggle group which the toggle belongs to. When it is null, the toggle is a CheckBox. <br>Otherwise, the toggle is a RadioButton.',
        check_events: 'The events triggered while toggle item is checked',
    },
    toggle_group: {
        allowSwitchOff:
            "If this setting is true, a toggle could be switched off and on when pressed.<br>If it is false, it will make sure there is always only one toggle could be switched on and the already switched on toggle can't be switched off.",
        check_events: "If Toggle is clicked, it will trigger event's handler.",
    },
    shapeModule: {
        position: 'Position of particle emitter',
        rotation: 'Rotation of particle emitter',
        scale: 'Scale of particle emitter',
        arc: 'Emit in a sector',
        angle: 'The angle between the axis of the cone and the generatrix',
        shapeType: 'Type of particle emitter',
        emitFrom: 'Where emit from',
        alignToDirection: 'Particle move direction align to its origin direction',
        randomDirectionAmount: 'Random setting of particle move direction',
        sphericalDirectionAmount: 'Lerp value between current emit direction and current move direction',
        randomPositionAmount: 'Random setting of particle move position(particle will appear beyond emit range)',
        radius: 'Radius of particle emitter',
        radiusThickness: 'Radius thickness of particle emitter (invalid when emitter type is Box):<br> - 0 emit from surface；<br> - 1 emit from center；<br> - 0 ~ 1 emit between center and surface',
        arcMode: 'Emit mode in the sector range',
        arcSpread: 'Space margin along arc',
        arcSpeed: 'Emit speed along arc',
        length: 'The axis length from the top section of the cone to the bottom',
        boxThickness: 'Thickness of particle emitter (only valid when emitter type is Box)',
    },
    slider: {
        handle: 'The "handle" part of the slider',
        direction: 'The slider direction',
        progress: 'The current progress of the slider. The valid value is between 0-1',
        slideEvents: 'The slider events callback',
    },
    trailSegment: {
        mode: 'Particle trail mode',
        lifeTime: 'Particle trail lifetime',
        minParticleDistance: 'Minimum trail distance',
        space: 'Space where particle trail in',
        textureMode: 'How texture covers trail',
        widthFromParticle: 'Trail width inherit from particle',
        widthRatio: 'Trail width, it\'s ratio if inherit from particle',
        colorFromParticle: 'Whether trail color inherit from particle',
        colorOverTrail: 'Gradient color with length',
        colorOvertime: 'Gradient color over time',
    },
    velocityOvertimeModule: {
        x: 'Velocity component along X-axis',
        y: 'Velocity component along Y-axis',
        z: 'Velocity component along Z-axis',
        speedModifier: 'Speed ​​correction factor (CPU particle supported only)',
        space: 'Space where velocity calculated',
    },
    widget: {
        target:
            'Specifies an alignment target that can only be one of the parent nodes of the current node. <br>The default value is null, and when null, indicates the current parent',
        align_top: 'Top edge alignment of the target Node',
        align_bottom: 'Bottom edge alignment of the target Node',
        align_left: 'Left edge alignment of the target Node',
        align_right: 'Right edge alignment of the target Node',
        align_h_center: 'Align to the horizontal midpoint of the target Node',
        align_v_center: 'Align to the vertical midpoint of the target Node',
        align_mode: 'Specifies the alignment mode of the Widget, <br>which determines when the widget should refresh at runtime.',
        top: 'Top edge position in pixels. This can be a percentage and a positive or negative value',
        bottom: 'Bottom edge position in pixels. <br>This can be a percentage and a positive or negative value',
        left: 'Left edge position in pixels. <br>This can be a percentage and a positive or negative value',
        right: 'Right edge position in pixels. <br>This can be a percentage and a positive or negative value',
        horizontal_center: 'Horizontal midpoint offset in pixels. <br>This can be a percentage and a positive or negative value',
        vertical_center: 'Vertical midpoint offset in pixels. <br>This can be a percentage and a positive or negative value',
    },
    layout: {
        layout_type:
            'Automatic layout mode: <br> 1. NONE, no automatic arrangement of child Nodes. <br> 2. HORIZONTAL, automatic horizontal arrangement of child Nodes. <br> 3. VERTICAL, automatic vertical arrangement of child Nodes.<br> 4. GRID, automatic grid arrangement of child Nodes.',
        resize_mode:
            'Automatic resize mode: <br> 1. NONE, no resize of both child Nodes and container. <br> 2. CONTAINER, resize container Node. <br> 3. CHILDREN, resize child Nodes.',
        padding_left: 'Use a padding between left sides of the Node',
        padding_right: 'Use a padding between right sides of the Node',
        padding_top: 'Use a padding between top sides of the Node',
        padding_bottom: 'Use a padding between bottom sides of the Node',
        space_x: 'The horizontal distance between adjacent child Nodes',
        space_y: 'The vertical distance between adjacent child Nodes',
        vertical_direction: 'Vertically align in the direction of the child Nodes: <br> 1. TOP_TO_BOTTOM, <br> 2. BOTTOM_TO_TOP',
        horizontal_direction: 'Horizontally align in the direction of the child Nodes: <br> 1. LEFT_TO_RIGHT <br> 2. RIGHT_TO_LEFT',
        cell_size: 'In Grid layout, the size of each child element.',
        start_axis: 'In Grid layout, the arrangement direction of children elements.',
        constraint: 'In Grid layout, content layout constraints, including: <br> 1.NONE, no constraints <br> 2.FIXED_ROW, fixed number of rows <br> 3.FIXED_COL, fixed number of columns',
        constraint_number: 'In Grid layout, number of rows or columns for content layout constraints',
        affected_scale: 'Child node scaling affects layout',
        align_horizontal: 'Align content horizontally<br>Fixed starting position in the same direction when Type is Horizontal.',
        align_vertical: 'Align content vertically<br>Fixed starting position in the same direction when Type is Vertical.',
    },
    particle: {
        export_title: 'Export custom particle data to plist file.',
        export: 'Export',
        export_error: 'This resource does not support exports outside of the project',
        sync: 'Sync',
        sync_tips: 'Synchronize the parameters in the File to Custom',
    },
    editbox: {
        string: 'The initial input text of Edit Box.',
        backgroundImage: 'The background image of Edit Box.',
        returnType: 'The keyboard return type of Edit Box. This is useful for keyboard of mobile device.',
        input_flag: 'Specify the input flag: password or capitalize word. ',
        input_mode: 'Specify the input mode: multiline or single line.',
        font_size: 'The font size of input label.',
        line_height: 'The line height of input label.',
        stay_on_top: 'Set to true and the input is always visible and be on top of the game view',
        tab_index: 'Set the tabIndex of the DOM input element, only useful on Web.',
        font_color: 'The font color of input label.',
        placeholder: 'The content string of placeholder.',
        placeholder_font_size: 'The font size of placeholder label.',
        placeholder_font_color: 'The font color of placeholder label.',
        max_length: 'The maximize input characters.',
        text_lable: "The Label component attached to the node for EditBox's input text label",
        placeholder_label: "The Label component attached to the node for EditBox's placeholder text label",
        editing_began: 'The event handler to be triggered when user begin to edit text',
        text_changed: 'The event handler to be triggered when the text content changes',
        editing_ended: 'The event handler to be triggered when user stop editing.<br>In single line mode, the function is usually called when the user presses enter or clicks outside the input box on the screen. <br> In case of multiline input, the function is usually called when the user clicks outside the input box on the screen',
        editing_return: 'The event handler to be called when return key is pressed.<br>In single line mode, pressing the Enter key also causes the input box to lose focus.',
    },
    videoplayer: {
        resourceType: 'The resource type of video player, <br>REMOTE for remote url and LOCAL for local file path.',
        remoteURL: 'The remote URL of video.',
        clip: 'The local video clip',
        playOnAwake: 'Whether the video start playing automatically after loaded?',
        volume: 'The volume of the video.(0.0 ~ 1.0)',
        mute: 'Mutes the VideoPlayer. Mute sets the volume = 0, Un-Mute restore the original volume.',
        playbackRate: 'The Video playback rate',
        loop: 'Whether the video should be played again at the end',
        keepAspectRatio: 'Whether keep the aspect ration of the original video.',
        fullScreenOnAwake: 'Whether play video in fullscreen mode?',
        stayOnBottom:
            'Always below the game view (only useful on Web. <br>Note: The specific effects are not guaranteed to be consistent, depending on whether each browser supports or restricts).',
        videoPlayerEvent:
            "The video player's callback, it will be triggered when certain event occurs, <br>like: playing, paused, stopped and completed.",
    },
    webview: {
        url: 'A given URL to be loaded by the Webview, <br>it should have a http or https prefix.',
        webviewEvents: "The Webview's event callback , <br>it will be triggered when certain Webview event occurs.",
    },
    UICoordinateTracker: {
        target: 'Target node',
        camera: 'The 3D camera representing the original coordinate system.',
        use_scale: "Whether to scale the converted 2d node's size according to the distance between the camera and the 3d node.",
        distance: 'The distance from the camera for displaying the 2d node in normal size',
        sync_events: 'Event callback after coordinates synchronization.<br>The first parameter of the callback is the mapped local coordinate in UI camera.<br>The second parameter is the distance scale of the 3d node from the 3d camera viewport.',
    },
    subContextView: {
        design_size: 'Design resolution of the SubContextView, dynamic updates at runtime is not possible',
        fps: 'Update frame rate for the SubContextView',
    },
    dragon_bones: {
        dragon_bones_asset:
            'The json data contains the DragonBones information, <br>drag the json file exported from DragonBones to get started.',
        dragon_bones_atlas_asset:
            'The json data contains the Texture information, <br>drag the json file exported from DragonBones to get started.',
        armature_name: 'The name of current armature.',
        animation_name: 'The name of current playing animation.',
        time_scale: 'The time scale of this armature.',
        play_times:
            'The play times of the default animation.<br>-1 means using the value of config file.<br>0 means repeat for ever<br>>0 means repeat times.',
        debug_bones: 'Indicates whether open debug bones',
    },
    motionStreak: {
        fadeTime: 'Trail fragment fade time, in seconds',
        minSeg: 'The minimum distance between of the trail',
        stroke: 'The width of the trail',
        texture: 'The texture of the trail',
        color: 'The color of the trail',
        fastMode: 'Whether to enable fast mode',
    },
    missing_scirpt: {
        error_compiled:
            'Error on executing script, or the script reference is missing. <br>Please check error log carefully and correct/recover your script. The component will be restored once scripting error is gone. If you no long need the missing script, please remove this component manually.',
        error_not_compiled:
            'Error on compiling script. Please check error log carefully and correct your script. <br>This component will be restored once compiling error is gone.',
    },
    collider: {
        editing: 'Edit this collider component',
        category: 'Collider component category',
        mask: 'The collider mask can collide with this collider',
    },
    particle_system: {
        preview: 'Play particle in edit mode',
        custom: 'If set custom to true, then use custom properties instead of read particle file',
        file: 'The plist file',
        spriteFrame: 'Sprite Frame of Particle System',
        texture: 'Texture of Particle System, readonly, please use Sprite Frame to setup new texture',
        particleCount: 'Current quantity of particles that are being simulated',
        srcBlendFactor: 'Specify the source Blend Factor',
        dstBlendFactor: 'Specify the destination Blend Factor',
        playOnLoad: 'If set to true, the particle system will automatically start playing on load',
        autoRemoveOnFinish: 'Indicate whether the owner node will be auto-removed when it has no particles left',
        emissionRate: 'Emission rate of the particles',
        life: 'Life and variation of each particle setter',
        totalParticles: 'Maximum particles of the system',
        startColor: 'Start color of each particle',
        startColorVar: 'Variation of the start color',
        endColor: 'Ending color of each particle',
        endColorVar: 'Variation of the end color',
        angle: 'Angle and variation of each particle setter',
        startSize: 'Start size and variation in pixels of each particle',
        endSize: 'End size and variation in pixels of each particle',
        startSpin: 'Start angle and variation of each particle',
        endSpin: 'End angle and variation of each particle',
        sourcePos: 'Source position of the emitter',
        posVar: 'Variation of source position',
        positionType: 'Particles movement type',
        emitterMode: 'Particles emitter modes',
        gravity: 'Gravity of the emitter',
        speed: 'Speed and variation of the emitter',
        tangentialAccel: 'Tangential acceleration and variation of each particle. <br>Only available in Gravity mode ',
        radialAccel: 'Acceleration and variation of each particle. <br>Only available in Gravity mode',
        rotationIsDir: 'Indicate whether the rotation of each particle equals to its direction. <br>Only available in Gravity mode',
        startRadius: 'Starting radius and variation of the particles. <br>Only available in Radius mode',
        endRadius: 'Ending radius and variation of the particles. <br>Only available in Radius mode',
        rotatePerS: 'Number of degrees to rotate a particle around the source pos per second and variation. <br>Only available in Radius mode',
        capacity: 'Maximum particle amount that the system can generate',
        scaleSpace: 'Scale space',
        startSize3D: 'Set start size of X, Y and Z respectively if true',
        startSizeX: 'Start size in X direction',
        startSizeY: 'Start size in Y direction',
        startSizeZ: 'Start size in Z direction',
        startSpeed: 'Start speed',
        startRotation3D: 'Set rotation of X, Y and Z respectively if true',
        startRotationX: 'Angle of rotation around X-axis at beginning',
        startRotationY: 'Angle of rotation around Y-axis at beginning',
        startRotationZ: 'Angle of rotation around Z-axis at beginning',
        startDelay: 'Time delayed of particle emit after the system start running',
        startLifetime: 'Life time of the particle',
        duration: 'Particle duration',
        loop: 'Loop animation',
        prewarm: 'Animation plays from the end state of last round (only valid when loop activated)',
        simulationSpace: 'The particle space your calculation is done in',
        simulationSpeed: 'Update ratio of particles',
        playOnAwake: 'Play on awake',
        gravityModifier: 'How much particles get affected by the gravity (only support on CPU)',
        rateOverTime: 'Number of particles emitted per second',
        rateOverDistance: 'Number of particles emitted per unit distance',
        bursts: 'Emit a given number of particles at a certain point in time',
        colorOverLifetimeModule: 'Color control module',
        shapeModule: 'Particle emitter module',
        sizeOvertimeModule: 'Particle size module',
        velocityOvertimeModule: 'Particle velocity module',
        forceOvertimeModule: 'Particle acceleration module',
        limitVelocityOvertimeModule: 'Particle velocity limitation module (only support on CPU)',
        rotationOvertimeModule: 'Particle rotation module',
        textureAnimationModule: 'Texture animation module',
        trailModule: 'Trail module (only supported in CPU particle system)',
        noiseModule: 'Noise module (only supported in CPU particle system)',
        renderer: 'Particle render module',
        renderCulling: 'Whether to enable the particle culling feature. <br>If enabled, a particle emitter bounding box will be generated, <br>and the particle emitter will be culled if the bounding box is not in the visible range of the camera. <br>Please refer to the cullingMode option below for the behavior settings after particle culling.',
        cullingMode: 'Sets the behavior of the particle emitter after it has been culled. <br>The available options include Pause, Pause and Catchup, and Always Simulate.<br>When the Pause is selected, the particle will pause the simulation if the particle emitter bounding box is not in the camera\'s visible range. <br>If it resumes visibility, the particle will continue simulating at the time of last pause.<br>When the Pause and Catchup is selected, if the particle emitter bounding box is not in the camera\'s visible range, the particle will pause the simulation.  If visible again, the particle will start simulating at the current time.<br>When the Always Simulate is selected, the particle will keep simulating regardless of whether the particle emitter bounding box is in the camera\'s visible range, but will not render when it is not in the camera\'s visible range.',
        alignSpace: 'Particle alignment space, the available options include View Space. <br>World Space and Local Space.<br>When the View Space is selected, the rotation direction of the particle mesh will follow the camera\'s view direction.<br>When the World Space is selected, the direction of the particle mesh will use the world space rotation direction of the node where the particle emitter is located.<br>When the Local Space is selected, the particle mesh will use the local space rotation direction of the node where the particle emitter is located.',
        aabbHalfX: 'Half width of the emitter bounding box',
        aabbHalfY: 'Half height of the emitter bounding box',
        aabbHalfZ: 'Half length of the emitter bounding box',
        dataCulling: 'Cull disabled data if true',
    },
    mask: {
        type: 'The mask type',
        spriteFrame: 'The mask image',
        inverted: 'The Reverse mask (Not supported Canvas Mode)',
        alphaThreshold:
            'The alpha threshold.<br>The content is drawn only where the stencil have pixel with alpha greater than the alphaThreshold. <br>(Not supported Canvas Mode)',
        segements: 'The segements for ellipse mask',
    },
    physics2d: {
        rigidbody: {
            group: 'group',
            enabledContactListener:
                'Should enabled contact listener. When a collision is trigger, <br>the collision callback will only be called when enabled contact listener.',
            bullet: 'Is this a fast moving body that should be prevented from tunneling through other moving bodies?',
            type: 'Rigid body type : Static, Kinematic, Dynamic or Animated.',
            allowSleep: 'Set this flag to false if this body should never fall asleep. Note that this increases CPU usage.',
            gravityScale: 'Scale the gravity applied to this body.',
            linearDamping:
                'Linear damping is use to reduce the linear velocity.<br>The damping parameter can be larger than 1, but the damping effect becomes sensitive to the time step when the damping parameter is large.',
            angularDamping:
                'Angular damping is use to reduce the angular velocity.<br>The damping parameter can be larger than 1 but the damping effect becomes sensitive to the time step when the damping parameter is large.',
            linearVelocity: "The linear velocity of the body's origin in world co-ordinates",
            angularVelocity: 'The angular velocity of the body.',
            fixedRotation: 'Should this body be prevented from rotating?',
            awakeOnLoad: 'Is this body initially awake?',
        },
        collider: {
            group: 'Group',
            editing: 'Whether to edit the collider',
            threshold:'Specifies the minimum distance between the vertices of the generated map outline, the larger the value, the fewer points will be generated, adjustable according to requirements',
            density: 'The density',
            sensor: 'A sensor collider collects contact information but never generates a collision response',
            friction: 'The friction coefficient, usually in the range [0,1].',
            restitution: 'The restitution (elasticity) usually in the range [0,1].',
            anchor: 'The anchor of the rigid body.',
            connectedAnchor: 'The anchor of the connected rigid body.',
            connectedBody: 'The rigid body to which the other end of the joint is attached.',
            collideConnected: 'Should the two rigid bodies connected with this joint collide with each other?',
            distance: 'The distance separating the two ends of the joint.',
            frequency: 'The spring frequency.',
            dampingRatio: 'The damping ratio.',
            linearOffset: 'The linear offset from connected rigid body to rigid body.',
            angularOffset: 'The angular offset from connected rigid body to rigid body.',
            maxForce: 'The maximum force can be applied to rigid body.',
            maxTorque: 'The maximum torque can be applied to rigid body.',
            correctionFactor: 'The position correction factor in the range [0,1].',
            mouseRegion: "The node used to register touch event. <br>If this is null, it will be the joint's node.",
            target: 'The target point. <br>The mouse joint will move chosen rigid body to target point.',
            localAxisA: 'The local joint axis relative to rigid body.',
            enableLimit: 'Enable joint distance limit?',
            enableMotor: 'Enable joint motor?',
            lowerLimit: 'The lower joint limit.',
            upperLimit: 'The upper joint limit.',
            maxMotorForce: 'The maximum force can be applied to rigid body to reach the target motor speed.',
            motorSpeed: 'The expected motor speed.',
            referenceAngle: 'The reference angle. <br>An angle between bodies considered to be zero for the joint angle.',
            lowerAngle: 'The lower angle.',
            upperAngle: 'The upper angle.',
            maxMotorTorque: 'The maximum torque can be applied to rigid body to reach the target motor speed.',
            maxLength: 'The max length.',
            offset: 'Position offset',
            size: 'Box size',
            radius: 'Circle radius',
            tag: 'Tag. If a node has several collider components, <br>you can judge which type of collider is collided according to the tag.',
            points: 'Polygon points',
        },
        joint: {
            anchor: 'The anchor of the rigid body.',
            connectedAnchor: 'The anchor of the connected rigid body.',
            connectedBody: 'The rigid body to which the other end of the joint is attached.',
            collideConnected: 'Should the two rigid bodies connected with this joint collide with each other?',
            distance: 'The distance separating the two ends of the joint.',
            frequency: 'The spring frequency.',
            dampingRatio: 'The damping ratio.',
            linearOffset: 'The linear offset from connected rigid body to rigid body.',
            angularOffset: 'The angular offset from connected rigid body to rigid body.',
            maxForce: 'The maximum force can be applied to rigid body.',
            maxTorque: 'The maximum torque can be applied to rigid body.',
            correctionFactor: 'The position correction factor in the range [0,1].',
            mouseRegion: "The node used to register touch event. <br>If this is null, it will be the joint's node.",
            target: 'The target point. <br>The mouse joint will move chosen rigid body to target point.',
            localAxisA: 'The local joint axis relative to rigid body.',
            enableLimit: 'Enable joint distance limit?',
            enableMotor: 'Enable joint motor?',
            lowerLimit: 'The lower joint limit.',
            upperLimit: 'The upper joint limit.',
            maxMotorForce: 'The maximum force can be applied to rigid body to reach the target motor speed.',
            motorSpeed: 'The expected motor speed.',
            referenceAngle: 'The reference angle. <br>An angle between bodies considered to be zero for the joint angle.',
            lowerAngle: 'The lower angle.',
            upperAngle: 'The upper angle.',
            maxMotorTorque: 'The maximum torque can be applied to rigid body to reach the target motor speed.',
            maxLength: 'The max length.',
            autoCalcDistance:'Whether to automatically calculate the distance between two rigid bodies connected by a joint',
            autoCalcAngle:'Automatically calculates the sliding direction based on the two rigid bodies connected',
            autoCalcOffset:'Automatically calculate the angularOffset and linearOffset between two rigid bodies connected by a joint',
        },
    },
    block_input_events: {
        brief_help:
            'This component will block all input events, <br>preventing the input from penetrating to other nodes below the screen, <br>typically for the background of the top-level UI of the screen.',
    },
    safe_area: {
        symmetric: 'Whether it is symmetric based on the screen',
    },
    tiledtile: {
        row: 'Specify the TiledTile horizontal coordinate, <br>use map tile as the unit.',
        column: 'Specify the TiledTile vertical coordinate, <br>use map tile as the unit.',
        gid: 'Specify the TiledTile gid.',
        layer: 'Specify which TiledLayer the TiledTile belong to.',
    },
    INSPECTOR: {
        component: {
            script: 'Custom Script',
        },
    },
    features: {
        categories: {
            '2d': {
                label: '2D',
                description: '2D',
            },
            '3d': {
                label: '3D',
                description: '3D',
            },
            animation: {
                label: 'Animation',
                description: 'Animation System.',
            },
            network: {
                label: 'Network',
                description: 'Network Module.',
            },
        },
        core: {
            label: "Core",
            description: "Cocos Creator core functionalities.",
        },
        graphics: {
            label: "Graphics Backend",
            description: "Select graphics back end used for rendering.",
        },
        gfx_webgl: {
            label: "WebGL",
            description: "Include support for WebGL 1.0 graphics API.",
        },
        gfx_webgl2: {
            label: "WebGL 2.0",
            description: "Include support for WebGL 2.0 graphics API.<br> If WebGL 2.0 is not available on target platform, the one will fallback as WebGL 1.0.",
        },
        gfx_webgpu: {
            label: "WebGPU",
            description: "Include support for WebGPU graphics API.",
        },
        ui: {
            label: "User Interface",
            description: "User interface support.",
        },
        gpu_driven: {
            label: "GPU Driven",
            description: "Whether to enable GPU-driven solutions",
        },
        base_3d: {
            label: "Basic 3D Features",
            description: "Components and tools that are widely used in general 3D applications.",
        },
        particle: {
            label: "Particle System",
            description: "Particle system support.",
        },
        physics: {
            label: "Physics System",
            description: "Select physics system.",
        },
        physics_builtin: {
            label: "Builtin Physics System",
            description: "Builtin physics system support.",
        },
        physics_cannon: {
            label: "cannon.js Based Physics system",
            description: "Physics system that based on cannon.js.",
        },
        physics_ammo: {
            label: "Bullet Based Physics System",
            description: "Physics system that based on Bullet.",
        },
        physics_physx: {
            label: "PhysX Based Physics System",
            description: "Physics system that based on PhysX.",
        },
        primitives: {
            label: "Primitive Geometries",
            description: "Libraries that used to create primitive geometries.",
        },
        base_2d: {
            label: "Basic 2D Features",
            description: "Components and tools that are widely used in general 2D applications.",
        },
        sorting_2d: {
            label: "2D Rendering Sorting",
            description: "Sorting UIRenderers by the configuration in Sorting2D component.",
        },
        rich_text: {
            label: "Rich Text",
            description: "Rich text support.",
        },
        mask: {
            label: "Mask",
            description: "Mask support.",
        },
        graphics_2d: {
            label: "Graphic Drawing",
            description: "2D Graphic Drawing support.",
        },
        ui_skew: {
            label: "Skew",
            description: "Skew support.",
        },
        affine_transform: {
            label: "2D Affine Transform",
            description: "2D Affine Transform support.",
        },
        physics_2d: {
            label: "2D Physics System",
            description: "Physics system that applied to 2D application.",
        },
        physics_2d_builtin: {
            label: "Builtin 2D Physics System",
            description: "Builtin 2D physics system support.",
        },
        physics_2d_box2d: {
            label: "Box2D Based 2D Physics System",
            description: "2D Physics system that based on Box2D.",
        },
        physics_2d_box2d_wasm: {
            label: "Box2D-wasm Based 2D Physics System",
            description: "2D Physics system that based on Box2D-wasm.",
        },
        physics_2d_box2d_jsb: {
            label: "Box2D-JSB Based 2D Physics System",
            description: "2D Physics system that based on Box2D-JSB.",
        },
        intersection_2d: {
            label: "2D Intersection Algorithms",
            description: "Include 2D intersection algorithms.",
        },
        particle_2d: {
            label: "2D Particle System",
            description: "Particle system that applied to 2D application.",
        },
        terrain: {
            label: "Terrain",
            description: "Terrain support.",
        },
        light_probe: {
            label: "Light Probe",
            description: "Light Probe support.",
        },
        audio: {
            label: "Audio",
            description: "Audio playing support.",
        },
        video: {
            label: "Video",
            description: "Video playing support.",
        },
        webview: {
            label: "Web View",
            description: "Support displaying Web contents.",
        },
        tween: {
            label: "Tween",
            description: "Tween system.",
        },
        profiler: {
            label: "Running Stats",
            description: "Include various components and tools used to audit and display rendering stats.",
        },
        occlusion_query: {
            label: "Occlusion Query",
            description: "Hardware based occlusion query.",
        },
        geometry_renderer: {
            label: "Geometry Renderer",
            description: "Used to render various geometries for debugging or use in editor.",
        },
        debug_renderer: {
            label: "Debug Renderer",
            description: "Used to render screen text for debugging.",
        },
        tiled_map: {
            label: "Tiled Map",
            description: "Tiled map support.",
        },
        vendor_google: {
            label: "Vendor Google",
            description: "Vendor support.",
        },
        spine: {
            label: "Spine Animation",
            description: "Spine Animation support.",
        },
        spine_38: {
            label: "Spine 3.8",
            description: "Spine 3.8",
        },
        spine_42: {
            label: "Spine 4.2",
            description: "Spine 4.2",
        },
        dragon_bones: {
            label: "Dragon Bones",
            description: "Dragon Bones support.",
        },
        animation: {
            label: "Basic Animation",
            description: "Basic animation support.",
        },
        skeletal_animation: {
            label: "Skeletal Animation",
            description: "Skeletal animation support.",
        },
        marionette: {
            label: "Marionette Animation System",
            description: "Enable the Marionette animation system",
        },
        procedural_animation: {
            label: "Procedural Animation",
            description: "Enable the procedural animation related features, such as pose graph etc.",
        },
        xr: {
            label: "XR",
            description: "Enable the XR function system",
        },
        custom_pipeline: {
            label: "Render Pipeline (New)",
            description: "The new render pipeline is based on data-oriented render graph. Users can write cross platform render pipelines and optimize for the specific platform.",
        },
        custom_pipeline_post_process: {
            label: "Post Process Module (Deprecated)",
            description: "The render pipeline used in previous versions. This pipeline will be deprecated in future versions.",
        },
        legacy_pipeline: {
            label: "Render Pipeline (Legacy)",
            description: "The render pipeline used in previous versions. This pipeline will be deprecated in future versions.",
        },
        websocket: {
            label: "WebSocket",
            description: "Enable WebSocket for native. For implementation, iOS/macOS uses SocketRocket, Android uses OkHttp, and Windows uses libwebsockets.",
        },
        websocket_server: {
            label: "WebSocket Server",
            description: "Enable WebSocket Server for native. Note: WebSocket must also be enabled.",
        },
        flags: {
            spine: {
                loadManual: {
                    label: 'Load Manually',
                    description: `Whether to load Spine Wasm/AsmJS moudle manually by 'loadWasmModuleSpine' API ?`,
                },
            },
            box2d: {
                loadManual: {
                    label: 'Load Manually',
                    description: `Whether to load Box2D Wasm/AsmJS moudle manually by 'loadWasmModuleBox2D' API ?`,
                },
            },
            bullet: {
                loadManual: {
                    label: 'Load Manually',
                    description: `Whether to load Bullet Wasm/AsmJS moudle manually by 'loadWasmModuleBullet' API ?`,
                },
            },
            physx: {
                loadManual: {
                    label: 'Load Manually',
                    description: `Whether to load PhysX Wasm/AsmJS moudle manually by 'loadWasmModulePhysX' API ?`,
                },
            },
        },
    },
    renderable_2d: {
        srcBlendFactor: 'Specifies the source blend mode, <br>it will clone a new material object.',
        dstBlendFactor: 'Specifies the destination blend mode.',
        color: 'Main color for rendering, it normally multiplies with texture color.',
    },
    ui_transform: {
        content_size: 'Size of the UI node.',
        anchor_point: 'Anchor point of the UI node.',
        priority: 'Priority of rendering ordering.',
    },
    graphics: {
        lineWidth: 'The width of edges',
        lineJoin: 'Determines how two connecting segments (of lines, arcs or curves) with non-zero lengths in a shape are joined together.',
        lineCap: 'Determines how the end points of every line are drawn.',
        strokeColor: 'Brush stroke color.',
        fillColor: 'Fill paint color.',
        miterLimit: 'Set the miter limit ratio.',
    },
    physics3d: {
        rigidbody: {
            group: 'Group of this rigid body',
            type: 'Type of this rigid body',
            mass: 'The mass of this rigid body, which needs to be greater than 0',
            allowSleep: 'Whether to allow automatic hibernation',
            linearDamping: 'Used to decay the linear velocity, <br>the larger it is, the faster the decay will be',
            angularDamping: 'Used to decay the angular velocity, <br>the larger it is, the faster the decay will be',
            useGravity: 'Whether to use gravity',
            linearFactor: 'For scaling physical values (velocity or force) in each axis direction',
            angularFactor: 'Angular factor to scale physical values (velocity or force) in each axis direction',
        },
        collider: {
            attached: 'The rigid body where the collider is attached to',
            sharedMaterial: 'The physical material used, default when not set',
            isTrigger: 'Whether it is a trigger, the trigger does not generate physical feedback',
            center: 'The center of the shape in the local coordinate system',
            sphere_radius: 'The radius of the sphere in the local coordinate system',
            box_size: 'The size of the box in the local coordinate system',
            capsule_radius: 'The radius of the sphere on the capsule body in the local coordinate system',
            capsule_cylinderHeight: 'The height of the cylinder on the capsule in the local coordinate system',
            capsule_direction: 'The orientation of the capsule body in the local coordinate system',
            cone_radius: 'The radius of the upper circular surface of the cone in the local coordinate system',
            cone_height: 'The height of the cone in the corresponding axial direction in the local coordinate system',
            cone_direction: 'The orientation of the cone in the local coordinate system',
            cylinder_radius: 'The radius of the circular surface on the cylinder in the local coordinate system',
            cylinder_height: 'The height of the cylinder in the corresponding axial direction in the local coordinate system',
            cylinder_direction: 'The orientation of the cylinder in the local coordinate system',
            plane_normal: 'The normal to the plane in the local coordinate system',
            plane_constant: 'The distance of the plane moving along the normal from the origin in the local coordinate system',
            mesh_mesh: 'Mesh resources used by collider',
            mesh_convex: 'Whether to use convex hull approximation instead, <br>the number of vertices should be less than 255, <br>and the dynamics can be supported after turning on',
            terrain_terrain: 'Terrain resources used by collider',
            simplex_shapeType: 'Simplex type, point, line, triangle, tetrahedron',
            simplex_vertex0: 'Vertex 0 of the shape',
            simplex_vertex1: 'Vertex 1 of the shape',
            simplex_vertex2: 'Vertex 2 of the shape',
            simplex_vertex3: 'Vertex 3 of the shape',
        },
        constant_force: {
            force: 'The force apply on a rigid body in the world coordinate system',
            localForce: 'The force apply on a rigid body in the local coordinate system',
            torque: 'The torque applied to the rigid body in the world coordinate system',
            localTorque: 'The torque applied to the rigid body in the local coordinate system',
        },
        constraint: {
            attachedBody: 'The rigid body where the constraint is attached to',
            connectedBody: 'The rigid body connected to the constraint, <br>if not set, the world object will be used',
            enableCollision: 'Whether to enable collision between the two rigid bodies',
            pivotA: 'The pivot point of the constraint in the local coordinate system of the attached rigid body',
            pivotB: 'The pivot point of the constraint in the local coordinate system of the connected rigid body',
            breakForce: 'The maximum force that can be applied to the constraint before it breaks',
            breakTorque: 'The maximum torque that can be applied to the constraint before it breaks',
            axis: 'The axis of the constraint in the local coordinate system of the attached rigid body',
            secondaryAxis: 'The secondary axis of the constraint in the local coordinate system of the attached rigid body',
            autoCalculatePivotB: 'Automatically derivate the pivotB from the pivotA and the relative transform of the two rigid bodies',
            linearLimit: {
                xMotion: 'The constraint mode along the x axis',
                yMotion: 'The constraint mode along the y axis',
                zMotion: 'The constraint mode along the z axis',
                upper: 'The upper limit of the constraint',
                lower: 'The lower limit of the constraint',
                enableSoftConstraint: 'Whether to enable soft constraint',
                stiffness: 'The stiffness factor of the constraint',
                damping: 'The damping factor of the constraint',
                restitution: 'The restitution factor of the constraint',
            },
            angularLimit: {
                twistMotion: 'The constraint mode of the twist angle',
                swingMotion1: 'The constraint mode of the swing y angle',
                swingMotion2: 'The constraint mode of the swing z angle',
                twistExtent: 'The twist angle limit',
                swingExtent1: 'The swing y angle limit',
                swingExtent2: 'The swing z angle limit',
                enableSoftConstraintSwing: 'Whether to enable soft constraint for the swing constraint',
                swingStiffness: 'The stiffness factor of the swing constraint',
                swingDamping: 'The damping factor of the swing constraint',
                swingRestitution: 'The restitution factor of the swing constraint',
                enableSoftConstraintTwist: 'Whether to enable soft constraint for the twist constraint',
                twistStiffness: 'The stiffness factor of the twist constraint',
                twistDamping: 'The damping factor of the twist constraint',
                twistRestitution: 'The restitution factor of the twist constraint',
            },
            linearDriver: {
                xMode: 'The driver mode along the x axis',
                yMode: 'The driver mode along the y axis',
                zMode: 'The driver mode along the z axis',
                targetPosition: 'The target position of the driver',
                targetVelocity: 'The target velocity of the driver',
                strength: 'The strength of the driver',
            },
            angularDriver: {
                twistMode: 'The driver mode along the twist axis',
                swingMode1: 'The driver mode along the swing y axis',
                swingMode2: 'The driver mode along the swing z axis',
                targetOrientation: 'The target orientation of the driver',
                targetAngularVelocity: 'The target angular velocity of the driver',
                strength: 'The strength of the driver',
            },
        },
        character_controller: {
            group: 'Collision Group of the character controller.',
            minMoveDistance: 'The minimum movement distance of the character controller.',
            stepOffset: 'The step offset of the character controller.',
            slopeLimit: 'The slope limit of the character controller in degree.',
            skinWidth: 'The skin width of the character controller.',
            detectCollisions: 'If the character controller can collide with other objects without calling move().',
            enableOverlapRecovery: 'If the character controller enable overlap recovery when penetrating with other colliders.',
            center: 'The center of the character controller in local space.',
            capsuleRadius: 'The radius of the sphere of the capsule shape of the character controller in local space.',
            capsuleHeight: 'The height of the capsule shape of the character controller in local space.',
            boxHalfHeight: 'The half height of the box shape of the character controller in local space.',
            boxHalfSideExtent: 'The half side extent of box shape of the character controller in local space.',
            boxHalfForwardExtent: 'The half forward extent of the box shape of the character controller in local space.',
        },
    },
    octree_culling: {
        enabled: 'The switch of octree culling, only available for native platforms.',
        minPos: 'The minimum position of the world bounding box.',
        maxPos: 'The maximum position of the world bounding box.',
        depth: 'The depth of octree.',
    },
    skin: {
        enabled: 'The switch of skin scattering',
        blurRadius: 'This parameter specifies the range of subsurface scattering , in other words, scattering filter width.',
        sssIntensity: 'This parameter specifies the intensity of subsurface scattering.',
    },
    light_probe: {
        giScale: 'The value of GI multiplier.',
        giSamples: 'The value of GI sample counts.',
        bounces: 'The value of light bounces.',
        reduceRinging: 'The value to reduce ringing of light probe.',
        showProbe: 'The switch of showing light probe.',
        showWireframe: 'The switch of showing connection of light probe.',
        showConvex: 'The switch of showing convex of light probe.',
        lightProbeSphereVolume: 'The value of all light probe sphere display size',
    },
    light_probe_group: {
        method: 'The automatic generation algorithm of light probe.',
        nProbesX: 'The number of probes generated in X axis.',
        nProbesY: 'The number of probes generated in Y axis.',
        nProbesZ: 'The number of probes generated in Z axis.',
        minPos: 'The minimum point of the bounding box of the generated probes.',
        maxPos: 'The maximum point of the bounding box of the generated probes.',
    },
    reflection_probe: {
        fastBake: 'If checked, generating progress will ignore GGX convolution for cubemap, very fast generation.',
    },
    hbao: {
        radiusScale: 'The range of ambient occlusion, by adjusting this value, the dark area can be better adapted to the scale of the scene.',
        aoSaturation: 'The saturation of ambient occlusion, the higher the value, the darker.',
        needBlur: 'Turn on for a softer effect with less noise, but it consumes some performance.',
    },
    bloom: {
        enableAlphaMask: 'Transparent channel flag bit, if you turn on this function, please also reduce the object material intrinsic color a channel output, a value of less than 1 object will not have a flood light',
        useHdrIlluminance: 'To use scene HDR brightness to filter flooded areas, both HDR mode and the CC_USE_FLOAT_OUTPUT macro must be enabled.',
        threshold: 'The brightness threshold, brighter area will produce bloom, this value unit is the LDR brightness seen by the human eye, independent of exposure.',
        iterations: 'The number of blur iterations, the higher the value that results in a larger and softer flare range, but with reduced performance.',
        intensity: 'Flood intensity, the higher the value, the brighter the halo, please adjust it moderately.',
    },
    color_grading: {
        contribute: 'Adjust contribution of LUT for screen color, The influence on screen color can be adjusted in the range of 0-1.',
        originalMap: 'Support arbitary LUT for Nx1 blocks or 8x8 blocks automatically. The builtin lut texture path is internal/dependencies/textures/lut/.',
    },
    taa: {
        sampleScale: 'TAA sample range. Smaller values are recommended, as too large values may cause jittering.',
        feedback: 'History frame blend value. The higher the value, the better the anti-aliasing effect, but the picture may become blurry.',
    },
    fsr: {
        sharpness: 'Sharpness',
    },
    postprocess: {
        global: 'Whether the post process is enabled for all post process camera.',
        shadingScale: 'Rendering resolution.',
        enableShadingScaleInEditor: 'Enable Shading Scale In Editor',
    },
    tone_mapping: {
        toneMappingType: 'Tone mapping type,valid only when HDR is enabled.',
    },
},

require('./modules/physics'),
require('./modules/rendering'),
require('./modules/ui.js'),
require('./modules/terrain.js'),
require('./animation'),

));
