/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hvr;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.util.Log;
import dalvik.system.DexClassLoader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LibUpdateClient {
    private Context mContext;
    private String mApkPath;
    private String mLibDirPath;
    private static final String LOG_TAG = "LibUpdateCall";
    private static final String LIB_PACKAGE_NAME = "com.huawei.hvrsdkserverapp";
    private static final String DEX_NAME = "classes.dex";
    private static final String DEX_CLASS_NAME = "com.huawei.hvr.LibUpdate";
    private static final String DEX_METHOD_NAME = "updateAndLoad";
    private static final String FULL_APP_FLAG_CLASS = "com.huawei.vrframework.VrFramework";
    private static final String REMOTE_PACKAGE_NAME = "com.huawei.hvrsdkserverapp";
    private static final String REMOTE_CLASS_NAME = "com.huawei.hvr.LibUpdateServer";
    private static final String REMOTE_METHOD_NAME = "update";
    private Context mRemoteContext;
    private String mRemotePkgPath;
    private String mRemoteLibPath;

    public LibUpdateClient(Context context) {
        this.mContext = context;
        this.mLibDirPath = this.mContext.getDir("SdkLibs", 0).getAbsolutePath();
    }

    public boolean runUpdate() {
        if (this.runUpdate2()) {
            Log.i((String)LOG_TAG, (String)"Run update 2.0 succeed");
            return true;
        }
        Log.i((String)LOG_TAG, (String)"Run update fall back 1.0");
        this.mApkPath = this.getAppPath("com.huawei.hvrsdkserverapp");
        if (this.mApkPath == null) {
            Log.e((String)LOG_TAG, (String)"can't find apk");
            return false;
        }
        Log.i((String)LOG_TAG, (String)"get server apkpath ok");
        this.unzipApk(DEX_NAME, this.mLibDirPath);
        String string = this.mLibDirPath + "/" + DEX_NAME;
        if (!new File(string).exists()) {
            Log.e((String)LOG_TAG, (String)"can't get dex");
            return false;
        }
        if (!this.call(string)) {
            Log.e((String)LOG_TAG, (String)"load dex fail");
            return false;
        }
        return true;
    }

    private boolean runUpdate2() {
        if (!this.initRemoteEnv()) {
            Log.e((String)LOG_TAG, (String)"Init remote env failed");
            return false;
        }
        return this.loadRemoteClass();
    }

    private boolean safeCheck() {
        if (this.mRemoteContext == null) {
            Log.e((String)LOG_TAG, (String)"Remote context is null");
            return false;
        }
        if (Process.myUid() != 1000) {
            return true;
        }
        Log.i((String)LOG_TAG, (String)"Run on system app");
        return this.mRemoteContext.getApplicationInfo().uid == 1000;
    }

    private boolean initRemoteEnv() {
        if (this.mContext == null) {
            Log.e((String)LOG_TAG, (String)"Context is null");
            return false;
        }
        try {
            this.mRemoteContext = this.mContext.createPackageContext("com.huawei.hvrsdkserverapp", 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)LOG_TAG, (String)"Remote server package not found");
            return false;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
        if (!this.safeCheck()) {
            Log.e((String)LOG_TAG, (String)"Safe check failed");
            return false;
        }
        this.mRemotePkgPath = this.mRemoteContext.getPackageResourcePath();
        this.mRemoteLibPath = this.mRemoteContext.getApplicationInfo().nativeLibraryDir;
        while (this.mRemoteLibPath.endsWith("/")) {
            this.mRemoteLibPath = this.mRemoteLibPath.substring(0, this.mRemoteLibPath.length() - 1);
        }
        return LibUpdateClient.checkSysLibPath(this.mRemoteLibPath);
    }

    private boolean loadRemoteClass() {
        Log.i((String)LOG_TAG, (String)"loadRemoteClass in");
        DexClassLoader dexClassLoader = new DexClassLoader(this.mRemotePkgPath, this.mContext.getCacheDir().getAbsolutePath(), this.mRemoteLibPath, this.mRemoteContext.getClassLoader());
        try {
            Class clazz = dexClassLoader.loadClass(REMOTE_CLASS_NAME);
            Constructor constructor = clazz.getConstructor(Context.class, Context.class, Object.class, String.class);
            Object t = constructor.newInstance(this.mContext, this.mRemoteContext, this.getClass(), this.mRemoteLibPath);
            Method method = clazz.getDeclaredMethod(REMOTE_METHOD_NAME, new Class[0]);
            method.setAccessible(true);
            if (!((Boolean)method.invoke(t, new Object[0])).booleanValue()) {
                Log.w((String)LOG_TAG, (String)"Call remote update failed");
                return false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)LOG_TAG, (String)"Remote class com.huawei.hvr.LibUpdateServernot found, it maybe server 2.0");
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.w((String)LOG_TAG, (String)"Remote method updatenot found, check if the server is correct");
            return false;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return false;
        }
        Log.i((String)LOG_TAG, (String)"loadRemoteClass succeed");
        return true;
    }

    private static boolean is64Bit() {
        try {
            Class<?> clazz = Class.forName("dalvik.system.VMRuntime");
            if (clazz == null) {
                return false;
            }
            Method method = clazz.getDeclaredMethod("getRuntime", new Class[0]);
            if (method == null) {
                return false;
            }
            Object object = method.invoke(null, new Object[0]);
            if (object == null) {
                return false;
            }
            Method method2 = clazz.getDeclaredMethod("is64Bit", new Class[0]);
            if (method2 == null) {
                return false;
            }
            Object object2 = method2.invoke(object, new Object[0]);
            if (object2 instanceof Boolean) {
                return (Boolean)object2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    private static boolean checkSysLibPath(String string) {
        if (string == null) {
            Log.i((String)LOG_TAG, (String)"LibPath is null");
            return false;
        }
        if (LibUpdateClient.is64Bit()) {
            if (string.endsWith("arm64")) {
                Log.i((String)LOG_TAG, (String)"App is 64 bit");
                return true;
            }
            if (string.endsWith("arm")) {
                Log.w((String)LOG_TAG, (String)"App is 64 bit, but server is 32 bit");
                return false;
            }
            Log.w((String)LOG_TAG, (String)"App is 64 bit, but server is unknown");
        } else {
            if (string.endsWith("arm64")) {
                Log.w((String)LOG_TAG, (String)"App is 32 bit, but server is 64 bit");
                return false;
            }
            if (string.endsWith("arm")) {
                Log.w((String)LOG_TAG, (String)"App is 32 bit");
                return true;
            }
            Log.w((String)LOG_TAG, (String)"App is 32 bit, but server is unknown");
        }
        return false;
    }

    public static String getVrSdkLibPath(Context context) {
        if (context == null) {
            Log.e((String)LOG_TAG, (String)"App context is null");
            return null;
        }
        Context context2 = null;
        try {
            context2 = context.createPackageContext("com.huawei.hvrsdkserverapp", 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        String string = null;
        if (context2 != null && LibUpdateClient.checkSysLibPath(string = context2.getApplicationInfo().nativeLibraryDir)) {
            return string;
        }
        try {
            context.getClassLoader().loadClass(FULL_APP_FLAG_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.i((String)LOG_TAG, (String)"Not full app");
            return context.getDir("SdkLibs", 0).getAbsolutePath();
        }
        Log.i((String)LOG_TAG, (String)"Full app");
        return context.getApplicationInfo().nativeLibraryDir;
    }

    private boolean call(String string) {
        DexClassLoader dexClassLoader = new DexClassLoader(string, this.mContext.getCacheDir().getAbsolutePath(), null, this.mContext.getClassLoader());
        try {
            Class clazz = dexClassLoader.loadClass(DEX_CLASS_NAME);
            Constructor constructor = clazz.getConstructor(Context.class);
            Object t = constructor.newInstance(this.mContext);
            Method method = clazz.getDeclaredMethod(DEX_METHOD_NAME, new Class[0]);
            method.setAccessible(true);
            method.invoke(t, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private String getAppPath(String string) {
        List list = this.mContext.getPackageManager().getInstalledApplications(64);
        String string2 = null;
        for (ApplicationInfo applicationInfo : list) {
            if (!applicationInfo.packageName.equals(string)) continue;
            string2 = applicationInfo.sourceDir;
            break;
        }
        if (string2 == null) {
            Log.w((String)LOG_TAG, (String)"can not find server app ,try another way");
            string2 = this.getAppPathBack(string);
        }
        return string2;
    }

    private String getAppPathBack(String string) {
        for (int i = 0; i < 5; ++i) {
            String string2 = "/data/app/" + string + "-" + i + "/base.apk";
            if (!new File(string2).exists()) continue;
            return string2;
        }
        return null;
    }

    private static void validateFileName(String string, String string2) {
        if (string.contains(string2)) {
            throw new IllegalStateException("File is outside extraction target directory.");
        }
    }

    private static String sanitzeFileName(String string, String string2) throws IOException {
        File file;
        String string3;
        File file2 = new File(string2, string);
        String string4 = file2.getCanonicalPath();
        if (string4.startsWith(string3 = (file = new File(string2)).getCanonicalPath())) {
            return string4;
        }
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    private void unzipApk(String string, String string2) {
        int n = 4096;
        try {
            ZipEntry zipEntry;
            BufferedOutputStream bufferedOutputStream = null;
            FileInputStream fileInputStream = new FileInputStream(this.mApkPath);
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                try {
                    int n2;
                    String string3 = zipEntry.getName();
                    LibUpdateClient.validateFileName(string3, "../");
                    string3 = LibUpdateClient.sanitzeFileName(string3, ".");
                    if (!string3.endsWith(string)) continue;
                    byte[] byArray = new byte[n];
                    String string4 = string2 + "/" + string;
                    LibUpdateClient.validateFileName(string4, "../");
                    string3 = LibUpdateClient.sanitzeFileName(string4, ".");
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(string4));
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream, n);
                    while ((n2 = zipInputStream.read(byArray, 0, n)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n2);
                    }
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadSo(String string) {
        try {
            System.load(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadClass(int n, Object object) {
        try {
            LibUpdateClient.setClass(n, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void NotifyEvent(int n, long l, long l2) {
        LibUpdateClient.setEvent(n, l, l2);
    }

    private static native void setClass(int var0, Object var1);

    private static native void setEvent(int var0, long var1, long var3);
}

