/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidgamesdk;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.FrameLayout;
import dalvik.system.BaseDexClassLoader;
import java.io.File;

public class GameActivity
extends Activity
implements SurfaceHolder.Callback2 {
    private static final String LOG_TAG = "GameActivity";
    public static final String META_DATA_LIB_NAME = "android.app.lib_name";
    public static final String META_DATA_FUNC_NAME = "android.app.func_name";
    private static final String KEY_NATIVE_SAVED_STATE = "android:native_state";
    protected int contentViewId;
    private EditorInfo imeEditorInfo;
    protected SurfaceView mSurfaceView;
    private long mNativeHandle;
    private SurfaceHolder mCurSurfaceHolder;
    protected final int[] mLocation = new int[2];
    protected boolean mDestroyed;

    protected boolean processMotionEvent(MotionEvent event) {
        int action = Build.VERSION.SDK_INT >= 23 ? event.getActionButton() : 0;
        int cls = Build.VERSION.SDK_INT >= 29 ? event.getClassification() : 0;
        return this.onTouchEventNative(this.mNativeHandle, event, event.getPointerCount(), event.getHistorySize(), event.getDeviceId(), event.getSource(), event.getAction(), event.getEventTime(), event.getDownTime(), event.getFlags(), event.getMetaState(), action, event.getButtonState(), cls, event.getEdgeFlags(), event.getXPrecision(), event.getYPrecision());
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.processMotionEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.processMotionEvent(event)) {
            return true;
        }
        return super.onGenericMotionEvent(event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.onKeyUpNative(this.mNativeHandle, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.onKeyDownNative(this.mNativeHandle, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected native long loadNativeCode(String var1, String var2, String var3, String var4, String var5, AssetManager var6, byte[] var7);

    protected native String getDlError();

    protected native void unloadNativeCode(long var1);

    protected native void onStartNative(long var1);

    protected native void onResumeNative(long var1);

    protected native byte[] onSaveInstanceStateNative(long var1);

    protected native void onPauseNative(long var1);

    protected native void onStopNative(long var1);

    protected native void onConfigurationChangedNative(long var1);

    protected native void onTrimMemoryNative(long var1, int var3);

    protected native void onWindowFocusChangedNative(long var1, boolean var3);

    protected native void onSurfaceCreatedNative(long var1, Surface var3);

    protected native void onSurfaceChangedNative(long var1, Surface var3, int var4, int var5, int var6);

    protected native void onSurfaceRedrawNeededNative(long var1, Surface var3);

    protected native void onSurfaceDestroyedNative(long var1);

    protected native boolean onTouchEventNative(long var1, MotionEvent var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11, int var13, int var14, int var15, int var16, int var17, int var18, float var19, float var20);

    protected native boolean onKeyDownNative(long var1, KeyEvent var3);

    protected native boolean onKeyUpNative(long var1, KeyEvent var3);

    protected native void onWindowInsetsChangedNative(long var1);

    public long getGameActivityNativeHandle() {
        return this.mNativeHandle;
    }

    protected void onCreateSurfaceView() {
        this.mSurfaceView = new SurfaceView((Context)this);
        FrameLayout frameLayout = new FrameLayout((Context)this);
        this.contentViewId = View.generateViewId();
        frameLayout.setId(this.contentViewId);
        frameLayout.addView((View)this.mSurfaceView);
        this.setContentView((View)frameLayout);
        frameLayout.requestFocus();
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    protected void onSetUpWindow() {
        this.getWindow().setFormat(4);
        this.getWindow().setSoftInputMode(16);
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.onCreateSurfaceView();
        this.onSetUpWindow();
        String libname = "main";
        if (null != this.getIntent().getStringExtra(META_DATA_LIB_NAME)) {
            libname = this.getIntent().getStringExtra(META_DATA_LIB_NAME);
        }
        String funcname = "GameActivity_onCreate";
        try {
            ActivityInfo ai = this.getPackageManager().getActivityInfo(this.getIntent().getComponent(), 128);
            if (ai.metaData != null) {
                String ln = ai.metaData.getString(META_DATA_LIB_NAME);
                if (ln != null) {
                    libname = ln;
                }
                if ((ln = ai.metaData.getString(META_DATA_FUNC_NAME)) != null) {
                    funcname = ln;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Error getting activity info", e);
        }
        BaseDexClassLoader classLoader = (BaseDexClassLoader)this.getClassLoader();
        String path = classLoader.findLibrary(libname);
        if (path == null) {
            throw new IllegalArgumentException("Unable to find native library " + libname + " using classloader: " + classLoader.toString());
        }
        byte[] nativeSavedState = savedInstanceState != null ? savedInstanceState.getByteArray(KEY_NATIVE_SAVED_STATE) : null;
        this.mNativeHandle = this.loadNativeCode(path, funcname, GameActivity.getAbsolutePath(this.getFilesDir()), GameActivity.getAbsolutePath(this.getObbDir()), GameActivity.getAbsolutePath(this.getExternalFilesDir(null)), this.getAssets(), nativeSavedState);
        if (this.mNativeHandle == 0L) {
            throw new UnsatisfiedLinkError("Unable to load native library \"" + path + "\": " + this.getDlError());
        }
        super.onCreate(savedInstanceState);
    }

    private static String getAbsolutePath(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    protected void onDestroy() {
        this.mDestroyed = true;
        if (this.mCurSurfaceHolder != null) {
            this.onSurfaceDestroyedNative(this.mNativeHandle);
            this.mCurSurfaceHolder = null;
        }
        this.unloadNativeCode(this.mNativeHandle);
        super.onDestroy();
    }

    protected void onPause() {
        super.onPause();
        this.onPauseNative(this.mNativeHandle);
    }

    protected void onResume() {
        super.onResume();
        this.onResumeNative(this.mNativeHandle);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        byte[] state = this.onSaveInstanceStateNative(this.mNativeHandle);
        if (state != null) {
            outState.putByteArray(KEY_NATIVE_SAVED_STATE, state);
        }
    }

    protected void onStart() {
        super.onStart();
        this.onStartNative(this.mNativeHandle);
    }

    protected void onStop() {
        super.onStop();
        this.onStopNative(this.mNativeHandle);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (!this.mDestroyed) {
            this.onConfigurationChangedNative(this.mNativeHandle);
        }
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (!this.mDestroyed) {
            this.onTrimMemoryNative(this.mNativeHandle, level);
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (!this.mDestroyed) {
            this.onWindowFocusChangedNative(this.mNativeHandle, hasFocus);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = holder;
            this.onSurfaceCreatedNative(this.mNativeHandle, holder.getSurface());
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = holder;
            this.onSurfaceChangedNative(this.mNativeHandle, holder.getSurface(), format, width, height);
        }
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = holder;
            this.onSurfaceRedrawNeededNative(this.mNativeHandle, holder.getSurface());
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mCurSurfaceHolder = null;
        if (!this.mDestroyed) {
            this.onSurfaceDestroyedNative(this.mNativeHandle);
        }
    }

    void setWindowFlags(int flags, int mask) {
        this.getWindow().setFlags(flags, mask);
    }

    void setWindowFormat(int format) {
        this.getWindow().setFormat(format);
    }

    public EditorInfo getImeEditorInfo() {
        if (this.imeEditorInfo == null) {
            this.imeEditorInfo = new EditorInfo();
            this.imeEditorInfo.inputType = 0;
            this.imeEditorInfo.actionId = 1;
            this.imeEditorInfo.imeOptions = 0x40000000;
        }
        return this.imeEditorInfo;
    }

    public void setImeEditorInfo(EditorInfo info) {
        this.imeEditorInfo = info;
    }

    public void setImeEditorInfoFields(int inputType, int actionId, int imeOptions) {
        EditorInfo info = this.getImeEditorInfo();
        info.inputType = inputType;
        info.actionId = actionId;
        info.imeOptions = imeOptions;
    }
}

