/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.games.paddleboat;

import android.hardware.input.InputManager;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.android.games.paddleboat.GameControllerManager;

public class GameControllerThread
extends Thread
implements InputManager.InputDeviceListener {
    private static final String TAG = "GameControllerThread";
    private boolean activeInputDeviceListener = false;
    private GameControllerManager mGameControllerManager;
    private Handler mHandler;

    public void setGameControllerManager(GameControllerManager gcManager) {
        this.mGameControllerManager = gcManager;
    }

    @Override
    public void run() {
        Looper.prepare();
        this.mHandler = new Handler(Looper.myLooper());
        this.onStart();
        Looper.loop();
    }

    public void onStop() {
        if (this.activeInputDeviceListener) {
            Log.d((String)TAG, (String)"unregisterInputDeviceListener");
            this.mGameControllerManager.getAppInputManager().unregisterInputDeviceListener((InputManager.InputDeviceListener)this);
            this.activeInputDeviceListener = false;
        }
    }

    public void onStart() {
        if (!this.activeInputDeviceListener) {
            Log.d((String)TAG, (String)"registerInputDeviceListener");
            this.mGameControllerManager.getAppInputManager().registerInputDeviceListener((InputManager.InputDeviceListener)this, this.mHandler);
            this.activeInputDeviceListener = true;
        }
    }

    public void terminate() {
        if (this.mHandler != null) {
            Log.d((String)TAG, (String)"terminate");
            this.mHandler.getLooper().quit();
            this.mHandler = null;
        }
    }

    public void onInputDeviceAdded(int deviceId) {
        Log.d((String)TAG, (String)("onInputDeviceAdded id: " + deviceId));
        this.mGameControllerManager.onInputDeviceAdded(deviceId);
    }

    public void onInputDeviceRemoved(int deviceId) {
        Log.d((String)TAG, (String)("onInputDeviceRemoved id: " + deviceId));
        this.mGameControllerManager.onInputDeviceRemoved(deviceId);
    }

    public void onInputDeviceChanged(int deviceId) {
        Log.d((String)TAG, (String)("onInputDeviceChanged id: " + deviceId));
        this.mGameControllerManager.onInputDeviceChanged(deviceId);
    }
}

