/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.games.paddleboat;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.hardware.lights.LightsManager;
import android.hardware.lights.LightsRequest;
import android.os.Build;
import android.util.Log;
import android.view.InputDevice;
import com.google.android.games.paddleboat.GameControllerManager;
import com.google.android.games.paddleboat.GuardedBy;

public class GameControllerListener {
    private static final String TAG = "GameControllerListener";
    private boolean reportMotionEvents;
    private int inputDeviceFlags;
    private int inputDeviceId;
    private final GameControllerManager gameControllerManager;
    private GameControllerAccelerometerListener accelerometerListener;
    private GameControllerGyroscopeListener gyroscopeListener;
    private InputDevice inputDevice;
    private final Object mLightLock = new Object();
    @GuardedBy(value="mLightLock")
    private LightsManager lightsManager;
    private LightsManager.LightsSession lightsSession;
    private Sensor accelerometer;
    private Sensor gyroscope;
    private final Object mSensorLock = new Object();
    @GuardedBy(value="mSensorLock")
    private SensorManager sensorManager;

    public GameControllerListener(GameControllerManager gcManager, InputDevice newDevice, int newFlags, boolean motionEvents) {
        this.gameControllerManager = gcManager;
        this.inputDevice = newDevice;
        this.inputDeviceFlags = newFlags;
        this.inputDeviceId = this.inputDevice.getId();
        this.reportMotionEvents = motionEvents;
        this.lightsManager = null;
        this.lightsSession = null;
        this.accelerometer = null;
        this.accelerometerListener = null;
        this.gyroscope = null;
        this.gyroscopeListener = null;
        this.sensorManager = null;
        this.configureMotion();
    }

    public void resetListener(InputDevice newDevice, int newFlags) {
        this.shutdownListener();
        this.inputDevice = newDevice;
        this.inputDeviceFlags = newFlags;
        this.inputDeviceId = newDevice.getId();
        this.configureMotion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownListener() {
        if (Build.VERSION.SDK_INT >= 31) {
            Log.d((String)TAG, (String)"shutdownListener");
            Object object = this.mLightLock;
            synchronized (object) {
                if (this.lightsSession != null) {
                    this.lightsSession.close();
                }
                this.lightsSession = null;
                this.lightsManager = null;
            }
            object = this.mSensorLock;
            synchronized (object) {
                if (this.sensorManager != null) {
                    if (this.accelerometerListener != null) {
                        this.sensorManager.unregisterListener((SensorEventListener)this.accelerometerListener);
                        this.accelerometerListener = null;
                    }
                    if (this.gyroscopeListener != null) {
                        this.sensorManager.unregisterListener((SensorEventListener)this.gyroscopeListener);
                        this.gyroscopeListener = null;
                    }
                }
                this.accelerometer = null;
                this.gyroscope = null;
                this.sensorManager = null;
            }
        }
        this.inputDeviceFlags = 0;
        this.inputDevice = null;
    }

    public void setReportMotionEvents() {
        this.reportMotionEvents = true;
        this.configureMotion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLight(int lightType, int lightValue) {
        if (Build.VERSION.SDK_INT >= 31) {
            Object object = this.mLightLock;
            synchronized (object) {
                if (this.lightsManager == null) {
                    this.configureLights();
                }
                if (this.lightsManager != null) {
                    for (Light currentLight : this.lightsManager.getLights()) {
                        if (lightType == 0 && currentLight.getType() == 10002) {
                            LightState.Builder stateBuilder = new LightState.Builder();
                            stateBuilder.setPlayerId(lightValue);
                            LightsRequest.Builder requestBuilder = new LightsRequest.Builder();
                            requestBuilder.addLight(currentLight, stateBuilder.build());
                            this.lightsSession.requestLights(requestBuilder.build());
                            break;
                        }
                        if (lightType != 1 || !currentLight.hasRgbControl()) continue;
                        LightState.Builder stateBuilder = new LightState.Builder();
                        stateBuilder.setColor(lightValue);
                        LightsRequest.Builder requestBuilder = new LightsRequest.Builder();
                        requestBuilder.addLight(currentLight, stateBuilder.build());
                        this.lightsSession.requestLights(requestBuilder.build());
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLights() {
        if (Build.VERSION.SDK_INT >= 31 && (this.inputDeviceFlags & 0x3000000) != 0) {
            Object object = this.mLightLock;
            synchronized (object) {
                Log.d((String)TAG, (String)"configureLights");
                this.lightsManager = this.inputDevice.getLightsManager();
                this.lightsSession = this.lightsManager.openSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureMotion() {
        if (Build.VERSION.SDK_INT >= 31 && this.reportMotionEvents) {
            Object object = this.mSensorLock;
            synchronized (object) {
                this.sensorManager = this.inputDevice.getSensorManager();
                if ((this.inputDeviceFlags & 0xC00000) != 0) {
                    this.accelerometer = this.sensorManager.getDefaultSensor(1);
                    if (this.accelerometer != null) {
                        if (this.gameControllerManager.getPrintControllerInfo()) {
                            this.printSensorInformation(this.accelerometer, "accelerometer");
                        }
                        this.accelerometerListener = new GameControllerAccelerometerListener(this.accelerometer);
                        Log.d((String)TAG, (String)"registering listener for accelerometer");
                        this.sensorManager.registerListener((SensorEventListener)this.accelerometerListener, this.accelerometer, 1);
                    }
                    this.gyroscope = this.sensorManager.getDefaultSensor(4);
                    if (this.gyroscope != null) {
                        if (this.gameControllerManager.getPrintControllerInfo()) {
                            this.printSensorInformation(this.gyroscope, "gyroscope");
                        }
                        this.gyroscopeListener = new GameControllerGyroscopeListener(this.gyroscope);
                        Log.d((String)TAG, (String)"registering listener for gyroscope");
                        this.sensorManager.registerListener((SensorEventListener)this.gyroscopeListener, this.gyroscope, 1);
                    }
                }
            }
        }
    }

    private void printSensorInformation(Sensor sensor, String sensorName) {
        Log.d((String)TAG, (String)("Registering listener for " + sensorName));
        Log.d((String)TAG, (String)"Begin sensor information -----------------------------");
        if (Build.VERSION.SDK_INT >= 19) {
            Log.d((String)TAG, (String)("getFifoMaxEventCount: " + sensor.getFifoMaxEventCount()));
            Log.d((String)TAG, (String)("getFifoReservedEventCount: " + sensor.getFifoReservedEventCount()));
        }
        if (Build.VERSION.SDK_INT >= 26) {
            Log.d((String)TAG, (String)("getHighestDirectReportRateLevel: " + sensor.getHighestDirectReportRateLevel()));
        }
        if (Build.VERSION.SDK_INT >= 24) {
            Log.d((String)TAG, (String)("getId: " + sensor.getId()));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Log.d((String)TAG, (String)("getMaxDelay: " + sensor.getMaxDelay()));
        }
        Log.d((String)TAG, (String)("getMaximumRange: " + sensor.getMaximumRange()));
        Log.d((String)TAG, (String)("getMinDelay: " + sensor.getMinDelay()));
        Log.d((String)TAG, (String)("getName: " + sensor.getName()));
        Log.d((String)TAG, (String)("getPower: " + sensor.getPower()));
        if (Build.VERSION.SDK_INT >= 21) {
            Log.d((String)TAG, (String)("getReportingMode: " + sensor.getReportingMode()));
        }
        Log.d((String)TAG, (String)("getVendor: " + sensor.getVendor()));
        Log.d((String)TAG, (String)("getVersion: " + sensor.getVersion()));
        if (Build.VERSION.SDK_INT >= 24) {
            Log.d((String)TAG, (String)("isAdditionalInfoSupported: " + sensor.isAdditionalInfoSupported()));
        }
        if (Build.VERSION.SDK_INT >= 26) {
            boolean canMemoryFile = sensor.isDirectChannelTypeSupported(1);
            boolean canHardwareBuffer = sensor.isDirectChannelTypeSupported(2);
            Log.d((String)TAG, (String)("DirectChannel Memory File: " + canMemoryFile));
            Log.d((String)TAG, (String)("DirectChannel Hardware Buffer: " + canHardwareBuffer));
        }
        Log.d((String)TAG, (String)"End sensor information -------------------------------");
    }

    class GameControllerAccelerometerListener
    implements SensorEventListener {
        private final Sensor listenerAccelerometer;

        GameControllerAccelerometerListener(Sensor newAccelerometer) {
            this.listenerAccelerometer = newAccelerometer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSensorChanged(SensorEvent event) {
            if (this.listenerAccelerometer != null) {
                Sensor sensor = this.listenerAccelerometer;
                synchronized (sensor) {
                    if (event.sensor == this.listenerAccelerometer) {
                        GameControllerListener.this.gameControllerManager.onMotionData(GameControllerListener.this.inputDeviceId, 0, event.timestamp, event.values[0], event.values[1], event.values[2]);
                    }
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    class GameControllerGyroscopeListener
    implements SensorEventListener {
        private final Sensor listenerGyroscope;

        GameControllerGyroscopeListener(Sensor newGyroscope) {
            this.listenerGyroscope = newGyroscope;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSensorChanged(SensorEvent event) {
            if (this.listenerGyroscope != null) {
                Sensor sensor = this.listenerGyroscope;
                synchronized (sensor) {
                    if (event.sensor == this.listenerGyroscope) {
                        GameControllerListener.this.gameControllerManager.onMotionData(GameControllerListener.this.inputDeviceId, 1, event.timestamp, event.values[0], event.values[1], event.values[2]);
                    }
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

