/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.games.paddleboat;

import android.os.Build;
import android.view.InputDevice;
import com.google.android.games.paddleboat.GameControllerListener;
import com.google.android.games.paddleboat.GameControllerManager;
import java.util.List;

public class GameControllerInfo {
    private static final int MAX_AXIS_COUNT = 48;
    private static final int AXIS_COUNT_LOW = 31;
    private static final int DEVICEINFO_INDEX_DEVICEID = 0;
    private static final int DEVICEINFO_INDEX_VENDORID = 1;
    private static final int DEVICEINFO_INDEX_PRODUCTID = 2;
    private static final int DEVICEINFO_INDEX_AXISBITS_LOW = 3;
    private static final int DEVICEINFO_INDEX_AXISBITS_HIGH = 4;
    private static final int DEVICEINFO_INDEX_CONTROLLERNUMBER = 5;
    private static final int DEVICEINFO_INDEX_DEVICEFLAGS = 6;
    private static final int DEVICEINFO_ARRAY_SIZE = 7;
    private static final int DEVICEFLAG_VIBRATION = 0x8000000;
    private static final int DEVICEFLAG_VIBRATION_DUAL_MOTOR = 0x10000000;
    private static final int DEVICEFLAG_VIRTUAL_MOUSE = 0x40000000;
    private final int[] mGameControllerDeviceInfoArray = new int[7];
    private final float[] mGameControllerAxisMinArray = new float[48];
    private final float[] mGameControllerAxisMaxArray = new float[48];
    private final float[] mGameControllerAxisFlatArray = new float[48];
    private final float[] mGameControllerAxisFuzzArray = new float[48];
    private final String mGameControllerNameString;
    private GameControllerListener mListener = null;

    GameControllerInfo(InputDevice inputDevice) {
        int index;
        for (index = 0; index < 7; ++index) {
            this.mGameControllerDeviceInfoArray[index] = 0;
        }
        for (index = 0; index < 48; ++index) {
            this.mGameControllerAxisMinArray[index] = 0.0f;
            this.mGameControllerAxisMaxArray[index] = 0.0f;
            this.mGameControllerAxisFlatArray[index] = 0.0f;
            this.mGameControllerAxisFuzzArray[index] = 0.0f;
        }
        this.mGameControllerNameString = inputDevice.getName();
        this.EnumerateAxis(inputDevice);
        this.EnumerateInfoArray(inputDevice);
    }

    public GameControllerListener GetListener() {
        return this.mListener;
    }

    public void SetListener(GameControllerListener listener) {
        this.mListener = listener;
    }

    public int GetGameControllerDeviceId() {
        return this.mGameControllerDeviceInfoArray[0];
    }

    public int GetGameControllerFlags() {
        return this.mGameControllerDeviceInfoArray[6];
    }

    public int[] GetGameControllerDeviceInfoArray() {
        return this.mGameControllerDeviceInfoArray;
    }

    public float[] GetGameControllerAxisMinArray() {
        return this.mGameControllerAxisMinArray;
    }

    public float[] GetGameControllerAxisMaxArray() {
        return this.mGameControllerAxisMaxArray;
    }

    public float[] GetGameControllerAxisFlatArray() {
        return this.mGameControllerAxisFlatArray;
    }

    public float[] GetGameControllerAxisFuzzArray() {
        return this.mGameControllerAxisFuzzArray;
    }

    public String GetGameControllerNameString() {
        return this.mGameControllerNameString;
    }

    private void EnumerateAxis(InputDevice inputDevice) {
        List motionRanges = inputDevice.getMotionRanges();
        for (InputDevice.MotionRange motionRange : motionRanges) {
            int axisSource;
            int axisIndex = motionRange.getAxis();
            if (axisIndex < 0 || axisIndex >= 48 || (axisSource = motionRange.getSource()) != 0x1000010 && axisSource != 1025) continue;
            if (axisIndex <= 31) {
                this.mGameControllerDeviceInfoArray[3] = this.mGameControllerDeviceInfoArray[3] | 1 << axisIndex;
            } else {
                this.mGameControllerDeviceInfoArray[4] = this.mGameControllerDeviceInfoArray[4] | 1 << axisIndex - 32;
            }
            this.mGameControllerAxisMinArray[axisIndex] = motionRange.getMin();
            this.mGameControllerAxisMaxArray[axisIndex] = motionRange.getMax();
            this.mGameControllerAxisFlatArray[axisIndex] = motionRange.getFlat();
            this.mGameControllerAxisFuzzArray[axisIndex] = motionRange.getFuzz();
        }
    }

    private void EnumerateInfoArray(InputDevice inputDevice) {
        this.mGameControllerDeviceInfoArray[0] = inputDevice.getId();
        if (Build.VERSION.SDK_INT >= 19) {
            this.mGameControllerDeviceInfoArray[1] = inputDevice.getVendorId();
            this.mGameControllerDeviceInfoArray[2] = inputDevice.getProductId();
            this.mGameControllerDeviceInfoArray[5] = inputDevice.getControllerNumber();
        }
        this.mGameControllerDeviceInfoArray[6] = GameControllerManager.getControllerFlagsForDevice(inputDevice);
    }
}

