% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_read_write_functions.R
\name{write_msp}
\alias{write_msp}
\title{Write MSP Data to a File}
\usage{
write_msp(info, fn.pre, spec.all)
}
\arguments{
\item{info}{A data frame containing metadata information for each spectrum, where each row represents a spectrum. The data frame must contain a column named `'Mass'` representing the precursor m/z values.}

\item{fn.pre}{A character string representing the prefix for the output file name. The file will be saved with the format `prefix_spectra.msp`.}

\item{spec.all}{A list of data frames where each element corresponds to the MS/MS spectrum of a particular compound. Each data frame must have two columns: `mz` (mass-to-charge ratio) and `intensity`.}
}
\value{
The function does not return any output but writes an MSP file to the disk.
}
\description{
This function writes MSP (Mass Spectral Peak) data to a `.msp` file format. It saves the spectrum data along with precursor m/z information and metadata for each entry.
}
\details{
This function takes metadata and spectral data and writes them in the `.msp` format, which is commonly used to store mass spectra data. The output file is generated based on the provided prefix and contains all the spectra and their associated information.
}
\examples{
\dontrun{
# Example of writing MSP data
info <- data.frame(Mass = c(300.12, 250.14), Name = c("Compound1", "Compound2"))
spec.all <- list(
  data.frame(mz = c(100, 150, 200), intensity = c(1000, 1500, 2000)),
  data.frame(mz = c(110, 160, 210), intensity = c(1200, 1300, 1400))
)
write_msp(info, fn.pre = "example", spec.all = spec.all)
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
