% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/19_output_for_other_database.R
\name{write_mgf_gnps}
\alias{write_mgf_gnps}
\title{Write GNPS Spectra to MGF Format}
\usage{
write_mgf_gnps(database, path = ".")
}
\arguments{
\item{database}{An object of class `databaseClass` containing spectral data and metadata.}

\item{path}{A character string specifying the directory where the MGF files will be written. Defaults to the current directory (`"."`).}
}
\value{
This function does not return any value. It writes MGF files for positive and negative mode spectra in the specified directory.
}
\description{
This function writes MS2 spectra from a given `databaseClass` object to MGF format files for both positive and negative ion modes. The spectra are written separately for each ion mode, following the format required for GNPS (Global Natural Products Social Molecular Networking).
}
\details{
This function extracts the spectra from a `databaseClass` object and writes them into MGF files. The positive mode spectra are written to `spectra_pos.mgf` and the negative mode spectra are written to `spectra_neg.mgf`. Each entry in the MGF file includes information such as the compound name, precursor type, ion mode, retention time, and the corresponding MS2 spectrum in the required GNPS format.
}
\examples{
\dontrun{
# Write MGF data from a databaseClass object
write_mgf_gnps(database = my_database, path = "output_directory")
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
