% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{remove_impossible_annotations}
\alias{remove_impossible_annotations}
\title{Remove Impossible Annotations Based on Adducts}
\usage{
remove_impossible_annotations(match_result)
}
\arguments{
\item{match_result}{A data frame containing matched metabolites, including the columns `Formula` and `Adduct`.}
}
\value{
A data frame with impossible annotations removed. The `Formula` column is dropped from the final output.
}
\description{
This function removes impossible metabolite annotations based on the chemical formula and detected adducts. It checks for impossible adducts such as multiple losses of water (e.g., `-H2O`, `-2H2O`) that cannot be supported by the molecular formula's hydrogen and oxygen content.
}
\details{
The function analyzes the `Formula` and `Adduct` columns to identify impossible matches. For adducts that suggest a loss of water (e.g., `-H2O`, `-2H2O`), the function compares the number of hydrogens and oxygens in the molecular formula to see if the loss of water is feasible. If the molecular formula cannot support the loss, the annotation is removed.

Specifically, the function:
* Extracts the number of hydrogens (`H`) and oxygens (`O`) from the molecular formula.
* Calculates whether the number of hydrogens and oxygens can support the indicated loss of water in the adduct.
* Removes annotations where the molecular formula has insufficient hydrogen or oxygen atoms for the adduct.
}
\examples{
\dontrun{
# Example data frame with matched metabolites
match_result <- data.frame(
  Formula = c("C6H12O6", "C5H10O5", "C7H14O7"),
  Adduct = c("(M-H2O)+", "(M-2H2O)+", "(M+H)+"),
  stringsAsFactors = FALSE
)

# Remove impossible annotations
cleaned_results <- remove_impossible_annotations(match_result)
print(cleaned_results)
}

}
