% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_read_write_functions.R
\name{read_msp_gnps}
\alias{read_msp_gnps}
\title{---------------------------------------------------------------------------
Read MSP Data from GNPS}
\usage{
read_msp_gnps(file, threads = 5)
}
\arguments{
\item{file}{A character vector specifying the file path(s) to the MSP file(s).}

\item{threads}{Numeric, the number of threads to use for parallel processing. Defaults to `5`.}
}
\value{
A list where each element contains:
\item{info}{A data frame with metadata for each spectrum (typically containing identifiers like m/z, intensity, and other descriptors).}
\item{spec}{A data frame with the `mz` (mass-to-charge ratio) and `intensity` values of the MS2 spectrum.}
}
\description{
This function reads and processes MSP data files from the GNPS (Global Natural Products Social Molecular Networking) database. The function extracts both metadata (such as m/z and intensity) and the spectrum information for each entry. The MSP data is returned as a list of parsed entries.
}
\details{
This function is designed to handle MSP data from the GNPS database. The data is organized into a structured list, where each list element corresponds to a spectrum with associated metadata and peak information.
}
\examples{
\dontrun{
# Read MSP data from GNPS
msp_data <- read_msp_gnps(file = "path/to/gnps_data.msp")
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
