% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_read_write_functions.R
\name{read_mgf_experiment}
\alias{read_mgf_experiment}
\title{Read MGF Data from Experimental Files}
\usage{
read_mgf_experiment(file, threads = 3)
}
\arguments{
\item{file}{A character vector containing file paths to the MGF files.}

\item{threads}{Numeric, the number of threads to use for parallel processing. Defaults to `3`.}
}
\value{
A list where each element contains the MS2 spectra and related metadata for each entry in the MGF file. Each entry includes:
\item{info}{A data frame with metadata (such as m/z, retention time, etc.) for each spectrum.}
\item{spec}{A data frame containing the `mz` and `intensity` values of the MS2 spectrum.}
}
\description{
This function reads Mass Spectrometry (MS) data in MGF format from experimental files, extracts the MS2 spectra, and returns them in a structured format.
}
\details{
The function parses MGF files from experimental data, extracting both the metadata and the MS2 spectra, and organizes the data into a structured format for further analysis. Parallel processing is supported to improve efficiency when handling large datasets.
}
\examples{
\dontrun{
# Read MGF data from experimental files
mgf_data <- read_mgf_experiment(file = c("path/to/mgf1.mgf", "path/to/mgf2.mgf"))
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
